DECLARE FUNCTION GetYesNo% (question$, bordercolour%, backcolour%)
DEFINT A-Z
DECLARE FUNCTION Shift% ()
DECLARE SUB ShowEndScreen ()
DECLARE SUB ShowHiScores (new%)
DECLARE FUNCTION HiResTimer& ()
DECLARE SUB ShiftSet (SetReset%)
DECLARE SUB TileIt ()
DECLARE SUB FadeIn (FileName$)
DECLARE SUB FadeInFadeOut (colornum%, r1%, g1%, b1%, r2%, g2%, b2%)
DECLARE SUB Move3DStars ()
DECLARE SUB ClearKeyBuff ()
DECLARE SUB CFontCEx (text$, trans%)
DECLARE SUB CFontC (text$, trans%)
DECLARE SUB SetAll (r%, g%, B%)
DECLARE SUB FadeToVal (r%, g%, B%)
DECLARE SUB DrawCursor (x%, y%, colour%)
DECLARE FUNCTION ScoreInput$ (limit%)
DECLARE SUB WaitForUser ()
DECLARE FUNCTION GetControl% ()
DECLARE SUB LoseGame ()
DECLARE SUB WinGame ()
DECLARE FUNCTION NumLevels% ()
DECLARE SUB LoadLev (levelnum%, sspd%, sbspd%, sbint%, ahost%, ax%, ay%, abspd%, amaxint%, aminint%, aspd%, atype%)
DECLARE SUB MenuHelp ()
DECLARE SUB MenuAbout ()
DECLARE SUB MenuOptions ()
DECLARE SUB Menu ()
DECLARE FUNCTION WhichControl% ()
DECLARE FUNCTION CentX% (what$)
DECLARE SUB Intro ()
DECLARE SUB NumLock (OnOff%)
DECLARE SUB ExPrint (x%, y%, text$, trans%, speed!)
DECLARE SUB Pause2 ()
DECLARE SUB Pause ()
DECLARE SUB TheGame ()
DECLARE FUNCTION GetDimsize% (x%, y%)
DECLARE SUB UDShields (what%)
DECLARE SUB CFont (x%, y%, text$, trans%)
DECLARE SUB UpdateScore (howmany, total)
DECLARE SUB Ending ()
DECLARE SUB MoveStars ()
DECLARE SUB loadpal (FileName$)
DECLARE SUB PrintC (row%, tocenter$)

DECLARE FUNCTION ENDSCREEN&
DECLARE FUNCTION ENDSCREENWidth%
DECLARE FUNCTION ENDSCREENDepth%
DECLARE FUNCTION ENDSCREENLength%

COMMON SHARED numstars%, stars%(), numlayers%, inc%(), starcol%()
COMMON SHARED count%, cu%, delay!, startop%, sw%, sh%
COMMON SHARED Shipstate, level, cheat, quick, gamestatus, Cs&
COMMON SHARED control, havemouse, status, MaxLev

level = 1

IF Shift THEN quick = 1 ELSE quick = 0
CONST KeyBoard = 1, mouse = 2

RANDOMIZE TIMER

OPTION BASE 1

CONST trans = 1, opaque = 0
CONST true = -1, false = 0

LOCATE , , 1, 3, 4
COLOR 15
PRINT "Welcome to Space Invaders v1.0"
COLOR 7
PRINT "Detecting mouse...";
CALL mmcheck(m%) 'check mouse
SELECT CASE m%
     CASE 0
          PRINT "Mouse not detected"
          havemouse = 0
     CASE 1
          PRINT "1 button mouse detected"
     CASE 2
          PRINT "2 button mouse detected"
     CASE 3
          PRINT "3 button mouse detected"
END SELECT
IF m% > 0 THEN havemouse = 1
MaxLev = NumLevels    'find out how many levels
IF quick THEN SCREEN 13: GOTO JustStartTheDamnGame
'MaxLev = 1
ShiftSet 0
NumLock 0      'turn off numlock

FadeToVal 0, 0, 0
SCREEN 13

SetAll 0, 0, 0
Intro          'run intro (title screen, etc.)

JustStartTheDamnGame:

Menu

END

FUNCTION CentX (what$)
CentX = (320 - (LEN(what$) * 8)) / 2
END FUNCTION

SUB DrawCursor (x, y, colour) STATIC
LINE (x, y)-(x + 7, y), colour
END SUB

SUB Ending
IF quick THEN END

FadeToVal 63, 63, 63

CLS

FadeToVal 0, 0, 0
SCREEN 0
WIDTH 80
SetAll 0, 0, 0

ShowEndScreen

FadeIn "default.pal"
LOCATE 23, 1
ShiftSet 1
END

END SUB

FUNCTION GetControl%
DIM byte AS STRING * 1
cfgfile = FREEFILE
OPEN "si.cfg" FOR BINARY AS #cfgfile
IF LOF(1) = 0 THEN  'if cfg file doesn't exist then
     byte = CHR$(1)
     PUT #cfgfile, 1, byte  'make one with default setting
     GOTO closing
END IF
GET #cfgfile, 1, byte
closing:
CLOSE #cfgfile
GetControl = ASC(byte)
END FUNCTION

FUNCTION GetYesNo (question$, bordercolour, backcolour)
question2$ = question$
maxlinelength = 16
FOR i = maxlinelength TO 1
     IF MID$(question2$, i, 1) = " " THEN
          numlines = numlines + 1
     END IF
NEXT i
END FUNCTION

FUNCTION HiResTimer&
DEF SEG = 0
HiResTimer = CVL(CHR$(255 - INP(&H40)) + CHR$(PEEK(&H46C)) + CHR$(PEEK(&H46D)) + CHR$(PEEK(&H46E)))
DEF SEG
END FUNCTION

SUB Intro

SetAll 0, 0, 0

DEF SEG = &HA000               'load splash screen
BLOAD "splash.gax", 0
DEF SEG
'***
Start! = TIMER                 'add a 2 second delay before fading in
DO WHILE TIMER - Start! <= 1: LOOP
'***

FadeIn "splash.pal"

WaitForUser

FadeToVal 0, 0, 0


END SUB

SUB LoadLev (levelnum, sspd, sbspd, sbint, ahost, ax, ay, abspd, amaxint, aminint, aspd, atype)
LevelSize = 12
levfile = FREEFILE
DIM tc AS STRING * 1
offs = LevelSize * levelnum + 1 - LevelSize
LevelFile$ = "levels.dat"
OPEN LevelFile$ FOR BINARY AS #levfile
GET #levfile, offs + 1, tc
sspd = ASC(tc)
GET #levfile, offs + 2, tc
sbspd = ASC(tc)
GET #levfile, offs + 3, tc
sbint = ASC(tc)
GET #levfile, offs + 4, tc
ahost = ASC(tc)

GET #levfile, offs + 5, tc
ax = ASC(tc)
GET #levfile, offs + 6, tc
ay = ASC(tc)
GET #levfile, offs + 7, tc
abspd = ASC(tc)
GET #levfile, offs + 8, tc
amaxint = ASC(tc)
GET #levfile, offs + 9, tc
aminint = ASC(tc)
GET #levfile, offs + 10, tc
aspd = ASC(tc)
GET #levfile, offs + 11, tc
atype = ASC(tc)

CLOSE #levfile
END SUB

SUB LoadLevel (levelnum)
'Unfinished sub that will load level information for the level you specify.
CONST LevelBytes = 20                 'how many bytes per level in the file
OPEN "levels.dat" FOR BINARY AS #1    'open level data file
CLOSE #1                              'close data file
END SUB

SUB LoseGame
CLS
FadeToVal 0, 0, 0
DEF SEG = &HA000
BLOAD "losing.gax", 0
DEF SEG
FadeIn "losing.pal"
CFontCEx "Blown to bits!", 1
WaitForUser
FadeToVal 0, 0, 0
END SUB

SUB Menu STATIC

DIM lf AS LONG

control = GetControl
DIM menuitems(6)
menuitems(1) = 26
dist = 25

FOR i = 2 TO 6
     menuitems(i) = menuitems(1) + (i * dist - dist)
NEXT i

DIM stp(2)

GOSUB DrawMenu

Move3DStars
delay! = .02


'MenuTop:

OPEN "ma.anm" FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 7, steps
GET #1, lf - 5, dimsize
GET #1, lf - 3, sizex
GET #1, lf - 1, sizey
CLOSE #1

DIM x(2)
xc = 75
x(1) = xc - sizex / 2
x(2) = 319 - xc - sizex / 2

REDIM ma(dimsize * steps + dimsize)
DEF SEG = VARSEG(ma(1))
BLOAD "ma.anm", VARPTR(ma(1))
DEF SEG
'DIM macover(dimsize)
'macover(1) = sizex * 8
'macover(2) = sizey
masteps = 9
item = 1
maxitem = 6
stp(1) = 1
stp(2) = 1

MenuTop:

REDIM macover(dimsize)
macover(1) = sizex * 8
macover(2) = sizey
ClearKeyBuff
Start! = TIMER
ticks = 2

CALL mmsetrange(0, 0, 0, ty)
CALL mmsetloc(0, 0)

DO
     waitticks = waitticks + 1
     IF waitticks >= ticks THEN
          waitticks = 0
          FOR i = 1 TO 2
               stp(i) = stp(i) + 1
               IF stp(i) > masteps THEN stp(i) = 1
          NEXT i
     END IF
     olditem = item
     a$ = INKEY$
     SELECT CASE a$
          CASE CHR$(0) + CHR$(72) 'up
               item = item - 1
               IF item < 1 THEN item = maxitem
               IF havemouse THEN
                    newy = (item - 1) * (ty / (maxitem + 1))
                    y = newy
                    CALL mmsetloc(0, newy)
               END IF
          CASE CHR$(0) + CHR$(80) 'down
               item = item + 1
               IF item > maxitem THEN item = 1
               IF havemouse THEN
                    newy = (item - 1) * (ty / (maxitem + 1))
                    y = newy
                    CALL mmsetloc(0, newy)
               END IF
          CASE "l", "L"
               cheatlevel$ = ""
          CASE "0" TO "9"
               IF LEN(cheatlevel$) < 2 THEN
                    cheatlevel$ = cheatlevel$ + a$
                    IF LEN(cheatlevel$) >= 2 THEN BEEP: BEEP
               END IF
          CASE CHR$(13)     'enter
               EXIT DO
     END SELECT
     IF havemouse THEN
          oldy = y
          CALL mmgetloc(x, y)
          IF y <> oldy THEN item = y * (maxitem - 1) / ty + 1
          CALL mmbutton(leftb, rightb)
          IF leftb THEN EXIT DO
     END IF
     WAIT &H3DA, 8, 8
     WAIT &H3DA, 8
     Move3DStars
     IF olditem <> item THEN
          FOR i = 1 TO 2
               PUT (x(i), menuitems(olditem)), macover, PSET
          NEXT i
     END IF
     FOR i = 1 TO 2
          PUT (x(i), menuitems(item)), ma(stp(i) * dimsize + 1), PSET
     NEXT i
LOOP

SELECT CASE item
     CASE 1
          IF VAL(cheatlevel$) THEN level = VAL(cheatlevel$) ELSE level = 1
          'IF Shift THEN level = MaxLev ELSE level = 1
          FadeToVal 0, 0, 0
newgame:
          CLS
          FadeToVal 0, 0, 0
          IF LEN(cheatlevel$) THEN
               CFontC "Cheating to wave" + STR$(level), 0
          ELSE
               CFontC "Wave" + STR$(level), 0
          END IF
          FadeIn "pal1.pal"
          FadeToVal 0, 0, 0
          TheGame
          SELECT CASE gamestatus
               CASE 10
                    IF level < MaxLev THEN
                         level = level + 1
                         GOTO newgame
                    ELSE
                         WinGame
                         ShowHiScores 1
                         GOSUB DrawMenu
                         GOTO MenuTop
                    END IF
               CASE 8, 9
                    LoseGame
                    ShowHiScores 1
                    GOSUB DrawMenu
                    GOTO MenuTop
               CASE 99
                    FadeToVal 0, 0, 0
                    CLS
                    ShowHiScores 0
                    GOSUB DrawMenu
                    GOTO MenuTop
               CASE ELSE
                    SCREEN 0
                    WIDTH 80
                    FOR i = 440 TO 880
                         SOUND i, .1
                    NEXT i
                    PRINT "Kind of screwed up here..."
                    END
          END SELECT
     CASE 2
          FadeToVal 0, 0, 0
          MenuOptions
          GOSUB DrawMenu
          GOTO MenuTop
     CASE 3
          FadeToVal 0, 0, 0
          CLS
          ShowHiScores 0
          CLS
          GOSUB DrawMenu
          GOTO MenuTop
     CASE 4
          FadeToVal 0, 0, 0
          MenuAbout
          GOSUB DrawMenu
          GOTO MenuTop
     CASE 5
          FadeToVal 0, 0, 0
          MenuHelp
          GOSUB DrawMenu
          GOTO MenuTop
     CASE 6
          Ending
END SELECT
EXIT SUB

DrawMenu:
er = 2
ClearKeyBuff
OPEN "menu.gax" FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 5, tdim
GET #1, lf - 3, tx
GET #1, lf - 1, ty
CLOSE #1
DIM menupic(tdim)
DEF SEG = VARSEG(menupic(1))
BLOAD "menu.gax", VARPTR(menupic(1))
DEF SEG
CLS
PUT ((319 - tx) / 2, (199 - ty) / 2), menupic, PSET
ERASE menupic
Move3DStars
FadeIn "menu.pal"
RETURN

END SUB

SUB MenuAbout
CLS
DEF SEG = &HA000         'load about screen
BLOAD "about.gax", 0
DEF SEG
FadeIn "about.pal"    'load credit palette
WaitForUser
'WHILE INKEY$ = "": WEND
FadeToVal 0, 0, 0
CLS
END SUB

SUB MenuHelp
CLS
TileIt
title$ = "help.gax"
titlemask$ = "helpm.gax"

anim$ = "sa.anm"
animmask$ = "sam.anm"


cy = 5
FOR i = 1 TO 2
     IF i = 1 THEN
          FileName$ = titlemask$
     ELSE FileName$ = title$
     END IF
     OPEN FileName$ FOR BINARY AS #1
     lf = LOF(1)
     GET #1, lf - 5, odim
     GET #1, lf - 3, ox
     GET #1, lf - 1, oy
     CLOSE #1
     cx = (319 - ox) / 2
     REDIM tmask(odim)
     DEF SEG = VARSEG(tmask(1))
     BLOAD FileName$, VARPTR(tmask(1))
     DEF SEG
     IF i = 1 THEN
          PUT (cx, cy), tmask, AND
     ELSE PUT (cx, cy), tmask, OR
     END IF
NEXT i
'CFontC "No help is available at this moment", 1
linespace = 10
indent = 20
y = 70
CFont indent - 10, y, "Keyboard commands:", 1
y = y + linespace + 2
CFont indent, y, "[Space] - fire", 1
y = y + linespace
CFont indent, y, "[Left] and [Right] arrows - move ship", 1
y = y + linespace
CFont indent, y, "[P] - pauses the game", 1
y = y + linespace
CFont indent, y, "[Esc] - exits the game", 1
y = y + linespace + 2
CFont indent - 10, y, "Mouse:", 1
y = y + linespace + 2
CFont indent, y, "[Left mouse button] - fire", 1
y = y + linespace
CFont indent, y, "Moving the mouse left and right", 1
y = y + linespace
CFont indent, y, "  moves the ship. (Really?)", 1
y = y + linespace

FadeIn "helppal.pal"
WaitForUser
'WHILE INKEY$ = "": WEND
FadeToVal 0, 0, 0
END SUB

SUB MenuOptions
CLS
texture$ = "texture.gax"

TileIt


title$ = "options.gax"
titlemask$ = "optionsm.gax"
what$ = "Choose your controller:"
c1$ = "Keyboard"
c2$ = "Mouse"
cy = 80
y1 = cy + 20
y2 = cy + 40
py1 = y1 - 2
py2 = y2 - 2
ppy1 = y1 + 9
ppy2 = y2 + 9
lx1 = 70
lx2 = 250
DIM olditem(GetDimsize(lx2 - lx1 + 1, 12))
CFont CentX(what$), cy, what$, 1
CFont CentX(c1$), y1, c1$, 1
CFont CentX(c2$), y2, c2$, 1
GET (lx1, py1)-(lx2, ppy1), olditem


cy = 5
FOR i = 1 TO 2
     IF i = 1 THEN
          FileName$ = titlemask$
     ELSE FileName$ = title$
     END IF
     OPEN FileName$ FOR BINARY AS #1
     lf = LOF(1)
     GET #1, lf - 5, odim
     GET #1, lf - 3, ox
     GET #1, lf - 1, oy
     CLOSE #1
     cx = (319 - ox) / 2
     REDIM tmask(odim)
     DEF SEG = VARSEG(tmask(1))
     BLOAD FileName$, VARPTR(tmask(1))
     DEF SEG
     IF i = 1 THEN
          PUT (cx, cy), tmask, AND
     ELSE PUT (cx, cy), tmask, OR
     END IF
NEXT i
FadeIn "helppal.pal"
oldchoice = 1
ClearKeyBuff
LINE (lx1, py1)-(lx2, ppy1), 240, B
choice = 1
minchoice = 1
maxchoice = 2
IF havemouse THEN
     CALL mmsetloc(0, 0)
     CALL mmsetrange(0, 1)
END IF
DIM a AS STRING * 1
DO
     j$ = INKEY$
     oldchoice = choice
     SELECT CASE j$
          CASE CHR$(0) + CHR$(72)  'up
               choice = choice - 1
               IF choice < minchoice THEN choice = maxchoice
               IF havemouse THEN
                    IF choice = 1 THEN
                         CALL mmsetloc(0, 0)
                    ELSE CALL mmsetloc(0, 1)
                    END IF
               END IF
          CASE CHR$(0) + CHR$(80)  'down
               choice = choice + 1
               IF choice > maxchoice THEN choice = minchoice
               IF havemouse THEN
                    IF choice = 1 THEN
                         CALL mmsetloc(0, 0)
                    ELSE CALL mmsetloc(0, 1)
                    END IF
               END IF
          CASE CHR$(13)            'enter
               control = choice
               cfgfile = FREEFILE
               OPEN "si.cfg" FOR BINARY AS #cfgfile
               a = CHR$(choice)
               PUT #cfgfile, 1, a
               CLOSE #cfgfile
               FadeToVal 0, 0, 0
               CLS
               EXIT DO
               'GOTO lastline
          CASE CHR$(27)            'esc
               FadeToVal 0, 0, 0
               CLS
               EXIT DO
               'GOTO lastline
     END SELECT
     IF havemouse THEN
          CALL mmgetloc(x, y)
          IF y = 0 THEN choice = 1 ELSE choice = 2
          CALL mmbutton(leftb, rightb)
          IF leftb THEN
               control = choice
               cfgfile = FREEFILE
               OPEN "si.cfg" FOR BINARY AS #cfgfile
               a = CHR$(choice)
               PUT #cfgfile, 1, a
               CLOSE #cfgfile
               FadeToVal 0, 0, 0
               CLS
               EXIT DO
               'GOTO lastline
          END IF
     END IF
     IF choice <> oldchoice THEN
          SELECT CASE choice
               CASE 1
                    PUT (lx1, py2), olditem, PSET
                    GET (lx1, py1)-(lx2, ppy1), olditem
                    LINE (lx1, py1)-(lx2, ppy1), 240, B
               CASE 2
                    PUT (lx1, py1), olditem, PSET
                    GET (lx1, py2)-(lx2, ppy2), olditem
                    LINE (lx1, py2)-(lx2, ppy2), 240, B
          END SELECT
     END IF
     WAIT &H3DA, 8, 8
     WAIT &H3DA, 8
     FadeInFadeOut 240, 21, 0, 0, 63, 0, 0
LOOP
'lastline:
'FadeToVal 0, 0, 0
CLS
END SUB

SUB MoveStars STATIC
IF loaded = 0 THEN
     loaded = 1
     numstars% = 70  'number of stars to be on screen
     numlayers% = 4   'how many layers of stars
     DIM stars%(numstars%, 4)
     DIM inc%(numlayers% + 10)

     FOR l% = 1 TO numlayers%
          inc%(l%) = (numlayers% - l%)
     NEXT l%

     DIM starcol%(numlayers%)
     FOR k% = numlayers% TO 1 STEP -1
          IF mode% <> 12 THEN
               starcol%(k%) = 255 - (k% * 3)
          ELSE starcol%(k%) = 255
          END IF
     NEXT k%

     FOR i% = 1 TO numstars%
          stars%(i%, 1) = INT(RND(1) * sw%)
          stars%(i%, 2) = INT(RND(1) * (sh% - startop) + startop)
          stars%(i%, 3) = INT(RND(1) * numlayers%)
          IF stars%(i%, 3) <= 0 THEN stars%(i%, 3) = 1
          IF stars%(i%, 3) >= numlayers% THEN stars%(i%, 3) = numlayers%
          stars%(i%, 4) = starcol%(stars%(i%, 3))
          PSET (stars%(i%, 1), stars%(i%, 2)), stars%(i%, 4)   'draw star
     NEXT i%
     DIM ns AS STRING * 1
END IF

DEF SEG = &HA000
FOR j% = 1 TO numstars%
     oldcol% = POINT(stars%(j%, 1), stars%(j%, 2))
     'IF (oldcol% = starcol(stars%(j%, 3)) AND oldcol% > 241) THEN
     IF oldcol% = starcol(stars%(j%, 3)) THEN
          'POKE (stars%(j%, 1) + 320& * stars%(j%, 2)), 0
          PSET (stars%(j%, 1), stars%(j%, 2)), 0 'erase old star
     'ELSE
          'PSET (stars%(j%, 1), stars%(j%, 2)), oldcol%
     END IF
     IF count% >= stars%(j%, 3) THEN
          'stars%(j%, 1) = stars%(j%, 1) + 1
          stars%(j%, 2) = stars%(j%, 2) + 1
     END IF
     'IF stars%(j%, 1) <= 0 THEN stars%(j%, 1) = sw%
     'IF stars%(j%, 1) > sw% THEN stars%(j%, 1) = 0
     IF stars%(j%, 2) <= startop% THEN stars%(j%, 2) = sh% + startop%
     IF stars%(j%, 2) > sh% THEN
          stars%(j%, 2) = startop%
          stars%(j%, 1) = RND * sw
          stars(j, 3) = RND * (numlayers - 1) + 1
     END IF
     oldcol% = POINT(stars%(j%, 1), stars%(j%, 2))
     IF oldcol% = 0 OR (oldcol > 241 AND oldcol < stars%(j%, 3)) THEN
          PSET (stars%(j%, 1), stars%(j%, 2)), starcol(stars(j, 3))'draw new star
          'ns = CHR$(starcol(stars(j, 3)))
          'POKE (stars%(j%, 1) + 320& * stars%(j%, 2)), ASC(ns)
     'ELSE
          'PSET (stars%(j%, 1), stars%(j%, 2)), oldcol%
          'ns = CHR$(oldcol%)
          'POKE (stars%(j%, 1) + 320& * stars%(j%, 2)), ASC(ns)
     END IF
NEXT j%
DEF SEG
count% = count% - 1
IF count% <= 0 THEN count% = numlayers%
END SUB

FUNCTION NumLevels
l = FREEFILE
DIM mop AS STRING * 1
OPEN "levels.dat" FOR BINARY AS #l
GET #l, 1, mop
CLOSE #l
NumLevels = ASC(mop)
END FUNCTION

SUB NumLock (OnOff)
DEF SEG = 0
set = PEEK(&H417)
SELECT CASE OnOff
     CASE 0                          'turn off numlock
          IF (set AND 32) = 32 THEN
               set = set XOR 32
               POKE &H417, set
          END IF
     CASE IS <> 0                    'turn on numlock
          IF (set AND 32) = 0 THEN
               set = set + 32
               POKE &H417, set
          END IF
END SELECT
DEF SEG
END SUB

SUB Pause2
'This sub pauses the game and displays "Game Paused" in center of screen
cap = 1
sx = 319
sy = 199
paused$ = "Game Paused"
pwid = LEN(paused$) * 8
ph = 8
xl = (sx - pwid) / 2
yl = (sy - ph) / 2

DIM back(GetDimsize(pwid + 1, ph + 1))  'make array for background

GET (xl, yl)-(xl + pwid, yl + ph), back 'get background behind letters

CFont xl, yl, paused$, 1                'print message

ig = 1

DEF SEG = 0
dipfile = 0
ffile = 0
DO WHILE l = 0 AND r = 0 AND j$ = ""
     j$ = INKEY$
     IF havemouse THEN CALL mmbutton(l, r)                'check mouse buttons
     Start! = TIMER
     DO UNTIL TIMER - Start! >= .1
     LOOP
     WAIT &H3DA, 8
     dip = dip + ig
     IF (PEEK(&H417) AND 12) = 12 AND cap = 1 THEN  'press ctrl+alt to capture screen
          PUT (xl, yl), back, PSET      'erase message
          capfile = FREEFILE
          DO
               dipfile = dipfile + 1
               IF dipfile >= 32000 THEN GOTO nocap
               capfile$ = "si" + LTRIM$(RTRIM$(STR$(dipfile))) + ".cap"
               OPEN capfile$ FOR BINARY AS #capfile
               IF LOF(capfile) = 0 THEN
                    CLOSE #capfile
                    EXIT DO
               END IF
               CLOSE #capfile
          LOOP
          DEF SEG = &HA000
          BSAVE capfile$, 0, 64000
          BEEP
          DEF SEG = 0
     END IF
nocap:
     IF dip >= 10 THEN
          ig = -ig
          PUT (xl, yl), back, PSET      'erase message
     ELSEIF dip <= 0 THEN
          ig = -ig
          CFont xl, yl, paused$, trans  'print message
     END IF
LOOP

PUT (xl, yl), back, PSET                'erase message

DEF SEG

END SUB

FUNCTION ScoreInput$ (limit)

'BoxX = 176
'BoxY = 76



InputFile$ = "input.gax"
ifile = FREEFILE
OPEN InputFile$ FOR BINARY AS #ifile
lf = LOF(ifile)
GET #ifile, lf - 5, idim
GET #ifile, lf - 3, BoxX
GET #ifile, lf - 1, BoxY
CLOSE #ifile

DIM back(GetDimsize(BoxX + 3, BoxY))

tx = (319 - BoxX) \ 2
ty = (199 - BoxY) \ 2

DIM InputTexture(idim)
DEF SEG = VARSEG(InputTexture(1))
BLOAD InputFile$, VARPTR(InputTexture(1))
DEF SEG

GET (tx, ty)-(tx + BoxX + 1, ty + BoxY - 1), back
PUT (tx + 1, ty + 1), InputTexture, PSET
LINE (tx, ty)-(tx + BoxX + 1, ty + BoxY + 1), 100, B
ERASE InputTexture

'LINE (tx + 1, ty + 1)-(tx + BoxX - 2, ty + BoxY - 2), 204, BF

bordX = limit * 8
InpX = (319 - bordX) \ 2
InpY = 120
bordersize = 3

cy = ty + 4
c$ = "Congratulations!"
CFont CentX(c$), cy, c$, 1
cy = cy + 13
c$ = "You have reached a"
CFont CentX(c$), cy, c$, 1
c$ = "high score!"
cy = cy + 13
CFont CentX(c$), cy, c$, 1
cy = cy + 13
c$ = "Enter you name:"
CFont CentX(c$), cy, c$, 1

bcolour = 244
LINE (InpX - bordersize, InpY - bordersize)-(InpX + bordX + bordersize - 1, InpY + 8 + bordersize - 1), 100, B
LINE (InpX - bordersize + 1, InpY - bordersize + 1)-(InpX + bordX + bordersize - 2, InpY + 8 + bordersize - 2), bcolour, BF

DIM response AS STRING

CurX = InpX
Cursory = InpY + 7
maxlen = limit
cursorcol = 240
DrawCursor CurX, Cursory, cursorcol
DO
     WAIT &H3DA, 8, 8
     WAIT &H3DA, 8
     FadeInFadeOut 240, 21, 0, 0, 63, 0, 0
     j$ = INKEY$
     keyval = 0
     IF LEN(j$) THEN keyval = ASC(LEFT$(j$, 1))
     SELECT CASE keyval
          CASE 13
               ScoreInput = response
               EXIT DO
          CASE 8
               IF LEN(response) > 0 THEN
                    LINE (CurX - 8, InpY)-(CurX, InpY + 7), bcolour, BF
                    IF CurX + 8 > InpX + bordX + bordersize - 2 THEN
                         DrawCursor CurX - 8, Cursory, bcolour
                    ELSE
                         DrawCursor CurX, Cursory, bcolour
                    END IF
                    CurX = CurX - 8
                    DrawCursor CurX, Cursory, cursorcol 'draw new cursor
                    response = LEFT$(response, LEN(response) - 1)
               END IF
          CASE 32 TO 122
               IF keyval > 0 THEN
                    IF LEN(response) < maxlen THEN
                         response = response + j$
                         'PRINT j$;
                         DrawCursor CurX, Cursory, bcolour
                         CFont CurX, InpY, j$, 1
                         CurX = CurX + 8
                         IF CurX + 8 > InpX + bordX + bordersize - 2 THEN
                              DrawCursor CurX - 8, Cursory, cursorcol
                         ELSE
                              DrawCursor CurX, Cursory, cursorcol
                         END IF
                    END IF
               END IF
     END SELECT
LOOP

PUT (tx, ty), back, PSET

END FUNCTION

FUNCTION Shift%
DEF SEG = 0
IF PEEK(&H417) AND 3 THEN Shift = 1 ELSE Shift = 0
DEF SEG
END FUNCTION

SUB ShowEndScreen
CLS
CALL uncrunch(ENDSCREEN&, 0)

END SUB

SUB ShowHiScores (new)
HiScoreFile$ = "hiscores.dat"      'high score data file
titlemask$ = "hiscorem.gax"        'filenames - mask
title$ = "hiscore.gax"             '          - title graphic
sbx = 184
sby = 100
putbackx = 72
putbacky = 70
DIM ScoreBack(GetDimsize(sbx, sby))

'FadeToVal 0, 0, 0
'SetAll 0, 0, 0    'set all palette colours to r=0,g=0,b=0

TileIt        'make tiled background

cy = 10          'draw title
FOR i = 1 TO 2
     IF i = 1 THEN
          FileName$ = titlemask$
     ELSE FileName$ = title$
     END IF
     tfile = FREEFILE
     OPEN FileName$ FOR BINARY AS #tfile
     lf = LOF(tfile)
     GET #tfile, lf - 5, odim
     GET #tfile, lf - 3, ox
     GET #tfile, lf - 1, oy
     CLOSE #tfile
     cx = (319 - ox) / 2
     REDIM tmask(odim)
     DEF SEG = VARSEG(tmask(1))
     BLOAD FileName$, VARPTR(tmask(1))
     DEF SEG
     IF i = 1 THEN
          PUT (cx, cy), tmask, AND
     ELSE PUT (cx, cy), tmask, OR
     END IF
NEXT i
ERASE tmask


ClearScores$ = "Press [C] to clear scores"
CFont CentX(ClearScores$), 191, ClearScores$, 1


DIM Famous(1 TO 10) AS STRING * 15      'array that hold high scores
DIM Scores(1 TO 10) AS INTEGER

GOSUB LoadScores
GET (putbackx, putbacky)-(putbackx + sbx - 1, putbacky + sby - 1), ScoreBack
empty$ = "Empty"

SELECT CASE new
     CASE 0
          GOSUB PrintScores
          FadeIn "helppal.pal"
     CASE 1
          GOSUB PrintScores
          myscore = level
          'myscore = 13
          FOR i = 1 TO 10
               IF myscore >= Scores(i) AND myscore <= 255 AND myscore >= 1 THEN
                    FOR j = 10 TO i + 1 STEP -1
                         Famous(j) = Famous(j - 1)
                         Scores(j) = Scores(j - 1)
                    NEXT j
                    oldone = i
                    Scores(oldone) = myscore
                    FadeIn "helppal.pal"
                    newname$ = ScoreInput(15)
                    IF LEN(newname$) > 0 THEN
                         Famous(oldone) = newname$ + SPACE$(15 - LEN(newname$))
                    ELSE
                         anon$ = "Anonymous"
                         Famous(oldone) = anon$ + SPACE$(15 - LEN(anon$))
                    END IF
                    GOSUB SaveScores
                    GOSUB LoadScores
                    PUT (putbackx, putbacky), ScoreBack, PSET
                    GOSUB PrintScores
                    EXIT FOR
               END IF
          NEXT i
END SELECT

ClearKeyBuff
IF havemouse THEN
     WHILE p = 0 AND l = 0 AND r = 0
          CALL mmbutton(l, r)
          a$ = ""
          a$ = INKEY$
          IF UCASE$(a$) = "C" THEN
               GOSUB EraseScores
               GOSUB LoadScores
               GOSUB PrintScores
          ELSEIF LEN(a$) <> 0 THEN p = 1
          END IF
     WEND
ELSE
     WHILE p = 0
          a$ = ""
          a$ = INKEY$
          IF UCASE$(a$) = "C" THEN
               IF GetYesNo("Are you sure you want to clear the high scores?", &HF0, 0) THEN
                    GOSUB EraseScores
                    GOSUB LoadScores
                    GOSUB PrintScores
               END IF
          ELSEIF LEN(a$) <> 0 OR l <> 0 OR r <> 0 THEN p = 1
          END IF
     WEND
END IF

FadeToVal 0, 0, 0
CLS
ERASE ScoreBack

EXIT SUB

PrintScores:
     PUT (putbackx, putbacky), ScoreBack, PSET
     FOR i = 1 TO 10
          Number$ = LTRIM$(RTRIM$(STR$(i)))
          Number$ = SPACE$(2 - LEN(Number$)) + Number$
          TheScore$ = LTRIM$(RTRIM$(STR$(Scores(i))))
          TheScore$ = SPACE$(3 - LEN(TheScore$)) + TheScore$
          ScoreLine$ = Number$ + " " + Famous$(i) + "  " + TheScore$
          CFont CentX(ScoreLine$), (i * 10) + 60, ScoreLine$, 1
     NEXT i
RETURN

LoadScores:
     scorefile = FREEFILE            'load high scores out of file
     OPEN HiScoreFile$ FOR INPUT AS #scorefile
     FOR u = 1 TO 10
          INPUT #scorefile, Famous$(u), score$
          IF LEN(score$) THEN Scores(u) = ASC(score$) ELSE Scores(u) = 0
     NEXT u
     CLOSE #scorefile
RETURN

EraseScores:
     savefile = FREEFILE
     OPEN HiScoreFile$ FOR OUTPUT AS #savefile
     'anon$ = "Empty"
     'IF LEN(anon$) > 15 THEN anon$ = LEFT$(anon$, 15) ELSE anon$ = anon$ + SPACE$(15 - LEN(anon$))
     FOR u = 1 TO 10
          WRITE #savefile, empty$ + SPACE$(15 - LEN(empty$)), CHR$(0)
     NEXT u
     CLOSE #savefile
RETURN

SaveScores:
     savefile = FREEFILE
     OPEN HiScoreFile$ FOR OUTPUT AS #savefile
     FOR j = 1 TO 10
          WRITE #savefile, Famous$(j), CHR$(Scores(j))
     NEXT j
     CLOSE #savefile
RETURN

END SUB

'This is the main sub that runs the whole game.
SUB TheGame
CLS
Shipstate = 0
sh = 200
sw = 320


SoundEffects = 0
atop% = 12        'top of where aliens go
startop% = 12     'top of where stars are
bottom% = 0       'bottom row
aexplospeed = 3
shipexplospeed = 4
ForHit = 5 'how long to display hit ship picture when ship is hit
HitState = 0

'load level information
LoadLev level, shipspeed%, bullspeed, bullint, TheyAreHostile, aliensx, aliensy, abullspeed, amaxint, aminint, irt, atype
incx = irt
IncY = irt

LastLev = 0
SELECT CASE atype
     CASE 1
          alienfile1$ = "alien1.anm"
          abulletfile$ = "abullet1.gax"
     CASE 2
          alienfile1$ = "alien2.anm"
          abulletfile$ = "abullet2.gax"
     CASE 3
          alienfile1$ = "alien3.anm"
          abulletfile$ = "abullet3.gax"
     CASE 4
          alienfile1$ = "boss.anm"
          abulletfile$ = "bbullet.gax"
          LastLev = 1
          BossHits = 4
     CASE ELSE
          alienfile1$ = "alien1.anm"
          abulletfile$ = "abullet1.gax"
END SELECT

DIM BossHitTimes(aliensx, aliensy) AS INTEGER

maxbull = (sh / bullint)
amaxbull = sh / aminint
ainterval = RND * (amaxint - aminint) + aminint

totalaliens = aliensx * aliensy  'total number of aliens
mincol% = 10
minrow% = 10
col% = mincol% + 1
row% = atop%

HitAliens = totalaliens
ActiveAliens = totalaliens
shipr = 28
shiprow = sh - shipr
        
DIM ashotloc(3, amaxbull)
DIM ashots(amaxbull)
DIM aoldshot(2, amaxbull)

AShotsFired = 0

DIM Rows(aliensy)
brow = aliensy
DIM cols(aliensx)
split = aliensx / 2
bcol1 = aliensx
bcol2 = 1

DIM shotloc(2, maxbull)         'good ship shot locations
DIM shots(maxbull)
DIM oldshot(2, maxbull)

DIM hit%(aliensx%, aliensy%)   'array stores which aliens have been hit
DIM dood(aliensx, aliensy)
SCREEN 13           'set screen to VGA 256 color mode
loadpal "pal1.pal"  'load the palette

bulletfile1$ = "sbullet.gax"
shipfile1$ = "ship.anm"
'alienmaskfile$ = "alienmsk.gax"
shiphit$ = "shiphit.gax"
DIM lf AS LONG

OPEN alienfile1$ FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 7, asteps
GET #1, lf - 5, dimsize
GET #1, lf - 3, sizex
GET #1, lf - 1, sizey
CLOSE #1

'IF LastLev THEN movedown% = .8 * sizey% ELSE
movedown% = sizey%

DIM sprite(dimsize * asteps + dimsize)
DEF SEG = VARSEG(sprite(1))
BLOAD alienfile1$, VARPTR(sprite(1))
DEF SEG
DIM spritecover(dimsize)
spritecover(1) = sizex * 8
spritecover(2) = sizey

OPEN shipfile1$ FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 7, ssteps
GET #1, lf - 5, shipdim
GET #1, lf - 3, shipx
GET #1, lf - 1, shipy
CLOSE #1

DIM tiltship(shipdim * 2)
DEF SEG = VARSEG(tiltship(1))
BLOAD "tiltship.anm", VARPTR(tiltship(1))
DEF SEG

DIM ship(shipdim * ssteps + shipdim)
DIM hitship(shipdim)

DEF SEG = VARSEG(ship(1))
BLOAD shipfile1$, VARPTR(ship(1))
DEF SEG = VARSEG(hitship(1))
BLOAD shiphit$, VARPTR(hitship(1))
DEF SEG

DIM shipcover(shipdim)
shipcover(1) = shipx * 8
shipcover(2) = shipy

OPEN bulletfile1$ FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 5, bulldim
GET #1, lf - 3, bullx
GET #1, lf - 1, bully
CLOSE #1
DIM bullet(bulldim)

OPEN abulletfile$ FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 5, abulldim
GET #1, lf - 3, abullx
GET #1, lf - 1, abully
CLOSE #1

'abully = abully
'abullx = abullx - 1
DIM abullet(abulldim)
DEF SEG = VARSEG(bullet(1))
BLOAD bulletfile1$, VARPTR(bullet(1))
DEF SEG
spritesize% = sizex%
bcover2dim = 4 + INT(((bullx + 1) * 1 + 7) / 8) * 4 * (bullspeed + 1)

DIM bcover2(bcover2dim)
bcover2(1) = bullx * 8
bcover2(2) = bullspeed

DIM bulletcover(bulldim)
bulletcover(1) = bullx * 8
bulletcover(2) = bully
DIM abcover2(GetDimsize(abullx + 1, 2 * abullspeed))
abcover2(1) = (abullx + 1) * 8
abcover2(2) = 2 * abullspeed

DEF SEG = VARSEG(abullet(1))
BLOAD abulletfile$, VARPTR(abullet(1))

DEF SEG

DIM abulletcover(abulldim)
abulletcover(1) = (abullx + 1) * 8
abulletcover(2) = (abully + 1)

home% = 0

maxcol% = sw% - 1 - aliensx% * sizex% - mincol%
'IF LastLev THEN
'     maxrow% = sh% - aliensy% * sizey%
maxrow% = sh% - aliensy% * sizey% - shipr + 2
'END IF

shipmid = INT(shipx / 2 + .5)
shipmincol% = 1
shipmaxcol% = sw% - shipx - 1

bullcol = shipmid - bullx / 2

CALL mmsetloc((sw - shipmid), (sw * 2 - shipmid) / 2)
CALL mmsetrange(shipmincol%, 0, 2 * (shipmaxcol% - shipmid), 0)
CALL mmgetloc(mcol%, mrow%)
mcol% = mcol% / 2

shiploc% = sw / 2 - shipmid
dotrow% = shiprow% + shipy% + 2
count% = numlayers%
cu% = 0

CLS

LINE (0, startop - 1)-(320, startop - 1), 139

sinv$ = "Wave" + STR$(level)
CFont ((sw - (LEN(sinv$) * 8)) / 2), 0, sinv$, 0

PUT (shiploc%, shiprow%), ship(1), PSET

shot = 0


PLAY "mb"

dotcolour = 160
IF control = mouse THEN
     LINE (oldmcol + shipmid, dotrow)-(oldmcol + shipmid, dotrow - 1), 0
     LINE (mcol + shipmid, dotrow)-(mcol + shipmid, dotrow - 1), dotcolour
END IF

ShotsFired = 0

jp = bullint                       'rate of fire   control
bulletstarty = shiprow - bully + 4   'starting row for the bullets
taheight = aliensy * sizey         'total alien height
tawidth = aliensx * sizex          'total alien width


UpdateScore 0, totalaliens

gamestatus = 0

MoveTilt = shipspeed

IF control = KeyBoard THEN shipinc = 0   'ship movement with keyboard


'
' main game loop 
'
ClearKeyBuff
UDShields 3 'fill up shields
invincible = 0
IF havemouse THEN
     CALL mmsetloc(160, 0)
END IF
DO
     IF HitAliens = 0 AND AShotsFired = 0 AND ShotsFired = 0 THEN
          fire = 0
          gamestatus = 10
     END IF
     SELECT CASE gamestatus
          CASE 8  'aliens reached bottom
               CFontC "They have landed!", 1
               FadeToVal 63, 0, 0
               CLS
               FadeToVal 0, 0, 0
               GOTO e
          CASE 9  'good ship destroyed
               CFontC "They got you!", 1
               FadeToVal 63, 0, 0
               CLS
               FadeToVal 0, 0, 0
               GOTO e
          CASE 10 'all aliens destroyed
               IF pls = 0 THEN
                    oldshiprow = shiprow
                    CFontC "Wave" + STR$(level) + " Completed", 1
                    incr! = 1
                    DIM ShipBG(GetDimsize(shipx + 1, shipy + 1))
                    pls = 1
                    WAIT &H3DA, 8
                    PUT (shiploc, shiprow), shipcover, PSET
                    GET (shiploc, shiprow)-STEP(shipx, shipy), ShipBG
                    PUT (shiploc, shiprow), ship(1), PSET
               END IF
               IF TouchTop <> 0 THEN
                    PUT (shiploc, oldshiprow), ShipBG, PSET
                    FadeToVal 0, 63, 0
                    CLS
                    FadeToVal 0, 0, 0
                    GOTO e
               END IF
     END SELECT

     UDShields 2   'recharge shields (if any are lost)

     alienbottom = row + taheight
     alienleft = col
     alienright = col + tawidth
   
     IF quick THEN
          Move3DStars  'move the stars
     ELSE MoveStars
     END IF

'move the ship:

     oldmcol% = mcol%
     oldshiploc% = shiploc%
     
     IF Shipstate = 0 AND gamestatus <> 10 THEN
         IF control = mouse THEN
               CALL mmgetloc(m2col%, mrow%)   'get mouse coordinates
               mcol% = m2col% / 2
               shipdev% = shiploc% - m2col% / 2
               IF ABS(shipdev%) > shipspeed% / 2 THEN
                    shiploc% = shiploc% - SGN(shipdev%) * shipspeed%
               ELSE shiploc% = m2col% / 2
               END IF
          END IF
     ELSE
          GOTO drawship
     END IF
    
     Start! = TIMER
     DO UNTIL (TIMER - Start! >= .01) AND (INP(&H3DA) AND 8)
          'ClearKeyBuff
          IF control = KeyBoard THEN
          keypress = INP(&H60)
          SELECT CASE keypress
               CASE 185             'released fire button
                    fire = 0
               CASE 75              'left arrow
                    left = 1        'left is down
                    shipinc = -shipspeed
               CASE 203             'released left
                    left = 0        'left is up
                    IF right = 0 THEN shipinc = 0 ELSE shipinc = shipspeed
               CASE 77              'right arrow
                    right = 1       'right is down
                    shipinc = shipspeed
               CASE 205             'released right
                    right = 0       'right is up
                    IF left = 0 THEN shipinc = 0 ELSE shipinc = -shipspeed
               CASE 57              'spacebar (fire)
                    IF gamestatus = 0 AND HitAliens <> 0 THEN fire = 1 ELSE fire = 0
               CASE 41
                    DEF SEG = 0
                    IF PEEK(&H417) AND 12 = 12 THEN END
          END SELECT
          END IF
     LOOP
    
     IF control = KeyBoard AND gamestatus = 0 THEN shiploc% = shiploc% + shipinc
     IF shiploc% > shipmaxcol% THEN shiploc% = shipmaxcol%
     IF shiploc% < shipmincol% THEN shiploc% = shipmincol%
     IF oldmcol% <> mcol% AND control <> KeyBoard THEN
          LINE (oldmcol + shipmid, dotrow)-(oldmcol + shipmid, dotrow - 1), 0
          LINE (mcol + shipmid, dotrow)-(mcol + shipmid, dotrow - 1), dotcolour
     END IF
   
     IF oldshiploc% <> mcol% AND shipspeed% > 1 THEN
          PUT (oldshiploc%, shiprow%), shipcover, PSET
     END IF

drawship:
   
     IF HitState = 1 AND Shipstate = 0 AND gamestatus <> 10 THEN
          PUT (shiploc, shiprow), hitship, PSET
          HitLen = HitLen + 1
          IF HitLen >= 2 THEN
               HitState = 0
               HitLen = 0
          END IF
     ELSEIF gamestatus = 10 THEN
          Start! = TIMER
          DO UNTIL TIMER - Start! >= .01
          LOOP
          WAIT &H3DA, 8
          PUT (shiploc, oldshiprow), ShipBG, PSET
          GET (shiploc, shiprow)-STEP(shipx, shipy), ShipBG
          PUT (shiploc, shiprow), ship(1), PSET
          CFontC "Wave" + STR$(level) + " Completed", 1
          oldshiprow = shiprow
          incr! = incr! * 1.05
          shiprow = shiprow - incr!
          IF shiprow <= 0 THEN shiprow = 0: TouchTop = 1
     ELSEIF HitState = 0 AND Shipstate = 0 AND gamestatus = 0 THEN
          SELECT CASE control
               CASE mouse
                    IF mcol <= shiploc - MoveTilt THEN
                         PUT (shiploc, shiprow), tiltship(1), PSET
                    ELSEIF mcol >= shiploc + MoveTilt THEN
                         PUT (shiploc, shiprow), tiltship(shipdim + 1), PSET
                    ELSE
                         PUT (shiploc%, shiprow%), ship(1), PSET
                    END IF
               CASE KeyBoard
                    IF oldshiploc > shiploc THEN
                         PUT (shiploc, shiprow), tiltship(1), PSET
                    ELSEIF oldshiploc < shiploc THEN
                         PUT (shiploc, shiprow), tiltship(shipdim + 1), PSET
                    ELSE
                         PUT (shiploc%, shiprow%), ship(1), PSET
                    END IF
          END SELECT
     ELSEIF Shipstate <> 0 AND gamestatus = 0 THEN
          WAIT &H3DA, 8
          Start! = TIMER
          DO WHILE TIMER - Start! <= .01: LOOP
          PUT (shiploc%, shiprow%), ship(Shipstate * shipdim + 1), PSET
     END IF

     IF Shipstate <> 0 THEN
          odd = odd + 1
          IF odd >= shipexplospeed THEN
               odd = 0
               Shipstate = Shipstate + 1
          END IF
     END IF
   
     IF Shipstate > ssteps THEN
          PUT (shiploc%, shiprow%), shipcover, PSET
          MoveStars
          gamestatus = 9
     END IF
   
 
    
   
'move aliens:
    
     lastcol% = col%
     lastrow% = row%
    
     IF col% >= maxcol% OR col% + incx% > maxcol% THEN
          'IF SoundEffects THEN PLAY "MB L64 CF"
          cu% = cu% + 1
          IF cu% < movedown% + 1 THEN
               incx% = 0
               row% = row% + IncY%
          ELSEIF cu% >= movedown% + 1 THEN
               incx% = -irt%
               cu% = 0
               col% = maxcol% + incx%
          END IF
     ELSEIF col% <= mincol% OR col% + incx% < mincol% THEN
          'IF SoundEffects THEN PLAY "mb l64 cf"
          cu% = cu% + 1
          IF cu% < movedown% + 1 THEN
               incx% = 0
               row% = row% + IncY%
          ELSEIF cu% >= movedown% + 1 THEN
               incx% = irt%
               cu% = 0
               col% = mincol% + incx%
          END IF
     ELSE col% = col% + incx%
     END IF
   
     'IF row > maxrow% or row +sizey >maxrow THEN gamestatus = 8
     IF row >= maxrow% THEN gamestatus = 8
   
   
     FOR p = 1 TO maxbull      'erase old bullets
          IF shots(p) <> 0 THEN PUT (oldshot(1, p), oldshot(2, p) + bullspeed), bcover2, PSET
     NEXT p
   
     'erase old bullets
    
     FOR m = 1 TO amaxbull
          IF ashots(m) THEN PUT (ashotloc(1, m), ashotloc(2, m) - abullspeed), abcover2, PSET
     NEXT m
    
     FOR ax% = 0 TO aliensx% - 1    'draw new aliens
          FOR ay% = 0 TO aliensy% - 1
               
               ta = hit%(ax% + 1, ay% + 1)
               IF ta <= asteps THEN
                    PUT (col% + sizex% * ax%, row% + sizey% * ay%), sprite(ta * dimsize + 1), PSET
                    IF ta <> 0 THEN
                         IF dood(ax + 1, ay + 1) >= aexplospeed THEN
                              dood(ax + 1, ay + 1) = 0
                              IF LastLev AND BossHitTimes(ax + 1, ay + 1) < BossHits THEN
                                   hit(ax + 1, ay + 1) = 0
                              'ELSEIF LastLev AND BossHitTimes(ax + 1, ay + 1) >= BossHits THEN
                              '     ActiveAliens = ActiveAliens - 1
                              ELSE
                                   hit(ax + 1, ay + 1) = hit(ax + 1, ay + 1) + 1
                              END IF
                         END IF
                         dood(ax + 1, ay + 1) = dood(ax + 1, ay + 1) + 1
                    END IF
               ELSEIF ta = asteps + 1 THEN
                    PUT (col% + sizex% * ax%, row% + sizey% * ay%), spritecover, PSET
                    ActiveAliens = ActiveAliens - 1
                    hit(ax + 1, ay + 1) = hit(ax + 1, ay + 1) + 1
                    HitAliens = HitAliens - 1
                    UpdateScore totalaliens - HitAliens, totalaliens
                    'IF HitAliens = 0 AND AShotsFired = 0 AND ShotsFired = 0 THEN
                    '     status = 10
                    '     gamestatus = 10
                    'END IF
               END IF
          NEXT ay%
     NEXT ax%
    
     IF testp THEN
          LINE (0, maxrow)-(319, maxrow), 255
          PSET (col, row), 255
          PSET (col, alienbottom), 255
          PSET (alienright, row), 255
          PSET (alienright, alienbottom), 255
          LOCATE 10, 1:
          PRINT brow;
          FOR i = 1 TO aliensy
               PRINT Rows(i);
          NEXT i
          PRINT
          PRINT alienbottom; maxrow

          'LOCATE 10, 1: PRINT brow, rows(brow)

     END IF
     'alien shooting:
   
     IF TheyAreHostile THEN
     'IF (LastLev = 0 AND ActiveAliens > 0) OR (LastLev = 1 AND ActiveAliens > 1) THEN
     IF ActiveAliens > 0 THEN
     alienshoot = alienshoot + 1
     IF alienshoot >= ainterval THEN
          alienshoot = 0
          ainterval = RND * (amaxint - aminint) + aminint
          xalien = RND * (aliensx - 1) + 1
          'yalien = aliensy
          yalien = RND * (aliensy - 1) + 1
          tried = 0
newalien:
          IF hit(xalien, yalien) = 0 THEN
               'IF SoundEffects THEN PLAY "mbl64abcdef"
               AShotsFired = AShotsFired + 1
               'IF SoundEffects THEN PLAY "l64o4dfo3d"          'play dumb little tune
               FOR m = 1 TO amaxbull
                    IF ashots(m) = 0 THEN
                         ashots(m) = 1                   'shot is fired
                         ashotloc(1, m) = col + (xalien - 1) * sizex + (sizex - abullx) / 2 'shotlocation = ship location
                         ashotloc(2, m) = row + yalien * sizey - 10
                         EXIT FOR
                    END IF
               NEXT m
          ELSE
               tried = tried + 1
               xalien = xalien + 1
               IF xalien > aliensx THEN
                    xalien = 1
                    yalien = yalien + 1
                    IF yalien > aliensy THEN yalien = 1
               END IF
               IF tried > totalaliens THEN GOTO NotGonnaShoot
               GOTO newalien
          END IF
     END IF
NotGonnaShoot:
     END IF

     FOR m = 1 TO amaxbull
          IF ashots(m) THEN
               ashotloc(2, m) = ashotloc(2, m) + abullspeed
               IF ashotloc(2, m) + abully + 1 >= sh THEN
                    PUT (ashotloc(1, m), ashotloc(2, m) - abullspeed), abulletcover, PSET
                    AShotsFired = AShotsFired - 1
                    ashots(m) = 0
                    GOTO nextbullet
               END IF
               PUT (ashotloc(1, m), ashotloc(2, m)), abullet, PSET
        
          '*** alien hit detection is done here:
             
               bbrow = ashotloc(2, m) + abully + 1
               IF bbrow >= shiprow THEN
                    FOR kp = 0 TO abullx - 1
                         ahit = POINT(ashotloc(1, m) + kp, bbrow)
                         IF (ahit > 0) AND (ahit < 240) AND ashotloc(1, m) + kp >= shiploc AND ashotloc(1, m) + kp <= shiploc + shipx AND Shipstate = 0 THEN
                              IF SoundEffects THEN PLAY "mbl64abcde"
                              AShotsFired = AShotsFired - 1
                              ashots(m) = 0
                              PUT (ashotloc(1, m), ashotloc(2, m)), abulletcover, PSET
                              IF invincible = 0 THEN UDShields 1
                              HitState = 1
                              EXIT FOR
                         END IF
                    NEXT kp
               END IF
          END IF
nextbullet:
     NEXT m
     END IF


     'this part does the shooting, hit detection, etc.
     'hit detection works now
   
     IF control = mouse AND gamestatus = 0 THEN CALL mmbutton(fire, rightb) 'check status of mouse buttons
     IF HitAliens = 0 THEN fire = 0
     jp = jp + 1
     IF jp > bullint THEN jp = bullint
     IF fire <> 0 AND jp = bullint AND ShotsFired < maxbull THEN           'if left button is pressed then
          jp = 0
          ShotsFired = ShotsFired + 1
          'IF SoundEffects THEN PLAY "l64o4dfo3d"          'play dumb little tune
          FOR m = 1 TO maxbull
               IF shots(m) = 0 THEN
                    shots(m) = 1                   'shot is fired
                    shotloc(1, m) = shiploc + bullcol       'shotlocation = ship location
                    shotloc(2, m) = bulletstarty
                    EXIT FOR
               END IF
          NEXT m
     END IF
       
     FOR k = 1 TO maxbull
        
          IF shots(k) <> 0 THEN
               oldshot(1, k) = shotloc(1, k)
               oldshot(2, k) = shotloc(2, k)
               shotloc(2, k) = shotloc(2, k) - bullspeed
             
               IF shotloc(2, k) <= atop AND shots(k) <> 0 THEN
                    'IF SoundEffects THEN PLAY "mbl64<<edcba>>"
                    shotloc(2, k) = bulletstarty
                    ShotsFired = ShotsFired - 1
                    IF ShotsFired < 0 THEN ShotsFired = 0
                    shots(k) = 0
                    PUT (oldshot(1, k), oldshot(2, k)), bulletcover, PSET
               END IF
             
               'check for hits:
             
               IF shotloc(2, k) <= alienbottom THEN
               FOR o = 0 TO bullx - 1
                  
                    ifhit = POINT(shotloc(1, k) + o, shotloc(2, k))
                    IF shotloc(1, k + o) >= alienleft AND shotloc(1, k) <= alienright AND shotloc(2, k) >= row AND shotloc(2, k) <= alienbottom - ashipb AND ifhit < 240 AND ifhit > 0 THEN
                         cx = shotloc(1, k) - col + o
                         cy = shotloc(2, k) - row
                         FOR B = 1 TO aliensx
                              IF cx >= (B - 1) * sizex AND cx < B * sizex THEN
                                   Shipnumx = B
                                   EXIT FOR
                              END IF
                         NEXT B
                         FOR B = 1 TO aliensy
                              IF cy >= (B - 1) * sizey AND cy < B * sizey THEN
                                   Shipnumy = B
                                   EXIT FOR
                              END IF
                         NEXT B
                         IF hit(Shipnumx, Shipnumy) > 0 THEN EXIT FOR
                         IF LastLev THEN
                              BossHitTimes(Shipnumx, Shipnumy) = BossHitTimes(Shipnumx, Shipnumy) + 1
                              'IF BossHitTimes(Shipnumx, Shipnumy) >= BossHits - 1 THEN ActiveAliens = ActiveAliens - 1
                         END IF
                         IF hit(Shipnumx, Shipnumy) = 0 THEN
                              'IF LastLev = 0 THEN ActiveAliens = ActiveAliens - 1
                              IF LastLev <> 0 THEN
                                   IF hit%(ax% + 1, ay% + 1) > 2 THEN
                                        Rows(Shipnumy) = Rows(Shipnumy) + 1
                                   END IF
                              ELSEIF LastLev = 0 THEN
                                   Rows(Shipnumy) = Rows(Shipnumy) + 1
                              END IF
                              'IF SoundEffects THEN PLAY "mbl64abcde"
                              IF Rows(brow) >= aliensx THEN
                                   brow = brow - 1
                                   IF brow < 1 THEN brow = 1
                                   maxrow = maxrow + sizey
                                   'aliensy = aliensy - 1
                              END IF
                              'IF Rows(brow) >= aliensx AND brow = Shipnumy THEN
                                   'brow = brow - 1
                                   'IF brow < 1 THEN brow = 1
                                   'maxrow = maxrow + sizey
                                   'aliensy = aliensy - 1
                              'END IF
                                      
                              hit(Shipnumx, Shipnumy) = 1
                              PUT (shotloc(1, k), shotloc(2, k)), bulletcover, PSET
                              shotloc(2, k) = bulletstarty
                              ShotsFired = ShotsFired - 1
                              IF ShotsFired < 0 THEN ShotsFired = 0
                              shots(k) = 0
                                     
                         END IF
                         EXIT FOR
                    END IF
               NEXT o
               END IF
          END IF
        
          IF shots(k) THEN PUT (shotloc(1, k), shotloc(2, k)), bullet, PSET
    
     NEXT k
    
     keyb$ = INKEY$
     ClearKeyBuff
     SELECT CASE keyb$
          CASE CHR$(27), "Q", "q"
               gamestatus = 99
               EXIT DO
          CASE "P", "p"   'pause
               IF gamestatus = 0 THEN Pause2
          CASE "M", "m"   'cheats: move down
               IF Shift THEN
                    BEEP
                    IF IncY THEN
                         oldincy = IncY
                         IncY% = 0
                    ELSE
                         IncY = oldincy
                    END IF
               END IF
          CASE "S", "s" 'cheat: max shields
               IF Shift THEN
                    BEEP
                    UDShields 3
               END IF
          CASE "N", "n"  'cheat: aliens don't shoot
               IF Shift THEN
                    BEEP
                    IF TheyAreHostile THEN
                         TheyAreHostile = 0
                    ELSE TheyAreHostile = 1
                    END IF
               END IF
          CASE "I", "i" 'cheat: invincibility
               IF Shift THEN
                    BEEP
                    IF invincible THEN invincible = 0 ELSE invincible = 1
               END IF
          CASE "T", "t"
               IF Shift THEN
                    BEEP
                    IF testp THEN testp = 0 ELSE testp = 1
               END IF
     END SELECT

LOOP
ClearKeyBuff
e:

END SUB

SUB UDShields (what) STATIC

'this subroutine updates the shields

IF loaded = 0 THEN
     loaded = 1
     maxshields = 50             'maximum shields you can get
     DIM shieldcharge AS SINGLE
                                'how fast shields charge
     x = 270                    'top left corner of shields
     y = 1                      'bottom right corner of shields
     shieldx = 40               'width of shields status bar
     shieldy = 5                'height of shield status bar
     blcorner = shieldy + y
     hitdamage = maxshields / 3 'damage aliens do to you
     DIM shields AS SINGLE
     shields = maxshields       'how much shields you have
     DIM mfactor AS SINGLE
     mfactor = (shieldx / maxshields)   'what to multiply shields by to get it to fit into the little grey box
     shieldcolour = 160
END IF

LINE (x - 1, y - 1)-(x + shieldx + 1, y + shieldy + 1), 250, B
    
IF cheat = 1 THEN
     shieldcharge = maxshields
ELSE shieldcharge = .08
END IF

SELECT CASE what
     CASE 1
          shields = shields - hitdamage
          IF shields < 0 THEN
               shields = 0
               Shipstate = Shipstate + 1
          END IF
     CASE 2
          IF shields < maxshields THEN shields = shields + shieldcharge
          IF shields > maxshields THEN shields = maxshields
     CASE 3
          shields = maxshields
END SELECT

barwid = shields * mfactor
leftbar = shieldx - barwid
IF shields = maxshields THEN
     LINE (x, y)-(x + shieldx, y + shieldy), shieldcolour, BF
ELSEIF shields = 0 THEN
     LINE (x, y)-(x + shieldx - 1, y + shieldy), 0, BF
ELSE
     LINE (x, y)-(x + barwid, blcorner), shieldcolour, BF
     LINE (x + barwid, y)-(x + leftbar + barwid, blcorner), 0, BF
END IF
END SUB

SUB UpdateScore (howmany, total)
hm$ = LTRIM$(RTRIM$(STR$(howmany)))
IF LEN(hm$) < 2 THEN hm$ = " " + hm$
tt$ = LTRIM$(RTRIM$(STR$(total)))
IF LEN(tt$) < 2 THEN tt$ = " " + tt$
CFont 0, 0, hm$ + "/" + tt$, 0
END SUB

SUB WaitForUser
ClearKeyBuff
IF havemouse THEN
     WHILE INKEY$ = "" AND l = 0 AND r = 0
          CALL mmbutton(l, r)
     WEND
ELSE
     WHILE INKEY$ = "": WEND
END IF
END SUB

SUB WinGame
CLS
FadeToVal 0, 0, 0
CLS
DEF SEG = &HA000
BLOAD "victory.gax", 0
DEF SEG
FadeIn "victory.pal"
c$ = "Congratulations!"
ExPrint CentX(c$), 80, c$, 1, .01
c$ = "Earth is safe once more!"
ExPrint CentX(c$), 100, c$, 1, .01
WaitForUser
FadeToVal 0, 0, 0
CLS
DEF SEG = &HA000
BLOAD "theend.gax", 0
DEF SEG
FadeIn "theend.pal"
WaitForUser
FadeToVal 0, 0, 0
CLS
END SUB

