DEFINT A-Z
DECLARE SUB ExPrint (x%, y%, text$, trans%, speed!)
DECLARE SUB SetAll (r%, g%, B%)
DECLARE FUNCTION GetDimsize% (x%, y%)
DECLARE SUB CFont (x%, y%, text$, trans%)
DECLARE FUNCTION HiResTimer& ()
OPTION BASE 1
'This file contains all of the normal stuff for Space Invaders, like:
'-Timing routine
'-Fading routines
'-and some other things that take up space.

SUB CapsLock (OnOff)
DEF SEG = 0
set = PEEK(&H417)
SELECT CASE OnOff
     CASE 0       'turn off capslock
          IF (set AND 64) = 64 THEN
               set = set XOR 64
               POKE &H417, set
          END IF
     CASE IS <> 0  'turn on capslock
          IF (set AND 64) = 0 THEN
               set = set + 64
               POKE &H417, set
          END IF
END SELECT
DEF SEG
END SUB

SUB CFont (x, y, text$, trans) STATIC

'                    Cfont.bas by Markus Svilans
'                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                         June 24th, 1997
'===================================================================
'How to use CFONT:
'cfont x, y, text$, trans
'    x, y - screen coordinates for top left corner of text
'    text$ - text to print
'    trans - if 0 then not transparent, if non zero then transparent
'===================================================================
'CFONT requires a font file to work
IF loadedfont = 0 THEN
     loadedfont = 1
     FileName$ = "sans.fnt"
     OPEN FileName$ FOR BINARY AS #1
     GET #1, LOF(1) - 1, dimsize
     CLOSE #1
     DIM letters(dimsize * 91 * 2)
     DEF SEG = VARSEG(letters(1))
     BLOAD FileName$, VARPTR(letters(1))
     DEF SEG
     lh = 8
     lw = 8
     sw = 320
     sh = 200
     dm = UBOUND(letters) / 2
     spac = 8
END IF
IF y + lh > sh THEN EXIT SUB
lent = LEN(text$)
SELECT CASE trans
     CASE 0
          FOR i = 0 TO lent - 1
               pchar = ASC(MID$(text$, i + 1, 1))
               IF pchar = 32 THEN xloc = xloc + spac
               IF pchar >= 33 OR pchar <= 122 THEN
                    pchar = pchar - 32
                    xloc = x + (i * lw)
                    IF xloc + lw > sw THEN EXIT SUB
                    PUT (xloc, y), letters(pchar * dimsize + 1), PSET
               END IF
          NEXT i
     CASE ELSE
          FOR i = 0 TO lent - 1
               pchar = ASC(MID$(text$, i + 1, 1))
               IF pchar = 32 THEN xloc = xloc + spac
               IF pchar >= 33 AND pchar <= 122 THEN
                    pchar = pchar - 32
                    xloc = x + (i * lw)
                    IF xloc + lw > sw THEN EXIT SUB
                    PUT (xloc, y), letters(pchar * dimsize + 1), OR
                    PUT (xloc, y), letters(pchar * dimsize + dm + 1), AND
               END IF
          NEXT i
END SELECT
END SUB

SUB CFontC (text$, trans)
'cfont x, y, text$, trans
IF LEN(text$) > 40 THEN text$ = LEFT$(text$, 40)
CFont ((319 - (LEN(text$) * 8)) / 2), 96, text$, trans
END SUB

SUB CFontCEx (text$, trans)
'cfont x, y, text$, trans
ExPrint ((319 - (LEN(text$) * 8)) / 2), 96, text$, trans, .01
END SUB

SUB ClearKeyBuff
DEF SEG = &H40
POKE &H1A, PEEK(&H1C) 'clear keyboard buffer
DEF SEG
END SUB

'
'by Markus Svilans, July 20th, 1997
'
'This sub prints text from the center out.
' x, y - coordinates for top left corner where text will end up
' text$ - text to be printed
' trans - 0 for non transparent, non zero for transparent
' speed! - how fast to print
'
SUB ExPrint (x, y, text$, trans, speed!)
twid = LEN(text$) * 8 - 8
startx = twid / 2 + x - 8
os = startx
IF trans <> 0 THEN
     DIM back(GetDimsize(twid + 10, 8 + 10))
     GET (startx, y)-(startx + 8, y + 8), back
END IF
SELECT CASE trans
     CASE 0
          FOR i = 1 TO LEN(text$)
               CFont startx, y, LEFT$(text$, i), 0
               startx = startx - 4
               Start! = TIMER
               DO WHILE TIMER - Start! <= speed!
               LOOP
          NEXT i
     CASE IS <> 0
          FOR i = 1 TO LEN(text$)
               PUT (os, y), back, PSET
               GET (startx, y)-(startx + i * 8 + 8, y + 8), back
               CFont startx, y, LEFT$(text$, i), 1
               'WAIT &H3DA, 8
               os = startx
               startx = startx - 4
               Start! = TIMER
               DO WHILE TIMER - Start! <= speed!
               LOOP
          NEXT i
END SELECT
END SUB

SUB FadeIn (FileName$)
SetAll 0, 0, 0
DIM getval AS STRING * 1
DIM pal(3, 256)
DIM fadepal(3, 256)

palfile = FREEFILE

OPEN FileName$ FOR BINARY AS #palfile
IF LOF(palfile) = 0 THEN  'check if file is present; if not, then exit sub
     CLOSE #palfile       'and delete the file.
     KILL FileName$
     EXIT SUB
END IF
plusval = 0
FOR i = 0 TO 255
     FOR j = 1 TO 3
          GET #palfile, i * 3 + j, getval
          gv = ASC(getval)
          IF gv > plusval THEN plusval = gv
          pal(j, i + 1) = gv
     NEXT j
NEXT i
CLOSE #palfile

FOR i = 0 TO 255
     FOR j = 1 TO 3
          fadepal(j, i + 1) = pal(j, i + 1) - plusval
     NEXT j
NEXT i

FOR pk = 0 TO plusval + 1
     FOR i = 0 TO 255
          el = i + 1
          FOR j = 1 TO 3
               p = pal(j, el)
               IF fadepal(j, el) < p THEN fadepal(j, el) = fadepal(j, el) + 1
               IF fadepal(j, el) > p THEN fadepal(j, el) = fadepal(j, el) - 1
          NEXT j
     NEXT i
     WAIT &H3DA, 8, 8
     WAIT &H3DA, 8
     FOR i = 0 TO 255
          OUT &H3C8, i
          FOR j = 1 TO 3
               IF fadepal(j, i + 1) > 0 THEN
                    OUT &H3C9, fadepal(j, i + 1)
               ELSE OUT &H3C9, 0
               END IF
          NEXT j
     NEXT i
NEXT pk
END SUB

SUB FadeInFadeOut (colornum, r1, g1, b1, r2, g2, b2) STATIC
IF oldc <> colornum THEN
     oldc = colornum
     incr = 1
     incg = 1
     incb = 1
END IF

OUT &H3C7, colornum
r = INP(&H3C9)
g = INP(&H3C9)
B = INP(&H3C9)

r = r + incr
IF r >= r2 OR r <= r1 THEN incr = -incr
IF r > r2 THEN r = r2
IF r < r1 THEN r = r1

g = g + incg
IF g >= g2 OR g <= g1 THEN incg = -incg
IF g > g2 THEN g = g2
IF g < g1 THEN g = g1

B = B + incb
IF B >= b2 OR B <= b1 THEN incb = -incb
IF B > b2 THEN B = b2
IF B < b1 THEN B = b1

OUT &H3C8, colornum
OUT &H3C9, r
OUT &H3C9, g
OUT &H3C9, B
END SUB

SUB FadeToPal (FileName$)
DIM getval AS STRING * 1
DIM pal(3, 256)
DIM fadepal(3, 256)
DIM changed AS STRING * 256
palfile = FREEFILE
OPEN FileName$ FOR BINARY AS #palfile
IF LOF(palfile) = 0 THEN  'check if file is present; if not, then exit sub
     CLOSE #palfile
     KILL FileName$
     EXIT SUB
END IF
FOR i = 0 TO 255
     FOR j = 1 TO 3
          GET #1, i * 3 + j, getval
          pal(j, i + 1) = ASC(getval)
     NEXT j
NEXT i
CLOSE #palfile
DIM rgb(3)
'DIM rgb(1 TO 3)

DO WHILE ch <= 255
     FOR i = 0 TO 255
          el = i + 1
          OUT &H3C7, i
          FOR j = 1 TO 3
               c = INP(&H3C9)
               p = pal(j, el)
               IF c > p THEN c = c - 1
               IF c < p THEN c = c + 1
               IF c > 63 THEN c = 63
               IF c < 0 THEN c = 0
                fadepal(j, el) = c
          NEXT j
          IF fadepal(1, el) = pal(1, el) AND fadepal(2, el) = pal(2, el) AND fadepal(3, el) = pal(3, el) AND MID$(changed, i + 1, 1) <> CHR$(255) THEN
               MID$(changed, el, 1) = CHR$(255)
               ch = ch + 1
          END IF
     NEXT i
     WAIT &H3DA, 8
     FOR i = 0 TO 255
          OUT &H3C8, i
          FOR j = 1 TO 3
               OUT &H3C9, fadepal(j, i + 1)
          NEXT j
     NEXT i
LOOP
END SUB

SUB FadeToVal (r, g, B)

IF r > 63 THEN r = 63
IF g > 63 THEN g = 63
IF B > 63 THEN B = 63

IF r < 0 THEN r = 0
IF g < 0 THEN g = 0
IF B < 0 THEN B = 0

DIM rgb AS STRING * 3
DIM changed AS STRING * 256

DO WHILE ch <= 255
     WAIT &H3DA, 8
     FOR i = 0 TO 255
          OUT &H3C7, i
          r2 = INP(&H3C9)
          g2 = INP(&H3C9)
          b2 = INP(&H3C9)
       
          IF r2 > r THEN r2 = r2 - 1
          IF r2 < r THEN r2 = r2 + 1
       
          IF g2 > g THEN g2 = g2 - 1
          IF g2 < g THEN g2 = g2 + 1
       
          IF b2 > B THEN b2 = b2 - 1
          IF b2 < B THEN b2 = b2 + 1
       
          IF r2 > 63 THEN r2 = 63
          IF g2 > 63 THEN g2 = 63
          IF b2 > 63 THEN b2 = 63
       
          IF r2 < 0 THEN r2 = 0
          IF g2 < 0 THEN g2 = 0
          IF b2 < 0 THEN b2 = 0
       
          IF r2 = r AND g2 = g AND b2 = B AND MID$(changed, i + 1, 1) <> CHR$(255) THEN
               MID$(changed, i + 1, 1) = CHR$(255)
               ch = ch + 1
          END IF
          OUT &H3C8, i
          OUT &H3C9, r2
          OUT &H3C9, g2
          OUT &H3C9, b2
     NEXT i
LOOP

END SUB

FUNCTION GetDimsize (x, y)
GetDimsize = (4 + INT(((x + 1) * 8 + 7) / 8) * (y + 1)) / 2
END FUNCTION

SUB loadpal (FileName$)
DIM getval AS STRING * 1
palfile = FREEFILE
OPEN FileName$ FOR BINARY AS #palfile
IF LOF(palfile) = 0 THEN  'check if file is present; if not, then exit sub
     CLOSE #palfile
     KILL FileName$
     EXIT SUB
END IF
FOR i = 0 TO 255
     OUT &H3C8, i
     GET #1, i * 3 + 1, getval
     OUT &H3C9, ASC(getval)
     GET #1, i * 3 + 2, getval
     OUT &H3C9, ASC(getval)
     GET #1, i * 3 + 3, getval
     OUT &H3C9, ASC(getval)
NEXT i
CLOSE #palfile
END SUB

SUB Move3DStars STATIC
IF loaded = 0 THEN
     sw = 319
     sh = 199
     loaded = 1

     CONST mc = 15

     starx = sw * 1.2
     stary = sh * 1.2
     starmidx = starx / 2
     cx = starmidx
     starmidy = stary / 2
     cy = starmidy
     midx = sw / 2   'middle of screen on x axis
     midy = sh / 2  'middle of screen on y axis

     DIM dinc AS SINGLE, sz AS SINGLE

     dinc = .02       'size of steps stars3d take through space
     sz = 1          'depth of starfield
     cr = mc / sz
     numstars3d = 250  'number of stars3d

     DIM stars3d(2, numstars3d)
     DIM starsz(numstars3d) AS SINGLE
     DIM oldstars3d(3, numstars3d)
     DIM tx AS LONG, ty AS LONG
     FOR i = 1 TO numstars3d
newcoord:
          stars3d(1, i) = RND * starx
          stars3d(2, i) = RND * stary
          starsz(i) = RND * (sz - dinc) + dinc
          'IF stars3d(3, i%) <= 0 THEN starsz(i) = starsz(i) + dinc
          tx = stars3d(1, i) / starsz(i) + midx - (starmidx / starsz(i))
          IF tx >= 319 OR tx <= 0 THEN GOTO newcoord
          oldstars3d(1, i) = tx
          ty = stars3d(2, i) / starsz(i) + midy - (starmidy / starsz(i))
          IF ty >= 199 OR ty <= 0 THEN GOTO newcoord
          oldstars3d(2, i) = ty
     NEXT i%
     sz = sz + dinc / 2
     DIM sc AS STRING * 1
END IF



DEF SEG = &HA000
FOR i = 1 TO numstars3d
     starsz(i) = starsz(i) - dinc
     IF starsz(i) <= 0 THEN GOTO newstar
     sx = (stars3d(1, i) - starmidx) / starsz(i) + midx
     IF sx > sw OR sx < 0 THEN GOTO newstar
     sy = (stars3d(2, i) - starmidy) / starsz(i) + midy
  
     IF sy > sh OR sy < 0 THEN
          GOTO newstar
     ELSE
          GOTO drawstar
     END IF
newstar:
     starsz(i) = sz
rndx:
     stars3d(1, i) = RND * starx
     IF stars3d(1, i) = cx THEN GOTO rndx
rndy:
     stars3d(2, i) = RND * stary
     IF stars3d(2, i) = cy THEN GOTO rndy
drawstar:
     starcol = 255 - INT(starsz(i) * cr)
     IF starcol > 255 THEN starcol = 255
     IF starcol < 240 THEN starcol = 240
     IF POINT(oldstars3d(1, i), oldstars3d(2, i)) = oldstars3d(3, i) THEN
          POKE oldstars3d(2, i) * 320& + oldstars3d(1, i), 0
     END IF
     IF POINT(sx, sy) = 0 OR (POINT(sx, sy) > 240 AND POINT(sx, sy) < starcol) THEN
          sc = CHR$(starcol)
          POKE sx + 320& * sy, ASC(sc)
     END IF
     oldstars3d(1, i) = sx
     oldstars3d(2, i) = sy
     oldstars3d(3, i) = starcol
NEXT i

END SUB

SUB ScrollDown (x1, y1, x2, y2, ScrollStep)

'Scrolling Routines by Markus Svilans
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'July 15th, 1997

'This sub scrolls specified section of screen down specified amount of pixels
'  x1, y1 - top left corner to be scrolled
'  x2, y2 - bottom right corner to be scrolled
'  ScrollStep - amount of pixels to scroll

'Use these subs where you want and how you want. Reverse engineer them to your
'hearts desire. I don't care if you give me credit or not, though it would
'be nice. Also, if you were to give me credit, it would be a great weight off
'your conscience. Don't worry, I'm not trying to convinve you.

xd = x2 - x1
yd = y2 - y1
IF ScrollStep > yd THEN EXIT SUB

DIM ScrollDim1(GetDimsize(xd, yd))
DIM ScrollDim2(GetDimsize(xd, ScrollStep))

yb = y1 + ScrollStep

GET (x1, yb)-(x2, y2), ScrollDim1
GET (x1, y1)-(x2, yb), ScrollDim2

PUT (x1, y1), ScrollDim1, PSET
PUT (x1, y2 - ScrollStep), ScrollDim2, PSET
END SUB

SUB SetAll (r, g, B)
FOR i = 0 TO 255
     OUT &H3C8, i
     OUT &H3C9, r
     OUT &H3C9, g
     OUT &H3C9, B
NEXT i
END SUB

SUB ShiftSet (SetReset) STATIC
DEF SEG = 0
SELECT CASE SetReset
     CASE 0        'capture settings
          OldSettings = PEEK(&H417)
     CASE IS <> 0  'reset settings
          IF OldSettings THEN POKE &H417, OldSettings
END SELECT
DEF SEG
END SUB

SUB TileIt
texture$ = "texture.gax"

OPEN texture$ FOR BINARY AS #1
lf = LOF(1)
GET #1, lf - 5, textdim
GET #1, lf - 3, tx
GET #1, lf - 1, ty
CLOSE #1
tx = tx + 1
ty = ty + 1

DIM text(textdim)
DEF SEG = VARSEG(text(1))
BLOAD texture$, VARPTR(text(1))
DEF SEG
FOR i = 0 TO 319 STEP tx
     FOR j = 0 TO 199 STEP ty
          PUT (i, j), text, PSET
     NEXT j
NEXT i
ERASE text
END SUB

