DECLARE SUB FadeOut ()
DEFINT A-B                  'Standarddatentyp fr alle Varibalen festlegen

'Unterprogramme mit Varibalen deklarieren
'Soundkarte:

DECLARE SUB SBNextNote ()                     'Spielt eine Note auf Soundkarte
DECLARE SUB SbVoiceFile (a$, B$, C$, D$)      'Einlesen der Instrumente
DECLARE SUB LOADSBM (SONG$)                   'Musikdatei laden (nur Soundkarte)
DECLARE SUB DELAY (sbDT!)                     'Verzgerung fr Abspielen der
					      'Noten auf Soundkarte
DECLARE SUB SbSendInfo (voice!, frequency!, octave!) 'Informationen an Soundkarte
						     'senden
DECLARE SUB SbStopNote (voice%)               'Eine Note nicht spielen
DECLARE SUB SBSTOP ()                         'Abspielen der Musik stoppen (nur Soundkarte)
DECLARE SUB SBPLAYNOTE ()                     'Eine Note abspielen ber Soundkarte
DECLARE SUB SBSEQUENCE ()                     'Koordination der Daten an Soundkarte
DECLARE SUB MAKESBM (sbmfl$, instd$)          'Erzeugen der Musikdateien
DECLARE SUB SBPLAY (sbp$)                     'Abspielen der Musik ber Soundkarte
DECLARE SUB SbOutPort (port!, info%)          'Soundport bestimmen
DECLARE SUB SBINIT ()                         'Soundkarte initialisieren
DECLARE SUB SETINSTRUMENT (voice%, dat%())    'Instrumente setzen
DECLARE SUB MAKESBI (sbifl$, instrudata%())   'Erzeugen der Instrumentendateien
DECLARE SUB Checksnd (Adlib%)                 'Suche Soundkarte (Adlib kompatibel)
DECLARE SUB Quiet ()                          'Reset der Soundkarte

'Spiel:

DECLARE SUB Laden ()                          'Laden der ntigen Dateien
DECLARE SUB Einrichten ()                     'Zeichnen der Spielgrafik
DECLARE SUB Init ()                           'Koordinaten festlegen
DECLARE SUB WandBewegen ()                    'Bewegungen der Wand zeichnen
DECLARE SUB HindernisBewegen ()               'Hindernis bewegen
DECLARE SUB GegnerSchussBewegen ()            'Gegnerische Schsse zeichnen
DECLARE SUB Steuerung ()                      'Steuerung des gesammten Spiels
DECLARE SUB TurmBewegen ()                    'Bewegung des Ziels

'Interruptprozeduren:

DECLARE SUB InitInterrupt ()    'Unterprogramm, das die Assemblerroutine
				'in das Datenfeld "Interfeld" eintrgt

DECLARE SUB INTERRUPT (Nr%, iax%, ibx%, icx%, idx%) 'Unterprogramm, das die
						    'Assemblerroutine aufruft

'Deklaration der der globalen Variablen

DIM SHARED InterFeld(0 TO 34) AS INTEGER 'In diesem Datenfeld wird sich
					 'spter das Assembler-Unterprogramm
					 'befinden
DIM SHARED OutRegBx AS INTEGER  'Datenfeld fr Register bx nach dem Interrupt
DIM SHARED OutregCx AS INTEGER  '    "      "      "    cx  "    "      "
DIM SHARED OutregDx AS INTEGER  '    "      "      "    dx  "    "      "

DIM SHARED ax(0 TO 80, 1 TO 60) AS INTEGER   'Datenfelder fr 3D Koordinaten
DIM SHARED ay(0 TO 40, 1 TO 60) AS INTEGER

DIM SHARED Sprite(1 TO 804) AS INTEGER       'Datenfeld fr Sprite

DIM SHARED x(1 TO 3) AS INTEGER         'Datenfelder fr die Koordinaten
DIM SHARED y(1 TO 3) AS INTEGER         'des Ganges
DIM SHARED z(1 TO 3) AS INTEGER

DIM SHARED gxl AS INTEGER, gxr AS INTEGER  'Datenfelder fr Wnde
DIM SHARED gyu  AS INTEGER, gyo AS INTEGER

DIM SHARED schx(1 TO 3) AS INTEGER      'Datenfelder fr 3 Schsse
DIM SHARED schy(1 TO 3) AS INTEGER
DIM SHARED schz(1 TO 3) AS INTEGER
DIM SHARED ssx(1 TO 3) AS INTEGER       'Datenfelder fr relative Lage zum
DIM SHARED ssy(1 TO 3) AS INTEGER       'Betrachter der Schsse

DIM SHARED hx1 AS INTEGER, hx2 AS INTEGER  'Variablen fr Hindernis
DIM SHARED hy1 AS INTEGER, hy2 AS INTEGER, hz AS INTEGER

DIM SHARED shx AS INTEGER, shy AS INTEGER  'Variablen fr relative Lage
					   'zum Betrachter des Hindernisses

DIM SHARED sx AS INTEGER, sy AS INTEGER    'Position des Betrachters

DIM SHARED sxe AS INTEGER, sye AS INTEGER  'Hilfsvariablen fr die Steuerung

DIM SHARED tsx AS INTEGER, tsy AS INTEGER             'Variablen fr den Turm
DIM SHARED tx AS INTEGER, ty AS INTEGER, tz AS INTEGER

DIM SHARED ImZiel AS INTEGER, LastTime AS LONG   'Variablen die Zielbereinstimmung
						 'bzw. letzte Schuzeit enthalten
DIM SHARED punkte AS INTEGER               'Variable die Punkte enthlt
DIM SHARED muni AS INTEGER                 'Variable die restl. Schu enthlt
DIM SHARED restpunkte AS SINGLE            'Variable die Punkte bis nchste Level enth.

'ffentliche Variablen fr Soundkarte

COMMON SHARED Insdat0%(), Insdat1%(), Insdat2%(), Insdat3%()  'Sounddaten
COMMON SHARED note() AS INTEGER, sblasttime!                  'Note fr Soundkarte
COMMON SHARED SONGLEN AS INTEGER, SONGPOS AS INTEGER, SONGDELAY AS SINGLE 'Liedspezifische Variablen
COMMON SHARED snd(), oct(), NOTECODE() AS LONG, SETOCTAVE AS INTEGER      '      "             "
COMMON SHARED MUSICBACK AS INTEGER, MREPEAT AS INTEGER, SETLENGTH AS INTEGER, SETCHANNEL AS INTEGER 'Variablen fr Musikwidergabe ber Soundkarte

'Instrumente fr Soundkarte deklarieren

COMMON SHARED STEELDRUMS()   AS INTEGER
COMMON SHARED CHIMES()   AS INTEGER
COMMON SHARED ChurchBell()   AS INTEGER
COMMON SHARED FUNKBASS()   AS INTEGER
COMMON SHARED SNAREDRUM()   AS INTEGER
COMMON SHARED PERCUSSION()   AS INTEGER
COMMON SHARED BASSGUITAR()   AS INTEGER
COMMON SHARED SbNull()   AS INTEGER

DIM SHARED m%, mon$, son$, bild$       'Variablen fr Konfiguration

'Zuweisung des Variableninhalts der oben deklarierten Variablen

DIM Insdat0%(12), Insdat1%(12), Insdat2%(12), Insdat3%(12)
DIM note(12) AS INTEGER
DIM snd(0 TO 3, 200), oct(0 TO 3, 200), NOTECODE(0 TO 3, 200) AS LONG
DIM STEELDRUMS(12) AS INTEGER     'Instrument #1
DIM CHIMES(12) AS INTEGER         'Instrument #2
DIM ChurchBell(12) AS INTEGER     'Instrument #3
DIM FUNKBASS(12) AS INTEGER       'Instrument #4
DIM SNAREDRUM(12) AS INTEGER      'Instrument #5
DIM PERCUSSION(12) AS INTEGER     'Instrument #6
DIM BASSGUITAR(12) AS INTEGER     'Instrument #7
DIM SbNull(12) AS INTEGER         'Kein Instrument

DIM SHARED a$(15)                 'fr SFX
DIM SHARED aa AS INTEGER          'fr SFX
DIM A7 AS INTEGER                 'fr SFX
DIM A11 AS INTEGER                'fr SFX
DIM A9 AS INTEGER                 'fr SFX

'*****************************************************************************

SCREEN 12: SCREEN 0
CLS : LOCATE 1, 1: PRINT "Initialisierung ..."

CALL InitInterrupt              'Zu Beginn wird die Routine einmalig aufgerufen
				
CALL Laden                      'Routine aufrufen, um Programmdateien zu laden

IF mon$ = "ON" THEN             'Wenn Musik = AN ist, dann gehe zum nchsten IF
 IF m% = 0 THEN                 'Wenn keine Soundkarte vorhanden ist, dann ...
   ON PLAY(2) GOSUB Musik       'Mit der Musik beginnen (PC-Speaker)
   PLAY ON                      'Ereignisverfolgung fr PLAY aktivieren
    RESTORE Bach                'Einlesen der Musik fr PC-Speaker aus DATAs
   READ a$                      'am Ende des Programms, Zuweisung der DATAs an Variable a$
   PLAY "MB" + a$               'Abspielen der Musik fr PC-Speaker
 ELSE                      'Wenn Soundkarte vorhanden
  SBINIT                           'Soundkarte initialisieren

  a$(1) = "C90A3106514071F39134A72094D1540074D09A87B733"     'SFX - Strings
  a$(2) = "B11121F3411061128127A19824FE440064CF8479B13A"
  a$(3) = "B0112000400060E48047A0982300430063408378B028"
  a$(4) = "B7003106514071F39134A72134D1540074D0947FB72C"
  a$(5) = "B21122EF421062F98225A2982518451065C08579B220"
  a$(6) = "B21122CD421062F98227A2982516450065C28579B22B"
  a$(7) = "B3112806480568F68837A3302B0F4B006BC48B6AB32C"
  a$(8) = "B4112913490069E38947A4462C324C006C418C78B42C"
  a$(9) = "B4022900490069E48947A4A02C004C006C408C78B428"
  a$(10) = "B700311A51C071F99100A7593411540074C29400B724"
  a$(11) = "B0002006404060F38034A02123D1430063D0837FB02C"
  a$(12) = "B7003106514071F39134A72034D1540074D09487B730"

  'Musikdaten an Prozedur SBPLAY bergeben
 
  SBPLAY "MRMBt.18v0o2P11C01A04G01F01G01B01A01F01D01F01D01C01F05P05;"
  SBPLAY "v1o4C01D01P01P01C01P01C01D01P01P01C01P01C01D01P01P01C01P01C01D01P01P01C01P01C01D01P01P01C01P01C01D01P01P01C01P01;"
  SBPLAY "v2o2P01P01D01C01P01D01P01P01D01C01P01D01P01P01D01C01P01D01P01P01D01C01P01D01P01P01D01C01P01D01P01P01D01C01P01D01;"
  SBPLAY "v3o1D01P01D01P01D01P01D01P01E01P01E01P01E01P01E01P01D01P01D01P01D01P01D01P01E01P01E01P01E01P01E01P01D01P01D01P01;"
   SBPLAY "MC"
 
  LOADSBM "PMOORE"                   'Musikdatei fr Soundkarte laden

 'LOADSBM "HULME1"         
 'LOADSBM "SKYVERSE"       
 
  MREPEAT = 1                        'Musik wiederholen

 END IF
END IF

CALL Einrichten                      'Grafiken zeichnen
CALL Init                            'Variablen initialisieren

muni% = 20
restpunkte! = 600

Anfang:                              'Hauptschleife
   IF m% = 1 AND mon$ = "ON" THEN SBNextNote   'Wenn Soundkarte, dann Musik spielen
   CALL WandBewegen               'Wand bewegen
   CALL HindernisBewegen          'Hindernis bewegen
   CALL GegnerSchussBewegen       'Gegnerschu bewegen
   CALL Steuerung                 'Steuerung (Tastatur, Maus einlesen u. auswerten)
  LOCATE 3, 1: PRINT "Punkte:"; punkte%; "von"; restpunkte!  'Punkte anzeigen
  LOCATE 5, 1: PRINT "Restl. Schu:"; muni%  'Restliche Schu anzeigen
 IF punkte% = restpunkte! THEN punkte% = punkte% + muni% * 100: Quiet: FadeOut: RUN "MENU"
 IF muni% = 0 THEN Quiet: FadeOut: RUN "MENU"
GOTO Anfang                       'Schleife wiederholen

IF m% = 1 THEN Quiet              'Wenn Soundkarte vorhanden, dann RESET

Musik:                            'Musikschleife

IF m% = 0 THEN                  'PC-Speaker
 READ a$                          'Einlesen der DATAs in a$
  IF a$ = "MUSIKENDE" THEN        'solange eine DATA "MUSIKENDE" enthlt
     RESTORE Bach                 'DATAs erneut aus DATAs lesen
     READ a$                      'und Variable a$ zuweisen
  END IF
 PLAY a$                          'Musik abspielen
ELSE                           'Soundkarte
 SBNextNote                       'Eine Note Spielen
END IF

RETURN                         'Zurckspringen zur Hauptschleife

Bach:                          'Daten fr PC-Speaker-Musik
DATA "T 255l 8n 24l 8n 28l 8n 31l 8n 36l 8n 40"
DATA "l 8n 31l 8n 36l 8n 40l 8n 24l 8n 28"
DATA "l 8n 31l 8n 36l 8n 40l 8n 31l 8n 36"
DATA "l 8n 40l 8n 24l 8n 26l 8n 33l 8n 38"
DATA "l 8n 41l 8n 33l 8n 38l 8n 41l 8n 24"
DATA "l 8n 26l 8n 33l 8n 38l 8n 41l 8n 33"
DATA "l 8n 38l 8n 41l 8n 23l 8n 26l 8n 31"
DATA "l 8n 38l 8n 41l 8n 31l 8n 38l 8n 41"
DATA "l 8n 23l 8n 26l 8n 31l 8n 38l 8n 41"
DATA "l 8n 31l 8n 38l 8n 41l 8n 24l 8n 28"
DATA "l 8n 31l 8n 36l 8n 40l 8n 31l 8n 36"
DATA "l 8n 40l 8n 24l 8n 28l 8n 31l 8n 36"
DATA "l 8n 40l 8n 31l 8n 36l 8n 40l 8n 24"
DATA "l 8n 28l 8n 33l 8n 40l 8n 45l 8n 33"
DATA "l 8n 40l 8n 45l 8n 24l 8n 28l 8n 33"
DATA "l 8n 40l 8n 45l 8n 33l 8n 40l 8n 45"
DATA "l 8n 24l 8n 26l 8n 30l 8n 33l 8n 38"
DATA "l 8n 30l 8n 33l 8n 38l 8n 24l 8n 26"
DATA "l 8n 30l 8n 33l 8n 38l 8n 30l 8n 33"
DATA "l 8n 38l 8n 23l 8n 26l 8n 31l 8n 38"
DATA "l 8n 43l 8n 31l 8n 38l 8n 43l 8n 23"
DATA "l 8n 26l 8n 31l 8n 38l 8n 43l 8n 31"
DATA "l 8n 38l 8n 43l 8n 23l 8n 24l 8n 28"
DATA "l 8n 31l 8n 36l 8n 28l 8n 31l 8n 36"
DATA "l 8n 23l 8n 24l 8n 28l 8n 31l 8n 36"
DATA "l 8n 28l 8n 31l 8n 36l 8n 21l 8n 24"
DATA "l 8n 28l 8n 31l 8n 36l 8n 28l 8n 31"
DATA "l 8n 36l 8n 21l 8n 24l 8n 28l 8n 31"
DATA "l 8n 36l 8n 28l 8n 31l 8n 36l 8n 14"
DATA "l 8n 21l 8n 26l 8n 30l 8n 36l 8n 26"
DATA "l 8n 30l 8n 36l 8n 14l 8n 21l 8n 26"
DATA "l 8n 30l 8n 36l 8n 26l 8n 30l 8n 36"
DATA "l 8n 19l 8n 23l 8n 26l 8n 31l 8n 35"
DATA "l 8n 26l 8n 31l 8n 35l 8n 19l 8n 23"
DATA "l 8n 26l 8n 31l 8n 35l 8n 26l 8n 31"
DATA "l 8n 35l 8n 19l 8n 22l 8n 28l 8n 31"
DATA "l 8n 37l 8n 28l 8n 31l 8n 37l 8n 19"
DATA "l 8n 22l 8n 28l 8n 31l 8n 37l 8n 28"
DATA "l 8n 31l 8n 37l 8n 17l 8n 21l 8n 26"
DATA "l 8n 33l 8n 38l 8n 26l 8n 33l 8n 38"
DATA "l 8n 17l 8n 21l 8n 26l 8n 33l 8n 38"
DATA "l 8n 26l 8n 33l 8n 38l 8n 17l 8n 20"
DATA "l 8n 26l 8n 29l 8n 35l 8n 26l 8n 29"
DATA "l 8n 35l 8n 17l 8n 20l 8n 26l 8n 29"
DATA "l 8n 35l 8n 26l 8n 29l 8n 35l 8n 16"
DATA "l 8n 19l 8n 24l 8n 31l 8n 36l 8n 24"
DATA "l 8n 31l 8n 36l 8n 16l 8n 19l 8n 24"
DATA "l 8n 31l 8n 36l 8n 24l 8n 31l 8n 36"
DATA "l 8n 16l 8n 17l 8n 21l 8n 24l 8n 29"
DATA "l 8n 21l 8n 24l 8n 29l 8n 16l 8n 17"
DATA "l 8n 21l 8n 24l 8n 29l 8n 21l 8n 24"
DATA "l 8n 29l 8n 14l 8n 17l 8n 21l 8n 24"
DATA "l 8n 29l 8n 21l 8n 24l 8n 29l 8n 14"
DATA "l 8n 17l 8n 21l 8n 24l 8n 29l 8n 21"
DATA "l 8n 24l 8n 29l 8n 7l 8n 14l 8n 19l 8n 23"
DATA "l 8n 29l 8n 19l 8n 23l 8n 29l 8n 7l 8n 14"
DATA "l 8n 19l 8n 23l 8n 29l 8n 19l 8n 23"
DATA "l 8n 29l 8n 12l 8n 16l 8n 19l 8n 24"
DATA "l 8n 28l 8n 19l 8n 24l 8n 28l 8n 12"
DATA "l 8n 16l 8n 19l 8n 24l 8n 28l 8n 19"
DATA "l 8n 24l 8n 28l 8n 12l 8n 19l 8n 22"
DATA "l 8n 24l 8n 28l 8n 22l 8n 24l 8n 28"
DATA "l 8n 12l 8n 19l 8n 22l 8n 24l 8n 28"
DATA "l 8n 22l 8n 24l 8n 28l 8n 5l 8n 17l 8n 21"
DATA "l 8n 24l 8n 28l 8n 21l 8n 24l 8n 28"
DATA "l 8n 5l 8n 17l 8n 21l 8n 24l 8n 28l 8n 21"
DATA "l 8n 24l 8n 28l 8n 6l 8n 12l 8n 21l 8n 24"
DATA "l 8n 27l 8n 21l 8n 24l 8n 27l 8n 6l 8n 12"
DATA "l 8n 21l 8n 24l 8n 27l 8n 21l 8n 24"
DATA "l 8n 27l 8n 8l 8n 17l 8n 23l 8n 24l 8n 26"
DATA "l 8n 23l 8n 24l 8n 26l 8n 8l 8n 17l 8n 23"
DATA "l 8n 24l 8n 26l 8n 23l 8n 24l 8n 26"
DATA "l 8n 7l 8n 17l 8n 19l 8n 23l 8n 26l 8n 19"
DATA "l 8n 23l 8n 26l 8n 7l 8n 17l 8n 19l 8n 23"
DATA "l 8n 26l 8n 19l 8n 23l 8n 26l 8n 7l 8n 16"
DATA "l 8n 19l 8n 24l 8n 28l 8n 19l 8n 24"
DATA "l 8n 28l 8n 7l 8n 16l 8n 19l 8n 24l 8n 28"
DATA "l 8n 19l 8n 24l 8n 28l 8n 7l 8n 14l 8n 19"
DATA "l 8n 24l 8n 29l 8n 19l 8n 24l 8n 29"
DATA "l 8n 7l 8n 14l 8n 19l 8n 24l 8n 29l 8n 19"
DATA "l 8n 24l 8n 29l 8n 7l 8n 14l 8n 19l 8n 23"
DATA "l 8n 29l 8n 19l 8n 23l 8n 29l 8n 7l 8n 14"
DATA "l 8n 19l 8n 23l 8n 29l 8n 19l 8n 23"
DATA "l 8n 29l 8n 7l 8n 15l 8n 21l 8n 24l 8n 30"
DATA "l 8n 21l 8n 24l 8n 30l 8n 7l 8n 15l 8n 21"
DATA "l 8n 24l 8n 30l 8n 21l 8n 24l 8n 30"
DATA "l 8n 7l 8n 16l 8n 19l 8n 24l 8n 31l 8n 19"
DATA "l 8n 24l 8n 31l 8n 7l 8n 16l 8n 19l 8n 24"
DATA "l 8n 31l 8n 19l 8n 24l 8n 31l 8n 7l 8n 14"
DATA "l 8n 19l 8n 24l 8n 29l 8n 19l 8n 24"
DATA "l 8n 29l 8n 7l 8n 14l 8n 19l 8n 24l 8n 29"
DATA "l 8n 19l 8n 24l 8n 29l 8n 7l 8n 14l 8n 19"
DATA "l 8n 23l 8n 29l 8n 19l 8n 23l 8n 29"
DATA "l 8n 7l 8n 14l 8n 19l 8n 23l 8n 29l 8n 19"
DATA "l 8n 23l 8n 29l 8n 12l 8n 12l 8n 19"
DATA "l 8n 22l 8n 28l 8n 19l 8n 22l 8n 28"
DATA "l 8n 12l 8n 12l 8n 19l 8n 22l 8n 28"
DATA "l 8n 19l 8n 22l 8n 28l 8n 12l 8n 12"
DATA "l 8n 17l 8n 21l 8n 24l 8n 29l 8n 24"
DATA "l 8n 21l 8n 24l 8n 21l 8n 17l 8n 21"
DATA "l 8n 17l 8n 14l 8n 17l 8n 14l 8n 12"
DATA "l 8n 11l 8n 31l 8n 35l 8n 38l 8n 41"
DATA "l 8n 38l 8n 35l 8n 38l 8n 35l 8n 31"
DATA "l 8n 35l 8n 26l 8n 29l 8n 28l 8n 26"
DATA "l 8n 12l 8n 12l 8n 24l 8n 28l 8n 31"
DATA "l 1n 36"
DATA "MUSIKENDE"

SUB Checksnd (Adlib%)
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat1 = INP(&H388)
OUT &H388, &H2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &HFF: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H21: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
SLEEP 1
Astat2 = INP(&H388)
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Ares1 = Astat1 AND &HE0: Ares2 = Astat2 AND &HE0
Adlib% = 0: IF Ares1 = 0 AND Ares2 = 192 THEN Adlib% = 1
END SUB

DEFSNG A-B
SUB DELAY (sbDT!)
IF sbDT! = 0! THEN EXIT SUB
sbstart! = TIMER
IF (sbstart! + sbDT!) > 86400 THEN
  sbFinish! = ((sbstart! + sbDT!) - 86400)
  DO WHILE TIMER >= sbstart! OR TIMER <= sbFinish!: LOOP
ELSE
  DO WHILE TIMER <= (sbstart! + sbDT!): LOOP
END IF
END SUB

DEFINT A-B
SUB Einrichten

SCREEN 7                        'Niedrige EGA - Auflsung
CLS

PAINT (0, 0), 8                 'Den ganzen Schirm grau malen
LINE (9, 49)-(310, 165), 0, BF  'Fensterrahmen zeichnen
LINE (5, 45)-(314, 169), 9, B
LINE (4, 44)-(315, 170), 3, B
LINE (3, 43)-(316, 171), 11, B
LINE (9, 49)-(310, 165), 11, B
LINE (8, 48)-(311, 166), 3, B
LINE (7, 47)-(312, 167), 9, B

PUT (120, 151), Sprite, PSET    'Linke Seite des Piloten malen

FOR SpriteX% = 120 TO 160       'Linke Seite spiegeln (rechte Seite malen)
   FOR SpriteY% = 151 TO 191
	  PSET (319 - SpriteX%, SpriteY%), POINT(SpriteX%, SpriteY%)
   NEXT
NEXT

LOCATE 1, 10
PRINT " Tunnel Striker V1.2 "

IF bild$ = "OFF" THEN VIEW SCREEN (10, 50)-(309, 150)  'Bildschirmfenster definieren

CLS                              'und lschen

END SUB

SUB FadeOut
 FOR colors% = 0 TO 63
   FOR fade% = 0 TO 30
     OUT 967, fade%
     Red = INP(969)
     Green = INP(969)
     Blue = INP(969)
     Red = Red - 1
     Green = Green - 1
     Blue = Blue - 1

     IF Red < 0 THEN Red = 0
     IF Green < 0 THEN Green = 0
     IF Blue < 0 THEN Blue = 0

     OUT 968, fade%

     OUT 969, Red
     OUT 969, Green
     OUT 969, Blue
   
     FOR warte = 1 TO 15: NEXT warte

   NEXT fade%
 NEXT colors%
END SUB

SUB GegnerSchussBewegen

FOR s% = 1 TO 3                'Alle 3 Schsse lschen
   LINE (ax(schx(s%) + ssx(s%), schz(s%)), ay(schy(s%) + ssy(s%), schz(s%)))-(ax(schx(s%) + ssx(s%), schz(s%) + 2), ay(schy(s%) + ssy(s%), schz(s%) + 2)), 0
   schz(s%) = schz(s%) + 4     'und um 4 Einheiten auf den Betrachter zu bewegen.
  
   IF schz(s%) > 58 THEN       'Betrachter erreicht ?
	 
	  Treffer% = 0         'Stimmen die Koordinaten des Schusses mit den
			       'eigenen Koordinaten berein?
		 IF ABS((40 - sx) - schx(s%)) < 4 THEN Treffer% = 1
		 IF ABS((20 - sy) - schy(s%)) < 2 THEN Treffer% = Treffer% + 1
	 
	  IF Treffer% = 2 THEN
		 'Hier mssen Sie einfgen,was geschehen soll, wenn der Betrachter
		 'getroffen wurde.
	  END IF
	 
	  schz(s%) = INT(RND * 10) + 1  'Zufllige, neue Position fr den
	  schx(s%) = INT(RND * 40)      'Schuss berechnen
	  schy(s%) = INT(RND * 20)
  
   END IF
  
   ssx(s%) = sx    'Die Koorinaten des Schusses denen des Betrachters
   ssy(s%) = sy    'anpassen und Schuss an neuer Position zeichnen.
   LINE (ax(schx(s%) + ssx(s%), schz(s%)), ay(schy(s%) + ssy(s%), schz(s%)))-(ax(schx(s%) + ssx(s%), schz(s%) + 2), ay(schy(s%) + ssy(s%), schz(s%) + 2)), 14
NEXT

END SUB

SUB HindernisBewegen
'Hindernis lschen.

t = TIMER: DO: LOOP UNTIL TIMER > t       'Verzgerung

LINE (ax(hx1 + shx, hz), ay(hy1 + shy, hz))-(ax(hx2 + shx, hz), ay(hy2 + shy, hz)), 0, B
   hz = hz + 1                 'Auf den Betrachter zu bewegen.
  
   IF hz = 61 THEN             'Ist der Betrachter erreicht ?
	  Treffer% = 0         'Stimmen die Koordinaten einigermaen berein ?
	  IF hx1 > hx2 THEN
		 hx1 = hx1 + 3: hx2 = hx2 - 3
		 IF (40 - sx) <= hx1 AND (40 - sx) >= hx2 THEN Treffer% = 1
	    ELSE
		 hx1 = hx1 - 3: hx2 = hx2 + 3
		 IF (40 - sx) >= hx1 AND (40 - sx) <= hx2 THEN Treffer% = 1
	  END IF
	  IF hy1 > hy2 THEN
		 hy1 = hy1 + 1: hy2 = hy2 - 1
		 IF (20 - sy) <= hy1 AND (20 - sy) >= hy2 THEN Treffer% = Treffer% + 1
	    ELSE
		 hy1 = hy1 - 1: hy2 = hy2 + 1
		 IF (20 - sy) >= hy1 AND (20 - sy) <= hy2 THEN Treffer% = Treffer% + 1
	  END IF
	 
	  IF Treffer% = 2 THEN
		 'Hier mssen Sie einfgen, was bei einer Kollision mit dem
		 'Hindernis geschehen soll.
	  END IF
	 
	  hz = 1               'Neue Koordinaten des Hindernisses ermitteln.
	  hx1 = INT(RND * 40)
	  hy1 = INT(RND * 20)
	  hx2 = INT(RND * 40)
	  hy2 = INT(RND * 20)
  
   END IF
  
   shx = sx     'Koordinaten dem Betrachterstandpunkt anpassen.
   shy = sy

'Hindernis zeichnen.
LINE (ax(hx1 + shx, hz), ay(hy1 + shy, hz))-(ax(hx2 + shx, hz), ay(hy2 + shy, hz)), 4, B

END SUB

SUB Init

RANDOMIZE TIMER           'Zufallsgenerator aktivieren

FOR w% = 1 TO 3           'Die Wnde im Abstand von 20 Einheiten definieren.
   x(w%) = 20
   y(w%) = 10
   z(w%) = w% * 20 - 10
NEXT

FOR sch% = 1 TO 3
   schx(sch%) = INT(RND * 40)      'Die Positionen der Schsse definieren.
   schy(sch%) = INT(RND * 20)
   schz(sch%) = INT(RND * 10) + 1
NEXT

hx1 = 10             'Die Position des Hindernisses bestimmen.
hy1 = 10
hx2 = 11
hy2 = 11
shx = 20
shy = 10
hz = 1

tx = 20              'Die Position des Turmes bestimmen.
ty = 15
tz = 1
tsx = 20
tsy = 10


sx = 20              'Die Position des Betrachters bestimmen.
sy = 10


END SUB

SUB InitInterrupt

PoiSeg% = VARSEG(OutRegBx)       'Segment und Offset der Variable
PoiPos% = VARPTR(OutRegBx)       'OutregBx bestimmen.

bxSLow% = (PoiSeg% MOD 256)      'Segment in Highbyte und Lowbyte
bxSHigh% = INT(PoiSeg% / 256)    'umrechnen.

bxPLow% = (PoiPos% MOD 256)      'Offset in Highbyte und Lowbyte
bxPHigh% = INT(PoiPos% / 256)    'umrechnen.


PoiSeg% = VARSEG(OutregCx)       'Segment und Offset der Variable
PoiPos% = VARPTR(OutregCx)       'OutregCx bestimmen.

cxSLow% = (PoiSeg% MOD 256)      'Segment in Highbyte und Lowbyte
cxSHigh% = INT(PoiSeg% / 256)    'umrechnen.

cxPLow% = (PoiPos% MOD 256)      'Offset in Highbyte und Lowbyte
cxPHigh% = INT(PoiPos% / 256)    'umrechnen.

PoiSeg% = VARSEG(OutregDx)       'Segment und Offset der Variable
PoiPos% = VARPTR(OutregDx)       'OutregDx bestimmen.

dxSLow% = (PoiSeg% MOD 256)      'Segment in Highbyte und Lowbyte
dxSHigh% = INT(PoiSeg% / 256)    'umrechnen.

dxPLow% = (PoiPos% MOD 256)      'Offset in Highbyte und Lowbyte
dxPHigh% = INT(PoiPos% / 256)    'umrechnen.


DEF SEG = VARSEG(InterFeld(0))   'In die Variable InterFeld wird der
   Poi% = VARPTR(InterFeld(0))   'Assemblercode direkt eingetragen.
  
   POKE Poi%, &HB8           'mov ax, dummy (Inhalt von ax wird
   POKE Poi% + 1, &H0        '               spter mittels Poke
   POKE Poi% + 2, &H0        '               eingefgt.)
  
   POKE Poi% + 3, &HBB       'mov bx, dummy
   POKE Poi% + 4, &H0
   POKE Poi% + 5, &H0

   POKE Poi% + 6, &HB9       'mov cx, dummy
   POKE Poi% + 7, &H0
   POKE Poi% + 8, &H0

   POKE Poi% + 9, &HBA       'mov dx, dummy
   POKE Poi% + 10, &H0
   POKE Poi% + 11, &H0
  
   POKE Poi% + 12, &HCD       'int dummy (Interruptnummer mit Poke
   POKE Poi% + 13, &H0        '           einfgen.)
  
   POKE Poi% + 14, &H6        'push es
   POKE Poi% + 15, &H56       'push si
  
   POKE Poi% + 16, &HB8       'mov ax, Segment von OutregCx
   POKE Poi% + 17, cxSLow%
   POKE Poi% + 18, cxSHigh%
  
   POKE Poi% + 19, &H8E      'mov es, ax
   POKE Poi% + 20, &HC0
  
   POKE Poi% + 21, &HB8      'mov ax, Pointer auf OutregCx
   POKE Poi% + 22, cxPLow%
   POKE Poi% + 23, cxPHigh%
  
   POKE Poi% + 24, &H8B      'mov si, ax
   POKE Poi% + 25, &HF0
  
   POKE Poi% + 26, &H26      'mov es:[si], cl
   POKE Poi% + 27, &H88
   POKE Poi% + 28, &HC
  
   POKE Poi% + 29, &H26      'mov es:[si+1], ch
   POKE Poi% + 30, &H88
   POKE Poi% + 31, &H6C
   POKE Poi% + 32, &H1
  
   POKE Poi% + 33, &HB8       'mov ax, Segment von OutregDx
   POKE Poi% + 34, dxSLow%
   POKE Poi% + 35, dxSHigh%
 
   POKE Poi% + 36, &H8E      'mov es, ax
   POKE Poi% + 37, &HC0
 
   POKE Poi% + 38, &HB8      'mov ax, Pointer auf OutregDx
   POKE Poi% + 39, dxPLow%
   POKE Poi% + 40, dxPHigh%
 
   POKE Poi% + 41, &H8B      'mov si, ax
   POKE Poi% + 42, &HF0
 
   POKE Poi% + 43, &H26      'mov es:[si], dl
   POKE Poi% + 44, &H88
   POKE Poi% + 45, &H14
 
   POKE Poi% + 46, &H26      'mov es:[si+1], dh
   POKE Poi% + 47, &H88
   POKE Poi% + 48, &H74
   POKE Poi% + 49, &H1
 
   POKE Poi% + 50, &HB8       'mov ax, Segment von OutregBx
   POKE Poi% + 51, bxSLow%
   POKE Poi% + 52, bxSHigh%

   POKE Poi% + 53, &H8E      'mov es, ax
   POKE Poi% + 54, &HC0

   POKE Poi% + 55, &HB8      'mov ax, Pointer auf OutregBx
   POKE Poi% + 56, bxPLow%
   POKE Poi% + 57, bxPHigh%

   POKE Poi% + 58, &H8B      'mov si, ax
   POKE Poi% + 59, &HF0

   POKE Poi% + 60, &H26      'mov es:[si], bl
   POKE Poi% + 61, &H88
   POKE Poi% + 62, &H1C

   POKE Poi% + 63, &H26      'mov es:[si+1], bh
   POKE Poi% + 64, &H88
   POKE Poi% + 65, &H7C
   POKE Poi% + 66, &H1
  
   POKE Poi% + 67, &H5E      'pop si
   POKE Poi% + 68, &H7       'pop es
   POKE Poi% + 69, &HCB      'ret
DEF SEG

END SUB

SUB INTERRUPT (Nr%, iax%, ibx%, icx%, idx%)

ah% = INT(iax% / 256)  'Die an INTERRUPT bergebenen Registerwerte werden
bh% = INT(ibx% / 256)  'in ihre Highbyte und Lowbyte aufgeteilt.
ch% = INT(icx% / 256)
dh% = INT(idx% / 256)

al% = (iax% MOD 256)
bl% = (ibx% MOD 256)
cl% = (icx% MOD 256)
dl% = (idx% MOD 256)

DEF SEG = VARSEG(InterFeld(0))  'Segmentzeiger auf InterFeld
   Poi% = VARPTR(InterFeld(0))  'Pointer auf InterFeld
  
   POKE Poi% + 1, al%           'Die Werte fr die Inreg-Register
   POKE Poi% + 2, ah%           'und die Interruptnummer werden in die
				'Stellen der Assemblerroutine eingetragen,
   POKE Poi% + 4, bl%           'die bei der Initialisierung mit Dummywerten
   POKE Poi% + 5, bh%           '(0) freigehalten wurden.

   POKE Poi% + 7, cl%
   POKE Poi% + 8, ch%

   POKE Poi% + 10, dl%
   POKE Poi% + 11, dh%

   POKE Poi% + 13, Nr%
   CALL absolute(Poi%)          'Hier verzweigt das Programm zur Assembler-
				'routine, die jetzt mit sinnvollen Werten
				'fr die Inreg-Register und der
				'Interruptnummer versehen worden ist.
DEF SEG
END SUB

SUB Laden

'Alle bentigten Datenfelder Laden, Grafik des Piloten laden

DEF SEG = VARSEG(ax(0, 1))
BLOAD "data_x.dat", VARPTR(ax(0, 1))      'Datenfeld fr X

DEF SEG = VARSEG(ay(0, 1))
BLOAD "data_y.dat", VARPTR(ay(0, 1))      'Datenfeld fr Y

DEF SEG = VARSEG(Sprite(1))
BLOAD "grafik_l.dat", VARPTR(Sprite(1))   'Grafik des Piloten laden

DEF SEG                                   'Ausgangszustand wiederherstellen

OPEN "sb.cfg" FOR INPUT AS #1             'Inhalt der Datei SB.CFG in Variable
 INPUT #1, m%                             'm% einlesen
CLOSE                                     'Datei schlieen

OPEN "ts.cfg" FOR INPUT AS #1             'Inhalt der Datei SB.CFG in Variablen
 INPUT #1, mon$, son$, bild$              'mon$, son$, bild$ einlesen
CLOSE                                     'Datei schlieen

mon$ = RTRIM$(mon$)                       'Leerzeichen entfernen aus Variable
son$ = RTRIM$(son$)                       'mon$, son$, bild$
bild$ = RTRIM$(bild$)

COLOR 7, 1
PRINT "Musik:    "; mon$                  'Konfiguration anzeigen
PRINT "Sound:    "; son$
PRINT "Vollbild: "; bild$

END SUB

DEFSNG A-B
SUB LOADSBM (SONG$) STATIC
SONGPOS = 1
OPEN SONG$ + ".SBM" FOR INPUT AS #19
INPUT #19, a$: INPUT #19, B$: INPUT #19, C$: INPUT #19, D$: INPUT #19, SONGDELAY
SbVoiceFile a$, B$, C$, D$
FOR v% = 0 TO 3: ct = 0
NOTES1:
INPUT #19, D: IF D = -1 THEN GOTO NOTES2
oc% = INT(D / 10000)
sd% = INT((D - INT(D / 10000) * 10000) / 100)
dr1% = INT(D - INT(D / 10000) * 10000)
dr% = dr1% - (INT(dr1% / 100) * 100)
FOR z% = 1 TO dr%: ct = ct + 1
snd(v%, ct) = note(sd%)
oct(v%, ct) = oc%
NEXT z%: GOTO NOTES1
NOTES2:
SONGLEN = ct
ct = ct + 1
NOTECODE(v%, ct) = INT(D)
FOR abxs% = ct TO 200
snd(v%, abxs%) = 0: oct(v%, abxs%) = 0
NEXT
NEXT v%
CLOSE #19
END SUB

SUB MAKESBI (sbifl$, instrudata%()) STATIC
OPEN sbifl$ + ".SBI" FOR OUTPUT AS #19
PRINT #19, instrudata%(1); ","; instrudata%(2); ","; instrudata%(3); ",";
PRINT #19, instrudata%(4)
PRINT #19, instrudata%(5); ","; instrudata%(6); ","; instrudata%(7); ",";
PRINT #19, instrudata%(8)
PRINT #19, instrudata%(9); ","; instrudata%(10); ","; instrudata%(11); ",";
PRINT #19, instrudata%(12)
CLOSE #19
END SUB

SUB MAKESBM (sbmfl$, instd$) STATIC
OPEN sbmfl$ + ".SBM" FOR OUTPUT AS #19
PRINT #19, instd$; ","; SONGDELAY
sbtottotln% = 0
FOR sba2% = 0 TO 3
sbngnd% = 0
sbtotln% = 0
FOR sbab% = 1 TO 200
IF NOTECODE(sba2%, sbab%) = -1 THEN sbngnd% = sbab%
IF sbngnd% = 0 THEN sbtotln% = sbtotln% + VAL(RIGHT$(STR$(NOTECODE(sba2%, sbab%)), 2))
NEXT
IF sbtotln% = 200 THEN sbtotln% = 0
IF sbtotln% > 0 THEN sbtotln% = sbtotln% + 1
IF sbtotln% > sbtottotln% THEN sbtottotln% = sbtotln%
IF sbngnd% = 0 THEN sbngnd% = sbtottotln%
FOR sbab% = 1 TO sbngnd% - 1
PRINT #19, STR$(NOTECODE(sba2%, sbab%));
IF sbab% / 8 = sbab% \ 8 THEN PRINT #19, "" ELSE PRINT #19, ",";
NEXT
PRINT #19, "-1"
NEXT
CLOSE #19
END SUB

DEFINT A-B
SUB Quiet
FOR A9 = 0 TO 244: OUT &H388, A9
FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0
FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT: NEXT
END SUB

DEFSNG A-B
SUB SBINIT STATIC
BASSGUITAR(1) = 1
BASSGUITAR(2) = 51
BASSGUITAR(3) = 138
BASSGUITAR(4) = 72
BASSGUITAR(5) = 241
BASSGUITAR(6) = 241
BASSGUITAR(7) = 17
BASSGUITAR(8) = 179
BASSGUITAR(9) = 0
BASSGUITAR(10) = 0
BASSGUITAR(11) = 6
BASSGUITAR(12) = 0
PERCUSSION(1) = 1
PERCUSSION(2) = 51
PERCUSSION(3) = 138
PERCUSSION(4) = 67
PERCUSSION(5) = 135
PERCUSSION(6) = 101
PERCUSSION(7) = 67
PERCUSSION(8) = 33
PERCUSSION(9) = 18
PERCUSSION(10) = 52
PERCUSSION(11) = 86
PERCUSSION(12) = 120
SNAREDRUM(1) = 16
SNAREDRUM(2) = 0
SNAREDRUM(3) = 133
SNAREDRUM(4) = 0
SNAREDRUM(5) = 255
SNAREDRUM(6) = 16
SNAREDRUM(7) = 4
SNAREDRUM(8) = 177
SNAREDRUM(9) = 0
SNAREDRUM(10) = 0
SNAREDRUM(11) = 15
SNAREDRUM(12) = 255
FUNKBASS(1) = 17
FUNKBASS(2) = 17
FUNKBASS(3) = 129
FUNKBASS(4) = 0
FUNKBASS(5) = 17
FUNKBASS(6) = 18
FUNKBASS(7) = 17
FUNKBASS(8) = 179
FUNKBASS(9) = 0
FUNKBASS(10) = 0
FUNKBASS(11) = 6
FUNKBASS(12) = 0
ChurchBell(1) = 37
ChurchBell(2) = 51
ChurchBell(3) = 138
ChurchBell(4) = 0
ChurchBell(5) = 241
ChurchBell(6) = 241
ChurchBell(7) = 17
ChurchBell(8) = 179
ChurchBell(9) = 0
ChurchBell(10) = 0
ChurchBell(11) = 6
ChurchBell(12) = 0
CHIMES(1) = 4
CHIMES(2) = 51
CHIMES(3) = 138
CHIMES(4) = 0
CHIMES(5) = 241
CHIMES(6) = 241
CHIMES(7) = 32
CHIMES(8) = 179
CHIMES(9) = 0
CHIMES(10) = 162
CHIMES(11) = 170
CHIMES(12) = 0
STEELDRUMS(1) = 213
STEELDRUMS(2) = 82
STEELDRUMS(3) = 0
STEELDRUMS(4) = 5
STEELDRUMS(5) = 240
STEELDRUMS(6) = 164
STEELDRUMS(7) = 28
STEELDRUMS(8) = 181
STEELDRUMS(9) = 5
STEELDRUMS(10) = 181
STEELDRUMS(11) = 0
STEELDRUMS(12) = 5
MUSICBACK = 0: MREPEAT = 0: SETOCTAVE = 3: SONGPOS = 1: SONGLEN = 199
SETLENGTH = 1: SETCHANNEL = 0: SONGDELAY = .1: sblasttime! = TIMER
FOR sbn% = 1 TO 12
SbNull(sbn%) = 0
NEXT
FOR x = &H0 TO &HF5
OUT &H388, x: OUT &H389, 0
NEXT x
note(1) = &H16B: note(2) = &H181: note(3) = &H198: note(4) = &H1B0: note(5) = &H1CA: note(6) = &H1E5
note(7) = &H202: note(8) = &H220: note(9) = &H241: note(10) = &H263: note(11) = &H287: note(12) = &H2AE
FOR mclr% = 0 TO 3: FOR mcl2% = 1 TO 200
NOTECODE(mclr%, mcl2%) = 1: NEXT: NEXT
SETINSTRUMENT 0, CHIMES()
SETINSTRUMENT 1, CHIMES()
SETINSTRUMENT 2, CHIMES()
SETINSTRUMENT 3, CHIMES()
END SUB

SUB SBNextNote STATIC
IF MREPEAT = 0 AND SONGPOS = SONGLEN + 1 THEN EXIT SUB
sbstart! = TIMER
IF (sblasttime! + SONGDELAY) > 86400 THEN
sbFinish! = ((sblasttime! + SONGDELAY) - 86400)
ELSE
sbFinish! = sblasttime! + SONGDELAY
END IF
IF sbstart! >= sbFinish! THEN
FOR x% = 1 TO 4
IF snd(x% - 1, SONGPOS) <> snd(x% - 1, SONGPOS - 1) THEN SbStopNote x% - 1
NEXT x%
FOR x% = 1 TO 4
SbSendInfo x% - 1, snd(x% - 1, SONGPOS), oct(x% - 1, SONGPOS)
NEXT x%
SONGPOS = SONGPOS + 1
IF SONGPOS = SONGLEN + 1 AND MREPEAT = 1 THEN SONGPOS = 1
sblasttime! = TIMER
END IF
END SUB

SUB SbOutPort (port, info%)
OUT &H388, port
OUT &H389, info%
END SUB

SUB SBPLAY (sbp$) STATIC

FOR tpos% = 1 TO LEN(sbp$)
IF SONGPOS = 200 THEN SONGPOS = 199
IF tpos% < LEN(sbp$) THEN xpos% = tpos% + 1 ELSE xpos% = tpos%
chk$ = UCASE$(MID$(sbp$, tpos%, 1))
IF chk$ = ";" THEN
NOTECODE(SETCHANNEL, SONGPOS) = -1
oklen% = 0
FOR getsp% = 1 TO SONGPOS - 1
oklen% = oklen% + VAL(RIGHT$(STR$(NOTECODE(SETCHANNEL, getsp%)), 2))
NEXT
SONGLEN = oklen%
SONGPOS = 1
END IF
IF chk$ = "O" THEN
SETOCTAVE = VAL(MID$(sbp$, xpos%, 1))
IF SETOCTAVE > 6 THEN SETOCTAVE = 6
IF SETOCTAVE < 0 THEN SETOCTAVE = 0
tpos% = tpos% + 1
END IF
IF chk$ = "M" THEN
ch2$ = UCASE$(MID$(sbp$, xpos%, 1))
SELECT CASE ch2$
CASE "B"
MUSICBACK = 1
CASE "F"
MUSICBACK = 0
CASE "R"
MREPEAT = 1
CASE "T"
MREPEAT = 0
CASE "C"
FOR mclr% = 0 TO 3: FOR mcl2% = 1 TO 200
NOTECODE(mclr%, mcl2%) = 1: NEXT: NEXT
SONGPOS = 1: SETCHANNEL = 0: SETLENGTH = 1
CASE "0"
FOR mcl2% = 1 TO 200
NOTECODE(0, mcl2%) = 1: NEXT
CASE "1"
FOR mcl2% = 1 TO 200
NOTECODE(1, mcl2%) = 1: NEXT
CASE "2"
FOR mcl2% = 1 TO 200
NOTECODE(2, mcl2%) = 1: NEXT
CASE "3"
FOR mcl2% = 1 TO 200
NOTECODE(3, mcl2%) = 1: NEXT
END SELECT
tpos% = tpos% + 1
END IF
IF chk$ = "T" THEN
sbaddmeup% = 0
FOR mslr% = tpos% + 1 TO LEN(sbp$)
ch2$ = MID$(sbp$, mslr%, 1)
IF ch2$ < "0" AND ch2$ <> "." OR ch2$ > "9" AND ch2$ <> "." THEN
ch3$ = MID$(sbp$, tpos% + 1, sbaddmeup%)
IF ch3$ = "." THEN ch3$ = ".1"
SONGDELAY = VAL(ch3$)
tpos% = mslr% - 1
GOTO EndIfPart2InThisSBBG3SUB
END IF
sbaddmeup% = sbaddmeup% + 1
NEXT
EndIfPart2InThisSBBG3SUB:
END IF
IF chk$ = "L" THEN
SETLENGTH = VAL(MID$(sbp$, xpos%, 2))
IF SETLENGTH > 16 THEN SETLENGTH = 16
IF SETLENGTH < 1 THEN SETLENGTH = 1
tpos% = tpos% + 2
END IF
IF chk$ = "V" THEN
SETCHANNEL = VAL(MID$(sbp$, xpos%, 1))
IF SETCHANNEL < 0 THEN SETCHANNEL = 0
IF SETCHANNEL > 3 THEN SETCHANNEL = 3
SONGPOS = 1
tpos% = tpos% + 1
END IF
IF chk$ = ">" THEN
SETOCTAVE = SETOCTAVE + 1
IF SETOCTAVE > 6 THEN SETOCTAVE = 6
END IF
IF chk$ = "<" THEN
SETOCTAVE = SETOCTAVE - 1
IF SETOCTAVE < 1 THEN SETOCTAVE = 1
END IF
IF chk$ = "P" THEN
ahahaha% = VAL(MID$(sbp$, xpos%, 2))
IF ahahaha% > 16 THEN ahahaha% = 16
IF ahahaha% < 1 THEN ahahaha% = 1
NOTECODE(SETCHANNEL, SONGPOS) = ahahaha%
SONGPOS = SONGPOS + 1
tpos% = tpos% + 2
END IF
IF chk$ = "C" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = 0
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (1 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF
IF chk$ = "D" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = -1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (3 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF
IF chk$ = "E" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 0
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = -1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (5 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF

IF chk$ = "F" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = 0
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (6 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF

IF chk$ = "G" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = -1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (8 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF

IF chk$ = "A" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = -1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (10 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF

IF chk$ = "B" THEN
thislength% = 0
addamount% = 0
gimmenote$ = MID$(sbp$, xpos%, 1)
IF gimmenote$ = "0" OR gimmenote$ = "1" THEN
thislength% = VAL(MID$(sbp$, xpos%, 2))
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
tpos% = tpos% + 2
END IF
IF gimmenote$ = "+" OR gimmenote$ = "#" THEN
addamount% = 0
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF gimmenote$ = "-" THEN
addamount% = -1
tpos% = tpos% + 1
ch2$ = MID$(sbp$, xpos% + 1, 2)
IF LEFT$(ch2$, 1) = "1" OR LEFT$(ch2$, 1) = "0" THEN
tpos% = tpos% + 2
thislength% = VAL(ch2$)
IF thislength% > 16 THEN thislength% = 16
IF thislength% < 1 THEN thislength% = 1
END IF
END IF
IF thislength% = 0 THEN thislength% = SETLENGTH
NOTECODE(SETCHANNEL, SONGPOS) = SETOCTAVE * 5000
NOTECODE(SETCHANNEL, SONGPOS) = NOTECODE(SETCHANNEL, SONGPOS) * 2 + (12 + addamount%) * 100 + thislength%
SONGPOS = SONGPOS + 1
addamount% = 0: thislength% = 0
END IF
NEXT
GOSUB EndOfSUBSBPLAY
IF MUSICBACK = 0 THEN SBSEQUENCE
EXIT SUB
EndOfSUBSBPLAY:
FOR v% = 0 TO 3: ct% = 0: countsbm% = 1
NOTES11:
IF countsbm% < 201 THEN
D! = NOTECODE(v%, countsbm%)
ELSE
D! = -1
END IF
countsbm% = countsbm% + 1
IF D! = -1 THEN GOTO NOTES22
oc% = INT(D! / 10000)
sd% = INT((D! - INT(D! / 10000) * 10000) / 100)
dr1% = INT(D! - INT(D! / 10000) * 10000)
dr% = dr1% - (INT(dr1% / 100) * 100)
FOR z% = 1 TO dr%: ct% = ct% + 1
IF ct% > 200 THEN GOTO NOTES11
snd(v%, ct%) = note(sd%)
oct(v%, ct%) = oc%
NEXT z%: GOTO NOTES11
NOTES22:
ct% = ct% + 1
NEXT v%
RETURN

END SUB

SUB SBPLAYNOTE STATIC
IF MREPEAT = 0 AND SONGPOS = SONGLEN + 1 THEN EXIT SUB
FOR x% = 1 TO 4
IF snd(x% - 1, SONGPOS) <> snd(x% - 1, SONGPOS - 1) THEN SbStopNote x% - 1
NEXT x%
FOR x% = 1 TO 4
SbSendInfo x% - 1, snd(x% - 1, SONGPOS), oct(x% - 1, SONGPOS)
NEXT x%
SONGPOS = SONGPOS + 1
IF SONGPOS = SONGLEN + 1 AND MREPEAT = 1 THEN SONGPOS = 1
DELAY SONGDELAY
END SUB

SUB SbSendInfo (voice, frequency, octave)
SbOutPort &HA0 + voice, frequency AND &HFF
SbOutPort &HB0 + voice, INT(frequency / 256) OR 32 OR (octave * 4)
END SUB

SUB SBSEQUENCE STATIC

IF MREPEAT = 1 THEN
DO
SBPLAYNOTE
LOOP UNTIL INKEY$ = CHR$(27)
SBSTOP
ELSE
DO
SBPLAYNOTE
LOOP UNTIL SONGPOS = SONGLEN + 1
SONGPOS = 1
SBSTOP
END IF

END SUB

SUB SBSTOP STATIC
FOR x% = 0 TO 4: SbStopNote x%: NEXT x%
SONGPOS = 1: sblasttime! = 0
END SUB

SUB SbStopNote (voice%)

 SbOutPort &HB0 + voice%, 0

END SUB

SUB SbVoiceFile (a$, B$, C$, D$) STATIC

OPEN a$ + ".SBI" FOR INPUT AS #20
FOR i = 1 TO 12: INPUT #20, Insdat0%(i): NEXT i
CLOSE #20
OPEN B$ + ".SBI" FOR INPUT AS #20
FOR i = 1 TO 12: INPUT #20, Insdat1%(i): NEXT i
CLOSE #20
OPEN C$ + ".SBI" FOR INPUT AS #20
FOR i = 1 TO 12: INPUT #20, Insdat2%(i): NEXT i
CLOSE #20
OPEN D$ + ".SBI" FOR INPUT AS #20
FOR i = 1 TO 12: INPUT #20, Insdat3%(i): NEXT i
CLOSE #20
SETINSTRUMENT 0, Insdat0%(): SETINSTRUMENT 1, Insdat1%()
SETINSTRUMENT 2, Insdat2%(): SETINSTRUMENT 3, Insdat3%()

END SUB

SUB SETINSTRUMENT (voice%, dat%())
     IF voice% < 3 THEN avoice% = voice%
     IF voice% = 3 THEN avoice% = 8
     IF voice% = 4 THEN avoice% = 9
     IF voice% = 5 THEN avoice% = 10
     IF voice% = 6 THEN avoice% = 16
     IF voice% = 7 THEN avoice% = 17
     IF voice% = 8 THEN avoice% = 18
     SbOutPort &H20 + avoice%, dat%(1)
     SbOutPort &H23 + avoice%, dat%(2)
     SbOutPort &H40 + avoice%, dat%(3)
     SbOutPort &H43 + avoice%, dat%(4)
     SbOutPort &H60 + avoice%, dat%(5)
     SbOutPort &H63 + avoice%, dat%(6)
     SbOutPort &H80 + avoice%, dat%(7)
     SbOutPort &H83 + avoice%, dat%(8)
     SbOutPort &HE0 + avoice%, dat%(9)
     SbOutPort &HE3 + avoice%, dat%(10)
     SbOutPort &HC0 + voice%, dat%(11)
     sbsbstat% = 0
     FOR sbabc% = 1 TO 12
     sbsbstat% = sbsbstat% + dat%(sbabc%)
     NEXT
     FOR sbabc% = 1 TO 12
     IF voice% = 0 AND sbsbstat% > 0 THEN Insdat0%(sbabc%) = dat%(sbabc%)
     IF voice% = 1 AND sbsbstat% > 0 THEN Insdat1%(sbabc%) = dat%(sbabc%)
     IF voice% = 2 AND sbsbstat% > 0 THEN Insdat2%(sbabc%) = dat%(sbabc%)
     IF voice% >= 3 AND sbsbstat% > 0 THEN Insdat3%(sbabc%) = dat%(sbabc%)
     NEXT
END SUB

SUB SoundOff
OUT &H388, &HB0: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB1: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB3: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB5: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB6: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB7: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB8: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &HB9: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, 0: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
END SUB

DEFINT A-B
SUB Steuerung

'Fadenkreuz lschen.
LINE (150 + sxe * 4, 100 + sye * 4)-(170 + sxe * 4, 100 + sye * 4), 0
LINE (160 + sxe * 4, 95 + sye * 4)-(160 + sxe * 4, 105 + sye * 4), 0

'Tastatur lesen.
i$ = INKEY$
IF i$ <> "" THEN
   IF LEN(i$) = 2 THEN i$ = RIGHT$(i$, 1)
   i% = ASC(i$)
   SELECT CASE i%
	  CASE 72
		 sye = sye - 2   'Steuerungsvariablen dem Tastendruck entsprechend
	  CASE 80                'verndern
		 sye = sye + 2
	  CASE 75
		 sxe = sxe - 2
	  CASE 77
		 sxe = sxe + 2
	  CASE 32               'Leertaste -> Schu
		 IF (TIMER - LastTime) > 1 THEN      'Ist der letzte Schuss schon 3
			LastTime = TIMER             '1 Sekunde her?
			SchussX% = 160 + sxe * 4     'Schuss zeichnen.
			SchussY% = 100 + sye * 4
			LINE (0, 0)-(SchussX%, SchussY%), 5
			LINE -(319, 0), 5
			LINE (0, 199)-(SchussX%, SchussY%), 5
			LINE -(319, 199), 5
		     IF son$ = "ON" THEN
			FOR Ton% = 1000 TO 2000 STEP 100     'Ton ausgeben.
			   SOUND Ton%, .2
			NEXT
		      muni% = muni% - 1      '1 Schu abziehen
		     END IF

			IF ImZiel = 1 THEN                   'Treffer ?
			   LINE (ax(tx + tsx, tz), ay(ty + tsy, tz))-(ax(tx + tsx + 1, tz), ay(tsy, tz)), 0, BF
			 IF son$ = "ON" THEN
			   FOR Ton% = 500 TO 2000 STEP 100    'Turm lschen und Ton
				  SOUND Ton%, .2              'ausgeben.
			   NEXT
			   FOR Ton% = 2000 TO 500 STEP -100
				  SOUND Ton%, .2
			   NEXT
			 END IF
			   tz = 1                'Neue Position des Turmes bestimmen.
			   tx = INT(RND * 40)
			   ty = INT(RND * 20)
		       
			    punkte% = punkte% + 100
		       
			END IF
		   
			LINE (0, 0)-(SchussX%, SchussY%), 0   'Schuss lschen.
			LINE -(319, 0), 0
			LINE (0, 199)-(SchussX%, SchussY%), 0
			LINE -(319, 199), 0
		 END IF
	 
	  CASE 27   'Escape beendet das Programm.
		 IF m% = 1 THEN Quiet: RUN "Menu"
		 IF m% = 0 THEN RUN "Menu"
	  CASE ELSE
   END SELECT
END IF

'Maustasten lesen

CALL INTERRUPT(&H33, &H3, 0, 0, 0)

IF OutRegBx = 1 THEN            'Linke Maustaste gedrckt?
		 IF (TIMER - LastTime) > 1 THEN     'Ist der letzte Schuss schon 3
			LastTime = TIMER            '1 Sekunde her?
			SchussX% = 160 + sxe * 4    'Schuss zeichnen.
			SchussY% = 100 + sye * 4
			LINE (0, 0)-(SchussX%, SchussY%), 5
			LINE -(319, 0), 5
			LINE (0, 199)-(SchussX%, SchussY%), 5
			LINE -(319, 199), 5
		      IF son$ = "ON" THEN
			FOR Ton% = 1000 TO 2000 STEP 100     'Ton ausgeben.
			   SOUND Ton%, .2
			NEXT
		       muni% = muni% - 1      '1 Schu abziehen
		      END IF
			IF ImZiel = 1 THEN            'Treffer ?
			   LINE (ax(tx + tsx, tz), ay(ty + tsy, tz))-(ax(tx + tsx + 1, tz), ay(tsy, tz)), 0, BF
			 IF son$ = "ON" THEN
			   FOR Ton% = 500 TO 2000 STEP 100    'Turm lschen und Ton
				  SOUND Ton%, .2                  'ausgeben.
			   NEXT
			   FOR Ton% = 2000 TO 500 STEP -100
				  SOUND Ton%, .2
			   NEXT
			 END IF
			   tz = 1                'Neue Position des Turmes bestimmen.
			   tx = INT(RND * 40)
			   ty = INT(RND * 20)
		       
			    punkte% = punkte% + 100
		       
			END IF
		 
			LINE (0, 0)-(SchussX%, SchussY%), 0   'Schuss lschen.
			LINE -(319, 0), 0
			LINE (0, 199)-(SchussX%, SchussY%), 0
			LINE -(319, 199), 0
		 END IF
END IF


		 
CALL INTERRUPT(&H33, &HB, 0, 0, 0)   'Mausbewegung lesen
sxe = sxe + OutregCx                 'und Steuerungsvariablen verndern.
sye = sye + OutregDx

IF sye > 2 THEN sye = 2              'Bewegung begrenzen und
IF sye < -2 THEN sye = -2
IF sxe > 4 THEN sxe = 4
IF sxe < -4 THEN sxe = -4

sx = sx - sxe / 2                    'auf den Betrachterstandpunkt
sy = sy - sye / 2                    'bertragen.

IF sx < 2 THEN sx = 2                'Bewegung an den Wnden stoppen.
IF sx > 38 THEN sx = 38
IF sy < 1 THEN sy = 1
IF sy > 19 THEN sy = 19

CALL TurmBewegen                     'Den Turm bewegen.

IF POINT(160 + sxe * 4, 100 + sye * 4) = 11 THEN  'Deutet das Fadenkreuz
   ImZiel = 1                                     'auf den Turm ?
  
				     'Ja, also Fadenkreuz wei zeichnen.
   LINE (150 + sxe * 4, 100 + sye * 4)-(170 + sxe * 4, 100 + sye * 4), 15
   LINE (160 + sxe * 4, 95 + sye * 4)-(160 + sxe * 4, 105 + sye * 4), 15
ELSE
   ImZiel = 0
				     'Nein, also Fadenkreuz grau zeichnen.
   LINE (150 + sxe * 4, 100 + sye * 4)-(170 + sxe * 4, 100 + sye * 4), 7
   LINE (160 + sxe * 4, 95 + sye * 4)-(160 + sxe * 4, 105 + sye * 4), 7
END IF

END SUB

SUB TurmBewegen
'Turm lschen.
LINE (ax(tx + tsx, tz), ay(ty + tsy, tz))-(ax(tx + tsx + 1, tz), ay(tsy, tz)), 0, BF
   tz = tz + 1           'Auf den Betrachter zu bewegen.
   IF tz = 59 THEN       'Ist der betrachter erreicht ?
	  tz = 1                'Neue Position bestimmen.
	  tx = INT(RND * 40)
	  ty = INT(RND * 20)
	IF son$ = "ON" THEN
	  FOR soun% = 500 TO 300 STEP -50
	   SOUND soun%, 1                 'Turm nicht getroffen -> Sound spielen
	  NEXT soun%
	END IF
   END IF
  
   tsx = sx               'Koordinaten dem Betrachterstandpunkt anpassen.
   tsy = sy

'Turm zeichnen.
LINE (ax(tx + tsx, tz), ay(ty + tsy, tz))-(ax(tx + tsx + 1, tz), ay(tsy, tz)), 11, BF
END SUB

SUB WandBewegen
FOR w% = 1 TO 3   'Alle 3 Wnde lschen.
   LINE (ax(x(w%), z(w%)), ay(y(w%), z(w%)))-(ax(x(w%) + 40, z(w%)), ay(y(w%) + 20, z(w%))), 0, B
  
   z(w%) = z(w%) + 1      'Auf den Betrachter zu bewegen.
   IF z(w%) > 60 THEN     'Ist der Betrachter erreicht ?
	  z(w%) = z(w%) - 60    'Neue Position bestimmen.
   END IF
  
   x(w%) = sx             'Koordinaten dem Betrachterstandpunkt anpassen.
   y(w%) = sy
  
   'Wand zeichnen.
   LINE (ax(x(w%), z(w%)), ay(y(w%), z(w%)))-(ax(x(w%) + 40, z(w%)), ay(y(w%) + 20, z(w%))), 2, B
NEXT

'Verbindungslinien (Gang) lschen.
LINE (ax(gxl, 1), ay(gyo, 1))-(ax(gxl, 60), ay(gyo, 60)), 0
LINE (ax(gxr, 1), ay(gyu, 1))-(ax(gxr, 60), ay(gyu, 60)), 0
LINE (ax(gxr, 1), ay(gyo, 1))-(ax(gxr, 60), ay(gyo, 60)), 0
LINE (ax(gxl, 1), ay(gyu, 1))-(ax(gxl, 60), ay(gyu, 60)), 0

gxl = sx        'Koordinaten anpassen.
gxr = sx + 40
gyu = sy + 20
gyo = sy

'Verbindungslinien zeichnen
LINE (ax(gxl, 1), ay(gyo, 1))-(ax(gxl, 60), ay(gyo, 60)), 2
LINE (ax(gxr, 1), ay(gyu, 1))-(ax(gxr, 60), ay(gyu, 60)), 2
LINE (ax(gxr, 1), ay(gyo, 1))-(ax(gxr, 60), ay(gyo, 60)), 2
LINE (ax(gxl, 1), ay(gyu, 1))-(ax(gxl, 60), ay(gyu, 60)), 2

END SUB

