'DOSFONTS.BAS
'Liest Pixelmuster der ASCII-Zeichen aus der Datei DOS\EGA.CPI
'und schreibt sie im Textmodus vergrert auf den Bildschirm
'Autor:     Roland Heer
'Sprache:   QBasic
'Stand:     18.9.96
'-------------------------------------------------------------
DEFINT A-Z
DECLARE SUB Pixel (ascii, x, y)
SCREEN 0
CLS

start:
INPUT " Font 8*16(1) 8*14(2) 8*8(3) 1/2/3 ? ", font

'zhoehe = Zeichenhhe in Pixeln
'offset = erstes Byte des Pixelmusters von CHR$(0)

SELECT CASE font
CASE 1                  '8*16 beginnt bei Byte Nr. 65
    zhoehe = 16
    offset = 65
CASE 2                  '8*14 beginnt bei Byte Nr. 4167
    zhoehe = 14
    offset = 256 * 16 + 71
CASE 3                  '8*8 beginnt bei Byte Nr. 7757
    zhoehe = 8
    offset = 256 * 16 + 256 * 14 + 77
CASE ELSE
    LOCATE 1, 1: PRINT " Falsche Eingabe"; TAB(80);
    GOTO start
END SELECT

zchzhl = 10             'Zahl der gleichzeitig dargestellten Zeichen

'** Die Pixelmuster werden im Feld inbyte() gespeichert

DIM inbyte(1 TO zhoehe, 1 TO zchzhl) AS STRING * 1

DO
    INPUT " Lies ab CHR$(n):  n = ", anf
    anf = anf * zhoehe + offset

'** Zeichen lesen
    OPEN "c:\dos\ega.cpi" FOR BINARY AS #1
        FOR j = 1 TO zchzhl
            FOR i = 1 TO zhoehe
                GET #1, anf + i + (j - 1) * zhoehe, inbyte(i, j)
            NEXT i
        NEXT j
    CLOSE

'** Zeichen schreiben
    WIDTH 80, 50
    FOR j = 1 TO zchzhl
        FOR i = 1 TO zhoehe
            ascii = ASC(inbyte(i, j))
            CALL Pixel(ascii, 7 + (j - 1) * 8, i)
        NEXT i
    NEXT j

    LOCATE 49, 1
    PRINT " Weiter mit beliebiger Taste oder <ESC> fr Abbruch";
    DO: key$ = INKEY$
    LOOP UNTIL LEN(key$)
    WIDTH 80, 25
    IF key$ = CHR$(27) THEN SYSTEM
LOOP
END

DEFINT A - Z
SUB Pixel (ascii, x, y)
'** Wandelt ascii in Binrzahl und setzt entsprechende Zeichen
    FOR i = 0 TO 7
        bit = ascii MOD 2
        LOCATE y + 1, x + 1 - i
        IF bit THEN PRINT "" ELSE PRINT ""
        ascii = ascii \ 2
    NEXT i
END SUB
