'QBFonts.BAS - Part of the QBFonts package.
'-------------------------------------------
'***** The most important stuff *****
'(Read this if nothing else)
'-CONST PROGRAMNAME = "QBFonts.BAS"
' Do Not forget to set this constant!  (Further down in code)
'-Use a ~ at the end of text to indicate staying
' on the same line.  Use only with left justified text.
'************************************
'
'  By Bobby K. of Insanity Dreams
'  You are strongly advised to read QBFonts.TXT - It gives full information
'  on how to use each of the subroutines.
'  There is also a readme.txt, which applys to the whole package,
'  and not just this program.
'  If you use these subs in any of your programs please give
'  full credit to the author.  If this dosn't happen, i am less likely
'  to make further QBFont programs.
'  This program is copywrited, and may not be used for any
'  commercial purposes without the authors consent
'  E-Mail me at:
'    christie@intonet.co.uk
'    (Replys may take a while, as i'm off to Manchester uni soon :)
'  Visit the insanity dreams homepage at:
'    laz.home.ml.org
'    And click on the insanity dreams logo.  (My uni e-mail will probably
'    be in there as well.)
'"So tell me bob k...."
' So.  I finally got round to making a new improved version huh?
' About time too.
' To those of you who are new to the QBFonts programs, the first version
' came out sometime in early 97.  It took one hell of a lot of work, i can
' tell you.  I was running VB programs that were taking two hours to run!
' Finally, after many a sleepless night, everything fell together, and there
' it was.
'
'**** Help Wanted! ****
' I have a game i am working on.  (I think it is one of the most
' technically advanced QB games i have seen, discluding some stuff which
' uses libarys, made from complicated Assembler or C code.)
' It is in 128 colors, 320*200 resolution.
' It is in 2.5 d, which means that as the little man moves around the
' game-world, he moves in front of, and behind objects!  He can also move
' up and down.  The character is animated, and the frame rate is pretty good,
' even on my pathetic 386.  The main engine for all this stuff is complete.
' Stop for a miute, and think how cool an RPG type game, with good graphics,
' a good plot, and this extreamly powerful game engine would be!
'HOWEVER!
' I do not have much spare time any more, and need help if this game is
' ever to become even close to being finished.
'If you would like to help with:
' Making the sprite editor
' Making the level editor
' Drawing sprites
' Storyline
' Music
' I would love to hear from you.
' Be under no illusion - like most joint QB projects over the web,
' this venture is unlikely to ever succeed.  But if it did, i think it
' would be one of the best ever QB games.
' BTW i think the game will be the sort of RPG, where you need to
' figure out stuff, and use your mind to succed, rather than a
' "collect the gems" sort of thing.  IE no power gamers need apply.
' If you think you are up to the challenge please e-mail me asap.
'
'Credits:
' This version arose out of the constructive critism from E-Mail,
' So remeber - if you want improvement I need feedback!
' My many thanks to all of you who wrote to me, wanting help,
' with comments on good/bad stuff, and just sayin' it was cool :)
' My thanks also to Lior Zur, who took the original VB font making program,
' added a load of cool stuff, and made an .exe out of it, so you can all
' now use the Font Maker.  (If you have win 95)
' If it wasn't for him, i probably wouldn't have bothered making the
' new version.
'
'Well, i dont have much more to say.  I hope you enjoy, and use this program.
'Have Happy programing, and just mail me if you want anything.


CONST LEFT = 1, CENTER = 2, RIGHT = 3
CONST CTHRU = -1, DEFAULT = -999
CONST FALSE = 0, TRUE = -1
DECLARE SUB QBFdefault ()
DECLARE SUB QBFfontpath (Path$) ' Attention: QBFfontpath seems to be buggy
                                ' ==> patched by  (c) Thomas Antoni 24.10.0

DECLARE SUB QBFopen (font$, File)
DECLARE SUB QBFjustify (JustifyType)
DECLARE SUB QBFletterspacing (Spacing)
DECLARE SUB QBFwordspacing (Spacing)
DECLARE SUB QBFlinespacing (Spacing)
DECLARE SUB QBFselectfont (FontID)
DECLARE SUB QBFtextwindow (x1, y1, x2, y2)
DECLARE SUB QBFnewline (text$)
DECLARE SUB QBFprintwrap (text$)
DECLARE SUB QBFprint (text$)
DECLARE SUB QBFcolor (Fore, Back)
DECLARE SUB QBFbackoneline (Side, Down)
DECLARE SUB QBFlines.addline (Row)
DECLARE SUB QBFlines.removeline (Row)
DECLARE SUB QBFlines.removeall ()
DECLARE FUNCTION QBFlength (text$)

DECLARE SUB AAA.SAVEinitialise ()
DECLARE SUB SAVEinputpathtofile (a$)
DECLARE FUNCTION SAVEfind (Path$)
DECLARE FUNCTION SAVEgetpath$ ()
CONST PROGRAMNAME = "QBFonts.BAS"
DIM SHARED SAVEDpath AS STRING
DIM SHARED BadPathName AS INTEGER

DECLARE SUB DEMOstart ()
DECLARE SUB DEMOfonttypes ()
DECLARE SUB DEMOlines ()
DECLARE SUB DEMOjustify ()
DECLARE SUB DEMOprintwrap ()
DECLARE SUB DEMOeffects ()
DIM SHARED justify AS INTEGER
DIM SHARED linecontinue AS INTEGER
DIM SHARED letterspacing AS INTEGER
DIM SHARED wordspacing AS INTEGER
DIM SHARED linespacing AS INTEGER
DIM SHARED currentfont AS INTEGER
DIM SHARED fontpath AS STRING
DIM SHARED modefound AS INTEGER
DIM SHARED toside AS INTEGER, below  AS INTEGER
DIM SHARED cursorX AS INTEGER, cursorY AS INTEGER
DIM SHARED forecolor AS INTEGER, backcolor AS INTEGER
DIM SHARED windowX1 AS INTEGER, windowX2 AS INTEGER
DIM SHARED windowY1 AS INTEGER, windowY2 AS INTEGER
DIM SHARED fontlines(10) AS INTEGER

GOTO SkipErrorHandler
ScreenModeFound:
    modefound = TRUE
    RESUME NEXT
BadPath:
  BadPathName = TRUE
  RESUME NEXT
SkipErrorHandler:

CLOSE
AAA.SAVEinitialise
QBFfontpath SAVEDpath   ' Attention: QBFfontpath seems to be buggy
                        ' ==> patched by  (c) Thomas Antoni 24.10.0
DEMOstart
DEMOfonttypes
DEMOlines
DEMOjustify
DEMOprintwrap
DEMOeffects
CLOSE
SCREEN 0
PRINT "That's all folks!"
PRINT "If you deam this program worthy PLEASE put it on your web site."
PRINT "This program was created by Bobby K,"
PRINT "  please give credit if you use this in your programs."
PRINT "E.Mail - christie@intonet.co.uk"
PRINT "Insanity Dreams homepage - Laz.home.ml.org"
PRINT "Check out the other programs in this package."

SUB AAA.SAVEinitialise
  'DO NOT DUPLICATE THE BELOW TEXT ANYWHERE IN YOUR
  'PROGRAM, IN EITHER CODE, LITERAL STRINGS OR REMARKS.
  'It could invalidate the SAVEpath subroutines, or
  'even cause the complete corruption of .exe files!
  a$ = "fInDwOrD@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
 
  DatPath$ = MID$(a$, 9, 50)
  FOR count = 1 TO 50
    IF MID$(DatPath$, count, 1) = "@" THEN
      DatPath$ = LEFT$(DatPath$, count - 1)
      EXIT FOR
    END IF
  NEXT count
  DatPath$ = LTRIM$(RTRIM$(DatPath$))
  IF SAVEfind(DatPath$ + "FINDER.DAT") THEN
    SAVEDpath = DatPath$
  ELSE
    DO
      a$ = SAVEgetpath$
      found = SAVEfind(a$ + "FINDER.DAT")
    LOOP UNTIL found
    PRINT "File located."
    PRINT "Searching for saver bytes.  Please wait."
    SAVEinputpathtofile a$
    SAVEDpath = a$
    PRINT "Bytes found and modified."
    COLOR 4
    PRINT "If this program is in .BAS form,"
    PRINT "It is advised that you reopen the program after the program has been run."
    PRINT "Do not save the program."
  END IF

END SUB

SUB DEMOeffects
  PALETTE 7, 0: PALETTE 8, 0: PALETTE 15, 0
  QBFselectfont 4
  QBFdefault
  QBFletterspacing 3
  QBFjustify CENTER
  QBFcolor 15, CTHRU
  QBFprint "Kewl effects!"
  QBFbackoneline 2, 2
  QBFcolor 8, CTHRU
  QBFprint "Kewl effects!"
  QBFbackoneline 1, -1
  QBFcolor 7, CTHRU
  QBFprint "Kewl effects!"
  PALETTE

  PALETTE 4, 0
  QBFselectfont 2
  QBFcolor 4, CTHRU
  QBFprint "(Made easy)"
  QBFbackoneline 2, 0
  QBFprint "(Made easy)"
  QBFbackoneline 2, 2
  QBFprint "(Made easy)"
  QBFbackoneline 0, 0
  QBFprint "(Made easy)"
  QBFbackoneline 1, -1
  QBFcolor 0, CTHRU
  QBFprint "(Made easy)"
  PALETTE

  PALETTE 1, 0
  QBFselectfont 5
  QBFcolor 1, CTHRU
  QBFprint "Good or what?!"
  QBFbackoneline 2, 2
  QBFcolor 0, CTHRU
  QBFprint "Good or what?!"
  PALETTE

  PALETTE 8, 0
  QBFcolor 8, CTHRU
  QBFselectfont 3
  QBFletterspacing -5
  QBFprint "Handwriting"
  PALETTE

  PALETTE 2, 0
  QBFselectfont 2
  QBFcolor 2, CTHRU
  QBFprint " BOLD "
  QBFbackoneline 1, 0
  QBFprint " BOLD "
  QBFbackoneline 1, 1
  QBFprint " BOLD "
  QBFbackoneline 0, 0
  QBFprint " BOLD "
  PALETTE 2, 40

  PALETTE 13, 0: PALETTE 14, 0
  QBFselectfont 3
  QBFcolor 13, CTHRU
  QBFprint "Outlined"
  QBFbackoneline 2, 0
  QBFprint "Outlined"
  QBFbackoneline 2, 2
  QBFprint "Outlined"
  QBFbackoneline 0, 0
  QBFprint "Outlined"
  QBFbackoneline 1, -1
  QBFcolor 14, CTHRU
  QBFprint "Outlined"
  PALETTE 13, 40
  PALETTE 14, 40 * 256 ^ 2

  PALETTE 10, 0: PALETTE 11, 0: PALETTE 12, 0
  QBFselectfont 5
  LINE (320 - 55, cursorY + linespacing - 5)-(320 + 55, cursorY + 2 * linespacing + 1), 12, BF
  LINE (320 - 54, cursorY + linespacing - 4)-(320 + 55, cursorY + 2 * linespacing + 1), 10, BF
  LINE (320 - 54, cursorY + linespacing - 4)-(320 + 54, cursorY + 2 * linespacing), 11, BF
  QBFcolor 12, CTHRU
  QBFprint " Raised "
  QBFbackoneline 2, 2
  QBFcolor 10, CTHRU
  QBFprint " Raised "
  QBFbackoneline 1, -1
  QBFcolor 11, CTHRU
  QBFprint " Raised "
  PALETTE 10, 20 + 20 * 256 + 20 * 256 ^ 2
  PALETTE 11, 40 + 40 * 256 + 40 * 256 ^ 2
  PALETTE 12, 60 + 60 * 256 + 60 * 256 ^ 2

  SLEEP: CLS
END SUB

SUB DEMOfonttypes
  cursorY = 0
  QBFselectfont 5: QBFcolor 4, CTHRU
  QBFprintwrap "A multitude of fonts available."
  QBFselectfont 4: QBFcolor 15, CTHRU
  QBFprintwrap "And all you have to do is"
  QBFselectfont 3: QBFcolor 1, CTHRU
  QBFprintwrap "create them with the QBF maker,"
  QBFselectfont 2: QBFcolor 2, CTHRU
  QBFprintwrap "or down load them."
  QBFselectfont 1: QBFcolor 8, CTHRU
  QBFprintwrap "How easy could it be?"
  SLEEP: CLS
END SUB

SUB DEMOjustify
  QBFdefault
  QBFcolor 1, CTHRU
  QBFjustify LEFT
  QBFprint "Left justified"
  QBFjustify CENTER
  QBFprint "Center justified"
  QBFjustify RIGHT
  QBFprint "Right justified"
  SLEEP: CLS
END SUB

SUB DEMOlines
  QBFselectfont 1
  QBFdefault
  QBFjustify CENTER
  QBFlinespacing linespacing - 5
  QBFlines.addline 30
  QBFlines.addline 32
  QBFprint "Underlining"
  QBFlines.removeall
  QBFlines.addline 20
  QBFlines.addline 21
  QBFlines.addline 22
  QBFprint "And strike thru"
  QBFlines.removeall
  QBFlines.addline 32
  QBFprint "Have been made easy to use"
  FOR n = 0 TO 34 STEP 2
    QBFlines.addline n
  NEXT n
  QBFprint "But don't use them excessivly!"
  QBFlines.removeall
  SLEEP: CLS
END SUB

SUB DEMOprintwrap
  QBFdefault
  QBFjustify LEFT
  QBFtextwindow 0, 0, 200, 479
  LINE (0, 0)-(200, 479), 15, B
  QBFlinespacing linespacing - 15
  QBFprintwrap "This is word wrap, you use it if you want text to stay in the window."

  QBFdefault
  QBFjustify CENTER
  QBFtextwindow 220, 0, 420, 479
  LINE (220, 0)-(420, 479), 15, B
  QBFlinespacing linespacing - 15
  QBFprintwrap "This is word wrap, you use it if you want text to stay in the window."

  QBFdefault
  QBFjustify RIGHT
  QBFtextwindow 439, 0, 639, 479
  LINE (439, 0)-(639, 479), 15, B
  QBFlinespacing linespacing - 15
  QBFprintwrap "This is word wrap, you use it if you want text to stay in the window."
  SLEEP: CLS
END SUB

SUB DEMOstart
  SCREEN 12
  QBFopen "lucidabl", 5
  QBFopen "msserif", 4
  QBFopen "lucidaha", 3
  QBFopen "impact", 2
  QBFopen "timesnew", 1
  QBFdefault
  QBFjustify CENTER
  QBFlinespacing linespacing - 15
  QBFprint "Welcome to"
  QBFprint "the QB fonts."
  QBFcolor 7, CTHRU
  QBFprint ""
  QBFprint "Quite possible the best QB font"
  QBFprint "application yet on the net!"
  QBFprint "Quick, easy to use windows"
  QBFprint "fonts in your programs!"
  QBFprintwrap "Now with the .QBF maker,"
  QBFprintwrap "word wrap, left/right/center justifiability,"
  QBFprintwrap "and a sub that remembers the path of your QBFs after your first use!"
  SLEEP: CLS
END SUB

SUB QBFbackoneline (Side, Down)
  cursorY = cursorY - linespacing
  toside = Side
  below = Down
END SUB

SUB QBFcolor (Fore, Back)
  forecolor = Fore
  backcolor = Back
END SUB

SUB QBFdefault
  QBFjustify LEFT
  QBFtextwindow DEFAULT, DEFAULT, DEFAULT, DEFAULT
  QBFcolor 15, CTHRU
  QBFlinespacing DEFAULT
  QBFwordspacing DEFAULT
  QBFletterspacing DEFAULT
END SUB

SUB QBFfontpath (Path$)
'Commented out (c) Thomas Antoni 24.10.00 ----  fontpath = Path$
fontpath = ""
'Commented out (c) Thomas Antoni 24.10.00 ----  IF LEFT$(fontpath, 1) <> "\" THEN fontpath = fontpath + "\"
END SUB

SUB QBFjustify (JustifyType)
  IF JustifyType = LEFT OR JustifyType = CENTER OR JustifyType = RIGHT THEN
    justify = JustifyType
  ELSEIF JustifyType = DEFAULT THEN
    justify = LEFT
  END IF
END SUB

FUNCTION QBFlength (text$)
  GET currentfont, 1, lpi%
  ws% = wordspacing
  ls% = letterspacing
  p% = 0
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET currentfont, m%, a1%
      GET currentfont, m% + 1, a2%
      FOR n% = a1% TO a2% - 1 STEP lpi%
        p% = p% + 1
      NEXT n%
      p% = p% + ls%
    ELSE
      p% = p% + ws%
    END IF
  NEXT count%
  QBFlength = p%
END FUNCTION

SUB QBFletterspacing (Spacing)
  IF Spacing = DEFAULT THEN
    GET currentfont, 3, Spacing%
    letterspacing = Spacing%
  ELSE
    letterspacing = Spacing
  END IF
END SUB

SUB QBFlines.addline (Row)
  AnInteger% = Row
  HowFarDown = INT((AnInteger%) / 16)
  AnInteger% = AnInteger% MOD 16
  IF AnInteger% > 0 THEN
    Bit = 2 ^ (15 - AnInteger%)
  ELSE
    Bit = -32768
  END IF
  fontlines(HowFarDown) = fontlines(HowFarDown) OR Bit
END SUB

SUB QBFlines.removeall
  FOR HowFarDown = 0 TO 10
    fontlines(HowFarDown) = 0
  NEXT HowFarDown
END SUB

SUB QBFlines.removeline (Row)
  AnInteger% = Row
  HowFarDown = INT((AnInteger% - 1) / 16)
  AnInteger% = AnInteger% MOD 16
  IF AnInteger% > 0 THEN
    Bit = 2 ^ (15 - AnInteger%)
  ELSE
    Bit = -32768
  END IF
  fontlines(HowFarDown) = fontlines(HowFarDown) AND (NOT Bit)
END SUB

SUB QBFlinespacing (Spacing)
  IF Spacing >= 0 THEN
    linespacing = Spacing
  ELSEIF Spacing = DEFAULT THEN
    GET currentfont, 1, Spacing%
    linespacing = Spacing% * 16
  END IF
END SUB

SUB QBFnewline (text$)
  cursorY = cursorY + linespacing
  SELECT CASE justify
  CASE LEFT
    cursorX = windowX1
  CASE CENTER
    average = (windowX1 + windowX2) / 2
    cursorX = average - QBFlength(text$) / 2
  CASE RIGHT
    cursorX = windowX2 - QBFlength(text$)
  END SELECT
  IF toside <> 0 THEN
    cursorX = cursorX + toside
    toside = 0
  END IF
  IF below <> 0 THEN
    cursorY = cursorY + below
    below = 0
  END IF
END SUB

SUB QBFopen (font$, File)
  currentfont = File
  CLOSE File
  font$ = fontpath + font$ + ".qbf"
  OPEN font$ FOR RANDOM AS File LEN = 2
  GET currentfont, 1, Spacing%
  linespacing = Spacing% * 16
  GET currentfont, 2, Spacing%
  wordspacing = Spacing%
  GET currentfont, 3, Spacing%
  letterspacing = Spacing%
END SUB

SUB QBFprint (text$)
  IF linecontinue = FALSE THEN QBFnewline (text$)
  GET currentfont, 1, lpi%
  ws% = wordspacing
  ls% = letterspacing
  p% = cursorX
  linecontinue = FALSE
  IF RIGHT$(text$, 1) = "~" THEN
    text$ = LEFT$(text$, LEN(text$) - 1)
    linecontinue = TRUE
  END IF
  IF LEN(text$) = 0 THEN EXIT SUB
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET currentfont, m%, a1%
      GET currentfont, m% + 1, a2%
      FOR n% = a1% TO a2% - 1 STEP lpi%
        FOR z% = 0 TO lpi% - 1
          GET currentfont, n% + z%, l%
          IF forecolor > -1 THEN
            LINE (p%, (16 * z%) + cursorY)-(p%, (16 * z%) + 15 + cursorY), forecolor, , l% OR fontlines(z%)
          END IF
          IF backcolor > -1 THEN
            LINE (p%, (16 * z%) + cursorY)-(p%, (16 * z%) + 15 + cursorY), backcolor, , NOT ((l% OR fontlines(z%)))
          END IF
        NEXT z%
        p% = p% + 1
      NEXT n%
      FOR z% = 0 TO lpi% - 1
        IF forecolor > -1 THEN LINE (p%, (16 * z%) + cursorY)-(p%, (16 * z%) + 15 + cursorY), forecolor, , l% OR fontlines(z%)
        IF backcolor > -1 THEN LINE (p%, (16 * z%) + cursorY)-(p%, (16 * z%) + 15 + cursorY), backcolor, , NOT fontlines(z%)
      NEXT z%
      p% = p% + ls%
    ELSE
      IF backcolor > -1 THEN LINE (p%, cursorY)-(p% + ws% - 1, (16 * lpi%) - 1 + cursorY), backcolor, BF, NOT (l%)
      IF forecolor > -1 THEN
        FOR temp% = p% TO p% + ws%
        FOR z% = 0 TO lpi% - 1
          LINE (temp%, (16 * z%) + cursorY)-(temp%, (16 * z%) + 15 + cursorY), forecolor, , fontlines(z%)
        NEXT z%
        NEXT temp%
      END IF
      p% = p% + ws%
    END IF
  NEXT count%
  cursorX = p%
END SUB

SUB QBFprintwrap (text$)
  IF RIGHT$(text$, 1) = "~" THEN
    text$ = LEFT$(text$, LEN(text$) - 1)
    continuestatus = TRUE
  END IF
  windowwidth = windowX2 - windowX1
 
  DO
    buffer$ = text$
    DO UNTIL QBFlength(buffer$) <= windowwidth
      FOR count = LEN(buffer$) TO 1 STEP -1
        IF MID$(buffer$, count, 1) = " " THEN
          'FOR count2 = count TO 1 STEP -1
          '  IF MID$(buffer$, count2, 1) <> " " THEN
              buffer$ = RTRIM$(LEFT$(buffer$, count))
              EXIT FOR
          '  END IF
          'NEXT count2
        END IF
      NEXT count
    LOOP
    QBFprint buffer$
    newlength = LEN(text$) - LEN(buffer$)
    text$ = LTRIM$(RIGHT$(text$, newlength))
  LOOP UNTIL LEN(text$) = 0
  linecontinue = continuestatus
END SUB

SUB QBFselectfont (FontID)
  IF FontID < 1 THEN EXIT SUB
  GET currentfont, 1, Spacing%
  linespacing = Spacing% * 16
  GET currentfont, 2, Spacing%
  wordspacing = Spacing%
  GET currentfont, 3, Spacing%
  letterspacing = Spacing%
  currentfont = FontID
END SUB

SUB QBFtextwindow (x1, y1, x2, y2)
  ON ERROR GOTO ScreenModeFound
  IF x1 = DEFAULT THEN x1 = 0
  IF y1 = DEFAULT THEN y1 = 0
  IF x2 = DEFAULT OR y2 = DEFAULT THEN
    DIM a(0 TO 2) AS INTEGER
    a(0) = 1: a(1) = 1: a(2) = 0
    modefound = FALSE
    mode = 0: PUT (0, 0), a, XOR: IF modefound THEN GOTO found
    mode = 7: PUT (320, 0), a, XOR: IF modefound THEN GOTO found
    mode = 8: PUT (0, 200), a, XOR: IF modefound THEN GOTO found
    mode = 9: PUT (0, 350), a, XOR: IF modefound THEN GOTO found
    mode = 12
found:
    SELECT CASE mode
    CASE 0:  STOP                               'Incompatible mode
    CASE 7:  x2default = 319: y2default = 199   'Mode 7 or 13
    CASE 8:  x2default = 639: y2default = 199   'Mode 8
    CASE 9:  x2default = 639: y2default = 349   'Mode 9 or 10
    CASE 12: x2default = 639: y2default = 479   'Mode 11 or 12
    END SELECT
    IF x2 = DEFAULT THEN x2 = x2default
    IF y2 = DEFAULT THEN y2 = y2default
  END IF
  IF x1 > x2 THEN SWAP x1, x2
  IF y1 > y2 THEN SWAP y1, y2
  windowX1 = x1
  windowY1 = y1
  windowX2 = x2
  windowY2 = y2
  cursorY = windowY1
  SELECT CASE justify
  CASE LEFT
    cursorX = windowX1
  CASE CENTER
    average = (windowX1 + windowX2) / 2
    cursorX = average - QBFlength(text$) / 2
  CASE RIGHT
    cursorX = windowX2 - QBFlength(text$)
  END SELECT
END SUB

SUB QBFwordspacing (Spacing)
  IF Spacing >= 0 THEN
    wordspacing = Spacing
  ELSEIF Spacing = DEFAULT THEN
    GET currentfont, 2, Spacing%
    wordspacing = Spacing%
  END IF
END SUB

FUNCTION SAVEfind (Path$)
  SAVEfind = TRUE
  ON ERROR GOTO BadPath
  BadPathName = FALSE
  OPEN Path$ FOR RANDOM AS #1 LEN = 2
  IF BadPathName THEN
    SAVEfind = FALSE
    EXIT FUNCTION
  END IF
  IF LOF(1) = 0 THEN
    SAVEfind = FALSE
  ELSE
    CLOSE
    OPEN Path$ FOR INPUT AS #1
    LINE INPUT #1, header$
    IF header$ <> "Finder Header Text" THEN SAVEfind = FALSE
  END IF
  CLOSE
END FUNCTION

FUNCTION SAVEgetpath$
  CLS
  SCREEN 0
  COLOR 7
  PRINT "Could not find the .QBF files!"
  PRINT
  PRINT "Please include full path (e.g. D:\BobbyK\Fonts)"
  PRINT "Type q to quit"
  INPUT "Where do they reside"; a$
  IF a$ = "q" THEN SYSTEM
  IF LEFT$(a$, 1) <> "\" THEN a$ = a$ + "\"
  SAVEgetpath$ = a$
     
  IF LEN(a$) > 50 THEN
    PRINT "Damn!  Too long!"
    PRINT "Move the file to a path with a shorter name"
    SLEEP
    SYSTEM
  END IF

END FUNCTION

SUB SAVEinputpathtofile (a$)
  DIM singlebyte AS STRING * 1
  DIM byte(8) AS STRING * 1
  OPEN a$ + PROGRAMNAME FOR RANDOM AS #1 LEN = 1
  record = 0
  DO
    record = record + 1
    byte(8) = byte(7): byte(7) = byte(6): byte(6) = byte(5)
    byte(5) = byte(4): byte(4) = byte(3): byte(3) = byte(2)
    byte(2) = byte(1): GET #1, record, singlebyte: byte(1) = singlebyte
    IF byte(8) = "f" THEN
      IF byte(7) = "I" AND byte(6) = "n" AND byte(5) = "D" AND byte(4) = "w" AND byte(3) = "O" AND byte(2) = "r" AND byte(1) = "D" THEN
        FOR n = 1 TO LEN(a$)
          singlebyte = MID$(a$, n, 1)
          PUT #1, record + n, singlebyte
        NEXT n
        FOR n = LEN(a$) + 1 TO 50
          singlebyte = "@"
          PUT #1, record + n, singlebyte
        NEXT n
        EXIT SUB
      END IF
    END IF
  LOOP UNTIL EOF(1)
  PRINT "Unexpected error!"
  PRINT "The path you specified was located."
  PRINT "A file with the correct header text was also found."
  PRINT "However, it was not found to have any path saving bytes."
  SLEEP
  SYSTEM
  CLOSE
END SUB

