DECLARE SUB SchmalPrint3 (Zeichen%, Y%, X%)
DECLARE SUB SchmalPrint2 (Zeichen%, Y%, X%)
' **************************************************
' * SCHMAL.BAS: Schmalschrift-Anzeige fuer QBasic  *
' *                                                *
' * (c) c't Heft 6/91 www.heise.de, Harald Zoschke *
' **************************************************

DEFINT A-Z

DECLARE SUB SPrintString (Text$, Y, X)
DECLARE FUNCTION Hex2Dez (H$)
DIM SHARED Font$, x1, y1, FrbHG, FrbVG

'*** Laden des Zeichensatzes in Font$
'*** (vor Benutzung der Schmalschrift einmal aufrufen)

Font$ = SPACE$(900)

RESTORE FontData
FOR i = 0 TO 44
   READ HexZeile$
   FOR j = 1 TO 20
      MID$(Font$, i * 20 + j, 1) = CHR$(Hex2Dez(MID$(HexZeile$, (j - 1) * 3 + 1, 2)))
   NEXT j
NEXT i

'*** Verwendung der Schmalschrift (Beispiele)

SCREEN 9      'EGA 640 x 480  (zum Beispiel)
' SCREEN 3    'Hercules (zuvor MSHERC.COM bzw. QBHERC.COM laden!)
CLS

'*** Beispiel 1:

LOCATE 1, 3: PRINT "Alle ASCII-Zeichen von 32 bis 255:"
FrbHG = 0     'Farbe nicht gesetzter Pixel
FrbVG = 14    'Farbe gesetzter Pixel
X = 0         'Startposition der Anzeige
Y = 1
y1 = 10       'Schmalschrift-Zeilenabstand
x1 = 6        'Schmalschrift-Zeichenabstand

FOR Zeile = 1 TO 7          'ASCII-Zeichensatz (32-255) anzeigen
   FOR Stelle = 0 TO 31
      Zeichen = Zeile * 32 + Stelle
      X = X + 2
      CALL SchmalPrint3(Zeichen, Y + Zeile, X)
   NEXT Stelle
   X = 0
NEXT Zeile

'*** Beispiel 2: Der Zeichenabstand lt sich variieren

FrbHG = 0     'Farbe nicht gesetzter Pixel
FrbVG = 15    'Farbe gesetzter Pixel
y1 = 8
x1 = 8        'groer Zeichenabstand
CALL SPrintString("Groer Zeichenabstand", 16, 1)
x1 = 5        'kleinerer Zeichenabstand
CALL SPrintString("Kleinerer Zeichenabstand", 18, 2)
x1 = 4        'kleinster Zeichenabstand (Normal-Einstellung)
CALL SPrintString(" Kleinster Zeichenabstand", 20, 2)
SPrintString STRING$(160, "A"), 13, 2

'Invertieren (Negativ-Schrift) durch Tauschen der Farben:
FrbHG = 15     'Farbe eines nicht gesetzten Pixels
FrbVG = 0      'Farbe eines gesetzten Pixels

' (wie man sieht, kann der Text natrlich auch eine Variable sein):
Text$ = " Negativ-Schrift "
CALL SPrintString(Text$, 20, 35)

'*** Beispiel 3: Zeitanzeige in einer simulierten LED-Uhr

CIRCLE (511, 54), 30, 7         'Uhren-Gehuse zeichnen
CIRCLE (509, 52), 30, 3
PAINT (509, 52), 3
y1 = 8
x1 = 4
FrbHG = 3
FrbVG = 0
CALL SPrintString("Ŀ", 5, 120)
CALL SPrintString("          ", 6, 120)
CALL SPrintString("", 7, 120)

FrbHG = 0                       'Zeit anzeigen...
FrbVG = 12
DO                              '...bis eine Taste gedrckt wird
   CALL SPrintString(" " + TIME$ + " ", 6, 121)
LOOP UNTIL LEN(INKEY$)
SCREEN 0                        'zurck zum Textbildschirm

'*** Schmalschrift-Zeichensatztabelle

FontData:
DATA "41 00 00 00 00 00 FA 00 00 E0 00 E0 00 FF 24 FF 00 24 D6 48"
DATA "00 86 38 C2 00 FE CC 14 00 20 40 80 00 38 44 82 00 82 44 38"
DATA "00 54 38 54 00 10 7C 10 00 05 06 00 00 10 10 10 00 06 06 00"
DATA "00 06 38 C0 00 7C 82 7C 00 20 40 FE 00 CE 92 72 00 44 92 6C"
DATA "00 1E 62 87 00 E2 A2 9C 00 7C 92 8C 00 86 88 F0 00 6C 92 6C"
DATA "00 62 92 7C 00 00 24 00 00 05 16 00 00 10 28 44 00 28 28 28"
DATA "00 44 28 10 00 40 8A 70 00 3A EE B8 00 7E 90 7E 00 FE 92 6C"
DATA "00 7C 82 82 00 FE 82 7C 00 FE 92 82 00 FE 90 80 00 7C 92 5C"
DATA "00 FE 10 FE 00 82 FE 82 00 02 01 FE 00 FE 10 EE 00 FE 02 02"
DATA "00 FE 60 FE 00 FE 38 FE 00 FE 82 FE 00 FE 90 60 00 7C 86 7A"
DATA "00 FE 90 6E 00 64 92 4C 00 80 FE 80 00 FE 02 FE 00 FC 02 FC"
DATA "00 FE 0C FE 00 EE 10 EE 00 F0 0E F0 00 8E 92 E2 00 00 FE 82"
DATA "00 C0 38 06 00 82 FE 00 00 40 80 40 00 02 02 02 00 80 40 20"
DATA "00 2E 2A 1E 00 FE 22 1C 00 1C 22 22 00 1C 22 FE 00 1C 2A 1A"
DATA "00 10 7E 90 00 19 25 3E 00 FE 20 1E 00 10 5E 00 00 02 11 5E"
DATA "00 FE 08 16 00 80 FE 00 00 3E 38 1E 00 3E 1E 00 00 1C 22 1C"
DATA "00 3F 24 18 00 18 24 3F 00 3E 20 10 00 12 2A 24 00 FC 22 22"
DATA "00 3E 02 3E 00 3C 02 3C 00 3E 0C 3E 00 36 08 36 00 39 05 3E"
DATA "00 26 2A 32 00 10 6C 82 00 00 EE 00 00 82 6C 10 00 18 10 30"
DATA "00 0E 12 12 0E 7C 82 83 00 5E 02 5E 00 1C 2A 5A 80 6E AA 5E"
DATA "00 AE 2A 9E 00 AE AA 1E 00 2E EA 1E 00 1C 22 23 00 5C AA 5A"
DATA "00 5C 2A 5A 00 5C 6A 1A 00 50 1E 40 00 50 9E 40 00 90 5E 00"
DATA "00 BE 50 BE 00 1E A8 1E 00 3E 6A A2 00 3A 1C 2E 00 3E 50 7E"
DATA "52 5C A2 5C 00 9C 22 9C 00 9C 62 1C 00 5E 82 5E 00 9E 42 1E"
DATA "00 B9 05 BE 00 BE 22 BE 00 BE 02 BE 00 3C E7 24 00 FE D2 06"
DATA "00 D4 3E D4 00 FE A0 5E 0A 11 FF 90 00 2E 6A 9E 00 10 5E 80"
DATA "00 1C 62 9C 00 1E 42 9E 00 BE 9E 00 00 BE 9C BE 00 E8 E8 28"
DATA "00 E8 A8 E8 00 0C B2 04 00 1C 10 10 00 10 10 1C 00 66 38 CC"
DATA "04 66 38 E2 06 00 BE 00 00 28 10 28 10 10 28 10 28 AA 55 AA"
DATA "55 AA AA 55 55 FF 55 FF 55 00 FF 00 00 08 FF 00 00 18 FF 00"
DATA "00 08 FF FF 00 08 0F 0F 00 18 1F 00 00 18 FF FF 00 00 FF FF"
DATA "00 18 1F 1F 00 18 F8 F8 00 08 F8 F8 00 18 F8 00 00 08 0F 00"
DATA "00 00 F8 08 08 08 F8 08 08 08 0F 08 08 00 FF 08 08 08 08 08"
DATA "08 08 FF 08 08 00 FF 18 18 00 FF FF 08 00 F8 F8 18 00 1F 1F"
DATA "18 18 F8 F8 18 18 1F 1F 18 00 FF FF 18 18 18 18 18 18 FF FF"
DATA "18 18 F8 18 18 08 F8 F8 08 18 1F 18 18 08 0F 0F 08 00 F8 F8"
DATA "08 00 F8 18 18 00 1F 18 18 00 0F 0F 08 08 FF FF 08 18 FF 18"
DATA "18 08 F8 00 00 00 0F 08 08 FF FF FF FF 0F 0F 0F 0F FF FF 00"
DATA "00 00 00 FF FF F0 F0 F0 F0 3E 3E 1C 22 3F 54 28 00 7E 40 60"
DATA "00 3E 20 3E 20 C6 BA 92 00 1C 22 3C 20 3F 08 38 00 20 1E 20"
DATA "00 BA C6 BA 00 7C 92 7C 00 F6 88 F6 00 CE AA 9E 00 0C 0C 0C"
DATA "00 1D 36 5C 00 7C 92 82 00 7C 40 7C 00 54 54 54 00 24 74 24"
DATA "00 54 24 24 00 24 24 54 00 00 7F 60 00 06 FE 00 00 08 2A 08"
DATA "00 14 28 14 28 40 A0 40 00 00 18 00 00 00 08 00 00 18 0E F0"
DATA "80 F0 80 70 00 B0 90 50 00 00 18 18 00 00 00 00 00 00 00 00"
'Die letzten drei "00" dienen nur zum Auffuellen (siehe Text)


DEFINT A-Z



'*** Hexadezimalzahl (String) in Dezimalwert wandeln
FUNCTION Hex2Dez (H$)
D = 0
FOR i = 1 TO LEN(H$)
   z = ASC(MID$(H$, i))
   z = z - 48 - 7 * INT((z - 48) / 17)
   D = D * 16 + z
NEXT i
Hex2Dez = D
END FUNCTION

SUB SchmalPrint1 (Zeichen, Y, X)
'*** Ein Schmalschrift-Zeichen auf dem Bildschirm ausgeben
'*** Methode 1:
'*** Verarbeitung der acht Spalten-Bits in einer Schleife

Zeichen = Zeichen - 32           'nur ASCII > 32 verwenden
ZE = Zeichen * 4 + 1             'Offset in den String Font: Ab hier
                                 'bilden 4 Spalten-Bytes ein Zeichen

'Die vier Pixelreihen eines Zeichens ermitteln und ausgeben
FOR Byte = 1 TO 4
   A = ASC(MID$(Font$, ZE + Byte, 1))
 
   'A = 255 - A                  'hiermit wre Invertieren mglich
                                 ' (ggf. REM-Zeichen entfernen)
 
   FOR Bit = 0 TO 7
      IF (A AND 2 ^ Bit) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG
      Spalte = X * x1 + Byte: Zeile = Y * y1 + 7 - Bit
      PSET (Spalte, Zeile), Frb
   NEXT Bit

NEXT Byte

END SUB

SUB SchmalPrint2 (Zeichen, Y, X)

'*** Ein Schmalschrift-Zeichen auf dem Bildschirm ausgeben
'*** Methode 2:
'*** Fr jedes Bit einer Zeichen-Spalte eine eigene Befehlsfolge

Zeichen = Zeichen - 32           'nur ASCII > 32 verwenden
ZE = Zeichen * 4 + 1             'Offset in den String Font$: Ab hier
                                 'bilden 4 Spalten-Bytes ein Zeichen

'Die vier Pixelreihen eines Zeichens ermitteln und ausgeben
FOR Byte = 1 TO 4
   A = ASC(MID$(Font$, ZE + Byte, 1))
 
   'A = 255 - A                  'hiermit wre Invertieren mglich
                                ' (ggf. REM-Zeichen entfernen)

   IF (A AND 128) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG    'Bit 7
   Spalte = X * x1 + Byte: Zeile = Y * y1
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 64) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG     'Bit 6
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 1
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 32) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG     'Bit 5
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 2
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 16) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG     'Bit 4
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 3
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 8) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG      'Bit 3
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 4
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 4) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG      'Bit 2
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 5
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 2) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG      'Bit 1
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 6
   PSET (Spalte, Zeile), Frb
 
   IF (A AND 1) <> 0 THEN Frb = FrbVG ELSE Frb = FrbHG      'Bit 0
   Spalte = X * x1 + Byte: Zeile = Y * y1 + 7
   PSET (Spalte, Zeile), Frb

NEXT Byte

END SUB

SUB SchmalPrint3 (Zeichen, Y, X)

'*** Ein Schmalschrift-Zeichen auf dem Bildschirm ausgeben
'*** Methode 3:
'*** Nutzung des LINE-Befehls zur Bitmuster-Ausgabe

Zeichen = Zeichen - 32           'nur ASCII > 32 verwenden
ZE = Zeichen * 4 + 1             'Offset in den String Font$: Ab hier
                                 'bilden 4 Bytes ein Zeichen)

'Die vier Pixelreihen eines Zeichens ermitteln und ausgeben
FOR Byte = 1 TO 4
   A& = ASC(MID$(Font$, ZE + Byte, 1))
 
   ' A& = 255 - A&               'hiermit wre Invertieren mglich
                                  ' (ggf. REM-Zeichen entfernen)
 
   Muster& = 256 * A&             'Bitmuster in die hhere Hlfte der
   IF Muster& > 32767 THEN        'Variablen, die wir als Struktur-
      M = Muster& - 65536         'Parameter fr LINE verwenden
   ELSE
      M = Muster&
   END IF
 
   'DIESE Zeile nur freischalten, wenn der Hintergrund bercksichtigt werden
   'mu, z.B. wenn bereits vorhandene Schmalschrift berschrieben werden soll
   LINE (X * x1 + Byte, Y * y1)-(X * x1 + Byte, Y * y1 + 7), FrbHG
 
   LINE (X * x1 + Byte, Y * y1)-(X * x1 + Byte, Y * y1 + 7), FrbVG, , M

NEXT Byte

END SUB

'*** Textstring als Schmalschrift-Zeichen auf dem Bildschirm ausgeben
SUB SPrintString (Text$, Y, X)
X2 = X 'Um den Wert von X zu bewahren
FOR Stelle = 1 TO LEN(Text$)
  Zeichen = ASC(MID$(Text$, Stelle, 1))
  X2 = X2 + 1
  CALL SchmalPrint2(Zeichen, Y, X2)
NEXT Stelle
END SUB

