'** SORTZCH.BAS
'** Ermittelt die Hufigkeit der verschiedenen Zeichen in einer ASCII-Datei
'** und stellt sie als Statistik und nach Hufigkeit geordnet dar
'** Autor:      Roland Heer
'** Sprache:    QBasic
'** Stand:      20.10.96
'** Freeware
'----------------------------------------------------------------------------
DEFINT A-Z
DECLARE SUB Initialisiere ()
DECLARE SUB Quicksort (Klein, Gross)
DECLARE SUB Statistik ()
DECLARE SUB ZeichneDia ()

TYPE SortType
	Laenge AS INTEGER           'Balkenlnge (das zu vergleichende Element)
	Balken AS STRING * 70       'Der Balken (Zeichenkette mit 70 Zeichen)
	Text AS STRING * 8          'Der zum Balken gehrige Text
END TYPE

DIM SHARED SortDatFeld(50) AS SortType
DIM SHARED MaxZeile, Sortfeld(32)
 
	CALL Statistik
	CALL Initialisiere
	CALL Quicksort(0, MaxZeile)
	CALL ZeichneDia
	SLEEP
	WIDTH 80, 25

SYSTEM

SUB Initialisiere

	WIDTH 80, 43

	FOR i = 0 TO MaxZeile
		SortDatFeld(i).Laenge = Sortfeld(i)
		SortDatFeld(i).Balken = STRING$(Sortfeld(i), 220)
		SortDatFeld(i).Text = CHR$(i + 64) + " " + CHR$(i + 96)
	NEXT i
	SortDatFeld(0).Text = "Leerz."
	SortDatFeld(27).Text = "Umlaute"
	SortDatFeld(28).Text = ""
	SortDatFeld(29).Text = "Ziffern"
	SortDatFeld(30).Text = ".,:;!?"
	SortDatFeld(31).Text = "-()" + CHR$(34)
	SortDatFeld(32).Text = "SonderZ"

	CLS
	FOR i = 0 TO MaxZeile
		LOCATE i + 2, 2
		PRINT SortDatFeld(i).Text; SortDatFeld(i).Balken
	NEXT i
	LOCATE 34, 48: PRINT " Statistik: Eine Taste drcken!";
	SLEEP

END SUB

SUB Quicksort (Klein, Gross)

	IF Klein < Gross THEN
		IF Gross - Klein = 1 THEN
			IF SortDatFeld(Klein).Laenge > SortDatFeld(Gross).Laenge THEN
				SWAP SortDatFeld(Klein), SortDatFeld(Gross)
			END IF
		ELSE
			AnfIndex = (Gross + Klein) \ 2
			SWAP SortDatFeld(Gross), SortDatFeld(AnfIndex)
			TeilStck = SortDatFeld(Gross).Laenge
			DO
				i = Klein: j = Gross
				DO WHILE (i < j) AND (SortDatFeld(i).Laenge <= TeilStck)
					i = i + 1
				LOOP
				DO WHILE (i < j) AND (SortDatFeld(j).Laenge >= TeilStck)
					j = j - 1
				LOOP
				IF i < j THEN
					SWAP SortDatFeld(i), SortDatFeld(j)
				END IF
			LOOP WHILE i < j
			SWAP SortDatFeld(i), SortDatFeld(Gross)
			IF (i - Klein) < (Gross - i) THEN
				Quicksort Klein, i - 1
				Quicksort i + 1, Gross
			ELSE
				Quicksort i + 1, Gross
				Quicksort Klein, i - 1
			END IF
		END IF
	END IF

END SUB

SUB Statistik
   
	DIM statist(64 TO 123)

	CLS
	VIEW PRINT
   
	LOCATE 2
	PRINT TAB(13); "Ŀ"
	PRINT TAB(13); "                                                       "
	PRINT TAB(13); "          ZEICHENHUFIGKEIT VON ASCII-DATEIEN          "
	PRINT TAB(13); "                                                       "
	PRINT TAB(13); "               Autor: Roland Heer (c) 1995             "
	PRINT TAB(13); "                                                       "
	PRINT TAB(13); ""
  
   
	LOCATE 10, 14
	INPUT "[Pfad\] Datei: ", d$
	LOCATE 11, 14
	PRINT "Datei wird gelesen ... "
	OPEN d$ FOR INPUT AS #1
	DO
		LINE INPUT #1, zeile$
		l = LEN(zeile$)
		n& = n& + l
		FOR i = 1 TO l
			a = ASC(MID$(zeile$, i, 1))
			SELECT CASE a
			CASE 32
				statistL& = statistL& + 1
			CASE 48 TO 57
				statistZ = statistZ + 1
			CASE 65 TO 90, 97 TO 122
				statist(a) = statist(a) + 1
			CASE 129, 132, 142, 148, 153, 154
				statistU = statistU + 1
			CASE 33, 44, 46, 58, 59, 63
				statistSA = statistSA + 1
			CASE 34, 174, 175, 40, 41, 45
				statistKL = statistKL + 1
			CASE 225
				statistSZ = statistSZ + 1
			CASE ELSE
				statistSO = statistSO + 1
			END SELECT
		NEXT i
	LOOP UNTIL EOF(1)
	CLOSE
	CLS
	PRINT
	PRINT " Zeichen insges.:"; n&
	PRINT " Groe Buchstaben: A,B,C..."
	FOR i = 65 TO 90
		PRINT " "; CHR$(i); ":"; statist(i),
	NEXT i
	PRINT
	PRINT " Kleine Buchstaben: a,b,c..."
	FOR i = 97 TO 122
		PRINT " "; CHR$(i); ":"; statist(i),
	NEXT i
	PRINT
	PRINT " Umlaute:"; TAB(20); statistU
	PRINT " :"; TAB(20); statistSZ
	PRINT " Ziffern 0 ... 9:"; TAB(20); statistZ
	PRINT " Leerzeichen:"; TAB(20); statistL&
	PRINT " .,:;!?"; TAB(20); statistSA
	PRINT " -()" + CHR$(34); TAB(20); statistKL
	PRINT " Sonstige Zeichen:"; TAB(20); statistSO
	PRINT
	PRINT TAB(48); " Diagramm: Eine Taste drcken!";

	FOR i = 1 TO 26
		Sortfeld(i) = statist(i + 64) + statist(i + 96)
		IF Sortfeld(i) > max THEN max = Sortfeld(i)
	NEXT i
	Sortfeld(0) = statistL&                             'Leerzeichen
	IF Sortfeld(0) > max THEN max = Sortfeld(0)
	Sortfeld(27) = statistU                             'Umlaute
	IF Sortfeld(27) > max THEN max = Sortfeld(27)
	Sortfeld(28) = statistSZ                            '
	IF Sortfeld(28) > max THEN max = Sortfeld(28)
	Sortfeld(29) = statistZ                             'Ziffern
	IF Sortfeld(29) > max THEN max = Sortfeld(29)
	Sortfeld(30) = statistSA                            '.,:;!?
	IF Sortfeld(30) > max THEN max = Sortfeld(30)
	Sortfeld(31) = statistKL                            '-()"
	IF Sortfeld(31) > max THEN max = Sortfeld(31)
	Sortfeld(32) = statistSO                            'Sonderzeichen
	IF Sortfeld(32) > max THEN max = Sortfeld(32)

	FOR i = 0 TO 32
		Sortfeld(i) = CINT(70& * Sortfeld(i) / max)
	NEXT i
	MaxZeile = 32
	SLEEP

END SUB

SUB ZeichneDia

	FOR i = 32 TO 0 STEP -1
		LOCATE 34 - i, 2
		PRINT SortDatFeld(i).Text; SortDatFeld(i).Balken
	NEXT i

END SUB

