// AIQView.cpp : Implementierung der Klasse CAIQView
//

#include "stdafx.h"
#include "AIQ.h"

#include "AIQDoc.h"
#include "AIQView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAIQView

IMPLEMENT_DYNCREATE(CAIQView, CView)

BEGIN_MESSAGE_MAP(CAIQView, CView)
	//{{AFX_MSG_MAP(CAIQView)
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_SETZEN_START, OnSetzenStart)
	ON_COMMAND(ID_SETZEN_ZIEL, OnSetzenZiel)
	ON_COMMAND(ID_SETZEN_HINDERNISSE, OnSetzenHindernisse)
	ON_BN_CLICKED(IDC_SetStart, OnSetzenStart)
	ON_BN_CLICKED(IDC_SetTarget, OnSetzenZiel)
	ON_BN_CLICKED(IDC_BUTTON3, OnSetzenHindernisse)
	//}}AFX_MSG_MAP
	// Standard-Druckbefehle
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAIQView Konstruktion/Destruktion

CAIQView::CAIQView()
{
	// 10 Brushes vorbereiten zur Darstellung der Hhenstufen
	for (int i= 0; i<10; i++)
	{
		Brushes[i].CreateSolidBrush(RGB(i*25,i*25,i*25));
	}
	// Brush fr Weg vorbereiten
	WayBrush.CreateSolidBrush(RGB(0,0,255));
	// Brush fr Hindernisse vorbereiten
	ObstacleBrush.CreateSolidBrush(RGB(255,0,255));
	// Flag initialisieren
	fFlag = 0;
}

CAIQView::~CAIQView()
{
}

BOOL CAIQView::PreCreateWindow(CREATESTRUCT& cs)
{
	// ZU ERLEDIGEN: ndern Sie hier die Fensterklasse oder das Erscheinungsbild, indem Sie
	//  CREATESTRUCT cs modifizieren.

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAIQView Zeichnen

void CAIQView::OnDraw(CDC* pDC)
{
	CAIQDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	CRect rect;
	int cx, cy, x, y;

	// Ausmae des Views ermitteln und Ausgabe skalieren
	GetClientRect(rect);
	cx = rect.right / WORLDX;
	cy = rect.bottom / WORLDY;

	// Zeichnen der Welt
	for (x=0; x < WORLDX; x++)
		for (y=0; y < WORLDY; y++)
		{
			int height = pDoc->World[x][y];
			if (height < 9)
			{
				pDC ->FillRect(CRect(x * cx + 1, y * cy + 1, 
									(x + 1) * cx, (y + 1) * cy), 
									&Brushes[height]);
			}
			else
			{
				if (height <199)
				{
					// height kennzeichnet einen gefundenen Pfad
					// zeichne Weg blau ein
					pDC ->FillRect(CRect(x * cx + 1, y * cy + 1, 
										(x + 1) * cx, (y + 1) * cy), 
										&WayBrush);
				}
				else
				{
					// Sehr hohes Hindernis
					pDC->FillRect(CRect(x * cx + 1, y * cy + 1, 
										(x + 1) * cx, (y + 1) * cy), 
										&ObstacleBrush);
				}
			}
		}

	// Zeichnen der Start und Zielkoordinaten
	CPen startpen, targetpen, *pOldPen;
	CBrush *drawBrush, *pOldBrush;
	// nur zeichnen, wenn gesetzt
	if (pDoc->Start.x != -1 && pDoc->Start.y != -1) 
	{
		// Startpunkt ist grn
		startpen.CreatePen(PS_SOLID, 2, RGB(0, 128, 0));
		pOldPen = pDC->SelectObject(&startpen);
		drawBrush = &Brushes[pDoc->World[pDoc->Start.x][pDoc->Start.y]];
		pOldBrush = pDC->SelectObject(drawBrush);
		pDC->Rectangle((pDoc->Start.x) * cx + 1, (pDoc->Start.y) * cy + 1,
					   (pDoc->Start.x + 1) * cx + 1, (pDoc->Start.y + 1) * cy + 1);
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}
	// nur Zeichnen, wenn gesetzt
	if (pDoc->Target.x != -1 && pDoc->Target.y != -1)
	{
		// Zielpunkt ist rot
		targetpen.CreatePen(PS_SOLID, 2, RGB(128, 0, 0));
		pOldPen = pDC->SelectObject(&targetpen);
		drawBrush = &Brushes[pDoc->World[pDoc->Target.x][pDoc->Target.y]];
		pOldBrush = pDC->SelectObject(drawBrush);
		pDC->Rectangle((pDoc->Target.x) * cx + 1, (pDoc->Target.y) * cy + 1,
					   (pDoc->Target.x + 1) * cx + 1, (pDoc->Target.y + 1) * cy + 1);
		pDC->SelectObject(pOldBrush);	
		pDC->SelectObject(pOldPen);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CAIQView Drucken


BOOL CAIQView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// Standardvorbereitung
	return DoPreparePrinting(pInfo);
}

void CAIQView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// ZU ERLEDIGEN: Zustzliche Initialisierung vor dem Drucken hier einfgen
}

void CAIQView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// ZU ERLEDIGEN: Hier Bereinigungsarbeiten nach dem Drucken einfgen
}

/////////////////////////////////////////////////////////////////////////////
// CAIQView Diagnose

#ifdef _DEBUG
void CAIQView::AssertValid() const
{
	CView::AssertValid();
}

void CAIQView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAIQDoc* CAIQView::GetDocument() // Die endgltige (nicht zur Fehlersuche kompilierte) Version ist Inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAIQDoc)));
	return (CAIQDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAIQView Nachrichten-Handler

void CAIQView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CView::OnLButtonUp(nFlags, point);

	CAIQDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CRect rect;
	int cx, cy;

	// Array-Koordinaten des angeklickten Weltfeldes errechnen
	GetClientRect(rect);
	cx = rect.right / WORLDX;
	cy = rect.bottom / WORLDY;

	if (fFlag == SETSTART)
	{
		// Startposition setzen
		pDoc->Start.x = point.x / cx;
		pDoc->Start.y = point.y / cy;
		// Flag zurcksetzen
		fFlag = 0;
	}
	else
	{
		if (fFlag == SETTARGET)
		{
			// Zielposition setzen
			pDoc->Target.x = point.x / cx;
			pDoc->Target.y = point.y / cy;
			// Flag zurcksetzen
			fFlag = 0;
		}
		else
		{
			// Wird die linke Maustaste ber der Welt gedrckt und losgelassen,
			// wird die Welt an dieser Stelle um eine Hhenstufe angehoben

			pDoc->RaiseWorld(point.x / cx, point.y / cy);
		}
	}
	if (fFlag == SETOBSTACLE)
	{
		// Groe Hindernisse (3x3 Felder) zeichnen
		int a = point.x / cx;
		int b = point.y / cy;
		pDoc->World[a][b] = 200;
		pDoc->World[a-1][b] = 200;
		pDoc->World[a-1][b-1] = 200;
		pDoc->World[a][b-1] = 200;
		pDoc->World[a+1][b-1] = 200;
		pDoc->World[a+1][b] = 200;
		pDoc->World[a+1][b+1] = 200;
		pDoc->World[a][b+1] = 200;
		pDoc->World[a-1][b+1] = 200;
		// Flag zurcksetzen
		fFlag = 0;
	}

	// Neuzeichnen der Welt veranlassen
	Invalidate();
}

void CAIQView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// Wird die rechte Maustaste ber der Welt gedrckt und losgelassen,
	// wird die Welt an dieser Stelle um eine Hhenstufe abgesenkt
	CAIQDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CRect rect;
	int cx, cy;

	// Array-Koordinaten des angeklickten Weltfeldes errechnen
	GetClientRect(rect);
	cx = rect.right / WORLDX;
	cy = rect.bottom / WORLDY;

	pDoc->LowerWorld(point.x / cx, point.y / cy);
	Invalidate();
	
	CView::OnRButtonUp(nFlags, point);
}

void CAIQView::OnSetzenStart() 
{
	// Flag setzen fr "Setze Startposition"
	fFlag = SETSTART;
	// Eigentliches Setzen der Startposition erfolgt in Behandlung des MouseUp-Ereignisses
	
}

void CAIQView::OnSetzenZiel() 
{
	// Flag setzen fr "Setze Zielposition"
	fFlag = SETTARGET;
	// Eigentliches Setzen der Zielposition erfolgt in Behandlung des MouseUp-Ereignisses
}

void CAIQView::OnSetzenHindernisse() 
{
	// Flag setzen fr "Setze Hindernisse";
	fFlag = SETOBSTACLE;
	// Eigentliches Setzen des Hindernisses erfolgt in Behandlung des MouseUp-Ereignisses
}
