'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........DBASM / Kapitel 3.4.3
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........9.1.2002
' Beschreibung:   Dieses Programm benutzt zum grten Teil Assembler-Routinen
'                 die sie in der Datei DB.asm finden. Bevor sie das Programm
'                 ausfhren knnen mssen sie Qbasic mit der Bibliothek DB.QLB
'                 starten (Qb /l db.qlb). Fr das Zeichnen von ausgefllten
'                 Dreiecken wurde eine neue Routine eingefhrt, die nur hori-
'                 zontale Linien zeichnet. Durch die bersetzung der Routine
'                 in Maschinensprache, gewinnt die Routine DrawTriangle an
'                 Geschwindigkeit.
'                 Fr das Raycasting existiert auch eine Routine zum Zeichnen
'                 vertikale Linien.
'                 Auch die Routinen DrawPixel, GetPixel, Clearscreen, Blit,
'                 Blittrans, Copysegment wurden in Assembler-Routinen
'                 konvertiert um die hchstmgliche Ausfhrungsgeschwindigkeit
'                 gewhrleisten zu knnen.
'                 Im Hauptprogramm werden zuerst alle Routinen auf den Buffer
'                 und dann auf das Videosegment angewendet.
'----------------------------------------------------------------------------
DECLARE SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
DECLARE SUB DrawTriangle (ZielSegment%, x1!, y1!, x2!, y2!, x3!, y3!, Farbe%)

'$INCLUDE: 'DBASM.BI'

DIM Bild(17 * 17 + 2 + 1) AS STRING * 1

SCREEN 13

RANDOMIZE TIMER

'Bild zeichnen und in Array Bild() einlesen
   CIRCLE (8, 8), 8, 14
   CIRCLE (6, 6), 2, 14
   CIRCLE (10, 6), 2, 14
   PAINT (6, 6), 15, 14
   PAINT (10, 6), 15, 14
   PAINT (8, 8), 14, 14
   LINE (6, 12)-(11, 12), 16
   CIRCLE (6, 6), 2, 16
   CIRCLE (10, 6), 2, 16
   PSET (7, 7), 16
   PSET (9, 7), 16
   GetPicture Vidseg, 0, 0, 16, 16, VARSEG(Bild(0)), VARPTR(Bild(0))

'Videospeicher und Buffersegment lschen
   ClearScreen Vidseg, 0
   ClearScreen BufSeg, RND * 255

'Routinen auf Buffer anwenden und Buffer in den Videospeicher kopieren
   FOR t = 1 TO 500
      DrawPixel BufSeg, RND * 319, RND * 199, RND * 255
      DrawLine BufSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      DrawHLine BufSeg, RND * 319, RND * 319, RND * 199, RND * 255
      DrawVLine BufSeg, RND * 319, RND * 319, RND * 199, RND * 255
      DrawTriangle BufSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      Blit BufSeg, RND * 319, RND * 199, VARSEG(Bild(0)), VARPTR(Bild(0))
      BlitTrans BufSeg, RND * 319, RND * 199, VARSEG(Bild(0)), VARPTR(Bild(0))
   NEXT t
   CopySegment BufSeg, Vidseg

'Auf Tastendruck warten
   SLEEP

'Videospeicher lschen und alle Routinen auf diesen anwenden
   ClearScreen Vidseg, RND * 255
   FOR t = 1 TO 500
      DrawPixel Vidseg, RND * 319, RND * 199, RND * 255
      DrawLine Vidseg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      DrawHLine Vidseg, RND * 319, RND * 319, RND * 199, RND * 255
      DrawVLine Vidseg, RND * 319, RND * 319, RND * 199, RND * 255
      DrawTriangle Vidseg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      Blit Vidseg, RND * 319, RND * 199, VARSEG(Bild(0)), VARPTR(Bild(0))
      BlitTrans Vidseg, RND * 319, RND * 199, VARSEG(Bild(0)), VARPTR(Bild(0))
   NEXT t

'Auf Tastendruck warten
   SLEEP

SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
'Ist DeltaX grer als DeltaY wird die Linie von links nach rechts
'gezeichnet.
   IF ABS(endx - startx) > ABS(Endy - Starty) THEN
      IF startx > endx THEN SWAP startx, endx: SWAP Starty, Endy
      IF Endy = Starty THEN
         k = 0
      ELSE
         k = (Endy - Starty) / (endx - startx)
      END IF
      x = startx
      y = Starty
      DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WHILE x <= endx
         x = x + 1
         y = y + k
         DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
         WEND
'Andernfalls wird die Linie von unten nach oben gezeichnet
   ELSE
      IF Starty > Endy THEN SWAP startx, endx: SWAP Starty, Endy
      IF Endy = Starty THEN
         k = 0
      ELSE
         k = (endx - startx) / (Endy - Starty)
      END IF
      x = startx
      y = Starty
      DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WHILE y <= Endy
         x = x + k
         y = y + 1
         DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WEND
   END IF

END SUB

SUB DrawTriangle (ZielSegment%, x1, y1, x2, y2, x3, y3, Farbe%)
  IF y3 < y2 THEN SWAP y3, y2: SWAP x3, x2
  IF y2 < y1 THEN SWAP y2, y1: SWAP x2, x1
  IF y3 < y2 THEN SWAP y3, y2: SWAP x3, x2

  IF (y2 - y1) <> 0 THEN
    k12 = (x2 - x1) / (y2 - y1)
  ELSE
    k12 = 0
  END IF
  IF (y3 - y1) <> 0 THEN
    k13 = (x3 - x1) / (y3 - y1)
  ELSE
    k13 = 0
  END IF
  IF (y3 - y2) <> 0 THEN
    k23 = (x3 - x2) / (y3 - y2)
  ELSE
    k23 = 0
  END IF

  u1 = x1
  v1 = y1
  u2 = x1
  v2 = y1

  WHILE v1 < y2
    DrawHLine ZielSegment%, CINT(u1), CINT(u2), CINT(v1), Farbe%
    u1 = u1 + k12
    v1 = v1 + 1
    u2 = u2 + k13
    v2 = v2 + 1
  WEND

  'Ist P1 auf selber Hhe wie P2 (y2-y1=0 => k1=0) mu u2 mit
  'der X-Koordinate des Punktes P2 neu initialisiert werden
  u1 = x2

  WHILE v1 <= y3
    DrawHLine ZielSegment%, CINT(u1), CINT(u2), CINT(v1), Farbe%
    u1 = u1 + k23
    v1 = v1 + 1
    u2 = u2 + k13
    v2 = v2 + 1
  WEND


END SUB

