'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........DBASM / Kapitel 3.4.3
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........9.1.2002
' Beschreibung:      Demonstriert den Einsatz der fr das Double-Buffering
'                    modifizierten Zeichen-Routinen. Da die Routinen aus-
'                    schlielich in Basic verfasst sind, ist deren Ausfhrungs-
'                    geschwindigkeit unzureichend.
'----------------------------------------------------------------------------
DECLARE SUB Blittrans (ZielSegment%, x1%, y1%, SEGMENT%, OFFSET%)
DECLARE SUB Blit (ZielSegment%, x1%, y1%, SEGMENT%, OFFSET%)
DECLARE SUB GetPicture (QuellSegment%, x1%, y1%, x2%, y2%, SEGMENT%, OFFSET%)
DECLARE SUB DrawTriangle (ZielSegment%, x1!, y1!, x2!, y2!, x3!, y3!, Farbe%)
DECLARE SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
DECLARE SUB DrawPixel (ZielSegment%, x AS INTEGER, y AS INTEGER, Farbe AS INTEGER)
DECLARE FUNCTION GetPixel% (QuellSegment%, x%, y%)
DECLARE SUB ClearScreen (ZielSegment%, Farbe AS INTEGER)
DECLARE SUB CopySegment (QuellSegment%, ZielSegment%)
'$DYNAMIC
DIM SHARED Buffer(31999) AS INTEGER
'$STATIC
DIM SHARED BufSeg AS INTEGER
DIM SHARED VidSeg AS INTEGER
BufSeg = VARSEG(Buffer(0))
VidSeg = &HA000

DIM SHARED Bildarray(17 * 17 + 2 - 1) AS STRING * 1

SCREEN 13
RANDOMIZE TIMER

'Smiley zeichnen
   CIRCLE (8, 8), 8, 14
   CIRCLE (6, 6), 2, 14
   CIRCLE (10, 6), 2, 14
   PAINT (6, 6), 15, 14
   PAINT (10, 6), 15, 14
   PAINT (8, 8), 14, 14
   LINE (6, 12)-(11, 12), 16
   CIRCLE (6, 6), 2, 16
   CIRCLE (10, 6), 2, 16
   PSET (7, 7), 16
   PSET (9, 7), 16

'Bild in Array einlesen
   GetPicture VidSeg, 0, 0, 16, 16, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))

'Buffer und Videospeicher lschen
   ClearScreen BufSeg, RND * 255
   ClearScreen VidSeg, 0

'Alle Funktionen auf den Buffer anwenden
   FOR t = 1 TO 50
      DrawLine BufSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      DrawTriangle BufSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
      DrawPixel BufSeg, RND * 319, RND * 199, 4
      Blit BufSeg, RND * 319, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
      Blittrans BufSeg, RND * 319, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
   NEXT t

'Buffer in den Videospeicher schreiben
   CopySegment BufSeg, VidSeg

'Auf Tastendruck warten
   SLEEP

'Videospeicher lschen
   ClearScreen VidSeg, 0

'Alle Funktionen auf den Videospeicher anwenden
FOR t = 1 TO 50
   DrawLine VidSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
   DrawTriangle VidSeg, RND * 319, RND * 199, RND * 319, RND * 199, RND * 319, RND * 199, RND * 255
   DrawPixel VidSeg, RND * 319, RND * 199, 4
   Blit VidSeg, RND * 319, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
   Blittrans VidSeg, RND * 319, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
NEXT t


'Auf Tastendruck warten
   SLEEP

DEFINT A-Z
SUB Blit (ZielSegment%, x1, y1, SEGMENT, OFFSET)

'Hhe und Breite des Bildes einlesen
   DEF SEG = SEGMENT
      widthp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
      heightp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
   DEF SEG

'Adresse des ersten zu zeichnenden Pixel und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Variablen fr Clipping initialisieren
   Clipx = x1
   Clipy = y1

'Die erste Schleife zhlt die Zeilen die gezeichnet wurden, die zweite
'die gezeichneten Pixel in einer Zeile. D.h. wurde eine Zeile gezeichnet
'springt der Zeiger PixelAdresse in an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      IF Clipx > 319 OR Clipx < 0 THEN GOTO Skippixel2
      IF Clipy > 199 OR Clipy < 0 THEN GOTO Skippixel2
      DEF SEG = SEGMENT                         'Farbindex des aktuellen Pixel
         Pixelcolor = PEEK(OFFSET&)             'aus dem Array lesen
      DEF SEG = ZielSegment%                    'Pixel im Videospeicher
         POKE PixelAdresse&, Pixelcolor         'zeichnen.
      DEF SEG
Skippixel2:
      OFFSET& = OFFSET& + 1                     'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1         'Videospeicherzeiger auf
                                                'nchstes Byte (Pixel)
      Clipx = Clipx + 1
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch        'ber Addition mit Pitch
                                                'in die nchste Zeile springen
   Clipy = Clipy + 1
   Clipx = Clipx - widthp
NEXT y

END SUB

SUB Blittrans (ZielSegment%, x1, y1, SEGMENT, OFFSET)
'Hhe und Breite des Bildes einlesen
   DEF SEG = SEGMENT
      widthp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
      heightp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
   DEF SEG

'Adresse des ersten zu zeichnenden Pixel und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Variablen fr Clipping initialisieren
   Clipx = x1
   Clipy = y1

'Die erste Schleife zhlt die Zeilen die gezeichnet wurden, die zweite
'die gezeichneten Pixel in einer Zeile. D.h. wurde eine Zeile gezeichnet
'springt der Zeiger PixelAdresse in an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      IF Clipx > 319 OR Clipx < 0 THEN GOTO Skippixel
      IF Clipy > 199 OR Clipy < 0 THEN GOTO Skippixel
      DEF SEG = SEGMENT                         'Farbindex des aktuellen Pixel
         Pixelcolor = PEEK(OFFSET&)             'aus dem Array lesen
         IF Pixelcolor = 0 THEN GOTO Skippixel  'Ist der Farbindex null wird
                                                'das Pixel bersprungen um
                                                'den Transparenzeffekt zu
                                                'erzielen
      DEF SEG = ZielSegment%                    'Pixel im Videospeicher
         POKE PixelAdresse&, Pixelcolor         'zeichnen.
Skippixel:
      DEF SEG
      OFFSET& = OFFSET& + 1                     'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1         'Videospeicherzeiger auf
                                                'nchstes Byte (Pixel)
      Clipx = Clipx + 1
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch        'ber Addition mit Pitch
                                                'in die nchste Zeile springen
   Clipx = Clipx - widthp
   Clipy = Clipy + 1
NEXT y

END SUB

DEFSNG A-Z
SUB ClearScreen (ZielSegment%, Farbe AS INTEGER)
   DEF SEG = ZielSegment%
      FOR t& = 0 TO 63999
         POKE t&, Farbe
      NEXT t&
   DEF SEG

END SUB

SUB CopySegment (QuellSegment%, ZielSegment%)
'Alle Byte des Quellsegment werden in da Zielsegment geschrieben
   FOR OFFSET& = 0 TO 63999
      DEF SEG = QuellSegment%                'Quellsegment setzen
         Pixelcolor = PEEK(OFFSET&)          'Farbindex einlesen
      DEF SEG = ZielSegment%                 'Zielsegment setzen
         POKE OFFSET&, Pixelcolor            'Farbindex schreiben
   NEXT OFFSET&
   DEF SEG
END SUB

SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
'Ist DeltaX grer als DeltaY wird die Linie von links nach rechts
'gezeichnet.
   IF ABS(endx - startx) > ABS(Endy - Starty) THEN
      IF startx > endx THEN SWAP startx, endx: SWAP Starty, Endy
      IF Endy = Starty THEN
         k = 0
      ELSE
         k = (Endy - Starty) / (endx - startx)
      END IF
      x = startx
      y = Starty
      DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WHILE x <= endx
         x = x + 1
         y = y + k
         DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
         WEND
'Andernfalls wird die Linie von unten nach oben gezeichnet
   ELSE
      IF Starty > Endy THEN SWAP startx, endx: SWAP Starty, Endy
      IF Endy = Starty THEN
         k = 0
      ELSE
         k = (endx - startx) / (Endy - Starty)
      END IF
      x = startx
      y = Starty
      DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WHILE y <= Endy
         x = x + k
         y = y + 1
         DrawPixel ZielSegment%, CINT(x), CINT(y), Farbe
      WEND
   END IF

END SUB

SUB DrawPixel (ZielSegment%, x AS INTEGER, y AS INTEGER, Farbe AS INTEGER)

'Clipping: Ist der Punkt innerhalb der Bildschirmgrenzen?
   IF x > 319 OR x < 0 THEN EXIT SUB
   IF y > 199 OR y < 0 THEN EXIT SUB

'Offset des Pixel errechnen und Byte im Videosegment a000hex auf
'die gewnschte Farbe setzten.
   DEF SEG = ZielSegment%
      POKE y * 320& + x, Farbe
   DEF SEG

END SUB

SUB DrawTriangle (ZielSegment%, x1, y1, x2, y2, x3, y3, Farbe%)
 
  IF y3 < y2 THEN SWAP y3, y2: SWAP x3, x2
  IF y2 < y1 THEN SWAP y2, y1: SWAP x2, x1
  IF y3 < y2 THEN SWAP y3, y2: SWAP x3, x2

  IF (y2 - y1) <> 0 THEN
    k12 = (x2 - x1) / (y2 - y1)
  ELSE
    k12 = 0
  END IF
  IF (y3 - y1) <> 0 THEN
    k13 = (x3 - x1) / (y3 - y1)
  ELSE
    k13 = 0
  END IF
  IF (y3 - y2) <> 0 THEN
    k23 = (x3 - x2) / (y3 - y2)
  ELSE
    k23 = 0
  END IF

  u1 = x1
  v1 = y1
  u2 = x1
  v2 = y1

  WHILE v1 < y2
    DrawLine ZielSegment%, CINT(u1), CINT(v1), CINT(u2), CINT(v2), Farbe%
    u1 = u1 + k12
    v1 = v1 + 1
    u2 = u2 + k13
    v2 = v2 + 1
  WEND

  'Ist P1 auf selber Hhe wie P2 (y2-y1=0 => k1=0) mu u2 mit
  'der X-Koordinate des Punktes P2 neu initialisiert werden
  u1 = x2

  WHILE v1 <= y3
    DrawLine ZielSegment%, CINT(u1), CINT(v1), CINT(u2), CINT(v2), Farbe%
    u1 = u1 + k23
    v1 = v1 + 1
    u2 = u2 + k13
    v2 = v2 + 1
  WEND

END SUB

DEFINT A-Z
SUB GetPicture (QuellSegment%, x1, y1, x2, y2, SEGMENT, OFFSET)
'Hhe und Breite des Bildes berechnen
   heightp = y2 - y1 + 1
   widthp = x2 - x1 + 1

'Breite und Hhe an die erste zwei Bytes im Array schreiben
DEF SEG = SEGMENT
   POKE OFFSET&, widthp
   OFFSET& = OFFSET& + 1
   POKE OFFSET&, heightp
   OFFSET& = OFFSET& + 1
DEF SEG

'Die Variable OFFSET zeigt jetzt auf das dritte Byte im Array und
'damit auf das erste Byte der Bildinformation. Gleichzeitig wird dieses
'Byte in BASIC ber den Index 2 angesteuert, da die ADressierung bei null
'beginnt. D.h. SEGMENT:OFFSET = Bildarray(2)

'Adresse des ersten Pixel im Videospeicher und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Die erste Schleife zhlt die Zeilen die eingelesen wurden, die zweite
'die eingelesenen Pixel in einer Zeile. D.h. wurde eine Zeile eingelesen
'springt der Zeiger PixelAdresse an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      DEF SEG = QuellSegment                 'Pixelfarbe aus dem Video-
         Pixelcolor = PEEK(PixelAdresse&)    'speicher einlesen
      DEF SEG = SEGMENT                      'Farbindex in den Array
         POKE OFFSET&, Pixelcolor            'schreiben
      DEF SEG
      OFFSET& = OFFSET& + 1                  'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1      'Videospeicherzeiger auf
                                             'nchstes Byte (Pixel)
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch     'ber Addition mit Pitch
                                             'in die nchste Zeile springen
NEXT y

END SUB

DEFSNG A-Z
FUNCTION GetPixel% (QuellSegment%, x%, y%)
   DEF SEG = QuellSegment%
      GetPixel = PEEK(y% * 320& + x%)
   DEF SEG

END FUNCTION

