'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........GETBLIT / Kapitel 3.3 / Kapitel 3.4 / Kapitel 3.5
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........5.1.2002
' Beschreibung: Demonstration der drei Routinen GETPICTURE, BLIT und
'               BLITTRANS. Mit Hilfe von BASICs LINE Befehl wird zuers ein
'               Muster gezeichnet (rotes Quadrat mit Diagonalen), welches
'               dann von der Prozedur GETPICTURE in den Array Bildarray
'               geschrieben wird. Dieser ist vom Typ STRING * 1 damit jedes
'               Element genau ein Byte gro ist. Die Datenstruktur wird darin
'               so angelegt wie es im Kapitel 3.3 beschrieben wurde. Das Bild
'               im Array wird dann zuerst von der Prozedur BLIT gezeichnet,
'               wobei dies ohne Transparenz-Effekt geschieht, das heit Pixel
'               mit dem Farbindex 0 werden gezeichnet. Die Prozedur BLITTRANS
'               zeichnet dann ebenfalls das im Array gespeicherte Bild,
'               jedoch mit Transparenz-Effekt.
'----------------------------------------------------------------------------
DEFINT A-Z
DECLARE SUB Blit (x1%, y1%, SEGMENT%, OFFSET%)
DECLARE SUB BlitTrans (x1%, y1%, SEGMENT%, OFFSET%)
DECLARE SUB GetPicture (x1, y1, x2, y2, SEGMENT, OFFSET)

DIM Bildarray(17 * 17 + 2 - 1) AS STRING * 1

SCREEN 13

'Smiley zeichnen
   CIRCLE (8, 8), 8, 14
   CIRCLE (6, 6), 2, 14
   CIRCLE (10, 6), 2, 14
   PAINT (6, 6), 15, 14
   PAINT (10, 6), 15, 14
   PAINT (8, 8), 14, 14
   LINE (6, 12)-(11, 12), 16
   CIRCLE (6, 6), 2, 16
   CIRCLE (10, 6), 2, 16
   PSET (7, 7), 16
   PSET (9, 7), 16

'Muster in Array Bildarray einlesen
   GetPicture 0, 0, 16, 16, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
   SLEEP

'Bildschirm mit Farbe blau lschen und Bild fnfzig mal ohne Transparenz-
'Effekt zeichnen
   PAINT (0, 0), 1
   PRINT "Blit"
   FOR t = 0 TO 50
      Blit RND * 320, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
   NEXT t
   SLEEP

'Bildschirm mit Farbe blau lschen und das Bild fnfzig mal mit Transparenz-
'Effekt zeichnen.
   CLS
   PAINT (0, 0), 1
   LOCATE 1, 1
   PRINT "Blittrans"
   FOR t = 0 TO 50
      BlitTrans RND * 320, RND * 199, VARSEG(Bildarray(0)), VARPTR(Bildarray(0))
   NEXT t
   SLEEP

SUB Blit (x1, y1, SEGMENT, OFFSET)

'Hhe und Breite des Bildes einlesen
   DEF SEG = SEGMENT
      widthp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
      heightp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
   DEF SEG

'Adresse des ersten zu zeichnenden Pixel und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Variablen fr Clipping initialisieren
   Clipx = x1
   Clipy = y1

'Die erste Schleife zhlt die Zeilen die gezeichnet wurden, die zweite
'die gezeichneten Pixel in einer Zeile. D.h. wurde eine Zeile gezeichnet
'springt der Zeiger PixelAdresse in an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      IF Clipx > 319 OR Clipx < 0 THEN GOTO Skippixel2
      IF Clipy > 199 OR Clipy < 0 THEN GOTO Skippixel2
      DEF SEG = SEGMENT                         'Farbindex des aktuellen Pixel
         Pixelcolor = PEEK(OFFSET&)             'aus dem Array lesen
      DEF SEG = &HA000                          'Pixel im Videospeicher
         POKE PixelAdresse&, Pixelcolor         'zeichnen.
      DEF SEG
Skippixel2:
      OFFSET& = OFFSET& + 1                     'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1         'Videospeicherzeiger auf
                                                'nchstes Byte (Pixel)
      Clipx = Clipx + 1
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch        'ber Addition mit Pitch
                                                'in die nchste Zeile springen
   Clipy = Clipy + 1
   Clipx = Clipx - widthp
NEXT y

END SUB

SUB BlitTrans (x1, y1, SEGMENT, OFFSET)

'Hhe und Breite des Bildes einlesen
   DEF SEG = SEGMENT
      widthp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
      heightp = PEEK(OFFSET&)
      OFFSET& = OFFSET& + 1
   DEF SEG

'Adresse des ersten zu zeichnenden Pixel und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Variablen fr Clipping initialisieren
   Clipx = x1
   Clipy = y1

'Die erste Schleife zhlt die Zeilen die gezeichnet wurden, die zweite
'die gezeichneten Pixel in einer Zeile. D.h. wurde eine Zeile gezeichnet
'springt der Zeiger PixelAdresse in an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      IF Clipx > 319 OR Clipx < 0 THEN GOTO Skippixel
      IF Clipy > 199 OR Clipy < 0 THEN GOTO Skippixel
      DEF SEG = SEGMENT                         'Farbindex des aktuellen Pixel
         Pixelcolor = PEEK(OFFSET&)             'aus dem Array lesen
         IF Pixelcolor = 0 THEN GOTO Skippixel  'Ist der Farbindex null wird
                                                'das Pixel bersprungen um
                                                'den Transparenzeffekt zu
                                                'erzielen
      DEF SEG = &HA000                          'Pixel im Videospeicher
         POKE PixelAdresse&, Pixelcolor         'zeichnen.
Skippixel:
      DEF SEG
      OFFSET& = OFFSET& + 1                     'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1         'Videospeicherzeiger auf
                                                'nchstes Byte (Pixel)
      Clipx = Clipx + 1
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch        'ber Addition mit Pitch
                                                'in die nchste Zeile springen
   Clipx = Clipx - widthp
   Clipy = Clipy + 1
NEXT y

END SUB

SUB GetPicture (x1, y1, x2, y2, SEGMENT, OFFSET)

'Hhe und Breite des Bildes berechnen
   heightp = y2 - y1 + 1
   widthp = x2 - x1 + 1

'Breite und Hhe an die erste zwei Bytes im Array schreiben
DEF SEG = SEGMENT
   POKE OFFSET&, widthp
   OFFSET& = OFFSET& + 1
   POKE OFFSET&, heightp
   OFFSET& = OFFSET& + 1
DEF SEG

'Die Variable OFFSET zeigt jetzt auf das dritte Byte im Array und
'damit auf das erste Byte der Bildinformation. Gleichzeitig wird dieses
'Byte in BASIC ber den Index 2 angesteuert, da die ADressierung bei null
'beginnt. D.h. SEGMENT:OFFSET = Bildarray(2)

'Adresse des ersten Pixel im Videospeicher und Pitch berechnen
   PixelAdresse& = y1 * 320& + x1
   Pitch = 320 - widthp

'Die erste Schleife zhlt die Zeilen die eingelesen wurden, die zweite
'die eingelesenen Pixel in einer Zeile. D.h. wurde eine Zeile eingelesen
'springt der Zeiger PixelAdresse an den Anfang der nchste Zeile

FOR y = 1 TO heightp
   FOR x = 1 TO widthp
      DEF SEG = &HA000                       'Pixelfarbe aus dem Video-
         Pixelcolor = PEEK(PixelAdresse&)    'speicher einlesen
      DEF SEG = SEGMENT                      'Farbindex in den Array
         POKE OFFSET&, Pixelcolor            'schreiben
      DEF SEG
      OFFSET& = OFFSET& + 1                  'Arrayzeiger auf nchstes Byte
      PixelAdresse& = PixelAdresse& + 1      'Videospeicherzeiger auf
                                             'nchstes Byte (Pixel)
   NEXT x
   PixelAdresse& = PixelAdresse& + Pitch     'ber Addition mit Pitch
                                             'in die nchste Zeile springen
NEXT y

END SUB

