'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........PBPSCR.BAS / Kapitel 4.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........16.2.2002
' Beschreibung:    Demonstrationsprogramm zum Kapitel Tile-Scrolling. Die
'                  Zeichenfunktionen sind in der Bibliothek DB.QLB enthalten
'                  und sind in Assembler verfasst worden. Unter Einsatz des
'                  Double-Buffer Prinzips wird ein unerwnschtes Flackern
'                  verhindert.Das Scrolling erfolgt ber die Tasten A,D,W und
'                  S.
'
'                                           W aufwrts
'                                           |
'                                           |
'                             links A----------------D rechts
'                                           |
'                                           |
'                                           S abwrts
'
'                  Das Scrollen erfolgt pixelweise. Die koordinate des linken                  
'                  Ecks des Kartenausschnitt wird nun aber in Bildschirmko-
'                  ordinaten angegeben. Das System wird auf die Gre der
'                  Karte ausgeweitet. Anstatt 16*10 Tiles zu zeichnen, wird
'                  je nach Situation eine Zeile bzw. Spalte mehr gezeichnet
'                  Ist mapx kein vielfaches von 20 so sind 17 Tils pro Reihe
'                  sichtbar. Das gilt auch fr mapy wo dann 10 Tiles dargestellt
'                  werden.
'               
'----------------------------------------------------------------------------
DECLARE SUB KarteZeichnen ()
DECLARE SUB ZufallsKarte ()
DECLARE SUB ZufallsTiles ()
DECLARE SUB DrawVLine (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL y2%, BYVAL Farbe%)
DECLARE SUB DrawHLine (BYVAL ZielSegment%, BYVAL x%, BYVAL x2%, BYVAL y%, BYVAL Farbe%)
DECLARE SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
DECLARE SUB DrawTriangle (ZielSegment%, x1!, y1!, x2!, y2!, x3!, y3!, Farbe%)
DECLARE SUB DrawPixel (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL Farbe%)
DECLARE FUNCTION GetPixel% (BYVAL QuellSegment%, BYVAL x%, BYVAL y%)
DECLARE SUB GetPicture (BYVAL QuellSegment%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB Blit (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB BlitTrans (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB CopySegment (BYVAL QuellSegment%, BYVAL ZielSegment%)
DECLARE SUB ClearScreen (BYVAL ZielSegment%, BYVAL Farbe%)
'$DYNAMIC
DIM Buffer(31999) AS INTEGER
'$STATIC
DIM SHARED BufSeg AS INTEGER
DIM SHARED VidSeg AS INTEGER
BufSeg = VARSEG(Buffer(0))
VidSeg = &HA000

DIM SHARED tiles((20 * 20 + 2) * 2 - 1) AS STRING * 1
DIM SHARED Karte(0 TO 31, 0 TO 19) AS INTEGER
DIM SHARED BytesProTile
DIM SHARED mapx AS INTEGER
DIM SHARED mapy AS INTEGER
BytesProTile = 20 * 20 + 2
mapx = 0
mapy = 0

SCREEN 13

'Zwei Zufalls-Tiles zeichnen und in Array Tiles() einlesen
   ZufallsTiles
   GetPicture VidSeg, 0, 0, 19, 19, VARSEG(tiles(0)), VARPTR(tiles(0))
   GetPicture VidSeg, 21, 0, 40, 19, VARSEG(tiles(0)), VARPTR(tiles(BytesProTile * 1))

'Zufalls-Karte in Array Karte erstellen
   ZufallsKarte

DO
   'Tastendruck auswerten und je nach Taste Position in Karte verndern
   Taste$ = INKEY$
   IF Taste$ = "a" THEN mapx = mapx - 2
   IF Taste$ = "d" THEN mapx = mapx + 2
   IF Taste$ = "w" THEN mapy = mapy - 2
   IF Taste$ = "s" THEN mapy = mapy + 2

   KarteZeichnen

   'Buffer in den Videospeicher kopieren
   CopySegment BufSeg, VidSeg
LOOP UNTIL Taste$ = CHR$(27)

SUB KarteZeichnen

IF mapx < 0 THEN mapx = 0
IF mapx > 320 THEN mapx = 320
IF mapy < 0 THEN mapy = 0
IF mapy > 199 THEN mapy = 199

gy = mapy \ 20                                    'mapx in Index des Arrays Karte() umgerechnet
gx = mapx \ 20                                    'mapy in Index des Arrays Karte() umgerechnet
FOR y = 0 TO ((mapy + 199) \ 20) - (mapy \ 20)   'Anzahl der zu zeichneten Tiles pro Spalte
   FOR x = 0 TO ((mapx + 319) \ 20) - (mapx \ 20) 'Anzahl der zu zeichneten Tiles pro Zeile
      Blit BufSeg, x * 20 - mapx MOD 20, y * 20 - mapy MOD 20, VARSEG(tiles(0)), VARPTR(tiles(Karte(gx + x, gy + y) * BytesProTile))
   NEXT x
NEXT y

END SUB

SUB ZufallsKarte
FOR y = 0 TO 19
   FOR x = 0 TO 31
      Karte(x, y) = RND * 2 - 1
      IF Karte(x, y) < 0 THEN Karte(x, y) = 0
   NEXT x
NEXT y
END SUB

SUB ZufallsTiles
FOR y = 0 TO 19
   FOR x = 0 TO 19
      DrawPixel VidSeg, x, y, RND * 5 + 40
   NEXT x
NEXT y
FOR y = 0 TO 19
   FOR x = 21 TO 40
      DrawPixel VidSeg, x, y, RND * 5 + 20
   NEXT x
NEXT y

END SUB

