'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........TBTSCR.BAS / Kapitel 4.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........16.2.2002
' Beschreibung:    Demonstrationsprogramm zum Kapitel Tile-Scrolling. Die
'                  Zeichenfunktionen sind in der Bibliothek DB.QLB enthalten
'                  und sind in Assembler verfasst worden. Unter Einsatz des
'                  Double-Buffer Prinzips wird ein unerwnschtes Flackern
'                  verhindert.Das Scrolling erfolgt ber die Tasten A,D,W und
'                  S.
'
'                                           W aufwrts
'                                           |
'                                           |
'                             links A----------------D rechts
'                                           |
'                                           |
'                                           S abwrts
'                                         
'----------------------------------------------------------------------------
DECLARE SUB KarteZeichnen ()
DECLARE SUB ZufallsKarte ()
DECLARE SUB ZufallsTiles ()
DECLARE SUB DrawVLine (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL y2%, BYVAL Farbe%)
DECLARE SUB DrawHLine (BYVAL ZielSegment%, BYVAL x%, BYVAL x2%, BYVAL y%, BYVAL Farbe%)
DECLARE SUB DrawLine (ZielSegment%, startx AS INTEGER, Starty AS INTEGER, endx AS INTEGER, Endy AS INTEGER, Farbe AS INTEGER)
DECLARE SUB DrawTriangle (ZielSegment%, x1!, y1!, x2!, y2!, x3!, y3!, Farbe%)
DECLARE SUB DrawPixel (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL Farbe%)
DECLARE FUNCTION GetPixel% (BYVAL QuellSegment%, BYVAL x%, BYVAL y%)
DECLARE SUB GetPicture (BYVAL QuellSegment%, BYVAL x1%, BYVAL y1%, BYVAL x2%, BYVAL y2%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB Blit (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB BlitTrans (BYVAL ZielSegment%, BYVAL x%, BYVAL y%, BYVAL SEGMENT%, BYVAL OFFSET%)
DECLARE SUB CopySegment (BYVAL QuellSegment%, BYVAL ZielSegment%)
DECLARE SUB ClearScreen (BYVAL ZielSegment%, BYVAL Farbe%)
'$DYNAMIC
DIM Buffer(31999) AS INTEGER
'$STATIC
DIM SHARED BufSeg AS INTEGER
DIM SHARED VidSeg AS INTEGER
BufSeg = VARSEG(Buffer(0))
VidSeg = &HA000

DIM SHARED Tiles((20 * 20 + 2) * 2 - 1) AS STRING * 1
DIM SHARED Karte(0 TO 31, 0 TO 19) AS INTEGER
DIM SHARED BytesproTile
DIM SHARED mapx AS INTEGER
DIM SHARED mapy AS INTEGER
BytesproTile = 20 * 20 + 2
mapx = 0
mapy = 0

SCREEN 13

'Zwei Zufalls-Tiles zeichnen und in Array Tiles() einlesen
   ZufallsTiles
   GetPicture VidSeg, 0, 0, 19, 19, VARSEG(Tiles(0)), VARPTR(Tiles(0))
   GetPicture VidSeg, 21, 0, 40, 19, VARSEG(Tiles(0)), VARPTR(Tiles(BytesproTile * 1))

'Zufalls-Karte in Array Karte erstellen
   ZufallsKarte

DO
   'Tastendruck auswerten und je nach Taste Position in Karte verndern
   Taste$ = INKEY$
   IF Taste$ = "a" THEN mapx = mapx - 1
   IF Taste$ = "d" THEN mapx = mapx + 1
   IF Taste$ = "w" THEN mapy = mapy - 1
   IF Taste$ = "s" THEN mapy = mapy + 1

   KarteZeichnen
   'Buffer in den Videospeicher kopieren
   CopySegment BufSeg, VidSeg
LOOP UNTIL Taste$ = CHR$(27)

SUB KarteZeichnen

'Sicherstellen, dass auf kein Element auerhalb des Array Karte zugegriffen
'wird
   IF mapx < 0 THEN mapx = 0
   IF mapx > 16 THEN mapx = 16
   IF mapy < 0 THEN mapy = 0
   IF mapy > 10 THEN mapy = 10


FOR y = 0 TO 180 STEP 20
   FOR x = 0 TO 300 STEP 20
      'Kachelnummer aus Karte-Array lesen
      Kachelnummer = Karte(x \ 20 + mapx, y \ 20 + mapy)
      'Tile zeichnen
      Blit BufSeg, x, y, VARSEG(Tiles(0)), VARPTR(Tiles(Kachelnummer * BytesproTile))
      'Position fr nchstes Tile rechts erechnen
   NEXT x
NEXT y

END SUB

SUB ZufallsKarte
FOR y = 0 TO 19
   FOR x = 0 TO 31
      Karte(x, y) = RND * 2 - 1
      IF Karte(x, y) < 0 THEN Karte(x, y) = 0
   NEXT x
NEXT y
END SUB

SUB ZufallsTiles
FOR y = 0 TO 19
   FOR x = 0 TO 19
      DrawPixel VidSeg, x, y, RND * 5 + 40
   NEXT x
NEXT y
FOR y = 0 TO 19
   FOR x = 21 TO 40
      DrawPixel VidSeg, x, y, RND * 5 + 20
   NEXT x
NEXT y

END SUB

