'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........RAYCAST.BAS / Kapitel 3.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........2.2.2002
' Beschreibung:    Ein "einfaches" Raycastin-Beispiel. Sie bewegen sich
'                  mit den Tasten A,D,W und S durch die Welt.
'
'                                         W vorwrts bewegen
'                                         |
'                                         |
'                   Drehung links A----------------D Drehung rechts
'                                         |
'                                         |
'                                         S rckwrts bewegen
'                
'----------------------------------------------------------------------------
DECLARE SUB KarteEinlesen ()
DECLARE SUB Raycasting ()
'$INCLUDE: 'DBASM.BI'
DIM SHARED karte(0 TO 9, 0 TO 9) AS INTEGER        'WeltKarte 10x10 Felder
CONST DegToRad = 3.141593 / 180                    'Grad in Radians umrechnen
CONST Winkelabstand = 60 / 320                     'Dient dazu die Winkel der
                                                   'einzelnen Strahlen inkrem-
                                                   'entel zu errechnen
CONST Perspective = 64 * 277                       'Multipliziert mit der Dis-
                                                   'tanz ergibt das die Hhe
                                                   'der Wand
DIM SHARED Betrachterx AS INTEGER                  'Position des Betrachters
DIM SHARED Betrachtery AS INTEGER                  'Position des Betrachters
DIM SHARED Blickrichtung AS INTEGER                'Blickrichtung des Betrachtes
Betrachterx = 64 * 5 - 32
Betrachtery = 64 * 6 - 32
Blickrichtung = 40
                               
'Karte in Array einlesen
KarteEinlesen

'Modus 13h aktivieren
SCREEN 13

DO
   'Buffer lschen
   ClearScreen BufSeg, 0
   'Raycaster aufrufen
   Raycasting
   'Buffer in Videospeicher kopieren
   CopySegment BufSeg, Vidseg
   'Tastatureingabe lesen
   I$ = INKEY$
   SELECT CASE I$
      CASE "d": 
         'Taste d: Betrachter rechts rotieren
         Blickrichtung = Blickrichtung + 2
         IF Blickrichtung > 360 THEN Blickrichtung = 0
      CASE "a":
         'Taste a: Betrachter linksrotieren
         Blickrichtung = Blickrichtung - 2
         IF Blickrichtung < -90 THEN Blickrichtung = 360
      CASE "w":
         'Taste w: Betrachter 10 Einheiten nach vorne versetzen
         Betrachterx = Betrachterx - COS(Blickrichtung * DegToRad) * 10
         Betrachtery = Betrachtery - SIN(Blickrichtung * DegToRad) * 10
         'Prfen ob der Betrachter sich auf einem Mauer-Feld befindet
         'Wenn ja dann wird der Betrachter auf die alte Position gesetzt
         IF karte(Betrachterx \ 64, Betrachtery \ 64) <> 0 THEN
            Betrachterx = Betrachterx + COS(Blickrichtung * DegToRad) * 10
            Betrachtery = Betrachtery + SIN(Blickrichtung * DegToRad) * 10
         END IF
      CASE "s":
         'Taste s: Betrachter 10 Einheiten nach hinten versetzen
         Betrachterx = Betrachterx + COS(Blickrichtung * DegToRad) * 10
         Betrachtery = Betrachtery + SIN(Blickrichtung * DegToRad) * 10
         'Prfen ob der Betrachter sich auf einem Mauer-Feld befindet
         'Wenn ja dann wird der Betrachter auf die alte Position gesetzt

         IF karte(Betrachterx \ 64, Betrachtery \ 64) <> 0 THEN
            Betrachterx = Betrachterx - COS(Blickrichtung * DegToRad) * 10
            Betrachtery = Betrachtery - SIN(Blickrichtung * DegToRad) * 10
         END IF
   END SELECT

LOOP UNTIL I$ = CHR$(27)


'Daten der Karte. Die Nummern entsprechen den Farbindizes der einzelnen
'Mauern
DATA 1,4,1,4,1,4,1,4,1,4
DATA 4,0,0,4,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,4
DATA 4,0,0,0,0,0,1,0,0,1
DATA 1,0,0,0,0,0,4,0,0,4
DATA 4,0,0,0,0,0,0,0,0,1
DATA 1,0,0,0,0,0,0,0,0,4
DATA 4,0,1,0,0,0,0,0,0,1
DATA 1,0,4,0,0,0,0,0,0,4
DATA 4,1,4,1,4,1,4,1,4,1

SUB KarteEinlesen
FOR y = 0 TO 9
   FOR x = 0 TO 9
      READ Feld                              'Inhalt des Feldes (x,y) einlesen
      karte(x, y) = Feld                     'Wert in Karte abspeichern
   NEXT x
NEXT y
END SUB

SUB Raycasting
StrahlWinkel = Blickrichtung - 30                  'Winkel des ersten Strahls
                                                   'errechnen
'Suche fr 320 Strahlen
FOR ray = 0 TO 319
   'horizontale Suche
     'Up-Strahl?
      IF StrahlWinkel >= 0 AND StrahlWinkel <= 180 THEN
         'ersten horizontalen Schnittpunkt berechnen
         strahly = (Betrachtery \ 64) * 64 - 1
         strahlx = Betrachterx + (strahly - Betrachtery) / TAN((StrahlWinkel + .1) * DegToRad)
         'Inkremente xa und ya initialisieren
         ya = -64
         xa = ya / TAN((StrahlWinkel + .1) * DegToRad)
      ELSE
         'ersten horizontalen Schnittpunkt berechnen
         strahly = (Betrachtery \ 64) * 64 + 64
         strahlx = Betrachterx + (strahly - Betrachtery) / TAN((StrahlWinkel + .1) * DegToRad)
         'Inkremente xa und ya initialisieren
         ya = 64
         xa = ya / TAN((StrahlWinkel + .1) * DegToRad)
      END IF
      'Ist der Strahl ausserhalb der Karte [0..639;0..639] wird die Suche
      'abgebrochen und die Distanz mit einem hohen Wert geladen
      IF strahlx < 0 OR strahlx > 639 THEN Distanz = 32000: GOTO Skip
      IF strahly < 0 OR strahly > 639 THEN Distanz = 32000: GOTO Skip
      'Solange der Strahl keine Mauer getroffen hat
      WHILE karte(INT(strahlx \ 64), INT(strahly \ 64)) = 0
         'neuen Schnittpunkt berechnen
         strahlx = strahlx + xa
         strahly = strahly + ya
         'Ist der Strahl ausserhalb der Karte [0..639;0..639] wird die Suche
         'abgebrochen und die Distanz mit einem hohen Wert geladen
         IF strahlx < 0 OR strahlx > 639 THEN Distanz = 32000: GOTO Skip
         IF strahly < 0 OR strahly > 639 THEN Distanz = 32000: GOTO Skip
      WEND
      'Distanz zur getroffenen Mauer errechnen
      Distanz = CINT(SQR((strahlx - Betrachterx) ^ 2 + (strahly - Betrachtery) ^ 2))
Skip:
   'vertikale Suche
      'Right-Strahl?
      IF StrahlWinkel >= 90 AND StrahlWinkel <= 270 THEN
         'ersten vertikalen Schnittpunkt berechnen
         strahlx2 = (Betrachterx \ 64) * 64 + 64
         strahly2 = Betrachtery + (strahlx2 - Betrachterx) * TAN((StrahlWinkel + .1) * DegToRad)
         'Inkremente xa und ya initialisieren
         xa = 64
         ya = xa * TAN((StrahlWinkel + .1) * DegToRad)
      ELSE
         'ersten vertikalen Schnittpunkt berechnen
         strahlx2 = (Betrachterx \ 64) * 64 - 1
         strahly2 = Betrachtery + (strahlx2 - Betrachterx) * TAN((StrahlWinkel + .1) * DegToRad)
         'Inkremente xa und ya initialisieren
         xa = -64
         ya = xa * TAN((StrahlWinkel + .1) * DegToRad)
      END IF
      'Ist der Strahl ausserhalb der Karte [0..639;0..639] wird die Suche
      'abgebrochen und die Distanz mit einem hohen Wert geladen
      IF strahlx2 < 0 OR strahlx2 > 639 THEN Distanz2 = 32000: GOTO Skip2
      IF strahly2 < 0 OR strahly2 > 639 THEN Distanz2 = 32000: GOTO Skip2
      'Solange der Strahl keine Mauer getroffen hat
      WHILE karte(INT(strahlx2 \ 64), INT(strahly2 \ 64)) = 0
         'neuen Schnittpunkt berechnen
         strahlx2 = strahlx2 + xa
         strahly2 = strahly2 + ya
         'Ist der Strahl ausserhalb der Karte [0..639;0..639] wird die Suche
         'abgebrochen und die Distanz mit einem hohen Wert geladen
         IF strahlx2 < 0 OR strahlx2 > 639 THEN Distanz2 = 32000: GOTO Skip2
         IF strahly2 < 0 OR strahly2 > 639 THEN Distanz2 = 32000: GOTO Skip2
      WEND
      'Distanz zur getroffenen Mauer errechnen    
      Distanz2 = CINT(SQR((strahlx2 - Betrachterx) ^ 2 + (strahly2 - Betrachtery) ^ 2))
Skip2:
   'Ist die Distanz zum vertikalen Schnittpunkt kleiner wird diese Wand
   'gezeichnet. Ansonsten wird die andere Wand gezeichnet
   IF Distanz2 < Distanz THEN
      'Hhe der Wand errechnen
      Wandhoehe = Perspective \ Distanz2
      'Fish-bowl-Effekt korrigieren
      Wandhoehe = Wandhoehe / COS(ABS(Blickrichtung - StrahlWinkel) * DegToRad)
      'Wand zeichnen
      DrawVLine BufSeg, ray, 100 - Wandhoehe \ 2, 100 + Wandhoehe \ 2, karte(strahlx2 \ 64, strahly2 \ 64)
   ELSE
      'Hhe der Wand errechnen
      Wandhoehe = Perspective \ Distanz
      'Fish-bowl-Effekt korrigieren
      Wandhoehe = Wandhoehe / COS(ABS(Blickrichtung - StrahlWinkel) * DegToRad)
      'Wand zeichnen
      DrawVLine BufSeg, ray, 100 - Wandhoehe \ 2, 100 + Wandhoehe \ 2, karte(strahlx \ 64, strahly \ 64)
   END IF
   'Winkel des nchsten Strahls errechnen
   StrahlWinkel = StrahlWinkel + Winkelabstand
NEXT ray
END SUB

