.model medium, basic
.386
.stack 100h
.Code

;-----------------------------------------------------------------------------
; DECLARE SUB CopySegment (Byval QuellSegment%, Byval ZielSegment%)
;
; Beschreibung: Kopiert die ersten 63999 vom QuellSegment in das
;               ZielSegment. Findet Verwendung um Buffer in Video-
;               speicher zu kopieren.
;-----------------------------------------------------------------------------
public CopySegment
CopySegment proc QuellSegment:word, ZielSegment:word
   push ds
   push si

   mov ax, ZielSegment
   mov es, ax
   mov ax, QuellSegment
   mov ds, ax

   xor si, si
   xor di, di
   mov cx, 16000
   rep movsd

   pop si
   pop ds
   ret
CopySegment endp

;-----------------------------------------------------------------------------
; DECLARE SUB ClearScreen (Byval ZielSegment%, Byval Farbe%)
;
; Beschreibung: Lscht eine Bildschirmseite im Segment ZielSegment%
;               mit der gewnschten Farbe.
;-----------------------------------------------------------------------------
public ClearScreen
ClearScreen proc ZielSegment:word, Farbe:word
   push ds

   mov ax, ZielSegment
   mov es, ax
   xor di, di

   mov ax, Farbe
   mov ah, al
   mov bx, ax
   shl eax, 16
   mov ax, bx

   mov cx, 16000
   rep stosd

   pop ds
   ret
ClearScreen endp

;-----------------------------------------------------------------------------
; DECLARE SUB DrawPixel (Byval ZielSegment%, Byval x%, Byval y%, Byval Farbe%)
;
; Beschreibung: Zeichnet einen Pixel an der angegeben Position am Bildschirm
;               mit der Farbe Farbe%.
;-----------------------------------------------------------------------------
public DrawPixel
DrawPixel proc ZielSegment:word, x:word, y:word, farbe:word
   push ds

   cmp x, 319
   jg SkipPixel
   cmp x, 0
   jl SkipPixel
   cmp y, 199
   jg SkipPixel
   cmp y, 0
   jl SkipPixel

   mov ax, ZielSegment
   mov es, ax
   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   mov cx, Farbe
   mov es:[di], cl
SkipPixel:
   pop ds
   ret
DrawPixel endp

;-----------------------------------------------------------------------------
; DECLARE FUNCTION GetPixel% (Byval QuellSegment%, Byval x%, Byval y%)
;
; Beschreibung: Liefert die Farbe eines Pixel an der Position (x,y) zurck               
;-----------------------------------------------------------------------------
public GetPixel
GetPixel proc QuellSegment:word, x:word, y:word
   push ds

   cmp x, 319
   jg SkipPixel5
   cmp x, 0
   jl SkipPixel5
   cmp y, 199
   jg SkipPixel5
   cmp y, 0
   jl SkipPixel5

   mov ax, QuellSegment
   mov es, ax
   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   xor ax, ax
   mov al, es:[di]
SkipPixel5:
   pop ds
   ret
GetPixel endp

;-----------------------------------------------------------------------------
; DECLARE SUB GetPicture (Byval QuellSegment%, Byval x%, Byval y%, Byval x2%_
;                         _Byval y2%, Byval Segment%, Byval Offset%)
;
; Beschreibung: Liest den angegeben Bildausschnitt in einen Array ein.
;               
;-----------------------------------------------------------------------------
public GetPicture
GetPicture proc QuellSegment:word, x:word, y:word, x2:word, y2:word, Segm:word, Offs:word
   push ds

   mov ax, QuellSegment
   mov es, ax
   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   mov ax, Segm
   mov ds, ax
   mov si, Offs

   mov ax, x2
   sub ax, x
   inc ax
   mov ds:[si], al
   inc si
   mov bx, y2
   sub bx, y
   inc bx
   mov ds:[si], bl
   inc si
   
   mov dx, 320
   sub dx, ax

   mov Offs, ax
   yLoop1:
      xLoop1:         
         mov cl, es:[di]
         mov ds:[si], cl
         inc si
         inc di         
         dec ax         
         cmp ax, 0
      jnz xLoop1
      mov ax, Offs
      add di, dx
      dec bx      
      cmp bx, 0      
   jnz yloop1
   pop ds
   ret
GetPicture endp


;-----------------------------------------------------------------------------
; DECLARE SUB Blit (Byval ZielSegment%, Byval x%, Byval y%, Byval Segment%,_
;                   _Byval Offset%)
;
; Beschreibung: Zeichnet ein in einem Bildarray abgelegtes Bild
;               
;-----------------------------------------------------------------------------
public Blit
Blit proc ZielSegment:word, x:word, y:word, Segm:word, Offs:word
   push ds

   mov ax, ZielSegment
   mov es, ax
   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   mov ax, Segm
   mov ds, ax
   mov si, Offs

   xor bx, bx
   xor cx, cx
   mov bl, ds:[si]
   inc si
   mov cl, ds:[si]
   inc si

   mov dx, 320
   sub dx, bx

   mov Offs, bx
   yLoop1:
      xLoop1:         
         cmp x, 319
         jg SkipPixel1
         cmp x, 0
         jl SkipPixel1
         cmp y, 199
         jg SkipPixel1
         cmp y, 0
         jl SkipPixel1
         mov ch, ds:[si]
         mov es:[di], ch
      SkipPixel1:
         inc si
         inc di
         inc x
         dec bx         
         cmp bx, 0
      jnz xLoop1
      mov bx, Offs
      sub x, bx
      inc y
      add di, dx
      dec cl      
      cmp cl, 0      
   jnz yloop1
   pop ds
   ret
Blit endp

;-----------------------------------------------------------------------------
; DECLARE SUB Blittrans (Byval ZielSegment%, Byval x%, Byval y%,_
;                        _Byval Segment%, Byval Offset%)
;                   
; Beschreibung: Zeichnet ein in einem Bildarray abgelegtes Bild, wobei
;               Pixel mit dem Farbindex 0 nicht gezeichnet werden.
;-----------------------------------------------------------------------------
public Blittrans
Blittrans proc ZielSegment:word, x:word, y:word, Segm:word, Offs:word
   push ds

   mov ax, ZielSegment
   mov es, ax
   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   mov ax, Segm
   mov ds, ax
   mov si, Offs

   xor bx, bx
   xor cx, cx
   mov bl, ds:[si]
   inc si
   mov cl, ds:[si]
   inc si

   mov dx, 320
   sub dx, bx

   mov Offs, bx
   yLoop:
      xLoop:
         mov ch, ds:[si]
         cmp ch, 0
         jz SkipPixel2
         cmp x, 319
         jg SkipPixel2
         cmp x, 0
         jl SkipPixel2
         cmp y, 199
         jg SkipPixel2
         cmp y, 0
         jl SkipPixel2
         mov es:[di], ch
      SkipPixel2:
         inc si
         inc di
         inc x
         dec bx         
         cmp bx, 0
      jnz xLoop
      mov bx, Offs
      sub x, bx
      inc y
      add di, dx
      dec cl      
      cmp cl, 0      
   jnz yloop
   pop ds
   ret
Blittrans endp

;-----------------------------------------------------------------------------
; DECLARE SUB DrawHLine (Byval ZielSegment%, Byval x%,Byval x2%,Byval y%,: 
;                        _Byval Farbe%)
;                   
; Beschreibung: Zeichnet eine horizontale Line. Diese Routine beschleunigt
;               das Zeichnen von Dreiecken, da der Groteil der Rechen-
;               arbeit wegfllt
;-----------------------------------------------------------------------------
public DrawHLine
DrawHLine proc ZielSegment:word, x:word, x2:word, y:word, farbe:word
   push ds

   cmp y, 0
   jl exit
   cmp y, 199
   jg exit

   mov ax, ZielSegment
   mov es, ax

   mov ax, x
   mov cx, x2
   cmp ax, cx
   jl next1
   xchg ax, cx
next1:
   sub cx, ax
   inc cx

   mov di, y
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, ax

   mov dx, Farbe
Loop1:
   cmp ax, 0
   jl SkipPixel3
   cmp ax, 319
   jg SkipPixel3
   mov es:[di], dl
SkipPixel3:
   inc di
   inc ax
   dec cx
   cmp cx, 0
   jne Loop1
exit:
   pop ds
   ret
DrawHLine endp

;-----------------------------------------------------------------------------
; DECLARE SUB DrawVLine (Byval ZielSegment%, Byval x%,Byval y%,Byval y2%,: 
;                        _Byval Farbe%)
;                   
; Beschreibung: Zeichnet eine vertikale Line. Diese Routine beschleunigt
;               den Raycasting-prozess, da der Groteil der Rechen-
;               arbeit wegfllt
;-----------------------------------------------------------------------------
public DrawVLine
DrawVLine proc ZielSegment:word, x:word, y:word, y2:word, farbe:word
   push ds

   cmp x, 0
   jl exit2
   cmp x, 319
   jg exit2

   mov ax, ZielSegment
   mov es, ax

   mov ax, y
   mov cx, y2
   cmp ax, cx
   jl next2
   xchg ax, cx
next2:
   sub cx, ax
   inc cx

   mov di, ax
   mov bx, di
   shl di, 8
   shl bx, 6
   add di, bx
   add di, x

   mov dx, Farbe
Loop2:
   cmp ax, 0
   jl SkipPixel4
   cmp ax, 199
   jg SkipPixel4
   mov es:[di], dl
SkipPixel4:
   add di, 320
   inc ax
   dec cx
   cmp cx, 0
   jne Loop2
exit2:
   pop ds
   ret
DrawVLine endp

end
