Attribute VB_Name = "DirectX"
Public DX As New DirectX7
Public DD As DirectDraw7
Public ddsPRIM As DirectDrawSurface7
Public ddsBACK As DirectDrawSurface7
Dim ddsd_p As DDSURFACEDESC2
Public ddsd_b As DDSURFACEDESC2
Public rect_p As RECT
Public rect_b As RECT
Dim ddClip As DirectDrawClipper

Dim Layers(1 To 10) As DirectDrawSurface7
Dim ddsd(1 To 10) As DDSURFACEDESC2
Dim rects(1 To 10) As RECT
Dim layerpointer As Integer
Dim colorkey As DDCOLORKEY


Sub InitDX(Form As Form, x As Integer, y As Integer, bpp As Integer)
Dim caps As DDSCAPS2
 'Directdraw-Objekt erstellen & Displaymode setzen
  Set DD = DX.DirectDrawCreate("")
  DD.SetCooperativeLevel Form.hWnd, DDSCL_FULLSCREEN Or DDSCL_EXCLUSIVE
  DD.SetDisplayMode x, y, bpp, 0, DDSDM_DEFAULT

'Primre Surface & RECT erstellen
  ddsd_p.lFlags = DDSD_CAPS Or DDSD_BACKBUFFERCOUNT
  ddsd_p.lBackBufferCount = 1
  ddsd_p.ddsCaps.lCaps = DDSCAPS_PRIMARYSURFACE Or DDSCAPS_COMPLEX Or DDSCAPS_FLIP
  Set ddsPRIM = DD.CreateSurface(ddsd_p)
  With rect_p
    .Bottom = y
    .Right = x
  End With
  
'Backbuffer & RECT erstellen
  caps.lCaps = DDSCAPS_BACKBUFFER
  Set ddsBACK = ddsPRIM.GetAttachedSurface(caps)
  ddsBACK.GetSurfaceDesc ddsd_b
  With rect_b
    .Bottom = y
    .Right = x
  End With

'CLipper objekt fr gesamten Backbuffer erstellen
  Set ddClip = DD.CreateClipper(0)
  ddClip.SetHWnd Form.hWnd
  ddsBACK.SetClipper ddClip
'Color Objekt fr transparenz erstellen
  With colorkey
    .high = RGB(0, 0, 0)
    .low = RGB(0, 0, 0)
  End With
  
'Layerpointer auf 1 setzen
  layerpointer = 1
End Sub

Function CreateLayer(Optional file As String, Optional x As Integer, Optional y As Integer) As Boolean
  If layerpointer > 10 Then
      CreateLayer = False
      Exit Function
  End If
  
  If IsMissing(file) Then
    If x = 0 Then
      ddsd(layerpointer).lFlags = DDSD_CAPS
      ddsd(layerpointer).ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
      Set Layers(layerpointer) = DD.CreateSurface(ddsd(layerpointer))
      With rects(layerpointer)
        .Bottom = ddsd(layerpointer).lHeight
        .Right = ddsd(layerpointer).lWidth
      End With
    Else
      ddsd(layerpointer).lFlags = DDSD_CAPS Or DDSD_HEIGHT
      ddsd(layerpointer).lHeight = y
      ddsd(layerpointer).lWidth = x
      ddsd(layerpointer).ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
      Set Layers(layerpointer) = DD.CreateSurface(ddsd(layerpointer))
      With rects(layerpointer)
        .Bottom = ddsd(layerpointer).lHeight
        .Right = ddsd(layerpointer).lWidth
      End With
    End If
  Else
    If x = 0 Then
      ddsd(layerpointer).lFlags = DDSD_CAPS
      ddsd(layerpointer).ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
      Set Layers(layerpointer) = DD.CreateSurfaceFromFile(file, ddsd(layerpointer))
      With rects(layerpointer)
        .Bottom = ddsd(layerpointer).lHeight
        .Right = ddsd(layerpointer).lWidth
      End With
    Else
      ddsd(layerpointer).lFlags = DDSD_CAPS Or DDSD_HEIGHT
      ddsd(layerpointer).lHeight = y
      ddsd(layerpointer).lWidth = x
      ddsd(layerpointer).ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
      Set Layers(layerpointer) = DD.CreateSurfaceFromFile(file, ddsd(layerpointer))
      With rects(layerpointer)
        .Bottom = ddsd(layerpointer).lHeight
        .Right = ddsd(layerpointer).lWidth
      End With
    End If
  End If
  

  Layers(layerpointer).SetColorKey DDCKEY_SRCBLT, colorkey

  CreateLayer = True
  layerpointer = layerpointer + 1
      
End Function
Sub copylayertoBACK(index As Integer, x, y, ck As Boolean)
Dim tmprect As RECT
tmprect = rects(index)
With tmprect
  .Bottom = .Bottom + y
  .Top = .Top + y
  .Right = .Right + x
  .Left = .Left + x
End With
If ck Then
  ddsBACK.Blt tmprect, Layers(index), rects(index), DDBLT_WAIT Or DDBLT_KEYSRC
Else
    ddsBACK.Blt tmprect, Layers(index), rects(index), DDBLT_WAIT
End If
End Sub

Sub copylayertoBACKfast(index As Integer, x, y, ck)
If ck Then
  ddsBACK.BltFast x, y, Layers(index), rects(index), DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT
Else
    ddsBACK.BltFast x, y, Layers(index), rects(index), DDBLTFAST_WAIT
End If
End Sub

Sub ClearBack(col As Long)
  ddsBACK.BltColorFill rect_b, col
End Sub
Sub flip()
    ddsPRIM.flip Nothing, DDFLIP_WAIT
End Sub

Sub ClearDX()
  DD.RestoreDisplayMode
   Set ddsPRIM = Nothing
  Set ddsBACK = Nothing
  Set DD = Nothing
  Set DX = Nothing
End Sub

Sub DrawSlice(tex, ray, y1, y2, colum)
Dim destrect As RECT
Dim sourcerect As RECT

With destrect
  .Top = .Top + y1
  .Bottom = .Bottom + y2
  .Left = ray
  .Right = ray + 1
End With

With sourcerect
  .Top = 0
  .Bottom = 63
  .Left = colum
  .Right = colum + 1
End With

ddsBACK.Blt destrect, Layers(1), sourcerect, DDBLT_WAIT
End Sub
