VERSION 5.00
Begin VB.Form frmRayCast 
   BorderStyle     =   0  'Kein
   Caption         =   "Form1"
   ClientHeight    =   1965
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3135
   LinkTopic       =   "Form1"
   ScaleHeight     =   131
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   209
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "frmRayCast"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Diese Variablen dienen dazu den aktuellen Zustand der Pfeiltasten
'aufzunehmen. Die Variable einer Taste ist TRUE wenn sie niedergedrckt
'wird.
Public lkey As Boolean
Public rkey As Boolean
Public ukey As Boolean
Public dkey As Boolean
'dMap gibt an ob die klein Karte im Fullscreenmodus gezeichnet werden soll.
'Sie knne zwischen den beiden Optionen durch druck auf die Leertaste wechseln
Public dMap As Boolean
'Fullscreen gibt an ob die Anwendung mit 320x200 Pixel arbeiten soll
'oder mit 640x480 plus der 2D-Karte. Der Wert wird ber das Drcken
'eines der beiden Buttons der Form frmMENU festgelegt. Dabei bedeutet
'TRUE dass die Anwendung mit 320x200 Pixel Auflsung arbeiten soll
Public FullScreen As Boolean


Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
'Wertet einen Tastendruck aus. Solange eine der Pfeiltasten niedergedrckt
'wird, ist ihre Variable True
Select Case KeyCode
  'Linke Taste
  Case vbKeyLeft
    lkey = True
  'Rechte Taste
  Case vbKeyRight
    rkey = True
  'Aufwrts Taste
  Case vbKeyUp
    ukey = True
  'Abwrts Taste
  Case vbKeyDown
    dkey = True
End Select
End Sub

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
'Wertet einen Tastendruck aus. Wurde eine der Pfeiltasten losgelassen
'wird ihre Variable auf FALSE gesetzt. Auserdem erfolgt eine Abruch des
'Programms wenn die Escape Taste losgelassen (und damit gedrckt) wurde.
Select Case KeyCode
  'linke Taste
  Case vbKeyLeft
    lkey = False
  'rechte Taste
  Case vbKeyRight
    rkey = False
  'Aufwrts Taste
  Case vbKeyUp
    ukey = False
  'Abwrts Taste
  Case vbKeyDown
    dkey = False
  'Escape Taste -> Abbruch des Programms
  Case vbKeyEscape
    Unload Me
  Case vbKeySpace
    dMap = Not dMap
End Select
End Sub

Private Sub Form_Load()
'Menu-Form anzeigen. Hier erfolgt die Auswahl des Modus vom Benutzer. Die
'Form ist gebunden, d.h. sie besitzt solange den Fokus bis sie entladen wird
frmMenu.Show vbModal, Me

'Trigonometrische-Tabellen erstellen
MakeTables

'Position und Blickrichtung des Betrachters festlegen
xp = 2 * 64
yp = 2 * 64
direction = 480

'Aufruf der Hauptschleife
main

End Sub

Sub main()

Do
'HintergrundBild in den Buffer kopieren
copylayertoBACK 2, 0, 0, False

'Raycasting Routine aufrufen
RayCasting

'Befinden wir uns nicht im 320x200 Pixel Modus wird die 2D-Karte gezeichnet
If FullScreen Then
  If dMap Then
    Drawmap2
  End If
Else
  Drawmap
End If

'Kopiere den Buffer in den Videospeicher. (In Wirklichkeit funktioniert diese
'Methode etwas anders. Sowohl der Buffer als auch der sichtbare Speicher
'befinden sich im Video-RAM. Eine Zeiger-Variable zeigt auf den Beginn des
'sichtbaren Speichers ein zweiter auf den Beginn des Buffers. Die Methode
'vertauscht den Inhalt der beiden Zeiger und macht somit den Buffer sichtbar
'und weist den bisher sichtbaren Speicher als Buffer aus. Allgemein wird das
'als Pageflipping bezeichnet
flip

'Auswertung der gepressten Tasten
'Abwrts-Taste gedrckt: Bewegung des Betrachters rckwrts
If dkey Then
  xp = xp - CosTable(direction) * 10
  yp = yp - SinTable(direction) * 10
  'Befindet sich an der neuen Position des Betrachters eine Mauer
  'wird er auf die alte Position zurckgesetzt
  If Karte(xp \ 64, yp \ 64) <> 0 Then
    xp = xp + CosTable(direction) * 10
    yp = yp + SinTable(direction) * 10
  End If
'Aufwrts-Taste gedrckt: Bewegung des Betrachters vorwrts
ElseIf ukey Then
  xp = xp + CosTable(direction) * 10
  yp = yp + SinTable(direction) * 10
  'Befindet sich an der neuen Position des Betrachters eine Mauer
  'wird er auf die alte Position zurckgesetzt
  If Karte(xp \ 64, yp \ 64) <> 0 Then
    xp = xp - CosTable(direction) * 10
    yp = yp - SinTable(direction) * 10
  End If
'Links-Taste gedrckt: Rotation des Betrachters gegen den Uhrzeigersinn
ElseIf lkey Then
  direction = direction - 15
  'Wird der Indexbereich der Trigonometrie-Tabellen verlassen, wird
  'die Blickrichtung auf 1920 gesetzt
  If direction < 0 Then direction = 1920
'Rechts-Taste gedrckt: Rotation des Betrachters im Uhrzeigersinn
ElseIf rkey Then
  direction = direction + 15
  'Wird der Indexbereich der Trigonometrie-Tabellen verlassen, wird
  'die Blickrichtung auf 0 gesetzt
  If direction > 1920 Then direction = 0
End If

'Kontrolle an Windows bergeben, damit es die Events bearbeiten kann
'(Maus, Tastatur etc.). Ohne diesen Aufruf knnten keine Eingaben vom
'Benutzer entgegengenommen werden.
DoEvents

Loop
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
'Wird kurz vor dem Programmabbruch aufgerufen. Entldt das Formular sowie
'die DirectX-Objekte. Dies ist sehr wichtig, da sonst der benutzte Speicher
'nicht freigegeben wrde.
  Unload Me
  ClearDX
  End
End Sub

Sub Drawmap()
'Zeichnet die 2D-Karte sowie die Strahlen die ausgesendet wurden im
'640x480 Pixel Modus. Alle Zeichen-operationen werden auf den Buffer
'angewendet.

'Hier werden zwei Rechtecke gezeichnet, da der Raycaster teilweise auerhalb
'des 320x200 Pixel Bereiches zeichnet. Dies wre eine unschner Effekt,
'weshalb diese Teile berschrieben werden
ddsBACK.SetFillStyle 0
ddsBACK.SetFillColor RGB(0, 0, 0)
ddsBACK.DrawBox 0, 200, 640, 480
ddsBACK.DrawBox 320, 0, 640, 200

'Die Zeilen geben die Position sowie die Blickrichtung des Betrachters in
'Grad neben der projizierten Ansicht der Welt aus.
ddsBACK.SetForeColor RGB(0, 255, 0)
ddsBACK.DrawText 320, 0, "Beobachter X:" + Str$(Int(xp)), False
ddsBACK.DrawText 320, 16, "Beobachter Y:" + Str$(yp), False
ddsBACK.DrawText 320, 32, "Beobachter Richtung:" + Str$(Int(direction * (360 / 1920))) + " Grad", False

'Das zweidimensionale Feld Zeichnen
ddsBACK.SetForeColor RGB(0, 0, 0)
For y = 0 To 9
  For x = 0 To 9
    'Befindet sich auf dem abgefragten Feld eine Mauer, ist die Fllfarbe
    'Rot (1*255). Sonst wird ein schwarzes Feld gezeichnet (0*255)
    ddsBACK.SetFillColor RGB(Karte(x, y) * 255, 0, 0)
    ddsBACK.DrawBox x * 32 + 320, y * 32 + 160, x * 32 + 32 + 320, y * 32 + 32 + 160
  Next x
Next y

'Die ausgesendeten Strahlen in der Farbe grn (RGB = (0;255,0) zeichnen.
'Innerhalb der Raycasting-Routine wurden die Koordinaten der der Schnittpunkte
'der Strahlen in den Arrays rayx() und rayy() gespeichert. Zwischen dem
'Betrachter und dem Schnittpunkt wird einfach eine Linie gezeichnet.
ddsBACK.SetForeColor RGB(0, 255, 0)
For ray = 0 To 319
  ddsBACK.DrawLine xp \ 2 + 320, yp \ 2 + 160, rayx(ray) + 320, rayy(ray) + 160
Next ray

'Zeichenfarbe auf Schwarz setzen
ddsBACK.SetForeColor RGB(0, 0, 0)

End Sub

Sub Drawmap2()
'Zeichnet eine kleine 2d-Karte zur Orientierung

'Das zweidimensionale Feld Zeichnen
For y = 0 To 19
  For x = 0 To 19
    'Befindet sich auf dem abgefragten Feld eine Mauer, ist die Fllfarbe
    'Rot (1*255). Sonst wird ein schwarzes Feld gezeichnet (0*255)
    If Karte(x, y) <> 0 Then
      ddsBACK.SetForeColor RGB(0, Karte(x, y) * 255, 0)
      ddsBACK.DrawLine x + 299, y, x + 300, y
    End If
  Next x
Next y

'Betrachter zeichnen
ddsBACK.SetForeColor RGB(255, 0, 0)
ddsBACK.DrawLine xp \ 64 + 299, yp \ 64, xp \ 64 + 300, yp \ 64

'Zeichenfarbe auf Schwarz setzen
ddsBACK.SetForeColor RGB(0, 0, 0)

End Sub

