Attribute VB_Name = "RayCast"
Option Explicit
'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........VBRAY.BAS / Kapitel 3.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........2.2.2002
' Beschreibung:    Ein "einfaches" Raycasting-Beispiel. Sie bewegen sich
'                  mit den Cursortasten durch die Welt.
'----------------------------------------------------------------------------

'Diese Arrays dienen als Tabellen fr die verschiedenen trigonometrischen
'Funktionen. Man geht dabei davon aus dass der Computer nicht immer von
'neuen die bentigten Funktionen berechnen mu, sondern diese nur einmal
'am Anfang des Programms berechnet und dann in einen Array gespeichert werden.
'Von der werden sie dann jedesmal ausgelesen und in die Berechnungen
'einbezogen. Um solche Tabellen erstellen zu knnen, mu man wissen, welche
'Winkel fr einen Strahl mglich sind. Fr uns sind immer 60 Grad von
'mglichen 360 Grad sichtbar.
'Diese 60 Grad werden aufgrund des spaltenweisen Aussendens der Strahlen
'in 320 UnterGrad unterteilt. 1 Grad entspricht daher 320 / 60 = 5.6666..
'Untergrad was bei 360 Grad 1920 Untergrad ausmacht. Die Schrittweite in
'betrgt in Grad 0.1875 in UnterGrad 1. Der Betrachter kann sich also mit
'einer Genauigkeit von 0.1875 Grad um die eigene Achse drehen.
'Jeder Array muss daher 1920 Elemente gro sein.

Public TanTable(0 To 1920) As Single
Public InvTanTable(0 To 1920) As Single
Public CosTable(0 To 1920) As Single
Public InvCosTable(0 To 1920) As Single
Public SinTable(0 To 1920) As Single

'Die Werte xa bzw. ya knnen ebenfalls fr jeden Winkel vorberechnet werden
Public stepx(0 To 1920) As Single
Public stepy(0 To 1920) As Single

'Einige Konstanen die das arbeiten mit Untergrad erleichtern
'90 Grad sind z.B. 480 Untergrad, was bedeutet das der Tangens von
'90 Grad sich im Element mit dem Index 480 befindet etc.
Const Angle0% = 0
Const Angle90% = 480
Const Angle180% = 960
Const Angle270% = 1440
Const Angle360% = 1920

'Konstante zum Umrechnen von Grad in Bogenma
Const DEGtoRAD = 1 / 57.2958

'Hier werden die x- und y-Koordinaten der einzelnen Schnittpunkte der
'Strahlen gespeichert. Diese werden spter zum Zeichnen des Blickfeldes
'auf der 2D-Karte bentigt.
Global rayx(319) As Integer
Global rayy(319) As Integer

'Array der Weltkarte (10x10 Felder)
Global Karte(0 To 320, 0 To 200) As Integer
Public maxX, maxY As Integer
'x- und y-Koordinate des Betrachters angegeben in Einheitenkoordinaten
Global xp As Single
Global yp As Single
'Blickrichtung des Betrachters angegeben in Untergrad (ganzzahliger Wert)
Global direction As Integer

Sub LoadMap(file As String)
'Ldt die ber das Argument file angegebene Karte aus der Datei in den
'Array Karte()
Dim x, y, Feld
If frmRayCast.FullScreen Then
  maxX = 20
  maxY = 20
Else
  maxX = 10
  maxY = 10
End If
  Open file For Input As #1
  For y = 0 To maxX - 1
     For x = 0 To maxY - 1
        Input #1, Feld
        Karte(x, y) = Feld
    Next x
  Next y
  Close #1
End Sub

Sub MakeTables()
'Erstellt die trigonometrischen Tabellen

'Gibt den Index des akutellen Array-Elements bzw. den aktuellen Winkel in
'Untergrad an
Dim index As Integer
Dim RadAngle As Double

'Trigonometrisch Funktionen fr alle 1920 Untergrad berechnen
  For index = Angle0% To Angle360%
      'Winkel von Untergrad in Bogenma umrechnen.
      'Grad = UnterGrad(Index) * (360/1920)
      'Bogenma = Grad * DEGtoRAD
      'Bogenma = UnterGrad(Index) * (360/1920) * DEGtoRad
      '         = UnterGrad(Index) * 3.27249234791667E-03
      'Der Wert 0.0003272 wird zum Bogenma dazugerechnet da sonst
      'bei den Graden 0, 90, 180, 270 und 360 bei den verschiedenen
      'Trig-Funktionen der Wert 0 bzw. ein Rechenfehler auftreten wrde
      'D.h. das Element mit Index 0 einer Tabelle besitzt nicht den Wert
      'TrigFunktion(0) sondern TrigFunktion(0.0003272), womit dieses Problem
      'gelst wre. Bei den inversen Tabellen wrde sonst auch eine
      'Division durch null auftreten.
      RadAngle = 0.0003272 + index * 3.27249234791667E-03
      
      'Tangens-Tabelle
      TanTable(index) = Tan(RadAngle)
      'inverser Tangens-Tabelle
      InvTanTable(index) = 1 / TanTable(index)
      'Cosinus-Tabelle
      CosTable(index) = Cos(RadAngle)
      'inverser Cosinus-Tabelle
      InvCosTable(index) = 1 / Cos(RadAngle)
      'Sinus-Tabelle
      SinTable(index) = Sin(RadAngle)
      
      'xa vorberechnen in abhngigkeit von left oder right-Strahl
      If index >= Angle0% And index < Angle180% Then
          stepy(index) = Abs(TanTable(index) * 64)
      Else
          stepy(index) = -Abs(TanTable(index) * 64)
      End If
      
      'ya vorberechnen in abhngigkeit von up oder down-Strahl
      If index >= Angle90% And index < Angle270% Then
          stepx(index) = -Abs(InvTanTable(index) * 64)
      Else
          stepx(index) = Abs(InvTanTable(index) * 64)
      End If
  Next
End Sub

Sub RayCasting()
'Die eigentliche Raycastin-Routine

'Diese Variablen geben die Zelle an in der sich der Strahl zur Zeit befindet
Dim CellX As Integer
Dim CellY As Integer


Dim XonHorizontal As Single
Dim horizontal As Single
Dim nexty As Integer
Dim nexthorizontal As Integer
Dim DistTOHorizontal As Single

Dim YonVertical As Single
Dim vertical As Single
Dim nextx As Integer
Dim nextvertical As Integer
Dim ray As Integer
Dim DistTOVertical As Single

Dim slice As Integer

Dim angle As Integer

   angle = direction - 160
   If angle < 0 Then angle = 1920 + angle
   If angle = 480 Then angle = 481
   If angle = 1440 Then angle = 1441

For ray = 0 To 319
   If angle < 960 Then
      horizontal = (yp \ 64) * 64 + 64
      XonHorizontal = InvTanTable(angle) * (horizontal - yp) + xp
      nexthorizontal = 64
      nexty = 0
   Else
      horizontal = (yp \ 64) * 64
      XonHorizontal = InvTanTable(angle) * (horizontal - yp) + xp
      nexthorizontal = -64
      nexty = -1
   End If

   If angle < 480 Or angle > 1440 Then
      vertical = (xp \ 64) * 64 + 64
      YonVertical = TanTable(angle) * (vertical - xp) + yp
      nextvertical = 64
      nextx = 0
   Else
      vertical = (xp \ 64) * 64
      YonVertical = TanTable(angle) * (vertical - xp) + yp
      nextvertical = -64
      nextx = -1
   End If


   Do
      If XonHorizontal > maxX * 64 - 1 Or XonHorizontal < 0 Then
         DistTOHorizontal = 100000
         Exit Do
      End If
      CellX = Int((XonHorizontal / 64))
      CellY = Int((horizontal / 64) + nexty)
      If Karte(CellX, CellY) Then
         If angle = 480 Or angle = 1440 Then DistTOHorizontal = Abs(yp - horizontal) * CosTable(Abs(angle - direction)): Exit Do
         DistTOHorizontal = Abs(InvCosTable(angle) * (xp - XonHorizontal)) * CosTable(Abs(angle - direction))
         Exit Do
      End If
      horizontal = horizontal + nexthorizontal
      XonHorizontal = XonHorizontal + stepx(angle)
   Loop
 
   Do
      If YonVertical > maxY * 64 - 1 Or YonVertical < 0 Then
         DistTOVertical = 100000
         Exit Do
      End If
      CellX = Int((vertical / 64)) + nextx
      CellY = Int((YonVertical / 64))
      If Karte(CellX, CellY) Then
         DistTOVertical = Abs(InvCosTable(angle) * (xp - vertical)) * CosTable(Abs(angle - direction))
         Exit Do
      End If
      vertical = vertical + nextvertical
      YonVertical = YonVertical + stepy(angle)
   Loop

   If DistTOHorizontal < DistTOVertical Then
      slice = 64 / DistTOHorizontal * 277 \ 2
      DrawSlice 1, ray, 100 - slice, 100 + slice, XonHorizontal Mod 64
      rayx(ray) = XonHorizontal \ 2
      rayy(ray) = horizontal \ 2
   Else
      slice = (64 / (DistTOVertical + 1) * 277 \ 2)
      DrawSlice 1, ray, 100 - slice, 100 + slice, YonVertical Mod 64
      rayx(ray) = vertical \ 2
      rayy(ray) = YonVertical \ 2
   End If
   angle = angle + 1
   If angle >= 1920 Then angle = 0
Next ray
End Sub

