'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........SPRANIM.BAS / Kapitel 3.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........18.1.2002
' Beschreibung:    Demonstriert das Prinzip hinter animierten Sprites
'                  unter Verwendung von Double Buffering. Die Frames des
'                  Sprites wurden in einer Bitmap-Datei gespeichert die
'                  die Funktion LoadBMP() einliest. Danach werden alle
'                  vier Frames in den Array Frames() eingelesen.
'----------------------------------------------------------------------------

DECLARE SUB LoadBMP (File AS STRING)
'$INCLUDE: 'DBASM.BI'

DIM Frames((16 * 16 + 2) * 8 - 1) AS STRING * 1
DIM Back((16 * 16 + 2) - 1) AS STRING * 1

TYPE sprite
   x AS INTEGER
   y AS INTEGER
   FRSegment AS INTEGER
   FrOffset AS INTEGER
   BaSegment AS INTEGER
   Baoffset AS INTEGER
   CurFrame AS INTEGER
END TYPE

DIM Spr AS sprite
   Spr.x = 152
   Spr.y = 92
   Spr.FRSegment = VARSEG(Frames(0))
   Spr.FrOffset = VARPTR(Frames(0))
   Spr.BaSegment = VARSEG(Back(0))
   Spr.Baoffset = VARPTR(Back(0))
   Spr.CurFrame = 0

SCREEN 13

'Bitmap-Datei mit Sprites einlesen und in Array Frames() speichern
   LoadBMP "D:\Test.bmp"

   index = 0
   FOR x = 0 TO 64 STEP 16
      GetPicture Vidseg, x, 0, x + 15, 15, VARSEG(Frames(0)), VARPTR(Frames(index * 258))
      index = index + 1
   NEXT x
     
'Animationsschleife
   ZeitSpanne = TIMER
   DO
      BlitTrans BufSeg, Spr.x, Spr.y, Spr.FRSegment, Spr.FrOffset
      CopySegment BufSeg, Vidseg
      Blit BufSeg, Spr.x, Spr.y, Spr.BaSegment, Spr.Baoffset

      IF TIMER - ZeitSpanne > .1 THEN
         Spr.CurFrame = Spr.CurFrame + 1
         IF Spr.CurFrame > 3 THEN Spr.CurFrame = 0
         Spr.FrOffset = VARPTR(Frames(Spr.CurFrame * 258))
         ZeitSpanne = TIMER
      END IF
   LOOP UNTIL INKEY$ <> ""

SUB LoadBMP (File AS STRING)
DIM Pixel AS STRING * 1
DIM r(255) AS STRING * 1
DIM b(255) AS STRING * 1
DIM g(255) AS STRING * 1

OPEN File FOR BINARY AS #1
   DEF SEG = &HA000
   GET #1, 54, Pixel
   FOR t = 0 TO 255
      GET #1, , b(t)
      GET #1, , g(t)
      GET #1, , r(t)
      GET #1, , Pixel
   NEXT t

   FOR t = 0 TO 255
      OUT &H3C8, t
      OUT &H3C9, ASC(r(t))
      OUT &H3C9, ASC(g(t))
      OUT &H3C9, ASC(b(t))
   NEXT t

   GET #1, 1078, Pixel
   FOR y = 199 TO 0 STEP -1
   FOR x = 0 TO 319
      GET #1, , Pixel
      POKE y * 320& + x, ASC(Pixel)
   NEXT x
   NEXT y
   DEF SEG
CLOSE #1


END SUB

