'----------------------------------------------------------------------------
' Fachbereichsarbeit....Informatik
' Beispielkode..........SPRITES.BAS / Kapitel 3.1
' Programmiersprache....QuickBasic 4.5
' Erstellt am...........18.1.2002
' Beschreibung:    Demonstriert das Prinzip hinter nicht animierten Sprites
'                  unter Verwendung von Double Buffering.
'----------------------------------------------------------------------------
'$INCLUDE: 'DBASM.BI'

CONST BytesPerFrame = 17 * 17 + 2
DIM Frame(BytesPerFrame - 1) AS STRING * 1
DIM Back(BytesPerFrame * 2 - 1) AS STRING * 1

TYPE Sprite
   x AS INTEGER
   y AS INTEGER
   FrSegment AS INTEGER
   FrOffset AS INTEGER
   BaSegment AS INTEGER
   BaOffset AS INTEGER
END TYPE

DIM Spr1, Spr2 AS Sprite
Spr1.x = RND * 319: Spr1.y = RND * 199
Spr1.FrSegment = VARSEG(Frame(0))
Spr1.FrOffset = VARPTR(Frame(BytesPerFrame * 0))
Spr1.BaSegment = VARSEG(Back(0))
Spr1.BaOffset = VARPTR(Back(BytesPerFrame * 0))

Spr2.x = RND * 319: Spr2.y = RND * 199
Spr2.FrSegment = VARSEG(Frame(0))
Spr2.FrOffset = VARPTR(Frame(BytesPerFrame * 0))
Spr2.BaSegment = VARSEG(Back(0))
Spr2.BaOffset = VARPTR(Back(BytesPerFrame * 1))

SCREEN 13

'Bild zeichnen und in Array Bild() einlesen
   CIRCLE (8, 8), 8, 14
   CIRCLE (6, 6), 2, 14
   CIRCLE (10, 6), 2, 14
   PAINT (6, 6), 15, 14
   PAINT (10, 6), 15, 14
   PAINT (8, 8), 14, 14
   LINE (6, 12)-(11, 12), 16
   CIRCLE (6, 6), 2, 16
   CIRCLE (10, 6), 2, 16
   PSET (7, 7), 16
   PSET (9, 7), 16
   GetPicture Vidseg, 0, 0, 16, 16, VARSEG(Frame(0)), VARPTR(Frame(0))

'Blauen Hintergrund im Buffer erstellen
   ClearScreen BufSeg, 1

'Hintergrundausschnitte einlesen
   GetPicture BufSeg, Spr1.x, Spr1.y, Spr1.x + 16, Spr1.y + 16, Spr1.BaSegment, Spr1.BaOffset
   GetPicture BufSeg, Spr2.x, Spr2.y, Spr2.x + 16, Spr2.y + 16, Spr2.BaSegment, Spr2.BaOffset
   
'Hauptschleife
   DO
      'Sprites zeichnen und Buffer in Videospeicher kopieren
      BlitTrans BufSeg, Spr1.x, Spr1.y, Spr1.FrSegment, Spr1.FrOffset
      BlitTrans BufSeg, Spr2.x, Spr2.y, Spr2.FrSegment, Spr2.FrOffset
      CopySegment BufSeg, Vidseg

      'Hintergrund im Buffer restaurieren  
      Blit BufSeg, Spr1.x, Spr1.y, Spr1.BaSegment, Spr1.BaOffset
      Blit BufSeg, Spr2.x, Spr2.y, Spr2.BaSegment, Spr2.BaOffset

      'Sprites bewegen
      Spr1.x = Spr1.x + 1: Spr2.x = Spr2.x + 1
      IF Spr1.x > 319 THEN Spr1.x = RND * 319: Spr1.y = RND * 199
      IF Spr2.x > 319 THEN Spr2.x = RND * 319: Spr2.y = RND * 199

      'Hintergrundausschnitte der SPrites einlesen
      GetPicture BufSeg, Spr1.x, Spr1.y, Spr1.x + 16, Spr1.y + 16, Spr1.BaSegment, Spr1.BaOffset
      GetPicture BufSeg, Spr2.x, Spr2.y, Spr2.x + 16, Spr2.y + 16, Spr2.BaSegment, Spr2.BaOffset

      'kleine Verzgerung einbauen, sonst sind die Sprites zu schnell
      FOR t& = 0 TO 64000
      NEXT t&
LOOP UNTIL INKEY$ = CHR$(27)

