REM Polynomwertbestimmung mittels
REM erweiterten HORNER -Schema
REM M. Meiler, 21.01.2002

DO
  CLS
  GOSUB polynomeingabe: PRINT
  PRINT "Eingegebenes Polynom": GOSUB polynomausgabe: PRINT
  DO
    GOSUB argumenteingabe: PRINT : GOSUB horner2
    GOSUB polynomwertausgabe: PRINT
    PRINT "Berechnen des gleichen Polynoms ";
    INPUT "mit neuem Argument(j/n)? ", Weiter$
  LOOP WHILE Weiter$ = "j"
  INPUT "Berechnen eines neuen Polynoms(j/n)? ", Weiter$
LOOP WHILE Weiter$ = "j"
END

REM Eingabe des Grads und der Koeffizienten des Polynoms
polynomeingabe:
DO
  INPUT "Grad des Polynoms (r > 0): ", r%
LOOP UNTIL r% > 0
REDIM a!(r%)
PRINT "Koeffizienteneingabe"
FOR i% = 0 TO r%
  PRINT "a!("; i%; ")="; : INPUT " ", a!(i%)
NEXT i%
RETURN

REM Eingabe des Arguments zur Berechnung des Polynomwertes
argumenteingabe:
INPUT "Argument x = ", x!
RETURN

REM Berechnung des Polynomwertes und der 1. Ableitung
REM mittels erweitertem Horner
horner2:
b! = 0: c! = 0
FOR k% = r% TO 0 STEP -1
  b! = a!(k%) + b! * x!:  'PRINT "b("; k%; ")="; b!;
  IF k% <> 0 THEN
    c! = b! + c! * x!:  'PRINT "c("; k%; ")="; c!
  END IF
NEXT k%
y! = b!: y1! = c!
RETURN

REM Ausgabe des Polynoms in ueblicher Schreibweise
polynomausgabe:
FOR ii% = 0 TO r%
  PRINT a!(ii%); "x^"; ii%; : IF ii% <> r% THEN PRINT "+ ";
NEXT ii%
PRINT
RETURN

REM Ausgabe des berechneten Polynomwertes
polynomwertausgabe:
PRINT "P("; x!; ")="; y!: PRINT "P'("; x!; ")="; y1!
RETURN

