REM Newtonverfahren (Tangentenverfahren)
REM Nullstellenberechnung in Polynomen
REM M. Meiler, 27.01.2003

' EPS#    ... Genauigkeit fuer Abbruchbedingung
' r%      ... Grad des Polynoms
' a#( i%) ... i. Koeffizient des Polynoms
' a!      ... Startwert
' x0#     ... Naeherung, anfangs a!
' y0#     ... Funktionswert an der Stelle x0#
' y1#     ... 1. Ableitung an der Stelle x0#
' x#      ... Argument fuer Polynomberechnung nach Horner
' b#      ... Funktionswert an der Stelle x# nach Horner
' c#      ... 1. Ableitung an der Stelle x# nach Horner


DO
  CLS
  GOSUB polynomeingabe
  DO
    GOSUB epseingabe
    DO
      GOSUB startwerteingabe
      GOSUB newton
      GOSUB ausgabe
      INPUT "Neuer Startnaeherungswert (j/n)? ", Weiter$
    LOOP WHILE Weiter$ = "j"
    INPUT "Neue Genauigkeit (j/n)? ", Weiter$
  LOOP WHILE Weiter$ = "j"
  INPUT "Neues Polynom (j/n)? ", Weiter$
LOOP WHILE Weiter$ = "j"
END


polynomeingabe:
DO
  INPUT "Grad des Polynoms (r>0): ", r%
LOOP UNTIL r% > 0
REDIM a#(r% + 1)
PRINT "Koeffizienteneingabe"
FOR i% = 0 TO r%
  PRINT "a("; i%; ")="; : INPUT " ", a#(i%)
NEXT i%
RETURN


epseingabe:
DO
  PRINT "Genauigkeit (0<EPS<1)": PRINT
  INPUT "EPS = ", EPS#
LOOP UNTIL 0 < EPS# AND EPS# < 1
RETURN


startwerteingabe:
INPUT "Startwert a= ", a!
x0# = a!
RETURN


newton:
x# = x0#: GOSUB horner: y0# = b#: y1# = c#
DO
  ' Testausgabe
  ' LOCATE , 10: PRINT x0#
  ' Testausgabe
  ' LOCATE , 10: PRINT y0#; : LOCATE , 40: PRINT y1#: PRINT

  IF ABS(y0#) < EPS# THEN EXIT DO

  x0# = x0# - y0# / y1#                            ' Newton
  x# = x0#: GOSUB horner: y0# = b#: y1# = c#
LOOP
RETURN


horner:
b# = 0: c# = 0
FOR k% = r% TO 0 STEP -1
  b# = a#(k%) + b# * x#
  IF k% <> 0 THEN c# = b# + c# * x#
  ' PRINT "b="; b#; "c="; c#
NEXT k%
RETURN


ausgabe:
PRINT "Das Newtonverfahren auf das Polynom mit den Koeffizienten"
FOR ii% = 0 TO r%
  PRINT "a("; ii%; ")="; a#(ii%)
NEXT ii%
PRINT "und den Startwert "; a!; "angewand,"
PRINT "liefert als Nullstelle den Wert "; x0#; "!"
PRINT
RETURN

