REM Integration von Polynomen mittels Trapezregel
REM Polynomwertbestimmung mittels HORNER-Schema
REM M. Meiler, 20.01.2003

REM Hauptprogramm
CLS : GOSUB eingabe: GOSUB trapez: GOSUB ausgabe
END


REM Eingabe der obere und unteren Grenze
REM und Berechnung der Stuetzstellen
eingabe:
GOSUB polynomeingabe: PRINT
GOSUB grenzeneingabe: PRINT
GOSUB stuetzstellen: PRINT
RETURN


REM Eingabe des Grades und der Koeffizienten des Polynoms
polynomeingabe:
DO
  INPUT "Grad des Polynoms(r > 0): ", r%
LOOP UNTIL r% > 0
REDIM a!(r%)
PRINT "Koeffizienteneingabe"
FOR i% = 0 TO r%
  PRINT "a!("; i%; ")="; : INPUT " ", a!(i%)
NEXT i%
RETURN


REM Eingabe der obere und unteren Grenze
grenzeneingabe:
DO
  INPUT "Untere Integrationsgrenze a= ", a!
  INPUT "Obere Integrationsgrenze b(b>a)= ", b!
LOOP UNTIL (b! - a!) > 0
RETURN


REM Berechnung der Stuetzstellen mittels HORNER
stuetzstellen:
DO
  INPUT "Anzahl der Stuetzstellen (s > 1): ", s%
LOOP UNTIL s% >= 2

n% = s% - 1
h! = (b! - a!) / n%
REDIM y!(n%)

FOR i% = 0 TO n%
  x! = a! + i% * h!
  GOSUB horner1: y!(i%) = y!
NEXT i%
RETURN


REM Berechnung des Polynomwertes mittels Horner
horner1:
b! = 0
FOR k% = r% TO 0 STEP -1
  b! = a!(k%) + b! * x! ': PRINT "b("; k%; ")="; b!
NEXT k%
y! = b!
RETURN


REM Berechnung des Integrals mittels Trapezregel
trapez:
y! = y!(0) + y!(n%)

FOR j% = 1 TO n% - 1
  y! = y! + 2 * y!(j%)
NEXT j%

y! = y! * h! / 2
RETURN


REM Ausgabe des Ergebnisses
ausgabe:
PRINT "Ergebnis: "; y!
PRINT
RETURN


