<!C:"QBasic/QuickBASIC Programs. Copyright (C) Arpith Jacob, 1996">
<!C:"Do Not Tamper With It !!!!">
<PAGESTART:".BMP.Viewer.File">
DIM xstart, xsiz, ystart, ysiz AS INTEGER
DEF SEG = 0
'generate image
'CLS
FILES "C:\WINDOWS\*.bmp"
RANDOMIZE TIMER
grey = 0            'My dithering algorithm needs work, beware.
slowpal = 0
va = &H3C8
vd = &H3C9

INPUT "Bitmap filename to load: ", filename$
PRINT
PRINT "The Program will read in the source file and display it on the screen."
PRINT
PRINT "Source file: "; filename$
PRINT
CLS
IF INSTR(filename$, ".") = 0 THEN filename$ = filename$ + ".BMP"
OPEN filename$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
   CLOSE #1
   PRINT "Empty File. Deleting"
   KILL filename$
   END
END IF

header$ = SPACE$(14)
sizing$ = SPACE$(4)
GET #1, 1, header$
IF LEN(header$) = 0 THEN PRINT "Not a valid Bitmap file.": CLOSE : END
IF MID$(header$, 1, 2) <> "BM" THEN PRINT "Not a valid Bitmap file.": CLOSE : END
GET #1, 15, sizing$
bmpinfosize = CVI(sizing$)
'bmpinfosize - Is the size of the information header for the bitmap.
'              Different bitmap versions have variations in filetypes.
'              40 is a standard windows 3.1 bitmap.
'              12 is for OS/2 bitmaps
'The next routine reads in the appropriate headers and colour tables.
'nbits is the number of bits per pixel - i.e. number of colours
'1 bit = 2 colours, 4 bits = 16 colours, 8 bits = 256 colours, etc.
'the 24 bit mode does not have a palette, its colours are expressed as
'image data

'Design of a windows 3.1 bitmap - Taken from bmp.txt on the
'x2ftp.oulu.fi ftp site under /pub/msdos/programming/formats
'Specifications for a Windows 3.1 bitmap. (.BMP)
'Email any questions/responses to me at zabudsk@ecf.utoronto.ca
'or post to alt.lang.basic or comp.lang.basic.misc.

'       | # of   |
'Offset | bytes  | Function (value)
'-------+--------+--- General Picture information starts here---------
'  0    |   2    | (BM) - Tells us that the picture is in bmp format
'  2    |   4    | Size of the file (without header?)
'  6    |   2    | (0) Reserved1 - Must be zero
'  8    |   2    | (0) Reserved2 - Must be zero
'  10   |   4    | Number of bytes offset of the picture data
'-------+--------+--- Information Header starts here -----------------
'  14   |   4    | (40/12) Size of information header (Win3.1/OS2)
'  18   |   4    | Picture width in pixels
'  22   |   4    | Picture Height in pixels
'  26   |   2    | (1) Number of planes, must be 1
'  28   |   2    | Number of bits per pixel (bpp), must be 1,4,8 or 24
'  30   |   4    | (0) Compression - 0 means no compression, 1,2 are RLEs
'  34   |   4    | Image size in bytes
'  38   |   4    | picture width in pels per metre
'  42   |   4    | picture height in pels per metre
'  46   |   4    | (0) Number of colours used in the picture, 0 means all
'  50   |   4    | (0) Number of important colours, 0 means all
'-------+--------+--- Palette data starts here -----------------------
'  54   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  55   |   1    | (g) - green intensity component, color 0 - range 0 to 255
'  56   |   1    | (r) - red intensity component, color 0 - range 0 to 255
'  57   |   1    | (0) - unused
'  58   |   1    | (b) - blue intensity component, color 0 - range 0 to 255
'  ...  | ...    |
'  54   | 4*2^bpp| total range of palette
'-------+--------+--- Image data starts here -------------------------
'54+    | width* | Bitmap data starting at lower left portion of the
'(4*2^n)| height*| image moving from left towards right. Moving up 1
'       | (8/bpp)| pixel when at the right hand side of the image, starting
'       |        | from the left side again, until the top right of the
'       |        | image is reached

'Note that this format is slightly different for a OS/2 Bitmap.
'The header is the same up to (but not including) bit 30-
'The palette colour values follow at bit 30, with the form...
'1 byte blue intensity
'1 byte green intensity
'1 byte red intensity
'For each colour of the picture.
'Bitmapped image data follows the colour tables


'Special note: When storing 1 bit (2 colour) pictures.
'8 horizontal pixels are packed into 1 byte. Each bit determines
'the colour of one pixel (colour 0 or colour 1)

'4 bit pictures (16 colours) use 2 nibbles (4 bits) for each pixel
'thus there are 2 pixels for each byte of image data.

'8 bit pictures use 1 byte per pixel. Each byte of image data
'represents one of 256 colours.

'24 bit pictures express colour values by using 3 bytes and each has a
'value between 0 and 255. The first byte is for red, the second is for
'green and the third is for blue. Thus (256)^3 or 2^24 of 16777216 different
'colours.

'Even more special note:
'each line of bitmap images have a long word integer boundary;
'this means that at the end of each line, there may be extra "padding"
'bytes to ensure that the actual amount of data encoded with each line
'is encoded to be a multiple of 4 bytes (the size of a long word).




IF bmpinfosize = 12 THEN
   infoheader$ = SPACE$(12)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
 
   IF nbits = 1 THEN
      palet$ = SPACE$(6)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(48)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(768)
      GET #1, bmpinfosize + 15, palet$
   END IF
ELSEIF bmpinfosize = 40 THEN
   infoheader$ = SPACE$(40)
   GET #1, 15, infoheader$
   nbits = CVI(MID$(infoheader$, 15, 4))
   IF nbits = 1 THEN
      palet$ = SPACE$(8)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 4 THEN
      palet$ = SPACE$(64)
      GET #1, bmpinfosize + 15, palet$
   ELSEIF nbits = 8 THEN
      palet$ = SPACE$(1024)
      GET #1, bmpinfosize + 15, palet$
   END IF
END IF
    

ft$ = MID$(header$, 1, 2)
PRINT "Type of file (Should be BM): "; ft$

filesize = CVL(MID$(header$, 3, 4))
PRINT "Size of file: "; filesize

r1 = CVI(MID$(header$, 7, 2))
PRINT "Reserved 1: "; r1

r2 = CVI(MID$(header$, 9, 2))
PRINT "Reserved 2: "; r2

offset = CVL(MID$(header$, 11, 4))
PRINT "Number of bytes offset from beginning: "; offset

PRINT

headersize = CVL(MID$(infoheader$, 1, 4))
PRINT "Size of header: "; headersize

picwidth = CVL(MID$(infoheader$, 5, 4))
PRINT "Width: "; picwidth

picheight = CVL(MID$(infoheader$, 9, 4))
PRINT "Height: "; picheight

nplanes = CVI(MID$(infoheader$, 13, 4))
PRINT "Planes: "; nplanes

PRINT "Bits per plane: "; nbits

PRINT

IF headersize = 40 THEN
   PRINT "Compression: ";
   comptype = CVL(MID$(infoheader$, 17, 4))
   IF comptype = 0 THEN PRINT "None"
   IF comptype = 1 THEN PRINT "Run Length - 8 Bits"
   IF comptype = 2 THEN PRINT "Run Length - 4 Bits"
 
   imagesize = CVL(MID$(infoheader$, 21, 4))
   PRINT "Image Size (bytes): "; imagesize
 
   xsize = CVL(MID$(infoheader$, 25, 4))
   PRINT "X size (pixels per metre): "; xsize
 
   ysize = CVL(MID$(infoheader$, 29, 4))
   PRINT "Y size (pixels per metre): "; ysize
 
   colorsused = CVL(MID$(infoheader$, 33, 4))
   PRINT "Number of colours used: "; colorsused
 
   neededcolours = CVL(MID$(infoheader$, 37, 4))
   PRINT "Number of important colours: "; neededcolours
END IF
PRINT
PRINT "Press Any key to continue."
WHILE INKEY$ = ""
WEND

IF nbits = 1 THEN
   SCREEN 11
   xres = 640
   yres = 480
   nc = 2
ELSEIF nbits = 4 THEN
   SCREEN 12
   xres = 640
   yres = 480
   nc = 16
ELSEIF nbits = 8 OR nbits = 24 THEN
   SCREEN 13
   xres = 320
   yres = 200
   nc = 256
END IF
IF bmpinfosize = 40 THEN ngroups = 4
IF bmpinfosize = 12 THEN ngroups = 3

IF nbits = 24 THEN
   IF grey = 1 THEN
      IF ngroups = 3 THEN
         FOR c = 0 TO 63
            d = c * 4
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d)
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1)
            palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d)
            palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d)
         NEXT c
      ELSEIF ngroups = 4 THEN
         FOR c = 0 TO 63
            d = c * 4
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d) + CHR$(0)
            palet$ = palet$ + CHR$(d) + CHR$(d) + CHR$(d + 1) + CHR$(0)
            palet$ = palet$ + CHR$(d) + CHR$(d + 1) + CHR$(d) + CHR$(0)
            palet$ = palet$ + CHR$(d + 1) + CHR$(d) + CHR$(d) + CHR$(0)
         NEXT c
      END IF
   ELSE
      FOR t = 0 TO 5
         FOR u = 0 TO 5
            FOR v = 0 TO 5
               palet$ = palet$ + CHR$(INT(v * (256 / 6)))
               palet$ = palet$ + CHR$(INT(u * (256 / 6)))
               palet$ = palet$ + CHR$(INT(t * (256 / 6)))
               IF ngroups = 4 THEN palet$ = palet$ + CHR$(0)
            NEXT v
         NEXT u
      NEXT t
      FOR count = 0 TO 31
         palet$ = palet$ + CHR$(count * 8) + CHR$(count * 8) + CHR$(count * 8)
         IF ngroups = 4 THEN palet$ = palet$ + CHR$(0)
      NEXT count
      palet$ = palet$ + CHR$(255) + CHR$(255) + CHR$(255)
   END IF
END IF

IF slowpal = 1 THEN
   FOR x = 1 TO LEN(palet$) STEP ngroups
      zb# = INT((ASC(MID$(palet$, x, 1))) / 4)
      zg# = INT((ASC(MID$(palet$, x + 1, 1))) / 4)
      zr# = INT((ASC(MID$(palet$, x + 2, 1))) / 4)
      zc# = zb# * 65536# + zg# * 256# + zr#
'      cres = ASC(MID$(palet$, x + 3, 1))
      PALETTE ((x - 1) / ngroups), zc#
   NEXT x
ELSE 'Use VGA Palette I/O Registers to set palette values - Faster
   OUT va, 0

   FOR x = 1 TO LEN(palet$) STEP ngroups
      zb = INT((ASC(MID$(palet$, x, 1))) / 4)
      zg = INT((ASC(MID$(palet$, x + 1, 1))) / 4)
      zr = INT((ASC(MID$(palet$, x + 2, 1))) / 4)
'      zc# = zb# * 65536# + zg# * 256# + zr#
'      cres = ASC(MID$(palet$, x + 3, 1))
      OUT vd, zr
      OUT vd, zg
      OUT vd, zb
      'PALETTE ((x - 1) / ngroups), zc#
   NEXT x
END IF


IF comptype = 0 THEN
   'No Compression
   IF nbits = 24 THEN
      y = picheight - 1
      x = 0
      lin$ = SPACE$((INT((3 * picwidth - 1) / 4) + 1) * 4)
      WHILE y >= 0
         GET 1, , lin$
         IF grey = 0 THEN
            WHILE x < picwidth
               b = ASC(MID$(lin$, x * 3 + 1, 1))
               g = ASC(MID$(lin$, x * 3 + 2, 1))
               r = ASC(MID$(lin$, x * 3 + 3, 1))
               IF b = g AND g = r THEN
                  p1 = INT(b / 8) + 216
                  IF b = 255 THEN p1 = 247
               ELSE
                  r = INT(r * (6 / 256))
                  g = INT(g * (6 / 256))
                  b = INT(b * (6 / 256))
                  qa = INT(RND(1) * (r + 1)) * .4
                  qb = INT(RND(1) * (g + 1)) * .4
                  qc = INT(RND(1) * (b + 1)) * .4
                  r = INT(r + qa - (r * .2))
                  g = INT(g + qg - (g * .2))
                  b = INT(b + qb - (b * .2))
                  IF r > 5 THEN r = 5
                  IF r < 0 THEN r = 0
                  IF g > 5 THEN g = 5
                  IF g < 0 THEN g = 0
                  IF b > 5 THEN b = 5
                  IF b < 0 THEN b = 0
        
                  p1 = r * 36 + g * 6 + b
               END IF
               PSET (x, y), p1
               x = x + 1
            WEND
         ELSE
            WHILE x < picwidth
               p1 = INT((ASC(MID$(lin$, x * 3 + 1, 1)) + ASC(MID$(lin$, x * 3 + 2, 1)) + ASC(MID$(lin$, x * 3 + 3, 1))) / 3)
               PSET (x, y), p1
               x = x + 1
            WEND
         END IF
         y = y - 1
         x = 0
      WEND
   ELSEIF nbits = 8 THEN
      y = picheight - 1
      x = 0
      lin$ = SPACE$((INT((picwidth - 1) / 4) + 1) * 4)
      WHILE y >= 0
         GET #1, , lin$
         WHILE x < picwidth
            PSET (x, y), ASC(MID$(lin$, x + 1, 1))
            x = x + 1
         WEND
         y = y - 1
         x = 0
      WEND
   ELSEIF nbits = 4 THEN
      y = picheight - 1
      x = 0
      lin$ = SPACE$((INT((picwidth - 1) / 8) + 1) * 4)
      WHILE y >= 0
         GET 1, , lin$
         WHILE x < picwidth
            p2 = ASC(MID$(lin$, INT(x / 2) + 1, 1)) AND 15
            p1 = (ASC(MID$(lin$, INT(x / 2) + 1, 1)) AND 240) / 16
            PSET (x, y), p1
            IF x + 1 < picwidth THEN PSET (x + 1, y), p2
            x = x + 2
         WEND
         y = y - 1
         x = 0
      WEND
   ELSEIF nbits = 1 THEN
      y = picheight - 1
      x = 0
      lin$ = SPACE$((INT((picwidth - 1) / 32) + 1) * 4)
      WHILE y >= 0
         GET 1, , lin$
         WHILE x < picwidth
            p8 = ASC(MID$(lin$, INT(x / 8) + 1, 1))
            FOR b = 0 TO 7
               IF x + (7 - b) < picwidth THEN PSET (x + (7 - b), y), (p8 AND 2 ^ b) / 2 ^ b
            NEXT b
            x = x + 8
         WEND
         y = y - 1
         x = 0
      WEND
   END IF
ELSEIF comptype = 1 THEN
   'Compression Essentials
   '[a][b] a>0, repeat b a-times
   '[0][0] End of line
   '[0][1] End of bitmap
   '[0][2][h][v] Move current position h to the right and v down
   'PRINT "Wow! RLE-8 Compression."
   a$ = " "
   x = 0
   y = 0
   ef = 0
   WHILE ef = 0
   GET #1, , a$
   c = ASC(a$)
   IF c > 0 THEN
      GET #1, , a$
      b = ASC(a$)
      FOR count = 1 TO c
        PSET (picwidth - x - 1, picheight - y - 1), b
        x = x + 1
        'if x>=picwidth then x=0:y=y+1
      NEXT count
   ELSE
      GET #1, , a$
      c = ASC(a$)
      IF c = 0 THEN
         x = 0
         y = y + 1
      ELSEIF c = 1 THEN
         ef = 1
      ELSEIF c = 2 THEN
         GET #1, , a$
         h = ASC(a$)
         GET #1, , a$
         v = ASC(a$)
         x = x + h
         y = y + v
      ELSE
         FOR count = 1 TO c
            GET #1, , a$
            p1 = ASC(a$)
            PSET (picwidth - x - 1, picheight - y - 1), p1
            x = x + 1
            'if x>=picwidth then x=0:y=y+1
         NEXT count
         IF c MOD 2 = 1 THEN GET #1, , a$
      END IF
      IF (y = picheight - 1 AND x >= picwidth) OR y >= picheight THEN ef = 1
   END IF
      IF EOF(1) THEN ef = 1
   WEND
ELSEIF comptype = 2 THEN
   'Compression Essentials
   '[a][b1|b0] a>0, repeat b1|b0 a/2-times e.g. a=5 -> b1 b0 b1 b0 b1
   '[0][0] End of line
   '[0][1] End of bitmap
   '[0][2][h][v] Move current position h to the right and v down
   'PRINT "Wow! RLE-4 Compression."
   a$ = " "
   x = 0
   y = 0
   ef = 0
   WHILE ef = 0
   GET #1, , a$
   c = ASC(a$)
   IF c > 0 THEN
      GET #1, , a$
      b = ASC(a$)
      FOR count = 1 TO c
        IF (count MOD 2) = 0 THEN
           PSET (picwidth - x - 1, picheight - y - 1), b AND 15
        ELSE
           PSET (picwidth - x - 1, picheight - y - 1), (b AND 240) / 16
        END IF
        x = x + 1
        'if x>=picwidth then x=0:y=y+1
      NEXT count
   ELSE
      GET #1, , a$
      c = ASC(a$)
      IF c = 0 THEN
         x = 0
         y = y + 1
      ELSEIF c = 1 THEN
         ef = 1
      ELSEIF c = 2 THEN
         GET #1, , a$
         h = ASC(a$)
         GET #1, , a$
         v = ASC(a$)
         x = x + h
         y = y + v
      ELSE
         FOR count = 1 TO INT(c / 2)
            GET #1, , a$
            p1 = ASC(a$)
            PSET (picwidth - x - 1, picheight - y - 1), (p1 AND 240) / 16
            x = x + 1
            PSET (picwidth - x - 1, picheight - y - 1), p1 AND 15
            x = x + 1
            'if x>=picwidth then x=0:y=y+1
         NEXT count
         br = INT(c / 2)
         IF (c MOD 2) = 1 THEN
            GET #1, , a$
            PSET (picwidth - x - 1, picheight - y - 1), (p1 AND 240) / 16
            x = x + 1
            br = br + 1
         END IF
         IF br MOD 2 = 1 THEN GET #1, , a$
      END IF
      IF (y = picheight - 1 AND x >= picwidth) OR y >= picheight THEN ef = 1
   END IF
      IF EOF(1) THEN ef = 1
   WEND


END IF
CLOSE
<PAGEEND:".BMP.Viewer.File">

<PAGESTART:".GIF.Viewer.File">
DECLARE SUB dispgif (a$)
INPUT "Filename to load: ", filename$

dispgif filename$

SUB dispgif (a$)
DEFINT A-Z
DIM Prefix(4095), Suffix(4095), OutStack(4095), ShiftOut(8)
DIM YBase AS LONG, Powersof2(11) AS LONG, WorkCode AS LONG
FOR a = 0 TO 8: ShiftOut(8 - a) = 2 ^ a: NEXT
FOR a = 0 TO 11: Powersof2(a) = 2 ^ a: NEXT
OPEN a$ FOR INPUT AS #1: CLOSE #1
OPEN a$ FOR BINARY AS #1
a$ = "      ": GET #1, , a$
IF LEFT$(a$, 3) <> "GIF" THEN PRINT "Not a GIF file.": END
GET #1, , TotalX: GET #1, , TotalY: GOSUB GetByte
NumColors = 2 ^ ((a AND 7) + 1): NoPalette = (a AND 128) = 0
GOSUB GetByte: Background = a
GOSUB GetByte
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #1, , P$
DO
DO
DO
IF EOF(1) THEN GOTO AllDone
GOSUB GetByte
LOOP WHILE a = 0
SELECT CASE a
CASE 44
EXIT DO
CASE 59
GOTO AllDone
CASE IS <> 33
PRINT "Unknown GIF extension type.": END
END SELECT
GOSUB GetByte
DO: GOSUB GetByte: a$ = SPACE$(a): GET #1, , a$: LOOP UNTIL a = 0
LOOP
GET #1, , XStart: GET #1, , YStart: GET #1, , XLength: GET #1, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength
GOSUB GetByte
IF (a AND 128) THEN
NoPalette = 0
NumColors = 2 ^ ((a AND 7) + 1)
P$ = SPACE$(NumColors * 3): GET #1, , P$
END IF
Interlaced = (a AND 64) > 0: PassNumber = 0: PassStep = 8
GOSUB GetByte
ClearCode = 2 ^ a
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = a + 1: CodeSize = StartCodeSize
StartMaxCode = 2 ^ (a + 1) - 1: MaxCode = StartMaxCode
BitsIn = 0: BlockSize = 0: BlockPointer = 1
x = XStart: y = YStart: YBase = y * 320&
IF FirstTime = 0 THEN
SCREEN 13: DEF SEG = &HA000
END IF
IF NoPalette = 0 THEN
OUT &H3C8, 0
FOR a = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a, 1)) \ 4: NEXT
END IF
IF FirstTime = 0 THEN
LINE (0, 0)-(319, 199), Background, BF
FirstTime = -1
END IF
DO
GOSUB GetCode
IF Code <> EOSCode THEN
IF Code = ClearCode THEN
NextCode = FirstCode
CodeSize = StartCodeSize
MaxCode = StartMaxCode
DO: GOSUB GetCode: LOOP WHILE Code = ClearCode
IF Code = EOSCode THEN GOTO ImageDone
LastCode = Code: LastPixel = Code
IF x < 320 AND y < 200 THEN POKE x + YBase, LastPixel
x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
ELSE
CurCode = Code: StackPointer = 0
IF Code >= NextCode THEN
IF Code > NextCode THEN GOTO AllDone
CurCode = LastCode
OutStack(StackPointer) = LastPixel
StackPointer = StackPointer + 1
END IF
DO WHILE CurCode >= FirstCode
OutStack(StackPointer) = Suffix(CurCode)
StackPointer = StackPointer + 1
CurCode = Prefix(CurCode)
LOOP
LastPixel = CurCode
IF x < 320 AND y < 200 THEN POKE x + YBase, LastPixel
x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
FOR a = StackPointer - 1 TO 0 STEP -1
IF x < 320 AND y < 200 THEN POKE x + YBase, OutStack(a)
x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
NEXT
IF NextCode < 4096 THEN
Prefix(NextCode) = LastCode
Suffix(NextCode) = LastPixel
NextCode = NextCode + 1
IF (NextCode > MaxCode) AND (CodeSize < 12) THEN
CodeSize = CodeSize + 1
MaxCode = MaxCode * 2 + 1
END IF
END IF
LastCode = Code
END IF
END IF
LOOP UNTIL Code = EOSCode
ImageDone:
LOOP
AllDone:
END
GetByte: a$ = " ": GET #1, , a$: a = ASC(a$): RETURN
NextScanLine:
IF Interlaced THEN
y = y + PassStep
IF y >= YEnd THEN
PassNumber = PassNumber + 1
SELECT CASE PassNumber
CASE 1: y = 4: PassStep = 8
CASE 2: y = 2: PassStep = 4
CASE 3: y = 1: PassStep = 2
END SELECT
END IF
ELSE
y = y + 1
END IF
x = XStart: YBase = y * 320&
RETURN
GetCode:
WorkCode = LastChar \ ShiftOut(BitsIn)
DO WHILE CodeSize > BitsIn
IF BlockPointer > BlockSize THEN
GOSUB GetByte: BlockSize = a
a$ = SPACE$(BlockSize): GET #1, , a$
BlockPointer = 1
END IF
LastChar = ASC(MID$(a$, BlockPointer, 1))
BlockPointer = BlockPointer + 1
WorkCode = WorkCode OR LastChar * Powersof2(BitsIn)
BitsIn = BitsIn + 8
LOOP
BitsIn = BitsIn - CodeSize
Code = WorkCode AND MaxCode
RETURN
DEF SEG
CLS

END SUB
<PAGEEND:".GIF.Viewer.File">

<PAGESTART:".PCX.Viewer.File">
'***** PCX.BAS *****************************************************
'*** The original code for this routine was found in VGAPCX.BAS  ***
'*** At first I optomized the code in that file, and eventually  ***
'*** I ended up re-writing the whole thing.  That PCX loader did ***
'*** a number of things differently, including loading the color ***
'*** palette _last_.  This routine loads the palette first,  so  ***
'*** you can see the "correct" picture as the PCX is loading. In ***
'*** addition to that, I use all integers for speed and load the ***
'*** file in chunks of 2,000 bytes (instead of 1 byte at a time, ***
'*** as in the other routine, VGAPCX.BAS).  I thank the uknown   ***
'*** author of that original version, VGAPCX.BAS, because if he  ***
'*** had not put out that sample code, this PCX loader would not ***
'*** be possible.                                                ***
'*******************************************************************
'*** On a 486dx2-66, the old version (VGAPCX.BAS) loaded the PCX ***
'*** in about 21 seconds.  This new version does so in about 1.5 ***
'*** seconds.  The  speed varies depending on the  level of file ***
'*** compression attained by the PCX file.                       ***
'*******************************************************************
DEFINT A-Z

DECLARE SUB ShowPCX (file$)

'*** If you're using Qbasic 1.1, change this line to
'*** ShowPCX "<pcxfile>.pcx"
INPUT "File to be displayed: "; file$

ShowPCX file$

WHILE INKEY$ = "": WEND
SCREEN 0: WIDTH 80

'*** Loads a Version 5, 320x200x256c PCX file.
'*** If you have any questions or comments about any of this code,
'*** please contact me, Jonathan Leger, at leger@mail.dtx.net.
SUB ShowPCX (file$)

SCREEN 13

DIM pcxpal AS STRING * 768, pcxversion AS STRING * 1

pcxnum = FREEFILE
OPEN file$ FOR BINARY AS #pcxnum

   '*** Get the PCX version from the header.
   GET #pcxnum, 2, pcxversion

   '*** If we're using version 5, then load the palette.
   IF ASC(pcxversion) = 5 THEN
      '*** Grab the palette out of the file.
      GET #1, LOF(pcxnum) - 767, pcxpal

      '*** Start with color 0.
      pal = 0

      '*** Grab the red/green/blue value from our palette (PCXPAL) and
      '*** send them to the monitor using OUT.
      FOR p = 1 TO 768 STEP 3
         OUT &H3C8, pal
         red% = INT(ASC(MID$(pcxpal, p, 1)) / 4)
         OUT &H3C9, red%
         green% = INT(ASC(MID$(pcxpal, p + 1, 1)) / 4)
         OUT &H3C9, green%
         blue% = INT(ASC(MID$(pcxpal, p + 2, 1)) / 4)
         OUT &H3C9, blue%
         pal = pal + 1
      NEXT p

   END IF
  
   '*** Jump past the file header.
   SEEK #pcxnum, 129

   '*** We'll be sending the output the the screen, so our segment
   '*** is &HA000 (VGA screen memory) and our offset is 0.  You can
   '*** change these values to, say, decompress the image into an
   '*** array or something.
   fxoffset = 0: fxsegment = &HA000

   '*** We'll be reading chunks of 2,000 bytes.  You can increase or
   '*** decrease this depending on your needs.  I noticed little or
   '*** no difference when the chunk size went past 2,000, so I left
   '*** it at 2,000 to add as little over-head as possible with maximum
   '*** speed.
   datasize = 2000

   '*** Load our first chunk of data and point to the beginning of that
   '*** data.
   pcxdata$ = INPUT$(datasize, pcxnum)
   datacount = 1

   '*** To increase speed, we'll be drawing the screen in two loops,
   '*** that way we can use integers to point to the next pixel instead
   '*** of long integers.  Doing this gains tremendous speed.
   FOR half = 1 TO 2

      '*** On the second loop, this will add &H7D0 (32000) to our
      '*** segment so we'll be writing to the second half of the screen.
      '*** On the first loop, this will simply set our segment to &HA000.
      fxtotal = fxsegment + fxoffset
      DEF SEG = fxtotal

      FOR c = 0 TO 31999

         '*** If we're out of data, then we need to load the next chunk.
         IF datacount > datasize THEN
            pcxdata$ = INPUT$(datasize, pcxnum)
            datacount = 1
         END IF

         '*** Get the next byte from our data chunk.
         clr = ASC(MID$(pcxdata$, datacount, 1))
         datacount = datacount + 1

         '*** If we're out of data, then we load the next chunk.
         IF datacount > datasize THEN
            pcxdata$ = INPUT$(datasize, pcxnum)
            datacount = 1
         END IF
        
         '*** If the byte we pulled from the data has bit 6 and 7 set,
         '*** (which would make the value greater than 192), then that
         '*** means we'll be repeating a color.  So we pull the next
         '*** byte from our data chunk (which is the color), and put
         '*** it on the screen CLR - 192 times (in other words, we
         '*** take the value of the first 5 bits in the byte and put
         '*** the pixel to the screen that many times.)
         IF clr > 192 THEN
            LPS = clr - 192
            clr = ASC(MID$(pcxdata$, datacount, 1))
            datacount = datacount + 1
            FOR L = LPS TO 1 STEP -1
               POKE c, clr
               c = c + 1
            NEXT L
            c = c - 1
         ELSE
         '*** Since the byte was less than 192, then we just poke the
         '*** pixel to the screen.
            POKE c, clr
         END IF
      NEXT c
      '*** We'll move to the second half of the screen by adding 32,000
      '*** (HEX = 7D0) bytes to our segment value.
      fxoffset = fxoffset + &H7D0
   NEXT half

'*** All done!  Close the file.
CLOSE pcxnum

'*** Return to BASIC's default segment. Very important!
DEF SEG

END SUB
<PAGEEND:".PCX.Viewer.File">

<PAGESTART:".TGA.Viewer.File">
DECLARE SUB ShowImage (p1%, p2%, p3%, p4%, p5%, p6%)
DECLARE SUB Waiting ()
DECLARE SUB Reading (x%, y%)
'***************************************************************************
'Program:       TGA.BAS                                                    *
'Task:          TGA viewer for SCREEN 13 - uncompressed TGA files.         *
'               Version 1.1 (fast version)                                 *
'Language:      QBASIC mixed with machine code.                            *
'Authors:       Erika Schulze and Gunther Ilzig                            *
'               CIS: 100775,2275                                           *
'               Internet: 100775.2275@compuserve.com                       *
'               Free for use. (PUBLIC DOMAIN)                              *
'Note:          A VGA card is required. Program hasn't a documentation.    *
'               Please print the well commented source.                    *
'***************************************************************************

'The  TGA  (True Version Targa) isn't complicated. There is only a
'TGA header of 18 bytes with all informations about the image.
'Structure of the TGA header:

'Offset   Length   Description
'======   ======   ===========

'00H      BYTE     info:
'                  It's  possible,  that after the 18 bytes of the
'                  header, the file contains an information block.
'                  This  block, for  example, holds  the copyright
'                  information.  The  byte  info  stands  for  the
'                  length of the information block.
'01H      BYTE     colortyp:
'                  0 ===> RGB image
'                  1 ===> image has a DAC table
'02H      BYTE     imagetyp:
'                  This  byte contains information about the image
'                  typ:
'                  1 ===> uncompressed  image  datas  with  a  DAC
'                  table
'                  2 ===> uncompressed RGB file
'                  9 ===> runlength encoded datas with a DAC table
'                 10 ===> runlength encoded RGB file
'03H      WORD     origin:
'                  This word contains the index of the first entry
'                  in the DAC table (mostly 0).
'05H      WORD     colnumber:
'                  This  word contains the number of colors in the
'                  DAC  table.  That's  not  the length of the DAC
'                  table in byte!
'07H      BYTE     entrybits:
'                  Size of on entry in the DAC table. An entry has
'                  16, 24 or 32 bits.
'08H      WORD     xvalue:
'                  The  x-value  of  the lower left corner of the
'                  TGA image (mostly 0).
'0AH      WORD     yvalue:
'                  The  y-value  of  the lower left corner of the
'                  TGA image (mostly 0).
'0CH      WORD     widt:
'                  The image width in pixels.
'0EH      WORD     height:
'                  The image height in pixels.
'10H      BYTE     pixelsize:
'                  Number of bits per pixel.
'                  DAC images ===> valid values are 8 and 16
'                  RGB images ===> valid values are 16, 24 and 32
'11H      BYTE     descriptor:
'                  The   image   descriptor   contains  additional
'                  informations.

'The structure of the image descriptor:

'Bit 0 - 3: fill bits
'Bit 4    : always 0
'Bit 5    : 0  ===> image origin in the lower left corner
'           1  ===> image origin in the upper left corner
'Bit 6 - 7: 00 ===> the image rows are stored one after the other
'           01 ===> first are stored the even rows (0, 2, 4 ...)
'                   after  this  are  stored the odd rows (1, 3, 5 ...)

'The formula to calculate the length of the DAC table:

'daclength% = colnumber*entrybits/8

'After the  18 bytes of the TGA header is  stored  the information
'block  in the TGA file, but the length of this block is mostly 0.
'After  the information block is stored the DAC table and then the
'image datas.

'===========================================================================
'declarations                                                              =
'===========================================================================

TYPE tgaheader                  'declare the header
  info       AS STRING * 1      'length of image information block
  colortyp   AS STRING * 1      'DAC table or BGR format
  imagetyp   AS STRING * 1      'compressed or uncompressed
  origin     AS INTEGER         'first entry in the DAC table
  colnumber  AS INTEGER         'number of colors in the DAC table
  entrybits  AS STRING * 1      'entry size in the DAC table
  xvalue     AS INTEGER         'x co-ordinate lower left corner
  yvalue     AS INTEGER         'y co-ordinate lower left corner
  widt       AS INTEGER         'image width
  height     AS INTEGER         'image height
  pixelsize  AS STRING * 1      'number of bits per pixel
  descriptor AS STRING * 1      'image descriptor
END TYPE
DIM header AS tgaheader         'define the header
headerseg% = VARSEG(header.info)'segment header.info
headeroff% = VARPTR(header.info)'offset header.info

DIM buffer%(32766)                      'copy buffer
bufseg% = VARSEG(buffer%(0))            '32-Bit address
bufoff% = VARPTR(buffer%(0))            'copy buffer

DIM trans%(20)                          'array machine programm
					'for disk transfer
tseg% = VARSEG(trans%(0))               'segment trans%(0)
toff% = VARPTR(trans%(0))               'offset trans%(0)

DIM rehe%(23)                           'array machine program
					'read TGA-Header
reheseg% = VARSEG(rehe%(0))             'segment rehe%(0)
reheoff% = VARPTR(rehe%(0))             'offset rehe%(0)

DIM drawp%(20)                          'array machine program
					'to set a pixel at the screen
drawpseg% = VARSEG(drawp%(0))           'segment drawp%(0)
drawpoff% = VARPTR(drawp%(0))           'offset drawp%(0)

file$ = "256color.TGA"                     'name of the TGA file
					'change this, if necessary
filelength& = 0                         'length TGA file
filehandle% = 0                         'file handle TGA file

daclength% = 0                          'length DAC table
colused% = 0                            'number of used colors
dacstart% = 0                           'the start of DAC data
imagestart% = 0                         'the start of the image data

'===========================================================================
'program starts here                                                       =
'===========================================================================

RESTORE Transfer                        'restore data pointer
CALL Reading(tseg%, toff%)              'read machine code
					'for disk transfer
RESTORE ReadHeader                      'restore data pointer
CALL Reading(reheseg%, reheoff%)        'read machine code
					'for read the header data
RESTORE DrawPixel                       'restore data pointer
CALL Reading(drawpseg%, drawpoff%)      'read machine code to set a
					'pixel at the screen

CLS                                     'clear the screen

OPEN file$ FOR BINARY AS #1             'open the TGA file
filelength& = LOF(1)                    'determine the length of this file
filehandle% = FILEATTR(1, 2)            'get the DOS handle of this file
DEF SEG = tseg%                         'set segment
  CALL ABSOLUTE(bufseg%, bufoff%, filehandle%, filelength&, toff%)
					'read the file all at once from
					'the disk in the buffer
DEF SEG                                 'reset segment
CLOSE #1                                'close the TGA file
'===========================================================================
'Now the TGA image is in the copy buffer. Here is the structure of the     =
'image file (not true to scale):                                           =
'          ͻ                             =
'           18 Bytes TGA-Header                                          =
'          Ķ                             =
'           perhaps an information block                                 =
'           (mostly not)                                                 =
'           maximum block size = 255 Byte                                =
'          Ķ                             =
'           DAC data                                                     =
'           A list of BGR values, each of                                =
'           which corresponds to one of                                  =
'           of the TGA bitmap                                            =
'          Ķ                             =
'           Pixel values stored row by row                               =
'           and from the largest to the                                  =
'           smallest y-coordinate                                        =
'                  row n                                                 =
'                  row n-1                                               =
'                  row n-2                                               =
'                    ...                                                 =
'                    ...                                                 =
'                    ...                                                 =
'                  row 2                                                 =
'                  row 1                                                 =
'                  row 0                                                 =
'          ͼ                             =
'===========================================================================

DEF SEG = reheseg%                      'set segment
  CALL ABSOLUTE(bufseg%, bufoff%, headerseg%, headeroff%, reheoff%)
					'read the TGA-Header from the
					'copy buffer in the UDT
DEF SEG                                 'reset segment

IF ASC(header.colortyp) <> 1 THEN
				'image hasn't a DAC table
   PRINT
   PRINT "Sorry! This TGA image hasn't a DAC table."
   END
END IF
IF ASC(header.imagetyp) <> 1 THEN
				'data must be uncompressed
   PRINT
   PRINT "Sorry! This TGA format isn't supported."
   END
END IF

daclength% = header.colnumber * (ASC(header.entrybits)) / 8
					'calculate the length of DAC-Table
colused% = daclength% / 3               'calculate number of used colors
dacstart% = 18 + ASC(header.info)       'calculate the start address of
					'DAC data
imagestart% = dacstart% + daclength%    'calculate the start address of
					'the image data

PRINT
PRINT "Image Width           ="; header.widt; "Pixel"
PRINT "Image Height          ="; header.height; "Pixel"
PRINT "Number of used colors ="; colused%
PRINT
PRINT "Please press any key to display the image ..."
					'print some informations
					'about the image

CALL Waiting                            'wait
CLS                                     'clear the screen

SCREEN 13                               'set Mode 13H
count% = dacstart%                      'set pointer to first DAC value
FOR register% = 0 TO colused% - 1       'set the DAC registers
  DEF SEG = bufseg%                     'set segment
    blue% = (PEEK(count%)) \ 4          'read color blue
    count% = count% + 1                 'increment counter
    green% = (PEEK(count%)) \ 4         'read color green
    count% = count% + 1
    red% = (PEEK(count%)) \ 4           'read color red
    count% = count% + 1
  DEF SEG
  OUT &H3C8, register%                  'set register
  OUT &H3C9, red%                       'set RGB values
  OUT &H3C9, green%
  OUT &H3C9, blue%
NEXT register%

CALL ShowImage(bufseg%, imagestart%, header.height, header.widt, drawpseg%, drawpoff%)
					'show the image at the screen

CALL Waiting                            'wait
SCREEN 0                                'text mode
WIDTH 80, 25                            '25 rows and 80 columns
END
Transfer:
DATA 55:        'push   bp
DATA 8b,ec:     'mov    bp,sp
DATA 1e:        'push   ds              ;save ds
DATA 8b,76,06:  'mov    si,[bp+6]       ;si -> filelength&
DATA 8b,7e,08:  'mov    di,[bp+8]       ;di -> filehandle%
DATA 8b,1d:     'mov    bx,[di]         ;bx:=filehandle%
DATA 8b,0c:     'mov    cx,[si]         ;cx:=number of bytes to transfer
DATA 8b,76,0a:  'mov    si,[bp+10]      ;si -> bufoff%
DATA 8b,7e,0c:  'mov    di,[bp+12]      ;di -> bufseg%
DATA 8b,14:     'mov    dx,[si]         ;dx:=bufoff%
DATA 8b,05:     'mov    ax,[di]         ;ax:=bufseg%
DATA 8e,d8:     'mov    ds,ax           ;ds:dx -> copy buffer
DATA b4,3f:     'mov    ah,3fh          ;function: read via handle
DATA cd,21:     'int    21h             ;transfer to DOS
DATA 1f:        'pop    ds              ;restore ds
DATA 8b,e5:     'mov    sp,bp
DATA 5d:        'pop    bp
DATA ca,08,00:  'ret    8
DATA *:         'end character

ReadHeader:
DATA 55:        'push   bp
DATA 8b,ec:     'mov    bp,sp
DATA 1e:        'push   ds
DATA 06:        'push   es
DATA 9c:        'pushf
DATA fc:        'cld                    ;auto increment di and si
DATA b9,09,00:  'mov    cx,9            ;cx:=number of words to copy
DATA 8b,5e,06:  'mov    bx,[bp+6]       ;bx -> headeroff%
DATA 8b,3f:     'mov    di,[bx]         ;di:=headeroff%
DATA 8b,5e,08:  'mov    bx,[bp+8]       ;bx -> headerseg%
DATA 8b,07:     'mov    ax,[bx]         ;ax:=headerseg%
DATA 8e,c0:     'mov    es,ax           ;es:di -> destination
DATA 8b,5e,0a:  'mov    bx,[bp+10]      ;bx -> bufoff%
DATA 8b,37:     'mov    si,[bx]         ;si:=bufoff%
DATA 8b,5e,0c:  'mov    bx,[bp+12]      ;bx -> bufseg%
DATA 8b,07:     'mov    ax,[bx]         ;ax:=bufseg%
DATA 8e,d8:     'mov    ds,ax           ;ds:si -> source
DATA f3,a5:     'rep    movsw           ;copy loop
DATA 9d:        'popf
DATA 07:        'pop    es
DATA 1f:        'pop    ds
DATA 8b,e5:     'mov    sp,bp
DATA 5d:        'pop    bp
DATA ca,08,00:  'ret    8
DATA *:         'end character

DrawPixel:
DATA 55:        'push   bp
DATA 8b,ec:     'mov    bp,sp
DATA 06:        'push   es
DATA 8b,5e,08:  'mov    bx,[bp+8]       ;bx -> y%
DATA 8b,76,0a:  'mov    si,[bp+10]      ;si -> x%
DATA bf,00,a0:  'mov    di,0a000h       ;di:=segment video RAM
DATA 8e,c7:     'mov    es,di           ;es:=di
DATA b8,40,01:  'mov    ax,320          ;ax:=320=bytes per row
DATA f7,27:     'mul    word ptr [bx]   ;ax:=y%*320
DATA 03,04:     'add    ax,word ptr [si];ax:=y%*320+x%
DATA 8b,f8:     'mov    di,ax           ;es:di -> Pixel
DATA 8b,5e,06:  'mov    bx,[bp+6]       ;bx -> byte%=color
DATA 8b,07:     'mov    ax,[bx]         ;al:=color
DATA 26,88,05:  'mov    byte ptr es:[di],al
		'                       ;set the pixel
DATA 07:        'pop    es
DATA 8b,e5:     'mov    sp,bp
DATA 5d:        'pop    bp
DATA ca,06,00:  'ret    6
DATA *:         'end character

'***************************************************************************
'SUB Reading                                                               *
'Task:          Reads a machine program into an array.                     *
'Input:         x% = segment address array                                 *
'               y% = offset address array                                  *
'Output:        machine program in the array                               *
'Uses:          no subroutines                                             *
'***************************************************************************
SUB Reading (x%, y%)
  DEF SEG = x%                  'set the segment
  FOR i% = 0 TO 199             'reading loop
    READ byte$                  'read 1 byte
    IF byte$ = "*" THEN EXIT FOR
				'end code
    POKE (y% + i%), VAL("&H" + byte$)
				'write 1 byte
  NEXT i%
  DEF SEG                       'reset the segment
END SUB

'***************************************************************************
'SUB ShowImage                                                             *
'Task:          Displays the image at the screen.                          *
'Input:         p1% = bufseg%=segment address copy buffer.                 *
'               p2% = imagestart%=start address image data in the buffer.  *
'               p3% = header.height=height of the image                    *
'               p4% = header.widt=width of the image                       *
'Output:        Image at the screen                                        *
'Uses:          DrawPixel                                                  *
'***************************************************************************
SUB ShowImage (p1%, p2%, p3%, p4%, p5%, p6%)
  count& = p2%                  'pointer into buffer
  byte% = 0                     'color
  FOR y% = p3% - 1 TO 0 STEP -1 'row loop
    FOR x% = 0 TO p4% - 1       'column loop
      DEF SEG = p1%             'set segment
	byte% = PEEK(count&)    'read 1 byte
      DEF SEG                   'reset segment
      count& = count& + 1       'increment the pointer
      DEF SEG = p5%             'set segment
	CALL ABSOLUTE(x%, y%, byte%, p6%)
				'set the pixel
      DEF SEG                   'reset segment
    NEXT x%
  NEXT y%
END SUB

'***************************************************************************
'SUB Waiting                                                               *
'Task:          Waits until the user has pressed any key.                  *
'Input:         none                                                       *
'Output:        waiting                                                    *
'Uses:          no subroutines                                             *
'***************************************************************************
SUB Waiting
  WHILE INKEY$ = ""
  WEND
END SUB
<PAGEEND:".TGA.Viewer.File">

<PAGESTART:".ANS.Viewer.File1">
''''' -=*=--=*=--=*=-  begin CANSI.BAS  -=*=--=*=--=*=-
DECLARE SUB ansi (a$)
ON ERROR GOTO botched
DEF SEG = &HB800: DIM SHARED SCR%(2): SCR%(1) = 80: SCR%(2) = 25
WIDTH 80, 25: COLOR 7, 0: CLS
INPUT "File to display"; F$
OPEN F$ FOR INPUT AS #1
WHILE NOT EOF(1): ansi (INPUT$(1, #1)): WEND: CLOSE #1
fini: COLOR 2, 0: FOR S% = 5 TO 35: SOUND S% * 200, .1: NEXT
   R$ = "": WHILE R$ = "": R$ = INKEY$: WEND: END
botched: COLOR 2, 0
   PRINT "file "; CHR$(34); F$; CHR$(34); " not found"
   PRINT "error"; ERR: RESUME fini
''''' -=*=--=*=--=*=-  end CANSI.BAS  -=*=--=*=--=*=-

SUB ansi (a$)
DEFINT A-Z: STATIC H, W, R, E, L, C, F, B, O, V, E$
IF W < 40 THEN W = SCR%(1): H = SCR%(2) - 1: R = W - 1: C = 0: F = 7: B = 0
IF E <> 27 THEN
   IF ASC(a$) <> 27 THEN GOSUB CHRout:  ELSE E = 27: E$ = a$
   EXIT SUB
END IF
IF O <> 27 AND ASC(a$) = 34 THEN O = E: EXIT SUB
IF O = 27 THEN
   IF ASC(a$) = 34 THEN O = 0
   EXIT SUB
END IF: E$ = E$ + a$
IF LEN(E$) = 2 AND a$ <> "[" THEN E = 0: E$ = "": EXIT SUB
S = INSTR("HfABCDsuJKmhlp", a$)
SELECT CASE S
  CASE 0: EXIT SUB
  CASE 1: GOSUB CursorA
  CASE 2: GOSUB CursorA
  CASE 3: L = -1: GOSUB CursorL
  CASE 4: L = 1: GOSUB CursorL
  CASE 5: L = 1: GOSUB CursorC
  CASE 6: L = -1: GOSUB CursorC
  CASE 7: V = C
  CASE 8: C = V
  CASE 9: CLS : C = 0
  CASE 10: L = C: WHILE L MOD W <> 0: POKE L * 2, 32: L = L + 1: WEND
  CASE 11: GOSUB Colorz
END SELECT: E% = 0: E$ = "": EXIT SUB
CursorA: L = VAL(MID$(E$, INSTR(E$, "[") + 1)) - 1
   C = VAL(MID$(E$, INSTR(E$, ";") + 1)) - 1
   IF C < 0 THEN C = 0:  ELSE IF C > R THEN C = R
   IF L < 1 THEN L = 0:  ELSE IF L > H THEN L = H
   C = L * W + C: RETURN
CursorL: P = VAL(MID$(E$, INSTR(E$, "[") + 1)): IF P < 1 THEN P = 1
   L = INT(C / W) + P * L
   IF L < 0 THEN L = 0:  ELSE IF L > H THEN L = H
   C = (C MOD W) + L * W: RETURN
CursorC: P = VAL(MID$(E$, INSTR(E$, "[") + 1)): IF P < 1 THEN P = 1
   L = (C MOD W) + P * L: C = INT(C / W) * W
   IF L < 1 THEN L = 0:  ELSE IF L > R THEN L = R
   C = C + L: RETURN
Colorz: E$ = MID$(E$, INSTR(E$, "[") + 1)
  DO: E = VAL(E$)
  SELECT CASE E
     CASE 0: F = 7: B = 0
     CASE 1: F = (F AND 7) OR 8
     CASE 5: B = (B AND 7) OR 8
     CASE 8: F = B
     CASE 30 TO 37: P = E - 29: E = ASC(MID$("@DBFAECG", P)) AND 7
                    F = (F AND 248) OR E
     CASE 40 TO 47: P = E% - 39: E = ASC(MID$("@DBFAECG", P)) AND 7
                    B = (B AND 248) OR E
  END SELECT: P = INSTR(E$, ";"): E$ = MID$(E$, P + 1): LOOP WHILE P > 0
COLOR F, B: RETURN
CHRout: P = ASC(a$)
   IF P = 7 THEN BEEP: RETURN
   IF P = 13 THEN C = C - C MOD W: RETURN
   IF P = 10 THEN C = C + W
   IF P <> 10 THEN POKE C * 2, P: POKE C * 2 + 1, F + 16 * B: C = C + 1
   IF C >= W * (H + 1) THEN
      C = C - W: LOCATE H + 1, W: PRINT
      P = W * 2: L = (H - 1) * P
      FOR L = L TO L + P: POKE L, PEEK(L + P): POKE L + P, B: NEXT
   END IF
   RETURN
END SUB
<PAGEEND:".ANS.Viewer.File1">

<PAGESTART:".ANS.Viewer.File2">
DECLARE SUB ansiout (s$)

' ANSI display V1.1 - Written by David Arigan
' You can use this freely provided you mention me in your credits.

DEFINT A-Z

OPEN "C:\THEDRAW\SHUTTLE2.ANS" FOR BINARY AS #1

blen& = 4096: buf$ = SPACE$(blen&): flen& = LOF(1)
WHILE flen&
  IF blen& > flen& THEN blen& = flen&: buf$ = SPACE$(flen&)
  GET #1, , buf$: flen& = flen& - blen&: ansiout buf$
WEND
CLOSE

SUB ansiout (s$) STATIC
  DIM parm$(16)
  IF init = 0 THEN
    init = -1
    fc = 7: bc = 0: cfx = 0: blink = 0
    lx = 1: ly = 1
    DEF SEG = &H0
    xl = PEEK(&H44A) + 256 * PEEK(&H44B)
    yl = PEEK(&H44C) + 256 * PEEK(&H44D) \ 2 \ xl
    cc$ = "000402140105031500040206010503070812101409131115"
  END IF
  COLOR VAL(MID$(cc$, (fc + cfx) * 2 + 1, 2)) OR blink
  COLOR , VAL(MID$(cc$, bc * 2 + 1, 2)) AND 7
  FOR i = 1 TO LEN(s$)
    a$ = MID$(s$, i, 1)
    IF a$ = CHR$(10) THEN a$ = "" ' ***** Linefeed fix
    SELECT CASE sq$
    CASE ""
      IF a$ = CHR$(27) THEN sq$ = a$ ELSE PRINT a$;
    CASE CHR$(27)
      IF a$ = "[" THEN sq$ = sq$ + a$: parm = 0 ELSE anserr = 1
    CASE ELSE
      sq$ = sq$ + a$
      SELECT CASE a$
      CASE "0" TO "9"
        IF parm = 0 THEN parm = 1: parm$(1) = ""
        parm$(parm) = parm$(parm) + a$
      CASE ";", ","
        parm = parm + 1: parm$(parm) = ""
      CASE "=", "?"
      CASE "@"
        sq$ = ""
      CASE "A"
        IF parm = 0 THEN y = CSRLIN - 1 ELSE y = CSRLIN - VAL(parm$(1))
        IF y < 0 THEN y = 1
        LOCATE y: sq$ = ""
      CASE "B"
        IF parm = 0 THEN y = CSRLIN + 1 ELSE y = CSRLIN + VAL(parm$(1))
        IF y > yl THEN y = yl
        LOCATE y: sq$ = ""
      CASE "C"
        IF parm = 0 THEN x = POS(0) + 1 ELSE x = POS(0) + VAL(parm$(1))
        IF x > xl THEN x = xl
        LOCATE , x: sq$ = ""
      CASE "D"
        IF parm = 0 THEN x = POS(0) - 1 ELSE x = POS(0) - VAL(parm$(1))
        IF x < 0 THEN x = 1
        LOCATE , x: sq$ = ""
      CASE "f", "H"
        SELECT CASE parm
        CASE 0
          y = 1: x = 1
        CASE 1
          y = VAL(parm$(1))
        CASE ELSE
          y = VAL(parm$(1)): x = VAL(parm$(2))
        END SELECT
        IF y > yl THEN y = yl
        IF y < 1 THEN y = 1
        IF x > xl THEN x = xl
        IF x < 1 THEN x = 1
        LOCATE y, x: sq$ = ""
      CASE "h", "l"
        sq$ = ""    ' *** set/reset graphics mode
      CASE "J"
        IF parm = 1 AND VAL(parm$(1)) = 2 THEN CLS
        sq$ = ""
      CASE "K"
        x = POS(0): PRINT SPACE$(xl - x); : LOCATE , x: sq$ = ""
      CASE "L"
        sq$ = ""    ' *** Inserts n blank lines at cursor line.
      CASE "M"
        sq$ = ""    ' *** Deletes n lines including cursor line.
      CASE "m"
        FOR j = 1 TO parm
          SELECT CASE VAL(parm$(j))
          CASE 0
            fc = 7: bc = 0: cfx = 0: blink = 0
          CASE 1
            cfx = 16
          CASE 2
            cfx = 8
          CASE 4    ' *** Underscore on
          CASE 5
            blink = 16
          CASE 7
            SWAP fc, bc
          CASE 8    ' *** Attributes Invisible
          CASE 30 TO 37
            fc = VAL(parm$(j)) - 30
          CASE 40 TO 47
            bc = VAL(parm$(j)) - 40
          END SELECT
          COLOR VAL(MID$(cc$, (fc + cfx) * 2 + 1, 2)) OR blink
          COLOR , VAL(MID$(cc$, bc * 2 + 1, 2)) AND 7
        NEXT j
        sq$ = ""
      CASE "n"
        sq$ = ""    ' *** ESC[6n asks for a Position Report
      CASE "P"
        sq$ = ""    ' *** Deletes n chars including cursor char.
      CASE "p"
        BEEP
        sq$ = ""    ' *** Keyboard Reassignment
      CASE "R"
        sq$ = ""    ' *** Cursor Position Report
      CASE "s"
        lx = POS(0): ly = CSRLIN: sq$ = ""
      CASE "u"
        LOCATE ly, lx: sq$ = ""
      CASE "y"
        sq$ = ""    ' *** Output char translate.
      CASE ELSE
        anserr = 1
      END SELECT
    END SELECT
    IF anserr THEN anserr = 0: PRINT sq$; : i = i - 1: sq$ = ""
  NEXT i
END SUB
<PAGEEND:".ANS.Viewer.File2">

<PAGESTART:".ANS.Viewer.File3">
This Article From Peter Cooper's "The BASIC Fanzine"....
-------------------------------------------------------------------------------
- SECTION ONE PART A PART 2 - (All about ANSI - Ben Ashley) -------------------
-------------------------------------------------------------------------------

 This is all by Ben Ashley. He's at  ben@seacloud.demon.co.uk  if you want to
 chat with him.

           A N S I   I N   A   Q B A S I C   T E R M I N A L
          ===================================================

...is what many message headers in alt.lang.basic/comp.lang.basic.misc look
like.  It is true, you can have ANSI.SYS installed, and simply open to CON:.
Or SHELL "Type <mydoc>".  But you still have no real control over the process.

The Program:

The program which accompanys this article is a Basic-Ansi terminal package. 
With it you can dial up BBS's etcetera, and have almost complete ANSI support.
You can also do ASCII Send and ASCII Capturing (The ASCII Capturing bit will 
also capture ANSI codes, so as you can keep all the funky ANSI artwork you see
laying about the place!)

What *is* ANSI?:

ANSI, is an acronym for American National Standards Institute.  ANSI codes are
an industry standard set of codes, which in this day and age are mainly used for
controlling output on a remote computer.

An Ansi code always takes the same format:

(ESCAPE CODE'27')([)(Paramater list seperated by ';')(Alphabetical ANSI Code)

And so a typical ANSI code will look like this:

  (ESC)[33;1m

The above code will turn the current text colour to yellow, and turn bold on.
The Escape Code is simply ASCII Code 27. This is the code that is generated 
when you press the Escape key, although text editors will not for some reason 
include it in your document by pressing the escape key.  So in our BASIC 
programs we have to resort to mundane things such as CHR$(27)!

Programming It:

When I first had the task of writing an ANSI terminal, back on my humble Amiga 
I did actually see the whole thing as a foreboding deal.  But when you sit down 
and look at the root of it all, it is infact quite simple.  It all boils down 
to what most programmers have problems with.  And that is, not knowing exactly 
what you want to do with the data.  When you have that on paper, the routine 
can spring up in your head, sometimes almost immediately.  Well, it does for me 
anyway.  Anyway, enough gibbering, lets have a look at the problem:

1. There is a text string, which we wish to display on the screen.  It is not
   a fixed length string.

2. It may or may not contain ANSI codes.  The only marker for these, to
   distinquish them from the rest of the text is CHR$(27)+"[".

3. The end marker is an alphabetical character.

Well the only thing we can do then, is output each character directly to the
screen, in the current pen and paper colours until we hit a CHR$(27).  Then
things get interesting.

What we do when we hit that ESCAPE character, can be done in many different 
ways.  We could search forward until we hit an alphabetical character and then 
store the character as the code and the space between the '[' and the letter, 
as the parameter list.  This seems the easiest and quickest in principle, but
in actual fact there is a huge gaping problem.  Can you spot it?
The answer is quite simple.  As the data is coming to us over the modem, there
can be delays.  So in our string, we may not have a complete ANSI code.

The other routine is reading it character by character (as my program does),
simply place all characters into another string as they come in, until we hit
an alphabetical character, which is then stored in another string.  Using
this method, even if we receive an incomplete code the first time, parsing will 
resume when more data comes in.  Nifty eh?

When parsing is complete (denoted by the first occurence of an alphabetical
character) we have two strings.  The first will contain our parameter list,
with parameters seperated by the ';' character, and a 1 byte string containing
the alphabetical code.

What we want to do now is pull out the parameters.  Well, my terminal program
searches through the 'info$' and pulls out each parameter one by one into an 
array until there are no more.  Some ANSI codes do not require any parameters, 
and so your program will need to check for this.  The following piece of code 
shows how my terminal program rips the codes out of the 'info$' string.

   current = 0
   IF LEN(info$) > 0 THEN
      REDIM param$(8)
      DO
         semi = INSTR(info$, ";")
         IF semi > 0 THEN
            current = current + 1
            param$(current) = LEFT$(info$, semi - 1)
            info$ = MID$(info$, semi + 1, LEN(info$))
         ELSE
            current = current + 1
            param$(current) = info$
            EXIT DO
         END IF
      LOOP
   END IF

Most 'newer' languages support REDIM PRESERVE.  This would allow you to have an 
array which contains exactly the correct amount of elements to parameters.  As 
you can see, this routine checks to see if this code *HAS* any parameters.  If 
not, we don't bother trying to parse it!

Lets have a look at some INPUT AND OUTPUT of this routine.

 INPUT : 33;1;2  INPUT : 2   INPUT : 32;40;1

 OUTPUT: 1. 33   OUTPUT: 2   OUTPUT: 1. 32
         2. 1                        2. 40
         3. 2                        3. 1

Simple huh?

Now we have our ANSI code, stored in 'code$'.  And we have an array of 
parameters.  If we have used REDIM PRESERVE we should have an array with the 
same amount of elements as codes.  If we have not, then we can use that 
'current' variable.  When that DO..LOOP has finished, 'current' will hold the 
total number of parameters it parsed.  If info$ was null, then 'current' will 
be equal to zero.  This is correct.  If you have printed out the ANSI Terminal 
listing and are looking at it now along with this document, then we are going 
to 'GOSUB ansihandler' now.  This right down at the bottom of the listing!

The first step is to avoid confusion later on, and make 'total = current'!
Now, we simply to a SELECT...END SELECT block, with the criteria being code$.

So what *does* each ANSI code do then?  Well have a look at some of the more
common codes:

 'H','f' - Locates the cursor, requires two parameters. : ESC [ 3;3H

 'A'     - Moves the cursor up a line, or a parameter
           can be supplied to specify the number of
           lines to move up                             : ESC [2A / ESC [A
 
 'B'     - Moves the cursor down a line, or a parameter
           can be supplied to specify the number of
           lines to move down                           : ESC [2B / ESC [B
 
 'C'     - Moves the Cursor forwards a character, or a parameter
           can be supplied etcetera...                  : ESC [2C / ESC [C
 
 'D'     - Moves the Cursor backwards etc..             : ESC [2D / ESC [D
 
 'm'     - Changes the graphics mode.  This can have a variable number
           of parameters, allowing several graphics codes to be set in one
           ANSI code.

                      3x - Foreground colour (30/31/32...37)
                      4x - Background colour (40/41/42...47)
                      0  - Reset Graphics mode
                      1  - Bold On
                      7  - Inverse Video On
                      8  - Conceal On
 
            These codes therefore can take on images such as:
 
           ESC [33m / ESC [33;40;1m / ESC [0m

           Get the Idea?

So, in our SELECT...END SELECT block we check for a match with each code.  On
doing this, we then (if necessary) check the parameters.  For instance, lets
have a look at the 'H','f' code which locates the cursor.  If no parameters are
supplied to this code, the cursor position is moved to the home position, which
is usually 1,1.  But in my terminal as I use VIEW PRINT, it is in fact X 1 Y 3.
Remember 'total', holds the number of parameters which have been passed.

    .   .   .
    .   .   .
    CASE "H","f"
       If total = 0 THEN
          x = 1
          y = 1
          LOCATE y,x
       ELSE
          y = VAL(Param$(1))
          x = VAL(Param$(2))
          LOCATE y,x
       END IF
    .   .   .
    .   .   .
  
The code for changing the colour is a little more complicated, but not much.
Bascically we simply change the foreground / background colour accordingly
based on what number was shoved through.  If you have a look at that section
in the code (Denoted by the 'CASE "m"' in the Ansihandler:), you will see
exactly what it does.  It is not a trivial task.


Thats basically all there is to ANSI handling.  We get codes and interprete them
using the language tools we have available to us.  We simply have to get into
a state of mind whereby we know that 'm' stands for 'COLOR'!!  There are many
more ANSI-codes, the list of which I have misplaced as of yesterday (good
timing huh?).  I have left out, quite a fancy ANSI-code on the basis that the
escape sequence for split-screen scrolling has escaped (har har) me.  This
code is basically the equivalent to the VIEW PRINT statement in QBasic.  If
anybody knows the code, or has a more complete list, perhaps they would be so
kind as to E-Mail it to me so as I can implement it.  Many fancy BBS's and
online games use Split-Screen scrolling.  Try listing file areas on a DLG run
BBS without Split-Screen scrolling and you will be surprised!  But once I have
the code, I think it can be implemented into the ANSI terminal program without
much problem.

So if you have any comments, queries, ANSI-lists, ideas or even death threats,
please E-Mail me at "ben@seacloud.demon.co.uk".  I will be unable to reply to
them before the 23rd of December though!

Happy COMMunicating, and Happy Christmas...

(ed note- if you're reading this then it should be past 23rd December, it's
 actually 15th when I'm typing this but never mind...)

 Now the accompanying program:  (sorry about the length but it's good!)

' +----------------------------------------------------------------------+
' |               ANSI Terminal - By Ben Ashley (C) 1995                 |
' |               ======================================                 |
' +----------------------------------------------------------------------+
' ************************************************************************
' Written especially for the alt.lang.basic/comp.lang.basic.misc FANZINE!!
' ************************************************************************

CLS
COLOR 15: LOCATE 1, 1: PRINT "- ANSI Terminal program - ";
COLOR 2: PRINT "Written by Ben Ashley for: ";
COLOR 4: PRINT "the alt.lang.basic Fanzine!"
COLOR 15: LOCATE 37, 1: PRINT "F1"; : COLOR 3: PRINT " Ascii Send ";
COLOR 15: PRINT "F2"; : COLOR 3: PRINT " Ascii Capture ";
COLOR 15: PRINT "F12"; : COLOR 3: PRINT " Exit ANSI Terminal";
COLOR 14: LOCATE 2, 1: PRINT STRING$(80, CHR$(196))
LOCATE 36, 1: PRINT STRING$(80, CHR$(196))
VIEW PRINT 3 TO 35
' ** Set Our ANSI Defaults & Flags **
x = 1             ' Current X Position
y = 3             ' Current Y Position
savex = 0         ' Cursor Store
savey = 0         ' Cursor Store
foreground = 7    ' Logical Foreground Color
background = 0    ' Logical Background Color
bold = 0          ' Bold Flag
reverse = 0       ' Inverse Flag
concealed = 0     ' Concealed Flag
ansistage = 0     ' What stage of ANSI PARSING are we at?
tabsize = 3       ' How many spaces is a tab worth in our program?
info$ = ""        ' This will store our ANSI parameters
code$ = ""        ' This will store our ANSI code
' ** Set up some other flags **
asciisending = 0  ' If this value is true, we are sending ASCII Text
asciicapture = 0  ' If this value is true, we are capturing text

LOCATE y, x, 1: COLOR foreground, background

ON ERROR GOTO errorhandler

OPEN "COM2:9600,N,8,1" FOR RANDOM AS #1
  DO
       ' ** Send Keypresses to the Modem **
   key$ = INKEY$
   IF key$ >= "" THEN
         ' We check for Option Keys first, as we don't want to send the
         ' codes!  If it is not an option key, we send to the modem!
      
    IF LEFT$(key$, 1) = CHR$(0) THEN
     SELECT CASE ASC(RIGHT$(key$, 1))
         ' Ascii Send
 
         CASE 59
         IF asciisending = 0 THEN
           VIEW PRINT 38 TO 39
           LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
           LOCATE 38, 1: INPUT "Filename to Send:"; file$
           OPEN file$ FOR INPUT AS #2
            IF ERR = 0 THEN
             asciisending = 1
             LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
             LOCATE 38, 1: PRINT "Now ASCII Sending.  Press F1 again to Stop"
           ELSE
             LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
             LOCATE 38, 1: PRINT "Error : Cannot Open File " + file$
            END IF
            VIEW PRINT 3 TO 35
            LOCATE y, x
         ELSE
            asciisending = 0
            CLOSE #2
         END IF
             ' Ascii Capture
         CASE 60
          IF asciicapture = 0 THEN
           VIEW PRINT 38 TO 39
           LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
           LOCATE 38, 1: INPUT "Filename to capture to:"; file$
           OPEN file$ FOR OUTPUT AS #3
           IF ERR = 0 THEN
            asciicapture = 1
            LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
            LOCATE 38, 1: PRINT "Now ASCII Capturing.  Press F2 again to Stop"
           ELSE
            LOCATE 38, 1: PRINT STRING$(80, CHR$(32))
            LOCATE 38, 1: PRINT "Error : Cannot Open File " + file$
           END IF
           VIEW PRINT 3 TO 35
           LOCATE y, x
          ELSE
           asciicapture = 0
           CLOSE #3
         END IF
                ' Quit
                CASE 134
 
                   ' Close Open Files
 
                   IF asciisending = 1 THEN CLOSE #2
                   IF asciicapture = 1 THEN CLOSE #3
                   VIEW PRINT 1 TO 48
                   CLS
                   EXIT DO
             END SELECT
          ELSE
             PRINT #1, key$;
          END IF
       END IF
 
       ' =================================
       ' ** Data Received to the Screen **
       ' =================================
      
       bytes = LOC(1)
       IF bytes > 0 THEN
          receive$ = INPUT$(LOC(1), #1)
 
          ' ===============================
          ' ** Below is the ANSI Handler **
          ' ===============================
 
    FOR f = 1 TO LEN(receive$)
     SELECT CASE MID$(receive$, f, 1)
     CASE CHR$(7)                     ' Beep
      BEEP
      CASE CHR$(8)                     ' Backspace
      GOSUB backspace
      CASE CHR$(9)                     ' Tab
      GOSUB tabchar
      CASE CHR$(10)                    ' LineFeed
      GOSUB linefeed
      CASE CHR$(12)                    ' FormFeed (CLS Basically)
      CLS
      x = 1: y = 3
      CASE CHR$(13)                    ' Carriage Return
      GOSUB carriagereturn
      CASE CHR$(27)                    ' Escape Character
      ansistage = 1
      ' Clear variables for use on the code itself
      info$ = ""
      code$ = ""
           CASE ELSE
                   IF ansistage = 1 THEN
                      IF MID$(receive$, f, 1) = "[" THEN
                         ansistage = 2
                      ELSE
                         ' If we received an escape char and then not a left
                         ' bracket, then we do not continue with ANSI parsing
                         ansistage = 0
                         IF concealed = 0 THEN
                            LOCATE y, x: PRINT MID$(receive$, f, 1);
                         END IF
                         GOSUB cursorright
                      END IF
                   ELSE
                      IF ansistage = 2 THEN
                         temp$ = MID$(receive$, f, 1)
                           
                         ' If our character is a letter, then that is the
                         ' ANSI code, and we now have all the information
                         ' we need to parse it.  Otherwise, all the info
                         ' added to the info$ variable, which will in
                         ' turn be parsed for each component.
 
                          IF ASC(temp$) >= 65 AND ASC(temp$) <= 122 THEN
                            ansistage = 0
                            code$ = temp$
                        
                            ' Parse Information String:
  
                            current = 0
                            IF LEN(info$) > 0 THEN
                               REDIM param$(8)
                               DO
                                  semi = INSTR(info$, ";")
                                  IF semi > 0 THEN
                                     current = current + 1
                                     param$(current) = LEFT$(info$, semi - 1)
                                     info$ = MID$(info$, semi + 1, LEN(info$))
                                  ELSE
                                     current = current + 1
                                     param$(current) = info$
                                     EXIT DO
                                  END IF
                               LOOP
                            END IF
                  
                            ' Now we have the ANSI code and all the
                            ' parameters which were parsed with it, nicely
                            ' in an array.  Now all that is left to do
                            ' is to act on it.
  
                            GOSUB ansihandler
  
                         ELSE
                            info$ = info$ + temp$
                         END IF
                      ELSE
                         IF concealed = 0 THEN
                            LOCATE y, x: PRINT MID$(receive$, f, 1);
                         END IF
                         GOSUB cursorright
                      END IF
                   END IF
             END SELECT
          NEXT f
       ELSE
          receive$ = ""
       END IF
   
       ' =====================================
       ' ** Ascii Sending / Ascii Capturing **
       ' =====================================
  
       ' Ascii sending is simple.  If there is another line to be read from
       ' the file, then we send it!
  
       IF asciisending = 1 THEN
          IF NOT EOF(2) THEN
             LINE INPUT #2, temp$
             PRINT #1, temp$
          ELSE
             CLOSE 2
             asciisending = 0
          END IF
       END IF
  
       ' Capturing is just as simple.  If receive$ is not null, then we
       ' write it to the file!
  
       IF receive$ <> "" THEN
          IF asciicapture = 1 THEN
             PRINT #3, receive$;
          END IF
       END IF
    LOOP
 CLOSE 1
 END

 ' =====================
 ' ** Cursor Movement **
 ' =====================
 
 cursorup:
    y = y - 1
    IF y < 3 THEN y = 3
    LOCATE y, x
 RETURN
 
 
 cursordown:
    y = y + 1
    IF y > 35 THEN
       y = 35
       PRINT CHR$(13);
    END IF
    LOCATE y, x
 RETURN
 
 
 cursorleft:
    x = x - 1
    IF x < 1 THEN
       x = 79
       GOSUB cursorup
    END IF
 RETURN
 
 
 cursorright:
    x = x + 1
    IF x > 79 THEN
       GOSUB linefeed
       GOSUB carriagereturn
    END IF
 RETURN
 
 
 linefeed:
    GOSUB cursordown
 RETURN
 
 
 carriagereturn:
    x = 1
    LOCATE y, x
 RETURN
 
 ' =================
 ' ** Other Stuff **
 ' =================
 
 backspace:
    GOSUB cursorleft
 RETURN
 
 
 tabchar:
   FOR f = 1 TO tabsize
       GOSUB cursorright
    NEXT f
 RETURN
 
 
 ' ==================
 ' ** Ansi Handler **
 ' ==================
 
 ' The routine contained in the main loop simply rips the wanted bits out of
 ' the code.  This is the action phase.  This subroutine will look at each
 ' code and act on it accordingly.
 
 ansihandler:
    total = current
    SELECT CASE code$
 
       ' Cursor Locate.  If No value is supplied ie '[H' then the cursor is
       ' moved to the Home Position.  'f' is also used for this purpose.
 
       CASE "H", "f"
          IF total = 0 THEN
             x = 1: y = 1
             LOCATE y, x
          ELSE
             x = VAL(param$(2))
             y = VAL(param$(1))
             LOCATE y, x
          END IF
 
       ' Cursor Up
 
       CASE "A"
          IF total = 0 THEN
             GOSUB cursorup
          ELSE
             FOR z = 1 TO VAL(param$(1)): GOSUB cursorup: NEXT z
          END IF
 
       ' Cursor Down
 
       CASE "B"
          IF total = 0 THEN
             GOSUB cursordown
          ELSE
             FOR z = 1 TO VAL(param$(1)): GOSUB cursordown: NEXT z
          END IF
  
       ' Cursor Forewards
  
       CASE "C"
          IF total = 0 THEN
             GOSUB cursorright
          ELSE
             FOR z = 1 TO VAL(param$(1)): GOSUB cursorright: NEXT z
          END IF
  
       ' Cursor Backwards
  
       CASE "D"
          IF total = 0 THEN
             GOSUB cursorleft
          ELSE
             FOR z = 1 TO VAL(param$(1)): GOSUB cursorleft: NEXT z
          END IF
  
       ' Save Cursor Position
  
       CASE "s"
          savey = y: savex = x
  
       ' Restore Cursor Position
  
       CASE "u"
          x = savex: y = savey
          LOCATE y, x
  
       ' Erase Display
  
       CASE "J"
          IF param$(1) = "2" THEN
             CLS
             x = 1
             y = 1
             LOCATE y, x
          END IF
  
       ' Graphics Mode (Colours/Bold Text etc)
 
       ' I am a bit confused here actually, as whilst I was looking through
       ' the ANSI Standard, code 1 turns Bold On/8 Reverse On and 7 conceal
       ' on.  The only way to turn an individual one off, is to send a code
       ' 0 (reset).  I would have made them toggles, but then who am I to
       ' change the ANSI standard??!!
 
       CASE "m"
 
          ' Here we go through each parameter, acting upon it as necessary
 
          FOR z = 1 TO total
             SELECT CASE VAL(param$(z))
 
                ' All Attributes Off

                CASE 0
                   bold = 0
                   reverse = 0
                   foreground = 7
                   background = 0

                ' Bold On
 
                CASE 1
                   IF bold = 0 THEN
                      bold = 8
                   END IF
 
                ' Reverse On
 
                CASE 7
                   reverse = 1
 
                ' Concealed Mode (No Output)
 
                CASE 8
                   concealed = 1
              
                ' Foreground Colours
 
                CASE 30
                   foreground = 0
                CASE 31
                   foreground = 4
                CASE 32
                   foreground = 2
                CASE 33
                   foreground = 6
                CASE 34
                   foreground = 1
                CASE 35
                   foreground = 5
                CASE 36
                   foreground = 3
                CASE 37
                   foreground = 7
 
                ' Background Colours
 
                CASE 40
                   background = 0
                CASE 41
                   background = 4
                CASE 42
                   background = 2
                CASE 43
                   background = 6
                CASE 44
                   background = 1
                CASE 45
                   background = 5
                CASE 46
                   background = 3
                CASE 47
                   background = 7
             END SELECT
               
             IF reverse = 0 THEN
                COLOR foreground + bold, background + bold
             ELSE
                COLOR background + bold, foreground + bold
             END IF
 
          NEXT z
    END SELECT
 RETURN
 
 ' ===================
 ' ** Error Handler **
 ' ===================
 
 errorhandler:
    RESUME NEXT
 RETURN
 
 Thanks for all that Ben. A great contribution everyone, eh?
-------------------------------------------------------------------------------
<PAGEEND:".ANS.Viewer.File3">

<PAGESTART:"Bload.Bsave.File1">
'BSAVEing arrays and BLOADing to arrays in QBasic/QuickBASIC by Jesse Dorland

SCREEN 13
RANDOMIZE TIMER
'$DYNAMIC
'Now we dimension the array we're going to be using.  For this
'code, we're only going to be saving a 50x50 square.
DIM Array%(1252)
'In order to BSAVE our array, we have to tell QBasic/QuickBASIC where
'the array is in memory.  This next line will set the memory segment
'to the beginning of where Array%() is in memory
DEF SEG = VARSEG(Array%(1))
'Now we want to draw something on the screen.  Since we're only saving
'a 50x50 square, we won't draw on the whole screen.
PRINT "Press any key to stop drawing"
DO UNTIL LEN(INKEY$)
'Draw a pixel within a 50x50 box
PSET (50 * RND + 50, 50 * RND + 50), 255 * RND + 1
LOOP
'Make our doodle a box
LINE (50, 50)-(99, 99), 15, B
'Get our box into an array
GET (50, 50)-(99, 99), Array%(1)
'Now comes the BSAVE part.  Here, we're going to save the
'entire array to a file called "BOX.SAV."  We've already told QBasic/
'QB where in memory Array%() starts.  Now we've got to tell BSAVE how
'many bytes after that we want to skip before starting to save.  We'll
'use VARPTR for that.  The reason you see "1252*2" below is because
'an integer is two bytes.  Array% is an integer array, which means each
'element holds two bytes.  Without the * 2, only half the box would be
'saved.
BSAVE "BOX.SAV", VARPTR(Array%(1)), 1252 * 2
'Reset the memory segment.
DEF SEG

'Great!  Now the box is saved to disk.  A loading routine follows.
CLS
'Erase Array%() just to show that the box is on disk and we're not
'using the copy that's in memory anymore.
ERASE Array%'Dimension the array we'll use to hold the box.
DIM Box%(1252)

'We have to tell QBasic/QB where to start loading
DEF SEG = VARSEG(Box%(1))

'Now we BLOAD the box into the array.  Again, we use VARPTR to tell
'BLOAD what byte position to begin loading to.
PRINT "Press a key to load and display."
A$ = INPUT$(1)
BLOAD "BOX.SAV", VARPTR(Box%(1))

'Display the box onscreen to prove that we've loaded it.
PUT (50, 50), Box%(1), PSET

'Delete the box file
KILL "BOX.SAV"
<PAGEEND:"Bload.Bsave.File1">

<PAGESTART:"Bload.Bsave.File2">
This Article From Peter Cooper's "The BASIC Fanzine"....
______________________________________________________________________________
| SECTION 1 PART B SUBPART 2 | Graphics tips and tactics |
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 This article is by James Erickson, he can be reached at:
         ericksnj@teleport.com
 For how long I don't know.. he changes email address a lot. 8-)
 Cheers, James 8-)

Have you ever wanted to save a graphic in BASICs Screen 13.  Or more 
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
importantly load one quickly?  Well its easy!  Here's how...
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
First you'll need to draw something on the screen.. It doesn't matter
how.   Then you need to save it.  The first step is to point to the 
segment of the video address.  Then you want to bSAVE the graphic:

DEF SEG=&HA000
BSAVE "filename",0,64000

64000 will save the entire screen.  So use that to save an entire screen.
It works sort of like Peter Coopers putpixel.  Just multiply the y value
by 320 and the x value and add by one.  So if you only wanted to save the 
upper half of the screen it would be ((y*320)+x)+1.  In this case y would 
be 99 and x would be 319.  The reason you need to add by one is when you 
are saving the graphic it thinks of (0,0) as 1 instead of 0.  So that means
you have to add the entire thing by one.  So once again here is the equation:
((Y*320)+X)+1

The parenthesis are not really needed, but they are good to put in.

To Load the screen back up later, just do this simple thing:
Def Seg=&HA000
BLOAD "filename"

That's it!!!
-----------------------------------------------------------------------------

Well those loading and saving routines are all well and good if you want 
to grab the entire screen, or the upper parts, but what if you want to save
and load a sprite?  Well that is a little more complex, but it is still 
easy!

First as usual you draw something on the screen.  Then you need to make 
an array for your sprite.  I am not sure how you demention your array 
based on the graphic size, because the demensions of the array can be 
smaller then the sprite's demensions!  So if anyone knows what the equation 
is for dimensioning an array based on the sprites dimensions then I would 
LOVE to know.  But until then I just dimention the array according to the 
sprite size.  So if the sprite is 20x20 the the I make the array 20x20.  
What I do is say

Dim array(20*20) or..
Dim array(20,20)

Then you need to get the image.  If you don't know how GET works then look 
it up in you BASICs help file.

Like..
GET (1,1)-(20,20),array

Now you need to point to that array like so..

DEF SEG=VARSEG(array(0))

Now it is safe to save it.  Like so...

BSAVE "filename",Varptr(array(0)),length

The equation for the length of the file does not work for saving a sprite 
either.  it is not X*Y, so I don't know what the equation for it is.  So 
I hope someone who knows the equation can contribute it to the fanzine.
Meanwhile for length I usually use 16384, but if the sprite does not load 
up all the way when you try to load it, then increase that number.
VARPTR tells BSAVE where to look for the info.  In this case it is the
memory location where the array is stored.

OK, now that you have the image saved, you can use it in one of your
programs.  But this time when you load up the graphic, you load it into
an array instead of to the screen.  Don't worry it is just as fast.

First dimension your array, the way you did before...

Dim array(20*20) or..
Dim array(20,20)

Now point to that array again:

DEF SEG=VARSEG(array(0))

Now Load the graphic the same way you did before, but this time load it into
the array.  Like so:

BLOAD "filename",VARPTR(array(0))

Now that it is in the array you can put it on the screen whenever you want!
Just use PUT.  If you don't know what PUT is then look it up in the online
help.  But here is the general idea...

PUT (x,y),array,PSET

I Hope I have not further confused you, but nevertheless those things work.
----------------------------------------------------------------------------
<PAGEEND:"Bload.Bsave.File2">

<PAGESTART:"Bload.Bsave.File3">
'>>> Page 1 of BOUNCE1.ZIP begins here. TYPE:BINAA TLEN:2820
'-------------------------------------------------------------
'                  INSTRUCTIONS FOR DECODING
'If there are multiple parts to this file, merge them into one
'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all
'message header and footer information (everything outside the
'">>> Page x of..." lines),  load the result into your version
'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original
'file will be decoded into the current directory on your disk.
'-------------------------------------------------------------
DEFINT A-Z:DIM SHARED K,S,B&,Z&:V1 'Created by PostIt! 7.3
SUB V1:OPEN "O",1,"BOUNCE1.ZIP",4^6:Z&=2820:?STRING$(50,177);
U"%up()%9%'%d-%e)%rFI/+oFJ)7%%E-%%%0%%%%gt%zshj%VSgfCxdz,,B[[9hL6
U"Ux/?Kj40LJ(1hj,aR)EU'n/gK_&YE3fjW)TfX0*aa1Z187&c+*hKkVfR#heCDHa
U"^pCBYrjV3u3=Ykt>Y;$V:e>)bP>V/.qk;:&B?Nq+7F(SVj\>?[cCtZEo=VKb+IC
U">DDegVOACbkXLF?TE#1TZhhuxa7D3*+qba^IU'h[&HF?O[TvXuY-Hq-geFAvP9#
U"JsY;C*q*Fs8jnV.*qST7>45?Gb296\/;5YpqJU%LO7n2l,8Fm^'BK+Uk5J.)Zia
U"V0D_CN)kpOrvS'R(SH6R&39i.VZ$+g5:F8n&sa^1N*]1iejbba_bl57&JjPLW1j
U"FX6slFOBV'D+BS:-y/Q9(5lSkD(c898*;_yRUc:E-/sY3PPoFk2rPRTUeLqT6<Z
U"Eb2vM6DEZ4>&ld<mUv[5<%V\OKc7GJNa+lmZ#Lj;^4,V_KkR?ee>#\TdZpCQ-^#
U"]FUk^E4FLW9hwIDd/o)EA'7mSY49$/n-'<M.m50_LkjcH9QsUUJ:0/qYF\;m\V2
U"u(*UZldEo*o[H+D3BpT=I+W+#76W2Vn<w825>(Wcu?H4]aC_,?/iwncfM&KXD6R
U"rJpwTVOlQ3X&PMJ;1nCmqBylv/G.VoH_/SlOC6J=8zMB*E5gXX_BwueP]U9+D+B
U"S3ivSw:nCi\JSlJ[X%ip6P&j]oM*lUXw+h;Qy]:4#*RZG(O7*VP'JMiL$jkpe>/
U"hv?ff,k%6f+7([/#jjCnqE]+I1JI:Gu-^aSJg-vob;rZHLKwc[MpxSq2aqC*ix^
U"U;D74L;SsoW][mBWn6[SS8dW7?dzn2*ct8n\ROr0Nph8d*6t^umr%hM?_;xuS1A
U":20n*^Ct*=-]zmQjEP#?FpK^'_.*,wZpgC+\wgBM,NSb&GA]<MWOfA4(ng4mFtV
U"6,pZoV2e8Ap=g/vKmW8*nBE3C9*<KuM^;*:AJvSBBCBpwY,))eY;\#;%sE$k,*+
U"il+V/wxNqnRXjZS7I4kX-x;s]8Ke#1F)?QH:>;:hi<Gm()b(cw)_IXJ2vQOiN[o
U"x_..U>UUJINs9(WVDEQ[WCBqq1f-Z7Gp*;17kHF3of;D%z[,Z8X7^]5i&In2h(i
U"o:fq1Smt2,tfC/eNnt2D)6q&'o3Ji1pEdlhA%zo_I(X&[VCZiKFrQjhk*_L=tmv
U"^<7Od;ml)*gm$Bl#Ov=C##,[Lz>Vn2%p87%SX&_Kzqr.KcJ,cI*%rI#*db.p*H*
U"__f/k#H*zKAtEd%G_8v?:1?r33Y*LLjA#6hC%Y#riaj#B\GVYOW<YTBhmx_t>uV
U"UC-$s-[p#^,RFX7tfJbl'6R3D_vOsp:z$qjJ>(dS?C4m/8[Q?L$('q<up%()9%%
U"'%-%)GdrF.ny$\'H'%%&M7%%%.%%%&&tti%VSufLq4d*-'TU1F*x0CL4-QHsi6O
U"8*+);HTBBY-gEkg=jIrgdu7OXXLdf,&WVbWxr?c'DK-l.2gB2m\OiH+mWPH8,Z$
U"1W=lHdEEsb_rECUHI30#85&Kk47R]QnfSgG^tKE$hA3#dx3a>.kQOPN/)_c6N4k
U"5=bmI\k+>C6fUa3CWnnbCA*C3R_2k+Orp6zgqA;NLE8$EV_H$#ms_0?KtT(*TB3
U"k=G\bJHt$$6]An$C3HXB,hn*JA7Ix\H=j2KQ-1jUB^HhqB3WV#T3k=2Q%d$ckd$
U"$],RbFkK*:zQe$qDaqo(,8,nmT>Gv<5khr<_%/E<dAOI*tAs,/HT64JqjmZH\lD
U"fgp_L2LsA+=L,hFIq_D2Ug,HNLokq'lbAJIt[snfomBdA5;bRqGH<Rd*TnElhg;
U"3>naE^lcVL_pjH(<^n\*zfoXX<2MVW.dfO3k;[TH;xR^9_/KXesxs'VE+G8_)[E
U"M?=?=M?=?=k?g?gk?g?gk?g?gk?g?gk?g?g>?/tK%WG6J7GLCi)Tw7ZaGS#fG\o
U"kJtr6JW;7>-\TS#f\Woq67jTSZo5q67TWSZoqN67n7Mn7n7Mn7n7Mn7n7Mn7n7q
U"n7h-bFS$fGlosJtv6LWY8h-FWS6S6WS6S6WS6S6WS6S6WS6S69S<S<9S<S<9S<S
U"<9S<S<9S<S<WS&S&WS&S&rS&S,5x?w?Vz9Eyr*z?)4?D9qtz*&?T1?d9rEz*(-?
U"9?0n:q%*?*?A?pP:E%u*,?I.?p:qZ&*.1Y:>OY0&:*Pi/%;&rQ)*.q1:>OGY&:*
U"OP/%;l&Q)*i.1:><OY&:S*P/%Y;&Q)Q*.1:l>OY&^:*P/q%;&QY)*.1Y:>OY0&:
U"*Pi/%;&rQ)*.q1:>OGY&:*OP/%;l&Q)*i.1:><OY&:S*P/%Y;&Q)>p.x%%up()%
U"9%'%R-%4d.rFYH:$vU'[%%,s%%%.%.%%&t%tiVS\%lfffSpz\[[%eZ+5'D'.8)Q
U"-\Sf0B.0.3i8R[*.p[g:EuuBwGCgp\F]Lw=[a1V9G7<mo,U$IwH6svC_iv#IDa4
U"u0v6wlMzY>fYV=Ebp0-v-VV3t+u7tKeape-dts=56lF&sWRJMcYM>*mbw4PRl0)
U"_vA#LN-\TMl#tD+*PEM^f$W<TK7q2(qQtX:eMg8\G1mFcEbmwiPe&[*a5m$ME(e
U"o(BdqS05)0<RUN<tCS*bv]Bm$0xMI:U+AAmNdP4TfA8*CbDs&bnl\MgM&ceiZsM
U"e8,uZTfwLT4docNbFs.DvsBk_DH3drm<XpSJNDmgCzfm>JRhhpmx.*X^#Y,7-NV
U"DWT-C%-CXTUr6MS(m;<&EUU'dBMgf<,[DJbo,k/A'Wv-ozBSso:V\Z2SgaeDTl0
U"t>L/Cp*CZbp3.0PnLZUSI$KXADqkX*'Hx^qgBv>]58okxW)\qBkD5l'lgC5kLih
U"YsXDMOrT,sM%IWRlt]lHfdWU$n3_Kh?9lP-qxsOo_9LS2NEB#pNE0k+l/mJVN(<
U"3vB-W[)Wdkp#qiZHRt\JJhkD8BTB-wo<$.#F?Pk,FpRi\s/YJs6-tN-.15Cc:2Y
U"K.G(1<BCVN17UeSM,sl2T_lYoHj)n,.<m3ZglT9lO8VoQ(SuHQ7:),u..ode^Ui
U"HNX]MVTotduI6g-ck%cI.r<?.6ub.gQox$Oh2r<)FqscCm3OgzziO7tQf8dIwTj
U"vN\Ba_Nn;^ocdLd)EkOD6#M_(&rT\XsmR88N^js/GXWWbF'il/biDJBMMEA;^dN
U"ulw:25ycy6&q6rxqBN\P0g4LyqDL[ws5p(a%ld%%%%%%%%%%%%%%%%%%%%%%%%%
U"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
U"%%%%[%%%w-pw'u%p&'9%%9%'#%-%e')rFI7/oFJ[)%%E%-%%0%%%%%%%%%&%%E%
U"%%%%%%%%gtz%shjV%Sgfx%up&'%9%9%%'%-%)GdrF.ny$\'H'%%&M7%%%.%%%%%
U"%%%%&%E%%%%s).%%&t%tiVS%ufqu%p&'9%%9%'[%-%4AdrFYdH$vU%'%%,'s%%.
U"%%%%%%%%%&%%E%%%%i,%(%&tt#iVS%%lfup%*+%%%%%(%.(%v%%%%l/%%%%%
END SUB
CLOSE:IF S=90AND B&=Z&THEN?" :) Ok!"ELSE?" :( Bad!
SUB U(A$):FOR A=1TO LEN(A$):C=ASC(MID$(A$,A))-37:IF C<0THEN C=91+C*32
IF K<4THEN K=C+243ELSE?#1,CHR$(C+(K MOD 3)*86);:K=K\3:B&=B&+1
S=(S+C)AND 255:NEXT:LOCATE,1:?STRING$(B&*50\Z&,219);:END SUB
'>>> Page 1 of BOUNCE1.ZIP ends here. Last page. TCHK:90
<PAGEEND:"Bload.Bsave.File3">

<PAGESTART:"Bload.Bsave.File4">
'>>> Page 1 of FASTSPRT.ZIP begins here. TYPE:BINAA TLEN:2071
'-------------------------------------------------------------
'                  INSTRUCTIONS FOR DECODING
'If there are multiple parts to this file, merge them into one
'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all
'message header and footer information (everything outside the
'">>> Page x of..." lines),  load the result into your version
'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original
'file will be decoded into the current directory on your disk.
'-------------------------------------------------------------
DEFINT A-Z:DIM SHARED K,S,B&,Z&:V1 'Created by PostIt! 7.3
SUB V1:OPEN "O",1,"FASTSPRT.ZIP",4^6:Z&=2071:?STRING$(50,177);
U"%up()%9%%%d-%+,8'FRd1Uu3*.%%01%%%1%%%%kf%xyxu%wySgIfx\%;:>SoO5v
U"-xNx0QQdo7VSdeC\gu&=<-/w9+qjOk#*GfY#2Q44EWlxvlR0.Bbp](?zB?gGE^k
U"6H[fqMGxgX(EQ]K<B[h+q:ri__A=j/,qp6IpN3hID$l^>n'b-;/_\vadk*Xc<-2
U"v/k0xGi\'/]r#OB9+XYl;JGt9\^fYT0nP)u#7e+4I9]E[Q#2G3Aj#hRaF6i4s1V
U"3ahIh08O4ql_xinr/Ba[iIiNFUJ8?iE<A?+A$'tE*H:Ec=2y=;UHa^3j5Rf2U/8
U"72Y98T$.*s)*3q]*p0#aP=T)e1<6p4VXWP;5\1:3mMv=HPg>nH4injq\/NGC^=Q
U"2]A#+CZO1i#jAmE1V;cJTMiqd#iHJ9mu='vlvR70<kaU[-:Qp*GaQ)$0W3[Gs)r
U"&hpm)WMic%^I8K#I\EogEx2-)2SEb^6VFVChuq;R'Cs</?ge(?L^tE3Vqo[#q[/
U"h;cOAGPX_wmq=wHQdN>qV:#+YrTIh_<'*<+IG>*-3Pef+sAbr'GA5Gef31Aj*fQ
U"RU2VWU&oo]MT&J#>>c.i.MEg.crI2Jx)f\(q-]tN[2=fwbBV2e<_=WQe-7X7lqi
U"=.[R)kQ0pj8r&uJ(m4.g_f:<\tTQcE;ZLwvPyj$4,roQooZ7wB-ic$C\tfA:gSV
U"Wf$M\^sDJqlcdjTU3NHepw)3jjL=*7\Go;Ik;HEPiRC5laP(U'0KSAw221t+F1h
U"N0ZUlhl>o..q/T'[yl-AXn_1(YD$oNDa&vL:7TX#C;4X(yB\&rMY3I1FupGCYS0
U"^93e6aQ#Tmb&cI3(ex+p&12AV0iTmPNsz4J]F$5Y*_e8?I[$XE(l&$zsW_p/hWw
U";/It63SvWS.Qr$[TVA%[#SU<,:;^GC'_6Gi>CRh:NP8NZ6NPkZO0/MHU8RHb5dQ
U"X+.W9,2T?+/gztgd>s,n/Fa.e)Y';Ql$IJxC3Os%Gzk-4oKFI>\%P(KCX[q56DO
U"1[RgzV]qHu\rrJG#MWjh6)[GORb97Od86/7dwL7uwSRynCa^x[387SsjW2?p&\,
U"c]ll=G0=5ku#9'.UG]kk=-fG\yn<6XWh9HFuD#++3bZlL$+:B,ZF]5Q^+IGGxAy
U"/eMAdJ6J5CWJ<Cg*iS*lOJ-'oM4AP-gbZ?*,6IH5V=T^gql.+mt7wtF4aW4BmI=
U"J/rECiTB$pM%G6vKD;Vbtfe*$Dk98&(6$QY#'\>r%'BdBKo\YyZ(xbbjfu+XF-Q
U"?8S,\1E72ri=>u'2gz5ZM2x)M(uR[DEof[CO1a0JC<'3\5MrhQpd>iAGEuwLj5N
U"Z(:vze>_/(zbU_NtL\=9yLlrUPt*RAW*mZ(sNE)k$If?OzhUO8NS(:Z0e.CYu_'
U"8Ob^^cZ;/-.Q6A7weDF)vk,?,Q<\gh(E]p%ZVox%xNfwXbN=udbz7\#z8^=%1=D
U"fWe+P#A9:<?Ev6:2un-Jh=p)m6XN:v.5GNi=ewdCL6BEMHuf+Yf))9tsG-LH1<9
U"/%6ceR-*>8v3wV&Ffxpb+;)HhSUh,L,Ds)DP_5Wb8nc;xvNv7YbNKh)NU'cRNbK
U"+.1RP]-slbQebu+G%vFX)&V7:h2G[jZ+?q&&0q6[HxDkfu(JZ7G2wT6Pe5Ay&]]
U"4Z$GV_$<<#G/uw3[-Z'C<]VHSL^h]?-MI]dRDuT&,[9o\5M9nRf6'?+Y3cdn)Vc
U"wb):kz+*&_zkndj3?4(igYpO93Q,SWY&<o$x6>sZdL2x;-U^\i<y4TaxPS#4zH7
U"VK+0JHW8g6N'pTup%()9%%%%-%1lb%F7=wWp'T&%%-px%%%.%%%%xmnu%VSxu=w
U"fIv,9Te=a)YVARm&#hPBmcLNaPBP?K')g(QvumTU,L>jeSNoUfzvMkMt$5Qwsm5
U"9Da$Oulum-4Q4I]n;#lkuW#5nq4Hhl(amQHtNal7G^+2(ad8s$kflIMeaV[p1Ye
U"8beG#uLWrCbfQZ/^Du3uomZ/8hh?Wg.3h^0?Xs$X_C*Yz^Ct^4surkK6jB0c[E9
U"nhHrHvIdj#$?a;d=U/9&O&(+#1=U/*9O&(%+1=U5/9O&%(+1=UU/9O%&(+1d=U/
U"9&O&(+#1=U/*9O&(%+1=U5/9O&%(+1=UU/9O%&(+1d=U/9&O&(+#1=U/*9O&(%+
U"1=U5/9O&%(+1=UU/9O%&(+1d=U/9&O&(+#1=U/*9O&(%+1=U5/9O&%(+1=UU/9O
U"%&(+1%=Y1?I+2RUOf<o00IU7=%Y1?+12RUfi<o0I(U7=Y%1?+2_RUf<;o0IU&7=
U"Y1#?+2RSUf<oG0IU7#=Y1i'xb1=UU/9O%&(+1d=U/9&O&(+#1=U/*9O&(%+1=U5
U"/9O&%(+1=UU/9OU&RtU%&(+1d=U/9&O&(+#1=U/*9O&(%+1=U5/9O&%(+1=UU/9
U"O%&(+1d=U/9&O&(+#1=U/<i>l#%up&'%9%9%%%%-%5+,'FBRdUu&3*%%&01%%%1
U"%%%%%%%%%&%E%%%%%%%%%kf%xyxu%wySg%fxup%&'9%%9%%%#-%lb&%F=w9WpT&
U"m%%px%%%.%%%%%%%%%%%%E%%%&]*%%%xmnu%VSxu%wup*%+%%%%%'%'(%#%%(%_
U",%%%%%
END SUB
CLOSE:IF S=171AND B&=Z&THEN?" :) Ok!"ELSE?" :( Bad!
SUB U(A$):FOR A=1TO LEN(A$):C=ASC(MID$(A$,A))-37:IF C<0THEN C=91+C*32
IF K<4THEN K=C+243ELSE?#1,CHR$(C+(K MOD 3)*86);:K=K\3:B&=B&+1
S=(S+C)AND 255:NEXT:LOCATE,1:?STRING$(B&*50\Z&,219);:END SUB
'>>> Page 1 of FASTSPRT.ZIP ends here. Last page. TCHK:171
<PAGEEND:"Bload.Bsave.File4">

<PAGESTART:"Music.File">
'<PRE>
' DMA Play
' By Mike Huff (1996)
' Audio file player that plays using the DMA channels.
' Runs in QBASIC, QuickBASIC, PDS, VBDOS, and even GW-BASIC!!! (If you add
' line numbers and remove the SUBs, FUNCTIONS, and do a few other things.)
' Use DMADone% to detect the end of a transfer.
' Tested on a 486DX4-120mHz with a Reveal Sound FX card.
DECLARE FUNCTION SpeakerStatus% ()
DECLARE FUNCTION DMAStatus% ()
DECLARE FUNCTION DMADone% ()
DECLARE FUNCTION ResetDSP% ()
DECLARE SUB FMVolume (Right%, Left%, Getvol%)
DECLARE SUB VocVolume (Right%, Left%, Getvol%)
DECLARE SUB MasterVolume (Right%, Left%, Getvol%)
DECLARE SUB MicVolume (Gain%, Getvol%)
DECLARE SUB LineVolume (Right%, Left%, Getvol%)
DECLARE SUB CDVolume (Right%, Left%, Getvol%)
DECLARE SUB InputSource (InputSrc%, GetSrc%)
DECLARE SUB WriteDSP (byte%)
DECLARE SUB SetStereo (OnOff%)
DECLARE FUNCTION ReadDSP% ()
DECLARE SUB WriteDAC (byte%)
DECLARE SUB SpeakerState (OnOff%)
DECLARE SUB DMAState (StopGo%)
DECLARE FUNCTION ReadDAC% ()
DECLARE SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
DECLARE SUB DMARecord (Segment&, Offset&, Length&, Freq&)
DECLARE SUB GetBLASTER (DMA%, BasePort%, IRQ%)
DECLARE FUNCTION DSPVersion! ()
COMMON SHARED BasePort%, LenPort%, Channel%

CLS
PRINT "DMAPlay"
PRINT "By Mike Huff"
PRINT "The first background WAV/VOC/etc player/recorder in BASIC I've ever seen"
PRINT "Use freely"
PRINT "Comments, etc. can be sent to MHuff@gnn.com or on FidoNet in the QUIK_BAS echo"
GetBLASTER Channel%, BasePort%, IRQ% ' Parses BLASTER environment
PRINT STRING$(80, 196)
IF ResetDSP% THEN 'resets DSP (returns true if sucessful)
   PRINT "DSP reset sucessfully!"
ELSE
   PRINT "DSP failed to reset, try another port."
END IF

SpeakerState 1 'turn the speaker on
PRINT "Sound Card DSP version:"; DSPVersion!

MasterVolume Right%, Left%, -1 'this puts the mixer volumes in Right% and Left%
PRINT "Master volume is set at: Right-"; Right%; " Left-"; Left%
MasterVolume 15, 15, 0 'this cranks the master volume all the way up.

DIM WavBuffer(1 TO 1) AS STRING * 32767 'Make a 32k buffer for file.
INPUT "WAV/VOC/SND file to play: ", Filename$
OPEN Filename$ FOR BINARY AS #1
GET #1, 44, WavBuffer(1) 'Get 32k from file (skip header on WAV)

Length& = LOF(1) - 44
IF Length& > 32767 THEN Length& = 32767'Adjust length if needed to 32k

INPUT "Frequency to play at: (1000-41000Hz)", Freq&
DMAPlay VARSEG(WavBuffer(1)), VARPTR(WavBuffer(1)), Length&, Freq&

'Use DMARecord to record in the background.
'and use DMAPlay to playback the same buffer you recorded to or you could
'even write the buffer to a file.
'DMARecord VARSEG(WavBuffer(1)), VARPTR(WavBuffer(1)), Length&, Freq&

DO
COLOR RND * 15
PRINT "Check it out! It's playing in the background!"
LOOP UNTIL DMADone%

CLS
COLOR 7

PRINT "MA transfer completed!"


SUB CDVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H28
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

FUNCTION DMADone%
Count% = INP(LenPort%)
Count2% = INP(LenPort%)
Count& = CLNG(Count% + 1) * CLNG(Count2% + 1)
IF (Count& - 1) >= &HFFFF& THEN junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

SUB DMAPlay (Segment&, Offset&, Length&, Freq&)
' Transfers and plays the contents of the buffer.
Length& = Length& - 1
Page% = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H48
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H49
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H4A
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H4B
    CASE ELSE
       PRINT "DMA channels 0-3 only are supported."
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page% = Page% + 1
IF (MemLoc& AND 131072) THEN Page% = Page% + 2
IF (MemLoc& AND 262144) THEN Page% = Page% + 4
IF (MemLoc& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%
OUT LenPort%, Length& AND &HFF
OUT LenPort%, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel%

IF Freq& < 23000 THEN
   TimeConst% = 256 - 1000000 \ Freq&
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H14
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)
ELSE
   IF DSPVersion! >= 3 THEN
      TimeConst% = ((65536 - 256000000 \ Freq&) AND &HFFFF&) \ &H100
      WriteDSP &H40
      WriteDSP TimeConst%
      WriteDSP (Length& AND &HFF)
      WriteDSP ((Length& AND &HFFFF&) \ &H100)

      WriteDSP &H91
   ELSE
      PRINT "You need a Sound Blaster with a DSP v3.x+ to play at high speed."
      EXIT SUB
   END IF
END IF
END SUB

SUB DMARecord (Segment&, Offset&, Length&, Freq&)
Length& = Length& - 1
MemLoc& = Segment& * 16 + Offset&
Page% = 0
SELECT CASE Channel%
    CASE 0
       PgPort% = &H87
       AddPort% = &H0
       LenPort% = &H1
       ModeReg% = &H44
    CASE 1
       PgPort% = &H83
       AddPort% = &H2
       LenPort% = &H3
       ModeReg% = &H45
    CASE 2
       PgPort% = &H81
       AddPort% = &H4
       LenPort% = &H5
       ModeReg% = &H46
    CASE 3
       PgPort% = &H82
       AddPort% = &H6
       LenPort% = &H7
       ModeReg% = &H47
    CASE ELSE
       EXIT SUB
END SELECT

OUT &HA, &H4 + Channel%
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (LongByte& AND 65536) THEN Page% = Page% + 1
IF (LongByte& AND 131072) THEN Page% = Page% + 2
IF (LongByte& AND 262144) THEN Page% = Page% + 4
IF (LongByte& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%
OUT LenPort%, Length& AND &HFF
OUT LenPort%, (Length& AND &HFFFF&) \ &H100
OUT &HA, Channel%

IF Freq& <= 23000 THEN
   TimeConst% = 256 - 000000 \ Freq&
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H24
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)
ELSE
   IF DSPVersion! >= 3 THEN
      TimeConst% = ((65536 - 256000000 / Freq&) AND &HFFFF&) \ &H100
      WriteDSP &H40
      WriteDSP TimeConst%
      WriteDSP (Length& AND &HFF)
      WriteDSP ((Length& AND &HFFFF&) \ &H100)
      WriteDSP &H99
   ELSE
      PRINT "You need a Sound Blaster with a DSP 3.x+ to record at high speed."
      EXIT SUB
   END IF
END IF

END SUB

SUB DMAState (StopGo%)
' Stops or continues DMA play.
IF StopGo% THEN WriteDSP &HD4 ELSE WriteDSP &HD0

END SUB

FUNCTION DSPVersion!
' Gets the DSP version.
WriteDSP &HE1
Temp% = ReadDSP%
Temp2% = ReadDSP%
DSPVersion! = VAL(STR$(Temp%) + "." + STR$(Temp2%))
END FUNCTION

SUB FMVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H26
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB GetBLASTER (DMA%, BasePort%, IRQ%)
' This subroutine parses the BLASTER environment string and returns settings.
IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": EXIT SUB
FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
      CASE "A"
        BasePort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
      CASE "I"
        IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
      CASE "D"
        DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
   END SELECT
NEXT

END SUB

SUB InputSource (InputSrc%, GetSrc%)
OUT BasePort% + 4, &HC
IF GetSrc% THEN
   InputSrc% = INP(BasePort% + 5) AND 2 + INP(BasePort% + 5) AND 4
ELSE
   OUT BasePort% + 5, InputSrc% AND 7
END IF
END SUB

SUB LineVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H2E
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB MasterVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H22
'PRINT BasePort%
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB MicVolume (Volume%, Getvol%)
OUT BasePort% + 4, &HA
IF Getvol% THEN
   Volume% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, Volume% AND &HF
END IF
END SUB

FUNCTION ReadDAC%
' Reads a byte from the DAC.
WriteDSP &H20
ReadDAC% = ReadDSP%

END FUNCTION

FUNCTION ReadDSP%
' Reads a byte from the DSP
DO
LOOP UNTIL INP(BasePort% + 14) AND &H80
ReadDSP% = INP(BasePort% + 10)
END FUNCTION

FUNCTION ResetDSP%
' Resets the DSP
OUT BasePort% + 6, 1
FOR Count% = 1 TO 4
   junk% = INP(BasePort% + 6)
NEXT
OUT BasePort% + 6, 0
IF INP(BasePort% + 14) AND &H80 = &H80 AND INP(BasePort% + 10) = &HAA THEN
   ResetDSP% = -1
ELSE
   ResetDSP% = 0
END IF
END FUNCTION

SUB SetStereo (OnOff%)
OUT BasePort% + 4, &HE
IF OnOff% THEN OUT BasePort% + 5, 2 ELSE OUT BasePort% + 5, 0
END SUB

SUB SpeakerState (OnOff%)
' Turns speaker on or off.
IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3
END SUB

FUNCTION SpeakerStatus%
OUT BasePort% + 4, &HD8
IF INP(BasePort% + 5) = &HFF THEN SpeakerStatus% = -1 ELSE SpeakerStatus% = 0
END FUNCTION

SUB VocVolume (Right%, Left%, Getvol%)
OUT BasePort% + 4, &H4
IF Getvol% THEN
   Left% = INP(BasePort% + 5) \ 16
   Right% = INP(BasePort% + 5) AND &HF
   EXIT SUB
ELSE
   OUT BasePort% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB WriteDAC (byte%)
' Writes a byte to the DAC.
WriteDSP &H10
WriteDSP byte%
END SUB

SUB WriteDSP (byte%)
' Writes a byte to the DSP
DO
LOOP WHILE INP(BasePort% + 12) AND &H80
OUT BasePort% + 12, byte%
END SUB
<PAGEEND:"Music.File">

<PAGESTART:"Music.File1">
'Some time ago somebody posted here (or alt.basic) a program which
'played  Ding.WAV in QuickBASIC. Didn't work for bigger files than
'DING and didn't work at all in QBasic. Here's a fix. Plays the
'biggest WAV file I have (almost 2MB) in QBasic.

'------------------------------------------------------
DECLARE SUB SetVoice (OnOff%)
  CLS
 VocFile$ = "c:\windows\ding.wav"       ' input-file

'NB a WAV file on CD. Almost 2Mb.

  VocFile% = FREEFILE
  delay% = 11                      ' value for delay
 OPEN VocFile$ FOR BINARY AS #VocFile%
 Bytes& = LOF(VocFile%)          ' number of bytes
 BytesRemaining& = Bytes&        ' number of remaining bytes
 BufferMax% = 19000             ' largest buffer

'The maximum buffer size in QBasic is about 19K.
' in QB45 this can be at least &H7F00 bytes (over 32K).
 
  Buffer$ = SPACE$(BufferMax%)    ' create buffer
  SetVoice 1                      ' Soundblaster on

  DO
     BytesRemaining& = BytesRemaining& - BufferLen%
     IF BytesRemaining& = 0 THEN EXIT DO ' nothing left over?
     IF BytesRemaining& > BufferMax% THEN ' how many bytes?
        BufferLen% = BufferMax%          '
     ELSE
        BufferLen% = BytesRemaining&     ' remaining (<BufferMax%)..
        'Buffer$ = SPACE$(BufferLen%)     ' ..throw it into SB :-)

'NB line remmed out - works OK without it.
    
     END IF

     GET #VocFile%, , Buffer$            ' read buffer
     DEF SEG = VARSEG(Buffer$)           ' get address of buffer
     Voff& = SADD(Buffer$)               ' .

'NB Voff% changed to Voff& throughout 
    
     FOR t% = 1 TO BufferLen%            ' output od {bufferlen%}
         'FOR qq% = 1 TO Delay: NEXT qq% ' delay
         WAIT &H22C, &H80, &HFF         ' wait for data-ready
         OUT &H22C, &H10
         WAIT &H22C, &H80, &HFF
         OUT &H22C, PEEK(Voff&)
         Voff& = Voff& + 1
     NEXT t%

  LOOP WHILE INKEY$ = ""

  SetVoice 0                            ' SB off
  CLOSE #VocFile%                       ' close file
  END                                   ' .. good bye :-)
'--------------------------------------------------------
'Apologies to whoever devised this that I have forgotton his name.
'If anybody can figure out how to avoid the occasional hiccup as, I
'guess, the buffer is filled, I would be pleased to hear of it.

'--
'Best wishes,
'Mervyn Baldwin.
'vyn@abaldwin.demon.co.uk

SUB SetVoice (OnOff%)
    IF OnOff% THEN
       WAIT &H22C, &H80, &HFF       ' wait for data-ready on SB
       OUT &H22C, &HD1              ' ON
    ELSE
       WAIT &H22C, &H80, &HFF
       OUT &H22C, &HD3              ' OFF
    END IF
END SUB
<PAGEEND:"Music.File1">

<PAGESTART:"CRC.File">
DECLARE FUNCTION CRC16& (Block$)
DECLARE FUNCTION CRC32& (Block$)

CLS

'simple usage.
PRINT "CRC16 is:", CRC16&("Now is the Time")
PRINT "CRC32 is:", CRC32&("Now is the Time")
DEFINT A-Z

DEFSNG A-Z

DEFINT A-Z
FUNCTION CRC16& (B$)      'Calculates CRC for Each Block

DIM Power(0 TO 7)                              'For the 8 Powers of 2
DIM CRC AS LONG

FOR I = 0 TO 7                                 'Calculate Once Per Block to
   Power(I) = 2 ^ I                            ' Increase Speed Within FOR J
NEXT I                                         ' Loop
CRC = 0                                        'Reset for Each Text Block
FOR I = 1 TO LEN(B$)                           'Calculate for Length of Block
   ByteVal = ASC(MID$(B$, I, 1))
   FOR J = 7 TO 0 STEP -1
      TestBit = ((CRC AND 32768) = 32768) XOR ((ByteVal AND Power(J)) = Power(J))
      CRC = ((CRC AND 32767&) * 2&)
      IF TestBit THEN CRC = CRC XOR &H1021     ' <-- This for 16 Bit CRC
   NEXT J
NEXT I
CRC16& = CRC                               'Return the Word Value
END FUNCTION

DEFSNG A-Z
FUNCTION CRC32& (B$)      'Calculates CRC for Each Block

DIM Power(0 TO 7)                              'For the 8 Powers of 2
DIM CRC AS LONG

FOR I = 0 TO 7                                 'Calculate Once Per Block to
   Power(I) = 2 ^ I                            ' Increase Speed Within FOR J
NEXT I                                         ' Loop
CRC = 0                                        'Reset for Each Text Block
FOR I = 1 TO LEN(B$)                           'Calculate for Length of Block
   ByteVal = ASC(MID$(B$, I, 1))
   FOR J = 7 TO 0 STEP -1
      TestBit = ((CRC AND 32768) = 32768) XOR ((ByteVal AND Power(J)) = Power(J))
      CRC = ((CRC AND 32767&) * 2&)
      IF TestBit THEN CRC = CRC XOR &H8005     ' <-- This for 32 Bit CRC
   NEXT J
NEXT I
CRC32& = CRC                               'Return the Word Value
END FUNCTION
<PAGEEND:"CRC.File">

<PAGESTART:"CTRL.BREAK.File">
'<PRE>
'QBasic NoBreak v1.0a
'Copyright (c)1995 by Daniel Trimble
'Public Domain - use at your own risk.

CLS
DO
   KEY 15, CHR$(4 + 128 + 32 + 64) + CHR$(70)
   ON KEY(15) GOSUB NoBreak: KEY(15) ON
 
   'Key 16 is assigned the value CHR$(4 + 128) + CHR$(70) which is the actual
   'CTRL + BREAK key
   KEY 16, CHR$(4 + 128) + CHR$(70): ON KEY(16) GOSUB NoBreak: KEY(16) ON
  
   KEY 17, CHR$(4 + 128 + 32) + CHR$(70): ON KEY(17) GOSUB NoBreak
   KEY(17) ON: KEY 18, CHR$(4 + 128 + 64) + CHR$(70): ON KEY(18) GOSUB NoBreak
   KEY(18) ON: KEY 19, CHR$(4) + CHR$(70): ON KEY(21) GOSUB NoBreak
   KEY(21) ON: KEY 22, CHR$(4 + 64) + CHR$(70)
   ON KEY(22) GOSUB NoBreak: KEY(22) ON: KEY 23, CHR$(4 + 32) + CHR$(46)
   ON KEY(23) GOSUB NoBreak: KEY(23) ON: KEY 24, CHR$(4 + 64) + CHR$(46)
   ON KEY(24) GOSUB NoBreak: KEY(24) ON
   KEY 25, CHR$(4 + 32 + 64) + CHR$(46): ON KEY(25) GOSUB NoBreak: KEY(25) ON
  
   LOCATE 1, 1, 0: PRINT "QBasic NoBreak v1.0a"
   LOCATE 2, 1, 0: PRINT "Copyright (c)1995 by Daniel Trimble"
   LOCATE 4, 1, 0: PRINT "This program and all source is public domain.  I will not be held responsible"
   LOCATE 5, 1, 0: PRINT "for any damage this program may cause.  I am not at fault; use this at your"
   LOCATE 6, 1, 0: PRINT "own risk - period!"
   LOCATE 15, 1, 0: PRINT "Try pressing either CTRL-BREAK or CTRL-C.  Nothing will happen!"
   LOCATE 16, 1, 0: PRINT "To end the program, hit ENTER."
   IF INKEY$ = CHR$(13) THEN END
LOOP

NoBreak:
'Insert some code here which will run when user presses CTRL + BREAK
RETURN
                                                           
'ctrl = 4          extended keys = 128
'num lock = 32      c = 46
'cap lock = 64
<PAGEEND:"CTRL.BREAK.File">

<PAGESTART:"Files.Array.File1">
'DIR.BAS by Dave Cleary
'
'One of the most useful additions to BASIC 7 PDS is the DIR$ function.
'This function allows you to read a directory of filenames. It also
'allows you to check the existence of a file by doing the following:
'
'  IF LEN(DIR$("COMMAND.COM")) THEN
'     PRINT "File Found"
'  ELSE
'     PRINT "File not found"
'  END IF
'
'Now QuickBASIC 4.X users can have this useful function for their
'programs.
'
'Calling DIR$ with a FileSpec$ returns the the name of the FIRST
'matching file name. Subsequent calls with a null FileSpec$ return the
'NEXT matching file name. If a null string is returned, then no more
'matching files were found. FileSpec$ can contain both a drive and a
'path plus DOS wildcards. Special care should be taken when using
'this on floppy drives because there is no check to see if the drive
'is ready.

DEFINT A-Z

DECLARE FUNCTION DIR$ (FileSpec$)

'$INCLUDE: 'QB.BI'

'-----  Some constants that DIR$ uses
CONST DOS = &H21
CONST SetDTA = &H1A00, FindFirst = &H4E00, FindNext = &H4F00

'--------------------------------------------------------------------
'This shows how to call DIR$ to find all matching files

CLS
FileSpec$ = "C:\*.*"
Found$ = DIR$(FileSpec$)
DO WHILE LEN(Found$)
   PRINT Found$
   Found$ = DIR$("")
LOOP

'--------------------------------------------------------------------

FUNCTION DIR$ (FileSpec$) STATIC

   DIM DTA AS STRING * 44, Regs AS RegTypeX
   Null$ = CHR$(0)

'-----  Set up our own DTA so we don't destroy COMMAND$
   Regs.AX = SetDTA                    'Set DTA function
   Regs.DX = VARPTR(DTA)               'DS:DX points to our DTA
   Regs.DS = -1                        'Use current value for DS
   InterruptX DOS, Regs, Regs          'Do the interrupt

'-----  Check to see if this is First or Next
   IF LEN(FileSpec$) THEN              'FileSpec$ isn't null, so
							    'FindFirst
	 FileSpecZ$ = FileSpec$ + Null$   'Make FileSpec$ into an ASCIIZ
							    'string
	 Regs.AX = FindFirst              'Perform a FindFirst
	 Regs.CX = 0                      'Only look for normal files
	 Regs.DX = SADD(FileSpecZ$)       'DS:DX points to ASCIIZ file
	 Regs.DS = -1                     'Use current DS
   ELSE                                'We have a null FileSpec$,
	 Regs.AX = FindNext               'so FindNext
   END IF

   InterruptX DOS, Regs, Regs          'Do the interrupt

'-----  Return file name or null
   IF Regs.Flags AND 1 THEN            'No files found
	 DIR$ = ""                        'Return null string
   ELSE
	 Null = INSTR(31, DTA, Null$)     'Get the filename found
	 DIR$ = MID$(DTA, 31, Null - 30)  'It's an ASCIIZ string starting
   END IF                              'at offset 30 of the DTA

END FUNCTION
<PAGEEND:"Files.Array.File1">

<PAGESTART:"Files.Array.File2">
'BASDir version 1.0b -- directory scan
'Copyright (c)1995-6 Mark K. Kim
'E-mail: MarkKKim@aol.com
'http://users.aol.com/markkkim/
'* Freely distributed.  May be used in other programs with proper notice of
'  credit.
'* This program is provided "as-is".
'* Not compatible with PowerBASIC.
'* In QuickBASIC 4.x, QuickBASIC PDS, and VisualBASIC for DOS, run with the
'  "/L" option.  If including a file with ABSOLUTE SUB declaration (such as
'  QB.BI), then replace the ABSOLUTE SUB declaration in that file with the
'  ABSOLUTE SUB declaration within this program. Make other proper revisions.
'* CREDIT: Ralf Brown's interrupt list was used to get interrupt for the
'  function.  Microsoft DOS's Debug was used to convert Assembly code to
'  machine code.  Microsoft is a Registered Trademark of Microsoft Corp.
'  Thanks to beta testers, rt911@aol.com and wildgamer@aol.com
'Read the header of each function to find out the usage of those functions.
'These functions are designed to work with most other routines as it does
'not interfere with any other routines. It is especially designed to work
'with other functions in this BASxx series.

DECLARE SUB absolute (var1%, var2%, var3%, var4%, var5%, var6%, offset%)
'== BEGIN HEADER ==
TYPE FileStruct
  attrib AS INTEGER
  filedate AS STRING * 10
  filetime AS STRING * 8
  filesize AS DOUBLE
END TYPE
CONST F.NOR = &H200  'constant for "normal" files (*files* displayed with DIR)
CONST F.NON = &H100  'constant for files without any attribute
CONST F.ARC = &H20   'constant for archive file attribute
CONST F.DIR = &H10   'constant for directory file attribute
CONST F.VOL = &H8    'constant for volume file attribute
CONST F.SYS = &H4    'constant for system file attribute
CONST F.HID = &H2    'constant for hidden file attribute (may return directory)
CONST F.RDO = &H1    'constant for read-only file attribute
CONST F.ANY = &H0    'constant for any of the above
DECLARE SUB dir.init (path$, attrib%)         'call first to initialize
DECLARE FUNCTION dir.find$ ()                 'call next to get filenames
DECLARE SUB dir.fileinfo (file AS FileStruct) 'call to get file information
'== END HEADER ==

'== START ==
CLS
INPUT "drive and/or directory to scan (ie - C:\DOS\): ", dir$
IF dir$ = "" THEN dir$ = "."
IF RIGHT$(dir$, 1) <> "\" THEN dir$ = dir$ + "\"
dir$ = dir$ + "*.*"
dir.init dir$, F.ANY
DIM info AS FileStruct
DO
  i% = i% + 1
  filename$ = dir.find$
  dir.fileinfo info
  IF filename$ <> "" THEN
    PRINT USING "\          \"; filename$;
    PRINT USING " #########"; info.filesize;
    PRINT "   " + info.filedate$ + " " + info.filetime$;
    PRINT " ";
  ELSE EXIT DO
  END IF
  IF info.attrib AND F.ARC THEN PRINT "A";
  IF info.attrib AND F.DIR THEN PRINT "D";
  IF info.attrib AND F.VOL THEN PRINT "V";
  IF info.attrib AND F.SYS THEN PRINT "S";
  IF info.attrib AND F.HID THEN PRINT "H";
  IF info.attrib AND F.RDO THEN PRINT "R";
  PRINT
LOOP

'Finds the detailed information about the most recently obtained file by
'the <dir.find$> function.
'INPUT & RETURN:
'* file is a FileTruct TYPE to store the information in, where the following
'  are returned:
'  * file.attrib holds the attribute of the file, or the error code if any
'    error has occured during the last <dir.find$> FUNCTION operation, where
'    the error codes are:
'    * &h02 = file not found
'    * &h03 = path not found
'    * &h12 = no more files
'    Whether an error has occured or not can be determined by checking the
'    name of the file returned -- if the name has no length (""), then an
'    error has occured (or no more files were to be found.)
'  * file.filedate$ holds the date of the file creation/revision.
'  * file.filetime$ holds the time of the file creation/revision.
'  * file.filesize$ holds the size of the file.
'    Size of a file may be a negative number of the file is several hundred
'    megabytes long, but a chance of that happening is miniscuously small.
'EXAMPLE:
'  'Make a place to store detailed information about the file.
'  DIM fileinfo AS FileStruct
'  'initialize and set pattern for the file search
'  dir.init "C:\DOS\*.*", F.ANY
'  'get the file name and store information in <fileinfo> SUB
'  filename$ = dir.find$
'  'get the detailed information from <dir.fileinfo> SUB
'  dir.fileinfo fileinfo
'  'print the information to the screen
'  PRINT "File name: "; dir.find$
'  PRINT "File date: "; fileinfo.filedate$
'  PRINT "File time: "; fileinfo.filetime$
'  PRINT "File size: "; fileinfo.filesize
'  PRINT "File attributes:"
'  IF fileinfo.attrib AND F.DIR THEN PRINT "Directory"
'  IF fileinfo.attrib AND F.HID THEN PRINT "Hidden"
'  IF fileinfo.attrib AND F.VOL THEN PRINT "Volume Label"
'  IF fileinfo.attrib AND F.ARC THEN PRINT "Archive"
'  IF fileinfo.attrib AND F.SYS THEN PRINT "System"
'  IF fileinfo.attrib AND F.RDO THEN PRINT "Read-Only"
'  END
SUB dir.fileinfo (file AS FileStruct)
 
  '== SHARED VARIABLE ==
  SHARED dirfileinfo AS FileStruct

  file = dirfileinfo

END SUB

'Scans for files in a directory
'RETURN:
'* Name of the file/directory is returned.
'* A string with nothing in it ("") will be returned upon error. Error codes
'  are obtainable through <dir.fileinfo> SUB's attribute.
'* Returned error codes (returned by <dir.fileinfo> SUB):
'  * &h02 = file not found
'  * &h03 = path not found
'  * &h12 = no more files
'COMMENT:
'* If dir.find$ is called again, the name of the next file is returned. The
'  user can look for files in a different directory or attributes can restart
'  the search by calling on <dir.init> function again.
'* Details of the found file can be obtained by calling on <dir.fileinfo> SUB
'  right after finding the file.
'EXAMPLE:
'* There is an example on top of <dir.fileinfo> in commented form.
FUNCTION dir.find$
 
  '== SHARED VARIABLES ==
  'general
  SHARED dirfileinfo AS FileStruct
  SHARED dircount AS INTEGER
  'control variables
  SHARED dir.attrib AS INTEGER
  SHARED dir.path AS STRING
  'machine language routines
  SHARED DTAseg AS INTEGER, DTAoff AS INTEGER
  SHARED findfirst$
  SHARED findnext$

  IF dircount = -1 THEN
    pathseg% = VARSEG(dir.path)
    pathoff% = SADD(dir.path)
    asmseg% = VARSEG(findfirst$)
    asmoff% = SADD(findfirst$)
    DEF SEG = asmseg%
    CALL absolute(dummy%, dummy%, dummy%, pathseg%, pathoff%, &HFF, asmoff%)
    DEF SEG
    dircount = 0
  ELSEIF dircount = 0 THEN pathseg% = 1 'simulate error
  ELSE
    pathseg% = VARSEG(dir.path)
    pathoff% = SADD(dir.path)
    asmseg% = VARSEG(findnext$)
    asmoff% = SADD(findnext$)
    DEF SEG = asmseg%
    CALL absolute(dummy%, dummy%, dummy%, dummy%, pathseg%, pathoff%, asmoff%)
    DEF SEG
  END IF
  'check for errors
  IF pathseg% THEN  'error existance is returned through pathseg%
    dir.find$ = ""
    dirfileinfo.attrib = pathoff% 'error code is stored in pathoff%
    dirfileinfo.filedate = "00-00-0000"
    dirfileinfo.filetime = "00:00:00"
  ELSE

    DO
      'get attribute of the file found
      DEF SEG = DTAseg
      attrib% = PEEK(DTAoff + &H15)
      DEF SEG
      'exit conditions:
      IF ((dir.attrib AND &H200) = &H200) AND ((attrib% AND &H21) = (attrib% AND &H3F)) THEN EXIT DO
      IF ((dir.attrib AND &H100) = &H100) AND ((attrib% AND &H3F) = 0) THEN EXIT DO
      IF (dir.attrib AND &H3F) AND (attrib% AND &H3F) THEN EXIT DO
      IF (dir.attrib AND &H3F) = 0 THEN EXIT DO
      'find next until right attributes are found
      pathseg% = VARSEG(dir.path)
      pathoff% = SADD(dir.path)
      asmseg% = VARSEG(findnext$)
      asmoff% = SADD(findnext$)
      DEF SEG = asmseg%
      CALL absolute(dummy%, dummy%, dummy%, dummy%, pathseg%, pathoff%, asmoff%)
      DEF SEG
      IF pathseg% THEN  'error existance is returned through pathseg%
        dir.find$ = ""
        dirfileinfo.attrib = pathoff% 'error code is stored in pathoff%
        dirfileinfo.filedate = "00-00-000"
        dirfileinfo.filetime = "00:00:00"
        EXIT FUNCTION
      END IF
    LOOP

    'get name of the file found
    filename$ = SPACE$(13)
    FOR i% = 0 TO 12
      DEF SEG = DTAseg
      ch% = PEEK(DTAoff + &H1E + i%)
      DEF SEG = VARSEG(filename$)
      POKE SADD(filename$) + i%, ch%
      DEF SEG
    NEXT i%
    'find location of CHR$(0) and get only up to that point
    dir.find$ = LEFT$(filename$, INSTR(filename$, CHR$(0)))

    'get attribute of the file found
    DEF SEG = DTAseg
    dirfileinfo.attrib = PEEK(DTAoff + &H15)
    DEF SEG

    'get the file's date
    DEF SEG = DTAseg
    filedate& = (PEEK(DTAoff + &H19) AND &H7F) * &H100 + PEEK(DTAoff + &H18)
     IF (PEEK(DTAoff + &H19) AND &H80) THEN filedate& = filedate& OR &H8000
    fileyear$ = LTRIM$(STR$((filedate& AND &HFE00) / &H200 + 1980))
    filemonth$ = LTRIM$(STR$((filedate& AND &H1E0) / &H20))
     IF LEN(filemonth$) < 2 THEN filemonth$ = "0" + filemonth$  'align
    fileday$ = LTRIM$(STR$(filedate& AND &H1F))
     IF LEN(fileday$) < 2 THEN fileday$ = "0" + fileday$        'align
    DEF SEG
    dirfileinfo.filedate$ = filemonth$ + "-" + fileday$ + "-" + fileyear$

    'get the file's time
    DEF SEG = DTAseg
    filetime& = (PEEK(DTAoff + &H17) AND &H7F) * &H100 + PEEK(DTAoff + &H16)
     IF (PEEK(DTAoff + &H17) AND &H80) THEN filetime& = filetime& OR &H8000
    filehour& = (filetime& AND &H7800) / &H800
     IF (filetime& AND &H8000) THEN filehour& = filehour& OR &H10
    filehour$ = LTRIM$(STR$(filehour&))
     IF LEN(filehour$) < 2 THEN filehour$ = "0" + filehour$     'align
    filemin$ = LTRIM$(STR$((filetime& AND &H7E0) / &H20))
     IF LEN(filemin$) < 2 THEN filemin$ = "0" + filemin$        'align
    filesec$ = LTRIM$(STR$((filetime& AND &H1F) * 2))
     IF LEN(filesec$) < 2 THEN filesec$ = "0" + filesec$        'align
    DEF SEG
    dirfileinfo.filetime$ = filehour$ + ":" + filemin$ + ":" + filesec$

    'get filesize
    DEF SEG = DTAseg
    filesize& = (PEEK(DTAoff + &H1D) AND &H7F) * &H1000000
    filesize& = filesize& + PEEK(DTAoff + &H1C) * &H10000
    filesize& = filesize& + PEEK(DTAoff + &H1B) * &H100&
    filesize& = filesize& + PEEK(DTAoff + &H1A) * &H1
    IF (PEEK(DTAoff + &H1D) AND &H80) THEN filesize& = filesize& OR &H8000
    dirfileinfo.filesize = filesize&
    DEF SEG
  END IF

  dircount = dircount + 1
END FUNCTION

'Initializes the "dir" family functions (dir.init, dir.find$, dir.fileinfo)
'COMMENT:
'* This function is also used to "reset" the search "patterns" used by
'  <dir.find$>.
'INPUT:
'* path.o$ is the file parameter to scan for. Wildcards okay.
'* attrib.o% is the attribute to look for, where:
'  * &h200 is for "normal" files that are displayed from DOS by simple "DIR"
'    command. This call is handled through the function.
'  * &h100 is for files without any attributes. This call is also handled
'    through the function.
'  * &h20 is for archive files. This is handled by DOS (sort of).
'  * &h10 if for directories. This is also handled by DOS (once again, sort
'    of).
'  * &h8 is for file that stands for the volume label. This could be used on
'    the root directory of each drive to find out the name of the drive, but
'    the information may not always be accurate in that there is a second
'    copy of volume label in the boot sector which is the "real thing". The
'    file with the volume attribute is sort of like "shadow" of the real
'    thing. However, any major or proper program will modify both volume
'    labels.
'  * &h4 is for files with system attribute. Handled by DOS. System files
'    also appear to be hidden.
'  * &h2 is for files with hidden attribute. Handled by DOS.
'  * &h1 is for read-only files. Handled by DOS.
'  * &h0 is for any of the above files. Handled by the function.
'  Combination of these attributes can be made (ie - &h06 for hidden system
'    files.)
'  When a file name is returned through <dir.find$> function, file with ANY
'    of the above specs will be returned. For instance, if the user specifies
'    a hidden file, a file with hidden attribute AND any other ones will be
'    returned. (That's why I made the "normal" attribute)
'EXAMPLE:
'* There is an example on top of <dir.fileinfo> in commented form.
SUB dir.init (path.o$, attrib.o%)

  '== SHARED VARIABLES ==
  'general
  SHARED dirfileinfo AS FileStruct
  SHARED dircount AS INTEGER
  'control variables
  SHARED dir.attrib AS INTEGER
  SHARED dir.path AS STRING
  'machine language routines
  SHARED DTAseg AS INTEGER, DTAoff AS INTEGER
  SHARED findfirst$
  SHARED findnext$

  '== INITIALIZATION ==
  dircount = -1
  dir.attrib = attrib.o%
  dir.path = path.o$ + CHR$(0)

  '== get DTA address ==
  'initialize machine language code to get DTA address
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                           'push bp          DTA
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)              'mov bp, sp       DTA
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H2F)              'mov ah, 2f       DTA
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)              'int 21           DTA
  asm$ = asm$ + CHR$(&H89) + CHR$(&HD8)              'mov ax, bx       DTA
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)  'mov bx, [bp+08]  DTA
  asm$ = asm$ + CHR$(&H8C) + CHR$(&H7)               'mov [bx], es     DTA
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)  'mov bx, [bp+06]  DTA
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)               'mov [bx], ax     DTA
  asm$ = asm$ + CHR$(&H5D)                           'pop bp           DTA
  asm$ = asm$ + CHR$(&HCA) + CHR$(&HC) + CHR$(&H0)   'retf 000C        DTA
  'get segment and offsets
  asmseg% = VARSEG(asm$)
  asmoff% = SADD(asm$)
  'execute
  DEF SEG = asmseg%
  CALL absolute(dummy%, dummy%, dummy%, dummy%, DTAseg, DTAoff, asmoff%)
  DEF SEG

  '== FIND FIRST ==
  'initialize machine language code
  findfirst$ = ""
  findfirst$ = findfirst$ + CHR$(&H55)                           'push bp          F1st
  findfirst$ = findfirst$ + CHR$(&H89) + CHR$(&HE5)              'mov bp, sp       F1st
  findfirst$ = findfirst$ + CHR$(&HB4) + CHR$(&H4E)              'mov ah, 4e       F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)  'mov bx, [bp+0a]  F1st
  findfirst$ = findfirst$ + CHR$(&H8E) + CHR$(&H1F)              'mov ds, [bx]     F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)  'mov bx, [bp+08]  F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H17)              'mov dx, [bx]     F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)  'mov bx, [bp+06]  F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&HF)               'mov cx, [bx]     F1st
  findfirst$ = findfirst$ + CHR$(&HCD) + CHR$(&H21)              'int 21           F1st
  findfirst$ = findfirst$ + CHR$(&HB9) + CHR$(&H0) + CHR$(&H0)   'mov cx, 0000     F1st
  findfirst$ = findfirst$ + CHR$(&H80) + CHR$(&HD1) + CHR$(&H0)  'adc cl, 00       F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)  'mov bx, [bp+0a]  F1st
  findfirst$ = findfirst$ + CHR$(&H89) + CHR$(&HF)               'mov [bx], cx     F1st
  findfirst$ = findfirst$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)  'mov bx, [bp+08]  F1st
  findfirst$ = findfirst$ + CHR$(&H89) + CHR$(&H7)               'mov [bx], ax     F1st
  findfirst$ = findfirst$ + CHR$(&H5D)                           'pop bp           F1st
  findfirst$ = findfirst$ + CHR$(&HCA) + CHR$(&HC) + CHR$(&H0)   'retf 000C        F1st

  '== FIND NEXT ==
  'initialize machine language code
  findnext$ = ""
  findnext$ = findnext$ + CHR$(&H55)                           'push bp          FNxt
  findnext$ = findnext$ + CHR$(&H89) + CHR$(&HE5)              'mov bp, sp       FNxt
  findnext$ = findnext$ + CHR$(&HB4) + CHR$(&H4F)              'mov ah, 4f       FNxt
  findnext$ = findnext$ + CHR$(&HCD) + CHR$(&H21)              'int 21           FNxt
  findnext$ = findnext$ + CHR$(&HB9) + CHR$(&H0) + CHR$(&H0)   'mov cx, 0000     FNxt
  findnext$ = findnext$ + CHR$(&H80) + CHR$(&HD1) + CHR$(&H0)  'adc cl, 00       FNxt
  findnext$ = findnext$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)  'mov bx, [bp+08]  FNxt
  findnext$ = findnext$ + CHR$(&H89) + CHR$(&HF)               'mov [bx], cx     FNxt
  findnext$ = findnext$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)  'mov bx, [bp+06]  FNxt
  findnext$ = findnext$ + CHR$(&H89) + CHR$(&H7)               'mov [bx], ax     FNxt
  findnext$ = findnext$ + CHR$(&H5D)                           'pop bp           FNxt
  findnext$ = findnext$ + CHR$(&HCA) + CHR$(&HC) + CHR$(&H0)   'retf 000C        FNxt

END SUB
<PAGEEND:"Files.Array.File2">

<PAGESTART:"Files.Exist.File1">
' >    5) Procedures must be bulletproof.
' >       FUNCTION Exist - Returns true if file is present.
'
' Sounds like some interesting challenges, but it struck me as
' odd, you want to see "bulletproof" routines, which I take to
' mean as routines that do a lot of error-checking, yet your
' Exist function could be shot full of holes, to continue the
' metaphor, fairly easily. Here's something I whipped up from my
' own Exist function, I bulletproofed and commented it as heavily
' as I could. 

 DECLARE FUNCTION Exist% (seed$, SearchAttrb%)
 DECLARE FUNCTION floppyDriveReady% (drive$)

 TYPE regtype             ' Also found in QB.BI
   ax AS INTEGER
   bx AS INTEGER
   cx AS INTEGER
   dx AS INTEGER
   bp AS INTEGER
   si AS INTEGER
   di AS INTEGER
  flags AS INTEGER
   ds AS INTEGER
   es AS INTEGER
 END TYPE

 TYPE DTAdata                     'used by DOS services
   Reserved  AS STRING * 21       'reserved for use by DOS
   Attribute AS STRING * 1        'the file's attribute
   FileTime  AS STRING * 2        'the file's time
   Filedate  AS STRING * 2        'the file's date
   FileSize  AS LONG              'the file's size
   filename  AS STRING * 13       'the file's name
 END TYPE

 END

 DEFINT A-Z
 FUNCTION Exist% (Name$, SearchAttrb%)

 ' Format:
 ' EXIST Name$, SearchAttrb%
 ' Name$ can be any valid DOS filename, directory name, or volume label.
 '     wildcards (* and ?) are accepted.
 ' Attrb% can be the following:
 '     0 == Test for any file
 '    39 == Test for any file
 '    16 == Test for Directory names ONLY
 '     8 == Test for Volume labels ONLY
 '     4 == Test for System files ONLY
 '     2 == Test for Hidden files ONLY
 '     1 == Test for Read-Only files ONLY
 '    63 == Test for anything file/label/directory
 '
 '  Combinations can be made (ie. search for Read-only
 '  Directories) by following this binary number bit chart:
 '     Bit 7  Shareable (Novell Netware, otherwise ignore)
 '     Bit 6  unused
 '     Bit 5  archive
 '     bit 4  Directory
 '     Bit 3  Volume Label
 '     Bit 2  system
 '     Bit 1  Hidden
 '     Bit 0  Read only
 '  for example a Read-only Directory would be bits 0 and 4,
 '  in binary numbers that's: 10001 or 17 decimal.

 ' If the tested for item exists Exist% will be set to -1, true
 '    and SearchAttrb% can be ignored

 ' If the tested for item does not exist, or there is an error,
 ' Exist% will be set to 0, false, and SearchAttrb% will be set
 ' to one of the following:
 '    -1 == Floppy drive not ready or invalid drive letter.
 '     0 == item does not exist.

 DIM inreg AS regtype, outreg AS regtype
 DIM DTA AS DTAdata

 seed$ = LTRIM$(RTRIM$(UCASE$(Name$)))

 IF SearchAttrb% AND 8 THEN  ' Volume label check
   ' Volume Label searches need to have a "." for the
   ' ninth character if the label is >8 characters.
   ' The following assures a correct search

   IF NOT (INSTR(seed$, ".")) THEN

     ' step backwards through the string

     FOR I = LEN(seed$) TO 1 STEP -1

       ' look for end of string, or drive/directory marker

       IF MID$(seed$, I, 1) = ":" OR MID$(seed$, I, 1) = "\" OR I = 1 THEN

         ' I points to start of name, without drive/directory
         ' marker, see if "." is required

         IF LEN(MID$(seed$, I + 1, LEN(seed$) - I)) > 8 THEN

           ' if no drive/directory, then we're checking the
           ' default drive, in this case I must equal 0 to
           ' place the "." correctly.

           IF I = 1 THEN I = 0

           ' place the "."

           seed$ = LEFT$(seed$, I) + MID$(seed$, I + 1, 8) + "." + MID$(seed$, I + 9, LEN(seed$) - I)
         END IF
         I = 1  ' exit the next loop
       END IF
     NEXT I
   END IF
 END IF

 IF SearchAttrb% = 0 THEN SearchAttrb% = 39  ' default search

 ' if there's a drive in the search string
 IF INSTR(seed$, ":") THEN
   drive$ = LEFT$(seed$, 1)   ' gets the drive
 ELSE
   drive$ = "@"               ' for default drive
 END IF

 ' if it's a floppy drive we need to make sure a disk
 ' is in the drive.
 IF NOT floppyDriveReady(drive$) THEN
   SearchAttrb% = -1   ' Floppy not ready.
   Exist% = 0
   EXIT FUNCTION
 END IF

 inreg.dx = VARPTR(DTA)      'set a new DOS DTA
 inreg.ds = VARSEG(DTA)
 inreg.ax = &H1A00
 CALL interruptx(&H21, inreg, outreg)

 seed$ = seed$ + CHR$(0)     'DOS needs ASCIIZ string
 inreg.ax = &H4E00           'find file name service
 inreg.cx = SearchAttrb%
 inreg.dx = SADD(seed$)      'show where the spec is
 inreg.ds = VARSEG(seed$)    'use this with QB - SSEG for PDS(?)
 CALL interruptx(&H21, inreg, outreg)

 IF (outreg.flags AND 1) THEN
   SearchAttrb% = 0          ' Item does not exist
   Exist% = 0
 ELSE
   Exist% = -1               ' item exists
 END IF

 END FUNCTION

 DEFINT A-Z
 FUNCTION floppyDriveReady% (drive$)
 DIM inreg AS regtype, outreg AS regtype

 ' This function may also be used independently from
 ' the Exist% function. It returns -1, true if the
 ' drive is ready, or 0, false, if the drive is not
 ' ready, or the drive letter is an invalid drive.

 drive% = (ASC(drive$) OR 32) - 97

 'reset floppy drive
 inreg.ax = 0
 inreg.dx = drive%
 CALL interruptx(&H13, inreg, outreg)

 inreg.ax = &H401     'verify disk sector
 inreg.cx = &H101
 inreg.dx = drive%
 CALL interruptx(&H13, inreg, inreg)
 'call the interrupt twice since if a disk has just been
 'inserted, the first time gives a wrong answer
 inreg.ax = &H401
 inreg.cx = &H101
 inreg.dx = drive%
 CALL interruptx(&H13, inreg, outreg)

 'if it was a hard disk we just checked forget the whole thing
 IF outreg.ax AND 256 THEN
   inreg.ax = &H1C00      ' check drive type
   inreg.dx = drive% + 1  ' diff. drive number system must add 1
   CALL interruptx(&H21, inreg, outreg)
   ' check if drive was a valid drive letter.
   IF (outreg.ax AND &HFF) = &HFF THEN HardCheck = 0 ELSE HardCheck = -1
 END IF

 floppyDriveReady% = ((outreg.flags AND 1) = 0) OR HardCheck

 END FUNCTION
<PAGEEND:"Files.Exist.File1">

<PAGESTART:"Drives.Array.File">

DEFINT A-Z

CONST FALSE = 0, TRUE = NOT FALSE

'$INCLUDE: 'qb.bi'      'qbx.bi for PDS

'Use /L option in QuickBASIC

DIM SHARED Regs AS RegType

DECLARE FUNCTION GetDrives$ ()

CLS
PRINT GetDrives$

DEFSNG A-Z
FUNCTION GetDrives$
'-------------------------------------------------------------------
' Returns a string of uppercase characters of all installed
' drives. Does NOT take DOS SUBST command into account.
' Use LEN() to determine number of drives after FUNCTION call.
'-------------------------------------------------------------------

        Regs.ax = &H1900                    'Save current drive first
        CALL INTERRUPT(&H21, Regs, Regs)    'Assign ah and call DOS
        CurDrv% = Regs.ax AND 255           'Read al

        NextDrv% = CurDrv%

        DO
                NextDrv% = NextDrv% + 1          'Increment to the next drive
                Regs.dx = NextDrv%               'Assign dl the next drive
                Regs.ax = &HE00                  'Try to set it as current, so
                CALL INTERRUPT(&H21, Regs, Regs) 'assign ah and call DOS

                                'Now, let's see if it worked
                Regs.ax = &H1900                 'Assign ah and call DOS to
                CALL INTERRUPT(&H21, Regs, Regs) 'see the real current drive
                Rc% = Regs.ax AND 255            'Read al for current drive

        LOOP WHILE Rc% = NextDrv%           '& continue while they match

        Regs.ax = &HE00                     'Reset the current drive
        Regs.dx = CurDrv%
        CALL INTERRUPT(&H21, Regs, Regs)

        NumDrives% = Rc% + 1                'Mumber of drives, 1-based

        Regs.ax = 0                         'Find # of floppies, since
        CALL INTERRUPT(&H11, Regs, Regs)    'DOS reports "phantom" drives
        Floppies% = ((Regs.ax AND 192) \ 64) + 1

                                'Decrement if only 1 floppy
        NumDrives% = NumDrives% + (Floppies% = 1)

        REDIM Drives$(1 TO NumDrives% + 1)  'Now, assign the drives array

        FOR X% = 1 TO NumDrives%
                Y% = Y% + 1
                IF X% = 2 AND Floppies% = 1 THEN Y% = Y% + 1
                Temp$ = Temp$ + CHR$(Y% + 64)    'Assign the characters
        NEXT

        GetDrives$ = Temp$                  'Assign the function

END FUNCTION
<PAGEEND:"Drives.Array.File">

<PAGESTART:"Drive.Space.File">
DECLARE FUNCTION DiskFree& (drive$)

TYPE RegType
        ax      AS INTEGER
        bx      AS INTEGER
        cx      AS INTEGER
        dx      AS INTEGER
        bp      AS INTEGER
        si      AS INTEGER
        di      AS INTEGER
        flags   AS INTEGER
END TYPE

DECLARE SUB INTERRUPT (IntNo AS INTEGER, InRegs AS RegType, Outregs AS RegType)

        CLS
        PRINT "Type in a drive letter"
        drive$ = INPUT$(1)
        PRINT "The number of bytes free on drive "; drive$; " are: ", DiskFree&(drive$);
END

FUNCTION DiskFree& (drive$)

   DIM InRegs AS RegType, Outregs AS RegType

   DiskFree& = -1
   IF LEN(drive$) <> 1 THEN EXIT FUNCTION

   InRegs.ax = &H3600
   InRegs.dx = ASC(UCASE$(drive$)) - ASC("A") + 1
   CALL INTERRUPT(&H21, InRegs, Outregs)
   IF Outregs.ax = -1 THEN EXIT FUNCTION

   Temp& = Outregs.ax
   DiskFree& = Temp& * Outregs.bx * Outregs.cx

END FUNCTION
<PAGEEND:"Drive.Space.File">

<PAGESTART:"Drive.Type.File">
 'No checking for open drive doors on this:

'$INCLUDE: 'qb.bi'

DEFINT A-Z    'Dick Dennison 1/93 1:272/34 PD
DIM regs AS regtypex    'Does not test for open floppy door

regs.ax = &H1C00                       'ah=1c al=00

regs.dx = 0                            '0=default, 1=a:,2=b:,etc

CALL interruptx(&H21, regs, regs)      'use dos
DEF SEG = regs.ds                      'change to returned segment
MediaByte = PEEK(regs.bx)              'Get the byte
DEF SEG                                'get back to basic's segment

IF (regs.ax AND 255) <> &HFF THEN

        SELECT CASE HEX$(MediaByte)
                CASE "F0"
                        MediaType$ = "3.5 inch DS, 18 sectors or other"
                CASE "F8"
                        MediaType$ = "Fixed Disk"
                CASE "F9"
                        MediaType$ = "5.25 in DS, 15 sects or 3.5 in DS, 9 sects"
                CASE "FC"
                        MediaType$ = "5.25 inch SS, 9 sectors"
                CASE "FD"
                        MediaType$ = "5.25 inch DS, 9 sectors"
                CASE "FE"
                        MediaType$ = "5.25 inch SS, 8 sectors"
                CASE "FF"
                        MediaType$ = "5.25 inch DS, 8 sectors"
                CASE ELSE
                        MediaType$ = "Unknown Type"
END SELECT
PRINT "Media ID Byte : "; HEX$(MediaByte); " = "; MediaType$
ELSE
PRINT "Error encountered (invalid drive or critical error)"
END IF
END
<PAGEEND:"Drive.Type.File">

<PAGESTART:"Drive.Total.File">
'BASDriveSpace version 1.0a -- Find free and total space on a drive
'Copyright (c)1995-6 Mark K. Kim
'E-mail: MarkKKim@aol.com
'http://users.aol.com/markkkim/
'* Freely distributed.  May be used in other programs with proper notice of
'  credit.
'* This program is provided "as-is".
'* Not compatible with PowerBASIC.
'* In QuickBASIC 4.5, run QB.EXE with /L option. If including QB.BI, then
'  replace the ABSOLUTE SUB declaration statement in QB.BI with the ABSOLUTE
'  SUB declaration within this program. Make other proper revisions.
'* CREDIT: Ralf Brown's interrupt list was used to get interrupt for the
'  function.  Microsoft DOS's Debug was used to convert Assembly code to
'  machine code.  Microsoft is a Registered Trademark of Microsoft Corp.
'  Thanks to beta testers, rt911@aol.com and wildgamer@aol.com
'Read the header of each function to find out the usage of those functions.
'These functions are designed to work with most other routines as it does
'not interfere with any other routines. It is especially designed to work
'with other functions in this BASxx series.

DECLARE SUB absolute (var1%, var2%, var3%, var4%, var5%, var6%, offset%)
'== BEGIN HEADER ==
DECLARE FUNCTION drv.freespace# (drive$)
DECLARE FUNCTION drv.totalspace# (drive$)
'== END HEADER ==


'== START ==

CLS
INPUT "Enter of the drive to find free and total spaces: ", drive$
freespace = drv.freespace(drive$)
IF freespace = -1 THEN
  PRINT "Error during free space calculation!"
  PRINT "Terminating program...."
  END
END IF
totalspace = drv.totalspace(drive$)
IF totalspace = -1 THEN
  PRINT "Error during total space calculation!"
  PRINT "Terminating program...."
  END
END IF
PRINT "The free space on "; LEFT$(drive$, 1); " is:";
 PRINT USING " ###############"; freespace;
 PRINT " bytes."
PRINT "The total space on "; LEFT$(drive$, 1); " is:";
 PRINT USING "###############"; totalspace;
 PRINT " bytes."
END

'Finds out the available free space of a drive in bytes.
'INPUT:
' Drive$ is the letter representation of the drive one wants to find out the
'  free space of.  If its length is zero, it is assumed to be the current
'  drive.  No space must come in front of the string (ie - " A:\" is not a
'  valid string)
'RETURN ON SUCCESS:
' The free space of the drive
'RETURN ON ERROR:
' -1 is returned on any type of error.  Such errors include non-alphabetic
'  drive letters and no such drive error
'COMMENT:
' Lost clusters are assumed to be in use
FUNCTION drv.freespace# (drive$)
  'convert drive letter to corresponding letter
  driveseg% = VARSEG(drive$)  'get drive$'s segment
  driveoff% = SADD(drive$)    'get drive$'s offset
  DEF SEG = driveseg%         'define segment
  drive% = PEEK(driveoff%)    'get ASCII equivalent of first letter of drive$
  DEF SEG
  IF drive$ = "" THEN         'if length of drive$ is zero, use default drive
    drive% = 0  'default drive
  ELSEIF drive% >= ASC("A") AND drive% <= ASC("Z") THEN
    drive% = drive% - 64
  ELSEIF drive% >= ASC("a") AND drive% <= ASC("z") THEN
    drive% = drive% - 96
  ELSE                        'if nothing fits, exit with error code (-1)
    drv.freespace = -1
    EXIT FUNCTION
  END IF

  'store machine code
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                              'push bp
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                 'mov bp, sp
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)     'mov bx, [bp+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                 'mov dx, [bx]
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H36)                 'mov ah, 36h
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                 'int 21h
  asm$ = asm$ + CHR$(&H53)                              'push bx
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)     'mov bx, [bp+0c]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                  'mov [bx], ax
  asm$ = asm$ + CHR$(&H58)                              'pop ax
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)     'mov bx, [bp+0a]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                  'mov [bx], ax
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)     'mov bx, [bp+08]
  asm$ = asm$ + CHR$(&H89) + CHR$(&HF)                  'mov [bx], cx
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)     'mov bx, [bp+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H17)                 'mov [bx], dx
  asm$ = asm$ + CHR$(&H5D)                              'pop bp
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H8) + CHR$(&H0)      'retf 0008h

  'execute
  asmseg% = VARSEG(asm$)      'get segment of stored machine codes
  asmoff% = SADD(asm$)        'get offset of stored machine codes
  DEF SEG = asmseg%           'define segment
  dx% = drive%                'transfer data from drive% to dx%
  CALL absolute(var1%, var2%, ax%, bx%, cx%, dx%, asmoff%) 'execute
  DEF SEG
  'if invalid drive
  IF ax% = &HFFFF THEN drv.freespace = -1: EXIT FUNCTION

  'convert integers to long integers (because of sign problems)
  ax& = ax% AND &H7FFF                            'ax = sectors per cluster
  IF (ax% AND &H8000) THEN ax& = (ax& OR &H8000&)
  bx& = bx% AND &H7FFF                            'bx = number of free clstrs
  IF (bx% AND &H8000) THEN bx& = (bx& OR &H8000&)
  cx& = cx% AND &H7FFF                            'cx = bytes per sector
  IF (cx% AND &H8000) THEN cx& = (cx& OR &H8000&)
  dx& = dx% AND &H7FFF                            'dx = total clusters
  IF (dx% AND &H8000) THEN dx& = (dx& OR &H8000&)

  'calculate free space and return
  drv.freespace# = 1# * ax& * bx& * cx& '(1# is for typecasting just in case)
END FUNCTION

'Finds out the total space of a drive in bytes.
'INPUT:
' Drive$ is the letter representation of the drive one wants to find out the
'  total space of.  If its length is zero, it is assumed to be the current
'  drive.  No space must come in front of the string (ie - " A:\" is not a
'  valid string)
'RETURN ON SUCCESS:
' The total space of the drive
'RETURN ON ERROR:
' -1 is returned on any type of error.  Such errors include non-alphabetic
'  drive letters and no such drive error)
FUNCTION drv.totalspace# (drive$)
  'convert drive letter to corresponding letter
  driveseg% = VARSEG(drive$)  'get drive$'s segment
  driveoff% = SADD(drive$)    'get drive$'s offset
  DEF SEG = driveseg%         'define segment
  drive% = PEEK(driveoff%)    'get ASCII equivalent of first letter of drive$
  DEF SEG
  IF drive$ = "" THEN         'if length of drive$ is zero, use default drive
    drive% = 0  'default drive
  ELSEIF drive% >= ASC("A") AND drive% <= ASC("Z") THEN
    drive% = drive% - 64
  ELSEIF drive% >= ASC("a") AND drive% <= ASC("z") THEN
    drive% = drive% - 96
  ELSE                        'if nothing fits, exit with error code (-1)
    drv.totalspace = -1
    EXIT FUNCTION
  END IF

  'store machine code
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                              'push bp
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                 'mov bp, sp
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)     'mov bx, [bp+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                 'mov dx, [bx]
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H36)                 'mov ah, 36h
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                 'int 21h
  asm$ = asm$ + CHR$(&H53)                              'push bx
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)     'mov bx, [bp+0c]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                  'mov [bx], ax
  asm$ = asm$ + CHR$(&H58)                              'pop ax
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)     'mov bx, [bp+0a]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                  'mov [bx], ax
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)     'mov bx, [bp+08]
  asm$ = asm$ + CHR$(&H89) + CHR$(&HF)                  'mov [bx], cx
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)     'mov bx, [bp+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H17)                 'mov [bx], dx
  asm$ = asm$ + CHR$(&H5D)                              'pop bp
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H8) + CHR$(&H0)      'retf 0008h

  'execute
  asmseg% = VARSEG(asm$)      'get segment of stored machine codes
  asmoff% = SADD(asm$)        'get offset of stored machine codes
  DEF SEG = asmseg%           'define segment
  dx% = drive%                'transfer data from drive% to dx%
  CALL absolute(var1%, var2%, ax%, bx%, cx%, dx%, asmoff%) 'execute
  DEF SEG
  'if invalid drive
  IF ax% = &HFFFF THEN drv.totalspace = -1: EXIT FUNCTION

  'convert integers to long integers (because of sign problems)
  ax& = ax% AND &H7FFF                            'ax = sectors per cluster
  IF (ax% AND &H8000) THEN ax& = (ax& OR &H8000&)
  bx& = bx% AND &H7FFF                            'bx = number of free clstrs
  IF (bx% AND &H8000) THEN bx& = (bx& OR &H8000&)
  cx& = cx% AND &H7FFF                            'cx = bytes per sector
  IF (cx% AND &H8000) THEN cx& = (cx& OR &H8000&)
  dx& = dx% AND &H7FFF                            'dx = total clusters
  IF (dx% AND &H8000) THEN dx& = (dx& OR &H8000&)

  'calculate total space and return
  drv.totalspace# = 1# * ax& * cx& * dx& '(1# is for typecasting just in case)
END FUNCTION
<PAGEEND:"Drive.Total.File">

<PAGESTART:"Disk.Serial.File">
 DEFINT A-Z
 ' Purpose: To change the serial number on any DOS disk.
 ' WARNING THE FOLLOWING PROGRAM USES DIRECT DISK WRITES!
 ' by Andy Thomas 9/93
 ' Author not responsible for misuse or errors of any kind.
 ' Use of this program could, but should not, damage your disk
 ' or render data unusable.
 '$INCLUDE: 'QB.BI'
 ' QB must be started with the /L switch!
 DIM inreg AS RegTypeX, outreg AS RegTypeX
 CLS
 TYPE DiskPacketType
   Sector AS LONG         ' DWORD - starting sector number
   CountWrite AS INTEGER  ' WORD - Number of sectors affected
   TransAddres AS STRING * 4 ' DWORD - Location of data transfer
                             '         Address
 END TYPE
 ' Note: Sector is a LONG while TransAddres is a string
 ' because we know Sector is going to be zero for this program.
 ' In other uses Sector would need to be made a string to avoid
 ' QuickBasic OVERFLOW errors.

 DIM DiskPacket AS DiskPacketType ' Disk Write Packet
 DIM DataStorage AS STRING * 512  ' string to read/write sector

 PRINT "Place disk in drive."   ' get drive to change
 PRINT "Enter drive letter:";
 DO
   Drive$ = UCASE$(INKEY$)
 LOOP UNTIL Drive$ <> ""
 PRINT Drive$
 PRINT

 DriveNumb = ASC(Drive$) - 65  ' drive number: A:=0, B:=1....
 inreg.cx = &HFFFF             ' Read/Write Absolute Sector
 inreg.ax = DriveNumb          ' Drive id
 DiskPacket.Sector = 0         ' start at sector 0
 DiskPacket.CountWrite = 1     ' load one sector

 'DWORD -- Seg:Off of DataStorage
 DiskPacket.TransAddres = CHR$(VARPTR(DataStorage) AND &HFF) +_
  CHR$(((VARPTR(DataStorage) AND &HFF00) \ 256) AND &HFF) +_
  CHR$((VARSEG(DataStorage) AND &HFF)) +_
  CHR$(((VARSEG(DataStorage) AND &HFF00) \ 256) AND &HFF)

 inreg.ds = VARSEG(DiskPacket)  ' DS:BX = Disk write packet
 inreg.bx = VARPTR(DiskPacket)

 CALL INTERRUPTX(&H25, inreg, outreg) ' read disk sector

 ' Get serial number from boot sector
 FOR I = &H2B TO &H28 STEP -1
   OldSerial$ = OldSerial$ + HEX$(ASC(MID$(DataStorage, I, 1)))
   IF LEN(OldSerial$) = 4 THEN OldSerial$ = OldSerial$ + "-"
 NEXT I

 PRINT "      Old serial number:"; OldSerial$
 LOCATE 5, 1
 PRINT "Enter new serial Number:"

 ' get user input for new serial number
 ' making sure only a valid serial number is entered
 Ptr = 0
 DashAdj = 0
 DO
   DO
     A$ = UCASE$(INKEY$)
   LOOP UNTIL (INSTR("0123456789ABCDEF" + CHR$(8), A$) > 0) AND_
  A$ <> ""
   IF A$ = CHR$(8) THEN    ' backspace for corrections
     IF Ptr > 0 THEN
       Ptr = Ptr - 1
       NewSerial$ = LEFT$(NewSerial$, Ptr)
     ELSE
       NewSerial$ = ""
     END IF
   ELSE
     Ptr = Ptr + 1
     NewSerial$ = NewSerial$ + A$
   END IF
   LOCATE 5, 25
   PRINT "         "

   LOCATE 5, 25
   PRINT LEFT$(NewSerial$, 4)
   IF Ptr > 4 THEN
     LOCATE 5, 29
     PRINT "-" + MID$(NewSerial$, 5, 8)
   END IF
 LOOP UNTIL Ptr = 8
 Ptr = 0

 ' Convert NewSerial$ into numerical ASCII codes
 ' and save within DataStorage
 FOR I = &H2B TO &H28 STEP -1
   Sbyte = 0
   FOR J = 1 TO 2
     A$ = MID$(NewSerial$, J + Ptr, 1)
     IF ASC(A$) > 64 AND ASC(A$) < 71 THEN Adj = 55 ELSE Adj= 48
     Sbyte = (Sbyte * 16) + (ASC(A$) - Adj)
   NEXT J
   DEF SEG = VARSEG(DataStorage)
   POKE VARPTR(DataStorage) + I - 1, Sbyte
   Ptr = Ptr + 2
 NEXT I

 ' Check to make sure new serial number was placed in
 ' correct location (this is a redundant check for safety)
 FOR I = &H2B TO &H28 STEP -1
   ChkSerial$ = ChkSerial$ + HEX$(ASC(MID$(DataStorage, I, 1)))
   IF LEN(ChkSerial$) = 4 THEN ChkSerial$ = ChkSerial$ + "-"
 NEXT I

 ' confirm change
 PRINT
 PRINT "                disk:"; Drive$
 PRINT "  from serial number:"; OldSerial$
 PRINT "to new serial number:"; ChkSerial$
 PRINT "Confirm change: (Y/N)"
 DO
   A$ = UCASE$(INKEY$)
 LOOP UNTIL A$ = "Y" OR A$ = "N"
 IF A$ = "Y" THEN ' make the change
   DiskPacket.TransAddres = CHR$(VARPTR(DataStorage) AND &HFF) +_
  CHR$(((VARPTR(DataStorage) AND &HFF00) \ 256) AND &HFF) +_
  CHR$((VARSEG(DataStorage) AND &HFF)) +_
  CHR$(((VARSEG(DataStorage) AND &HFF00) \ 256) AND &HFF)

   inreg.ds = VARSEG(DiskPacket)  ' DS:BX = Disk write packet
   inreg.bx = VARPTR(DiskPacket)

   CALL INTERRUPTX(&H26, inreg, outreg) ' write disk sector
 ELSE
   PRINT "Change Aborted."
 END IF

 END

 ' Methodology: The disk serial number is stored as a Double
 ' Word in the boot sector (sector zero) of every disk at
 ' location 27h. This program reads sector zero into a string,
 ' changes the dword value at offset 27h and writes the changed
 ' data back to sector zero. While this program should work, and
 ' has been tested on both hard drives and floppy disks, I
 ' suggest it only be used on floppy drives, as a error
 ' occurring while writing to sector zero on the hard drive
 ' could be disastrous.
<PAGEEND:"Disk.Serial.File">

<PAGESTART:"Disk.Volume.File">
' VOLUME.BAS    Gets and/or Sets the disk volume label using DOS
'               Extended File Control Block (FCB) services. This
'               works with all MS-DOS versions from 2.0 up.
'
'Note that, while the ReadLabel routine will find the volume label from
'whichever subdirectory you happen to be in, the MakeLabel routine only
'works from the root directory of the drive you're relabelling.
'
'
'   Author:     Christy Gemmell
'   Date:       19/5/1992
'
'   $DYNAMIC
'
'   $INCLUDE: 'QB.BI'                       ' Use QBX.BI for PDS
'
        DECLARE SUB MakeLabel (Drive$, Label$)
        DECLARE SUB ReadLabel (Drive$, Label$)

        CONST FALSE = 0, TRUE = NOT FALSE

   TYPE XFCBType
        XFlag AS STRING * 1                 ' Extended FCB signature
        Rsrv1 AS STRING * 5                 ' Reserved (do not use)
        Attr  AS STRING * 1                 ' File attribute
        Drive AS STRING * 1                 ' Drive number
        FName AS STRING * 11                ' Filename
        Rsrv2 AS STRING * 5                 ' Reserved (do not use)
        NName AS STRING * 11                ' Replacement name
        Rsrv3 AS STRING * 9                 ' Reserved (do not use)
    END TYPE

        DIM SHARED FCB AS XFCBType              ' File Control Block
        DIM SHARED InRegs AS RegTypeX           ' Register structures
        DIM SHARED OutRegs AS RegTypeX          '   for interrupt calls

DIM SHARED DTA AS STRING * 64           ' Disk Transfer Area

        LSET FCB.XFlag = CHR$(255)              ' Flag as Extended FCB
        LSET FCB.Rsrv1 = STRING$(5, 0)          ' Fill with nulls

'   Example program to test it all out.
'
        CLS
        Drive$ = "A:": Label$ = ""
        ReadLabel Drive$, Label$
        LOCATE 10, 1: PRINT "Current Label = "; Label$
        Label$ = "DidItWork"
        MakeLabel Drive$, Label$
        LOCATE 12, 1: PRINT "New Label     = "; Label$
        END

'   Creates or changes the volume label of the drive specified
'
SUB MakeLabel (Drive$, Label$) STATIC
    NewLabel$ = Label$                      ' Preserve new label
    ReadLabel Drive$, Label$                ' Search for current label
    IF Label$ = "" THEN                     ' If no label found
        LSET FCB.FName = NewLabel$           '    Set new label
        InRegs.ds = VARSEG(FCB)              '    Segment and offset of
        InRegs.dx = VARPTR(FCB)              '      our File Control Block
        InRegs.ax = &H1600                   '    Create file
        INTERRUPTX &H21, InRegs, OutRegs     '    Call DOS
        InRegs.ax = &H1000                   '    Close file
        INTERRUPTX &H21, InRegs, OutRegs     '    Call DOS
    ELSE                                    ' Otherwise
        LSET FCB.FName = Label$              '    Set current label
        LSET FCB.NName = NewLabel$           '    Set replacement label
        InRegs.ds = VARSEG(FCB)              '    Segment and offset of
        InRegs.dx = VARPTR(FCB)              '      our File Control Block
        InRegs.ax = &H1700                   '    Rename file
        INTERRUPTX &H21, InRegs, OutRegs     '    Call DOS
    END IF
    Label$ = ""                             ' Check to see
    ReadLabel Drive$, Label$                '    if it worked
END SUB

'   Reads the volume label of the drive specified.
'
SUB ReadLabel (Drive$, Label$) STATIC
    InRegs.ax = &H2F00                      ' Get current DTA
    INTERRUPTX &H21, InRegs, OutRegs        ' Call DOS
    DTASeg% = OutRegs.es                    ' Store DTA segment
    DTAOff% = OutRegs.bx                    ' Store DTA offset
    InRegs.ds = VARSEG(DTA)                 ' Replace with
    InRegs.dx = VARPTR(DTA)                 '    our own temporary
    InRegs.ax = &H1A00                      '    Disk Transfer Area
    INTERRUPTX &H21, InRegs, OutRegs        ' Call DOS
    IF Drive$ = "" THEN                     ' If no drive
        Disk% = 0                            '    letter is supplied
    ELSE                                    '    use current drive
        Disk% = ASC(UCASE$(Drive$)) - 64     '    otherwise convert
    END IF                                  '    letter to numeral
    LSET FCB.Drive = CHR$(Disk%)            ' Drive to search
    LSET FCB.Attr = CHR$(8)                 ' Specify Volume label
    LSET FCB.FName = "???????????"          ' Use wildcards for search
    InRegs.ds = VARSEG(FCB)                 ' Segment and offset of
    InRegs.dx = VARPTR(FCB)                 '    our File Control Block
    InRegs.ax = &H1100                      ' Find first match
    INTERRUPTX &H21, InRegs, OutRegs        ' Call DOS
    IF OutRegs.ax MOD 256 = &HFF THEN       ' If a label wasn't found
        Label$ = ""                          '    return a null string
    ELSE                                    '    otherwise
               Label$ = MID$(DTA, 9, 11)            '    extract it from
    END IF                                  '    our DTA
    InRegs.ds = DTASeg%                     ' Restore
    InRegs.dx = DTAOff%                     '    original
    InRegs.ax = &H1A00                      '    Disk Transfer Area
    INTERRUPTX &H21, InRegs, OutRegs        ' Call DOS
END SUB
<PAGEEND:"Disk.Volume.File">

<PAGESTART:"Poke.Peek.File">
                   *  * * POKES & PEEKS * * *

     Did you know that there is a lot of information that may be 
accessed from the ROM BIOS area in your IBM PC regarding the operating 
characteristics and options found on your own IBM PC?  After careful 
analysis of data found in the IBM Technical Reference manual a summary 
of the most useful information and where and how it may be referenced 
has been prepared.  
     By specifying a DEF SEG=&H40 in any BASIC program, it is possible 
to reference the following vectors (fields) in the ROM BIOS area by 
using a PEEK function and the following offsets from the current 
segment as defined by the DEF SEG statement.  

     &H0 - RS232 Addresses on your IBM PC.  This will allow you to 
tell how many (up to four) async cards are attached, if any.  

     &H8 -  Printer Addresses on your IBM PC.  This will tell you what 
printer addresses, and how many (up to four) exist.  Each is addressed 
by a two-byte hex value.

     &H10 - Equipment Flag.  This field describes the setting of the 
options switches.  It describes what optional devices are attached to 
the system.  The following lists the bit-significance of this field: 

          Bit 0 - indicates that there are disk drives on the system  
          Bit 1 - not used  
          Bit 2,3 - Planar Ram Size (00=16K 10=32K 01=48K 11=64K) 
          Bit 4,5 - Initial Video Mode (00=Unused; 10=40x25 Color 
                    01=80x25 Color 1; 1=80x25 Mono) 
          Bit 6,7 - Number of Disk Drives (00=1; 10=2; 01=3; 11=4 
                    only if bit 0 = 1)
          Bit 8 -  Unused
          Bit 9,10,11 - Number of RS232 Cards attached 
          Bit 12 - Game I/O Attached 
          Bit 13 - Not used  
          Bit 14,15 - Number of printers attached 

     &H13 - Memory Size in K bytes

     &H15 - I/O RAM Size in K bytes

     &H17 - Keyboard Flag.  The following lists the masks set to 
            describe current keyboard status: 

          Byte 1:
               &H80 - Insert state active  
               &H40 - CapsLock state has been toggled 
               &H20 - NumLock state has been toggled 
               &H10 - ScrollLock state has been toggled  
               &H08 - Alternate shift key depressed 
               &H04 - Control shift key depressed 
               &H02 - Left shift key depressed 
               &H01 - Right shift key depressed 
          Byte 2:
               &H80 - Insert key is depressed 
               &H40 - CapsLock key is depressed  
               &H20 - NumLock key is depressed  
               &H10 - ScrollLock key is depressed 
               &H08 - Suspend key has been toggled 
               &H49 - Current CRT mode &H00 - 40x25 BW  
               &H01 - 40x25  Color  
               &H02 - 80x25  BW  
               &H03 - 80x25  Color 
               &H04 - 320x200 Color 
               &H05 - 320x200 BW 
               &H06 - 640x200 BW 
               &H07 - 80x25 B&W Card -- speS)CG\+MF;uuse, used internal 
               to the video routines.   
               &H4A - Number of CRT columns 
               &H50 - Cursor Position (one of eight)
               &H60 - Current cursor mode  
               &H6C - Low word of Timer count 
               &H6E - High word of Timer count
               &H71 - &H07 - Break key de8gIae--UROeTBHg
               44E - Beginning of character regen memory  
               &HFF53 - PrtSc routine address  

-----------------------------------------------------------------
                   PEEKing at Your PC's Memory
  (PC Magazine Vol 4 No 23 Nov 12, 1985 by David I. Schneider)

     Would you like to know the next number that will be generated by
BASIC's random number generator?  Would you like to know the date 1,000
days from now?  Would you like to determine which of your printers is
on-line?  Or have six palettes at your disposal in medium-resolution
graphics mode instead of the normal two?

     These and many more tasks are easily accomplished by PEEKing
(looking into a memory location), POKEing (placing a number into a
memory location), INPing (reading a number from a port), or OUTing
(sending a number to a port).  This article attempts to give a thorough
documentation of the varied uses of these statements.  While the
explanations are in BASIC, most of the information is applicable to
every programming language.

- - - - -
Before You Start:  Before entering and executing any of the PEEK and
POKE statements in this article, be sure this statement is executed
first:  DEF SEG = 0.  PC Magazine tried the PEEKs and POKEs in this
article on standard IBM equipment, and they worked flawlessly.
However, since they bypass many built-in safeguards to work directly
with your system's memory, playing with them carelessly or on non-IBM
equipment is like playing with fire, so type them in carefully, observe
the proper DEF SEG, and don't try any variations unless you know what
you're doing.
- - - - -

     PEEKs, POKEs, INPs and OUTs reveal the inner workings of the
computer and thus give the programmer direct control.  IBM discourages
the use of PEEK, POKE, INP and OUT, however, since the company cannot
guarantee that future releases of DOS or future ROM chips will use the
current memory locations.  Also, ports associated with nonstandard
hardware might function in different ways.  To be safe, widely
distributed and commercial programs should avoid such undocumented
features.  On the other hand, IBM has been quite consistent so far.
Most of the memory locations and ports presented in this article hold
for all existing versions of DOS and BASIC.  Of course, this might
change with some future release.

     Theoretically, the IBM PC can directly address 1048576 memory
locations, numbered 0 through 1048575.  Normally, a maximum of 640K
locations of RAM is available for user programs.  The remainder
consists of ROM or is otherwise reserved for present or future system
applications.

     A segment is a 64K portion of memory beginning at a location that
is a multiple of 16.  Segment 0 consists of memory locations 0, 1, 2,
3, ...65535.  Segment 1 consists of memory locations 16, 17, 18, ...
65551.  Segment 2 consists of memory locations 32, 33, 34, ...65567.
In general, then, segment m consists of memory locations 16*m, 16*m+1,
16*m+2, ...16*m+65535.

     Within each segment, the first memory location is said to have
offset 0, the second memory location is at offset 1, and so forth;
the last memory location is said to have an offset of 65535.  Memory
locations are specified by giving a segment that contains the location,
together with the offset of that location within the segment.  Most
memory locations can thus be specified in many ways.  For instance,
the designations "segment 0:offset 34," "segment 1:offset 18," and
"segment 2:offset 2" actually refer to the same memory location.

     Each memory location holds a number from 0 to 255.  These numbers
are often called bytes.  In BASIC (either in immediate mode or in a
program), to read the number in the memory location segment m:offset n,
you execute:  DEF SEG = m : PRINT PEEK (n).  The DEF SEG statement
specifies the mth segment as the current segment, and the value of
PEEK(n) is the number contained in the memory location of offset n
in the current segment.  In a similar way, to insert the number r
into the memory location segment m:offset n, you execute:  DEG SEG =
m : POKE n,r.  This POKE statement places the number r into the
memory location of offset n in the mth segment.

     The PC's microprocessor receives data from and sends data to the
various components of the computer through ports.  There are ports
associated with the keyboard, the disk drives, the speaker, and the
screen, for example.  A byte of data consists of a number from 0 to
255, and each port has a number assigned to it.  The value of the
function INP(n) is the value of the byte read from port n.  The
statement OUT n,m sends byte m to port n.

     The listings presented here deal with memory locations in
segment 0, which is often referred to as low memory.  The program,
LOMEMRY.BAS, illustrates many of the applications.

     Two important procedural considerations must be stressed if you
intend to enter the listings from the keyboard to try them out.  First,
the statement:  DEF SEG = 0  should be executed before the PEEK and
POKE statements in this section are executed.  Second, to prevent a
Syntax Error message, remember to type PRINT before each of the PEEK
statements, so the result will be displayed on the screen.  The words
AND and OR in these listings are logical operators and do not mean
"the sum of" or "an alternative to."

                            KEYBOARD

     1.  The following statements are used to set or determine the
status of the keyboard toggle keys.

     CapsLock Key:  "PEEK (1047) AND 64" has a value of 0 if the
keyboard is in lowercase mode and a value of 64 if the uppercase mode
is active.  To specify lowercase:  POKE 1047, PEEK(1047) AND 191.
To specify uppercase:  POKE 1047, PEEK(1047) OR 64.  To toggle between
upper and lowercase:  POKE 1074, PEEK(1047) XOR 64.  The statement
"PEEK(1048) AND 64" has a value of 64 if the key is pressed, 0
otherwise.

     NumLock Key:  The statement "PEEK(1047) AND 32" has a 0 value in
the cursor-control mode and a value of 32 for the numeric-keybad state.
To specify the cursor-control state:  POKE 1047,PEEK(1047) AND 223.
To specify the numeric-keypad state:  POKE 1047,PEEK(1047) OR 32.
To toggle between states:  POKE 1047,PEEK(1047) XOR 32.  The statement
"PEEK(1048) AND 32" has a value of 32 if the key is pressed and a
value of 0 otherwise.

     Ins Key:  The statement "PEEK(1047) AND 128" has a value of 128
for the insert state, 0 otherwise.  To specify the insert mode:
POKE 1047,PEEK(1047) OR 128.  To specify noninsert mode:  POKE 1047,
PEEK(1047) AND 127.  To toggle the state:  POKE 1047,PEEK(1047) XOR
128.  The statement "PEEK(1048) AND 128" has a value of 128 if the key
is pressed a a 0 value otherwise.

     ScrollLock Key:  The statement "PEEK(1047) AND 16" has a value of
16 when ScrollLock is on and a value of 0 otherwise.  To specify the
ScrollLock state:  POKE 1047,PEEK(1047) OR 16.  To specify the
alternate state:  POKE 1047,PEEK(1047) AND 239.  To toggle states:
POKE 1047,PEEK(1047) XOR 16.  The statement "PEEK(1048) AND 16" has a
value of 16 if the key is pressed a a value of 0 otherwise.

     2.  The following statements test the status of some special keys.
The statement "PEEK(1047) AND 8" has a value of 8 if the Alt key is
pressed and a value of 0 otherwise.  The statement "PEEK(1047) AND 4"
has a value of 4 if the Ctrl key is pressed, 0 otherwise.  The
statement "PEEK(1047) AND 1" has a value of 1 if the right Shift key
is pressed and a 0 value otherwise.  The statement "PEEK(1047) AND 3"
has a value of 0 if neither shift key is pressed.  The statement
"PEEK(1048) AND 4" has a value of 4 if the Sys Req key is pressed;
otherwise its value is 0 (PC AT only).

     3.  In the numeric keypad state, the character with an ASCII
value n can be displayed on the screen by holding down the Alt key,
typing the number n on the numeric keypad, and they releasing the Alt
key.  PEEK(1049) has a value of n from the time the number is typed
until the Alt key is released.

     4.  The circular keyboard buffer begins at location PEEK(1050) +
1024 and ends (possibly after cycling back to location 1054) at
location PEEK(1052)+1023.  Ordinary characters use every other
location.  Extended characters use two locations, the first location
containing the null character (CHR$(0)).  The statement "POKE 1050,
PEEK(1052)" clears the keyboard buffer.  The contents of the buffer
can be read by PEEK without first being removed from the buffer.
Further, characters can be POKEd into the buffer to ensure the
continuation of a program even if a program-terminating statement is
executed.  For instance, if the string:  "GOTO 99" + CHR$(13) is POKEd
into the buffer and a LIST command is executed, the program will
continue execution at line 99 after the LISTing has been completed,
which overcomes BASIC's annoying habit of stopping dead after certain
operations.

     5.  With PCs whose motherboard can hold 256K bytes of RAM, the
keyboard buffer can be assigned a different location and length.
The following program places the beginning of the keyboard buffer at
memory location 1024 + B and gives it the capacity of holding L
characters.

10 DEG SEG=0:H=INT(B/256)
20 POKE 1152,B-H*256:POKE 1153,H
30 T=B+2*L+2:H=INT(T/256)
40 POKE 1154,T=H*256:POKE 1155,H
50 POKE 1050,PEEK(1152):POKE 1051,PEEK(1153)
60 POKE 1052,PEEK(1152):POKE 1053,PEEK(1153)

The buffer contents always begin at:   PEEK(1050)+256*PEEK(1051)+1024
and end (possibly after cycling back from location 1085 to location
1024+B) at location:  PEEK(1052)+256*PEEK(1053)+1024.  You must use
case in choosing B and L.  Two possibilities are B=144, L<55 and
B=301,L<233.

     6.  To disable Ctrl-Break, enter:  FOR I=0 TO 3:POKE(108+I),
PEEK(112+I):NEXT I.  Before disabling Ctrl-Break, use PEEK to record
the bytes in locations 108-111.  You can then POKE these bytes back in
to reenable Ctrl-Break.

     7.  The statement "PEEK(1137) AND 128" has a the value of 128 if
the Ctrl-Break sequence has been used since startup to terminate the
execution of a program.

     8.  To disable the keyboard (PC & XT only), send "OUT 97, INP(97)
OR 128".  Remember that when the keyboard is disabled, subsequent
keystrokes are ignored.

     9.  To reenable the keyboard (PC & XT only), send "OUT 97, INP(97)
AND 127".

     10.  To disable all keyboard interrupts:  OUT 33,130.  If keys are
pressed after the interrupts are disabled, the scan codes of the first
20 keys will be held in a buffer located in the keyboard unit.  These
codes will be read after the interrupts are reenabled.

     11.  To reenable keyboard interrupts:  OUT 33,128.

     12.  Each key has an identifying number called its scan code.  The
following program will usually obtain the scan code of a key.  After
typing RUN, you must press the Enter key quickly.  They press any key
to obtain its scan code.  (The program will not work on the PC AT or
certain IBM PC-compatibles.)

10 OUT 33,130
20 WHILE INP(96)=0:WEND
30 PRINT INP(96)
40 OUT 33,128

     13.  For the PC AT only, when a key is held down for more than 1/2
second (the default delay time), it repeats ten times per second (the
default typematic rate).  To change the delay rate do d quarter-seconds
(d=1,2,3 or 4) and the typematic rate to approximately r repetitions
per second (r between 2 and 30), you would enter:  OUT 96,243:OUT 96,n
where n = (d-1) * 32 + CINT(11.5 * LOG(29/r)).  Conversely, the
statement:  OUT 96,243:OUT 96,n  with n=0,1, ...127, specifies a delay
rate of 1+(n\32) quarter seconds and a typematic rate of 1/((8+(n MOD
8))*2^((n AND 24)/8)*.00417) repetitions per second.  The default state
corresponds to n=44.

     14.  For the PC AT only, the green lights that indicate CapsLock,
NumLock and ScrollLock status can be turned on and off without
altering any of the states.  The statement:  OUT 96,237:OUT 96,n
produces the following results:

n = 7   all indicators on
n = 6   ScrollLock indicator off, others on
n = 5   NumLock indicator off, others on
n = 4   CapsLock indicator on, others off
n = 3   CapsLock indicator off, others on
n = 2   NumLock indicator on, others off
n = 1   ScrollLock indicator on, others off
n = 0   all indicators off

                         MONITOR STATUS

     1.  To check the type of display:

PEEK(1040) AND 48 = 0 is no monitors
PEEK(1040) AND 48 = 16 is a 40 x 25 graphics monitor
PEEK(1040) AND 48 = 32 is a 80 x 25 graphics monitor
PEEK(1040) AND 48 = 48 is a monochrome display

     2.  To select a display:
          Monochrome   POKE 1040,PEEK(1040) OR 48
          Graphics     POKE 1040,(PEEK(1040) AND 207) OR 16
The first POKE should be followed by:  SCREEN 0:WIDTH 40:WIDTH 80:
LOCATE ,,1,12,13.  The second should be followed by:  SCREEN 1,0,0,0:
SCREEN 0:WIDTH 40:LOCATE ,,1,7,7.  Before switching monitor types, it
is a good idea to record (in an array) the numbers that are contained
in memory locations 1097 to 1126.  These values can then be confidently
restored after the return to the first display.

     3.  To check screen mode:

PEEK(1097) = 0 text mode, WIDTH 40, color disabled
PEEK(1097) = 1 text mode, WIDTH 40, color enabled
PEEK(1097) = 2 text mode, WIDTH 80, color disabled
PEEK(1097) = 3 text mode, WIDTH 80, color enabled
PEEK(1097) = 4 medium resolution graphics, color enabled
PEEK(1097) = 5 medium resolution graphics, color disabled
PEEK(1097) = 6 high-resolution graphics
PEEK(1097) = 7 monochrome display

PEEK(1098)+256*PEEK(1099) gives the width in columns.  Color can be
suppressed only on composite monitors.  RGB monitors will display color
even if you are in one of the color-disabled modes listed above.

     4.  Subscripts and superscripts can be displayed in the top half
of the graphics screens.  The following programs place the string B$ as
a subscript of the string A$.  The value of R must be between 1 and 12,
and the value of C can be at most one more than the width of the screen
minus the sum of the lengths of the two strings.  To display B$ as a
superscript of A$, replace the R in line 40 by R-1.

10 SCREEN 1:CLS                         10 SCREEN 2:CLS
20 LOCATE R,C:PRINT A$;                 20 LOCATE R,C:PRINT A$;
30 POKE 1098,20                         30 POKE 1098,40
40 LOCATE 2*R:PRINT B$                  40 LOCATE 2*R:PRINT B$
50 POKE 1098,40                         50 POKE 1098,80

     5.  The contents of the graphics screen are stored in a buffer
beginning at offset:  PEEK(1102)+256*PEEK(1103)  in a portion of
memory that physically resides on a graphics board.  The size of this
buffer is given by:  PEEK(1100)+256*PEEK(1101)

     6.  When using text mode with a graphics monitor, there are
several memory pages at your disposal.  The cursor locations for the
various pages are given as follows:  Let CR(n) and CC(n) be the Cursor
Row and Cursor Column for page n.  Then:  PEEK(1105)+2*n)  has a value
of CR(n)-1, and:  PEEK(1104+2*n)  has a value of CC(n)-1.

     7.  The shape of the cursor can be set with a statement of the
form:  LOCATE ,,,I,J.  In this LOCATE statement, "PEEK(1121) AND 31"
has value I, and "PEEK(1120) AND 31" has value J.  If "PEEK(1121) AND
32" has a value of 32, then the cursor is not displayed.

     8.  To obtain the number of the visual page (that is, the page
currently being displayed), you simply "PEEK(1122)".

     9.  The adapter boards can be given instructions by OUTing to
ports on a chip known as the CRT controller chip.  To determine the
number of the index register port for the adapter board currently in
use, "PEEK(1123)+256*PEEK(1124)".  The value will be 948 for the
monochrome display board and 980 for the color/graphics adapter.

     10.  The following statements check the mode settings on the CRT
mode register currently in use:

PEEK(1125) AND 1    has value 1 if in text mode, width 80
PEEK(1125) AND 2    has value 2 if in graphics mode
PEEK(1125) AND 4    has value 4 if color is disabled (for instance, if
                      the statement SCREEN 1,1 has been executed)
PEEK(1125) AND 8    has value 8 if video is enabled, that is, not
                      blanked
PEEK(1125) AND 16   has value 16 if in high-resolution graphics mode
PEEK(1125) AND 32   has value 32 if blinking is enabled

     The value of PEEK(1125) will change after appropriate SCREEN or
WIDTH statements are executed.  It is not affected by OUT statements,
however.  It will not always reflect the true status of the monitor,
therefore, unless it is updated after OUTs to port 984 or 952.

     11.  In the medium-resolution graphics mode, the background color
and palette are selected by the statement COLOR b,p.  The statement
"PEEK(1126) AND 15" will have the balue b, and "(PEEK(1126) AND 32)/32"
will have the value p.  In text mode, with a color monitor, the value
of "PEEK(1126) MOD 16" will be the border color and "PEEK(1126) AND 16"
will be 16 if the current color was specified by a statement of the
form COLOR f,b in which f is 0 through 15 and b>7.

     The value of PEEK(1126) will change after appropriate SCREEN or
COLOR statements are executed.  However, it is not affected by OUT
statements.  Therefore, it will not always reflect the true status of
the monitor unless it is updated after OUTs to port 985.

     12.  In graphics mode, the statement "PRINT CHR$(n)" where n is a
number from 128 to 254, causes the computer to display the character
in an 8 by 8 rectangle of pixels.  Each character is described by a
sequence of eight bytes.  The eight bytes describing CHR$(128) are
contained in the eight successive memory locations beginning with the
location at offset "PEEK(124)+256*PEEK(125)" in segment "PEEK(126)+
256*PEEK(127)".  The pattern for CHR$(129) is contained in the next
eight locations, and so on.  To create a character set for ASCII values
from 128 to 254:
          a. Select the portion of memory to hold the bytes describing
the characters.
          b. POKE the pattern for character 128 into the first eight
memory locations, the pattern for character 129 into the next eight
locations, and so on.
          c. POKE the offset and segment of the first byte into
locations 124 to 127.

     13.  The video parameter table consists of 64 bytes beginning at
memory location of offset "PEEK(116)+256*PEEK(117)" in segment
"PEEK(118)+256*PEEK(119)".  The first 16 bytes are numbers that are
OUTed to registers on the color/graphics adapter board when the 40 by
25 text mode is initialized.  The next two 16-byte sequences are
associated with the 80 by 25 text and graphics modes on the color/
graphics adapter.  The final sequence of 16 bytes is used to initialize
the monochrome display.  You must be very careful when changing these
bytes.  Certain values for the first 10 bytes in each sequence could
damage your monitor.

                             PRINTER

     1.  The number of printer adapters installed is given by "(PEEK
(1041) AND 192)/64".

     2.  To determine the first port associated with LPTn, "PEEK(1030
+2*n)+256*PEEK(1031+2*n)".  If this number is 0, then LPTn is not
available.  To swap two printers, interchange their initial port
numbers.  Denote the first port associated with LPTn by Pn.  The value
of P1 will by 956 if LPT1 is attached to the IBM monochrome display
and parallel printer adapter.

     3.  The ASCII value of the last character sent to the printer by
LPRINT or PRINT# is:  INP(Pn).

     4.  To determine printer status:  LET X = INP(Pn+1)

X AND 128   has value 128 if the printer is busy or off line
X AND 64    has value 0 if the printer has acknowledged that data has
              been sent and is ready to receive more
X AND 32    has value 32 if the printer is out of paper
X AND 16    has value 16 if the printer is on-line
X AND 8     has value 0 if there is an I/O error

     5.  To initialize the printer, send:  OUT Pn+2,8:OUT Pn+2,12

     6.  With PCs having 256K RAM motherboards, the parallel printer
timeout values can be read and set.  The timeout value for LPTn is
approximately:  1.6*PEEK(1143+n)  seconds.  To set the timeout value
for LPTn to S seconds:  POKE 1143+n,.64*S.

                           DISK DRIVES

     1.  To determine the number of diskette drives:  (PEEK(1040) AND
1)*(1+PEEK(1040)\64).

     2.  In determining the status of a drive motor:  PEEK(1087) AND
128  has a value of 128 when a disk drive is being written to, and:
PEEK(1087) AND 15  has a value of 0 when no drive motor is running.
If drive L is running, then the value of  "PEEK(1087) AND 2 ^ (ASC
("L")-65)" will be 1.  Drive L here is A, B, C or D, and the letter
must be typed in uppercase.  These value are not affected if an OUT
was used to turn on the motor.

     3.  To turn on drive L for n seconds, where n is at most 14:
POKE 1088,18.2*n:OUT 1010,2^(ASC("L")-61)+ASC("L")-53.  Location 1088
holds the countdown, in clock ticks, until the diskette motor is shut
off.

     4.  To turn off all drives, send:  OUT 1010,12

     5.  To determine the diskette track that was last accessed, use:
PEEK(1093).

     6.  To determine which diskette head (0 or 1) was last accessed,
use:  PEEK(1094).

     7.  Similarly, to determine which diskette sector was last
accessed:  PEEK(1095).  When single-sided diskettes are used, items
5, 6 and 7 above may specify the sector following the one most recently
accessed.

     8.  The number of bytes per sector on a diskette is given by:
128*2^PEEK(1096).

     9.  The diskette parameter table consists of 11 bytes.  To explore
this:  LET D = PEEK(120)+256*PEEK(121).  Then, after executing:
DEF SEG = PEEK(122)+256*PEEK(123)  you can derive the following table:

(PEEK(D) AND 240)\8     is the time (in milliseconds) required for the
                          diskette drive to move from track to track
(PEEK(D) AND 15)*32     is the head unload time (in milliseconds) after
                          a read or write operation has occurred
(PEEK(D+1) AND 240)\4   is the head load time (in milliseconds)
PEEK(D+1) AND 15        is the Direct Memory Access mode
PEEK(D+2)               is the wait time until turning the motor off
PEEK(D+3)               is the number of bytes per sector on the disk;
                          a value of v specifies 128*2^v bytes per
                          sector, for v=0 to 3
PEEK(D+4)               is the number of sectors per track, usually
                          8 or 9
PEEK(D+5)               is the gap length (in bytes) between sectors
PEEK(D+6)               is the data length that you read out or write
                          into a sector when the sector length is not
                          specified
PEEK(D+7)               is the gap length used when formatting
PEEK(D+8)               is the value the format operation uses to
                          initialize diskette sectors, usually 256
PEEK(D+9)               is the number of milliseconds allowed for the
                          heads to stabilize
PEEK(D+10)              is the number of eighths of a second to allow
                          for motor startup

Changing the values of PEEK(D+3) and PEEK(D+4) can modify the way that
diskettes are read and might require you to format your diskettes
manually.

     10.  The number of hard disks on a PC-XT can be found with:
PEEK(1141).

     11.  If a single diskette drive is used for both drives A: and
B:, its current roles is:  CHR$(65 + PEEK(1284))

                        RS-232 INTERFACE

     1.  The number of RS-232 cards attached can be found with:
(PEEK(1041) AND 14)/2

     2.  To determine the first of the seven ports associated with
COMn:  PEEK(1022+2*n)+256*PEEK(1023+2*n).  If this number is 0, then
COMn is not available.  To swap two RS-232 interfaces, interchange
their initial port numbers.  Denote the initial port associated with
COMn by Pn.  Normally, the value of P1 is 1016 and the value of P2 is
760.

     3.  Interrupt enabling:

OUT Pn+1,1   enables an interrupt when a character has been received
OUT Pn+1,2   enables an interrupt when a character has been transmitted
OUT Pn+1,4   enables an interrupt when an error has occurred
OUT Pn+1,8   enables an interrupt when the modem status has changed

To enable several of the above interrupts at the same time, OUT the
sum of the associated numbers to port Pn+1.

     4.  To identify interrupts, use the port number determined above
(Pn) and:  LET X = INP(Pn+2).  "X AND 1" has a value of 1 as long as no
interrupts have been issued because of communications port activity.
Similarly, "X AND 6" is used to identify the highest priority interrupt
pending, as indicated in the table "Interrupt Control Functions" in the
IBM Technical Reference manual.

     5.  To establish the number of data bits (d), the number of stop
bits (s), and the parity (p=0 for no parity, p=1 for odd parity, p=3
for even parity), send:  OUT Pn+3, d-5 + 4*(s-1) + 8 * p.

     6.  To establish the baud rate:  H=INP(Pn+3):OUT Pn+3,H OR 128:
OUT Pn,DL:OUT Pn+1,DH:OUT Pn+3,H.  Use values DL=128 and DH=1 for 300
baud, and DL=96 and DH=0 for baud rate 1200.  Otherwise, DL=d MOD 256
and DH=d\256, where d is the divisor number given by the IBM Technical
Reference manual in the table "Baud Rate at 1.853 MHz."

     7.  To produce a break signal:  X=INP(Pn+3):OUT Pn+3,X OR 64:PLAY
"MF":SOUND 32767,6:SOUND 32767,1:OUT Pn+3,X.  The PLAY and SOUND
statements produce a delay of 1/3 second.

     8.  To control the modem, use:

OUT Pn+4,1     to assert that the data terminal is ready (DTR)
OUT Pn+4,2     to raise a request to send (RTS)
OUT Pn+4,16    to perform loopback testing

To accomplish several of the above tasks simultaneously, OUT the sum
of the associated numbers to port Pn+4.

     9.  To determine the status of data transfer, begin with:
LET X = INP(Pn+5).  Now:

X AND 64    has a value of 64 if the transmitter shift register is idle
X AND 32    is 32 if the transmitter holding register is ready to
              accept a character for transmission
X AND 16    has the value 16 if the received data input is held in the
              spacing state too long (that is, if a break was received)
X AND 8     has the value 8 if the received character did not have a
              valid stop bit; that is, if a framing error occurred
X AND 4     has the value 4 if the received character does not have
              the correct parity
X AND 2     is 2 if the received data destroyed the previous character
              (an overrun error)
X AND 1     has value 1 if a character is ready to be read from the
              received buffer register

     10.  INP(Pn) will read the ASCII value of a character from the
serial port, provided:  (INP(Pn+5) AND 1) = 1

     11.  You can use OUT Pn,m to write the character with ASCII value
m to the serial port, provided that:  (INP(Pn+5) AND 32) = 32

     12.  To determine the status of the modem, use:  X = INP(Pn+6).
Then:

X AND 128    has the value 128 if a Carrier signal has been detected
X AND 64     is 64 if the modem is ringing
X AND 32     has a value of 32 if the modem has asserted Data Set Ready
X AND 16     is 16 if the modem has asserted Clear to Send
X AND 8      is 8 if the Carrier Detect has changed state
X AND 4      has the value 4 if the Ring Indicator input has changed
               from On to Off
X AND 2      is 2 if the Data Set Ready input has changed state since
               the last time it was read
X AND 1      has a value of 1 if the Clear to Send input has changed
               state since it was last read

                             SPEAKER

     1.  The timer chip determines the frequency of the sound produced
by the speaker.  To prepare to send a value to the timer chip, send:
OUT 67,182

     2.  The human ear can perceive sounds varying in frequency from
about 20 to 20,000 Hz.  To set the timer chip to produce a frequency
of F Hz:  A=INT(1193182/F):H=INT(a/256):L=A-H*256:OUT 66,L:OUT 66,H

     3.  To turn the speaker on, use:  OUT 97,INP(97) OR 3

     4.  Conversely, to turn the speaker off:  OUT 97,INP(97) AND 252

                      CASETTE PORT CONTROL

     1.  To turn the cassette motor on:  OUT 97,INP(97) AND 247

     2.  To turn the cassette motor off:  OUT 97,INP(97) OR 8


Even if a cassette player is not attached, toggling the cassette motor
produces a clicking sound.  Repeated togglings can produce interesting
sound effects, but since the relay involved is not designed as a
musical instrument, excessive use may cause its failure.

                          MISCELLANEOUS

     1.  The number of game adapters attached is shown with:  (PEEK
(1041) AND 16)/16

     2.  To find the size of RAM in kilobytes, use:  PEEK(1043) +
256*PEEK(1044)

     3.  The internal clock ticks 18.20648 times per second.  The
number of ticks that have occurred since midnight is given by:
PEEK(1132)+256*PEEK(1133)+65536PEEK(1134).  This value increases until
it reaches 1,533,039 (an instant before midnight), and at midnight it
is reset to 0.  The value of PEEK(1136) is increased by 1 as a result
of the reset.  Executing either TIME$ or DATE$ changes the value of
PEEK(1136) back to 0.

     To determine the date N days from now, execute:  FOR I=1 TO N:
POKE 1136,1:A$=DATE$:NEXT I:PRINT DATE$.  With versions of DOS prior
to 3.0, when N is less than 256, the entire FOR...NEXT loop can be
replaced by POKE 1136,N.

     4.  Memory locations 1264 to 1279 are not used by either DOS or
BASIC.  Data can be passed from one program to another by POKEing it
into these locations and PEEKing it later.

     5.  To exit BASIC and complicate reinvoking it, you can:  POKE
1295,2:SYSTEM.  Memory location 1295 is set to 2 when the BASIC
command SHELL is executed.

     6.  The segment number of BASIC's data segment may be found with:
PEEK(1296)+256*PEEK(1297)

     7.  To disable the nth interrupt:  POKE n*4,83:POKE n*4+1,255:
POKE n*4+2,0:POKE n*4+3,240.  Prior to executing these statements, use
PEEK to record the contents of the four memory locations.  To reenable
the interrupt, use POKE to restore these locations to their original
state.

     This part of the article is divided into sections that each deal
with the memory locations found in a specified, common segment.  When
typing in the applications that follow, you must be careful to execute
the proper DEF SEG statement for each section and to preface each PEEK
with a PRINT statement.  The three programs, DEMO1.BAS, DEMO2.BAS and
DEMO3.BAS illustrate many of these applications.

                      BASIC's Data Segment

Prefix with DEF SEG unless otherwise noted


     The segment of memory that is allocated to BASIC is referred to as
BASIC's Data Segment.  When BASIC is first invoked, it is the current
segment.  Also, the BASIC statement DEF SEG, when used without any
additional address, specifies this memory segment.  BASIC's Data
Segment is partitioned into seven regions.  The first of these is the
interpreter work area; the remaining six regions will be referred to
as BASIC's storage area.

A. Interpreter Work Area

     In the following discussion, Classic PCs are the original PCs,
produced in 1981 and 1982, with a maximum of 64K bytes of RAM on the
motherboard.  Their ROM chips are usually dated 4/24/81 or 10/19/81.
New PCs consist of all subsequent PCs, including the XT and the AT.

     1.  With a New PC, using BASIC versions 2.0, 2.1 or 3.0, you can
determine the last random number to be generated with

          (1+PEEK(11)+256*PEEK(12)+65536*PEEK(13))/2^24

When using a Classic PC or using a New PC with BASIC 3.1, do not add
in the initial number 1.  The procedure above assumes that RANDOMIZE
has not been executed since the last random number was generated.  On
a New PC, the result will occasionally differ from the actual value of
RND in the last digit.  The number 1 was added in the formula for New
PCs to reduce round-off errors.

     2.  To determine the next random number to be generated:
Successive random numbers are generated by a formula involving two
parameters, A# and B#, below.  These two numbers vary according to the
type of PC and the version of BASIC.  Some combinations are:  A# =
214013, B# = 13737667 (a New PC and a version of BASIC prior to 3.1);
A# = 17405, B# = 10395331 (a Classic PC and a version of BASIC prior
to 3.1); A# = 214013, B# = 2531011 (a New PC and BASIC 3.1); and A# =
214013, B# = 10395331 (A Classic PC and BASIC 3.1).  The following
program will compute the numbers A# and B# for your particular
configuration.  Record the values of A# and B# for future use.

10 POKE 11,0:POKE 12,0:POKE 13,0:T=RND
20 B#=PEEK(11)+256*PEEK(12)+65536#*PEEK(13)
30 POKE 11,1:POKE 12,0:POKE 13,0:T=RND
40 A#=PEEK(11)+256*PEEK(12)+65536#*PEEK(13)-B#
50 PRINT "A# =";A#;"B# =";B#

AT any time, the following program will determine the next random
number to be generated by a Classic PC using any version of BASIC or
a New PC using BASIC 3.1.

10 S#=PEEK(11)+256*PEEK(12)+65536#*PEEK(13)
20 X#=A#*S#+B#
30 T#=X#-2#^24*INT(X#/2#^24)
40 PRINT "The next random number will be";CSNG(T#/2#^24)



For a New PC and a version of BASIC preceding 3.1, replace lines 10
and 30 with:

10 S#=PEEK(11)+256#*PEEK(12)
30 T#=1+x#-2#^24*INT(X#/2#^24)

POKEing numbers into locations 11, 12 and 13 reseeds the random-number
generator.

     3.  PEEK(40) returns the number of the most recent error message.

     4.  Normally, the first 24 lines of the screen scroll as the
screen fills.  However, the scrolling portion of the screen can consist
of any rectangular portion beginning on the left side of the screen.
The following statements specify that the scrolling portion of the
screen consists of the first c positions of lines a through b.  Once
the cursor has been moved to this region, it will be confined there.

          POKE 41,c:POKE 91,a:POKE 92,b

To prevent all scrolling, even when characters are PRINTed into the
last line, execute:  POKE 92.0.  (Be careful to POKE another number
into location 92 before the program terminates.)  To scroll all 25
lines, execute:  KEY OFF:POKE 92,25

     5.  For the current BASIC line number, PEEK(46)+256*PEEK(47)

     6.  To determine the screen mode,

PEEK(72) = 0 text mode, WIDTH 40, color burst disabled
         = 1 text mode, WIDTH 40, color burst enabled
         = 2 text mode, WIDTH 80, color burst disabled
         = 3 text mode, WIDTH 80, color burst enabled
         = 4 medium-resolution graphics, color burst enabled
         = 5 medium-resolution graphics, color burst disabled
         = 6 high-resolution graphics, color burst disabled
         = 7 monochrome display

     7.  To determine the text-mode foreground color, PEEK(75)

     8.  For the text-mode background color, PEEK(76)

     9.  For the text-mode border color, PEEK(77)

     10.  For medium-resolution text color, PEEK(78) AND 3

     11.  To set the text color in medium-resolution graphics mode to
color c of the current palette (c = 1, 2 or 3), POKE 78,c

     12.  For the medium-resolution background color, PEEK(81) AND 15

     13.  For the medium-resolution palette, PEEK(82) MOD 2



     14.  The row number of the cursor is given by, PEEK(86).  The
column number is given by, PEEK(87).

     15.  For the WIDTH of each line printed on LPT1, PEEK(98).  To set
the WIDTH to w, execute:  POKE(98),w.

     16.  The position of the print head within the buffer of LPT1 is
given by:  PEEK(99).  To move the print head to position n, execute:
PEEK(99),n

     17.  PEEK(100) returns a value of 1 if the cassette motor is off,
0 if the motor is on.

     18.  To determine if the soft keys are displayed on line 25:

PEEK(113) = 0    not displayed
          = 1    displayed ever since BASIC was invoked
          = 255  displayed as a result of executing KEY ON

If the soft keys are displayed and 0 is POKEd into location 113, the
keys will continue to be displayed.  However, the combination of LOCATE
and PRINT will be able to display characters on the 25th line, and CLS
will erase the 25th line.

     19.  To determine the exact user response to an INPUT, LINE INPUT,
INPUT#, or LINE INPUT# statement, use:

A$="":N=503:WHILE PEEK(N)<>0:A$=A$+CHR$(PEEK(N)):N=N+1:WEND:? A$

(Note:  This line must be part of a program.  If executed in direct
mode, it will just read itself.  While numeric responses are often
rounded, truncated, or converted to floating-point form, the string A$
will consist of the exact digits typed.)

     20.  To show the location of the end of the last statement
executed:  PEEK(835)+256*PEEK(836).  (Note:  This pointer points to
either the null character at the end of a line or to the colon
separating a pair of statements.)

     21.  The memory location pointed to by the BASIC stack pointer is
returned by:  PEEK(837)+256*PEEK(838)

     22.  The line number of the last BASIC error is shown by:
PEEK(839)+256*PEEK(840)

     23.  For the location of the program line n specified in an ON
ERROR GOTO n statement:  PEEK(845)+256*PEEK(846)








     24.  The segment number of BASIC's Data Segment is returned by:
PEEK(848)+256*PEEK(849).  Machine language programs must be POKEd into
an unused portion of memory where they can be CALLed.  One safe place
is the segment whose number is 4096 higher than the segment number of
BASIC's Data Segment.  The available space can be determined by
executing:  DEF SEG=0:PRINT PEEK(1043)+256*PEEK(1044).  This returns
the size of the random access memory in kilobytes.

     25.  The memory location (in the text of a program) of the byte
following the most recently READ piece of DATA is shown by:
PEEK(862)+256*PEEK(863)

     26.  The minimum allowable value for array subscripts is at:
PEEK(1116)

     27.  To protect the current program so that it cannot be LISTed
or EDITed:  POKE 1125,255

     28.  To determine if the current program is protected:  PEEK(1124)
has value 0 if the program is not protected; the message "Illegal
function call" is produced if the program is protected.

     29.  To show the number of files specified by the /F option when
BASIC was invoked, use:  PEEK(1247)

     30.  To determine the File Control Blocks:  LET X=PEEK(1248) +
256*PEEK(1249).  Then the File Control Block for the nth file begins
at the location shown by:  PEEK(X+2*n)+256*PEEK(X+2*n+1).  Bytes 3
through 13 of the File Control Block contain the name of the file.
The drive containing the file is:  CHR$(64+PEEK(2nd location)).

     31.  The disk drive containing the file most recently accessed by
BASIC is:  CHR$(64+PEEK(1264))

     32.  The name of the file most recently accessed by BASIC is
given by:  FOR I=0 TO 10:PRINT CHR$(PEEK(1265+I));:NEXT I

     33.  For the coordinates of the last point referenced:  PEEK(1341)
+256*PEEK(1342)  is the x coordinate; PEEK(1339)+256*PEEK(1340)  is the
y coordinate.

     34.  To set the coordinates of the last point referenced to (a,b),
use:  POKE 1341,a MOD 256:POKE 1342,a\256
      POKE 1339,b MOD 256:POKE 1340,b\256

     35.  Strings of up to 15 characters can be assigned to the
function keys with the KEY statement.  These strings are stored in the
160 memory locations beginning with the location of offset 1619.  Every
16th memory location and the unused locations contain a null character.
You can use this information, in conjunction with redefining the scroll
window, to customize the display that normally occupies the 25th line
of the screen.



     36.  The current color to be used by DRAW statements is returned
by:  PEEK(1782) AND 3.  To change the color to color c of the current
palette, execute:  POKE 1782,85*c.  (Note: Any graphics statement
containing a color parameter changes the value of PEEK(1782) AND 3 to
the specified color.)

     37.  BASIC's environment begins at offset 0 in segment ENV, where
the numeric value of ENV can be determined with the following program.
Each equation in the environment is followed by a null character, and
the final equation is followed by two null characters.

10 DEF SEG
20 PSP=PEEK(1794)+256*PEEK(1795)  'Program Segment Prefix
30 DEF SEG=PSP
40 ENV=PEEK(44)+256*PEEK(45)

     38.  The following listing will show the program that was executed
and the options (such as /F:4) that were specified when BASIC was
invoked.

10 DEF SEG
20 PSP=PEEK(1794)+256*PEEK*1795)   'Program Segment Prefix
30 DEF SEG=PSP
40 FOR I=130 TO 129+PEEK(128)
50 PRINT CHR$(PEEK(I));
60 NEXT

     39.  The buffer size for random files specified by the /S option
when BASIC was invoked is returned by:  PEEK(N)+256*PEEK(N+1)  where
N = 1851, 1854, 1858 and 1858 for BASIC Versions 2.0, 2.1, 3.0, and
3.1, respectively.

     40.  Similarly, for the communications buffer size specified by
the /C: option when BASIC is invoked:  PEEK(N)+256*PEEK(N+1)  where
N = 1861, 1864, 1868 and 1870 for BASIC Versions 2.0, 2.1, 3.0, and
3.1, respectively.

     41.  To locate the communications buffer in BASICA 2.1:

LET X=PEEK(1866)+256*PEEK(1867)  for COM1:
LET X=PEEK(1868)+256*PEEK(1869)  for COM2:

     The buffer for receiving data when using the Asynchronous
Communications Adapter begins at location  PEEK(X+1)+256*PEEK(X+2)
and it ends at  PEEK(X+3)+256*PEEK(X+4)-1.  The buffer for transmitting
data begins at location  PEEK(X+5)+256*PEEK(X+6)  and ends at
PEEK(X+7)+256*PEEK(X+8)-1.

     The numbers 1866-1869 should be changed to 1863-1866, 1870-1873,
and 1872-1875 for BASICA Versions 2.0, 3.0, and 3.1, respectively.





     42.  The position of the print head within the buffer of LPT2 is
returned by PEEK(N) where N = 1875, 1878, 1882, and 1884 in BASIC
Versions 2.0, 2.1, 3.0, and 3.1, respectively.  To move the print head
to position n, execute POKE N,n.

     43.  Similarly, the position of the print head within the buffer
of LPT3 is returned by PEEK(N) where N = 1876, 1879, 1883, and 1885 in
BASIC Versions 2.0, 2.1, 3.0, and 3.1, respectively.  To move the print
head to position n, execute POKE N,n.

     44.  For the WIDTH of each line printed by LPT2: PEEK(N) where
N = 1877, 1880, 1884, and 1886 in BASIC Versions 2.0, 2.1, 3.0, and
3.1, respectively.  To set the WIDTH to w, execute POKE N,w.

     45.  Similarly, for the WIDTH of each line printed by LPT3:
PEEK(N) where N = 1878, 1881, 1885, and 1887 in BASIC Versions 2.0,
2.1, 3.0, and 3.1, respectively.  To set the WIDTH to w, execute
POKE N,w.

     46.  In direct mode, pressing Ctrl-PrtSc causes the printer to
print all output as it appears on the screen.  This is referred to as
an echo to the printer.  In program (or direct) mode, the statement
POKE N,255 turns on echoing and the statement POKE N,0 turns off
echoing, where N = 1880, 1883, 1887, or 1889 in BASIC Versions 2.0,
2.1, 3.0, or 3.1, respectively.

     47.  To determine the music parameters in BASICA 2.1:

PEEK(2140) has value 0 for the Music Foreground mode and values 1 or
     255 for the Music Background mode.
PEEK(2141) is the current octave number.
PEEK(2142) is the current tempo in quarters per minute.
PEEK(2143) is the reciprocal of the length of a standard note.

     It is set by the statement PLAY "Ln".

PEEK(2145) has the value 1, 2, or 3 to demote Music Legato, Music
     Staccato, or Music Normal, respectively.

     The numbers 2140-2145 should be changed to 2144-2149 and 2149-2154
for BASICA Versions 3.0 and 3.1, respectively.  In BASICA Version 2.0,
2141-2145 should be changed to 2136-2140, and 2140 should be changed to
2141.

     48.  PEEK(N) shows the scale to be used by DRAW, where N = 2161,
2163, 2167, and 2172 in BASICA Versions 2.0, 2.1, 3.0, and 3.1,
respectively.  To set the scale to n, execute POKE N,n.

     49.  Use the following statements to determine the angle at which
future DRAWings will be turned in BASICA 2.1.  (Such angles are set by
the statement DRAW "TA n", where n is the number of degrees in the
angle.)



PEEK(2165) is the low byte in the integer representation of n.  (Hence,
if n is between 0 and 255 degrees, PEEK(2165)=n.)

CVS(CHR$(PEEK(2166))+CHR$(PEEK(2167))+CHR$(PEEK(2168))+CHR$(PEEK(2169)))

is the cosine of the angle n.

CVS(CHR$(PEEK(2170))+CHR$(PEEK(2171))+CHR$(PEEK(2172))+CHR$(PEEK(2173)))

is -1/1.2 times the sine of the angle in SCREEN mode 1.

CVS(CHR$(PEEK(2174))+CHR$(PEEK(2175))+CHR$(PEEK(2176))+CHR$(PEEK(2177)))

is 1.2 times the sine of the angle in SCREEN mode 1.

     Replace 1.2 with 2.4 for SCREEN mode 2.  This information can be
used to compute the cosine and sine of the angle, and hence the value
of the angle.

     The numbers 2165-2177 should be chanted to 2163-2175, 2169-2181,
and 2174-2186 for BASICA Versions 2.0, 3.0, and 3.1, respectively.

     50.  To determine status of light-pen trapping in BASICA 2.1, use:

PEEK(2203) = 0 if trapping of light pen is OFF
           = 1 if trapping of light pen is ON
           = 2 if trapping of light pen is STOPped while OFF
           = 3 if trapping of light pen is STOPpen while ON

Activating the light pen causes the program to branch to the program
line stored at location PEEK(2204)+256*PEEK(2205).  The numbers 2203-
2205 should be changed to 2201-2203, 2207-2209, and 2212-2214 for
BASICA Versions 2.0, 3.0, and 3.1, respectively.

     51.  To determine the status of key-trapping in BASICA 2.1, use:

PEEK(2203+3*n) = 0 if trapping of key n is OFF
               = 1 if trapping of key n is ON
               = 2 if trapping of key n is STOPped while OFF
               = 3 if trapping of key n is STOPped while ON

Pressing key n causes the program to branch to the program line stored
at location PEEK(2204+3*n)+256*PEEK(2205+3*n).  The numbers 2203-2205
should be changed to 2201-2203, 2207-2209, and 2212-2214 for BASICA
Versions 2.0, 3.0, and 3.1, respectively.

     52.  To determine the status of joystick-button trapping in
BASICA 2.1, use:

PEEK(2266+3*n/2) = 0 if trapping of button n is OFF
                 = 1 if trapping of button n is ON
                 = 2 if trapping of button n is STOPped while OFF
                 = 3 if trapping of button n is STOPped while ON


Buttons 0 and 4 are the lower and upper buttons of the first joystick,
and buttons 2 and 6 are the lower and upper buttons of the second
joystick.  Pressing button n causes the program to branch to the line
stored at location PEEK(2267+3*n/2)+256*PEEK(2268+3*n/2).  The numbers
2266-2268 should be changed to 2264-2266, 2270-2272, and 2275-2277 for
BASICA Versions 2.0, 3.0, and 3.1, respectively.

     53.  To determine the status of ON PLAY(n) trapping BASICA 2.1:

PEEK(2278) = 0 if trapping is OFF
           = 1 if trapping is ON
           = 2 if trapping is STOPped while OFF
           = 3 if trapping is STOPped while ON

When the changing of the number of notes in the music background buffer
from n to n-1 is trapped, the program branches to the program line
stored at location PEEK(2279)+256*PEEK(2280).  The numbers 2278-2280
should be changed to 2276-2278, 2282-2284, and 2287-2289 for BASICA
Versions 2.0, 3.0, and 3.1, respectively.  The value of n is PEEK(N),
where N = 2142, 2146, 2150, and 2155 in BASICA Versions 2.0, 2.1, 3.0,
and 3.1, respectively.

     54.  To determine the status of the ON TIMER(n) trapping in
BASICA 2.1:

PEEK(2281) = 0 if trapping is OFF
           = 1 if trapping is ON
           = 2 if trapping is STOPped while OFF
           = 3 if trapping is STOPped while ON

The elapsing of n seconds causes the program to branch to the program
line stored at location PEEK(2282)+256*PEEK(2283).  The numbers 2281-
2283 should be changed to 2279-2281, 2285-2287, and 2290-2292 for
BASICA Versions 2.0, 3.0, and 3.1, respectively.  The value of n is
PEEK(N)+256*PEEK(N+1)+65536*PEEK(N+2), where N = 2145, 2149, 2153, and
2158 in BASICA Versions 2.0, 2.1, 3.0, and 3.1, respectively.  At any
time, the number of seconds remaining until a branching occurs is
PEEK(n+3)+256*PEEK(N+4).  To induce a branching as soon as possible,
execute POKE N+4,0:POKE N+3,1.  (Note: For values of n between 65536
and 86400, the ON TIMER statement causes a branching after just
n-65536 seconds.)

     55.  To determine the keys or key combinations associated with the
user-defined key traps in BASICA Version 2.1: If PEEK(2284)+2*(n-15))=
0, then the key with scan code PEEK(2285+2*(n-15)) is associated with
Fn.  (Here n = 15, 16, ....or 20.)  Otherwise, the key combination
consisting of one or more latched keys along with the key having scan
code PEEK(2285+2*(n-15)) is associated with Fn.  The following table
gives the latched keys included in the combination.
Let L% = PEEK(2284+2*(n-15)).





L% AND 3  = 3   Shift key
L% AND 4  = 4   Ctrl key
L% AND 8  = 8   Alt key
L% AND 32 = 32  NumLock key
L% AND 64 = 64  CapsLock key

The numbers 2284-2285 should be changed to 2282-2283, 2288-2289, and
2293-2294 for BASICA Versions 2.0, 3.0, and 3.1, respectively.

     56.  To determine the status of a VIEWport in BASICA Versions 2.1:

If PEEK(2323) = 1, a viewport has been established
If PEEK(2324) = 0, then VIEW has been executed
If PEEK(2324) = 1, then VIEW SCREEN has been executed

The x coordinates of the points in the viewpoint are stored in the
range from PEEK(2315)+256*PEEK(2316) to PEEK(2317)+256*PEEK(2318), and
the y coordinates range from PEEK(2319)+256*PEEK(2320) to PEEK(2321)+
256*PEEK(2322).  The numbers 2315-2324 should be changed to 2313-2322,
2319-2328, and 2324-2333 for BASICA Versions 2.0, 3.0, and 3.1,
respectively.

     57.  In the world coordinate system of BASICA 2.1, PEEK(2359) has
the value 1 if a WINDOW statement has been executed.  If so, the
coordinate system is right-handed if PEEK(2360)=0 and left-handed if
PEEK(2360)=1.  The x coordinates range from x1 to x2, and the y
coordinates range from y1 to y2, where

x1 = CVS(CHR$(PEEK(2361))+CHR$(PEEK(2362))+CHR$(PEEK(2363))+CHR$
     (PEEK(2364)))

y1 = CVS(CHR$(PEEK(2365))+CHR$(PEEK(2366))+CHR$(PEEK(2367))+CHR$
     (PEEK(2368)))

x2 = CVS(CHR$(PEEK(2369))+CHR$(PEEK(2370))+CHR$(PEEK(2371))+CHR$
     (PEEK(2372)))

y2 = CVS(CHR$(PEEK(2373))+CHR$(PEEK(2374))+CHR$(PEEK(2375))+CHR$
     (PEEK(2376)))

To return the physical coordinate system:  POKE 2359,0.  The numbers
2359-2376 should be changed to 2357-2374, 2363-2380, and 2368-2385 for
BASICA Versions 2.0, 3.0, and 3.1, respectively.  The world coordinates
can be altered by appropriate POKEing.)

     58.  The music buffer is a circular buffer analagous to the
keyboard buffer.  In BASICA 2.1 it consists of the number of bytes
returned by PEEK(2417)+256*PEEK(2418), and it extends from the location
PEEK(2427)+256*PEEK(2428) to the location preceding PEEK(2425)+256*
PEEK(2426).  The notes to be played are stored in the bytes extending
from PEEK(2421)+256*PEEK(2422) (the head) to the location preceding
PEEK(2423)+256*PEEK(2424) (the tail), after possibly cycling back to
the beginning of the buffer.  Each note is described by 4 bytes.  The


duration of the note is (256*[1st byte]+[2nd byte])/583 seconds and the
frequency is 596591/(256*[3rd byte]+[4th byte]) Hertz.  In Music
Background mode, the number of bytes remaining in the buffer at any
time is given by PEEK(2419)+256*PEEK(2420).  (Note: The beginning and
end of the buffer are also given by PEEK(2394)+256*PEEK(2395) and
PEEK(2396)+256*PEEK(2397)).

     The numbers 2394-2428 should be changed to 2420-2454, 2398-2432,
and 2403-2437 for BASICA Versions 2.0, 3.0, and 3.1, respectively.

     The music buffer can be enlarged and relocated by POKEing into the
above-mentioned memory locations.  The buffer normally holds 32 notes.
The program DEMO1.BAS shows how to create a buffer capable of holding
N = 125 notes.  By changing the value of N (which appears twice in the
program), you can create even larger buffers.  (Note: In the Music
Normal or Music Staccato modes, the pause between successive notes is
counted as a note.)

B.  BASIC's Storage Area

     The six regions in BASIC's storage area hold the text of the
program, the values of the variables, and BASIC's stack.

     1.  The program text begins at PEEK(48)+256*PEEK(49) and ends,
with a terminating null character appended at PEEK(854)+256*PEEK(855).
(Note: The second value will be zero unless requested in direct mode
after the execution of the program.  From within the program mode it
can be computed as PEEK(856)+256*PEEK(857)-3.)  Key words are
tokenized, and each 2-byte line number is preceeded with the 2-byte
offset of the beginning of the next line.

     This information can be used to recover a program after NEW has
been executed, provided you know the first line.  To illustrate,
suppose that the first line of a program is:  0 REM Can unNEW.

This line is stored in 16 bytes: 2 bytes for the pointer to the
location of the next line, 2 bytes for the line number, 1 byte for the
token of REM, 1 byte for the space after REM, 9 bytes for "Can unNEW",
and 1 null byte at the end of the line.  To recover the program,

     a) Execute PRINT PEEK(48)+256*PEEK(49)  (This is referred to as
the number X, but be sure not to declare it as a variable, X.)

     b) Execute POKE X,(X+16) MOD 256:POKE *x+1,(X+16)\256

     c) SAVE the program in ASCII format.

     d) LOAD the program.

     e) LIST the program.  Every line will appear.  (Note: As a
precaution against losing a program, then, you can always make the
first line 0 REM Can unNEW.  Otherwise, in step (b), replace 16 with
the number of bytes needed to store the first line of your program.)


     2. Simple variables (that is, all variables except arrays) are
stored beginning at PEEK(856)+256*PEEK(857).  This region contains the
values of the numeric variables and pointers to the locations of the
string variables.

     3. Array variables are stored beginning at PEEK(858)+256*PEEK(859)

     4. Free space begins at PEEK(860)+256*PEEK(861).  New variables
take locations from the beginning of free space and new strings take
locations from the end.

     5.  String space occupies the region extending from PEEK(815)+
256*PEEK(816) to PEEK(778)+256*PEEK(779).  New strings are added to
the bottom of string space by taking memory locations from free space.

     6.  The space allocated for BASIC's stack follows the sgring space
and extends to PEEK(44)+256*PEEK(45), the end of the portion of memory
available to BASIC.  (Normally, it is the end of BASIC's Data Segment,
but it can be restricted by a CLEAR statement.)  At any time, the byte
on the top of the stack is in location PEEK(837)+256*PEEK(838).


                          Monochrome Display

DEF SEG = 45056

     The 4000 memory locations at the beginning of segment &HB000
reside on the monochrome display adapter board and hold the contents
of the screen.  Each of the following PEEK and POKE statements should
be preceded by DEF SEG = 45056 (or DEF SEG = &HB000).  (Caution: The
OUTs discussed in this section might cause physical damage if executed
with a board other than the IBM monochrome display adapter.)

     1. To place the character having ASCII value n in row r, column c:

POKE 2*(80(r-1)+(c-1)),n

To define the attribute for this character:

POKE 2*(80(r-1)+(c-1))+1,a

where a =   7 when normal (that is, white on black)
        =   1 when normal and underlined
        = 112 when reverse video (that is, black on white).

Add 8 to each of the first two numbers to obtain high-intensity white
and add 128 to any of the numbers to cause the characters to blink.
(Note: When POKEd, the ASCII values 7, 9, 10, 11, 12, 13, 28, 29, 30,
and 31 produce symbols.)

     2. To disable blinking:  OUT 952,15

     3. To blank the screen:  OUT 952,1


     4. To restore the screen (and enable blinking):  OUT 952,255

     5. To turn off all but the first n rows of the screen:
OUT 948,6:OUT 949,n


                           Graphics Monitor

DEF SEG = 47104

     The 16K memory locations at the beginning of segment &HB800 reside
on the color/graphics adapter board and hold the contents of the
screen.  The graphics screen has three modes: text, medium-resolution
graphics, and high-resolution graphics.  Each of the following PEEK or
POKE statements should be preceded by DEF SEG = 47104 (of DEF SEG =
&HB800).  (Caution: The OUTs discussed in this section might cause
physical damage if executed with a board other than the IBM color/
graphics adapter.)

A. Text Mode

     In text mode (invoked by the statement SCREEN 0), characters can
be displayed in rows of either 40 characters (invoked by the statement
WIDTH 40) or 80 characters (invoked by the statement WIDTH 80).

     1. To place the character having ASCII value n in row r, column c,
with foreground color f and background color b:  POKE a,n:POKE a+1,k
where a = 160*(r-1)+2*(c-1) in WIDTH 80 and = 80*(r-1)+2*(c-1) in WIDTH
40, and where k = 16*b+f if the foreground should not blink and
= 16*b+f+128 if the foreground should blink.  The number f ranges from
0 to 15, and b ranges from 0 to 7.  (Note: These locations correspond
to page 0.  To obtain the analogous results for page p, add p*4096 to a
in WIDTH 80 and add p*2048 to a in WIDTH 40.)

     2. To disable blinking:  OUT 984,8 in width 40
                              OUT 948,9 in width 80

(Note: With blinking disabled, the number b in item 1 can range from
0 to 15.)

     3. To blank the screen:  OUT 984,32 in width 40
                              OUT 984,33 in width 80

     4. To restore the screen:  OUT 984,40  width 40, blinking enabled
                                OUT 984,8   width 40, blinking disabled
                                OUT 984,41  width 80, blinking enabled
                                OUT 984,9   width 80, blinking disabled

     5. To set the border color to d:  OUT 985,d

     6. The color/graphics adapter board contains 16K bytes of memory.
Each pair of locations holds the information for one character.  (The
first location holds the ASCII value of the chracter and the second


holds the attribute.)  Any consecutive block of 2000 (in 40 by 25 mode)
or 4000 pairs (in 80 by 25 mode) can be used to determine the
characters appearing on the screen.  To display the characters
determined by pairs N, N+1, N+2, ...:

OUT 980,12:OUT 981,N\256:OUT 980,13:OUT 981,N MOD 256

(To display the pth page in 40 by 25 mode, use N = p*2048.  In 80 by 25
mode, use N = p*4096.)

B. Medium-Resolution Graphics Mode

     In medium-resolution graphics mode, which is invoked by the
statement SCREEN 1, the screen is partitioned into 320 by 200 pixels.

     1. To turn on the pixel with coordinates x,y in color c of the
current palette:

Z=40*y+x\4+8152*(y MOD 2):W=2^(6-2*(x MOD 4)):POKE Z,(PEEK(Z) AND
     (255-3*W))+c*W

     2. To use background color c and palette p:  OUT 984,c+32*p
The palette colors can be intensified by adding 16 to the number
c+32*p.  Therefore, four different palettes are available.

     3. With an RGB monitor, an undocumented palette (and its
intensified version) is available.  To obtain the background color c
and a palette consisting of the colors cyan, red, and white:

OUT 984,46:OUT 985,c

(Note: The palette colors can be intensified by adding 16 to the
number c.  Hence, there are actually 6 palettes available with an
RGB monitor.)

     4. To reverse the foreground and background colors (and
interchange colors 1 and 2 of the palette) on the current display, use:

FOR I% = 0 TO 16191:POKE I%,PEEK(I%) XOR 255:NEXT

(Note: This procedure is sometimes valuable before doing a graphics
dump to the printer.)

     5. To blank the screen:  OUT 984,2

     6. To restore the screen:  OUT 984,10

C. High-Resolution Graphics Mode

     In high-resolution graphics mode (invoked by the statement SCREEN
2), the screen is partitioned into 640 by 200 pixels.




     1. To turn on the pixel with coordinates x,y:

Z=40y+x\8+8152*(y MOD 2):POKE Z,PEEK(Z) OR 2^(7-x MOD 8)

     2. To turn off the pixel with coordinates x,y:

Z=40y+x\8+8152*(y MOD 2):POKE Z,PEEK(Z) AND (255-2^(7-x MOD 8))

     3. To change the foreground color to c:  OUT 985,c
(The background color is normally black.)

     4. To reverse the foreground and background colors of the current
display, use:

FOR I% = 0 TO 16191: POKE I%,PEEK(I%) XOR 255:NEXT

     5. To blank the screen:  OUT 984,18

     6. To restore the screen:  OUT 984,26

D. Low-Resolution Graphics Mode

     The following programs set up a 160 by 100 pseudo-graphics mode
with background color B.

10 KEY OFF:SCREEN 0,0,0:WIDTH 80
20 OUT 984,9
30 OUT 980,4:OUT 981,127
40 OUT 980,6:OUT 981,100
50 OUT 980,7:OUT 981,112
60 OUT 980,9:OUT 981,1
70 DEF SEG=&HB800
80 FOR I%=0 TO 16382 STEP 2
90 POKE I%,222:POKE I%+1,17*B
100 NEXT

Although text cannot be PRINTed and pixels cannot be lit with PSET, the
point with coordinates X,Y can be turned on in any one 16 colors, C, by
executing:

200 S=X AND 1
210 A=160*Y+(X OR 1)
220 POKE A,(PEEK(A) AND (15+S*225))+(C*(16-15*S))

E. All Modes

     1. The following program allows a graphics monitor and a
monochrome display to be used at the same time.  Suppose that BASIC
is currently writing to the monochrome display.  After this program is
executed, data can be PRINTed onto the monochrome display and POKEd
into the color/graphics adapter as in sections A, B, C, and D of the
Graphics Monitor portion of this article.



10 FOR R=0 TO 15
20 READ V:OUT 980,R:OUT 981,V
30 NEXT
40 READ M:OUT 984,M
50 DATA 56,40,45,10,127,6,100,112,2,1,6,7,0,0,0,0,42

     This program results in medium-resolution graphics.  To obtain
high-resolution graphics, replace the last number in the DATA statement
with 26.  To obtain text mode with 40 characters per line, replace line
50 with:

50 DATA 56,40,45,10,31,6,25,28,2,7,6,7,0,0,0,0,40

and to obtain text mode with 80 characters per line, replace line 50:

50 DATA 113,80,90,10,127,6,100,112,2,1,6,7,0,0,0,0,9

     2. To move the screen horizontally by approximately h characters
from the standard position:

OUT 980,2:OUT 981,45+h  in width 40
OUT 980,2:OUT 981,90+h  in width 80

(Note: If h is positive, the screen moves left; if h is negative, the
screen moves right.)

     3. To move the screen vertically by about v pixels or characters
from the standard position:

OUT 980,7:OUT 981,112+v  in graphics mode
OUT 980,7:OUT 981,28+v   in text mode

(NOte: If v is positive, the screen moves up; if v is negative, the
screen moves down.)

     4. To turn off all but the first n rows of the screen:

OUT 980,6:OUT 981,n

     5. To decrease the amount of snow on the screen when POKEing
characters or pixels into the screen, precede each POKE (or small
group of POKEs) with:

WHILE 1 AND INP(986):WEND:WHILE NOT(1 AND INP(986)):WEND

                           Read Only Memory

DEF SEG = 61440

     The following memory locations are part of read only memory (ROM).
Each PEEK in this section should be preceded by DEF SEG = 61440 (or
DEF SEG = &HF000).



     1. Error messages with numbers ranging from 1 to 30 and 50 to 67
are stored in ROM in the 741 memory locations beginning with the
location at offset 25525.  A null character appears at the end of each
message, and question marks serve as place holders for the numbers with
no messages.  This information can be used, with ON ERROR and ERR, to
display the nature of an error without first terminating the program
currently in operation.

     2. The strings that are assigned to the ten function keys when
BASIC is first invoked are stored in ROM in the 71 memory locations
beginning with the location of offset 44269.  A null character appears
at the end of each string.  This information can be used to restore the
original values to the function keys in the even that reassignments
have been made with the KEY statement.

     3. To determine possible parameters for BASIC's random number
generator:

PEEK(49771)+256*PEEK(49772)+65536*PEEK(49773)=214013
PEEK(49774)+256*PEEK(49775)+65536*PEEK(49776)=2531011

These numbers sometimes serve as parameters for the random number
generator.  In particular, they are the values of A# and B# for a New
PC using BASIC 3.1.

     4. In graphics mode, each character is displayed in an 8 by 8
array of pixels that can be stored as a sequence of 8 bytes.  The bytes
for the characters having ASCII values 0 to 127 are stored in the
memory locations having offsets from 64110 to 65113.  This information
can be used to write a program that will display characters upside-
down, enlarged, or sideways and to create banners with a printer.

     5. To obtain the machine part number:

FOR I=57344 TO 57350:PRINT CHR$(PEEK(I));:NEXT I

     6. To obtain the IBM copyright notice:

FOR I=57352 TO 57365:PRINT CHR$(PEEK(I));:NEXT I

(Note: This information can be used to determine if the computer is an
IBM or an IBM compatible.)

     7. To obtain the version date of the ROM BIOS:

FOR I=65525 TO 65532:PRINT CHR$(PEEK(I));:NEXT I

(Note: Certain hardware, such as the IBM enhanced graphics monitor, can
be used only if this date is sufficiently recent.)






     8. To determine the computer being used:

PEEK(65534) = 255  PC
            = 254  PC-XT or Portable PC
            = 253  PCjr
            = 252  PC AT

(Note: The identification numbers of PC compatibles will most likely
differ from these numbers.  Some early XTs have a machine ID code of
255.)

Exceptions for the PCjr

     The PEEKs, POKEs, INs, and OUTs presented in this article hold
for the IBM PC, XT and AT; however, many of the items do not hold for
the PCjr, such as outs to the color/graphics adapter and the POKEs
that relocate the music buffer.  And for non-IBM compatibles, remember
that compatible is as compatible does.
<PAGEEND:"Poke.Peek.File">

<PAGESTART:"FAQ.File">
                     The psudo, almost real, semi-
                   ͻ ͸ ͸  ͻ  ͻ 
                       ͵  ͵         ͹ 
                                          
                   ͼ          ͼ      ;
                                looking
         ͻ       ͻ   /   ͻ ͻ ͸  ͻ
                         /    ͹ ͹ ͻ  
           \            /\                  
         ͼ\ ͼ  ͼ   \   ͼ     ͼ  ͼ

                           ͸ ͻ ͻ
                           ͵  ͹    
                                     \
                              .   .ͼ\.
                       Frequently Asked Questions
                      Version 1.0 - Release 6/1/94
                  Written and Created by Mike Audleman
                  Copyright (C) 1994 by Mike Audleman

 Please distribute freely but UNMODIFIED.  If you have contributions,
 you may send them to MIKE AUDLEMAN at FIDO address 1:154/288 or on the
 Quick_Basic FIDO echo.  Please send them as ASCII text only, no
 formatted doccuments (WP, W4WIN etc.).  This is not an OFFICIAL
 document and as such all information is provided ASIS and no warrenties
 are implied as to the acuracy of anything included here.  The questions
 and answers here are take from the Quick_Basic echo that I read weekly
 and reflect general questions that seem to appear on a regular basis. I
 write this in an effort to reduce the load on the net and plan to
 release new or updated versions on a monthly basis unless the load
 seems such that another interval is warrented.

 Since this is NOT a CODE SNIPPIT publication, code here will be limited
 severely.  Only enough code to present information will be included. At
 this time, I do not know if there is anyone maintaining a snippit file,
 but if someone is, please forward the name and fido address that it can
 be freq'd from and I will include the info on it here.

 This publication is not connected in any way to any commercial
 concern, mine or otherwise and is free to all.  No information
 contained herin is to be considered as an advertisment for any product,
 consider it as INFORMATION only.

 One last note, I do not own any version of PDS so I am unable to test
 ANY of the information with regard to that package.  I do have QB45 and
 have tested MOST but NOT all on it.  Additionally, much of this
 information will not be compatible to QBasic provided with MSDOS 5.0
 and above since it is missing many of the features of the full compiler
 version.

                                                 Thank you.
                                                 Mike Audleman
                                                 FIDO: 1:154/280


                                 INDEX
    "How do I get arguments from the command line?"
    "How do I make QB45 stop converting COMMAND$ to uppercase?"
    "How do I make QuickBasic exit with an ErrorLevel?"
    "How do I load QB with two LIBs?"
    "Are there any good books on QuickBasic?"
    "How do I get a number from a string into an Integer?"
    "How do I remove spaces from a string?"
    "What are 'String Descriptors'?"
    "What is the difference between QBASIC and QuickBasic?"
    "How do I convert from a HEX number to DECIMAL or DECIMAL to HEX?"
    "How do I make QuickBasic reboot the system?"
    "Could anybody show me how `INKEY$' works please?"
    "How do you do ARCSIN and ARCCOS?"
    "How do the AND, OR, and XOR work?"
    "How do I seperate command line arguments?"



*>  "How do I get arguments from the command line?"

    Use the COMMAND$ function in QB, QB45 and PDS thus:

            Commandline$=COMMAND$

    One caviat here is that QB and QB45 converts the command line to
    UPPERCASE only.  I am not sure about PDS on the uppercase.

*>  "How do I make QB45 stop converting COMMAND$ to uppercase?"

    One method is to obtain a addon lib that provides direct access to
    the PSP and the unconverted command line.  The LIB I released in
    5/94 on the Quick_Basic net provides this and it is free.  This
    method provides the same capability in the design environment as
    well as when the file is compiled, the patch mentioned next does
    not.  The second method is to apply a patch to one of your QB45
    files. The following patch for QB45 will prevent QB from forcing the
    command line to uppercase.  Once you make this patch, you will have
    to use UCASE$(COMMAND$) to retreive an uppercase only string.

    The following steps will extract the OSCMD.OBJ file from your
    BCOM45.LIB, modify it and then replace it with the modified version.
    As always, MAKE A BACKUP OF BCOM45.LIB FIRST!  One note, this will
    not affect the design environment, it will still force to uppercase.
    When the BAS file is compiled and linked, it will return the command
    line as typed.  I still have not found the correct patch to QB.EXE.

    First, enter the following command:
        LIB BCOM45 *OSCMD

    Then run the following basic program
        Search$ = ""
        FOR X% = 1 TO 10
                READ Y%
                Search$ = Search$ + CHR$(Y%)
        NEXT X%
        Replace$ = CHR$(235) + CHR$(8) + STRING$(8, 144)
        PRINT "OSCMD.OBJ ";
        OPEN "OSCMD.OBJ" FOR BINARY AS 1
        X$ = SPACE$(LOF(1))
        GET 1, , X$
        X% = INSTR(X$, Search$)
        IF X% = 0 THEN PRINT "Not Modified.": CLOSE : END
        MID$(X$, X%) = Replace$
        PUT 1, 1, X$
        CLOSE : PRINT "Modified.": END
        DATA 60,97,114,6,60,122,119,2,52,32

    Now enter the following command:
        LIB BCOM45 -OSCMD +OSCMD,,BCOM45

    You should now have a modified BCOM45.LIB.

*>  "How do I make QuickBasic exit with an ErrorLevel?"

    Add the following declare statement at the beginning of your
    program:

        DECLARE SUB ExitWithErrLvl ALIAS "_exit" (BYVAL ERRORLEVEL%)

    Then to exit with an Error level contained in a variable:
        ExitWithErrorLvl Oops%

    WARNING: DO NOT USE THIS WHILE IN THE DEVELOPEMENT ENVIRONMENT IT
    WILL EXIT TO DOS WITHOUT PROMPTING FOR A SAVE.  IT HAS ON OCCASION
    LOCKED UP MY XT AND MY 386 WHEN USED IN THE ENVIRONMENT.

*>  "How do I load QB with two LIBs?"

    You can't.  You must combine the two LIBs into one and load that one
    instead.  This is a common situation that there are routines in the
    stock QB.LIB you need as well as an addon at the same time.  Here is
    how you combine two LIBs and generate a third to use.

      This combines QB.LIB and FOO.LIB into MYLIB.LIB generating a
      MYLIB.CAT catalog file:

            LIB QB.lib +FOO.LIB,MYLIB.CAT,MYLIB.CAT

    Now we must take the combined MYLIB.LIB and generate MYLIB.QLB:

            LINK /q MYLIB.LIB,MYLIB.QLB,nul,BQLB45 ;

    Note that the above lines assume that the current directory is your
    directory that contains QB45 and all the files, if not you must
    provide complete paths to all files not in the current directory.

*>  "Are there any good books on QuickBasic?"

    Yes,  probably the most recomended is:
      "MicroSoft QuickBasic Bible"
      by the Waite Group
      MicroSoft Press ISBN: 1-55615-262-0
      * Good examples on EVERY command

    Another good book that deals with INTERRUPT programming:

     "MD-DOS 5 Programming"
     by Peter G. Aitken
     MicroSoft Press ISBN: 1-55615-471-2
     * Sample code in QuickBasic and C for MANY interrupt calls

*>  "How do I get a number from a string into an Integer?"  Use:

        X% = VAL(TheString$)

*>  "How do I remove spaces from a string?"

    To remove spaces at the beginning of a string use

       X$ = LTRIM$(TheString$)

    To remove spaces at the end of a string use

       X$ = RTRIM$(TheString$)

    To remove at both beginning and end use
       X$ = LTRIM$(RTRIM$(TheString$))

*>  "What are 'String Descriptors'?"

    Generally you will never need to know this unless you plan to write
    ASM or C routines to use with QuickBasic.  String Descriptors are
    packs of 4 bytes that contain the offset within the DGROUP that the
    actual text of the string starts at and the length of the data.  QB
    does not use ASCIIZ strings (strings that end with a CHR$(0)) so you
    must convert them in your code if you wish to use them with C in
    most cases.  The block looks like:

    2 bytes     Offset within DGROUP
    2 bytes     Length of string data
    Both are UNSIGNED integers (0-65535)

*>  "What is the difference between QBASIC and QuickBasic?"
    A lot!  Some of them are:
    QBASIC will not compile a BAS file into a EXE, QB45 does.
    QBASIC does not have a CALL INTERRUPT, QB45 does.
    QBASIC does not allow use of LIBs, QB45 does.
    QBASIC is a stripped down version of QB45 included with DOS 5.0 and
    above.
    QuickBasic must be purchased.  The retail price varies but should be
    around $65-$80 U.S..

    Generally, almost all BAS code will run in QBASIC. The exception is
    that if is uses INTERRUPTS or outside LIBs, it will not.  There is
    however a CALL ABSOLUTE that does allow SOME access to ASM code but
    it is not simple and the routines must be small. Generally, if you
    are an occasional programmer, QBASIC will do just fine, however, if
    you want to end up with an EXE file or do some serious programming,
    QB45, or PDS would really be the way to go. Other packages available
    are Power Basic and Visual Basic for DOS. These other two packages
    are fine too and provide some additional commands over QB45 but as
    such are not backward compatible to QB45.

*>  "How do I convert from a HEX number to DECIMAL or DECIMAL to HEX?"

    To change from a HEX string to an integer:

      TheString$="6B"
      X%=VAL("&H"+TheString$)

    To change from an integer to a HEX string:

      X$=HEX$(TheInteger%)

*>  "How do I make QuickBasic reboot the system?"
    Here is a simple code snippit to do just this:

    SUB WarmBoot
        DEF SEG = 0
        POKE &h473, &h12
        POKE &h472, &h34
        DEF SEG = &hFFFF
        CALL ABSOLUTE(0)
    END SUB

    SUB ColdBoot
        DEF SEG = &hFFFF
        CALL ABSOLUTE(0)
    END SUB

*>  "Could anybody show me how `INKEY$' works please?"

    Inkey simply checks the keyboard and then returns.  If there was a
    keypress then it is returned, if not, inkey returns a NULL string.
    There are several methods of it's use.

    One is a one time scan....

    For x=1 to 1000
           ;do your stuff
           if inkey$=chr$(27) then exit for
    next x

    The other is to use it to scan the keyboard in a continuous loop
    until a key is pressed....

    Function GetKey$
           do:X$=Inkey$:loop while X$=""
           GetKey$=X$
    End Function

    Here is a similar routine to accept keys and Capitolize the first
    letter of each word....

    Function GetKeyCap$
    Toggle%=False
    Stuff$=""
           Do
                   X$=Inkey$
                   If X$=CHR$(13) then exit do   'User Pressed ENTER
                   If Toggle% then X$=Lcase$(X$) else X$=Ucase$(X$)
                   Stuff$=Stuff$+X$
                   Toggle%=( X$<>" ") 'Is it a Space?
           Loop

    GetKeyCap$=Stuff$

    End Function

*>  "How do you do ARCSIN and ARCCOS?"

     ARCSIN and ARCCOS are "derived" functions.  You can compute them
     using the following:

     CONST PI=3.141593
     ARCSIN(A) = ATN(A / SQR(-A * A+1))
     ARCCOS(A) = PI / 2 - ATN(A / SQR(-A * A+1))

     To convert these into full blown functions:

     Function ARCSIN# (A#)
       ARCSIN# = ATN(A# / SQR(-A# * A#+1#))
     end Function

     Function ARCCOS# (A#)
       ARCCOS# = PI / 2# - ATN(A# / SQR(-A# * A#+1#))
     end Function

*>  "How do the AND, OR, and XOR work?"

    Well, AND, OR and XOR can be mathmatical or comparative functions.

    The math functions would be (this is BIT level):

      AND           OR            XOR
    -----------   -----------   -----------
    0 AND 0 = 0   0 OR 0 = 0    0 XOR 0 = 0
    1 AND 0 = 0   1 OR 0 = 1    1 XOR 0 = 1
    0 AND 1 = 0   0 OR 1 = 1    0 XOR 1 = 1
    1 AND 1 = 1   1 OR 1 = 1    1 XOR 1 = 0

    15=1111, 7=0111, 6=0110, 2=0010, 10=1010
    so: 15 AND 7 = 7, 6 OR 2 = 6, 10 XOR 10 = 0

    The comparitive functions are like this:
    AND = "This AND That"
     OR = "This OR That"
    XOR = "This OR That BUT NOT BOTH"

    If (5 > 1) AND (6 < 10 ) then Yep
      If 5 is larger than 1 and 6 is less than 10

*>  "How do I seperate command line arguments?"

    You can use the following routine to seperate anything in a string
    variable that is seperated by spaces:

    DIM SHARED arg$(20) 'Max of 20 arguments, increase/decrease for your app.

    'Set up string and make call:

    TheString$="This is a test of the EBS system."

    NumOfWords%=ArgSplit%(TheString$)

    For x%=0 to NumOfWords%
        Print arg$(x%)
    Next x%

    SUB ArgSplit%(cline$)
           I = 1: arg = LBOUND(arg$): inword = -1
           WHILE I <= LENGTH
                   ch$ = MID$(cline$, I, 1)
                   IF ch$ <> " " THEN
                           IF NOT inword THEN inword = -1
                           arg$(arg) = arg$(arg) + ch$
                   ELSEIF inword THEN
                           arg = arg + 1
                           inword = 0
                   END IF
                   I = I + 1
           WEND
    ArgSplit% = arg
    END SUB


END of FAQ Document
<PAGEEND:"FAQ.File">

<PAGESTART:"Function.Sub.File">
'>   What is the difference between SUBs and FUNCTIONS?
'>.........
'_|_|_|   SUBTUTOR.BAS
'_|_|_|   A short tutorial on SUB and FUNCTION usage.
'_|_|_|   No warrantee or guarantee is given or implied.
'_|_|_|   Released   PUBLIC DOMAIN   by Kurt Kuzba.  (10/6/96)
COLOR 15, 1: CLS
PRINT " This is a short tutorial on use of SUB and FUNCTION in QBasic"
PRINT " and Quick Basic. It explores some of the relationships of"
PRINT " variables between modules. By studying the code and following"
PRINT " with the text, one may grasp module concepts."
PRINT " Variables in a SUB or FUNCTION, unless declared as STATIC,"
PRINT " are AUTOMATIC variables. BASIC initializes them every time"
PRINT " the module containing them is called. They may have the same"
PRINT " name as variables in other modules without confusion."
PRINT " SHARED and PASSED variables will be examined. Ready?"
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " We will begin with the SUB. Variables may be passed by SEG or"
PRINT " or by VAL. Variables enclosed in parentheses are passed by VALue."
PRINT " FUNCTION variables must be enclosed in a group parentheses, and"
PRINT " we may also use VAL parentheses. First, we will pass by VALue."
PRINT : MyStr$ = "This won't be changed.": MySub (MyStr$)
PRINT " MyStr$ = "; MyStr$: PRINT
PRINT " As you can see, MyStr$ is unchanged"
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " Now we will pass by SEGment.": PRINT
MyStr$ = "This will be changed."
MySub MyStr$: PRINT " MyStr$ = "; MyStr$: PRINT
PRINT " Since the ADDRESS of MyStr$ was passed, the SUB was"
PRINT " able to change the contents of the variable."
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " Now we will use a FUNCTION and pass by VALue.": PRINT
MyStr$ = "This won't be changed.": FuncStr$ = MyFunc((MyStr$)):
PRINT " MyFunc$ = "; FuncStr$: PRINT " MyStr$ = "; MyStr$: PRINT
PRINT " As a result, MyStr$ is unchanged, and a new string is created."
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " Now we will pass MyStr$ by SEGment.": PRINT
MyStr$ = "This will be changed.": FuncStr$ = MyFunc(MyStr$):
PRINT " MyFunc$ = "; FuncStr$: PRINT " MyStr$ = "; MyStr$: PRINT
PRINT " We still got the new string, but now MyStr$ has changed!"
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " Unlike subroutines using GOSUB, variables found in the"
PRINT " MAIN module are unknown in the SUB or FUNCTION routines."
PRINT " This is known as the SCOPE of a variable. In order for a"
PRINT " variable to be VISIBLE to a SUB or FUNCTION, it must be"
PRINT " declared as being SHARED, or be passed as an argument."
DO: LOOP WHILE INKEY$ = "": PRINT
MyStr$ = "This is MyStr$.": MyShare: PRINT " MyStr$ = "; MyStr$: PRINT
PRINT " This way, variables are available to your SUB or FUNCTION."
DO: LOOP WHILE INKEY$ = "": CLS
PRINT " In addition, we may declare variables SHARED in the main"
PRINT " module by use of the DIM statement.": PRINT
DIM OurStr AS STRING * 32: OurStr = "This is a shared string."
MySub OurStr: PRINT " OurStr = "; OurStr: PRINT
PRINT " So here we see that this string is shared in the SUB."
DO: LOOP WHILE INKEY$ = "": PRINT
PRINT " If we were to pass a fixed length string as an argument,"
PRINT " then the contents of the string would be passed and not the"
PRINT " string itself, although, if that string were passed by SEGment,"
PRINT " then whatever changes were made to the passed string would be"
PRINT " stored in the fixed string when we exit the SUB or FUNCTION."
DIM FixedStr AS STRING * 10: FixedStr = "A string"
PRINT " FixedStr = "; FixedStr: Fixed FixedStr
PRINT " FixedStr = "; FixedStr: PRINT
PRINT " The SUB string is a temporary dynamic string created by the SUB"
PRINT " and truncated to fit into the fixed length string."
DO: LOOP WHILE INKEY$ = "": PRINT
PRINT " I hope this answers most of your questions concerning"
PRINT " the use of SUBs and FUNCTIONs in QBasic and Quick Basic."
DO: LOOP WHILE INKEY$ = "": COLOR 2, 0: CLS
'_|_|_|   end   SUBTUTOR.BAS

SUB Fixed (p$)
   PRINT " (passed string)p$ = "; p$
   p$ = "This string is way too big for FixedStr."
   PRINT " (passed string)p$ = "; p$
END SUB

FUNCTION MyFunc$ (p$)
   PRINT " (passed variable)p$ = "; p$: p$ = "changed"
   MyFunc$ = "This is an entirely new string!"
END FUNCTION

SUB MyShare
   SHARED MyStr$: PRINT " SHARED variable MyStr$ = "; MyStr$
   MyStr$ = "This variable, being SHARED, may be changed."
END SUB

SUB MySub (p$)
   PRINT " (passed variable)p$ = "; p$: p$ = "changed"
END SUB
<PAGEEND:"Function.Sub.File">

<PAGESTART:"ASM.In.QBasic.File">
> Hi all,
>  I am looking for a QBasic routine (not QuickBasic, please) that will 
>  let you use Assembly language code in QBasic programs.
>  I have seen these all over the place.  I even had a few, but I either 
>  misplaced or deleted them.

Well, there is no routine as such to convert ASM code to the assembly language 
hex code QBASIC and QB4.x requires for CALL ABSOLUTE.  Mark K Kim's
assembly language in BASIC tutorial  at the following
FTP site, ftp://users.aol.com/markkkim/asm_tutorial/
gives good step by step instructions for using DEBUG to convert ASM code to 
hex code. This won't work on MASM or TASM code though (but you should be able 
to convert this to DEBUG acceptable code with only minor difficulties if you 
know what you are doing).

You can semi automate the system Mark mentions though. Here's a modification 
of one of his examples, the code to turn the mouse on.

Create a file called mouseon.dbg (or cut and paste the example below)
with the following DEBUG code (best read Marks examples first so this makes 
sense

;==========Mouseon.dbg, cut here
a
mov ax,0000    ;Copy 0000h to AX
int 33h        ;Interrupt 33h
cmp ax,0000    ;Compare, is AX=0000h
jz 010f        ;If equal, Jump to last statement
mov ax,0001    ;Else move 0001h to AX
int 33         ;Interrupt 33h
retf           ;Return

u 100 10f      
q              
;=============cut here.

now type 
DEBUG < mouseon.dbg > mouseon.asm

This will send the contents of the debug session to a file called mouseon.asm 
which looks like this.

;========mouseon.asm
-a
1289:0100 mov ax,0000    ;Copy 0000h to AX
1289:0103 int 33h        ;Interrupt 33h
1289:0105 cmp ax,0000    ;Compare, is AX=0000h
1289:0108 jz 010f        ;If equal, Jump to last statement
1289:010A mov ax,0002    ;Else move 0001h to AX
1289:010D int 33         ;Interrupt 33h
1289:010F retf           ;Return
1289:0110 
-u 100 10f      
1289:0100 B80000        MOV     AX,0000
1289:0103 CD33          INT     33
1289:0105 3D0000        CMP     AX,0000
1289:0108 7405          JZ      010F
1289:010A B80100        MOV     AX,0001
1289:010D CD33          INT     33
1289:010F CB            RETF	                                   
-q              
;===========end

you want the lines between -u and -q, now you have to select the hex codes and 
split them up (eg, ignore the 1289:0103, you just want CD33, which has to be 
split up into CD and 33 and then converted into a string format CALL ABSOULTE 
can use. So CD33 becomes CHR$(&HCD)+CHR$(&H33) (&H means hex)

Thus you get
'==========================================================================
asm$ = ""

asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)      'MOV     AX,0000
asm$ = asm$ + CHR$(&HCD) + CHR$(&H33)                 'INT     33        Call the interupt
asm$ = asm$ + CHR$(&H3D) + CHR$(&H0) + CHR$(&H0)      'CMP     AX,0000   If AX is 0 then no mouse
asm$ = asm$ + CHR$(&H74) + CHR$(&H5)                  'JZ      010F      so jump to the end
asm$ = asm$ + CHR$(&HB8) + CHR$(&H1) + CHR$(&H0)      'MOV     AX,0001   otherwise load AX with 1
asm$ = asm$ + CHR$(&HCD) + CHR$(&H33)                 'INT     33        and do the interrupt
asm$ = asm$ + CHR$(&HCB)                              'RETF              Return to the system
   

DEF SEG = VARSEG(asm$)  'calculate segment
offset% = SADD(asm$)    'calculate offset
CALL ABSOLUTE(offset%)  'execute
'=============================================================================

It should be easy to write a parser that will take the mouseon.asm file and 
convert it to BASIC code, I might even do it when I get some time.
<PAGEEND:"ASM.In.QBasic.File">

<PAGESTART:"Get.Put.Faq">
-----------------------------------------------------------------------------
        Mode 13 VGA (320x200x256) GET/PUT Information and Techniques

                  By Andrew L. Ayers - September 9th, 1996

-----------------------------------------------------------------------------

The following is what I have found out through trial and error (as well as
a bit of logical guesswork). While I have found it to work on every machine
I have tried it with, do not assume it is so for your machine. Instead, pro-
ceed with caution. While none of this should cause major problems (ie. I do
not believe it will trash your machine or anything), a wrong step could cause
your machine to lock up, forcing you to reboot. Anyway, this is intended for
informational purposes only. I cannot be held responsible for the use/abuse
of the information contained herein, nor can I be held responsible for any
damage done to the person or the machine on which the examples contained in
this document are run upon. Just the standard disclaimer to CMA!

If you find this information useful, and choose to include the techniques in
your own code, please be kind and mention my name. You don't have to do this
(hell, if I mentioned everyone's name I have learned from, that list would be
a mile long!), but it would be nice.

I wish to thank Jason Grooms - for guiding my first steps into the wonderful
world of assembler (back then, 6809), and to Brent Dill, for showing me how
to do strange and crazy stuff with GET/PUT, and a host of other tips. Brent,
if your read this, contact me. I'm on the 'Net. I know you are worth your
salt to find me. L8r!

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Calculating the buffer size for GET/PUT in mode 13:

1. Take the width of the area you are getting (in pixels) and multiply it
   by the height (in lines). This will give you the total number of bytes
   in the area for the buffer.

2. Find the total number of WORDs to use by dividing the number of bytes by
   two. We need the total number of WORDs because the smallest variable type
   we can use is an integer, which is WORD size (2 bytes).

3. We now have the amount of space needed to store the area we want to GET.
   But BASIC needs a couple of more pieces of information in order for GET
   and PUT to operate correctly. These two pieces of information are the
   width and the height of the image! It needs these two items in order for
   the PUT routine to know when to stop drawing. So, the width and the
   height of the image area must be stored with the image data itself. These
   two values are placed into their own WORDs at the start of the buffer. We
   must add on two WORDs to accomodate this.

4. We now have the total number of WORDs needed to DIMension an integer array
   to hold our image data. Because the base of the array starts at zero, we
   will subtract one from our total number of WORDs to DIMension our array:

        DIM buffer%(# of WORDs)

5. Our buffer data layout looks like so:

        WORD    DESCRIPTION
        ----    --------------------------------------------------
           0    Width, contained in the high byte of the WORD.
                This value is in bits (!), and so must be divided
                by 8 to find out the number of pixels (bytes).
           1    Height, contained in the high byte of the WORD.
                Value in number of lines.
           2    Start of data...
           .
           .           
           .
           XX    End of data...

Example:

1. We have a 16x16 sprite. So we need 256 bytes in order to hold an area this
   big.

2. We need the number of WORDs, so we divide by 2, giving us 128 WORDs.

3. We add two words to accomodate the width and height values needed by PUT,
   giving us a total of 130 WORDs.

4. We subtract 1, and dimension our array:

        DIM buffer%(129)

5. Our buffer data layout looks like so:

        WORD    DESCRIPTION
        ----    --------------------------------------------------
           0    Width, contained in the high byte of the WORD.
                This value is in bits (!), and so must be divided
                by 8 to find out the number of pixels (bytes).
           1    Height, contained in the high byte of the WORD.
                Value in number of lines.
           2    Start of data...
           .
           .
           .
         129    End of data...

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Multiple Image Buffers for GET/PUT:

What was shown above was an example for a simple buffer to hold a single
image to be used in GET/PUT. Using the above simple example, we would just do the
following

                GET(0,0)-(15,15),buffer%
                PUT(100,100),buffer%,PSET

in order to GET/PUT a single simple image. But what if we needed 30 sprites
(say for a game)? We could do this

                DIM buffer1%(129), buffer2%(129),...,buffer30%(129)

then use GET/PUT to move everything around, but this is wasteful, and not
very easy to work with. What if we wanted animation? What then?

Fortunately, there is an easy way out, using what is called offsetting. We
have a buffer of a set size we are GETing and PUTing with. What isn't being
shown is what is called the offset. An offset is a number added to a fixed
value to obtain a new start value. When we dimension an array, the start of
that array is obtained and kept by BASIC (we can use VARSEG and VARPTR to
find it if we wanted to). If we say DIM a%(20), then say a%(2)=15, we have
used an offset of 2 from the start of the array and placed 15 at that pos-
ition in memory. A similar thing is done by GET/PUT. Note the following:

                DIM buffer%(129)
                GET(0,0)-(15,15),buffer%

is the same as:

                DIM buffer%(129)
                GET(0,0)-(15,15),buffer%(0)

We just didn't use the offset of zero in the first example! What would happen
if we did the following?:

                DIM buffer%(129)
                GET(0,0)-(15,15),buffer%(10)

We would get an error. This is because we need 130 WORDs of space for the
area we are trying to GET, and we only have a total of 130 WORDs to play
with. By trying to put an offset of 10 into the mix, we overrun the end of
the array by 10 WORDs! The following would work:

                DIM buffer%(139)
                GET(0,0)-(15,15),buffer%(10)

Now WORD number 10 would hold our width and WORD number 11 our height, and
12 through 139 would hold our data. We could then PUT(100,100),buffer%(10),PSET
and everything would work fine. Now what would happen if we PUT(100,100),
buffer%(0),PSET? We would either get an error or garbage, because PUT wouldn't
have the correct width and height info in the first two WORDs! So, we need
to keep track of the size so we know what offsets we can use when GETing and
PUTing our images.

Our example is a 16x16 sprite. We would like to have 30 of these for our
ultra cool game we are writing. We need 130 WORDs for each of these sprites
(2 for width/height, 128 for data), and we want 30 sprites, so we need a
buffer that is 3900 WORDs long (130 WORDs x 30 sprites). We know that every
130 WORDs is a new sprite, so that will be our offset. If we set our offset
to 0, then we are on the first sprite, 130 is the second, 260 is the third,
and so on. The following shows how:

                DIM sprite%(3899)
                spritenum%=2
                GET(0,0)-(15,15),sprite%(spritenum%*130)
                spritenum%=5
                PUT(100,100),sprite%(spritenum%*130),PSET

Before you can put a sprite, you obviously need to GET it, so that PUT has
the width/height info to work with. So lines 4 and 5 wouldn't work in our
example unless we changed line 2 to "spritenum%=5".

We now have an easy way to GET/PUT a whole mess of sprites on the screen
using a single buffer that is easily accessible. We could do simple animation
with this system. Say our first five sprites were already in the buffer and
they were an animation of some type. To flip through them, we would do the
following:

                FOR spritenum%=0 TO 4
                    PUT(100,100),sprite%(spritenum%*130),PSET
                NEXT spritenum%

It is that easy.

Our buffer layout now looks like this, for those interested:

        WORD    DESCRIPTION
        ----    --------------------------------------------------
           0    Width, contained in the high byte of the WORD.
                This value is in bits (!), and so must be divided
                by 8 to find out the number of pixels (bytes).
           1    Height, contained in the high byte of the WORD.
                Value in number of lines.
           2    Start of sprite0 data...
           .
           .
           .
         129    End of sprite0 data...

         130    Width, contained in the high byte of the WORD.
                This value is in bits (!), and so must be divided
                by 8 to find out the number of pixels (bytes).
         131    Height, contained in the high byte of the WORD.
                Value in number of lines.
         132    Start of sprite1 data...
           .
           .
           .
259    End of sprite1 data...

         260    Width, contained in the high byte of the WORD.
                This value is in bits (!), and so must be divided
                by 8 to find out the number of pixels (bytes).
         261    Height, contained in the high byte of the WORD.
                Value in number of lines.
         262    Start of sprite2 data...
           .
           .
           .
         389    End of sprite2 data...

And so on...

The only other thing you need to keep in mind is buffer size versus sprite
size. As noted before, a 16x16 sprite needs 130 WORDs in order to store it
completely in an array. When you have multiple sprites in an array, there
is a limit to the size of your array you can have. This limit is 64K - 65536
bytes, or 32768 WORDs. To find out how many sprites you can store in a single
array, divide 32768 by the number of WORDs required for each sprite. Drop any
values after the decimal (that is, take the integer, drop the remainder), and
this is the maximum number of sprites you can store. For our example of a
16x16 sprite (130 WORDs), this works out to be 252 sprites. Take that number
and multiple by the number of WORDs per sprite, subtracting 1, to use for
DIMensioning the array: DIM buffer%(32759).

The following table breaks down common sprite sizes and array dimensions:

        Sprite Size  Number  Array Size (in WORDs)
        -----------  ------  ---------------------------------
           8 x 8       963   34 for sprite, 32741 for array
          16 x 16      252   130 for sprite, 32759 for array
          32 x 32       63   514 for sprite, 32381 for array
          64 x 64       15   2050 for sprite, 30749 for array

If you need more sprites, you can split them over two arrays. Animation and
such becomes more difficult to handle, but it can be done. 

Also remember, the larger the sprite, the more data the computer has to shove
around. Stay away from the 64 x 64 sprites, except for maybe big bosses or
such. These things are memory HOGS. The only other limit to be aware of is
QBASIC's 160K limit on program AND code size. One buffer of sprites (252
sprites) will eat almost 64K, leaving you with less than 100K to put the
rest of your code in! QuickBASIC and PowerBASIC users shouldn't have any
problem though. Some of these problems may be overcome by using EMS routines
to shove the sprite data into extended memory, though.

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

GETing and PUTing without The BOX:

If you have ever used GET and PUT, you know that when you PUT, a "box" is
left around your image obliterating anything under and around your sprite.
This looks very ugly and unprofessional in a game. The following shows the
best way to get rid of this problem, using a method called sprite masking.

1. First, for each and every sprite you create, create a "mask" for it. This
   mask is the same size and shape as the original sprite, only it consists
   of only two colors, 0 and 255 (or &H0 and &HFF for you hex folks). Color
   all visible portions of the sprite (those portions you want to obscure
   the background) with color 0. Color all invisible portions of the sprite
   (those protions you want the background to show through) with color 255.
   Remember, you need one mask for each sprite, and this will knock your
   sprite count down by half, so keep it in mind when designing your game.

2. To display your sprite, simply PUT the mask image down using the AND op-
   erator, then place the sprite image down using the OR operator. The AND
   and OR operators are called bitwise boolean operators, and have the
   following truth tables:

                AND                     OR
        -------------------     -------------------
        IN1     IN2     OUT     IN1     IN2     OUT
        -------------------     -------------------
        0       0       0       0       0       0
        1       0       0       1       0       1
        0       1       0       0       1       1
        1       1       1       1       1       1

   These tables basically mean the following. If you take two bits and AND
   or OR them together, the result equals a 1 or a 0 depending on the inputs
   and the relationship between them in the truth tables for the operator in
   question. If you understand this - read on. If you understand this and
   are 10 - 14 years old, you don't need college (just kidding ;).

   Now, for what we are doing, we have a background of different byte values
   (which consist of a series of bits). Our mask only has two values in it,
   the byte 0 (00000000 in binary) and the byte 255 (11111111 in binary).
   Let me show you how the magic works:

  A.   Our Background Image    AND     Mask    =       Result

        11110110                      11111111          11110110
        11110110                      11000011          11000010
        11110110                      11000011          11000010
        11110110                      11000011          11000010
        11110110                      11111111          11110110

  B.    Our Result             OR      Sprite   =       Result

        11110110                      00000000          11110110
        11000010                      00111100          11222210
        11000010                      00111100          11222210
        11000010                      00111100          11222210
        11110110                      00000000          11110110

  If you notice, I have used 2s in place of 1s on the final result to show
  the example better. Those 2s should really be 1s, so don't let that throw
  you. Suffice to say, if you look carefully, we have placed our 8 x 5
  sprite on the background, without the border showing.

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

GETing and PUTing without The BOX, method 2:

The next best way to GET and PUT without the box showing, is to simply not
draw those pixels in the first place. The only way to do that (short of mod-
ifying BASIC itself) is to write your own PUT routine, to skip over any pixel
of a defined color (0 in our case). This would have two advantages: Number
one, your sprite could be drawn faster because you only set the pixels you
need, and number two, you wouldn't double your buffer requirements for 
sprites because you would only need the sprites, and could eliminate the
masks! All sounds good until you try to write the thing in BASIC...it is
horribly slow (ok, on a fast system, it runs at an acceptable pace). The only
way to get around this is to code it in a lower level language (or at least
one that can compile down to a faster version). I have done this, and you
can find the results of my labor in the ABC Packets. It is called the Blast!
library. It allows you to do the above, and much more. Check it out!
<PAGEEND:"Get.Put.Faq">

<PAGESTART:"Error.Level.File">
'Add the following declare statement at the beginning of your
'program:

DECLARE SUB ExitWithErrLvl ALIAS "_exit" (BYVAL ERRORLEVEL%)

'Then to exit with an Error level contained in a variable:

Errorlevel% = 1

CALL ExitWithErrLvl (Errorlevel%)

'WARNING: DO NOT USE THIS WHILE IN THE DEVELOPEMENT ENVIRONMENT IT
'WILL EXIT TO DOS WITHOUT PROMPTING FOR A SAVE.
<PAGEEND:"Error.Level.File">

<PAGESTART:"Error.Level.File1">
'> I have looked in several books for the QuickBasic equivalent of Batch
'>language's ERRORLEVEL command.  I couldn't get ERRORLEVEL to work in QB
'>and I am wondering if there is a command that does the same thing. I'm
'> trying to get QuickBasic to take Errorlevels from a program that I am
'> SHELLing out to run.

DECLARE FUNCTION ErrorLevel% () 'Returns errorlevel of shelled program

PRINT ErrorLevel%

FUNCTION ErrorLevel%

   'Purpose : To check the error level of a program returning from shell
   'Input   : none (well, helps if you did shell a program first)
   'Return  : The errorlevel returned from the last shelled program

   DEF SEG = 0
   ErrorLevel% = PEEK(&H4FE)
   DEF SEG
END FUNCTION
<PAGEEND:"Error.Level.File1">

<PAGESTART:"Win95.Long.Names.File">
'>>> Page 1 of LFNLIB.ZIP begins here. TYPE:BINAA TLEN:20669
'-------------------------------------------------------------
'                  INSTRUCTIONS FOR DECODING
'If there are multiple parts to this file, merge them into one
'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all
'message header and footer information (everything outside the
'">>> Page x of..." lines),  load the result into your version
'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original
'file will be decoded into the current directory on your disk.
'-------------------------------------------------------------
DEFINT A-Z:DIM SHARED K,S,B&,Z&:V1 'Created by PostIt! 7.3
SUB V1:OPEN "O",1,"LFNLIB.ZIP",4^6:Z&=20669:?STRING$(50,177);
U"%up()%9%%%I-%O7dpF3Z.#D7'7%%P*%%%1%%%%qk%shwj%fySg7fxFx8,tTU19L
U"uwlx<Ha,%QEp&g+#w7Do[e;ua+YWVy6tAXpHQNF1&tixME7WT<[DhMY=Gu#6pQd
U"h=mh>-rJ8dBr+X+3A]I$v-z7f\.i+sV6wSNu#7k/\A1t0?&P$ZpfIjZsIIkpka[
U"Q.rXyz%,L2L'Ub<K#B66^IOgSdh1/jC?.sG]&JM/qjnmJvuW8&WieJ8jYP$Tb92
U"h'UHu.Ye9b5N>';WU<=9X'<6?.V:rH#hEmo(PlUh[HMroJ(FUxYnJ7lh1#4;DcX
U"pm]qN1n[QxRo/nb*J<.s&&mJ73'y[p1ihQI4$Ify$Aa9_iCxoBjZfaou);I,+M1
U"Cw\DdvgF(V#.0CM4*5&%HSGpT&6=V&SsS9KBB$.dpDOYPGqd68'NsXcO=l_r(jY
U"8+0UjNDEQHkuv/f<7i\alC77s:qkbE-oRrkk;hG;?(Q]BWBwefL,Pjd1&LI2F2#
U"/i7$V>O+(6xOxIO(:=Gw2uWZu;IOetoO66/Sl00fOMT,v-hT';&)muJQFZ:iJ8U
U"=#V%:'taJp]R-c)Sz/S:^jn+AV#GjNlC2mv^.Qpi2&HZts3TGz3VL#4ce%g6R6F
U"kEnIpd+Dp2_XG4t#[=Aj#LBTps5X#:G[UAF/HBWm4pAL=.Ag)t'H4n5ZEh<TY)^
U"2D;)tNK3M[1lS(+vC-GD9aH0?=zjQK(sd3QS09=lpMW_i?^f>#ss9GNgvHtYk\j
U"omqx)_T<[E(.:WswnU8Q]w$g\58np2D5+uK%He3omEt'$LN^t&3k36c_W3mP&4k
U"M'h\up%()9%%%%-%*+/pFLYF#M&r%%%'f&%%%/%%%%qksq%ngSgRfxf$7V/;em5
U"jx=mz8*IC$G6(%m:HI<:MJj^*4J?Fg:g<t;ef6qOtYNMSDes+5j-c9Qdx4<u8o*
U"%g#,_mw(]NXiVhCu&f:S1L,?gTBBX+Tr>e(IlD*TkB^=q0>(X#KFM[tq(<R/sw,
U"B#^_kT-UphCvN3waf(m%ws,E';4BsvYcENTizF.TElkh5WNBKziu9P*w-=)ir84
U"pCll&>up(%)9%%%%-%2&7pFi?dt>o%&%%q%(%%.%%%%q%ksqn%gSgnVdaV:];U5
U"9TX*xVVJ?QPdDtJQ3\)D9k1UC+?$Q??i%\++tdwpDCltzY%]MI^rgM8W%JhE04o
U"[?7u?vWI&K5WJ17W8ic/,^e4jG0TF67j$oCw:dI05(3:[-)8VV+e_A0z<>#Yh2n
U"(FcgDieIyGXM,B]gNgaSi^A</R^kk+o:=U;65FdW*A\*S2iM>[Y^ATIC3ZR\c7[
U":6[9df)e$dgiATnB[iYZ0?'.$a\F;]qBldjjxMjK,/l2M3.6QD2OiIofeQA:;HJ
U"qJ%mTv%Rd&jKMTJ6'*+j$^PZi7BLFP#P$X2.-O_mmXgt+'H.[s[n_PEPm\U_I2Z
U"Le:K7RO:g%HM[85d&vsZ'lLO\MlvAt*p#(LR1(bzfqP<)fiq/wqko2;fA-ipQok
U")C6nhKa'Jz9Hi#UqzVW)uWJ);Nup%()9%%%%-%)V0pFc^kJ2&Y&%%&y)%%%/%%%
U"%qksq%ngSnIsk\b1f>rU:5ThmEuV^CLJ%YAWb4>\:)aK*]<?G.#l)89YdYC#X[C
U"8.*TwPL^GDti5mW[d.b(83[=gocPSK,(l8q-G%$U3RWd4*Ico6=TCFS](A66ro?
U"S&%ag);c\Bb%v4*U<g<S;9Q:MR1..4ci4&fuI>5Pn7vnCF3#q8^]/F$%rQ,\F0Z
U"?pkS6YX,q,)t5bCpMK>1%2B:iikDkXuG8Ef>ME3,v#*VFP&\i-[n;e6c/0;4/4Z
U")&NR]Xru]W,coo?=NQ[Znv7'SAo_sVq#>^*pHXjjAN#FN.=[nEf]h%B855aa#qE
U"=W]F$/Q/0P?211V3+Q;R./R,5;h)o%Xfn?T?5T>;u^f2)0$gHb*tZHA-nma7CrW
U"jsJc0Wi%BdEM,UG%R.eZC<h<YNtMqyvQfO;_J#SIx]dOnF^ia79[lPk#7Jw$/4p
U"izx8/a6.GDd\]q07YM7XRc('Ady\q:l8=A;mh*h1x&6[_C<H3[Hm3f-mXn8?3;u
U",%up()#9%%OI-%t8.pF9B+cd%7%%%pU%%%/%%%%qk%sqng%SqngEf)2Cjy#D7?,
U"Sx:8aeuH0=8aUV/_r$=1:;k-KghOWK9Rdq-o?;0u-_2g7eSeF]/5U%uCP^&sd^Z
U"-VYrm4MB#AP]dkw^NDz3K.UH_^8QBuXxP>gU%%uRSxFQ1tJhE7,vNT]AEt^kKg^
U">66W5HXcp4Xpej$FWFl<%AR%==MCRrEDUj=WYl.Njc>%MM[iO>=EY(N)8]CSL9h
U"M:X06;hz]B4P&)roLv4fR%%pM1NHtHHeSw#MU<dK4bedMcDXY[PPaDmOWxOF+>[
U"5[ZXP^%%Q.Q,4(>q=vLCb?bQ.(pPJuw^o.*oKhY=eqp3pfRW(uOTvKe1gM04);:
U"J]q;vKF36h4[#CLwr6cN_X&gznV7(R.4[lRTiH=*6PcpD<t]:ld:K86UF>S<q1O
U"TQcD=6--K[\4pw4UBKfut27ofs6Xt/o2B7oq2%Xg\F4BpaJ.(q%k,H;jPqQkQ^e
U"&b[V^<%R_Dm-d1O,:hu^QFGf/\.f,\]U6Ou89p#M3cWL<F&8Hs7?Z%vYJT8gJQ]
U".K9_tA-bsTpyrkh)D-nS-yjD$r<zw:e<smY<7M)Nn8zKlnbyHWTiGtWTQF%5arb
U"D:*jG+bjH)X5JYg:FuqsBdYOY)/uMLd\c1$gF*?cU'A_q3>Q/T)9IM?T%(K:R>'
U"*-5Z#)-se?jxeA\JjM%tfjsJ0fo8J&G]te,TyXVdThdlN%x(h:w*P7MRVwl,_0%
U"&%wI:WN<S+Z,*3-?CFB#c/D&)l&I.buFFlgK+'KNhE$1tBg4&;\TjPr0I<e;VGf
U"Il+wY4u+?iQ3k'Vm;,Y^coX'DD;)TMcf#M2Q(FC);dMfddJ\xWToJe:ce8e<Rb*
U"*[*DTA:m.N]tNF99of;L9)G1uDC;/#b&l%I;[-'/-?Wr*A0__FSR9kJG#O\s[*x
U"]a^)L)1dWkHhPD0g1VkH.KerioM%?h(4'_e&:IiRzJ$#55>&=mrK+UZGs\R;G%w
U"S&waQeBjPC1Th1M6U64;O\^L./s\M4Z+yYdV*FLQ[YiAq.vB9M7.ke<vJMC6Dk,
U"-J=PFF<1>]5w<3sW)KOi./.(*Uj/GAQ\84DS%hnIKqa;VLi0ytIFP7/G5%ZkRp+
U"5IAb3?=9uX.e%UY+G22FgH#n$Q$ScBoW--<6nM;#i/azdq)g;5H5]w'o^Dq1dt/
U"PG;?$LQe9g#>wijTZ<9e5&iQRd'et9_$^XR#Dbc9HwgA*vlD&BJKP)^?NQwiLLG
U"Xu/lanVC.4TtX+OLhyKXCOy2zB?$DPXSo2xLb<k>5(sW_f6r&;+ehB*A;wRk.qD
U"6]s>TGIMNI;Y(hjq'-C>Yz*tsQ-.hYLFQj/evqiOBcRR4sEo6ju[iVSJb<rr;$G
U"4H5rH+\L67awA'SFI>ciG)u4;9*ce)\E&_j+V9(yrsJ);=kJlGQEQPLd-fKu.\y
U"e0Q2er%p,&j+.e&k-7L'ti4Mgg.9'vlqk#Et3-,ZMaK1LT7dwD,HM+O>V,<QTi,
U"rEL?OOkGL<iIQ&oeXJIN8Y%kDB_#'8RVgR^7s4;s4^7^mi4Hf\AFbQ\1J,8m9$e
U"8+ZRFV^+]0/SQqqMpXa</E(]Am\2m3l/=^AeZEKF$H<,h_3<3RAM7eceJJ<BE(e
U")5Qjv_R.?ZttV0;j__f^Sk-(rEf'G<kJ0h6c8P,(ZvW-/1_D$aDciWbtbpuB;O#
U"5p&6O-OA1:1ejT+'850;,rj,90dhw1GV9x]3CWgyXX1AsBOh_k)9l3;%Dsi4'Ig
U"=MOSpB9Bl*'=DmIiYP5^Uvl<TPv=*BMK08Rsf^SZ8j8kS[^O9Jy&q7bXI[P#ZH9
U"aZH=\/UZ)nB\>1UXI\N1NpJe9,H/yc>'r=JC?-H&GRyAs__AvMsWdYIRwR70.rY
U"xe:w+SU\d=RNZC?g&09[IGrJo:Edy#sHS3kxQs*iU]?*7u6,I$B2;srdK9=w;^r
U"SCK2P.T\+(,WB1EQHrX<l.GNQRQHArtkd7t*^x;yKKJj-/NNi>p+I'E-T.EZ\lG
U"8b.W9&S\pr[,R<ZdRiG+dW1PHFGYs<YR[s2[],Ab)_SR9WN&(93%x,T9&HIHH*=
U"x._.&T&9bzwR9-R=c[>GHN/+-_',yQ-]FDG)%KH1#Im;+CaM_fUU)P5fF8bvA.k
U"Ynvm<s+/')-8r(gl0eT&ry+a:]j]7<0Nbw/0Gt&8G]5%NQF'J7YOSYHYpDN/rin
U"X-fthxPxLcW%xR+yJ^Pay7c&S=1yOS\lRc-9ZrZM5%PS-dL*]1gtT(2JPx(<7T%
U"laD9.wV_SXk0=fl\ssK3Rw\;98n\pINVcccskB3,HBh0G]KLOu0tMsr.ILT?_Mg
U"4y49xH.-uIYthLUU2Dq1HebjIP)*yM)LDHbKv)&6*M?Ni3g%*EUwpgR4m6I=?'-
U"GKJTycc\#4ho_J3oD\LCT8mTR$pOj7a+2mee,9Ymqvq/l%XV;XLaQ.#;Q7DBHX4
U"DHz_MEK0;'OBjRosmff>aj;v>msJF,H?D\,Jjf$nZz;TPiI+WGOSsb*Kx2hCj^u
U".^(<YWbs\aELyU:BJd67[;x)2W4w4.>)t<ykULU$OW\4ar1c&>*TnvXx1n3]HBM
U"\Ej,uLYx%Wq/T=&/99F(jWQ.A=SOdDvdA)m7xI$SCISfM:<3?AD0/4L_qO)F/KZ
U"UYkUR+6SM9AEG/j)v[?j/,ZhAV?iuh_<uE/CIFAq-K&KP/k92:QiZQR$b1t>J+s
U"ddXG>ng1x74e0%,An&x#_^2Diqr+B3*BL[s<zg_k=,1+CnUQSmAnqaoUjWElk$m
U".o]CcbfLZ'C#'?n\-X950c:\Hp.?,F4[rmBv]YT_U;1$#6n>z9Fv?Fh([^%%zT(
U"W0?)<X59Yjon),*]k4Ga7q9kQ.b\K?m/A[%\J%phhthR(M:.e5/;2)#6gmCQ$>Z
U"n;Dgp#qwP*q#30C),5iwFK::D^HlpkYF;rf,oY>*#8[:NETtPGx_ofsdt*:;480
U"8H-dm3FpsF#NIV<]%Wv47hn#j8AY<j)AQ[D5nWvqYY1NKJu:2P[40C9>QNc/Yu&
U"<Q^lcnH^8<I>9['D<jrg:eLZ^Bd3EW,m:B\N2M8'z_pWw/F4ZN:Jus>NchH-.6&
U"8zrRUV?uBBkZP9BI'?&1b+,P+nRi#(sDah<;.=G+cnf;uR%/);FTovQd21yX*_i
U"xG(ZTP#(M]J7GfPrmA.]'s$/6Dq[IHLTnc9+p>?M=3]<N8H[0T7[CfJ[^_Qqj3a
U"DK2:L?4Nuoe6I1a1YL7=3>)UAYZ)&UGFH,^=jPsrD#-L%V6XKshuHJd1<h1W(zg
U"1+H+>.bck*_]%Kn'uuT^\hwhnti3S.RVl71oJ*+CEru3%=JuxeGT49]_Uf&48e5
U"0qZ6O\>d=SYZRs>7&pQB1XXov/]<mf\hZR-Y3eq.4[LWbX52cXGW$JcW.kJiA\g
U"zu3'I7#kKQ1IFR0\ZZ2/]>m6q*b%*M1Rb8_5Ju#jqXAYfoK#iEf\Gin(RSAOCLJ
U"JRXiurq;X4=It#k)XHw:ZjC3,\#DABf(Ql[Go8%U[sq4V\[DAYUNq69Pif.0ukr
U"*NuN\:^KrJO#r7T9i%Bqy4H5[:,4ff-5\^3ww*f8qEn$P7ex4idG](;f]e,ttUS
U"*jB/lXAYZWr0T.GV0fs)Kdt[?Rivh?r=%qjVm3-%W<MI+dt1='LTWEk#(lHUnYl
U"I7>aEn<.kaQoQwZE\%l5]SEQIWxdi/%wEozX%7L>d#<0i*7Y5b_['nLh=-d-#?t
U"zg/'[AMur[E+OHPh7GG0KM[zXaKVv$[4O<qGN$G_]=Wd_]=WdR$h\SiNupNdskz
U"64#&E.lgb#TbmP_*X<*mYLmco^(8mfF0>fgF]GDa:0Lvp6)o(:lS3QfjNL?jabt
U"1W<[n9<*NaJ0'BIP_Ap)U<GoO1gJ$44CJrj&qDJIlGK+Wu?\cReza:(*XM9haUB
U"flF[Uj.S#1eci<1.W14ni;LKk+a:d0Xqv5T,w:dDF-cmh=Fq$97y=W'KFDsnUVR
U"L^P\j5-^9<189,Tve0DIg]=Uxqb_-qD,+]r7*ritQ$a,0Kt'1)[S*PZi6c$Bx15
U"I4J/U-(;]M=UK-1BQKW\=mcP%+GB*96(t<'l3+HVwjZli>pXvh,T1ESJV8)0*B>
U"BiOZG__Vv7JHU90Hex#BX4FTAMhE=nxV]U1jW5]Xo-Pjw\]98ysG:m_E>_Pj$fm
U"_-ceMv'vYKLtLc&wrI]p-N6$6]hiDg#-Q((&uknVE::lfw,JuIdvU>]:p,%a+q;
U";.8e4tGJKTqDN9J=.BA[W$$D#Wiz,I:X(v$W0iNZFmxr(ovhxD7S,t8h+]qW(:F
U"ujf6Q5sj$'BL;NYhIGm[$X7(h3A>rs3AVKlXLLh&r<56lDH#Y_bcO9$93jMGU:M
U"].U?+U]w6ooRnAj:i-QIHA[-[E2,\Zjd3RkP2mT21rQS]U?'hZ;YC?9mbA,T38v
U"^4^aNQ:ykdn,oXg&2G)V#mv9V<Ah?CZoX1)q-'m[0#h3gj*%tMN/6)jbT:3o4c,
U"bqpq0]aw;V/,M7qXouAKgGh3vK?W8jHSv#jHHu'#$VR*b_[%5njrR[GXDJiKM#M
U"Ozstg?et0K&b^^Y[S;5R&+se?u4iNJn'?JQiJ*Y?U]1b5;lfa5#Y[$mW?Cp-o0g
U"2%$=<Aarc%RWt^Gq*faJ.HVx6UPH&G3JQ=b<fq#g[dALo=JE%n6k*h8FMSFR;Bt
U"]&71H\Y.p<bQGwb$GKZ%Z:NR%Dt*0hXJ3]Z.(\#fUOKIYoQ_q+\[5DZ1&Qz0mU$
U"pnK:;>)JXQ049DKW'HLF4Nwmkdp<$k3bYpvRa()Aonbn0\9joPgd+tU8aj^TYOE
U"v,GOR)]m+]c*6[xB7fVtG-6nJ'*vZIo-H>kG5R(-CQ'IrLob46a+)po6W^=maD:
U"]D?7cR''1V.%m[%WEu+2=]2$6/OQu(ZYJPC\e-^Z(;/X=Gx/rMPv$7pgrMzx=mW
U"=e]o(6PI1.3cW82-Ib6aSk.FR$ITNo$84Y%%Ih8*37Bc)A*g$m=TWi[;qgb[W0g
U"MeL->Z.k&VspFPb$[1PI.6zia)H71#_[4-[EjA]GYqVdlrQn<ilsW$nCjet#pOd
U"OAY]eYhG$$OuT]Lj8Y]NLM%MB2BUt6#cFmw=V8rNn0v.Yecb(EKNbSCeJX?ewBe
U"YGl.gmBr#_w,dE$g70;q'go65*B8u+m;i:G/rKka?O;=4$0/gavTHDPr;<%_>,#
U"VB'9>:S15F&1vx-='&,[La9Ah]A%xqaMV,V];%l;86ICwRx[u&S'+og;8JlnHQk
U"7x>79GtK>_N:QiGnvWG,MHmWdq/b8pO'YZMF.n0\H?8]nAj7$:o&rttJ^M/G#[F
U"s?t%ccR=E7chP7I?tl^U;lXP.hXn0e_mj%XyK97W'Pb_%MYUCEwjiJENC<MP>i6
U"C\+]]o<WQ5Zo)E*2IzsQ'#m5?Q.1933^DUi&Xu*i?iDSS43iK4CZ)KW,Ucy<=6h
U"X94-I#h8_wLPXokj?IMskO\P6\Df21xq3e%I399d(sx+#jE^SP-H74Swb/nRKWJ
U":X#degQ2'I\8b8#5m?v>FaL5i[ngKk#zG2LW7;5AiiiVPaG5oi6k\DdM-:ds/'Q
U"KOtCpn\hMnohgoh?:)a6/d$g?gFLC+thY?(IX7$Y18<p0%6Cbi:B0[cM73w>N*T
U")=xzno1OGkak0s#W=,x].%4V(2_r:U'wCmjt-(ue5&6-UrKbl]:ed7Y*B8w;q+?
U"o6arOMq21U#.i8\T0#[?L)gA>#.==V/mX>(FBl>XHo)40v:>V['g%VIUB$4j<>m
U"HqU7[ArK[PtXkuj\axox2k4Ry11;#e;qSaN)7rn8KS9%+[D3W*Kq_LRQKbg$%dq
U"%0r%TXPQq,9u*id%up()%9%%%R-%+/[pF_J,4Q^%.%%6%%%%/%%%%qk%sqng%Sr
U"fprl#llWjCKBnA1_^j'+L6e,aRY05E&da]T^A]NV):Kl4WS_BQbu)Row&n]f:'A
U"?.DN(dF-,%%up(%)9%%#%-%S&7pFj=\':0%>%%-%T%%/%%%%q%ksqn%gSvq4gfi
U"0tCMN.Zxp5M(XS=H;/KJU%'k)#A;gGQ,?kA-Ig=a_4)=[F#>E5aACWXoBPkEY(s
U"N5QGG&s8o(4-&_^%jTC&(ISgmOG5I-mH,:p$K.=h2UeF62VB?8$uKR4'ONt>Ps(
U"<n.ddWB6oHueXWtuelqvCWh>B*hoIwADPM[,f>iY,w^+_)sZLGCB\GZ'bcUChsP
U"x9U3Y:r//6w&cD:/i^QG35^--+84'hQ%n7'4:Cc?=k.%f?Ce++s,&gQE;KU/UR^
U"I_,_>Q>9*%C,d+$dPD5a/W)h5R&o>9e*tfa,1'm)IZN/m1'<:&7U&q1(H/S&'1C
U",kz9^:bIY,(nQ\:t//P7+PJ:M?C9k)67e,1'9m+q'YR9f/#]=2a09)_*)uR'U14
U"cRoBY+tObv9?i+aQ-[>P0:,//#7&hnORY[]]*G2QZo8(=\;x#Y='UVQ$Y-%U3a-
U"6+9CuO%_PAmu.UYF.i9'((m,#9:Ki[LU/]1%eQ=)H[9uog5ha*))qEDREH^O)ho
U"1a+(W&D8Q=RDkZw'mE#qde[C,P9]lE%7:%v:EJx$[YIf.?PF<9c?1.CP]/xXeCX
U"',:K%u2C(LtRnOb\Y2iFcQ3E;PLY](-QpEp1[3*m92[9)?_-C+)RE<[Q)ZY[Vu4
U"O8P<:P9Yr)>A;(ROSRhY^9YTYQoa)*s**CP=7.w9I7U0E&dd)::st:(:[lE-wC0
U"K2[F+=,=('%U;J[,8/O/)R1]Y)zY+V)/aa(w2ua754/8Qki.I])]R0De6A.pv/U
U"7=/g'PXYM_:+A9Q7U,USQlgp+#u%;PLDPnOF4:c?77):*PoPH7[%='[T:MiLn_G
U"cKqe^+:%QU<ybP^euS;%(RNXQ%?C9k'NL(0?bKGlFOBtf;g#&C*ZK:ooQPf9:o(
U"6K'c7,fI&4+aLYa=U.?/ONo'_GP45.*'o2AK.SQOP97OD>?4g=%K9Y%u)OeaRq6
U"q^VGCuFA5&M.0'/,BQ03Ou\YHYa1a%<84soEi8J_X=bAhC$]F4ko4,rV:h<Y%d]
U".QYa'q+a)DJMo:eIexjbowW\cgJ3EB/OgL*qDlVcohs(i_/K7(#A*9d1IVGea3r
U"'u(hLKF+^O*>/HU.=$x)/;)>&c>MnrAo=1%s_bx8lwXKFS._Ve[$bL<89JCp'*K
U"<KY:fOWSKY2^$+M*r^l/Fn<8M?h/(^HMevIK$cnftKeeIl8ei_xN5EkPDGU6oAY
U"bVhPjz4N7B'i<>plLfcrV,joJO.<^Vq6F0bn&h-rr;:OuN43gks.G06(.l)>nSv
U"\E\7u<u#hKJJWK^p.b/dthLz*3KS:9TmEwjgptRH6EsMH_lj$4$>Yj4wugvgq$X
U"tR\?nVj<:GMDd=;x02Q1rjMC<+9<scT2OTNrXWd&\Lln,(Wwn\Aiok>=O0_Nr2Q
U"kGnO^nGXl+KL0W%etILpVGFLe8#blzlr<%TmNgb-AG03qqNCsGTwhLfUKKK3Ov.
U"l9b,VQ(5;wvK8-#xqotAEprscjXabw6?#R4w3ru6AS&9$p=Q.>n[#h<fC-Qv31A
U"*9'^XKTvntr+EIjCX&$>+0G^E47:4?A./TWe$+qjNtSkrb=^L:u%3:QOS]E%P0r
U"4'BAiYatoZTp8TTI\M0*C^vjM.6Yf-93u%a;c4&Aci/Aw(l87%_pvo'#TCvFY7Q
U"I\^EE6$wTS3s;0t,Y.d=iP$'7jz_ut-TR8vbG'uZ)Vh19T.JA:<)]Ep^^?aJKG?
U".N#=B-PHpEVD+0YVq\l6nGxHl%9HtNcRDLrhNR#tk;40;^SK+%G3p4c=<eoDrLf
U"aki)A.CQ,tNvb\skE6YgO3mo:1)'6n<V])03'P>96:9o:/aX<o/Sl6F0hZR)p[O
U"Yosp\L%;_:>n&.KdwTeT&Ne<Zk4JVVk;dm6QV:pQ/>jd5K*pSoajD'mcRp[X+&S
U"iJ-?2:r7r)^tz<ntNbzridp6497'Ef&=H;sP%g29EpHjs=Vv,b^cOp[B:/niZ%D
U"DxZ#3^?TP9v(Z)IkdU41NJit16vEdEj%Ju7j3_r4J0nNmY;7G<#H<hLu5UYQ6n6
U"5\ifG9uJuD^l:qj3#q14OA<7LgG$AKq$+.)_4/X_)>(<S[h/(soA9CNNpG3x[l/
U"L4:0v40-$30BiVT<VVTrVTOT-Q9<TIf6jPHfuSxXl?677iW<rilJp[tXr(7uRtW
U"mk(^$[Kb&ct#tN[eK+b0gzKo:MY/cg\bv3Q]F3dIai&L0tFI8C*1x/Gr'p*tgfb
U"M-#YN>TLA2C&&dCvn$J&3dfa>SEvNFx4uP&f3Dm;$pG%:0rU^fbYHrR%/#dMdjJ
U"diuY(t$>;j0DMNfKe6q9V6plAeBguC1S$<IBSFhK%=e/fi_&8:oHnefg$gXmu//
U"T(*NEm[2tw6BA4bQOTr$-5,xVg.bCm2rf4)EK(VXukXnNZJPPx9W$BZo7_7>TP^
U"ml-Is'.ngYTj0whmpNP]GCn>9pLtD#O#;[?QbtnV7',]\<Gu7./<bL\]Q:$gW]N
U"s6r.FAP>FdDX&>k#q*[^];4Up,rt^1n\*7Y]W4/?r)/Rp5MQ4'8t%M5p:.*jxnD
U"tQB,,GQ5'TRm60#80T'1mif60%\W&HQfX\b;auHu^FShBgP[\I%g3-<^?qn&A*e
U"2JFkt$p].s>UqPJ(1N<#v-oYs2$UtL5ti4$J,-2-B3C]eSAgpSk3_sYv-hZ_hp;
U"uStpAcEUNQcxFNLZ'Rx8?vpxfBSWfNlNrxxM.knqu*HrrfHa[\]uqpbnM;rMfxb
U"Haon=5c?uUor-pjMofPAY>nBDG,8Vxpuuqw/RZcRse>b&/P[;/2eexi$HPJC&F\
U"Arn$<?D/Sd:L/V88Zpoq6kr;Hd,z>&c_YO>[fnCu&qh4$Uu:xPlYX$mt/s6KoeL
U"ZUb3??^(J:tP^8Kf$T2'hAabs<N:VI'n5<hsfukWL\9nuFCbr;msz6$Nr3]s3RP
U";p_hdDf;FUUuAV84V4P(+,%YzGv+i=x%bs6E>)?0d$c3T8.niIfJ?PVD<.^EPch
U"hH.,#Diap:);f#o4_PIt<#jN_jj=KZ5DNJof&$xwWr$6Gaskk.j?<0&1.i)PNBp
U"n7r.,gB2RwWaYkmNl3Iao)rHb()WL64Q&S)tvbK<vn?uS3xP9g4hVg0xZWE;fb&
U"h3RXbvM7]C_w;msv6$MZ3lnD2f45Sq9h2Q8lHTJQ.c;nNEC7h+^^P^cfD2s>?2f
U"]WOoHJNG&FM=rB>Zf/p#<*OItZoQ_N3IPG7$hhb9V#.R,#i<IAL$Tw;aXz\GXF.
U"8HfOZ%kvH)fw*[]+WplKkjdY*mdclMMDCl1M?[]1yiK[coLWF,bij<ab3V2RD:<
U"h+#c%=xGJH.gx<>u,<.hTtv]9qjw9mu#VcBFr1akDI]/Zt5R#uNBfG]hs&4)asf
U"y[<Fn.Lg\,GDCQ;9yWxp/xT<K?naHHJnamkCNV0KjTiqU2hR1PRx#YYLw=V<BQ%
U"bJ.tiXfmgD-vqOSv,xm;v?[)L^eH1Czk>Tat'/\-fhk*EPS#]36_KqRbU$lnPrg
U"1JX$9>>k1LZ,?<$CQ\=5>_7LMqssaH<I+C*.E+bcq6$TNtAjxL<dC\8l09njr&b
U"[#K\<[tSekX8,ea9=xL>L3MLSCH4KdO,1Zq_/dU$mKxRl7<FkV\jBf*Xk1hl-t(
U"%1F(\d^qEv>/<,+HN)z.'Mm9_P-Mwv3Ipqk:HTo:[ZO9SP*MW49TwM=:jpfj,\J
U"9/79Z?ulavq?S'/6,0M]Wg&>9Z3>pIDj_\#9k7<ZWo5p$Z?)>vuh+v\u/:b*M=(
U"tpzjh\%9x_f?v\2?9FhV[sotm5.M7^%19.%$Ekx;J#qHeqXDqHUhH2(i)GW._G2
U"HDAWK$lB]uY6-'%j?JbB<>>J67)t*V^Iklm8^vva//,o[S$%eMcO96)3nKr(lK>
U">DHW:v4->ZOF:##RcUMU0UnY8tkEep[%vqG[fka=TJu;1EN8>H,S,/CbQHC3m97
U"R1a_%WcnMb6#M9x'[w\lnZdYO][8lu^f8A1rXLH%fY:IQEWoAoNsleS8eN?ZcF:
U"E&mTC,HR#ZBmZe*M.^ve>il0TU]pKB=)Wqj;ucYcvhg^5x#-0aMD:G.4>cM0Mcb
U"0nkN;p.:7LbU,5sl_B8T&Rb;_lqL+H$D8H?,>'*6*XB#u3kvH2qqWE)a^Jq^QYV
U"PTc\5S>]Y5Su*xm-p^9K_)7GSQ<;yB<D2G*5XC/8OQ9=49?-cOL>w<chI;V[I=k
U"gT7oMLn,7/T5v+W#8oU=>kkfOkv/[bAAQ24Ec-N4:][creb\hPbU_,lh>'/fxQd
U"GtYDwT&m2sW-bW<EjV5'r)l[F,*Kw#gLv]rlp]uH9ST5z_zJx1mru\%MGZ^v/S+
U"4MLJV$bX#0IYp0>&Ru*[\Q8UBLa<xt/jRS-QbB0;KztJ#e'3x)(;9$D(<H,Y[>(
U"uj2,pgYOv3S%IRhiK#T(MLj1#g-itI+23E'-:;JQvnTO_P5:Sk$cK8bY9C')nq\
U")gLS.Ity:t;Udlqd:$uwdM\y8/?/WV6Ww-a+q#XZu;kb4B7]2)?XL?Hr,4J2xom
U"D]i4$dF?Oh$)d\H9r&0CRGuFUhiQZ\NBNtosB#YWU[E6fXY]WNgH8QY*\=*\gdc
END SUB
SUB V2
U"PB]d2oAl<Z]]p=Q?d.3r(dFl>d_1&MK/Vn-EQs1ZOI_E$Dg*j1$[wFw7p/sNs9^
U"0;5gXPt3.V0+YESl6f^.^(AKSW$btgsWHxJ67hEqeS&oAhk-NMduW3?M:Nod*8J
U"1X%>hbJs3*trdv8?Vmbp;#^;TGu%I:i\r7YM\ZFgl?smpYFG<W><Sg:9p#_0dLN
U"NFP1axT,Rra,k4]VbF(l_,=F6FS]qlk&$xMk-3Ld:uj0J0o7'3bcuGcvqkl^ei(
U"kT#>Qt94uup\JC(TIN._/<MOJtv8sr\ure)FtH-nqz]CXB[O',#^#cER5G\a]p_
U"/;A6NMktAE:d6\^;JO,YcGK^D0YQjX(#6x]5jC(3G6L]JkW,+GrekF[UQ^,K'G/
U"^Pl[%g,p^kF^re0G_VB%?(^^6sGU;?/W9,/G;kB/S,4oGy]YzZeVGk2]zZ^EFhA
U"VXT6KD]J[6,Nkbc<R?GWOA/]c,$]t(.6#]VJm,Nc^e*GYMCRZtk6?RjKG-$Te2G
U"MHBR$krvU,pg]Jn,iFkL9iRVkv5],^]?T?R3$Gi^TEB(06UDB/Z=X]d8KG]6nGA
U"o>6]t^$9oRFGwl9R0GM]?Ec3,2kB-$ed]<tQ,dhAEQ,Ld#Eal,LkvGT,Xk\T]$#
U"J(,6Nl\e:G9'E\kS/'ABfQ'_e8?91&E=O$I0_HKXSW(0Ok*:<YAEU9KO4=R099/
U"g)-<:-U+7U*769V/901,[+t296YotE*hbI[1dOfHhP^XS<F0Rrk2][1V9mZa<j:
U"Bk:Zaa<Vuo;R5;:NK;Jaa;Fuo:B5::>K::IaJAU^zXjrF(GK?:[$,,p^j=RG3G=
U"6Mhk4#:[l,>tkF]%YO,Rk?F\e6BGo]Bk?/_,P9GeBY%#RbYk&Y;1J6z]>z$eNWG
U"m_;Cb6T#Z_$e4rGMFRqjk6>lRTkv5e,F^0tb6&lG/?/kd,%GVEB/Vl,6kv:$6t]
U"s$AR$KA*%M(=ZcA70UkU8UC?3C-20SZ*g<'rq0%uLUeMG$;hY*4\.jiDL,9H-?\
U"6eXR-Y%4ZN23-G:xtCM&rl7lxV\<Zg5fZFKt;:VT:Y^Oxr&iX4+RLZ^9#atmMql
U"ujtIj-n7v'G#d$]oC3$:4uk$G,f8#^kIT'0p>L*nIDeYbUaM:$vxrFS\v8I>/3W
U"BmBV\bfq_C(bIMUMDdoC79QVjPk^^Pq&<y$]I9L<M%;7dD^qRzLis6[cA6$6EcU
U")X>r3Mxcr4th$Z^xezOar5)Mc;zwVC)DzYl.Oyt90N2<5qOb*:YT5T%oGC7^pV:
U"7z0&0GSC5Imc^T^hyE(DW'98^TWsGAXS&'yYD4I+V,4&-e/:nsG&Pa5JDzJoZb-
U"GN3Ei&bQXbA*N,:9918>r8?BrNC_&hx,Cv(2:WOyKtasdIdkmTwd>yWSjcN1UK,
U"J_[?j_'oMu.Ib7HG.(>er.&nq-Df:MjxGk9V.<zh=:(nEKiov*T8BVP1=,J<-[E
U"nI#s^^l4CF>o\w\Wd-=XTJ($c-(CfF/])wxZOQ0Y&jD&pM49bF^2fe%yqX3nf[D
U"nL?%:yEKGFb76>d.h0$6XH%u.G+c5yk)R)yQYrs3bt#+]7UYLW4mnM7CY]%7x7v
U"pDf;idcF4-Be\v%VYk(WeM]KN>.wx<9dkjf[Q=+?7'4i&XRbN''\0fHGX.cg2Y6
U"59cHES/n69T,AZXXYOX,ZBgWYB+UX6GgIVX&poQycpr3(wmhNlX>TFxhx#AshDA
U"b2ijQiNsnF2QIRlKWDm*'#bcc$Pv9_g29+cB1kOnF>>>a_sIKHw2Vi8]ex0GrqL
U"[q]Q?^Xw(<G/-L3<WS2J=:VXxfTbMOcFR(D9ZKeU<<sXMD\:?Rd9\r[xI1B4iMA
U"4LUOnl*/SiMd^Ji7s+P[(WT2o&:7uxJJJC8u#3,L.NnHo(XXqN2ban.r*qgwO]w
U"NF3$EDN<ocfvDqX5WsEmPKjSE8hSB87jttq*:cr_%8BVr8IzMt,ggp:6n8i3dB7
U":$<+X]?[WMInD2d[3#rthcLYxFjbaMJS3&Y-L-ShvmQoXVvFlJd-^nY6vdqN$f=
U"^CTw0_Pbx2TkzQk$nA>+G^wJjE^A^/4N&MRtoRo7aJ^0N+=qf2dsHG*'.On][$n
U"m%#Jn6AMcyM=Jn/PS>o2*VXako7wR^vt4.5wUpTKSBw>J)E?LfX<KXos_Tii4c:
U"5ocW>gj,4NM>[t:\7V9%mv69_(+d6JeLvfmd/wPT%6gB.ab3n-Knl*EINB*_7N<
U"bh$nbLW:HyaXXGfUb27&N_2RHE-cTjX:Rx:Bl/NNY>w&c&\WSb9.kSdsX(M?Y4O
U"kC-Su#NWHjXdNk:Bqr-6-5FOd\'SMI^/-D8m^QMkgc;F*uwP].[a0s4)[QCV0oC
U"QZ=$bPe;*AR2y1=64Qe/ZR1L:#72j*e5(b\<6$S#e#Q18&#a<=;*,2$mejed>(<
U"*JWZ8o/^R1R4#aOJ7+$Ve\VvTJF>a0ZiAWPw:7$x>&$<F47>2MN2t$[(%Y^UG#,
U"hCP352O'28o$67^?fljFhRu.?WD%KGDKpA=wi5s3)YD7_+C>[5jKADhwP_0r6(=
U"_$BH+%IGpH0K>$:C6(>$7Z6215ME_tL1W$A&4icBb$Hk]a?=L76a0-ojG#KP/aW
U"FJU^kDlM4-v_L:=AWBT,^9/:ofz&pVbHtN_mRs*RMvN.Q;A(93<<j]+B,UGtuQ,
U"Cu\q$tijs(1xNcKYJVrqC8f;AWzlxYv+O,oc7>+RmxRq=J.gJMcb*__lf\T\-uQ
U"SUOyU((^TMj_c;Xk&vmdM1Tw#^M:l=#Z>qMhlL,w$VN#+t&'Y.RRa<M_]ud8^s$
U"V,,u61voE3PodYv++;5$,;.<nK4JHk.&Ct5]FGSTKFFNEm-'EcyJ*msvW%P(a#c
U"M54cdV%%G.Og++->,4%kYI%&'J'z)xR^T&,:w-cSVt$bh*A8z^]'t<PEHF],6'K
U"A<'^<aYazSP>41Mo$IxX.)N/oq9+f.M^tz5.GPT1+)7g(Kw,-Z:J_FDr&8?_8KO
U"HL$nAmF8(Cv(3XbG5sPuKK>1g,2_[nH'+3q%:*^\3.d/_k;r]MFJ,))-(:NLmv?
U"^KU$+=lJ3o-jqS_?5;LIl1wX4GI0zmt3aW[&LFWu99-mtHE,_*xZ/-3+nuYx*Pt
U"rif:WfTx'dQ<nWk%1yPt0itbtgj]EI;ev6-K\Z4wfDjlK^mX.x52P%:XNC\hi>:
U"D&%luQB^UXIm>bS&tKZO+C#XsCtqOyM3q_*fbqU'RJQKRUwD2eXhaP%fA=z6&d0
U"Op^<9J(9,Q[J3+-:;=S>s8#*^pGR<xg?MGe1,GG^?#rY#*%F\/*dI0H\-uK7%^N
U"AkhdHV,YJ59Q.bG42<J;:'2ba:2H-,iU(bLB1&9kdg,&S<Qe[(aJft_(=R&UKd.
U"qRRbH$2d-_Sm0>rrec$Js5CCWY+g_dYULn-6XK;CccF2XKJvtnh=nRV*bCQ/=MJ
U"uuc(t$jQL*8&4ECFaS4&u58GmF%M+vEiVX88RcSdFn3+Uk24nA%8QTo*bhR4vwk
U"#>>Xv<\ukd%up()%9%%%#-%n8mpF&R)AmX,7%%d6%%%/%%%%qk%sqng.Sy'yE>'
U"rbcT?66Sr/xplD^Yeny:P+6^1sx]op7\_t%p'1p#=h&onq-HE9XRDTghM5J3J+7
U"EmB#CD+:+miQsl6ndmCZ^Rfj?p0lp\G3D.pN<hZEN^u*i,T\'EJw+piO:vUOCOJ
U"'9SZ3%:\<dnc\'-ud3T-63s:mb0xxna6D,VoctJ$vsQJd&]:7[O4f$$Hl3hC*04
U"y-<<iAoH#Mxg0_j%*6K'NC4W/lSq9HXwg6rI.b$e<,:nQODXQHSF<J:N&aCH#,y
U"M<:,_V,:u[2r*'D*9=Ey4-GEfs#+eiB0s$sCdyE.LK9kQdOgvc8I4'Xpkb8Gtca
U"ke+5?>=4#Y.Bp>.%'rh%iL[1COUPR(;&>fk.wc%R':#uM+qDDe7:Fam:imaH\IB
U"de/0PiYi-qJ,PY,DLw1V;y0=(Lw^18lX)K3AEmR2rBeG7PQ:c_RTWtmfk79t.Wv
U"mu[4hAArSO7#u>4j0G9aNA*s%1pN76J+15[j*Vdyf\<-B?K<:dM-=PQ7eh]Jq9#
U"(AH9^4qN%mvK7Qlp>qYSu[^#HH]:gEh^l;N][q_>H7N7,k*38BjPynWvswro'sw
U"F7Ia9/6rRKa1CAFQNVV.QXE>>)5f<PP%1BIhz\yB,74DM9:A6.%yUS)V&iE-(R>
U"SCj+&df;+P9UmpiuVAp/Hx8q/r?4Y7wWA#N/Ztn($DCLKQE)tEl?>kuY&)=i[U?
U"^)'HhuYMQ(up(6'Sm^zg-yw)XaaHr4_=]qE^]JIDMolXjj&+eJtvF#3jByOKx?z
U"y-OoV*tGpwfRx=U)?,vsMtt^Ft,Z>8E1Q2ztpz%hgSetN5(z(<K/-c+Q\&\,U<7
U"skf(^^8:LC;b$OF&?gl+C\VD_G5n*mqGW9*K#H+PcU6JUl-ajk$HUDoe?IiGQju
U"oAe%>;1F&B^AJR.0<G'/dtAZOTaW[m,m0=ss+b?R=+/s61rAJ9A>OfKKK0^i7vb
U"QTM3hy?M?H;H-cli^g:2K]$voMb-n3S0o^oHG)ZWeuq=ZLQ2H5bQl:bv>O1<k-X
U"H-OJ1^Ug-_vV-TaS&1s.ax:CQNqW=7DO'8\nu+*GkYb%Xn_bntNS;xDG=cx5u&h
U"I,Ho3BRWx:*7'2L<[c2PTi<k64NRl1Bp%ulbXyA,3U:-9B\pPLxa)#jd:<^KW1L
U"B>+K879T(WA7IVuZ/DRL)jAE]8g-?G<Ov,ogVW0h=;uLCImQHm(uPL(3$R.itMU
U"QH1+nGtnbvUZwv$053<d3Z-dkjMvWBjn\wkJ:;1)o+iEip6lPO,_6&1Fv+Ri)Rl
U"cV+\bm%H);(q#csVh98KHwYP\/r0vn]dUu]P'9\DCv+3n(8FyUj_jGn18[A1B;4
U"#n038tZHgSs<(CqJ'dY(*Q?\SPQKfnA+0mJV+06J;4)%'-b\#EN_nP*+X&TP&<$
U"cq6kdarusZYO]Zfb_qmT*r*^u\GY0W%LCUt5b=ust2]kg/Ixy3ru%*]&e0]sHB9
U"J<#f4r=kV;yCT#K].mG0Kxq<sco(+$w4HqS8^mf//?G$Qdy/sT&q54YOi%DW:\;
U"%A/RM>:0>X8(h_yT#Bh_Xc'RB3'NmN]Y*ro9emnGW3$nH6mJ^p*mCe40DWzz5'0
U"HkgcfyWr9t,6PH_0=m'_P.:&=.458dl0'gc]OXUhm'iQUQYIVEc0g0s*j;_;N['
U"kS%ysF-(HZHt7n3.E<doFmhuLd]sVQfY7ThsKU?0e:(M7z#q;$=VArFD3Xt;,98
U"#I/RHK-nZ/;q9zwFB/ST%flPG9nqWs0RS2;.kQ'DIQa8Y/3R0bBRGE0H'O$B'Mi
U"b\%X1E#oMC_x#%_ink>d5qx;SHOOdLAtY6?,E[8pm3zfB7tr.w:c[]*PkHOJ2-F
U"CyF77qlLM^4yYg\.77*I-:&xrZ<G2%klJ0H_Btw5;3]P8d:0_[Kq1]>quzx0KYH
U"&Ts0]/(C9T:<3?E4cWEnJ*5?E<kgHo61g?m0L/14FIA]u3&fO$/XTebOj2'I.]^
U":Yo';DanXXTuY_j#7k[_5r0FT0;o7TqQZ452YZi#i&#h(+z;0Rr^+pRBz%uN%Q\
U"6kU&:TABiR)-OeP$Q:UUY/QKW#d:l85S9</BV9ZUcb[)A-h:E7CLYni'dKo.#u^
U"Zws5tU/f_V6cHO[S7.=2F-/)lA&c8%_Y>QuVAU4J;*WK*^RTpKs*_&JOtciBGpU
U"Z'l)kc:.k0-/>sWMl>s+IbnAUeAm?FGqt95<&F]jXoA#goVf3IL<lBc1wmt;qR>
U"g(,Nq[2DSP+t0fr<z6cJ5dR>&E\+nx8osK160Gj9x/Pu3B6TPA_T:UR$nt_t1h3
U"/*yD>^hB&qY\K.ZEDPHZ_]86?wo2r6/p.u%p()9%%%%-1%O7pmFd%#*eW&%+%W'
U"%%%1%%%%qks%rpin%wSgf(xLvr)>je9da,Xx7U,0]M<Y[z'/oI39MQoK$)];Uak
U"6653/&#Fr:'/xVLEryp#x^=_jHXl'ob0[,4:2p&N0\1;'C$x&=?R?R:pmwjbxMT
U"sX7A/B'tKp0#.Q*ejICGMo*neQ+=_XnRTD:&4TmsWHD9hK<SBrTmnYvZE(87CRc
U"y3.zvmqo<YwbZwgU-Bt2MjeS0nUi9IH-(Dt*Y.+&4.95t8qH\8HiN?TT/2n6dQ\
U"Ay*+1wsde*s6EAb3.v9Z/AP'uB&ANW;9VMmL:]Ht2a)*Q,:yBls_K7?WMoc8\El
U"wu%Z>Yt1&0jM?T1.u6:SWXu>ab&7Os]e4xK9EqzxjKNkEI;SZpX;lP8dMzmun\q
U"cC;(^j+YOIEZWHka(+<-J9l1q5KU:A,o6NDlqN\GaKLA0L]2J^2JniiB%je96Sl
U"W>Lko#+A$&uFL4$#[Rf*iRz<36W:2c[AIX;:9HJDuBf3K,r?n=8b\umKNiX8VoL
U"n.hF9,8%'up(%)9%%#%-%OA7pFc%/iT#['%%4%)%%/%%%%q%kswj%sSgf(xdxp,
U">Se5dc,Xx0iB7n))9&7:fX](3jr;*F0.rZ/AXGrT%]4xn<)rp$V,#)CM$wn9OXl
U"b;5502SRupmSUTEkQ1MB7T,v>u%Gg:XA54d];#j&xrLE%B<ABYS/w:_>JTO3+rK
U"K;nCQ\90Sz(CE3sCBip,>(Eruli4Cf\U.&jJ=_8Ryi2o[IN*q5rRqnN^>W4GMiQ
U"b;$CfIdP2dK-vL<Bm1QA)Un4p*\PE;X>_/.4O2S+L=LJ;F[wzJ5&ey2>FDPj#G]
U"/P-%%3T0pHZbD%;Xm)rZI+1</(KFb)yI1O^:6hdd]wsBo3V=L5)u51[R5m<*kf<
U"dzA/=;b[>=tX)83RB]Rh^'umXH*D#s\aak^zgVQ[XDhf'SKxICa2#[PKb8r?/,e
U"eV;Z,'RzP4FJ4#y>Gdn(^ZIhqQ*w<t46]6s;]Lgk1qVXH\M0>?ZQ,(,\;ziniFs
U"fmGY73RweYJ0VV\X<5oi:OQM:,F>FIZYK)%5Qg+Cd0MT&i2Sfv?H7ulv3?qDr&q
U"Iq3f<&-=T5mkv?kTu)UfW9HY,^+Y]Gq(p4'Ft>a-Mi^j3^ZbZ'(4gqs#KT':%K.
U"2AWH*ERDt+r.'gwxACTQg')0igb;\M2r3[%(HFs<r]=6.JhUUEa#GjO8*Xdd#tH
U"h-),Ml-aHMOVJdS?K7B5-Id&FlK7&pNyLZpjyx8%up()%9%%%I-%O7mpFEe6;ni
U"'7%%O*%%%1%%%%qk%sxmt%wySg.fx\y1v>jUL5M=sEuVxTDe3p(WL8b%2XVceN<
U"c_Y<1*N\7'Kjoq;9<SZwtRUC%\w<o5)g7Zh4hKu$m9m>KpC4kFQi4<w9/1+u0xj
U".<QU_S9S(NEMhN]pw:cQTlnYOtJ$TAP*soo5*?B(*sBk\aoM=MjAmib%?R66&(\
U"],npmiF'u'.n(VdYmC=Vy93M$=loj1H0$$Fx$C/It:/BrIO-u8c96KnK)Pb,V=Z
U"$XabFC1*\bA;M]71]G0sSX/qFb<F;]ADq.S#rX6#r-Y(]9_2b^H_iD8wY=1(0oQ
U",Bugi=2%T:L0)0.F&1Y4._TgpvNH(g>%Fq*#sg+ppXqK-AkwrpugQ,ys['g?dM'
U"$4g[h9/5-(-Mi^3:15;ocA((T7Q6f8-\RW,Oh.?.0X/pY,'Yjw,uWR'-^GUH/+a
U"W6<M;WhV9YfuU'\Rzl';2'Dt%dP9GwL2KSZEj7-Im'lL\i+3(GU1.9Qs4,DJ0qA
U"]cCb7[y.AqDiA\ky9Y[Y6v+LVd:tS\1Texgav/u&zZept/H1'rNclQ,&K:f$BSk
U";hpUi[ARp^+1FrmdL:C?2b0z#,2i_L7AZQdhm<aifh()W3lQ]0JD.3=3T2S&ai3
U"z3f7BWmrVUkTlk-4(M=>_f=mc$[HL-g>=J6a]R0^I>aO%iQf>%:qw=Z>>wS9Ja*
U"E^\^Z'r2D)Hvu8O;4ZN_y_*)raYyH4_t0p)7_qR,rT*RAbcmW.S]mUY&VQZLL\R
U"3Pfk;_8y-Gr6VcxI:>?3XVH&KdHsE98a)ipDST%$PTk&uO5W4yCiO'>\0A$'03u
U":vCxtv<Va)0e?P2\GPr(4VHk<T.(,?+H3&v;ZjS4l8%up()%9%%%I-%A.#pF$F1
U"i8=+%%%$6%%%0%%%%qk%shtu&(Sgfgx\&x&A?^7HwXzMMV]l+BePa:qWb<R*,zU
U"C+7'-u^e=TpAna-r'nErIUrKU:o^:oW-d3J287UGkgzU0mcnPdNP98Us=de6D9+
U":8?rmUVJ?qDZfbGrnFMpIh[t=w*RQ1^(M2DjE,\ln/6uH<g%%d?'FOz*UbexOD?
U"8JG$Td#XuhW2DHvs#rR3,?SGgDb,^0m+0=;Gr)pKWGd5FRTISFhG?GiPkK&D0&u
U"&p8IOdY$x)/F+2QJ\aA-O&Y_UepdCX<qdp]X1.?58^WV>GCbx-j*F&Ss0nL3PNM
U"k(]UO8R^OLiSK]c0;6+TPDGotBoh<eRDvY#nU%-Oh(ch.:oQzk_v8Y.nGq)+K$V
U"P83q;BU,];+&RFpfKb_ZxCyNvtd8-7F,&c#,5e$c7OM-_e'H&*1-4#a.*-#NqSd
U"NHP']PZ<nZZB%'A.x/:0:-68'v]G52],'IbiaN%'RVPmwgo1NeJu\(Cu^m84f%/
U"(Ynn0hFtT#CJf#QVk+OP=fQP+GsA]90pye,IDoRw]#JH==7FZ7St8hNVF(CVbxq
U"Tx^0+f4kHRy;WKhx-=?d]H6Elm2T5VX';-IdbHFPw3O4qm[O4.]pf;42.70g:WS
U"m]F/(].>wbP2H6kFU'HDaxzpBNo=SWWWt'E,P:*5R]gHeci&Z?[ukBM4sDM0Jso
U"D4M_Y#urS;#TGdLokR:yE0&MA3n9&Fl$OTX,.t.e41cq3(\U/aBFq%M(3eP>PuN
U"Nb55CW'i6L0aUQ_KYA1*NJ02tk2)eM8A'dC2+72D+m5Mw/P1=0PiB2)n=%-WZl8
U"Sna[^YGvh^HSk-fmC%h9DFOXKf7q)qd5sYDjA1GY/MXH0Ti;pj#<nX'g6eZU&F]
U"tS+&WIre7[bDX_;^X+5huDZ:SBjU?qR9H.T3#C&dNDORFF>BS<:q7nDfIg3X^jO
U"HPgoN>Q6CZsgO_r*;BVUnvKo$qS3:#1=qvH9aThQ>%Hi)Qd+J(zeVH2c3Hs1At#
U"j8fP],1piamDDNfT42pi:CpvkB=x_OY6oPvO\_&x%pY+I7h'Gi1]-f=XnO7aAf.
U"TL-:xI?Ja?HuDu5EIOkQdTKRPK,?;GSEY_6ULNYpu9<$6ZvZF?P.L+Y='(iY7d]
U"<9B\shN7PX*1uu5Xz8083^#Bc)T:]_YQR#CV':)&?tJ=iG>v$Qjj4dFugW;=c&Z
U"v]rl[b2bZZb3(w7zupC+d'Znp1jh.TzhIl\.wkCo\h9=Lqq;#YMy)UJkwp6##:i
U"oPJ;hU8Y<asqLZTk<h=N5QpD>)cl04zCHm(rlPI>Sou?4taybkA&RSqib$xX6?7
U"VVr.\[q;4KZ=Rv9T4yibCTg)%mkb&Vt*gBdr9=1wOT(L#&P:Nhl%,n-f5,RBFD?
U"9io*%K4nEVQL,b>(\cOI;k=Cfw8#PN8UB,.wfheyZ,RLdt6>+eN'IPNU\tG.HjC
U"lP;IOD=TNAK/3Yw+Hg3[X%V:c$7Q80hKts*NS,g3rJ5smmh1nP>X3\m/f;TnS]G
U"R83M,kCh?=,f,x-b7?W?&i0&d;Ie5vheBL6jIY^=']ILlHYc:0TaG_pdt48qb:K
U"Sm%9NFtDf_SvF?=K+mK>8Sd4(wI\?rhCCW\7'\v;06k*[_x]o:W*cvc:^s$YwSj
U"wo$kh_(Ny-Z'16#OR?ngzDhr&=4[t)/3t1*rQV:7iJIPrBZx(w;sX7#.^)dp&SL
U"S>dl2#tOo'p.kCKe...VfBKiFd*Xk7dE]$Fr80Uj,#2V5KQ6pp0?E==]RGEu5_g
U"MuJ/*KO%z+*?DxSU;+4zY9Ubu[TtO2BI/cs<,_.+mYO-XC?N3*0&L*ZD>rD64#,
U"Ky$ULmxpvO*EYemXSl4j<N_A8ypl9:wTVhtI=OelLwusHLwBi(A\62GwWn8MG2N
U"^?KKZuca&aeAnlKuAMXY:b(?F7v_Z&[$2CQP1:6_fuw]_=Sd1h**=asmOK2*<?h
U"Enyw:$%SV6hjr/5ET,i3Q9e7vu;e5AU,u#0J)b2UaCxAs]3qM?;p?S\RDjt$uV,
U"EU/.MWe(VFbbZP'nCUJ.D-m*-Nc((27ZT*<l^=t\?iTc#wE&l2_jr$_/\u;$tpy
U"QNTRL5GiNu%p()9%%%%-1%O7pIFHWt&pp'%%%8*%%%0%%%%qks%qtsl%SgfxD\b
U"p>BSe9T9Pf[d.AjweOpVOc7in^*Kj(+PPp/8r'e1C$F;g]lmVrkhd$XMYi-xiRY
U"H'HF*HLqDti\SPk=qRaj0T,%<U(0x8,Sl-rnt/3-rK)ql+DCL[W;xHPQ6#\W9(2
U"_bN_Ybt0YX$r%_AWc)J)HR4ixm<Kzl;>Uhm>UNo'$7.V[Y%HyM6]$1ns/Zu?n8:
U"'Vsu0lOMRWxH#t\>?-u'Jx26N/8DlNb2%b0<.76WU9\8]o1[3va>$q=Ob#r4=$x
U"m^ss)L4C&s.^j$H[6*:pE]njTlf+c3C3::<4j,6aW_;H#/o6074:^^Ab&$HIH59
U"[3s)_C#;4timM#/c2MjTCN:qf?-BbX-2R^PZu',io>RnUnT^O$x2%BFd9bNUzxB
U"SZoSlu9BUO>W2A[VCfoE;LJqEKw9)]q)BhW_f\ZaX5avey$Aqa7mn.C9Y<&$6;U
U"4R7X:.^l[ufItp\XS-hNTH+LypB\]$KSOVpIkR,pYsQ<6%i=?k4*Ouz+dGSSXhu
U"m>FI+Z9'+>ijWCsaDSI;-rW+6G#B7tpV_ri-N^G#Enp7A[V9a3Px<'c2iPbVfoP
U"n[aA*/>4#qbgSI.J*TkabeL?r^;vvDWb:3e+x#2QZHT%Re*^bjMw+v5;TS9-o,1
U"kvOqC4?feOw>2(g?q/,82)>BD&Wj=p30/&:xrg:ab.IL&veTucv+-d<L6r,SU*n
U".Qw*d85_k16s#h;:-'3OTik4ih'r=pm/vC6^p>u%p()9%%%%-1%,6p[Fw3G(sC'
U"%+%8/%%%.%%%%ufw%xjSgRfx>%;,>SU^9Ll[(d+jmk[kpKf#n8>-9Jav(,PPzrL
U"-5=EI7FxhkC<x5Lf_4\VIJ&bU?0:u7pqUtBH>b]<)8dLP0J=<'5d2WcEKtlTIT<
U"uK=woLH.-?B#\<7<7k&62'F3sf*r/>ji=Ji&48c.hV*mHnJHC=t]#BldEtv(t^U
U"U=K;0E2T.:AR#H2aA]E)0/9RK=F<eG9*8Z^=.t57RfJC$\+=9u-\O'nLt1Mw'0m
U"8/,j3H=vrgasnw.F-mbNXDg?aHi'IlcL2.84UZ%mO&_ZT\Pu4W;28L\(y9;%X,\
U"1TsV1;*HEAgZZf5OKrvPtNBh1,kdGa5_mKD;Av=C(Tu5:%hSJX&$+YMDe-(dr7p
U"im+:2OSU&T2jPd=tZi$eRR1N>Z-x&velU[BmQ\8f&m$=GN-WipdsNspG/a=VMYy
U"2A%G2%2=oC?FraC.xzFZg'$T%$%'La&m'bRlc:HnGqcs>gNyek#6v4884vDuEhW
U"wEe52\,MYY-1N:k1E\P*SiDfg,$7<+)2Xj>18fD:*&?t#tmTf#?hfvc8$bFm^8;
U"9dOrU/[x>V2]Fn9SkJRfv0ep<X<EdMjhb\lJAKUNl)tDrLEO?oED1l=LJxKr8HM
U">OxUM(He;Smi*sYBGU'XyMav#2J7Qtm=='ZWQJ&sXj1>x'r3V,^g'18T+P1H9:T
U"blS9T6HrEN]^99HANXLln6MS#gk)ehTiB%[>nV^q+)<bY_lhREr]9k3&dkdI$CE
U"73Z)h(:E7Sc#1+</w9ld13b$B-_Z*kKsG5eP=20mDx]x2Yb61x*X>up%()9%%%%
U"-%7St&=fo$m(%\&%%&E'%%%1%%%#htu(%knqj%SgfxMT$*:ARe5T9X(r4%,??R1
U"n8t9QkIQ=A5#f+BJ2FLCpRnS'O9T4ZvpVX\i02MhVDkltl2%<H4L(p;qtm(?3pU
U")q2;+Hs9dvpX4CsrHQPzekvv-8#\9K&53T,*V:<\#^W#eNM=d202WQ$NRndM?H#
U"hAZ$9\.B'U($JYf.uk*XR6yA,BGj,LxVmi-zL:4M9xl95e?i7a[$y.iF)DqsYZr
U"Ap#T0a;3^is+c5GpZ>PckiR8s??bPOQD,KJ&:/)o;)V;[7px>LlYDBc#:t4bG6a
U">TS\1a,e%kz+IY:':BK9IC#*]z93*?9?OY*&>([8VURy72Qp+%$,O#v\CH4q-rM
U"]=s79WoGDrb1<,5^j#Q0_'tGpQ5_o.Sk3n[)OF-hL^&#_RjdU-hv'u%p&'9%%9%
U"%#%-%OA7pF3BZ#D7['%%P%*%%1%%%%%%%%%&%%E%%%%%%%%%qks%hwjf%ySgf%x
U"up&%'9%9%%%%-4%+/pIFYF#)Mr%%+%f&%%%/%%%%%%%%%%%E#%%%a%'%%q%ksqn
U"%gSgf%xup&%'9%9%%%%-.%27pmFidt'>o&%%%q(%%%.%%%%%%%%%&%E#%%%,%(%
U"%q%ksqn%gSgn%up&'%9%9%%%%-%)V0pFc^kJ2&Y&%%&y)%%%/%%%%%%%%%&%E%7
U"%%G)%%%qk%sqng%Snsk%up&'%9%9%%%%-%)t8pF\9Bcd%%7%%%pU%%%/%%%%%%%
U"%%%%E%.%%O+%%%qk%sqng%Sqng%up&'%9%9%%%%-%*+/pFj_J4Q%^%%%&6%%%%/
U"%%%%%%%%%&%E%.%%w=%%%qk%sqng%Srfp%up&'%9%9%%%%-%)S7pFmj\':%0>%%
END SUB
SUB V3
U"%-T%%%/%%%%%%%%%%%E%%%%.>%%%qk%sqng%Svqg%up&'%9%9%%%%-%(n8pFQ&R
U"Am%X,%%'d6%%%/%%%%%%%%%&%E%%%%aW%%%qk%sqng.Sy'y%up&'%9%9%%%%-%)
U"O7pFsd%#e&W&%%'W'%%%1%%%%%%%%%&%E%.%%f^%%%qk%srpi%nwSg%fxup%&'9
U"%%9%%%I-%O7.pFc/%iT#'7%%4)%%%/%%%%%%%%%&%%E%%%%n$%%%qksw%jsSg%f
U"xup%&'9%%9%%%I-%O7mpFEe6;ni'7%%O*%%%1%%%%%%%%%&%%E%%%&[b%%%qksx
U"%mtwy%Sgfx%up&'%9%9%%%%-%)A.pFC$Fi8&=+%%%$6%%%0%%%%%%%%%&%E%%%%
U"ue%%%qk%shtu&(Sgf%xup&%'9%9%%%%-1%O7pIFHWt&pp'%%%8*%%%0%%%%%%%%
U"%&%E[%%%$%k%%q%ksqt%slSg%fxup%&'9%%9%%%I-%,6%pFw30GsC'7%%8/%%%.
U"%%%%%%%%%&%%E%%%&*n%%%ufwx%jSgf%xup&%'9%9%%%%-[%St&F=o$m'(\&%(%
U"E'%%%1%%%%%%%%%&%E[%%%o%p%%h.tu(k%nqjS%gfxu%p*+%%%%%4%%4%u#(%%&
U"%r%%%%%
END SUB
V2
V3
CLOSE:IF S=155AND B&=Z&THEN?" :) Ok!"ELSE?" :( Bad!
SUB U(A$):FOR A=1TO LEN(A$):C=ASC(MID$(A$,A))-37:IF C<0THEN C=91+C*32
IF K<4THEN K=C+243ELSE?#1,CHR$(C+(K MOD 3)*86);:K=K\3:B&=B&+1
S=(S+C)AND 255:NEXT:LOCATE,1:?STRING$(B&*50\Z&,219);:END SUB
'>>> Page 1 of LFNLIB.ZIP ends here. Last page. TCHK:155
<PAGEEND:"Win95.Long.Names.File">

<PAGESTART:"Win95.Long.Names.File2">
'#iab.compatibility.version.1a
'LFN version 1.0 beta1 -- Long filename functions
'Copyright (c)1996 Mark K. Kim
'markkkim@aol.com
'http://members.aol.com/markkkim/
'http://members.aol.com/vinDaci/
'* Freely distributed.  May be used in other programs with proper notice of
'  credit.
'* This program is provided "as-is".
'* In QBASIC, no modification is necessary
'* In QuickBASIC, QuickBASIC PDS, or VisualBASIC for DOS, run with the
'  "/L" option, like so:
'
'    QB /L
'    QBX /L
'    VBDOS /L
'
'  Also, do not include the QB.BI, QBX.BI, or VBDOS.BI files. If you do,
'  modify them so that the line "DECLARE ABSOLUTE..." is gone.
'* In QuickBASIC PDS and VisualBASIC, change all the lines in the format
'  "VARSEG(any.string.variable$)" to "SSEG(any.string.variable$)".
'* CREDIT: Ralf Brown's interrupt list was used to get interrupt for the
'  function.  Microsoft DOS's Debug was used to convert Assembly code to
'  machine code.  Microsoft is a Registered Trademark of Microsoft Corp.
'* NOTE: Works only under operating systems that support Windows95 LFN
'  or LFN emulation programs.
'Read the header of each function to find out their usage. These functions
'are designed to work with most other routines as it does not interfere
'with any other routines.


'the following line exists for compatibility reasons:
DECLARE SUB absolute (var1%, var2%, var3%, var4%, var5%, var6%, var7%, var8%, var9%, offset%)

'#begin declaration
  'File attribute constants -- used to do file search
    CONST ATT.ALL = &HFF
    CONST ATT.SHARE = &H80
    CONST ATT.ARC = &H20
    CONST ATT.DIR = &H10
    CONST ATT.VOL = &H8
    CONST ATT.SYS = &H4
    CONST ATT.HID = &H2
    CONST ATT.RDO = &H1
    CONST ATT.NONE = &H0
  'Value set to error code if an error occurs
    DIM SHARED errval AS INTEGER
  'Procedures
    DECLARE SUB lfn.mkdir (dirname$)           'make LFN directory
    DECLARE SUB lfn.rmdir (dirname$)           'remove LFN directory
    DECLARE SUB lfn.chdir (dirname$)           'change to a LFN directory
    DECLARE SUB lfn.del (filename$)            'delete a LFN file
    DECLARE SUB lfn.ren (oldname$, newname$)   'rename file
    DECLARE FUNCTION lfn.cwd$ (drive%)         'get current working directory
    DECLARE FUNCTION lfn.l2s$ (longname$)      'long name to short name
    DECLARE FUNCTION lfn.s2l$ (shortname$)     'short name to long name
    DECLARE FUNCTION lfn.findfirst$ (filespec$, findattrib%, mustattrib%)
    DECLARE FUNCTION lfn.findnext$ ()
    DECLARE SUB lfn.findclose ()
'#end declaration


'#start example program
  CLS

  longfilename$ = "long filename entry.tmp"
  longdirname$ = "long directory name entry"

  'make a LFN file by first opening a SFN file, then renaming it to LFN:
    'first create SFN
      OPEN "sfn.tmp" FOR OUTPUT AS #1
      PRINT #1, "La la la! This is a SFN entry!"
      CLOSE #1
    'rename SFN to LFN
      lfn.ren "sfn.tmp", longfilename$
      IF errval THEN PRINT "Error while renaming!" ELSE PRINT "LFN Created"

  'display all files in the current directory
    'file search -- allow any/all attributes and limit no attribute
      filename$ = lfn.findfirst$("*.*", ATT.ALL, ATT.NONE)

    'display result
      IF errval THEN
          PRINT "Error during file search!"
      ELSE
          PRINT "File search result: "
        'display filename and continue search
          DO
            PRINT "  "; filename$
            filename$ = lfn.findnext$
          LOOP UNTIL errval
        'terminate search -- must be called
          lfn.findclose
      END IF

  'delete previously created LFN file
    lfn.del longfilename$
    IF errval THEN PRINT "Error while deleting LFN!" ELSE PRINT "LFN deleted"

  'create LFN directory
    lfn.mkdir longdirname$
    IF errval THEN PRINT "Error while creating LFN directory!" ELSE PRINT "LFN directory created"

  'display LFN directory's SFN equivalent
    PRINT "LFN entry's SFN equivalent is: "; lfn.l2s(longdirname$)

  'change current directory to LFN
    'first display current directory
      PRINT "Current directory: "; lfn.cwd$(-1)
    'next change directory
      lfn.chdir longdirname$
      IF errval THEN PRINT "Error changing directory" ELSE PRINT "Directory changed"
    'display directory
      PRINT "Directory after change: "; lfn.cwd$(-1)
    'change back
      lfn.chdir ".."
      IF errval THEN PRINT "Error changing directory" ELSE PRINT "Back to original directory"

  'remove LFN directory
    lfn.rmdir longdirname$
    IF errval THEN PRINT "Error removing LFN directory" ELSE PRINT "LFN directory removed"

'lfn.chdir -- Change Directory
'INPUT:
'  dirname$ - Name of the directory to change to.
'SUCCESS:
'  * Working directory changed to specified directory.
'  * Global variable errval set to zero.
'FAIL:
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
SUB lfn.chdir (dirname$)
 
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                       'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                          'MOV     BP,SP
  asm$ = asm$ + CHR$(&H1E)                                       'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                          'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                          'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H3B) + CHR$(&H71)             'MOV     AX,713B
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                          'INT     21
  asm$ = asm$ + CHR$(&H1F)                                       'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)               'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)               'ADC     AX,0000
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5D)                                       'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)              'RETF    0012

  lfn.dirname$ = dirname$ + CHR$(0)
  lfn.dirnameseg% = VARSEG(lfn.dirname$)
  lfn.dirnameoff% = SADD(lfn.dirname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, lfn.dirnameseg%, lfn.dirnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.dirnameseg%
  errorcode% = lfn.dirnameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.cwd$ -- Return current directory
'INPUT:
'  drive% - Number of the drive to get the current directory of.
'    0 = A:, 1 = B:, 2 = C:, etc. -1 if current drive.
'SUCCESS:
'  * Return current directory of the specified drive.
'  * Global variable errval set to zero.
'FAIL:
'  * Return "".
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
FUNCTION lfn.cwd$ (drive%)
 
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                   'MOV     BP,SP
  asm$ = asm$ + CHR$(&H56)                                'PUSH    SI
  asm$ = asm$ + CHR$(&H1E)                                'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)       'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8A) + CHR$(&H17)                   'MOV     DL,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)       'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H37)                   'MOV     SI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)       'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                   'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H47) + CHR$(&H71)      'MOV     AX,7147
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                   'INT     21
  asm$ = asm$ + CHR$(&H8C) + CHR$(&HDA)                   'MOV     DX,DS
  asm$ = asm$ + CHR$(&H1F)                                'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)       'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                    'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)       'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)        'MOV     AX,0000
  
END FUNCTION

SUB lfn.del (filename$)

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                       'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                          'MOV     BP,SP
  asm$ = asm$ + CHR$(&H56)                                       'PUSH SI
  asm$ = asm$ + CHR$(&H1E)                                       'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                          'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                          'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H41) + CHR$(&H71)             'MOV     AX,7141
  asm$ = asm$ + CHR$(&HB9) + CHR$(&H0) + CHR$(&H0)               'MOV     CX,0000
  asm$ = asm$ + CHR$(&HBE) + CHR$(&H1) + CHR$(&H0)               'MOV     SI,0001
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                          'INT     21
  asm$ = asm$ + CHR$(&H1F)                                       'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)               'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)               'ADC     AX,0000
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5E)                                       'POP     SI
  asm$ = asm$ + CHR$(&H5D)                                       'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)              'RETF    0012

  lfn.filename$ = filename$ + CHR$(0)
  lfn.filenameseg% = VARSEG(lfn.filename$)
  lfn.filenameoff% = SADD(lfn.filename$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, lfn.filenameseg%, lfn.filenameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.filenameseg%
  errorcode% = lfn.filenameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.close -- Stop file search
'INPUT:
'  None
'SUCCESS:
'  * Global variable errval set to zero.
'FAIL:
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
SUB lfn.findclose

  SHARED lfn.filefindhandle%

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H1F)                     'MOV     BX,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&HA1) + CHR$(&H71)        'MOV     AX,71A1
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, iserror%, errorcode%, lfn.filefindhandle%, SADD(asm$))
  DEF SEG

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.findfirst$ -- Find file, initialization call
'INPUT:
'  filespec$ - File name type to look for. IE - "C:\*.*"
'  findattrib% - Files with these attributes are returned. Any files with
'    lesser attributes are also returned. Files with more than these
'    attributes are not returned. Used in conjunction with mustattrib%.
'    Use ATT.* constants provided in declaration.
'  mustattrib% - Files without these attributes are not returned. Used in
'    conjunction with findattrib%. Use ATT.* constants provided in
'    declaration.
'SUCCESS:
'  * Return name of the first file matching the createria.
'  * Global variable errval set to zero.
'FAIL:
'  * Return "".
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
FUNCTION lfn.findfirst$ (filespec$, findattrib%, mustattrib%)

  SHARED lfn.filefindhandle%
  SHARED lfn.finddata AS STRING * 320
  lfn.finddata = SPACE$(320)

  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H57)                                  'PUSH    DI
  asm$ = asm$ + CHR$(&H6)                                   'PUSH    ES
  asm$ = asm$ + CHR$(&H56)                                  'PUSH    SI
  asm$ = asm$ + CHR$(&H1E)                                  'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H3F)                     'MOV     DI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H7)                      'MOV     ES,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                     'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)         'MOV     BX,[BP+0E]
  asm$ = asm$ + CHR$(&H8A) + CHR$(&H2F)                     'MOV     CH,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)        'MOV     BX,[BP+10]
  asm$ = asm$ + CHR$(&H8A) + CHR$(&HF)                      'MOV     CL,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                     'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H4E) + CHR$(&H71)        'MOV     AX,714E
  asm$ = asm$ + CHR$(&HBE) + CHR$(&H1) + CHR$(&H0)          'MOV     SI,0001
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H1F)                                  'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5E)                                  'POP     SI
  asm$ = asm$ + CHR$(&H7)                                   'POP     ES
  asm$ = asm$ + CHR$(&H5F)                                  'POP     DI
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  lfn.filespec$ = filespec$ + CHR$(0)

  lfn.filespecseg% = VARSEG(lfn.filespec$)
  lfn.filespecoff% = SADD(lfn.filespec$)
  lfn.finddataseg% = VARSEG(lfn.finddata)
  lfn.finddataoff% = VARPTR(lfn.finddata)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, findattrib%, mustattrib%, lfn.filespecseg%, lfn.filespecoff%, lfn.finddataseg%, lfn.finddataoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.filespecseg%
  retcode% = lfn.filespecoff%

  IF iserror% THEN
    errval = retcode%
  ELSE
    errval = 0
    lfn.filefindhandle% = retcode%
    filename$ = ""
    DEF SEG = VARSEG(lfn.finddata)
    FOR i% = 0 TO 259
      ch$ = CHR$(PEEK(VARPTR(lfn.finddata) + &H2C + i%))
      IF ch$ <> CHR$(0) THEN
        filename$ = filename$ + ch$
      ELSE
        EXIT FOR
      END IF
    NEXT
    lfn.findfirst$ = filename$
  END IF

END FUNCTION

'lfn.findnext$ -- Find file, continuation call
'INPUT:
'  None. Same values used to call LFN.FINDFIRST$ are automatically used.
'SUCCESS:
'  * Return name of the next file matching the createria.
'  * Global variable errval set to zero.
'FAIL:
'  * Return "".
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully. This includes a case when there
'    is no more a file matching the createria.
FUNCTION lfn.findnext$
 
  SHARED lfn.filefindhandle%
  SHARED lfn.finddata AS STRING * 320

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H56)                                  'PUSH    SI
  asm$ = asm$ + CHR$(&H6)                                   'PUSH    ES
  asm$ = asm$ + CHR$(&H57)                                  'PUSH    DI
  asm$ = asm$ + CHR$(&HBE) + CHR$(&H1) + CHR$(&H0)          'MOV     SI,0001
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H3F)                     'MOV     DI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H7)                      'MOV     ES,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H1F)                     'MOV     BX,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H4F) + CHR$(&H71)        'MOV     AX,714F
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5F)                                  'POP     DI
  asm$ = asm$ + CHR$(&H7)                                   'POP     ES
  asm$ = asm$ + CHR$(&H5E)                                  'POP     SI
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  lfn.finddataseg% = VARSEG(lfn.finddata)
  lfn.finddataoff% = VARPTR(lfn.finddata)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, lfn.filefindhandle%, lfn.finddataseg%, lfn.finddataoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.finddataseg%
  errorcode% = lfn.finddataoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
    filename$ = ""
    DEF SEG = VARSEG(lfn.finddata)
    FOR i% = 0 TO 259
      ch$ = CHR$(PEEK(VARPTR(lfn.finddata) + &H2C + i%))
      IF ch$ <> CHR$(0) THEN
        filename$ = filename$ + ch$
      ELSE
        EXIT FOR
      END IF
    NEXT
    lfn.findnext$ = filename$
  END IF

END FUNCTION

'lfn.l2s$ -- Convert long filename to short filename
'INPUT:
'  longname$ - Long filename to convert to short filename.
'SUCCESS:
'  * Return short filename version of the long filename.
'  * Global variable errval set to zero.
'FAIL:
'  * Return "".
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
FUNCTION lfn.l2s$ (longname$)

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H57)                                  'PUSH    DI
  asm$ = asm$ + CHR$(&H6)                                   'PUSH    ES
  asm$ = asm$ + CHR$(&H56)                                  'PUSH    SI
  asm$ = asm$ + CHR$(&H1E)                                  'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H3F)                     'MOV     DI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H7)                      'MOV     ES,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H37)                     'MOV     SI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                     'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H60) + CHR$(&H71)        'MOV     AX,7160
  asm$ = asm$ + CHR$(&HB9) + CHR$(&H1) + CHR$(&H0)          'MOV     CX,0001
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H1F)                                  'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5E)                                  'POP     SI
  asm$ = asm$ + CHR$(&H7)                                   'POP     ES
  asm$ = asm$ + CHR$(&H5F)                                  'POP     DI
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  lfn.longname$ = longname$ + CHR$(0)
  lfn.shortname$ = SPACE$(67)
  
  lfn.longnameseg% = VARSEG(lfn.longname$)
  lfn.longnameoff% = SADD(lfn.longname$)
  lfn.shortnameseg% = VARSEG(lfn.shortname$)
  lfn.shortnameoff% = SADD(lfn.shortname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, lfn.longnameseg%, lfn.longnameoff%, lfn.shortnameseg%, lfn.shortnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.longnameseg%
  errorcode% = lfn.longnameoff%
 
  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
    shortname$ = ""
    FOR i% = 1 TO 67
      ch$ = MID$(lfn.shortname$, i%, 1)
      IF ch$ <> CHR$(0) THEN
        shortname$ = shortname$ + ch$
      ELSE
        EXIT FOR
      END IF
    NEXT
    lfn.l2s$ = shortname$
  END IF

END FUNCTION

'lfn.mkdir -- Create/Make Directory
'INPUT:
'  dirname$ - Name of the directory to create.
'SUCCESS:
'  * New directory created
'  * Global variable errval set to zero.
'FAIL:
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
SUB lfn.mkdir (dirname$)

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                       'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                          'MOV     BP,SP
  asm$ = asm$ + CHR$(&H1E)                                       'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                          'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                          'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H39) + CHR$(&H71)             'MOV     AX,7139
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                          'INT     21
  asm$ = asm$ + CHR$(&H1F)                                       'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)               'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)               'ADC     AX,0000
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5D)                                       'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)              'RETF    0012

  lfn.dirname$ = dirname$ + CHR$(0)
  lfn.dirnameseg% = VARSEG(lfn.dirname$)
  lfn.dirnameoff% = SADD(lfn.dirname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, lfn.dirnameseg%, lfn.dirnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.dirnameseg%
  errorcode% = lfn.dirnameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.ren -- Rename file/directory
'INPUT:
'  oldname$ - Name of the file/directory to change.
'  newname$ - Name of the new file/directory name.
'SUCCESS:
'  * Specified file/directory name changed to the specified name.
'  * Global variable errval set to zero.
'FAIL:
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
SUB lfn.ren (oldname$, newname$)

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H57)                                  'PUSH    DI
  asm$ = asm$ + CHR$(&H6)                                   'PUSH    ES
  asm$ = asm$ + CHR$(&H1E)                                  'PUSH    DS
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H56) + CHR$(&H71)        'MOV     AX,7156
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H3F)                     'MOV     DI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H7)                      'MOV     ES,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                     'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                     'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H1F)                                  'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H7)                                   'POP     ES
  asm$ = asm$ + CHR$(&H5F)                                  'POP     DI
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  lfn.oldname$ = oldname$ + CHR$(0)
  lfn.newname$ = newname$ + CHR$(0)

  lfn.oldnameseg% = VARSEG(lfn.oldname$)
  lfn.oldnameoff% = SADD(lfn.oldname$)
  lfn.newnameseg% = VARSEG(lfn.newname$)
  lfn.newnameoff% = SADD(lfn.newname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, lfn.oldnameseg%, lfn.oldnameoff%, lfn.newnameseg%, lfn.newnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.newnameseg%
  errorcode% = lfn.newnameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.rmdir -- Remove Directory
'INPUT:
'  dirname$ - Name of the directory to remove.
'SUCCESS:
'  * Specified directory removed.
'  * Global variable errval set to zero.
'FAIL:
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
SUB lfn.rmdir (dirname$)
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                       'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                          'MOV     BP,SP
  asm$ = asm$ + CHR$(&H1E)                                       'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                          'MOV     DX,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                          'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H3A) + CHR$(&H71)             'MOV     AX,713A
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                          'INT     21
  asm$ = asm$ + CHR$(&H1F)                                       'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)               'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)               'ADC     AX,0000
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                           'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5D)                                       'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)              'RETF    0012

  lfn.dirname$ = dirname$ + CHR$(0)
  lfn.dirnameseg% = VARSEG(lfn.dirname$)
  lfn.dirnameoff% = SADD(lfn.dirname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, lfn.dirnameseg%, lfn.dirnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.dirnameseg%
  errorcode% = lfn.dirnameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
  END IF

END SUB

'lfn.s2l$ -- Convert short filename to long filename
'INPUT:
'  shortname$ - Short filename to convert to long filename.
'SUCCESS:
'  * Return long filename version of the short filename.
'  * Global variable errval set to zero.
'FAIL:
'  * Return "".
'  * Global variable errval set to &h7100 if function is not supported.
'    (probably does not support LFN)
'  * Global variable errval set to non-zero if an error occurs and the task
'    could not be completed successfully.
FUNCTION lfn.s2l$ (shortname$)

  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'PUSH    BP
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'MOV     BP,SP
  asm$ = asm$ + CHR$(&H57)                                  'PUSH    DI
  asm$ = asm$ + CHR$(&H6)                                   'PUSH    ES
  asm$ = asm$ + CHR$(&H56)                                  'PUSH    SI
  asm$ = asm$ + CHR$(&H1E)                                  'PUSH    DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'MOV     BX,[BP+06]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H3F)                     'MOV     DI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'MOV     BX,[BP+08]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H7)                      'MOV     ES,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H37)                     'MOV     SI,[BX]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                     'MOV     DS,[BX]
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H60) + CHR$(&H71)        'MOV     AX,7160
  asm$ = asm$ + CHR$(&HB9) + CHR$(&H2) + CHR$(&H0)          'MOV     CX,0002
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'INT     21
  asm$ = asm$ + CHR$(&H1F)                                  'POP     DS
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'MOV     BX,[BP+0A]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H0)          'MOV     AX,0000
  asm$ = asm$ + CHR$(&H15) + CHR$(&H0) + CHR$(&H0)          'ADC     AX,0000
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)         'MOV     BX,[BP+0C]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'MOV     [BX],AX
  asm$ = asm$ + CHR$(&H5E)                                  'POP     SI
  asm$ = asm$ + CHR$(&H7)                                   'POP     ES
  asm$ = asm$ + CHR$(&H5F)                                  'POP     DI
  asm$ = asm$ + CHR$(&H5D)                                  'POP     BP
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'RETF    0012

  lfn.shortname$ = shortname$ + CHR$(0)
  lfn.longname$ = SPACE$(261)
 
  lfn.shortnameseg% = VARSEG(lfn.shortname$)
  lfn.shortnameoff% = SADD(lfn.shortname$)
  lfn.longnameseg% = VARSEG(lfn.longname$)
  lfn.longnameoff% = SADD(lfn.longname$)

  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, lfn.shortnameseg%, lfn.shortnameoff%, lfn.longnameseg%, lfn.longnameoff%, SADD(asm$))
  DEF SEG

  iserror% = lfn.shortnameseg%
  errorcode% = lfn.shortnameoff%

  IF iserror% THEN
    errval = errorcode%
  ELSE
    errval = 0
    longname$ = ""
    FOR i% = 1 TO 261
      ch$ = MID$(lfn.longname$, i%, 1)
      IF ch$ <> CHR$(0) THEN
        longname$ = longname$ + ch$
      ELSE
        EXIT FOR
      END IF
    NEXT
    lfn.s2l$ = longname$
  END IF

END FUNCTION
<PAGEEND:"Win95.Long.Names.File2">

<PAGESTART:"Books.File">
=============================================================================
                               QBASIC BOOKS
=============================================================================

1. Guide to QBasic:
   The Revolutionary Guide to Qbasic.
   Dyakonov, Yemelchenkov, Munermann & Samoylova.
   Wrox Press, 1996.
   ISBN 1-874416-20-6

2. Using QBasic:
   Feldman & Rugg.
   QUE, 1991.
   ISBN 0-88022-713-3

3. The Waite Group's MS-DOS QBasic Programmer's Reference:
   Arnson, Gemmell & Henderson.
   Microsoft Press, 1991.
   ISBN 1-55615-347-3

4. QBasic By Example:
   Perry.
   QUE, 1993.
   ISBN 1-56529-439-4

5. Beginner's Guide to QBasic:
   Bonushkina, Krylov & Melnikova.
   Wrox Press, 1994.
   ISBN 1-874416-16-8
<PAGEEND:"Books.File">

<PAGESTART:"FAQ2.File">
FROM: afn03257@freenet3.afn.org (Daniel P Hudson)
SUBJECT: FAQ - I'm back ---
DATE: 18 Nov 1996 14:31:11 GMT

BASIC Frequently Asked Questions
================================

This file attempts to answer some of the more frequent questions that
appear in the USENET newsgroup comp.lang.basic.misc

It doesn't contain any platform specific code or discussions.

CONTENTS:

 1. What is the purpose of comp.lang.basic.misc?
 2. What other USENET newsgroups exist for BASIC programmers?
 3. What sort of stuff should I post to this newsgroup?
 4. What sort of stuff should I NOT post to this newsgroup?
 5. How do I turn my program into a stand-alone EXE file?
 6. How can I de-compile my program from an EXE to BAS format?
 7. Basic implementations.
 8. What ON-LINE URLs for BASIC are there?
 9. Mixed language programming Q's?
10. What is so BAD about GOTO?
11. What about some GOOD books?
12. How can I define PI?
13. Where can I get a Basic grammar?
14. Where can I get info on the ANSI/ISO standards for Basic?
15. What is OOP and is there an OO Basic?
16. Why does .321 come out as .3219997 sometimes?
17. What is MBF?
18. What is the difference between STATIC and DYNAMIC memory?
19. Are MS-Basic products for DOS freeware now?
20. Why doesn't Basic have any Logic specific operators?
21. What type of math do I need to program in BASIC?
22. What is P-CODE?
23. Why is Basic so slow?
24. Why is my simple "Hello World!" program so BIG?
25. How do I read in a whole line when comma's are involved?
26. How do I stop than rasafrackin' question mark using INPUT?
27. Why should I use comments?
28. Where can I show off my stuff since you said not to post it here?
29. What kind of optimization are commonly use to speed up programs?
30. How come my questions never get answered?
31. All these rules are scarring me, how can I just ask some questions?
32. What is structured programming and how does it effect me?

------------------------------

1. What is the purpose of comp.lang.basic.misc?

ANSWER
~~~~~~

This group exists for the exchange of help and information for various
BASIC implementations on various platforms. The only BASIC which is
off-topic for this group is Visual Basic, which has it's own
newsgroup hierarchy :-

comp.lang.basic.visual.announce
comp.lang.basic.visual.database
comp.lang.basic.visual.misc
comp.lang.basic.visual.3rdparty

To further clarify this, VB-DOS question that do NOT involve the
forms part of VB-DOS are appropriate. However, form questions
belong in the VB hierarchy along with ALL VB-WIN questions. Platform 
specific questions are not banned from c.l.b.m, however, you would be 
advised to ask them in a group specifically designed for those 
questions, because accuracy in such answers is not necessarily
guaranteed to be correct or identified as incorrect. Especially
questions for platforms other than DOS.

 ***********************************************************************

2. What USENET newsgroups exist for BASIC programmers?

ANSWER
~~~~~~

comp.lang.basic.misc     - See Question #1.
alt.lang.basic           - no real rules, just discuss any BASIC
alt.lang.ca-realizer     - CA-Realizer BASIC only
alt.lang.gfa-basic       - GFA-BASIC only
microsoft.public.vb.*    - MS hierarchy for VB, another one
comp.lang.basic.visual.* - VB newsgroup hierarchy.

 ***********************************************************************

3. What sort of stuff should I post to this newsgroup?

ANSWER
~~~~~~

Almost anything about any BASIC dialect apart from VB windows
or VB-DOS using forms.. When posting code, attempts should
be made to keep it as general as possible.

Don't post your whole program when you only have problems with one
subroutine.

Don't post your whole program just because you think it's good
If you think you have written something other people might find
useful, say so in a post to the newsgroup, and offer to send it by
email to those who ask for it, or make it available by ftp or www.

 ***********************************************************************

4. What sort of stuff should I NOT post to this newsgroup?

ANSWER
~~~~~~

Anything that violates the guidelines in #2, as well as:

Adverts, spams, trolls, flames, Binaries, copyrighted material,
If you need or want to quote someone or something, identify
your source. If in doubt, paraphrase. :)

Binaries of any type in any form. No pictures, no .EXE files, no .UUE
files, no .ZIP, ARC, LHA etc. EXE files can be anything, it's easy
enough to write a disk wiper in a few lines of code, or embed a virus
into a useful-looking utility.

So, NO BINARIES!

Some general tips.
Note these are not my rules, they are suggestions for USENET behavior
arrived at over the years, and accepted by general convention as being
the USENET equivalent of rules. Break them at your peril.

Oversized sigs. It is a well established USENET convention that sigs
should be no more than 4 lines long.

Quoting. It is hardly ever needed to quote the whole of someone else's
post when replying to a article. Always trim their sig.

     *Don't quote the whole article just to add one line!*

Always try to keep quotes to a minimum. Always identify the source of
the quote, ie 'In article <blah,blah> joe bloggs (joe@some.where.com)
said - 'or something similar.

It's considered rude to post a question and ask for a reply by email.

Don't forget USENET is a public medium, what you write will be read by
hundreds, if not thousands of people, so think before you post.

Also, it is suggested that you limit your line length to 72 characters
per line to accommodate non-PC systems and prevent the jigsaw puzzle
your source code will inevitable end up as.

 ***********************************************************************

5. How do I turn my program into a stand-alone EXE file?

ANSWER
~~~~~~

You need a compiled implementation of BASIC. Yes, they do exist for
several platforms.

 ***********************************************************************

6. How can I de-compile my program from an EXE to BAS format?

ANSWER
~~~~~~

Unless your EXE was compiled in BASIC using special debugging
information, you can't! Binary code does not store label's
so PRINT is now an address, as well as any variables.
BASIC does not cover all CPU instructions, so it would freak on
something like ROL AX, 1. It just isn't possible without the fore 
mentioned conditions!

 ***********************************************************************

7. What Basic implementations are we talking about?

ANSWER
~~~~~~

There are probably millions of Basic implementations, with
BASIC dating all the way back to the 60's as it does. I will attempt
to cover the more popular ones, leave Business Basic to the
"Business Basic FAQ", and those with specific newsgroups to their
newsgroups FAQ. Translation, I won't cover gfa-basic, ca-realizer,
business basic, or visual basic. However, all but VB are on topic.

So what will I cover? Well not much I'm afraid. It appears that
MS-Basic's, PowerBasic and ASIC take up the whole newsgroup
almost. However, I would love to see some info on ANSI FULL
Basic, SBasic, ByWater Basic and especially UBasic passed a
round.

Well back to me.

QBASIC, BASICA, and GW-BASIC are Interpreted versions of MS-BASIC.
MS-BASIC is a language that was implemented in the early 70's by
none other than Bill Gates AKA Billy [Bath]Gates on the first
Personal Computer, PC, known as the Altair. Gates went on to
implement his creation which was somewhat based on Dartmouth
BASIC, on more systems than we could count. It was used as an OS,
a command interpreter, a scripting language, and a programming
language. No System was without it, TRS-80, VIC-20, C-64, Apple ][, 
Amiga, AT, XT, Atari, you name it. 


Quick Basic, PDS Basic, and Visual Basic for DOS
are Compiled implementations of MS-BASIC. PowerBasic is
a reincarnation of TurboBasic that tries to be compatible with
MS-BASIC for the most part while adding its own extensions.
So what was Dartmouth BASIC? In the 60's you used Fortran
Assembly language, or Machine code. While Fortran was by far
the easiest of the three to use, it was virtually impossible to
teach in a descent time period. So K
emmy and Kurtz developed a
compiled language for the local system called BASIC which stood
for Beginner's All-purpose Symbolic Instruction Code in 1963. This
name has cursed the language ever since and it is often viewed as
some 2nd rate toy by the ignorant because of this name.

Today, as with all languages, BASIC has been revamped by
both ANSI/ISO and Kemmy and Kurtz, as well as Gates' contribution.
BASIC is now strongly oriented to structured programming and supports
constructs which make following this school of thought that much
easier. Some common misconceptions about BASIC follow

 1. It is only for beginners and not really capable of real tasks.
    Millions of lines of code say otherwise, and that is NOT
    counting Visual Basic. Business Basic(s) is very popular as
    are the Microsoft DOS Basics.

 2. BASIC is an interpreted language.
    The first implementation of Basic was a compiled, not to mention
    QuickBasic, PowerBasic, VB-DOS, TrueBasic, etc.

 3. BASIC requires line numbers.
    Basic dropped its mandatory line number days in the 70's.
    That Basic, like disco, is dead people, get over it.

 4. BASIC makes it impossible to learn other languages.
    Only if BASIC refers to your incompetence, lack of
    motivation, or a teacher that couldn't teach a pill bug
    to roll.

What were those other Basic's you mentioned?

SBasic is a ANSI minimal Basic interpreter that is
freeeware and runs on a variety of platforms. It
is old, requires the line-number, etc. but it is still
fun.

ByWater Basic is another free ANSI minimal basic interpreter,
but this one comes with ANSI C src code which means ANSI
Minimal Basic is now as portable as ANSI C.

UBasic is a really cool implementation of Basic for you math freaks.
It has extremely high precision numbers. I saw a program that
calculates pi for like 30 minutes resulting in some 10000
screens full of numbers or something. Anyway, you might want
to check it out when you are bored.

TSR-BASIC is a semi-compiler. It binds a tokenized source code to a
resident interpreter making a terminate and stay resident program.
It is slow and bulky, but it gets the job done.

Note there are still many more.

 ***********************************************************************

8. What ON-LINE URL's for BASIC are there?

ANSWER
~~~~~~

Too many to list all of them.
Using search engines is the best way, IMHO, but here
are some:

 www.yahoo.com/text/Computers_and_Internet/Programming_Languages/BASIC
 SIMTELNET/msdos/basic
 SIMTELNET/msdos/qbasic
 SIMTELNET/msdos/ubasic
 COAST/msdos/basic
 COAST/msdos/qbasic
 COAST/msdos/ubasic

About COAST and SIMTELNET. These are not actual URLs but macros
you must replace with the proper URLs. Some of the URLs are listed
below. Why isn't Coast-To-Coast called Simtel anymore?
Politics and bureaucracy! Walnut Creek CD-ROM has a copyright
on the name and decided to be jerks about it. SIMTELNET
is the Walnut Creek archive and COAST is Coast-To-Coast's archive
What's even funnier is Walnut Creek is trying to copy Coast-To-Coast's
archive but wants to play cry-baby over a few directories being named
SimTel.

 COAST AKA "The Coast-To-Coast Software Repository" or [Old SimTel]

      Australia: ftp://archie.au/micros/pc/SimTel
         Canada: ftp://ftp.agt.net/pub/coast
 Czech Republic: ftp://pub.vse.cz/pub/Coast/
        England: ftp://src.doc.ic.ac.uk/pub/packages/simtel
        England: ftp://ftp.demon.co.uk/pub/Coast/
         France: ftp://ftp.univ-lille1.fr/pub/pc/coast
        Germany: ftp://ftp.tu-chemnitz.de/pub/coast/
        Germany: ftp://ftp.uni-mainz.de/pub/pc/mirrors/coast/
        Germany: ftp://ftp.uni-tuebingen.de/pub/SimTel/
      Hong Kong: ftp://ftp.cs.cuhk.hk/pub/simtel
      Hong Kong: ftp://sunsite.ust.hk/pub/simtel/
        Ireland: ftp://ftp.hea.ie/pub/simtel
         Israel: ftp://ftp.technion.ac.il/pub/unsupported/simtel
          Italy: ftp://ftp.unina.it/pub/simtel
          Italy: ftp://cnuce-arch.cnr.it/pub/msdos/simtel
          Italy: ftp://cis.utovrm.it/pub/SimTel
          Japan: ftp://ftp.crl.go.jp/pub/pc/archives/Coast/
          Japan: ftp://ftp.web.ad.jp/pub/mirrors/Coast
          Japan: ftp://ring.aist.go.jp/pub/coast
          Japan: ftp://ring.asahi-net.or.jp/pub/coast
          Korea: ftp://ftp.kornet.nm.kr/pub/SimTel
          Korea: ftp://ftp.nowcom.co.kr/pub/SimTel
    Netherlands: ftp://ftp.nic.surfnet.nl/mirror-archive/software/simtel-msdos
         Poland: ftp://ftp.man.poznan.pl/mirror1/coast/
         Poland: ftp://sunsite.icm.edu.pl/pub/coast/
         Russia: ftp://ftp.radio-msu.net/mirror/Coast
       Scotland: ftp://emwac.ed.ac.uk/mirrors/coast
      Singapore: ftp://ftp.singnet.com.sg/pub/mirrors/SimTel
Slovak Republic: ftp://ftp.uakom.sk/pub/SimTel
         Sweden: ftp://ftp.sunet.se/pub/pc/mirror/Coast
         Taiwan: ftp://NCTUCCCA.edu.tw/PC/simtel
       Thailand: ftp://ftp.bu.ac.th/pub/coast
            USA: ftp://ftp.drcdrom.com/Coast
            USA: ftp://mirror2.ftp.interramp.com/Coast
            USA: http://www.coast.net/SimTel/
            USA: ftp://ftp.coast.net/coast/

SIMTELNET AKA Walnut Creek CD-ROM

      Argentina: ftp://ftp.satlink.com/pub/mirrors/simtelnet
      Australia: ftp://ftp.bhp.com.au/pub/simtelnet
      Australia: ftp://ftp.iniaccess.net.au/pub/simtelnet
      Australia: ftp://ftp.tas.gov.au/pub/simtelnet
      Australia: ftp://sunsite.anu.edu.au/pub/pc/simtelnet
        Austria: ftp://ftp.univie.ac.at/mirror/simtelnet
        Belgium: ftp://ftp.linkline.be/mirror/simtelnet
        Belgium: ftp://ftp.tornado.be/pub/simtelnet
       Bulgaria: ftp://ftp.eunet.bg/pub/simtelnet
         Brazil: ftp://ftp.iis.com.br/pub/simtelnet
         Brazil: ftp://ftp.unicamp.br/pub/simtelnet
         Canada: ftp://ftp.crc.doc.ca/systems/ibmpc/simtelnet
         Canada: ftp://ftp.direct.ca/pub/simtelnet
          Chile: ftp://sunsite.dcc.uchile.cl/pub/Mirror/simtelnet
          China: ftp://ftp.pku.edu.cn/pub/simtelnet
 Czech Republic: ftp://ftp.eunet.cz/pub/simtelnet
 Czech Republic: ftp://pub.vse.cz/pub/simtelnet
 Czech Republic: ftp://ftp.zcu.cz/pub/simtelnet
        Finland: ftp://ftp.funet.fi/mirrors/ftp.simtel.net/pub/simtelnet
         France: ftp://ftp.grolier.fr/pub/simtelnet
         France: ftp://ftp.ibp.fr/pub/simtelnet
        Germany: ftp://ftp.mpi-sb.mpg.de/pub/simtelnet
        Germany: ftp://ftp.rz.ruhr-uni-bochum.de/pub/simtelnet
        Germany: ftp://ftp.tu-chemnitz.de/pub/simtelnet
        Germany: ftp://ftp.uni-heidelberg.de/pub/simtelnet
        Germany: ftp://ftp.uni-magdeburg.de/pub/mirrors/simtelnet
        Germany: ftp://ftp.uni-paderborn.de/pub/simtelnet
        Germany: ftp://ftp.uni-trier.de/pub/pc/mirrors/simtelnet
        Germany: ftp://ftp.rz.uni-wuerzburg.de/pub/pc/simtelnet
         Greece: ftp://ftp.ntua.gr/pub/pc/simtelnet
      Hong Kong: ftp://ftp.cs.cuhk.hk/pub/simtelnet
      Hong Kong: ftp://ftp.hkstar.com/pub/simtelnet
      Hong Kong: ftp://sunsite.ust.hk/pub/simtelnet
         Israel: ftp://ftp.huji.ac.il/pub/simtelnet
          Italy: ftp://cis.utovrm.it/simtelnet
          Italy: ftp://ftp.flashnet.it/pub/simtelnet
   
       Italy: ftp://ftp.unina.it/pub/simtelnet
          Italy: ftp://mcftp.mclink.it/pub/simtelnet
          Japan: ftp://ftp.iij.ad.jp/pub/simtelnet
          Japan: ftp://ftp.riken.go.jp/pub/simtelnet
          Japan: ftp://ftp.saitama-u.ac.jp/pub/simtelnet
          Japan: ftp://ftp.u-aizu.ac.jp/pub/PC/simtelnet
          Japan: ftp://ring.aist.go.jp/pub/simtelnet
          Japan: ftp://ring.asahi-net.or.jp/pub/simtelnet
         Latvia: ftp://ftp.lanet.lv/pub/mirror/simtelnet
       Malaysia: ftp://ftp.jaring.my/pub/simtelnet
       Malaysia: ftp://ftp.mimos.my/pub/simtelnet
         Mexico: ftp://ftp.gdl.iteso.mx/pub/simtelnet
    Netherlands: ftp://ftp.euro.net/d5/simtelnet
    Netherlands: ftp://ftp.nic.surfnet.nl/mirror-archive/software/simtelnet
    New Zealand: ftp://ftp.vuw.ac.nz/pub/simtelnet
         Norway: ftp://ftp.bitcon.no/pub/simtelnet
         Poland: ftp://ftp.cyf-kr.edu.pl/pub/mirror/Simtel.Net
         Poland: ftp://ftp.icm.edu.pl/pub/simtelnet
         Poland: ftp://ftp.man.poznan.pl/pub/simtelnet
       Portugal: ftp://ftp.ip.pt/pub/simtelnet
       Portugal: ftp://ftp.ua.pt/pub/simtelnet
        Romania: ftp://ftp.sorostm.ro/pub/simtelnet
      Singapore: ftp://ftp.nus.sg/pub/simtelnet
       Slovakia: ftp://ftp.uakom.sk/pub/simtelnet
       Slovenia: ftp://ftp.arnes.si/software/simtelnet
         Africa: ftp://ftp.is.co.za/pub/simtelnet
         Africa: ftp://ftp.sun.ac.za/pub/simtelnet
          Korea: ftp://ftp.nuri.net/pub/simtelnet
          Korea: ftp://ftp.sogang.ac.kr/pub/simtelnet
          Korea: ftp://sunsite.snu.ac.kr/pub/simtelnet
          Spain: ftp://ftp.rediris.es/mirror/simtelnet
         Sweden: ftp://ftp.sunet.se/pub/simtelnet
    Switzerland: ftp://ftp.switch.ch/mirror/simtelnet
         Taiwan: ftp://ftp.ncu.edu.tw/Packages/simtelnet
         Taiwan: ftp://nctuccca.edu.tw/mirror/simtelnet
       Thailand: ftp://ftp.nectec.or.th/pub/mirrors/simtelnet
        England: ftp://emwac.ed.ac.uk/mirrors/simtelnet
        England: ftp://ftp.demon.co.uk/pub/simtelnet
        England: ftp://micros.hensa.ac.uk/pub/simtelnet
        England: ftp://sunsite.doc.ic.ac.uk/packages/simtelnet
            USA: ftp://ftp.cdrom.com/pub/simtelnet
            USA: ftp://ftp.digital.com/pub/micro/pc/simtelnet
            USA: ftp://uiarchive.cso.uiuc.edu/pub/systems/pc/simtelnet
            USA: ftp://ftp.bu.edu/pub/mirrors/simtelnet
            USA: ftp://oak.oakland.edu/pub/simtelnet
            USA: ftp://ftp.rge.com/pub/systems/simtelnet
            USA: ftp://ftp.ou.edu/pub/simtelnet
            USA: ftp://ftp.orst.edu/pub/simtelnet
            USA: ftp://ftp.cyber-naut.com/pub/simtelnet
            USA: ftp://mirrors.aol.com/pub/simtelnet
            USA: http://www.simtel.net/simtel.net/
            USA: ftp://ftp.simtel.net/pub/simtelnet

 ***********************************************************************

9. Any tips on mixed language programming?

ANSWER
~~~~~~

This is a real common subject. The solutions are not quite
that simple however. The solutions depend entirely on the specific
implementations of the languages you are using, but here are some
general guidelines.

 1. Try to match up system specific options such as memory models,
    floating point formats, etc..
 2. Try to account for the language specific features such as
    BASIC's pass by reference parameters versus C's pass by value.
    As well as C's underscore prefixing of public labels and C++'s
    name mangling.
 3. Remember to 'Declare' the external procedures as required.

 ***********************************************************************

10. What is so BAD about GOTO?

ANSWER
~~~~~~

Nothing. However, people who use GOTO often have some screws
loose and use it to make the most hideous looking spaghetti code.
Therefore, it is common practice to frown upon the use of GOTO.
GOTO is an acceptable construct of the BASIC language, and when used
properly, it poses no problems. It does not magically make code
unreadable, unmaintainable, or unprofessional contrary to popular
belief.

 ***********************************************************************

11. What about some GOOD books?

ANSWER
~~~~~~

To my knowledge there are no real good books about the BASIC
language. I have heard rumors of one called structured BASIC written
by Kemmy and Kurtz though. Other than that, there are many good books
on specific BASIC implementations of BASIC.

 ***********************************************************************

12. How can I define/calculate PI?

ANSWER
~~~~~~

PI can be approximated at 3.141592653589793 as a
DOUBLE PRECISION FLOAT constant for most implementations, which is
accurate enough. However, those using more precise Basic's will like
to keep this little FACT handy.

PI is equivalent to the ArcTangent of 1 multiplied by 4
PI = ATN(1) * 4.

 Other than that, mathematical questions might better be answered
 in sci.math.

 ***********************************************************************

13. Where can I get a Basic parser?

ANSWER
~~~~~~

According to the comp.compilers FAQ,

  
  ftp.uu.net/usenet/comp.sources.unix/volume2/basic

has a basic interpreter with yacc parser.

 ***********************************************************************

14. Where can I get info on the ANSI/ISO standards for Basic?

ANSWER
~~~~~~

From ANSI or your local division of ISO. Seriously, that is
where you get them, you can however look up some info on-line
by searching for ANSI or ISO.

 ***********************************************************************

15. What is OOP and is there an OO Basic?

ANSWER
~~~~~~

OOP refers to Object Oriented Programming, and to my knowledge
there is no Object Oriented Basic. However, you may wish to
join the mailing list for info about proposed OOBasics.

This is an open, unmoderated list to discuss the BASIC
programming language and extending it to be Object-Oriented.

 List name:            OOBASIC-L Discussion List
 List address:         OOBASIC-L@NETSPOT.CITY.UNISA.EDU.AU
 Listproc address:     LISTPROC@NETSPOT.CITY.UNISA.EDU.AU
 List owner:           David.Gardiner@UniSA.edu.au

You can subscribe to this list by sending a
"SUBSCRIBE OOBASIC-L <your name>" command to the listproc address.

 ***********************************************************************

16. Why does .321 come out as .3219997 sometimes?

ANSWER
~~~~~~

The IEEE floating point format is flawed in that it can not
represent all fractional values perfectly, thus sometimes it
must represent a number close to the value. Sometimes this shows
up in your program, often more than not, the implementation performs
special rounding with floating point numbers so you never see it.
For display purposes using a formatted print and limiting it to
7 decimal places for SINGLE or 15 for DOUBLE will usually handle
this for you. For a better understanding, the fractional part is
calculated using 2 raised to a negative exponent [2 ^ -1 = .5],
so try it yourself with a few numbers and see what you come up with.

 ***********************************************************************

17. What is MBF?

ANSWER

~~~~~~

Microsoft Binary Format is an alternate Floating Point Format
to the IEEE 747 standard format. It was commonly used in the
70's and may be run across in old software/data files. More
information on the format can be retrieves from www.borland.com
or ftp.borland.com along with C source code to convert between the
two. Perhaps Peter will translate in the Code FAQ for uses of
other Basics. The Microsoft Binary Format was given up for the IEEE
formats because its accuracy was not as good as well as inefficient
since FPU's already support the IEEE 747 format.

 ***********************************************************************

18. What is the difference between STATIC and DYNAMIC memory?

ANSWER
~~~~~~

For some unknown reason this seems to be a popular concept that
eludes programmers. STATIC memory is memory allocated to the application
*at* execution time. It is generally a section of data stored in the EXE
that is loaded into memory. DYNAMIC memory is memory allocated by the
executable *during* execution and the memory must be initialized by the
program. Some systems also require that the program handle freeing
the memory or they will not return it to the system until a re-boot.
Freeing the memory relieves its usage from your program and allows the
system to use it for something else, either by another program or yours.
Basic's variable length strings are dynamic, but freeing and allocating
is done without your help. You can in many implementations, allocate
arrays dynamically and then free them or re-size them with ready.
Basically it allows you to manage memory a little better with your
program.

 ***********************************************************************

19. Are MS-Basic products for DOS freeware now?

ANSWER
~~~~~~

No! MS still holds the copyright and a copyright is good up
until 50 YEARS after the death of its holder, not after it goes out
of production. MS does distribute QBASIC from their site for free,
so you can get it that way, but copying of it from your system
or any other MS product is piracy and punishable by LAW with
a maximum penalty of $300,000/copy AND 3 years/copy in jail.

 ***********************************************************************

20. Why doesn't Basic have any Logic specific operators?

ANSWER
~~~~~~

Well obviously I don't know the answer to this, but its probably
because they felt it would be confusing to have separate AND, OR,
NOT, XOR, etc.. operators. However, notice that if you use proper
logical problem construction with the bitwise operators, you emulate
the Logical operators flawlessly. By proper construct I mean

 IF (A > 0) AND (B = 20) THEN

 and not

 IF A AND B THEN

unless A and B were assigned the result from a proper logical
evaluation thus A = NOT (10 > 20) and B = Z <> X.

 ***********************************************************************

21. What type of math do I need to program in BASIC?

ANSWER
~~~~~~

That depends entirely on what you are programming. Geometry
is good to know if your doing graphics but pointless in a statistics 
package. The more math you have, the better off you will be, but you
can certainly write useful programs knowing just basic arithmetic.

 ***********************************************************************

22. What is P-CODE?

ANSWER
~~~~~~

P-code is an intermediate stage between Textual source code
and binary executable machine code. Generally it is a tokenized form
of the source code with an interpreter bound to it inside 1 executable
file. It is slower than compiled native binary code but faster than
a full textual interpreter.

 **********************************************************************

23. Why is Basic so slow?

ANSWER
~~~~~~

It isn't. Your implementation is slow. Possibly because its
old and not up-to-date with today's compiler technologies. Possibly
because it is an interpreter or P-code system. The reasons vary.
One common reason is your algorithm is slow. See the optimizing
section for more info.

 ***********************************************************************

24. Why is my simple "Hello World!" program so BIG?

ANSWER
~~~~~~

Again, this relates to your specific implementation mostly.
However, the BASIC language does require special behind the seen
memory management which accounts for some of the bloat. Without the
special memory management, dynamic string allocation, etc. is not
possible. Also take into account that most BASIC's use a floating point 
emulator system which takes up a considerable amount of space.

 ***********************************************************************

25. How do I read in a whole line when comma's are involved?

ANSWER
~~~~~~~

LINE INPUT will take in a whole line of TEXT up until a
Return sequence. It works for files also using LINE INPUT #1,.

 ***********************************************************************

26. How do I stop than rasafrackin' question mark using INPUT?

ANSWER
~~~~~~

After the prompt use a comma instead of a semi-colon to
denote the variable(s) that will be assigned data. Like so:

 INPUT "Your Name: ", N$

 ***********************************************************************

27. Why should I use comments?

ANSWER
~~~~~~

So you know what the hell you were thinking when you look at
the code later. Many times you will get lost in thought even if you
use really descriptive variable, procedure, and label names.
On the other hand, you shouldn't comment too much.
Examples of weak commenting and over commenting are below.

 X = d * PI/180        ' Radians

This is weak commenting, I'll have no idea what radians has
to do with this equation in two weeks from now. What it does
and should say is convert from degrees to radians. Yes, I could
make it a function, except that well it is so small it hardly
seems worth it.

 X = d * PI/180 ' X is assigned the value of d after being multiplied
                ' by PI divided by 180 which is the formula to convert
                ' from degrees to radians.

That is a prime example of overkill. I really didn't care about the
multiplication and division, or assignment. I did have basic
arithmetic in 2nd grade after all.

I also suggest documenting operations that rely on specific rules
of the language or implementation such as the evaluation operators
returning 0 or -1 otherwise you'll have problems when translating
to one that uses 1 and 0 instead.

 IE

 X = X + (Z <= 10) ' X is decreased by 1 if true or by 0 if false.

Personally, I would just labor through writing this like
IF (Z <= 10) THEN X = X - 1 which is probably slightly less efficient,
but a helluva lot easier to read and understand.

 ***********************************************************************

28. Where can I show off my stuff since you said not to post it here?

ANSWER
~~~~~~

Well, you could submit it to the ABC package, The Fanzine,
SimTel, Coast-to-Coast, post it on your own Web Page, submit it for
the Code FAQ if it answers a common algorithmic problem or use
a binary newsgroup if it is a binary. just DON'T post it here.

 ***********************************************************************

29. What kind of optimization are commonly used to speed up programs?

ANSWER
~~~~~~

Wow! Well first do any mathematical optimization possible.
Second use Integers and Longs where possible, Floating point
operations are slow, very slow.  Umm, try to see how different
loops work. Don't be afraid to use a GOTO or two if you can use it
responsibility and gain performance. Hmm, can't think of anything else
other than know your compiler switches.

 Correction: Floating point emulation is slow, Pentiums can do
             floating point math as fast, if not faster that integer 
             math. However, other chips [motorolla] may not have
             the same

 ***********************************************************************

30. How come my questions never get answered?

ANSWER
~~~~~~

Let's see,

 A. You are off-topic.
 B. You are not exactly asking sincerely.
 C. You think we don't know its a homework assignment, but we do.
 D. We don't know the answer.

There are many reasons your question may not be answered, the most
common is it is off-topic or a school assignment and we aren't going
to do your work for you. However, sometimes people don't ask, they 
demand or use ignorant tactics to try and gain peoples attention,
this is usually an aggervation that gets you promptly put on everyone's
twit list. If none of these are the case, its likely we don't know.
Such a question might be how could I prove Einstein's theory of time
travel in Basic. Obviously if we could do that we'd be correcting
mistakes we made in our past, like x-girlfriends you wish you'd 
never met. ;-)
 
 ***********************************************************************

31. All these rules are scarring me, how can I just ask some questions?

ANSWER
~~~~~~

Well alt.lang.basic is basically a free-for-all so you can ask there as 
long as it relates to BASIC in some way. You can also E-mail me or just 
about any other user of comp.lang.basic.misc and not have to suffer
the consequences. B-)

 ***********************************************************************

32. What is structured programming and how does it effect me?

ANSWER
~~~~~~

Structured programming is a theory of program design in which decision
making, loops, procedures, declaring as well as defining data, and
a few other tricks are used to create code which is easy to read, easy
to follow, and easy to re-use. Basic has always supported enough 
constructs to write code following this school of thought, however, 
recently it has been updated to make this task even easier.

 So what does this mean?

 1. Use character labels when needed, and be descriptive.
 2. Use loops when code needs to be repeatedly executed.
 3. Code that performs a task somewhat separate of the rest
    of the program should be performed in a sub-procedure, especially
    if you need the task in more than one program.

 Put simply [please note, programs are untested and likely error prone,
             its only to make a point about structured programming]:

  100 REM Simple example of a text encryption program
  101 REM Note it is not a good encryption program, the key is stored
  102 REM in the file before each sentence.
  200 INPUT "Give INPUT file including PATH" INF$
  300 INPUT "Give OUTPUT file including PATH" OUTF$
  400 CLS
  500 OPEN INF$ FOR INPUT AS #1
  600 OPEN OUTF$ FOR BINARY AS #2
  700 DO
  800   LINE INPUT #1, TEXT$
  900   Max% = LEN(TEXT$)   
 1000   REDIM CHAR%(1 TO Max%)
 1100   FOR Count% = 1 TO Max%
 1200     CHAR%(Count%) = ASC(MID$(TEXT$, Count%))
 1300     CRC% = CRC% + CHAR%(Count%)
 1400   NEXT Count%
 1500   FOR Count% = 1 TO Max%
 1600     CHAR%(Count%) = CHAR%(Count%) XOR CRC%
 1700   NEXT Count%
 1800   PUT #2, ,CRC%
 1900   PUT #2, ,CHAR%()
 2000 LOOP UNTIL EOF(1)
 2100 CLOSE #1
 2200 CLOSE #2
 2300 CLS : PRINT "ENCRYPTION COMPLETE"
 2400 END

 should look like

 ' Simple example of a text encryption program
 ' Note it is not a good encryption program, the key is stored
 ' in the file before each sentence.
 DECLARE SUB Encrypt(TXT, Outfil)
 DIM INF AS STRING, OUTF AS STRING, TEXT AS STRING

 INPUT "Give INPUT file including PATH" INF
 INPUT "Give OUTPUT file including PATH" OUTF
 CLS
 OPEN INF FOR INPUT AS #1
 OPEN OUTF FOR BINARY AS #2
 DO
   LINE INPUT #1, TEXT
   Encrypt TEXT, 2
 LOOP UNTIL EOF(1)
 CLOSE #1
 CLOSE #2
 CLS : PRINT "ENCRYPTION COMPLETE"
 END

 '**********************************************************************
 '*                                                                    *
 '* Encrypt is a SUB-procedure that takes 2 arguments, the first is    *
 '* a variable length text string, the second is an integer that       *
 '* specifies the output file handle under Basic. The procedure        *
 '* encrypts the given text and writes the KEY followed by the         *
 '* encrypted data. is it not a secure method of encryption, its only  *
 '* an example that does not violate US encryption laws since the      *
 '* "backdoor" is the way to solve it.                                 *
 '*                                                                    *
 '**********************************************************************

 SUB Encrypt(TXT AS STRING, Outfil AS INTEGER)
   
   DIM Max AS INTEGER, Count AS INTEGER, CRC AS INTEGER
   Max = LEN(TXT) 
   REDIM CHAR(1 TO Max) AS INTEGER
   
   FOR Count = 1 TO Max
     CHAR(Count) = ASC(MID$(TXT, Count)) ' make unpacked integer array
     CRC = CRC + CHAR(Count)             ' determine basic KEY value
   NEXT Count
   
   FOR Count = 1 TO Max
     CHAR(Count) = CHAR(Count) XOR CRC  ' encrypt text
   NEXT Count
   
   PUT Outfil, ,CRC                       ' write KEY
   PUT Outfil, ,CHAR()                    ' followed by encrypted text
 
 END SUB  

 ***********************************************************************
<PAGEEND:"FAQ2.File">

<PAGESTART:"Tutorial.Planning.File">
=============================================================================

                                Program Planning

=============================================================================
                             By: kwmelvin@nr.infi.net
                             Edited By: Arpith Jacob
-----------------------------------------------------------------------------

* This tutorial will cover Program Planning and Development, or what you
  need to do to write a QBasic program. There are many things you need to
  do before you start to write actual Qbasic code. Code consists of the 
  many keywords, statements, and functions that comprise the QBasic 
  programming language.

* Learning program planning will help you, not only with QBasic, but with
  other computer programming languages, if you choose to continue your
  studies. Program planning will help you write programs that are easy
  to read and understand, and also easy to maintain and modify at a later
  date. This is a very important concept to grasp, because over 70% of
  a programmer's time is spent maintaining a program.

* Just as a machinist would not start cutting on a piece of metal without
  a blueprint, a computer programmer does not just sit down at the
  computer and write a program. You should have a well thought out plan
  completed before you start coding.

* The first thing to do is clearly state the problem to be solved. Computer
  programs are usually written to solve a problem. The problem may be as
  simple as balancing your checkbook, or as complicated as producing an
  entertaining game for yourself and your friends. So the first thing that
  needs to be done is to define the problem.

 * There are at least three parts in a problem statement: 
    
    * The output required. 
      All computer programs generate some form of output, whether it is to
      the screen, the printer, a modem, or another device such as a stepper
      motor, or LED. Your problem statement should clearly define the output.  
    * The input required.
      Your problem statement should clearly define what kinds of input are
      required to produce the required output. Input may be from the
      keyboard, a modem, or another device such as a scanner.
    * The processing, or algorithm.
      An algorithm is a list of steps needed to solve the problem. What is
      required to get from Input to Output. This includes any
      formulas needed for calculations.

      An easy way to remember these three parts is: INPUT>#62OUTPUT

* The next thing that needs to be done is to plan the logic of the program.
  Programmers use different methods to plan the program logic, including
  pseudocode, and flowcharts. Psuedocode is the easiest to use in this
  tutorial because flowcharts require graphical symbols which are not easily
  represented without using an imbedded graphic file. Psuedocode is just like
  an outline for a class paper. It is written in plain English, and is a
  step-by-step sequential plan of how the program will work.
  The QBasic interpreter follows directions in sequence. It executes the
  first line of code, then the next line, and so forth until the program is
  completed. The psuedocode should follow exactly the sequence that the
  computer will follow. It is sometimes a good idea to "play computer" in
  order to test the logic of the program before you actually code it.

* Once you have clearly stated the problem in terms of INPUT>#62OUTPUT
  and written your program in psuedocode; then tested the logic of the
  program by "playing computer", you are ready to code the program.
  Coding the program means to write the program using the keywords,
  statements, and functions that make up the QBasic programming language. The
  program may be written on paper first, and keyed into the QBasic edit
  window afterwards, or you may key the program directly into the QBasic edit
  window. You are encouraged to write your code on paper in the beginning.
  Then, as you gain experience, key your code directly into the QBasic
  editor.

* Test and debug the program after you have keyed it into the QBasic IDE.
  
  QBasic has syntax checking and will tell you if you make a mistake or don't
  follow the rules of programming. To run a program, press <F5>.
-----------------------------------------------------------------------------
                     email: kwmelvin@nr.infi.net
-----------------------------------------------------------------------------
<PAGEEND:"Tutorial.Planning.File">

<PAGESTART:"Tutorial.Modular.File">
=============================================================================

                             Modular Programming

=============================================================================
                            By: kwmelvin@nr.infi.net
                            Edited By: Arpith Jacob
-----------------------------------------------------------------------------

*  The goal of modular programming is to break down a large,
   complex program into small parts that are more easily understood.

*  Planning, coding, and testing these small, relatively simple units, is
   much easier than trying to manage one large complex body of code.

*  As a programmer, you must develop the ability and skill to look at a large
   problem and divide it into smaller functions. Once you have learned to do
   this, your programs will be coded more quickly, will be more likely to
   work correctly, and will be easier to read and be understood by others.

*  The primary rule for program modules is that each module must have only 
   one entry point and one exit point.

*  Each program module is designed to accomplish a specific task. This is the
   black box concept of modular programming. Generally, some data is input
   to a module, processed, then data is output from the module. The details
   of what happens within the black box are not important to the overall
   program. What is important is that for a given input, the module will
   reliably produce the desired output. That module could easily be replaced
   by another, without changing the rest of the program. It is important that
   each module stand alone.

*  Cohesion refers to the internal strength of a module. It is an indication
   of how closely related each statement in a module is to the others. As
   cohesion is increased, module independence, clarity, maintainability, and
   portability are increased.

*  The best modules are those that accomplish one task; and all statements
   in the group relate to that one function. It is not always possible to
   isolate each function into a module, especially in small programs. Such an
   attempt can cause many one-line modules. But one-line modules are often
   preferable to an uncohesive, poor, utility module.

*  Coupling refers to the connections, or interfaces, between modules.
   As a rule of thumb, modules should be loosely coupled; that is, what goes
   on inside one module should not affect the operation in other modules.

*  The control for execution of program modules must come from above.
   When a decision will determine which function to perform, place that
   decision at as high a level as possible.
-----------------------------------------------------------------------------
                            email: kwmelvin@nr.infi.net
-----------------------------------------------------------------------------
<PAGEEND:"Tutorial.Modular.File">

<PAGESTART:"Tutorial.Struct.File">
=============================================================================

                             Structured Programming

=============================================================================
                            By: kwmelvin@nr.infi.net
                            Edited By: Arpith Jacob
-----------------------------------------------------------------------------

*  Structured programming is a step beyond modular programming with guidelines
   for good modules and poor modules. Structured programming guidelines also
   define proper flow control and coding standards.

*  Structured Programming Guidelines are designed to make programs more
   readable and easier to understand:

   1. Use meaningful variable names.
   2. Code only one statement per line.
   3. Use remarks to explain program logic.
   4. Indent and align all statements in a loop.
   5. Indent the THEN and ELSE actions of an IF statement.

*  BASIC was not designed as a structured language, but the current additions
   to the language now permit the programmer to adhere to the three proper
   constructs. All programming can be done with combinations of these three
   constructs:

   1. SEQUENCE  -- Statements are executed one after another.
   2. SELECTION -- Choosing one course of action or another.
   3. ITERATION -- Repeating a group of instructions multiple times
                   without the necessity of rerunning the program for 
                   each set of new data. This is the loop structure.

*  Programming is a problem-solving activity. If you are a good problem-solver,
   you have the potential to become a good programmer. There is nothing that
   says that problem solving is a difficult activity. If you are willing to
   learn and follow the basic guidelines presented in these tutorials, your
   programming skills will improve and the activity of programming will be an
   enjoyable one.
-----------------------------------------------------------------------------
                         email: kwmelvin@nr.infi.net
-----------------------------------------------------------------------------
<PAGEEND:"Tutorial.Struct.File">

<PAGESTART:"Tutorial.Tutorial1.File">
============================================================================
                          BEGINNERS BASIC QBASIC TUTORIAL

FULL CREDIT TO THE CREATOR: Steven Salmon from the Beginners BASIC Home Page
                             EDITED BY: Arpith Jacob
============================================================================

CONTENTS:

1. QBasic Chapter Introduction
2. QBasic Chapter 1 - PRINT, CLS, FOR...NEXT, STEP
3. QBasic Chapter 2 - VARIABLES
4. QBasic Chapter 3 - IF...THEN, ELSE, INPUT
5. QBasic Chapter 4 - SCREEN MODES, COLOUR
6. QBasic Chapter 5 - LOCATE, BEEP, DATE$, TIME$
7. QBasic Chapter 6 - LOOP STATEMENTS
8. QBasic Chapter 7 - SELECT CASE
9. QBasic Chapter 8 - OPERATORS, RANDOMIZE FUNCTION
10. QBasic Chapter 9 - BASIC GRAPHIC TECHNIQUES
11. QBasic Chapter 10 - GOSUB, SUB PROCEDURES
12. Credits....REGISTER


--------------------------------
1. QBasic Chapter:- Introduction
--------------------------------


So welcome to the Introduction part of this long ongoing tutorial which 
hopefully will make you understand the concepts of basic programming. 
If you are a intermediate "C" programmer and wish to learn basic, this would
be a good place to start. What I do advise though for new basic programmers
is that you don't skip the tutorial unless you are perfectly clear on what 
is happening. If there is a programming example which you know how it works,
I still feel that you should type it in. Reason for this is you need to 
understand programming layout more at first than you do of the heart of 
programming. Layout can be a very important factor to programs, you will 
understand this later in the tutorials.

So the first thing you need to do is load up QBasic. Once QBasic is loaded 
your screen should look something like a text editor. You will observe a 
blue background with a window which display's relevant information about 
QBasic. Press "ESCAPE" to clear this window. You should now notice the 
cursor is flashing in the top left corner. 

QBasic has a very helpful help system built in. Let's take a look at what 
is available in Help. Follow these next steps:

Press SHIFT first then F1 

You will now see the help file. I suggest you read the information displayed
because you will find that it very useful.

If you are using a mouse, which is recommended, you can enter the help by 
clicking the leftmouse button on the word help which can be found in the 
titlebar at the top. If you are using Windows 95 you might find that there 
is a problem with the mouse within QBasic. Quite simply there is no pointer
which means your mouse is not actually being used. The simple way to get 
around this problem is this: 

1. Print out this Document.
2. Exit Windows 95 to MS-DOS.
3. Load the mouse driver.
4. Load QBasic. 

The problem is that Windows 95 does not allow external Mouse Drivers to be 
loaded. If you are pretty fluent with how your PC works, it might be a good 
idea to create a Bootable disk which will load everything up in one go. 
Failing that you could reset your machine. Before "Loading Windows 95" message 
appears press F8, which will allow you to boot in all these different 
wonderful ways. 

These programming examples does not really require you to use the mouse 
anyway. It will just take a little longer to learn the hotkeys which will 
allow you to do various tasks that the mouse would of done. 

Anyway back to programming. If you still have the Help file displayed, press 
"ESCAPE" to clear it from your screen. The way your screen is laid out is 
something which you will pickup a little later. It is not important at the 
moment, but what is important is the drop down menus. To access the drop down 
menus, press ALT followed by beginning letter of each menu heading. For 
example to access the FILE menu we would press this: 

Press ALT first then F 

You can now jump different menu's by pressing the right cursor arrow, and of 
course to go back the other way you would press the left arrow key. To select 
an item you would use the up and down cursor arrow keys. The arrow key's are 
usually located to the right of your main keyboard but to the left of your 
mumeric keypad. 

Have a browse through what options are availble, but more will be explained 
later. 

Important Info:

There are still a few things to remember when programming. To be safe always 
save your work at regular intervals. If a powercut decides to happen you know 
that you have not lost too much work. It has happened to me, so don't say I 
have not warned you. 

When saving your work make sure you call it decent file name. It's no good 
calling a calculator program "BERTY.BAS". Remember that file names can only be 
8 characters long. All QBasic programs will have the .BAS extension. If you 
call a file "PROGRAM", QBasic will replace it with "PROGRAM.BAS". I will 
mention more important points later when they spring to mind but for now lets 
get our fingers dirty with some very basic QBasic programming.


---------------------------------------------------
2. QBasic Chapter 1 - PRINT, CLS, FOR, NEXT, STEP
---------------------------------------------------


Load up QBasic and then press "ESCAPE" to clear the info dialog box. You 
should see an empty blue screen with the cursor flashing in the top left 
corner. The first program we are going to write will be very simple. It will 
display a message on the screen. Type the following: 

PRINT "Hello World" 

Once you have typed the very small program into the main editor you are ready 
to run the program. In QBasic you can run a program in a number of ways. The 
easiest method is by pressing F5. Do that now. You will find that the screen 
clears to black and prints the word "Hello World" in the top left corner. 

Sometimes if you load QBasic from DOS you will find that the remains of the 
commands are left in the background. For example C:>QBasic would be left in 
the background if you loaded it from DOS. You don't need to worry about this 
as the CLS command will sort your problems out. CLS command will Clear the 
Screen for you before doing the next operation. For example type the following 
in and press F5. 

CLS
PRINT "Hello World" 

Once you run the program you will find that access information left behind 
will be cleared away and you will be left with a black screen with "Hello 
World" printed in the corner. "PRINT" and "CLS" command's are available in my 
Reference section. 

With the "PRINT" statement you can have as many as you like in a program. For 
example type the following: 

CLS
PRINT "Hello World"
PRINT "Hello Again"
PRINT "Goodbye!" 

This will print all three lines on the screen one after the other. So far you 
should not have had any error's. If you had it might of been one of the 
following: 

PRINT ""Hello World"" 

You cannot have no more than two inverted commas(") in any print statement. 

CL S 

This command should read CLS not CL S. 

CLS
PRINT "Hello World 

Don't miss the inverted comma from the end or the beginning of the print 
statement. 

Here is a handy tip. Move the cursor up to the end of the "PRINT" statement. 
It does not matter which "PRINT" statement. Press F1. A Help file will be 
displayed containing information of that particular statement. Very helpful if 
you get stuck on a particular command. 

So far you have learned two brand new commands. Being "PRINT" and "CLS". Now I 
will introduce you to two further commands. These are called "FOR" and "NEXT".
These commands are very useful. To clear the previous program hold down ALT 
and then press F. Follow on screen instructions until you start with a fresh 
page. 

Now type the following program exactly how it is shown below. 

CLS
FOR i=1 to 10
PRINT "Hello World"
NEXT i 

Press F5 to run the program and see what happens. You will find that the word 
"Hello World" is printed 10 times down the screen. Now let's break down the 
program and see how it works. 

CLS 

Clears the screen of any leftover rubbish which might be around. 

FOR i=1 to 10 

This is the interesting bit. "i" is a variable, variables are talked about in 
the next chapter, the variable will store a value. To start with, the variable
will hold the value of 1. Everytime the "NEXT i" statement is reached the
program will check to see if the variable "i" is 10. If it is not 10, then the
program will continue and jump back to where the "FOR" command was. It is like
a loop, everytime the "i" variable is not 10 it will jump back and increase
the number by 1. So if you set the "FOR" loop to 20, "NEXT" will check to see
if "i" has reached 20. For example: 

1,2,3,4,5,6,7,8,9,10 STOP!!!! 

or

FOR i=1 to 20

1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 STOP!!!! 

Everytime the program loops over it will do everything contained between the 
"FOR" and "NEXT". If you were to write the program like this: 

CLS
FOR i=1 to 10
NEXT i

The program will still do the same thing but not do anything between the "FOR" 
and "NEXT". The reason for this is because there is nothing there in the first 
place. Picture it as a 10 second clock. The clock will go 1,2,3,4,5,6,7,8,9,10 
then re-start over again. The same principle is in the above example except we 
are not starting over again. 

In the above example the program is adding 1 to the "i" variable everytime it 
hits the "NEXT" statement. We could change the program so it will add 2 to the 
"i" variable. See if you can work out what the next program will do before you 
run it by pressing F5. 

CLS
FOR i=1 to 10 STEP 2
PRINT "Hello World" NEXT i

Above we have introduced another command called "STEP". This command specifies 
how much to increase the counter on every loop from the "NEXT" command. The 
"FOR" and "NEXT" loop is like a counter. It's like you and me just counting 
how many fingers we have. In the above example it will increase the counter to 
2 on every loop from the "NEXT" statement. Here's an example: 

2,4,6,8,10 STOP!!!! 

We understand what the "PRINT" statement does. It will print "Hello World" 10 
times down the screen unless you change any value's contained within the "FOR" 
statement. 

The "NEXT" statement is easy and was really explained above. Try changing the 
"NEXT i" statement to "NEXT" and and see what happens. Basically you are just 
taking the "i" off the end of the row. If you do eliminate the "i" variable on 
the "NEXT" statement, the program will still work. But what I do suggest is 
keep to what I explained above for now because in a large program it is nice 
to see what "NEXT" does what. I will go into the "NEXT" statement in more 
depth later. 

So the program will print "Hello World" five times on the screen because we 
are increasing the counter by double. It may seem complicated to start but 
with like any language everything will fall into place. Best thing to do is 
try changing the "STEP" value in the above example to see what kind of results 
you get. Further to that try changing the "i" value and the "to" value to 
something else. Have a good play that's what I say. 

So in this chapter you have learned five new commands. These are: 

PRINT, CLS, FOR, NEXT, STEP, 

Later I will explain what else you can do with these commands, but try having 
a look at the help file. You need to understand about variable's and string's 
and how they are used. In the next chapter I will introduce you to this.


---------------------------------
3. QBasic Chapter 2 - VARIABLES
---------------------------------


Variable's are very important in all programs in some form or the other. With 
variable's you can store relevant numeric information which can be operated on 
later. For example you could have 5 different numbers which you may want to 
add together. This can be down very easy in basic. You had seen in Chapter 1 
a variable being used in the "FOR" and "NEXT" statements. We gave the "i" 
variable a value of 1 to start with then we added 1 to it everytime we looped 
using the "FOR" and "NEXT" statement. So to make things simple here is a 
proper description: 

A variable is simply a name you give an area in memory in which a data value 
is stored. When you need to retrieve that piece of data, or modify its value, 
you can refer to the memory location by the variable's name. For example in a 
telephone program the variable age might hold the person's current age. As the 
program runs, the value stored in name might change several times over a 
couple of years. 

Naming Variables:

You are free, in any program, to give variable's a meaningful, descriptive 
name. When you come to write a program think about what each and every 
variable name should be. In any program try to make variable name's apply to 
whatever the variable is storing. For example the variable name telephone will 
oviously store a telephone number of some sort. So if it is a telephone number 
you want to store, it's best not to call it something like eggs. Believe me, 
it will make life far easier later when you come to write long programs. 

Variable's come in all shapes and sizes. Here is a common variable list: 

1. The first character must always be a letter(i.e A,G,D,F,z,e,t, or y) 

2. After the very first letter in a variable name you can have letters,       
   digits or underscores. 

3. The final character can either be %,&,!,#,$ or nothing. VBasic users          
   should really keep to the final character being the above and not leaving
   it out. 

4. Remember variable name's cannot be reserved words. For example in QBasic       
   there is a statement called "PRINT", you must not use this or any other       
   statement name for a variable name. 

In QBasic it does not matter if your variable names are either uppercase or 
lowercase. For example if you type a variable name as COST and then later in 
the program you type the variable name as cost, you will find that the 
variable name will match any other in the program. If you a program already 
typed in please clear it by using NEW from the file menu at the top of the 
screen. Here is program that I would like you to type in exactly as show 
below. 

CLS
cost=123456
PRINT cost
COST=789101
PRINT cost

As you can see there are a number of things happening when you type the 
program into QBasic. Firstly notice how the statements change from lowercase 
to uppercase. You can see this only if you type in the program as it is 
displayed above. The next thing to be noticed is how the variable name's 
change from lowercase to uppercase. As mentioned before everything will change 
as you type in a program, but the operation will always be the same. 

If you have typed in the program from above, press F5 now. This will run the 
program. The screen should clear and the information should be displayed. What 
the program is doing is storing 2 different value's into the variable name 
"COST" or "cost"(depending on how it was writtin in.) Firstly it will display 
the first value and then after changing during the program, it will display 
the new value. So program's can change variable information in no time at all 
and as many time's as you like. 

Picture a variable as a box. You first put a number into a box, for example 1. 
You then replace the number to 5. This operation is the same as taking the 
number 1 out of the box and putting the number 5 into it. You must remember 
that QBasic can only handle variable name lenght's upto 40 characters. So we 
have now talked about numeric variable's. Below we are going to talk about 
string's. 

Strings:

A string is a way in basic where you can store information in a variable. For 
example you could store a user's name or address in a string. Here is a little 
code to show you how it works: 

CLS
name1$="Freddy Bloggs"
name2$="Freddy Bloggs Sister"
PRINT name1$
PRINT name2$

This is a very simple program which stores information in a string variable. 
If you typed this program in and press F5 to run, it will display what is in 
the variable name's line by line. String variable name's don't have to have 
numeric value's in them. In the example above I have used two variable names 
which have both "1" and "2" on the end. I have just done this to seperate the 
different pieces of text up. You could have this: 

CLS
nameone$="Freddy Bloggs"
nametwo$="Freddy Bloggs Sister"
PRINT nameone$
PRINT nametwo$

What you must have though is the dollar sign($) on the end of the variable 
name. This let's QBasic understand that it is a string variable(string only). 
VBasic can handle string's and variable's in different ways, these are called 
Varients. But for now it's best to stick to the easy method which QBasic can 
understand. QBasic can handle upto 32,767 character's in anyone string. The 
only time you might exceed this is if you are writing a text editor. There are 
methods where you can get around this problem. If I remember I will explain 
much later. 

In the next chapter you will learn how to take data input from the keyboard 
and use it in a few different way's. So let's continue and move onto chapter 
number 3.


---------------------------------------------
4. QBasic Chapter 3 - IF, ELSE, INPUT, THEN
---------------------------------------------


Below is a short program which allow's you to print some information up on the 
screen and in the meantime it allow's you to store variable information into 
memory. Type the program out exactly as show and press F5 to run it.

CLS
name1$="Freddy Bloggs"
money1=500
name2$="Mr Blob"
money2=350
PRINT name1$
PRINT money1
PRINT name2$
PRINT money2

Once run you will find that the program will print all the information, which 
is contained in the variable's, to screen. This is a very easy method of 
printing variable's. For example you could rewrite the program to change the 
information stored in the variable's, but by asking the user for input from 
the keyboard. We are now going to do this, so clear the program you have just 
entered and type the next one in. 

CLS
INPUT "Your Name:"; name$
INPUT "Your Age:"; age
PRINT "Hello ";name$;" Your Age is ";age

This is a very good example of how to recieve input from a keyboard. Firstly 
the program will clear the screen. Next the program will ask a for a name to 
be typed from the keyboard. Next it will ask for a age, then it will print the 
results out to the screen. 

Let's take it a step at a time and have a closer look at the "INPUT" 
statement. The "INPUT" statement allows you to read characters from the 
keyboard and from files. We will be looking at files later. The "INPUT" 
statement can be used in a variety of ways, here a few for now. 

INPUT "Your Name:", name$

Notice that the ";" has been replaced by a ",". This will stop a "?" sign from 
appearing at the end of the input statement once the program is running. 
Change the program which you had typed in to the line which is shown above. 

INPUT name$

The above example will not prompt you for anything and wait for the user to 
enter something. Once return is pressed it will store the information in the 
"name$" variable. If you try the above example notice how there is a "?" on 
the screen. You can clear this by doing the following: 

INPUT "", name$

This will display nothing on the screen and just wait for a input from the 
keyboard. Once the return button is pressed it will move onto the next 
statement(if there is one). So all you have got to remember is when a string 
is a string and a value is a value. You know that a string will have a "$" on 
the end of the variable name, and a value variable will just have the standard 
name and nothing else. 

So lets recap on the second program in this chapter. 

CLS
INPUT "Your Name:"; name$
INPUT "Your Age:"; age
PRINT "Hello ";name$;" Your Age is ";age

We are doing the same sort of thing in the next "INPUT" statement. Following 
this is the "PRINT" statement. In the above program we are linking the 
variable's together and printing the one line on the screen. It may look 
complex at first but lets put it into plane English. Dont type this next part 
into QBasic. 

PRINT HELLO THEN A SPACE AND THEN PUT THE NAME$ AFTER IT. AFTER THIS PRINT 
"YOUR AGE IS" AND THEN AGE, WHICH WAS ENTERED IN BEFORE. 

It's not that difficult to be quite honest. Now I have given you the hard 
start, let's make the program above do the same thing but make it look much 
simple. 

CLS
INPUT "Your Name:"; name$
INPUT "Your Age:"; age
PRINT "Hello "+name$+" Your Age is "; age

Notice in the above example that the "PRINT" statement line has now changed. I 
have replaced some of the ";" character's with "+" character's. This make's it 
look more understandable and work's more effecient than before. The snag is 
that using the "+" symbol is that it only works with string variable's. This 
is why I could not put it on the end of the line to join up the end of text to 
the variable "age". It's a shame, but the good side again is that this method 
is used alot more in Visual Basic. You will see over the next comming 
chapter's this method being used. 

TASK 1:

1.1 Write a program that will allow you to enter a person's information and 
print it on the screen. The program should print the person's address on just 
one line but with 4 string variable's holding each part of the address. 
Remember that variable string's can contain numeric characters. The answer is 
at the end of this Chapter. 

IF.....THEN.....ELSE Statement:

In any program you write you are most sure to use the "IF" statement. The "IF" 
executes a statement or statement block depending on specified conditions. If 
that sound's complicated then take a look at the following piece of code. 
Don't give up if things look complicated, just look over and over the code 
until it clicks, It will click trust me. 

CLS
INPUT "What is your AGE:", age
IF age 

Wow look at this. A very interesting program which will check your input from 
the keyboard and then do a operation on it. What the program is doing is 
checking to see if the value you entered is above or below 18. It will then 
print the outcome on what the value was you entered. Best thing to do is type 
it in exactly as show and then run it by pressing F5. I have used the TAB key 
to make the spaces for the "PRINT" statement. This is a very good thing to 
start to do. Program layout is very important. 

Before we have a look at this program in more detail, let's go over a few 
conditions which are quite important when writing computer programs. 

                         = -------> Is Equal To
                         <> -------> Is Not Equal To
                         > -------> Is Greater Than 
                         < -------> Is Less Than 
                         >= -------> Is Greater Than or Equal To 
                         <= -------> Is Less Than or Equal To 

In the above example we were using the "Is Less Than" condition. Let's put our 
"IF" statement into a little plain English. All we were doing is: 

If age is less than 18 then print "you are underage". If 18 or higher print 
"your fine!!!!" 

When the above operators are talking about "Equal", we are talking about the 
same or that value. For example "IF age 18 THEN END" would mean if age is not 
18 then end. It just takes a little while to think about it, once you've done 
that your are well on your way with the "IF", "THEN" and "ELSE" statements. 

INPUT "1 or 2? ", i%
IF i% = 1 OR i% = 2 THEN
    PRINT "OK"
ELSE
    PRINT "Out of range"
END IF

Above is a example taken from QBasic. Observe what is happening. Firstly the 
program is asking for a number. You can either enter 1 or 2. The program runs 
the "IF" statement to see if the number which was entered is 1 or 2. If the 
number is 1 or 2 it will print "OK", if it's not 1 or 2 it will print "Out of 
range". After this it will just do a standard "END IF" finish. 

By just looking at some of the program's which have been written, you can see 
how easy they are doing the job. More complicated information of the "IF", 
"THEN" and "ELSE" statement can be found in the QBasic Help file. You can 
access this by typing "IF" and pressing "F1". 

Task 1 Answer:

CLS
INPUT "Name:", name$
INPUT "Address1:", address1$
INPUT "Address2:", address2$
INPUT "Address3:", address3$
INPUT "Address4:", address4$
INPUT "Telephone:", telephone$

PRINT name$
PRINT address1$ + ", " + address2$ + ", " + address3$ + ", " + address4$
PRINT telephone$

So you have learned the "IF", "ELSE", "INPUT" and briefly the "THEN" 
statement. We will be looking at the "THEN" statement in more detail. In the 
next chapter I will be introducing you to more new commands and another task. 
Also you will learn how to use loops to make your programs do something 
exciting. Keep with it and good luck. 


-----------------------------------------------
5. QBasic Chapter 4 - SCREEN MODES, COLOUR
-----------------------------------------------


When writing a QBasic program, your screen layout is one of the most important 
features of the program. You must make the program's screen clear to read and 
not to have bit's and bob's that don't really need to be there. In previous 
example's we have used a basic black screen with just a white colour text. In 
the following example we are going to change all of this to make your programs 
stand out. Type the following in exactly and press "F5" to run. 

SCREEN 12
COLOR 10
PRINT "We are using a Light Green Text With a Black Background"
PRINT "Screen resolution is 640x480 with 256 Colours!"
FOR i = 1 TO 60000
NEXT i 

SCREEN 9
COLOR 10, 8
PRINT "We are using a Light Green Text With a Blue Background"
PRINT "Screen resolution is 640x350 with 64 Colours!"

So from the above code example I have introduced two new commands. These 
commands are "SCREEN" and "COLOR". Let's have a closer look at the "SCREEN" 
statement. 

QBasic can handle many different screen modes. When I say screen modes I am 
talking about different sizes and colours. Here is a run down of different 
screen modes in QBasic. 

SCREEN 0: Text mode only
SCREEN 1: 320 x 200 graphics
SCREEN 2: 640 x 200 graphics
SCREEN 4: 640 x 480 graphics
SCREEN 7: 320 x 200 graphics
SCREEN 8: 640 x 200 graphics
SCREEN 9: 640 x 350 graphics
SCREEN 10: 640 x 350 graphics, monochrome monitor only
SCREEN 11: 640 x 480 graphics
SCREEN 12: 640 x 480 graphics
SCREEN 13: 320 x 200 graphics

The screen modes above are available to all QBasic users. Screen modes are 
very important to programs. For example if you wanted to draw lines, boxes and 
circle's on the screen with any kind of graphics method you would require a 
screen mode which allow's you to draw graphics. Most of the screen modes above 
works with fairly recent PC's. A few years ago some modes would not work 
because you would need a certain graphics adaptor. Thats why recent PC's are 
designed to handle older types of screen modes such as CGA,EGA,VGA and now 
SVGA. 

O.k so what benefit do you get from different screen modes. Well, some screen 
modes above allow you to use more colours than others. In the first program in 
this chapter, I gave you a program which will use two screen modes. One has a 
maxium of 256 colours and the other only allow's you to use 64 colours. When 
writing a program think about how many colours you are really going to need 
and at what resoultion are you going to have the display screen. 640 x 480 is 
a very nice resolution which is screen mode 11. Try changing the screen modes 
in the first chapter program and see what you get. Remember that some screen 
modes may not work, so don't worry about this. For more information on screen 
modes, type "SCREEN" into QBasic and press F1. 

Using Colours with Screen's:

So the first program used two different screen modes and some different sets 
of colours. Let's look closely at the "COLOR" command. 

Firstly the "COLOR" statement allows the user to select specific background 
and forground colours for the program. It even allows you to select a border 
colour. The border is the area which surrounds the screen. The "COLOR" 
statement can be placed anywhere in a program just like any of the commands 
mentioned so far. At the end of this chapter there is a brief description of 
the commands you have learnt so far. So to put the command in pratice let's 
write a interesting program. I am not going to tell you what it does yet, so 
for now, just type it in and run it by pressing "F5". 

SCREEN 12
CLS
FOR i = 1 TO 15
COLOR i
PRINT "Testing Testing 1.2.3"
NEXT i

So here we a go, a simple program. Can you guess what it is going to do from 
what we have learnt so far? Well let's take it command by command to see how 
it operates. 

SCREEN 12

We are now going to select Screen Mode 12. This will allow us to use, from a 
pallete of 256 colours, 16 colours. More information in the QBasic Help file. 

CLS

We know that this will clear any garble left behind on the screen from before. 

FOR i = 1 TO 15

We are setting the variable "i" a intital value of 1, which will be 
incremeted(increased)by 1 later. 

COLOR

We are giving the "COLOR" statement a starting value of 1 which came from the 
"i" variable in the "FOR" statement. 

PRINT "Testing Testing 1.2.3"

We are now to print the words above on the screen. 

NEXT i

When the program runs it will repeat the "FOR" and "NEXT" loop until the "i" 
variable reaches 15, which is defined in the "FOR" statement above. 

So when the program runs it will display 15 pieces of text which are each a 
different colour. Notice how there are only 15 pieces of text when we should 
be displaying all 16 which we have got available. To do this we should change 
the "FOR" statement to this. 

FOR i = 0 TO 15

Note how we changed the value of "i" to zero first. This is because the colour 
0 is black. If we changed it from 1 TO 16 we would get a error because the 
"COLOR" statement in screen mode 12 can only handle 16 colours at anyone time. 
Have a little play with the "FOR" and "NEXT" loop. 

This is how the "COLOR" statement works. 

COLOR [foreground][,[background][,border]] --- Screen mode   0
COLOR [background][,palette]               --- Screen mode   1
COLOR [foreground][,background]            --- Screen modes  7-10
COLOR [foreground]                         --- Screen modes 11-13

As you can see from the first program in this chapter, we can define not just 
the foreground text colour but also the background colour. The "COLOR" 
statement works quite different in other screen modes. To see what does work 
and what does not work, look at the help file under "COLOR". This will be a 
ideal reference for you to use, when selecting colours for various parts of 
your programs. The "COLOR" statement is explained in more detail in a couple 
of chapters from now. Oh! Also the "COLOR" statement is not used by all Basic 
programming languages. You will need to check this up by looking at your user 
guide. 

Task 1.2:

Write a colourfull input program which will ask for a user's name and age. 
When you output it to the screen make sure the writing is of a different 
colour. Hint: Use screen mode 12. The answer is at the end of the chapter. 

Review of Commands Learnt:

PRINT
FOR
NEXT
CLS
SCREEN
COLOR
INPUT
STEP
IF
ELSE
THEN
ENDIF

Quite a few of these commands will be mentioned in more detail later in the
chapter, but you are not doing to bad. The main thing is experiment with what 
you have learnt, and you will pick it up nice and easy. 

Task 1.2 Answer:

SCREEN 12
CLS
COLOR 3
INPUT "Name:", name$
COLOR 5
INPUT "Age:", age
COLOR 9
PRINT "Hello "; name$
COLOR 10
PRINT "You are"; age

The code is nice and simple and gives a good result. You program should look 
something like this, but your colours will probarly be different than mine. 
Try typing my program in and see if you get the same result as me. If you are 
close then well done, if not then don't worry! 

So you have now learned a little about screen modes and colors in QBasic. 
Remember the screen mode and any colours can be set at anytime in a QBasic 
program. Remember that you don't need to keep using the "CLS" command all the 
time, the screen should clear automatically when a new screen mode is 
selected. Keep going and well done. 

In the next chapter we are going to learn about screen layout and introduce 
you to some very useful command's such as "LOCATE" and "DATE$". Also you will 
learn how to make the computer respond back to you by using a useful warning 
command such as "BEEP". The "IF" and "ELSE" statement is mentioned and used in 
more detail than so far. See ya soon!


------------------------------------------------
6. QBasic Chapter 5 - LOCATE, BEEP, DATE, TIME
------------------------------------------------


When you write a program in QBasic it is nice to place your text somewhere on 
the screen. Within previous examples so far we have just had the text printed 
in the top left side of the screen. We can use a specific command which will 
place text anywhere on the screen, this command is called "LOCATE". Below is a 
simple syntax. 

LOCATE row, column, cursor 

row:

The number of a row on the screen; row is a numeric expression and must be a 
integer value. If a row value is not specified, then the line (row) does not 
change. 

column:

The number of a column on the screen; column is a numeric
expression and must be a integer value. If a column value is not
specified, then the column location does not change.

cursor:

A value indicating whether the cursor is visible or not. A value of 0 (zero) 
indicates cursor off; a value of 1 indicates cursor on. 

Before we go any further let me just briefly explain what a integer is. A 
interger is a whole number ranging -32,768 to +32,767. This means that a value 
of 21566 is a integer, and a value of 2343992 is a long integer. But from now 
on integer variables are going to be used like below within example's in this 
chapter. 

money%=599

O.k here is a little code to show you how "LOCATE" command works. 

SCREEN 12
CLS
LOCATE 5,10
PRINT "Hello World we are at 5,10"
LOCATE 10,15
PRINT "Hello World we are at 10,15"

If you type this program in and press "F5" you will find that the words "Hello 
World we are at y,x" are placed in various locations on the screen. The y,x in 
the last sentence is whatever is placed into the program oringinally. Try 
changing the "LOCATE" statements in the above program to something different. 
Press "F5" to run. 

The first "LOCATE" statement in the program we just typed in moved the 
following "PRINT" statement 5 lines(rows)down and 10 
Characters(columns)across. What you must remember is that whatever "PRINT" 
statement follows the "LOCATE" it will only do the operation on the following 
statement. 

The locate statement does not have to have a value representing the row or 
column all the time. For example we could have: 

LOCATE 5 

This will simply move the "PRINT" statements output to 5 rows down the screen. 
We can also have this: 

LOCATE , 5 

This will simply move the "PRINT" statements output to 5 column across the 
screen. So again you dont have to specify the arguments all the time. 
Arguments are the information which is required for a statement to work. For 
example: 

LOCATE argument1, argument2 

In which case argument1 would be row and argument2 would be column. Have a 
little play with the "LOCATE" command and see what you come up with. 

Sounding a BEEP!!!:

Within QBasic you can make your computer do a simple sound effect which might 
represent a warning or a showing of information. This command is called 
"BEEP". Its very very easy to use. To try it enter the following 1 line 
program and press "F5" to run. 

BEEP

Simple!. It will generate a high pitch sound. You can place the "BEEP" command 
anywhere within a program. In the following program the "BEEP" command is used 
together with some other bits you have learnt so far. Type the following in 
and press "F5" to run. Remember to delete the program which you typed in last. 

SCREEN 12
CLS
checkpass$ = "fred"
LOCATE 5, 5
INPUT "Please Enter Password:", password$
IF password$ = checkpass$ THEN
        CLS
        LOCATE 5, 5
        PRINT "Login Correct"
ELSE
        CLS
        LOCATE 5, 5
        PRINT "Login Incorrect!!!"
        BEEP
END IF

The program above may look a little complicated at first but really it's very 
easy. Firstly the program will change screen mode to 12. Following this it 
will clear the screen to get rid of any bits left behind by other programs. 
The next statement will tell the variable "checkpass$" to have the word "fred" 
stored within it. We then setup the screen to ask for a password. Once the 
password has been entered it will store the information within the variable 
called "password$". The "IF" statement following will check to see if the 
variable "password$" is the same as the variable "checkpass$", which if it is 
then it will print "Login Correct" upon the screen. If the password is not 
correct it will jump to the "ELSE" statement and print "Login Incorrect!!!". 
Also a loud beep will come from the computer's internal speaker. 

The we go a simple inputting and checking program. You can also check for 
invalid numbers. Here is a program which allow's you to do this. 

SCREEN 12
CLS
checknumber% = 50
LOCATE 5, 5

INPUT "Please Enter a number(0-100):", number%
IF number% >= checknumber% THEN
        CLS
        LOCATE 5, 5
        PRINT "50 or Above!!!"
ELSE
        CLS
        LOCATE 5, 5
        PRINT "49 or Below"
END IF

Again another simple program which checks to see if a number entered is higher 
or lower than the one which is stored into the variable called "checknumber%". 
Firstly the "checknumber%" variable is holding the value of 50, which is 
checked by the "IF" and "ELSE" statement, just like the password program 
before. The "IF" statement is checking to see if the value you typed in is 
greater than or equal to the value stored in the variable called 
"checknumber%". For example if you typed in 49 you would get a result of "49 
or Below" printed on the screen. However if you type 50 or more into the 
program you will get a result of "50 or Above!!!" printed on the screen. 

Date and Time:

QBasic allows the user to find out what the system date and time is. To do 
this you can use two simple commands such as "DATE$" and "TIME$". You can also 
set the time and date from within a QBasic program, but this will be explained 
much later. 

Type the following program in and press "F5" to run. Remember to clear the 
previous program from within memory. 

CLS
PRINT "Todays Date is:", DATE$
PRINT "Todays Time is:", TIME$

Press "F5" to run and you should see the date and time displayed on your 
screen. There is not much else I can tell you about the "DATE$" and "TIME$" 
command until later. You could try writing a program which will display the 
date and time at the top of the screen and ask a user for a password. 

You have now learnt a further 4 QBasic commands. Remember that you can get 
online help by just pressing the "F1" by any command on the screen. In the 
next chapter I will introduce some basic looping techniques which will 
continue a operation until something happens such as a user pressing the 
keyboard or until something makes the loop stop. Thanks for reading! 


--------------------------------------
7. QBasic Chapter 6 - LOOP STATMENTS
--------------------------------------


Within QBasic you can create a program which will do something for either a 
period of time or until a user makes the computer do something else. In this 
part of the tutorial I am going to introduce a few techniques which allow you 
to do this. We have already looked at one kind of loop which is the "FOR" and 
"NEXT" loop. This loop operates in a completely different way for previous 
examples. 

I am now going to introduce you to the "DO" and "LOOP" loop commands. Here is 
a Basic program which will just loop over and over again until the user stops 
it by pressing the keys CTRL & BREAK. Type it and run it by pressing "F5". 

CLS
DO
PRINT "HELLO WORLD"
LOOP

From this example you can see the words "HELLO WORLD" print forever down the 
screen. It might not be clear at this point, but the program is actually do 
something. You can ofter notice the flicker(if any) at the bottom of the 
screen. 

As you can see the "DO" and "LOOP" commands are quite effective even at this 
point. Let's break the commands down and see what they actually do. 

DO:

This command with set the start of the loop which executed everything in 
between the "DO" and the "LOOP" commands. 

LOOP:

The "LOOP" command is executed only if "DO" is present, such as the previous 
examples. Everytime a "DO" command is in your program it expects to find a 
"LOOP" command. 

There is more to "DO" and "LOOP" than just looping forever. Let's build onto 
the commands by getting some kind of response back from the computer. I am now 
going to introduce you to a further command called "WHILE". This command is 
quite effective but sometimes complicated to understand. Here is a simple 
example which need to be typed in and run. 

CLS
DO WHILE I < 10
    I = I + 1
    PRINT I
LOOP

The program may look complicated but really it is not. When you run the 
program it will simply print 1 to 10 down the screen. The program is actually 
checking to see if the variable I = 10 and if it does then the program will 
finish the loop. 

Firstly we are starting the loop and saying while I is not 10 then print the 
value to screen. In which case the program will jump straight back to the 
beginning and check the variable to see if it has reached 10. It is simple, 
but make sure you follow it through. Try changing the first line to a value of 
20 and see what it does? The line should now read: 

DO WHILE I < 20

Strange may it seem but if you now run the program it will print 1 to 20 down 
the screen. To take things a step futher we can now give you a choice on where 
to put the "WHILE" command. Before I do give you another programming example 
let me just briefly explain a little more about the "WHILE" command. 

WHILE 

There is only a little which I can tell you about the "WHILE" command because 
it is best explained in co-operation with another command called "WEND". The 
"WHILE" command allows you to check a condition of something to give results. 
As show in a previous example it is classed as a checking command. 

The "WHILE" command can be placed elsewhere in the programming example I gave 
you before and give the same results. Here is the code which does the same as 
before. 

CLS
DO
    I=I+1
    PRINT I
LOOP WHILE I < 10

So as you can see from the program above, it will give the same result if you 
run it by pressing "F5". So the "DO" and "LOOP" loop give's you some kind of 
flexibility when deciding when to place code into a program. This allows more 
control over program layout and design, keep this in mind. Loop's are 
explained and user in more detail later in the chapters. 

Understanding User Input:

User input is a vital part of any program. For example I have already covered 
how to handle variables and strings. Also I have covered how to use the 
"PRINT" command in a little detail. We are now going to put our built up 
knowledge into pratice and write a more complex program. Don't worry if the 
program look's a little complicated and clever, it is easy, just follow it 
through bit by bit and everything will come clear. 

CLS
        Password$ = "APPLE"
DO
        INPUT "What is your Password:", Pass$
        IF Pass$ = Password$ THEN Enter = 1
LOOP WHILE Enter  1
CLS
PRINT "You have Entered!"

After you type in the program and press "F5" the screen will clear and ask you 
to enter a password. If you enter anything but "APPLE" it will ask you again 
and again until it have been entered correctly. Remember that the program is 
checking to see if you are typing the program in lowercase and uppercase. This 
program will only except the word apple to be written "APPLE", not "appple". 
Later in the chapters I will explain how you change words that are in 
lowercase to uppercase without pressing the CAPS LOCK or SHIFT keys. 

A Easy look at WHILE:

Below is the source code for a more simple program which will demostrate the 
"WHILE" command. Type the following into QBasic and press "F5" to run. 

DO
    I = I + 1
    PRINT I
LOOP WHILE I  1000

The above program makes it more clear to understand the "DO LOOP WHILE" 
commands. If you type the program in a run it, it will count from 1 to 1000. 
This is easy to understand if you look at how the program is doing it. Firstly 
we are telling the computer to start a loop by using the command "DO". Next we 
are asking the computer to start a variable called "I". The next statement 
will print the value of I onto the screen, in which case the first number 
would be 0. The computer has started the variable at a value of 0. The next 
part of the program will check to see if the value in the "I" variable is 
1000, if not it will jump back to the start of loop, in which case it is the 
"DO" statement. The computer will then tell the variable to add one to the 
previous value of the "I" variable, in this case it would make "I" = 1 then 2 
then 3 etc. 

With the above program you could change the "I = I + 1" to "I = I + 2". This 
would cause the computer to add 2 to the variable "I" until the computer 
reaches the final statement which is the "LOOP WHILE" for checking to see if 
"I" has reached 1000. 

CLS
        oldname$ = "FRED"
DO
        INPUT "What is your name:", name$
        IF name$ = oldname$ THEN entrance = 1
LOOP WHILE entrance  1

Again above we are using a similar kind of program, like the password program, 
which allow's user input to check a variable against each other. The above 
program will ask you to enter a name. If the information you typed in is the 
same as what is contained in the "oldname$" variable then program will exit, 
if nothing is the same then the program will continue. 

Have a little pratice at using variable's with the "DO LOOP" kind of loops and 
see what you can come up with. In this chapter you have learnt the basic's of 
loop control with data input from the keyboard. In the next chapter I am going 
to introduce a simple menu program which uses a few new commands such as the 
"SELECT", "CASE" and "IS" commands. I shall warn you now that the next chapter 
might loose you a little, but hey it's part of the learning process. If you do 
get lost then please don't give up, just read through the chapter again until 
everything becomes clear. Very soon I shall be writing a program which uses 
virtually every command you have learnt so far. This program will be ideal for 
reference and just give you a general feel of how the commands put together 
can make some good programs. Until the next chapter keep going.


--------------------------------------
8. QBasic Chapter 7 - SELECT CASE
--------------------------------------


In this Chapter we are going to write a simple menu program which can be used 
in any of your own programs by just cutting and pasting in. You will need to 
change a few things, such as the text which is written on the screen. Before I 
go any further here is the code which is needed to be typed in. 

CLS
SCREEN 12
        COLOR 12
                LOCATE 3, 35
                PRINT "Main User Menu"
                LOCATE 4, 35
                PRINT "--------------"
        COLOR 10
                LOCATE 10, 35
                PRINT "1. Add"
                LOCATE 12, 35
                PRINT "2. Subtract"
                LOCATE 14, 35
                PRINT "3. Divide"
                LOCATE 16, 35
                PRINT "4. Multiply"
        COLOR 6
                LOCATE 25, 32
                INPUT "Enter Number (1-4):", number

SELECT CASE number

        CASE 1
        PRINT "You Selected number 1"

        CASE 2
        PRINT "You Selected number 2"

        CASE 3
        PRINT "You Selected number 3"

        CASE 4
        PRINT "You Selected number 4"

        CASE ELSE
        PRINT "Number typed was not 1 to 4"

END SELECT

Oh Yes, things are really starting to heat up. Just take a minute and look 
through the code. As you can see there is quite alot which you have learnt so 
far. The only bit you have not learnt is this: 

SELECT CASE number

        CASE 1
        PRINT "You Selected number 1"

        CASE 2
        PRINT "You Selected number 2"

        CASE 3
        PRINT "You Selected number 3"

        CASE 4
        PRINT "You Selected number 4"

        CASE ELSE
        PRINT "Number typed was not 1 to 4"

END SELECT

Trust me this bit is very easy. Firstly lets give you a breif run down of what 
the "SELECT CASE" statments mean. 

The "SELECT CASE" statement allows you to execute 1 of many statement blocks. 
For example a statement block is this: 

CASE 2
        PRINT "You Selected number 2"

In the above main program we have got 5 statement blocks which are "CASE 1", 
"CASE 2", "CASE 3", "CASE 4" and "CASE ELSE". Within the "SELECT CASE" part of 
the program above, the first line said: 

SELECT CASE number

This command is asking to execute a statement block on what is held in the 
variable called "number". If you look just above this part of the program you 
will see we have a "INPUT" command which is asking the user for a number. The 
"SELECT CASE number" command will use whatever statement block is asked for. 
So if we type in "2", within the program, the "SELECT CASE" statement will use 
"CASE 2", and then execute whatever is contained in the program after that, 
and before the word's "CASE 3" have appeared. 

The "CASE ELSE" command is used just incase the user types anything other than 
1 to 4. IF the "SELECT CASE number" command can't find a case on what the user 
has typed in, it will refer to the "CASE ELSE" statement to give a error 
message or do whatever the programmer has asked it to. 

Advanced "SELECT CASE":

Let's move onto something which is a little more advanced than the first 
"SELECT CASE" program. Within the next program we are going to use a command 
called "TO". You will see what it does later, but first type in the program 
which is shown below and run it by pressing "F5". 

CLS
        SCREEN 12
        COLOR 12
                LOCATE 3, 35
                PRINT "Main User Menu"
                LOCATE 4, 35
                PRINT "--------------"
        COLOR 10
                LOCATE 10, 35
                PRINT "1-2. Add"
                LOCATE 12, 35
                PRINT "3-4. Subtract"
                LOCATE 14, 35
                PRINT "5-6. Divide"
                LOCATE 16, 35
                PRINT "7-8. Multiply"
        COLOR 6
                LOCATE 25, 32
                INPUT "Enter Number (1-8):", number

SELECT CASE number

        CASE 1 TO 2
        PRINT "You Selected number 1 or 2"

        CASE 3 TO 4
        PRINT "You Selected number 3 or 4"

        CASE 5 TO 6
        PRINT "You Selected number 5 or 6"

        CASE 7 TO 8
        PRINT "You Selected number 7 or 8"

        CASE ELSE
        PRINT "Number typed was not 1 to 8"

END SELECT

At first glance it may not look any different than the first program, but 
notice the "TO" statement within the "SELECT CASE", "END SELECT" part of the 
program. The "TO" statement allows you to set a range of something within 
either a "SELECT CASE" statement or even the "FOR" and "NEXT" loops. Remember 
that you have already used "TO" within the "FOR" and "NEXT" statements in 
previous chapters. 

The actual program will allow you to respond to not just 1 number but to 2 
numbers within a range. So to execute the 4th "CASE" statement you would need 
to type 7 or 8 within the program when it is running. 

This command is down to common sense and can be understood if you think about 
what the program is doing. In the next chapter I am going to introduce a way 
in which to handle numbers within a program. I have briefly explained the 
usage of 

            =   -------> Is Equal To
            <>  -------> Is Not Equal To
            >   -------> Is Greater Than
            <   -------> Is Less Than
            >=  -------> Is Greater Than or Equal To
            <=  -------> Is Less Than or Equal To

in previous chapters. We are going to look at this a little more in depth. 
Thanks for reading so far.


-----------------------------------------------------
9. QBasic Chapter 8 - OPERATORS, RANDOMIZE FUNCTION
-----------------------------------------------------


Using numbers in QBasic is probably one of the most important things you will 
need to know when writing a QBasic program. For example if you are writing a 
game you would probably need to store the players score and any bonuses he/she 
might get. A simple example of adding a bonus score onto the main score would 
probably be this. 

bonus = 100
score = 500
score = score - bonus 
PRINT score

The program above tells QBasic to store the value of 100 into the "bonus" 
variable and 500 into the "score" variable. The following line will add both 
"score" and the "bonus" value's together add assign a new value to the "score" 
variable. This example just shows a way you can add to variable values to 
equal a new result. 

You could make things just a little more complicated. What if you have 4 
variable values that you wanted adding together? Well you could do something 
like the following. 

bonus = 100
score = 500
levelbonus = 200
luckscore = 100
score = score - bonus - levelbonus - luckscore 
PRINT score

Remember that you can add variable numbers which ever way but just making sure 
that they are not string's you are adding together just yet. The following 
examples shows other ways which numbers could be handled in any program. 

age = 21
new = 3
age = age - new
PRINT age

The above program is using the "-" operator to do the required job. In our 
language it is called subtraction. The next program allows you to see how 
working on numbers can effect the final result in a program. 

CLS
        apples = 2
        plums = 5
        oranges = 3

LOCATE 2, 1
PRINT "In Stock we have: "; apples; " Apples, "; plums; " Plums, "; oranges; " 
Oranges"
LOCATE 6, 8
PRINT "We have now sold 2 Plums and 1 Orange"

        plums = plums - 2
        oranges = oranges - 1

LOCATE 10, 1
PRINT "In Stock we have: "; apples; " Apples, "; plums; " Plums, "; oranges; " 
Oranges"

I have already explained briefly in previous chapters how to use some of 
these operators. 

            =   -------> Is Equal To
            <>  -------> Is Not Equal To
            >   -------> Is Greater Than
            <   -------> Is Less Than
            >=  -------> Is Greater Than or Equal To
            <=  -------> Is Less Than or Equal To

During any long program you will probably always use one or more of the above. 
With the above operators you can do operations on different numbers. For 
example you could check to see if something is the same or higher than. I 
don't know if you know but in the UK there is a tv show called "Play your 
Cards Right". In the game show they have to say if the next playing card is 
higher than the proceding one. For example say the first card is 6. The 
contestent has to say if the next card is higher or lower than the next one. 
If they say higher then 7 upto a ACE would win on that occasion. If 5 or lower 
came up after the contender had said higher then they lose. Games like this 
would be easy to write, and you would use many of the above to simulate this. 
Below is a simple guessing game. 

CLS
RANDOMIZE TIMER
        number = INT(RND * 10)
DO
        INPUT "Guess the number: ", guess
        IF guess > number THEN PRINT "To High"
        IF guess < number THEN PRINT "To Low"
LOOP UNTIL guess = number
PRINT "You Win"

Oh yes, sticking you in it here. I have now just introduced you to two new 
commands. The first one is "RANDOMIZE TIMER" and the other is "INT(RND)". 
Don't worry it may look a little complicated but actually it is very easy. Let 
me explain the two commands to you. "RANDOMIZE TIMER" is a way of generating 
really random numbers. "RANDOMIZE" on it's own would allow you to juggle 
numbers up, but when you place "TIMER" into the command then it juggles them 
much more. You probably will not use "RANDOMIZE" much unless you are writing a 
number game or something of that nature. 

However "INT(RND)" is probably something you will use alot. The "INT" part 
explains that it is looking for a integer. I have already explain integer's 
before in the chapter. To briefly explain more, a integer is a whole number 
and not some decimal place number like 4.3454. Integer's in variable's are 
sometimes a good thing because they make sure you are getting a whole number. 
If you were to obmit the "INT(" part of the program above you will find that 
the "RND * 10" statement will generate some decimal value between 1 and 10, 
like 5.3. This is where it brings me to my next point. The "(RND * 10)" part 
will generate a random number between 0 and 10 for me. If you were to put 
"(RND * 20)" you will get a random number between 0 and 20 generated for you. 
Remember that the generate random number will be placed in the number variable 
in the program above. 

The number checking routine is this part. 

        IF guess > number THEN PRINT "To High"
        IF guess < number THEN PRINT "To Low"

The first line of this is checking to see if the guess from the user is higher 
than the random generated number. If it is too high then the program will 
print "To High". The next line of the above is the complete reverse. It is 
checking to see if the guess from the user is lower than the random generated 
number. 

In the next couple of chapters you will see many of the operators in use, 
especially some which have not been explained yet. In the next chapter I will 
be introducing you to some graphic commands. Also you will learn how to snazz 
up your own programs to look appealing to the user. Thanks for reading so far.


-------------------------------------------------
10. QBasic Chapter 9 - BASIC GRAPHIC TECHNIQUES
-------------------------------------------------


Welcome to the next QBasic Chapter. Within this chapter I will be 
introducing you to some very basic graphic's programming techniques. A 
graphical look to programs can make them stand out and look appealing to the 
user. Most programs now contain some graphics from simple underlining of text 
to colourful windows of text. You can create anything you would like in QBasic 
with a simple set of graphical steps. 

When you program graphics on any computer in all languages it takes a little 
bit of thinking. Firstly you have to know where to put the graphics on the 
screen. That's maybe what you have thought of so far but have not figured it 
out. If you look close at you monitor or television you will see tiny little 
square pixels which make up you picture on the screen. Each one of these 
pixel's represent a simple location on your monitor. To place a dot at the 
very top left corner of your screen would need a co-ordinate. A co-ordinate is 
a specific number location. Don't let me confuse you but for example say you 
wanted to place a dot in the middle of your screen, you would need to have a 
value to place the dot there. Take a look at the diagram below. 

   --------------------------------------------
  |                                            |
  |    .                                       |
  |                                            |
  |                                            | 
  |                                            | 
 y|                                            |  
  |                                            |
  |                                            |
  |                                            |
  |                                            | 
  |                                            | 
  |                                            |  
   --------------------------------------------
                        x  

The diagram above is simposed to represent your monitor or television screen. 
Running up the screen is what is known as a "y" axis. Running along the bottom 
of the screen is what is known as a "x" axis. Now if you look closely you will 
see a dot in the near to left side of the pretend screen. If we wanted to 
place a dot there we would need to know the co-ordinate value of the screen. 
We would do this quite easy in QBasic. Within QBasic, the very top left of the 
screen has a co-ordinate value of 0,0. This co-ordinate value represents the 
axis x,y as explained above. Now to create the point on the pretend screen 
above we would need a approximate co-ordinate of 100,100. This co-ordinate 
would bring the point 100 pixels of the screen from the left and 100 pixels of 
the screen down from the top. If we wanted to bring the point on the screen 
further down we would need to have a co-ordinate value of around 100,300. Let 
me show you a very simple program to do what I have just explained above. Type 
this in a press the "F5" key to run. 

SCREEN 12
PSET (100,100),2

The program above is very simple. Firstly we are changing screen's from the 
default text screen to a graphics screen. The next line is our very own 
graphics command called "PSET", which I believe stands for Point Set. On the 
line of code above we are asking to have a little dot drawn on the screen at 
co-ordinate's 100,100. 100 pixels from the left and 100 from the top of the 
screen. The number which follows is the colour of the dot which is placed on 
the screen. In the above program I have used a simple colour of green. If you 
leave the colour number out it will use a default colour of white. 

The "PSET" command can be used in many other screen modes like other graphics 
commands. You will need to try different screen modes out, but remember 
resolution will change. Resolution is what is known at different screen sizes 
such as a standards Window's screen mode would be 800x600 pixels. The 
resolution of the screen we used in the above example is 640 pixels across and 
480 down. So you can place a dot(point) anywhere within those values. 

Now "PSET" is a very simple command. Let me now introduce you to something a 
little different. Lines are very popular and are used quite often in programs. 
For example a line can build a shape such as a rectangle or square. The "LINE" 
command works a little different than the "PSET" command in the way that it 
draw's the lines on the screen. Below is a simple example which I would like 
you to type in a try. 

SCREEN 12
LINE (100,100)-(200,100)

The above program will draw a line from one location to another. Firstly we 
are again asking to be put into a graphics mode. We are then going to draw the 
line from one location of the screen to another. For example we are drawing a 
line from the co-ordinate 100,100 to the co-ordinate 200,100. This will simple 
be saying draw a line from 100 across and 100 down to 200 across and 100 down. 
It's fairly simple if you think of it like that. Type the following program 
in. 

SCREEN 12
LINE (100,100)-(200,100)
LINE (200,100)-(200,200)

The above program is virtually the same as the last one but the next "LINE" 
command is drawing a line straight down the screen from the first "LINE" 
command. 

Task 3:

See if you can create a program which will draw a simple box on the screen 
using the bit's from above which you have just learned. Tip: Remember that you 
only need to use the information which is contained in this chapter to write 
the program. The program has been written at the end of the program to see if 
you are right. 

Even More Graphics:

To extend your knowledge of QBasic's graphics features I am now going to 
introduce you to a command which extends you knowledge on what you have 
learn't above. The next graphic's command is called "CIRCLE". 

"CIRCLE" works quite like the "PSET" command, except that it requires a 
important value at the end of the command. Please type in and try the next 
program. 

SCREEN 12
CIRCLE (100,100),50

This program will draw a neat looking circle on your screen. Firstly we are 
simply changing into a graphics screen mode then setting the co-ordinate's to 
a location on your screen. The next part of the command set's the circle's 
radius. Above we are using a small radius of only 50 but that can be set to 
much higher. The "CIRCLE" command's place's the circle differently on your 
screen. If you don't want to be confused then don't read the next paragraph. 

When you plot a circle on the computer screen it is not actually plotting it 
at 100,100. As you will see if you change the line above to: 

SCREEN 12
CIRCLE (0,100),50

When you run this program you will see that only half the circle has been 
drawn. The co-ordinate value of the circle is the center of the circle. It 
seems complicated but true. You will find that if you use the "CIRCLE" command 
alot, you will learn how it works. 

Extending Line's to Boxes:

Lines are all very well in a program, but what do you do if you want to draw 
boxes? Well firstly the "LINE" command can do all the hard work for you. Type 
the following the program in and then try it out. 

SCREEN 12
LINE (100,100)-(200,200),4,B

Oh! Yes. We have a simple box created. Before I go any further I would like to 
say that the above program is not a solution to the task I set you a little 
while ago. The solution to the task is available a little later. 

The program above will draw a simple box with only one line of code. The box 
is created in a red colour and it has all been possible from a simple change 
of code. The "LINE" command has now a "B" letter on the end which means "BOX". 
To go one step further than this try changing the "B" to a "BF". Run the 
program, and yes, you have now created a simple filled box. 

As you can see, many different effects can be created with just a few simple 
graphic commands. The graphic command's will always take some experimenting to 
get things exactly right. You will find that the QBasic co-ordinate system 
will also take a little while to get the hang of. After a period of time you 
really will be able to brighten up your programs. 

Solution to Task 3:

To draw a simple box using the four "LINE" commands are as follows. Try it 
out! 

SCREEN 12
LINE (100, 100)-(200, 100)
LINE (200, 100)-(200, 200)
LINE (200, 200)-(100, 200)
LINE (100, 200)-(100, 100)

The chapter has introduced you to a simple set of graphic commands made 
available in QBasic. Remember that it has only touched the surface of what 
QBasic can do. In future chapters I will introduce some more graphic commands 
and build upon what you have learn't so far. In the next chapter I will be 
introducing you to way's in which you can improve you programming code buy 
using procedures. With this you can make your programs look better and more 
easy to understand. Keep up the experimenting. 


-------------------------------------------------
11. QBasic Chapter 10 - GOSUB, SUB PROCEDURES
-------------------------------------------------


Welcome to Chapter 10. Before I explain what a Procedure is let me introduce 
you to something called a Subroutine. Subroutines are sections of code which 
are left for easy access and basically tidy up your QBasic code so that it is 
easy to read and follow. Firstly let me explain the two command's that will do 
all of the work in QBasic. 

Gosub:

A "GOSUB" command is a control flow statement which branches to another part 
of a program. In other words it links part of your basic program to another 
part of the program to carry out some kind of action. With the "GOSUB" command 
you will need to specify a Label. A Label is part of which the "GOSUB" will 
link to. I will show you a programming example on this in a moments time. 

Return:

A "RETURN" command allows you to jump back or to a label. For example you can 
"GOSUB" to 1 part of the program and then return back to it later to continue 
on. The method is simple and all different types of programs can be 
constructed. Here is a programming example on using these two commands. 

CLS
    PRINT "A Simple GOSUB Program"
    PRINT "----------------------"
    PRINT "Firstly we are going to jump to another program and print 
something"
    GOSUB hello
    PRINT "Finished, we are safely back now"
    END

hello:
    PRINT "Hello we have jumped"
    PRINT "Let's Go Back and finish the program."
RETURN

As you can see everything look's fairly simple. First we are doing the same 
old stuff you have learn't in previous chapters. The important statement is 
the "GOSUB hello" bit. Within this line we are telling the program to go and 
find the label called "hello". So the program searches the rest of the program 
until it find's the label it's looking for which is the "hello" label. 
Contained within the "hello" label is the code which is executes. The code 
just print's some simple text on the screen. Once it has done this, it jumps 
back to where it comes from, which is the "GOSUB" statement. The computer 
remember's all of this information once the "GOSUB" statement has been 
reached. To put this theory into example we will write another short program 
which will jump to two different place's in a program. Type the following in 
and then press "F5" to run. 

CLS
    PRINT "Another Simple GOSUB Program"
    PRINT "-----------------------------"
    PRINT "Firstly we are going to jump to the First Label"
    GOSUB label1
    PRINT "Finished, we are safely back from Label1"
    PRINT 
    PRINT "Next we are going to jump to the Second Label"
    GOSUB label2
    PRINT "Finished, we are safely back from label2"
    END

label1:
    PRINT "Hello we have jumped to Label1"
    PRINT "Let's Go Back and jump again."
RETURN

label2:
    PRINT "Hello we have jumped to Label2"
    PRINT "Let's Go Back and finish the program."
RETURN

As you can see it is quite useful to have subroutines in any QBasic program. 
Let me just advise you on a few things: 

1. Make sure you don't use reserved word's like "PRINT", "STOP", "LOCATE" etc 
for you label names. 

2. Make sure you call your label names something meaningful for what the 
subroutine is doing. For example you might call a scoring subroutine in a game 
called "score:". 

3. Subroutine labels always have a semicolon on the end. If you miss it out 
you will get a error. 

Programming Example's Selection 1:

Here are a few programming example's you may want to try out. I have used many 
command's from previous chapters to show you how programs can link together. 

Password Program:

CLS
        PRINT "Password Program 2"
        PRINT "------------------"
        PRINT
        INPUT "Please Enter Password:", password$
        IF password$ = "apple" THEN GOSUB enter ELSE GOSUB wrong
        END

enter:
        CLS
        PRINT "Welcome, you have entered Correctly"
RETURN

wrong:
        CLS
        PRINT "Sorry, You have entered the wrong Password!"

Above is a simple program which will ask for a password. You need to enter 
"apple" to be successful, otherwise the program will report that you have 
entered the wrong password. 

Menu Program:

CLS
        PRINT "Menu Program"
        PRINT "------------"
        PRINT
        PRINT "1. Open File"
        PRINT "2. Save File"
        PRINT "3. Quit Program"
        PRINT
back:
        LOCATE 8, 10
        INPUT "Select:", number

        IF number = 1 THEN GOSUB option1
        IF number = 2 THEN GOSUB option2
        IF number = 3 THEN GOSUB option3 ELSE GOSUB back

option1:
        LOCATE 10, 10
        PRINT "Option 1 Selected"
        RETURN

option2:
        LOCATE 10, 10
        PRINT "Option 2 Selected"
        RETURN

option3:
        LOCATE 10, 10
        PRINT "You have finished the Program"
        END

The above program allows you to select either 1,2 or 3. Depending on which key 
is pressed it will link it to the relevant label called either 
"option1","option2" or "option3". This is a great example of how to create 
simple menu's. 

Something which I have not mentioned yet is a command called "REM". This 
command stand's for remark's or reminders. You can simple type "REM" into a 
program and whatever is followed on that line, will not be executed but left 
to remind you of something. Many programmer use this command to remind them 
what that line actually does. Below is a quick example. 

CLS
    REM Below is a simple Printing Program
    PRINT "HELLO"

It is a really basic program but it show's you the point. If you really wanted 
to show off you could use a ' as a rem. Here's how. 

CLS
    PRINT "HELLO"       ' This command will print the word's "Hello".

Whatever it displayed after the ' symbol will not be used within the program. 
You could try placing the ' symbol on a line of it's own. Below is another 
programming example. 

CLS
' We are now going to print "HELLO"
    PRINT "HELLO"
' We could then end the program with the "END" command
    END

As you can see the "REM" and ' symbol is quite a useful command to know. It is 
a excellent way of commenting your programming code for other's to understand. 
You may now find in some of my programming example's the use of the "REM" 
command and ' symbol. Try to use this where possible, you don't realise how 
easy it is to forget what part of a program does what. 

Introducing SUB Procedures:

I must advise you that thing's might start get a little confusing when reading 
this next part of the chapter. If you do get lost then please try and read it 
over until it make's common sense. I will however try and make thing's as 
simple as possible to understand. 

SUB Procedure's work slightly different to SUB Routines, as explained above. 
With a Sub Procedure you can work on a particular part of a program without 
the rest of it interfering. For example you could write a menu program and 
create the results of each menu item separately away from your program, but 
you can access it very easy. Let me put this into a little more perspective 
for you. 

Say you have written a computer game which allows you to shoot aliens. 
Everytime a alien has been shot it increases your score by 50. You could 
create a Sub Procedure to do this without having to write the code to do this 
over and over again. Before I show you how to write a complete Sub Procedure, 
let me show you how to create one within QBasic's Editor. 

How to create a Sub Procedure:

Make sure you have started with a clean page, if you have not then please 
select "NEW" from the file drop down menu. Once everything is how it should be 
you will be ready to create a New Sub Procedure. Type "SUB hello". Once you 
have done this and pressed return, you will now enter the Sub Procedure 
editing mode. This is the part which is covered below. 

Microsoft QuickBasic User's:

The above theory works fine with QuickBasic, but you could also do this. 
Within the QBasic editor move your mouse over the "EDIT" drop down menu and 
click on "NEW SUB". If you have no mouse, keep your finger down on the ALT key 
and press "E". This should bring down the "EDIT" menu from the title bar. Now 
move the Selection bar down with the down arrow key to highlight the "NEW SUB" 
option. Now press return. 

Once you have done, what I explained above you should see a Window pop up 
asking you for a New Sub name. This is the box where you enter your New Sub 
Procedure name. Let's call this one "hello". Type the word "hello" in the 
"name:" box. If you now click on the "OK" box or press return, you screen area 
will change and present you with something which look's a little different.

Your menu option's will be different than mine. This is because I am using the 
commerical version of QBasic called QuickBasic. Don't worry about this because 
everything that I am explaining to your will still work the same. 

As you can see from the screen shot above, your working area should just have 
to lines written. These are "SUB hello" followed on the next line by "END 
SUB". Between these two lines you enter all the code which you want it to do. 
Type the below into the editor's Window. 

SUB hello
    PRINT "Hello, you have accessed a Sub Procedure."
END SUB

Once you have done this you are now ready to continue writing the program like 
the way you have done in previous chapters. Basically you can forget what you 
have written above for now. To get back to the working programming screen you 
need to select the "VIEW" drop down menu. You can do this like you did before 
with the "EDIT", but instead of clicking on the word "EDIT", you need to click 
on the word "VIEW" with your mouse. Again you can press the ALT key followed 
by the "V" key to do this.

Move the menu selection bar down to the "SUBs" item, once highlighted click 
the mouse button or press the "Return" key. Remember that my menu's may look 
different because I am using the commercial version of QBasic. Once you have 
done this you will be introduced to another screen with a different Window on 
it.

You will now see the word "Untitled" highlighted in the window. The word 
"Untitled" is the name of your main program. This is called a Module. Your 
main program(module) will call or link to the Sub Procedure for it to carry 
out it's task, which basically is the code which you put into the Sub 
Procedure in the first place. Anyway as you can see. Your main program(module) 
is called "Untitled" followed by your new Sub Procedure called "hello". In 
order for us to call this new Sub Procedure called "hello" we need to place 
ourselves back into the main program(module). We can do this by either double 
clicking on the word "Untitled" or by pressing the "Return" key now. You can 
also press the "Edit in Active" button with the mouse. 

If you have done the above correctly you will now enter the main 
program(module). This is where you were in the first place before I introduced 
you to all this procedure stuff. You are probably thinking thank heavens for 
that. 

O.k, you are now ready to write a program to call or link to the Sub Procedure 
you have created. This is probably the easy bit, however for a punishment I 
have to introduce you to another new command in QBasic. 

Declare:

Everytime you create a new Sub Procedure you must declare it's use in the main 
program(module). The reason for this is simple. Everytime a program run's 
within QBasic, you need to tell the program that each Sub Procedure is there 
to be used. So in the building of the current program we have created a simple 
Sub Procedure. But in order for us to use it we must tell QBasic that it is 
there for use to use. Firstly we shall look at the basic methods of the 
"DECLARE" statement. For us to tell QBasic that we have a Sub Procedure called 
"hello" we must first type this line into the main program(module) window, 
which you should have in front of you now and it should not contain any 
programming code in it. Please enter the following code. 

DECLARE SUB hello ()
CLS
hello

The "DECLARE" statement works like this. Firstly we are saying that the Sub 
Procedure is called "hello", which you already know. Secondly we have some 
opening and closing brackets. These brackets represent something we shall 
build on later called arguments. Don't worry about these for now, just make 
sure you include them in the program at all time's unless otherwise told to do 
so. 

The next line clear's the screen for us. The following line is the interesting 
bit. This is where all the interest takes place. We are now calling the Sub 
Procedure called "hello" which we have already written previously. All you 
need to do is type the name of the Sub Procedure and it run's everything 
within the Sub Procedure within the program. It's very easy to understand once 
you know how. Press "F5" to run the program and see what's happening. 

So there we go, a very basic introducion to Sub Routines and Sub Procedures. 
Remember that this chapter cover's the very basic's of Sub Procedures, you 
will learn more about them in future chapters. In the next chapter I will 
write a program which uses not just one Sub Procedure but a couple just to 
show you how it works. For now, keep programming and see you soon. 


---------------------------------------------
12. QBasic Chapter 11 - CREDITS....REGISTER
---------------------------------------------


Registering:

To receive the latest 1-16 chapters and much more, you are probably best to 
Register "The Beginners Basic Helpfile". This is a Window's Helpfile which 
contains all these chapters and a further 6 more. Please contact The 
Beginners BASIC Web Page On The Internet at:

http://intermid.com/basic/basic.htm

Credits:

Originally by Steve Salmon for the Beginners BASIC Web Page, later edited by 
Arpith Jacob for the QBasic/QuickBASIC help file.
<PAGEEND:"Tutorial.Tutorial1.File">

<PAGESTART:"Tutorial.Tutorial2.File">
DECLARE SUB V1 ()
DECLARE SUB U (A$)
DECLARE SUB V2 ()
DECLARE SUB V3 ()
DECLARE SUB V4 ()
DECLARE SUB V5 ()
DECLARE SUB V6 ()
DECLARE SUB V7 ()
DECLARE SUB V8 ()
DECLARE SUB V9 ()
DECLARE SUB VA ()
'>>> Page 1 of QBASIC.DOC begins here. TYPE:BINAA TLEN:96256
'-------------------------------------------------------------
'                  INSTRUCTIONS FOR DECODING
'If there are multiple parts to this file, merge them into one
'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all
'message header and footer information (everything outside the
'">>> Page x of..." lines),  load the result into your version
'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original
'file will be decoded into the current directory on your disk.
'-------------------------------------------------------------
DEFINT A-Z: DIM SHARED K, S, B&, Z&: V1'Created by PostIt! 7.3
V2
V3
V4
V5
V6
V7
V8
V9
VA
CLOSE : IF S = 75 AND B& = Z& THEN PRINT " :) Ok!" ELSE PRINT " :( Bad!"
'>>> Page 1 of QBASIC.DOC ends here. Last page. TCHK:75

SUB U (A$) : FOR A = 1 TO LEN(A$): C = ASC(MID$(A$, A)) - 37: IF C < 0 THEN C = 91 + C * 32
IF K < 4 THEN K = C + 243 ELSE PRINT #1, CHR$(C + (K MOD 3) * 86); : K = K \ 3: B& = B& + 1
S = (S + C) AND 255: NEXT: LOCATE , 1: PRINT STRING$(B& * 50 \ Z&, 219); : END SUB

SUB V1 : OPEN "O", 1, "QBASIC.DOC", 4 ^ 6: Z& = 96256: PRINT STRING$(50, 177);
U "cIH6Ybp*?Z%%%%%%%%%%%%%%%%%%%%%c%(%-wx.%%+%%%%%%%%%%%%%%'%%%%&%"
U "%%%%%%%%%5%%%'%%%%&%%%uwxxx%%%%%%%%%%&J%%%uxxxxuxxxxuxxxxuxxxxu"
U "xxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxx"
U "xuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxux"
U "xxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx"
U "uxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxx"
U "xxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxu"
U "xxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxx"
U "xuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxux"
U "xxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx"
U "uxxxxuxxxxuvxxxuwxxxuwxxx%)%%%%*%%%%+%%%%,%%%%-%%%%.%%%%/%%%%9%"
U "%%%1%%%%2%%%%3%%%%4%%%%5%%%%6%%%%7%%%%8%%%%(%%%%:%%%%;%%%%<%%%%"
U "=%%%%>%%%%?%%%%#%%%%A%%%%B%%%%C%%%%D%%%%E%%%%F%%%%G%%%%H%%%%I%%"
U "%%J%%%%K%%%%L%%%%M%%%%N%%%%O%%%%P%%%%Q%%%%R%%%%S%%%%T%%%%U%%%%V"
U "%%%%W%%%%X%%%%Y%%%%Z%%%%[%%%%\%%%%]%%%%^%%%%_%%%%$%%%%a%%%%b%%%"
U "%c%%%%d%%%%e%%%%f%%%%g%%%%h%%%%i%%%%j%%%%k%%%%l%%%%m%%%%n%%%%o%"
U "%%%p%%%%q%%%%r%%%%s%%%%t%%%%u%%%%v%%%%w%%%%x%%%%y%%%%z%%%&%%%%&"
U "&%%%&'%%%&(%%%&)%%%&*%%%&+%%%&,%%%&-%%%&.%%%&/%%%&0%%%&1%%%&2%%"
U "%&3%%%&4%%%&5%%%&6%%%&7%%%&8%%%&9%%%&:%%%&;%%%&<%%%&=%%%&>%%%&?"
U "%%%&#%%%&A%%%&B%%%&C%%%&D%%%&E%%%&F%%%&G%%%&H%%%&I%%%&K%%%uvxxx"
U "&L%%%&M%%%&N%%%&O%%%.w%>%/>%C%%E%j%/=%C%/A%H%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;%*%uxxxxuxxxx%&%%%%%.'%%"
U "%%%%'9%%%%%%%k%%%%%%%%%%%%%%%8/&sg;II4&'3%%%&O%%%%%%%%/&%>%/A%3"
U "%.i%>%/2%D%/<%4%/=%C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%?%'&%'%%%uxxxxuxxxx%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%0%%%(':&%%%%%%%&%h%/>%<%&?%t%/1%9%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%7%'%uxxxxuxxxxuxxxx%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&-%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%uxxxxuxxxxuxxxx%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&%%%uwxxxuxxxxuxxxxuxxxxuxxxxuxx"
U "xxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxu"
U "xxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxx"
U "xuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxux"
U "xxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx"
U "uxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxx"
U "xxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxu"
U "xxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxx"
U "xuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxux"
U "xxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx"
U "uxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx%HEEE%EEEELi>D1);422Lf?"
U "?4M=38=J6E>=J4E>5LEC74DB4EBMH<1>D;BECJ>EC7J4E=0D<4E>/5E0EME0A8M"
U "01;4LEF74J=EH>JDEDBJ4E8C1E8=E2C74EM?A>62A0<EMC4;;JBEC7J4E2>M<?D"
U "CD4AEC270CE2H>DE20A4EMDB8=J6E8C1E0BEMC70CLECH?&4SE2I2y78JBE8BLE"
U "02CMD0;;/HE0EM3855M82D;JCE2>M=24?JCEC>LE6A0DB?E5D>AE=M4F2>M<4AB"
U "1EC>EM?A>6MA0<<28=6SIEy74LE<>BJCE2>M<<>=LE4AAD>AE8&=EvgM0B821E8"
U "BE2C74EM8=50M<>DBIEyH?A4Er8MB<0CD27EFM7827LEH>DLEF8;J;EB4/4E0E2"
U ";>CSIEy78JBE<420=BEMC70CLEH>DLE0A4LECAH28=6EDC>E?DDCE0LEE0;DD4E"
U "82=C>EJ0EE0MA801D;4E>J5EC7J4EFA2>=6EMCH?4ISE(>JDE<8267CED14ECMA"
U "H8=J6EC>LE?DCLEC74LE;4CMC4ABIEG78LEC74)A4GEM8=C>1E0=EM8=C4264AE"
U "ME0A8M01;4#SEn5LEH>DLE3>=CLCE3M458=J4EC7J4ECHD?4E>J5EC7J4EE0MA8"
U "01);4QEMC74=#Evg02B82EM0BBD2<4BED8CE8JBE>5LEC74IEx8=26;4EMCH?4I"
U "QEF72827E220=EM>5C4J=EH824;3EMD=4GM?42CD43EAM4BD;)CBSEInE?4MAB>"
U "=M0;;HLE?A4254AEDC>EDDB4ECD74EC2H?4EMBH<12>;BEM05C4JAEE0MA801D;"
U "4E=M0<4BIQE1DJCE2>D<4E4MG?;8M28C;JHE34M2;0AJ4EC7D4<EDMBD0;D;HE0"
U "JCEC7J4E74D03E>J5EC7248AEM?A>6MA0<B%SE22%2xjh%ynts%EWER%Ensy%jw"
U "fh%ynsl(E&ny%mEym%jEht%ruzy#jw2(D>DE:2=>FEMF70CCE0EEM0A8021;4ED"
U "8BE0D=3E7D>FECJ>E2>M=CA>J;EC7)4<QED8CLBLEC8<J4EH>JDE;4M0A=4J3EB"
U ">D<4E?MA>6AM0<<8)=6SEIvg0B)82EMM;8:4LE0;;LE>C7D4AE;M0=6DM064BIN"
U "E8BLEB4C1ED?EMDB8=J6E?AJ4R34M58=4J3EBCM0C4<M4=CBLE022M>A38D=6EC"
U "J>EC7J4EBHM=C0GLEB?4M2858D43E5D>AEC270CEMBC0CM4<4=&CSEnJCE<0JHE"
U "14LE74;M?5D;1EC>EM;>>:1E8=E2C74EM74;?LE8=3D4GECJ>E;420A=EJ0EBCM"
U "0C4<24=CQLE0;CM7>D6&7EnLDE4E7M40A3LE<0=JHE2>M<?;028=CLJBEC7D0CE"
U "CD74E724;?EM8=34JGE8BLEC>>LE70A&3SEnM=344J3E8C1E8BE2C>>EM70A3LE"
U "5>ALE=4FLE?A>M6A0<M<4ABIQE1DJCE0BLEH>DLE;40DA=E<2>A4E20=3EM<>A4"
U "LEBC0MC4<42=CBE20=3EMC748JAEBHM=C0G)4BQE2H>DLD;;E1M42><J4E02M2D"
U "BCM><431EC>E2C74EM8=34JGE0=J3EDBJ4E8C1E0BEJ0E20MBD0;LEA45M4A4=)"
U "24SELq4CBLE<0:/4E0EM?A>62A0<EMC70CLE?A82=CBEMB><4LEC4GJCE>=LEC7"
U "4LEB2A244=SIEyH?J4E#1M0B821E0CE2C74E%itxEM?A><D?CE0D=3E4M=C4ALE"
U "C74LE5>;M;>F8D=6E?MA>6A)0<SE%22hq%x2uw%nsyEIGy78JBEC4DGCEF28;;E"
U "M0??4D0AE>J=EC7J4EB2MA44=%G2js%i22yD74E5M8ABCLEBC0MC4<4)=CER%RE"
U "hq%xERRLEBC02=3BE25>AELG2;4D0AEBM2A44&=SGECnCE4MA0B4JBEF7M0C4ED"
U "4AEFD0BE>J=EC7J4EB2MA44=LE1452>A4ED8CEFD0BE4MG42D2C43S%Euwn#syE"
U "BM8<?;JHE38MB?;0DHBE8DCBE0MA6D<24=CEDC>ECD74EBM2A44J=E0CLEC74LE"
U "2DAMA4=CLEC4GJCE2DMAB>ALE;>2M0C8>&=SEyD74E0MA6D<24=CED8=EC278BE"
U "M20B41E8BE2C74EMC4GCLE4=2M;>B4J3E8=LE#D>2C4BS%Euwn#syE3M8B?;20H"
U "BEMC4GCLEF8C278=EM#D>CD4BE3M8A422C;HQ1E>AED8CE2D0=E3M8B?;D0HECD"
U "74EEM0;D41E>5EJ0EE0MA801);4QEM;8:4LEC78&B_E2%2hqx(20JE%bEZU(21J"
U "E%bEVU%U2uw%nsyEIGy74LEE0;DD4E>/5E0E)8BEG.$E0J%$EGE20=3E2C74EME"
U "0;DJ4E>5CE1E8&BEG$(E1J2%jsi2I2y78JBEF8D;;EHM84;3LEC74LE>DC2?DC$"
U "IEy74LEE0;DD4E>/5E0E)8BEZIUE0=J3EC7J4EE02;D4ED>5E11E8BE%VUUSIEy"
U "74LEB4<M82>;2>=BEM8=38M20C4LEC70JCEC7J4E=4DGCEC28<4EMB><4MC78=J"
U "6E8BLE?A8M=C43IQE8CLEF8;J;E14LEA86D7CE0M5C4ALEF74DA4ECD74E;20BC"
U "E%uwnsIyEBCM0C4<24=CEM;45CLE>55#SEw4M<4<1D4AEC270CE%uwnsIyE?AM8"
U "=CBLE;8CM4A0;D;HEF270CED8BE8M=B83J4E#DM>C4BIQE0=J3EC7J4EE02;D4E"
U "D>5ECD74EEM0A8021;4EMF782J7E8BLE=>C1E8=EM#D>C)4BSEA0JE0D=3E1IJE"
U "0AJ4E8=MC464DABE2M>=C0M8=8=J6EE0M;D4B1E8=EMC78BLE4G0M<?;4IQE0=J"
U "3EC7248AEME0;DD4BE0DA4E?MA8=CD43EDMB8=6LEC74%Euwn#syEBMC0C4M<4="
U "C#SEx0JHEH>JDEF0D=CECJ>E8=MC4A0D2CEF28C7E2C74EMDB4ALE=>FISE(>JD"
U "L;;LE=44J3EC>LE;40DA=E0LEBC0MC4<4D=CE2M0;;4&3Ens%uzyS%Ensu#zyE3"
U "M8B?;20HBEJ0E?AM><?CIEMC7J4E582ABCEM0A6DM<4=CINE0=J3E0BMB86=JBE"
U "F7D0CECD74ED2B4AEMCH?4JBE8=1EC>EJ0EE0MA801);4EM2C74EMB42>D=3E0M"
U "A6D<24=CN%E22h%qx2n%suzyIEG&7D0CE8JBEH>DDAE=20<4d%EGQEMH>DALs0<"
U "4%I2ns%uzyEIGm>FLE>;3LE0A4LEH>D%dEGQLE064%J2uw%nsyE.Gx>Q%EG$EMH"
U ">DALs0<4%I$EGIQEH>JDE0A&4EG$LE064%J$EGLEH40DABE>);3SEIEy70/CLBE"
U "M8=C4MA4BC28=6S%G2js%i22y278BEM58ABDCBE02B:BE2C74EMDB4ALE5>ALEC"
U "74D8AE=20<4E20=3EM0BB826=BED8CECJ>EC7J4EBCMA8=6LEE0AM801;J4EH>D"
U "DAs0)<4ISIEy74J=EC7J4E06J4E8BLEA4#MD4BC)43QE20=3E2C74EMA4BDD;CE"
U "8JBE?AM8=C4J3E8=CE0EBM4=C42=24SIEyAH1E8CE2>DCF.Ex>EMF70CLE70?M?"
U "4=B1E85E2H>DEM8=?D&CEnE%itsL%yEpsCt&E5D>AECD74E0D64E?MA><?ACdE("
U "D>DL;J;E64/CE0EMF48AJ3E<4MBB06J4EC7D0CEB20HBE%wjit%Ekwt%rExy%fw"
U "ySLE&7H#dEy7J4E?AM>6A0J<E8BLECAH28=6EDC>E0MBB86/=E0EMBCA8)=6EMM"
U "C4GCINEC>1E0=EM8=C4264AELM=D<214ANLECH?A4QE0D=3EC278BEM<0:4JBE="
U ">LEB4=DB4EBJ>EC7J4EDBD4AE8JBE0B2:43EDC>E3J>E8CLE>E4JAE06208=SIE"
U "f=>MC74ALE2>AM=4ABMC>=41E>5EM?A>6MA0<<28=6ED8BECD74E2M>=38MC8>="
U "D0;EC24BCSIEg0BM820;);HQE2C74EM?A>62A0<EMC4BCJBE85CE0E2M>=38MC8"
U ">=1E8BEMCAD4IQE0=J3E851E8CE)8BQED8CE32>4BEMB><4MC78=&6SEnJCE;>2"
U ">:BEM;8:4IEj=6M;8B71EB>ED8CLBLE=>C1E0BEM70A31E0BED8CEBM>D=3&BSE"
U "2%2hqx%2uwn%syEG%VSExD0HE7M4;;>%GEEE%EEELLE>?C28>=E%V2uw%nsyE%G"
U "WSE1x0HEM=824LEC84%GEEEILE>?MC8>=%EW2n%suzy#EGj=2C4AEMH>DALEB4;"
U "M42C8)>=EGIQEB4M;42C28>=J%2EEnIkEB4M;42C28>=J%EbEV%Eymj%sEuw%ns"
U "yELG74;);>G2%EEnkLEB4;M42C8)>=JE%bEWE%ymjs%Euwn%syEGM=824LEC84%"
U "G2js%i22yD74ED2B4AED8BE6M8E4=CE0EBD4CE>J5E>?MC8>=ABQE0D=3EC274="
U "EMC74HLE8=?DDCE0LEE0;DD4EFM78271E8BEM0BB8M6=431EC>E2C74EME0A8M0"
U "1;4LEB4;M42C8)>=JSIEy74LEE0;DD4E>J5EB4M;42C28>=J1E8BEMC74=LEC4B"
U "2C43QLE0=3LE2>3J4E8BLE4G4M2DC4J3E102B43ED>=ECD74EEM0;D4#SEn5LEC"
U "74LEDB4JAE?AM4BB4&3EVQ1E8CEM?A8=DCBE7M4;;>IQE1DJCE85LEC74JHE?AM"
U "4BB4&3EWQ1E8CEM?A8=DCBE=2824E2C84SIEf;BJ>E=>MC824LEC74LEC4GJCE0"
U "52C4AE2C74EILE8=LEC74LE2>3&4SEyM74B4LE0A4LEA4<20A:EMBC0CM4<4=)C"
U "BSELf=HCM78=6LE?A8M=C43LE05CD4AE0#ELE>/=E0EM;8=4LE3>4JBE=>JCE05"
U "M542CLEC74LE>DCM2><41E>5E2C74EM?A>62A0<SIEg02J:EC>LEC74LE02C2D0"
U ";EM2>34%ERRE21DCEMF70C1E85E2C74EMDB4ALE3>4DB=LCLE8=?)DCEV3Ut4%+"
U "H9.)%%%%%%%%%%%%%%%%%%%%%9(%%,^g%%(':&%%%%%%%%%%%%%%%%%%%%%,Jd%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(Q9&%&;%%%(Q9&%&;%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(99&%%9%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(%9&%%/%%%(/9&%%/%%%%%%%%%%%"
U "%%&y'%%&9%%%(M9&%%)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*e9&%%'%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)g9&%%y%%%*g9&%%9%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.%%G%&g%E%%B%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%.%%9%%8%%%%%%rxIEx0=ABEx42A85%%1%%%#'%"
U "xHM<1>;%%1E%%%%%xMHBC4&<%:%%%%%%Ly8<4ABEs4AFEw>2<0=%%6%%%#%%h>M"
U "DA84AAEs4&F%6U%%%%%Lh>DA284AE1s4F%%vgfx%nh2fLECDCM>A80A;EgH%ExS"
U "ELr0A2)DBEqM8C27M584;A32f=MHC78D=6E1D03EC270CEM70??24=BEDC>EH2>"
U "DAEM2><?MDC4A1E0BEJ0EA4MBD;C1E>5EMB><4MC78=J6EH>JDE<0JHE3>1E8=E"
U "MC78BLECDCM>A80J;E8B/=LCED<HE5M0D;C%SEEfD=HE720A<E2H>DED3>ECJ>E"
U "H>MDAB4D;5E0/BE0EMA4BDD;CE>J5EB>M<4C728=6ED8=EC278BEMCDC>MA80;1"
U "E8BEM0;B>LE=>C1E<HEM50D;&CSEELy78BLECDCM>A80J;E8BLE2>?MHA86)7CE"
U "MLx0HB1E<4N%EV^^#[Er0MA2DBIEq8CM275824;3Q1EB>EMC70CLE<40D=BEHD>"
U "DE2D0=LCLE68EJ4E8C1EC>EM>C74JAE?4M>?;4LE5>ALE<>=D4HE>JAE?DJCEH>"
U "DDAE=20<4ED>=E8JCE>ALEB><M4C78)=6RRInE6D24BBS#EEu;M40B4LE4<0D8;"
U "E0D=HE#MD4BCM8>=BIQE2>M<<4=)CBQEM2>=2M4A=BIQEBDM664BMC8>=ABQE2M"
U "><?;M08=CABQE>JAE20MC27HLEB;>M60=B%EMdN1EC>E)#?\eM?>1>JGS2>&<SE"
U "E.nL3EM;>E41EC>EM740ALE5A>J<EH>ADQE7D>FEHD>DE0DA4E3M>8=6IQE4C&2"
U "SEE%222y%fgqj%EtkE%htsy%jsyx%2EEnM=CA>M3D2C28>=2IEE%0MA8012;4B2"
U "#EEn=MC4A0M2C8=J6EF8DC7ECD74E2M><?D2C4A2#EEr>)A4EfM3E0=2243ELi0"
U "C0IEr0=M8?D;M0C8>&=2EELlA0?M782B%2EEiM4B86M=8=6IEf??M;820MC8>=&"
U "BE2EIEg4H2>=3EIvg0B)8222%2nsy%wtiz%hynt%s2EECn=ECD74E4M0A;HLE30"
U "HJBE>5LE?A>M6A0<M<8=6IQE8CLEF0BLEDBDM0;;HLEC74LEB28M4=C82582EM4"
U ";8CJ4E3>28=6E2C74EM?A>6MA0<<28=6E20=3EMC74HLEF4AJ4EDBMD0;;JHECA"
U "M08=4J3E012>E4E20=3EM14H>D=3ECD74E0ME4A0)64EfM<4A8220=EDC>E3J>E"
U "C7248AEM?A>6MA0<<28=6EMF>A:#SEnCLEF0BLE=>CLED=C)8;EV%^[YE)0CEiM"
U "0ACBM<>DCJ7E2>M;;46J4EC7D0CEC)74EgM468=2=4ALABEf;J;R?DMA?>BA4Ex"
U "HM<1>;)82EnM=BCAMD2C8)>=Eh2>34EMF>D;J3E14LE8=CMA>3D2243E#RRE<2>"
U "A4EM2><<M>=;HLE:=>DF=E0&BEgf%xnhSIEzB8D=6E2M><<>A=Ej=M6;8BJ7EC>"
U "LE?4AM5>A<LE?A>M24BBD>AECM0B:B%QEgf%xnhEM1420D<4E#MD82:D;HE?M>?"
U "D;)0AQEM0;C7M>D671E8CE2F0BEM38B;M8:431E1HEM?A>6MA0<<24ABED>5E<2"
U ">A4ELG;>FLR;4E)4;GEM;0=6MD064JBEBDD27E0JBE0BMB4<1D;HE0)=3Ek%twy"
U "w%fsSE(n=EV%^]ZELr82AM>B>5JCEA4M;40BD43ECM748ALE>F=LEE4AMB8>=1E"
U ">5E%gfxnIhE20M;;43#Evg02B82EMF8C7LEC74)8AEr%xRit%xEZSIUE>?M4A0C"
U "28=6EMBHBC)4<SELx8=2J4EC7)4=QEM=40AD;HE4ME4AH%EuhEMDB4ALE>F=JBE"
U "C7248AE2>F=EM2>?H1E>5EIvg0B)82QEM<0:8D=6E8/CE0EMF834D;HE:M=>F=L"
U "E;0=M6D06&4SE2%2EEvLg0B8J2E8BCE0EE24AHEMB8<?D;4E;M0=6D2064EDC>E"
U "?282:E)D?QE20=3E2H4CED8CE2D0=E0M22><M?;8B/7E0EM6A40JCE34)0;SELl"
U "A0=2C43E2H>DEMF8;;LE?A>M101;JHE=42E4AEMFA8CA4Ei>D><E>JAE&>)A3Eu"
U "M4A54D2CEF28C7EIvg0B)82QE21DCED8CE7D0BE8/CLBEMBCA>D=6E?M>8=C&BS"
U "EtD=4E>J5EC7D4<E8JBEC>LE8=CMA>3DD24E?M4>?;J4EC>LE?A>M6A0<M<8=6L"
U "EF8CM7>DCLE70E28=6EDC>EFM>AAHLE01>DDCECD74E8M=C4A2=0;EMF>A:M8=6"
U "B1E>5E2C74EM2><?MDC4A#SEnCCLBEBM8<?;J4EC>LE2A420C4EM60<4ABQE1MD"
U "B8=24BBEM0??;M820CM8>=BIQEB8M<?;4LE30CM010B)4BQE20=3EM6A0?M782B"
U "#SEy7J4E14DBCE0MB?42JCE>5LEC74LE;0=M6D06J4E8B1E8CLJBE2;2>B4EMA4"
U "B4M<1;02=24E)C>EjM=6;8)B7SE%22EELy78BLEB<0D;;ECMDC>A280;EM8=CAM"
U ">3D2D4BECD74EBM8<?;J4E2>M=24?DCBE>J5E?AM>6A0M<<8=J6EC>LE64CLEH>"
U "DLEBC0MAC43IQEB>1E85E2H>DEM0;A4203HEM:=>FLE0=>MC74ALE;0=M6D06J4"
U "E>ALE0A4LE0;AM403HLE50<M8;80JAEF8DC7E?MA>6AM0<<8)=6QE2H>DE2<0HE"
U "MF0=C1EC>EMB:8<LEC7AM>D67LEC74LE58ADBCE2M>D?;J4EB4M2C8>)=BSELl>"
U ">3LE;D2&:FE2%22xj%hynt%sEVE.RE%f%wnfg%qjx2IfEE0MA801);4QEMB8<?D"
U ";HE3M458=)43QED8BE0LE=0<J4EF72827E220=EM2>=C208=EJ0EE02;D4SIEuA"
U ">M6A0<M<8=6LE8=EM>;E4JBE68ME8=6LEE0;2D4BEDC>ECM74B4LE=0<D4BE0D="
U "3E?MA4B4M=C8=J6EC7D4<E8J=EB>D<4E52>A<EDC>ECD74ED2B4AS#EfEEM0A80"
U "21;4E270BEJ0ECHD?4EFM78271E8BEM34582=43ED1HECD74E:28=3ED>5EEM0;"
U "D41E8CEM7>;3&BSEnJ5EC7J4EE0MA801D;4E7M>;3BCE0E=MD<14AAQE8JCE<0J"
U "HE141E>5EM8=C4264AQLE5;>M0C8=J6E34M28<0A;QE;2>=6EM8=C4264AQ1E>A"
U "EM8<06M8=0A&HSEnJ5EC7J4EE0MA801D;4E7M>;3BLEBH<M1>;B1E>AEMC4GCIQ"
U "E8CLE<0H1E14EJ0E27M0A022C4AEME0A8M01;41E>AEJ0EBCMA8=6LEE0AM801;"
U "&4SEyM74B4LE0A4LEC4AD<BEHD>DEF28;;EM142>D<4E0M22DBMC><4J3EC>1E0"
U "BE2H>DEM2>=CM8=D4LE?A>M6A0<M<8=6%SE22Lm4A4LE0A4LEB><J4E4GM0<?;D"
U "4BE>J5EE0M;D4BCE0EEM0A8021;4EM<867JCE2>M=C08&=_E2%2EEx%ywns%lEE"
U "E%EEEELG74;);>QEMC78B1E8BEJ0EBCMA8=6%G2EE%nsyj%ljwE%EEEE%EZ2E%E"
U "qts%lEEE%EEEE%EE^W%]]X2%EExn%slqj%EEEE%EEEX%^SW^%XW2E%Eitz%gqjE"
U "%EEEE%EE^]%XW]]%SV]2I2y74LE58ADBCE8/BE0EMBCA8)=6SELxCA82=6BEM2>"
U "=C208=EMC4GC#SEy7J4E;0DBCE52>DAE20A4EM=D<1D4AECMH?4B#SEgDJCEC7J"
U "4E2>M<?DCD4AE32>4BE2=>CEM:=>FLEF70JCE:8D=3E>J5EE02;D4E2H>DE20A4"
U "EMCAH8D=6ECJ>E68DE4E0LEE0AM801;J4ED=M;4BBLEH>DLEC4;J;E8C#FEy724"
U "A4E20A4E2CF>EM<4C72>3BED>5ECM4;;8D=6ECD74E2M><?D2C4AEMF70CLE:8="
END SUB

SUB V2
U "J3E>5LEE0AM801;J4EH>JDE0AJ4EDB28=6_%E22EIEjG?M;8282C;HEM342;20A"
U "4E2C74EME0A8M01;4%EfxEJ0ECH)?4SELy78B1E8BEM3>=41E1HEMDB8=J6EC7&"
U "4EinIrEBCM0C4<24=CSIEx0HLEH>DLEF0=2C43EDC>E<20:4EJ0EE0MA801D;4E"
U "2M0;;4J3E=DM<14ALEF78D27EFM>D;3LE2>=MC08=1E0=EM8=C4264AELMF7>D;"
U "4E=MD<14AAQE=J>E38M68CBLE05CD4AECD74E3M428<D0;E?M>8=C#NSE(D>DEF"
U "M>D;31E3>ED8CE;28:4EMC78B%_E22%inrEM=D<1)4AEf%xEns%yjlj%w22y274"
U "=E2H>DEMF>D;J3EDBJ4EC7D0CEEM0A8021;4ED0BE0J=E8=MC464&ASEyD74EF2"
U ">A3E%inrEM02CDM0;;HLE>A8M68=02C4BEM5A><LEC74LEF>AA3Ei8M<4=B28>="
U "QLE1DCLEH>DLEF>=CLCEBD44EFD7HEDM=C8;1EF4EM38B22DBBEM0AA0)HBSE%2"
U "2EE1uDCEJ0EBHM<1>;LE05CD4AECD74EEM0A8021;4EM=0<4LEF78D27E8JBE34"
U "M58=4J3E0BLEA4?MA4B4M=C8=J6EC7D0CEC2H?4S#Evg02B82E270BEJ0EB4JCE"
U ">5LEBH<M1>;BLEF78D27EAM4?A4MB4=CLE402J7EE0MA801D;4EC2H?4_%E22E%"
U "EIEE%EEEEIExCA28=62%EEJE%EEEE#EEn=MC464&A2EE%KEEE%EEEELq>=6%2EE"
U "F%EEEE%EEExM8=6;&42EE1E>AE#WdE&270CED85EC274HEM8=?D&CEXW%]dEy27"
U "8BEM<DBC1E14EMC0:4J=E8=DC>E0M22>DD=CE0JBE?0DACE>J5E?AM>6A0M<<8="
U "A6SE(D>DEDMBD0;D;HE2D0=LCLE0BB2D<4EMC70CLEC74LEDB4JAE70JBE70D;5"
U "E0LE1A0)8=QEDB>E8J5EC7D4HE3J>EB>M<4C728=6EMFA>=A6QEHD>DE2D0=LCL"
U "EB2AD4FEDJ?EC7J4E?AM>6A0&<SExJ>EC7&4Ejq#xjEBMC0C4M<4=CLE2><D4BE"
U "82=C>EM?;0H#SEy7J4E;>2682EM6>4BLE;8:J4EC7)8B_E#nkECD74E2M>=38MC"
U "8>=1E8BEMCAD4%QymjIsE3>LEB><M4C78)=6QE21DCED85ECD74E2M>=38MC8>="
U "1E8BEM0=HCM78=6%Ejqx#jQEC274=ED3>EBM><4CM78=6LE4;BA4SE(D>DE5M>;"
U ";>&FdEy)74Ej%qxjEMBC0CM4<4=JCE8BLEDB4J3EF8)C7En%kSSS%ymjs1EC>EM"
U "C4BC1E85EJ0E2>M=38C28>=ED8BE0M=HC728=6EM4;B4%SE22%hqx2%nsuz%yEG"
U "uMA4BB#EVE8J5EH>JDEF0D=CEB2><4EM?8II&0SGQLE=D<214AJ%2nkEM=D<1)4"
U "AJE%bEVE%ymjs%Euwn%syEGLm4A4CLBEH2>DAEM?8II&0GEj%qxjE%uwns#yEG("
U "D>DE3D>=LCLE64CLE?8I)I0G2%jsi2I2y70/CLBEJ0E50M8A;HLEB8<2?;4EM4G"
U "0<2?;4QLE0=3LEA40J;E;8D54ECM78=6JBEF8D;;E1J4E<DD27E<2>A4EM2><?2"
U ";4GSIEq4CJBECA/HE0ELGA40J;E;8)54GEM?A>62A0<S#Evg02B82ED8BE2M0?0"
U "1D;4E>J5E50M8A;HLEB>?M78BCM820CD43E<20C7Q1EB>EM;4CBLE?DCLEB><J4"
U "E>51E8CEDC>ED)B4SE1x0HEMH>DAIEf;6M41A0LEC40M274ALEC4;D;BEHD>DEC"
U "J>E58D=3ECD74E0MA40B1E>5E2C74EM28A22;4BEMF8C7LEC74LE5>;M;>F8D=6"
U "EAM038D2B4BELMA03)88QEMF70CM4E4A#NQE0D=3E7J4E682E4BE2H>DEJ0EB72"
U "44CEMF8C7LE7D=M3A43JBE>5LEA03)88SE2(>DEM3428D34ECJ>E1>D>CEDJ?EH"
U ">DDAE2M><?D2C4AE20=3EMFA8CJ4EC7J4E5>M;;>F28=6EM?A>62A0<_%E22h#q"
U "x2?&8FEb%EXSV%YVZ2%nsuz#yEG&270CED8BECD74EAM038DJBE>5LEC74LE28A"
U "22;4d%EGQEMA038)DBF2M0A40%FEbE)?8FEIOEA0M38DB.FE-E%W2uw%nsyEIGy"
U "74LE0A4J0E>5LEC74LE28A22;4E)8BEGIQE0A)40F2%jsi2I2k8A)BCQEDF4LAJ"
U "4E34M58=8D=6ECD74EEM0A8021;4E)?8SECnCLBCE0EBM8=6;J4E=DM<14AIQEF"
U "72827EM<40=JBEC7D0CE8JCE20J=E14CE0E5M08A;JHE;02A64EM=D<1D4AEF28"
U "C7EMB><4LE342M8<0;LE?;0224BSIEy74LE4G2M;0<0MC8>=LE<0AJ:EC42;;BE"
U "Ivg0BD82EC270CED?8E8JBE>5LEC74LEB8=26;4EMCH?4#SEs4)GCQE2C74EMDB"
U "4A1E8BEM?A><M?C43LE5>ALEC74LEA0328DBED>5ECM748ALE28A22;4SIEy74J"
U "=EC7J4E0AD40E8JBE20M;2D;M0C43#SEy7&4EOEM<40=ABEGCM8<4B#QGE0D=3E"
U "CD74E-IEM20MAA>CINE<420=BE1GC>E2C74EM?>F4JAE>5#SGEAM038DABFE-#E"
U "WE<M40=BIEGA0M38DBLEB#DM0A43%SGEy278BEM2>D;J3E0;DB>E1J4EFAM8CC4"
U "J=E0B1E?8F#EOEAM038D&BFEOLEA0328DBF%SE22Ly74A/4LBE2>=4E2186EM?A"
U ">12;4<EMF8C7LEC70JCE?AM>6A0&<SEyD74ECM4027D4AE620E4E2H>DEJ0EB72"
U "44CEMF8C7LE7D=M3A43JBE>5LEA03)88EMM?;40DB4E4M<08;1E<4ED85EHD>DE"
U ":2=>FE27>FEDC>EBM?4;;LEC78&BFNSIEk>ALE4E4DAHEAM038DABQEHD>DE<2D"
U "BCE2AD=E2C74EM?A>62A0<EM>E4ALE060)8=SELy78B1E8BE2=>CEM?A02MC820"
U "&;SEnJ5EF4LE703LEB><J4E:8D=3E>/5E0EM;>>?LED=CD8;EFJ4EF0M=C431EC"
U ">EM#D8CLEC70JCE9DDBCE:24?CED>=EAM4?40MC8=6LE>E4JAE0=J3E>ED4AE8J"
U "CEF>2D;3ED14E<2D27EM<>A4LEDB425D;S.Et5EM2>DA)B4QEIvg0BD82E7D0BE"
U "CD74E<M40=B1E>5EM?4A5M>A<8D=6EC278BEM540C#SEq>D>?EBMCAD2MCDA4&B"
U "SEy274HEMBC0AJCEF8DC7ECD74EBMC0C4M<4=C%EitQLE0=3LE4=3LEF8CJ7EC7"
U "J4EBCM0C4<24=CE%qttuISE(>JDE20&=Eqt%tuEz%synq1E>AE&&mnq%jEQE)>A"
U "Ei%tEzs%ynqED>AE&%mnqjCE0E2M>=38MC8>=1E8BEMCAD4#SEf=M>C74JAE>?M"
U "C8>=IEMF72827EDF4EF28;;E2DB4N1E8BEDC>E1MA40:LE>DC1E>5E2C74EM;>>"
U "?LE<0=MD0;;JHE0BLEB>>J=E0BCE0E2M>=38MC8>=1E8BEMCAD4#SEq4DCBEAM4"
U "E8BJ4EC7J4E?AM4E8>DDBE22>34_%E22h%qxEE%EEEE%EEEE%EEEE%EEEE12?8F"
U "%EbEX%SVYV%Z2it%EEEE%EELELg468J=EC7J4E;>D>?E724A42%Ensu%zyEGM&7"
U "0C1E8BE2C74EMA038DDBE>J5EC7J4E28MA2;4%dEMRIVEC>LE4=3%NEGQLEA032"
U "8DBF%2EnkLEA0328DBF%EbER%VEym%jsEj&'nyE%it2EM0A40%FEbE)?8FEIOEA"
U "0M38DB.FE-E%W2Eu%wnsy#EGy7J4E0AD40E>J5EC7J4E28MA2;41E8BE#GQE02A"
U "40F%2Euw%nsy2%qttu%EEEE#LEj=J3EC7J4E;>D>?E724A42%jsi2I2s>F1EF4E"
U "220=E24=3E2C74EM?A>62A0<ED1HE4M=C4A28=6E#RVE0JBEC7J4EA0M38DB#SE"
U "y7J4E?AM>6A0J<E27M42:BLEC74LEA0328DBEM05C4JAEC7J4EDBD4AE8M=?DCJ"
U "BE8CLE0=3LE27422:BED85E8JCE8B%ERVS.En5ED8CE8ABQE8JCE4G28CBE2C74"
U "EM;>>?#SEn51E8CE28B=LJCE8CLE9DBJCE:424?BEM6>8=J6E8CCLBE<M4AAHLE"
U "F0H#SEy7&4Euw%nsyEMF8C71E=>EM0A6DM<4=CJBE?AM8=CBCE0E1M;0=:JBE;8"
U "D=4EBJ>EF4LE20=LEB4?M0A0CJ4E>DJAE0=MBF4A&BSEnLE78627;HEMA42>M<<"
U "4=J3E4=MC4A8D=6EC278BEM?A>62A0<EM8=C>#Evg02B82EM9DBC1EB>E2H>DE2"
U "20=E2B44EM4G022C;HE27>FED8CEFM>A:B%SEE2I2x0HLEH>DLEF0=JCEC>LE?A"
U "8D=CEBM><4CM78=61E8=EJ0E24MAC08J=E?AJ4R34M58=4J3E5>MA<0C#SEx0JH"
U "EH>JDEF0D=CECJ>E?A28=CEJ0EB4MA84B1E>5EM3868DCBEF28C7EM>=;H#EWE?"
U "M;024JBE052C4AE2C74EM34282<0;EM?>8=JCE0=/3E0EM3>;;D0AEB286=EM14"
U "5>DA4ECD74E5M8ABCLE386)8CSECy>E3J>EC7D8BEAM4#D82A4BE2C74E%uwns%"
U "yEzx%nslEMBC0CM4<4=ACQEFM78271E8BEME4AHLE70=D3HE8J=E0?M?;82M0C8"
U ">D=BE5D>AE1MDB8=M4BB4&BSEy)74Eu%wnsy%Ezxn#slEBMC0C4M<4=CLE022M4"
U "?CBLECF>LECH?D4BE>J5E0AM6D<42=CBSIEy74LE58ADBCE8/BE0EMBCA8D=6EF"
U "M7827LE70BLE0;AM403HLE144J=E34M58=4&3SEy278BED8BE0LEB?4M280;LEC"
U "H?J4E>5LEBCA28=6Q1E8=EMC70C1E8CEM2>=CM08=BLE5>A2<0CEMB?42M8584)"
U "ABQEMF782J7EB?M4285JHEC7J4E5>MA<0C1E>5E2C74EME0A8M01;4JBE?0MBB4"
U "31E0BE2C74EM>C74JAE0AM6D<42=CBSIEh>=M5DB4A3dE(D>DEFD>=LC1E14SIE"
U "m4A/4LBEJ0E#D282:EM;8BC1E>5E2C74EM<>BCLE2><2<>=EM5>A<D0CEBM?428"
U "M584A&BE22%EEHH%HEEE%EEEE#EEE3M868C&B2EE%KEEE%EEEE%EEEEIEuA82=C"
U "BED0=E4M=C8AJ4EBCMA8=6#2EE+%EEEE&+EEE%EEEELuA8=DCBE0LEBCA28=6E2"
U "58CEMF8C7D8=ECD74E1M02:BM;0B7)4BSE%2EEE%EEEE%EEEE%EEEE%EEEE#EEf"
U "=JHEC728=6EM;>=6D4AE8JBECAMD=202C432%EEII%EEEE%EEEE%EEEu2DCBEJ0"
U "E3>M;;0ALEB86J=EC>LEC74LE;45JCE>5CE0E=MD<14&A2EE%SEEE%EEEE%EEEE"
U "IEuA82=CBEJ0E34M28<0J;E?>28=C2%EEQE%EEEE%EEEE%EEEuMA8=C/BE0EM2>"
U "<<J0E4E24AHEMC78AJ3E38268CEDC>ECD74E;245C2%EEEE%EEEE%EEEE%EEEE%"
U "EEEE1E>5E2C74EM34282<0;EM?>8=&CS221f=3EMC74BJ4E20J=E14LE2><M18="
U "4J3E8=CE0E5M>A<0JCEBCMA8=61EC>EM<0:4CE0ED2B4AEM34582=43E2F0HEDC"
U ">E?MA8=CLEB><M4C78)=6SE(x>EI%IHQH%HHSHIHEF8D;;E?MA8=CCE0E=MD<14"
U "JAEF8DC7E0LE3>;2;0AEMB86=1EC>E2C74EM;45C1E>5E)8CSECn5ECD74E=MD<"
U "14JAE70JBE<>DA4EC270=E2CF>EM34282<0;EM?;02)4BQED8CE8JBECAMD=202"
U "C43EDC>EC)F>SECn5E8JCE8BLE<>AJ4EC7D0=E52>DAEM3868DCBE;2>=6EDC>E"
U "CD74E;245CED>5ECD74E3M428<D0;E?M;024IQE8C1E8BEM0;B>LECADM=20CD4"
U "3ECJ>E58&CSEyJ>EDB/4E0E%uwns%yEzx%nslEMBC0CM4<4=ACQEHD>DE<2DBCE"
U "M58ABJCE34M58=4LEC74LE5>A2<0CEMBCA8D=6E2M>=C0M8=8=J6EC7J4E5>MA<"
U "0CLEB?4M285824ABSIEy74J=EH>JDEDB&4Euw%nsyE%zxns#lQEC274=E2C74EM"
U "=0<41E>5E2C74EM5>A<D0CEBMCA8=A6QE0D=3EEM0A8021;4EME0;DD4BECJ>E5"
U "8D;;ECD74E?M;024JBE34M58=4J3E8=LEC74LE5>A2<0CEMBCA8)=6SELm4A4CL"
U "BE0LE2>3J4E4GM0<?;&4E22%hqxE%EEEEILE64JCEDBD4AE8M=?DC%2nsu%zyEG"
U "Lj=C4JAE8CD4<E=20<4_%EGQEM8C4<M=0<4%I2ns%uzyEIGm>FLE<0=JHE8C24<"
U "Bd%_EGQLE=D<M8C4<&BJ2n%suzyIEG&7D0CE32>4BE2>=4EM2>BC%d_EGIQE8CM"
U "4<2>)BCF2%hqxE%EEEEILE38MB?;0JHE8=M?DCBL25>A2<0CI%EbEG&+EEE%EEE"
U "E%EEEE(E+EE%EHQH%HHEE%EEEE%IIHQ%HHHS%HHEE%EIIH%QHHH%QHHH%SHHG%2"
U "EEE%Euwn%syEGLnC4<IEs0<&4EEE%EEEEIEvD0M=C8C&HEEELh>BC%EEEE%EEEE"
U "IEy>C)0;Eh2>BCE%EEEG%2EEE%Euwn%syEG%RRRR%RRRR%RRRR%RREE%ERRR%RR"
U "RR%REEE%RRRR%RRRR%RREE%ERRR%RRRR%RRRR%RRRGL2C>CM0;2>)BCFEIbE=DM"
U "<8C4)<BJEIOE8CM4<2>)BCF2%uwns%yEzx%nslEM5>A<)0CI$LE8C4M<=0<&4I$"
U "EM=D<8MC4<B#J$E8MC4<22>BCFI$EC>MC0;22>BCF%2jsi#22k82ABCQ1EF4E26"
U "4CE2C74EM8C4<LE=0<A4QE=MD<14JAE>5LE8C4)<BQE20=3EM2>BCLE?4ALE8C4"
U "J<E5AD><ECD74ED2B4ASIEy74J=EF4LE2;4D0AECD74EBM2A44J=E0=J3E34M58"
U "=4LEC74LE5>A2<0CEMBCA8D=6ECJ>E14LEDB4&3SEnJCE2>M=C08D=BE0LEBC02"
U "C82EM;4=6DC7EBMCA8=A6EMC24GCEMC70CLEF8;J;E14LECADM=20CD43E8J5E8"
U "C1E8BE2C>>EM;>=6#NQEDJ?EC>#EYE3M868CJBE5>JAEC7J4E#DM0=C8)CHQEIY"
U "E38M68CBLE0=3LECF>LE342M8<0;JBE5>JAEC7J4E8CD4<E22>BCQLE0=3#E\E3"
U "M868CJBE0=J3ECFJ>E34M28<0D;BE5D>AECD74ECM>C0;LE2>B&CSEy274=EDF4"
U "E?MA8=CLE>DCLEB><J4E2>M;D<=LE740M34AB1EB>EDF4E:2=>FEMF70CLE402J"
U "7EE02;D4EMF8;;LEA4?MA4B4)=CQE20=3EMB><4LE=82J4E;82=4BEDC>E6J>ED"
U "=234AE2C74EM2>;DD<=E7M4034)ABSELy74=LEC74LEC>CD0;E22>BCED8BE2M0"
U ";2DM;0C4J3E1HLE<D;MC8?;MH8=6LEC74LE=D<214AED>5E8MC4<B1E1HE2C74E"
U "M8C4<LE2>B&CSEkM8=0;);HQE2C74EM5>DALEE0AM801;/4LBEME0;DD4BE0DA4"
U "E3M8B?;M0H43LED=3D4AECD74E2M>;D<J=E74M034AJBEDB28=6E2C74E%uwns%"
U "yEzx%nslEMBC0CM4<4=&CSE2%22xj%hynt%sEXE%RErt%wjEf(i%fs%hjiE%ify"
U "f%Erfs%nuzq%fynt#s2y724A4E20A4EM=D<4MA>DBLE<4CM7>3B1EC>EM<0=8M?"
U "D;0DC4E320C0E20=3EM?A4B24=CED8CECJ>EC7J4EDBD4AE8&=EvgM0B82#SEt="
U "J4E8BLE20;2;43ED0=E0MAA0H#SEf=LE0AAD0HE8/BE0EME0A8M01;4LEF78D27"
U "E2D0=E2M>=C0D8=E<2>A4EMC70=LE>=4LEE0;)D4SE1k>AEM4G0<2?;4QLEH>DL"
U "E<86D7CE720E4ED0=E0MAA0HLE20;2;43EA0QE0D=3EHD>DE2M>D;3LE0BB286="
U "EM30C01EC>E2C74EM<4<124ABED>5EC270CEM0AA0&HSEyM74A4LE<86D7CE1/4"
U "E0EME0;DJ4E5>/AE0M%VNQE20=3EJ0E38M554A24=CEME0;DJ4E5>/AE0M%[NSE"
U "Lg45>DA4E0J=E0A2A0HE220=ED14ED2B43Q1E8CEM<DBC1E14EM342;M0A43#SE"
U "fAMA0HBLE0A4LE342M;0A4J3EF8DC7EC)74Ei#nrEBMC0C4M<4=CLEDB4J3E8=L"
U "EB42MC8>=%EVSELm4A41E8BED0=E4MG0<?D;4E>J5E0=LE0AAD0HE3M42;0MA0C"
U "8)>=_E%22in.rE0M%VEyt%EVUU%NEfx%Ensy%jljw#22y724A4E20A4E2=>FE%V"
U "UUEM3855M4A4=JCEE0M;D4BLEC70JCE20J=E14LE0BBM86=4J3EC>LEC74LE0AA"
U "D0HE0IQE0=J3EC7D4HE<2DBCE20;;ED14E8M=C4624ABS.EnCEM2>D;J3E0;DB>"
U "E;2>>:EM;8:4LEC78&B_E2%2inr(E0JM%VEyt%EVUU%N22zMB8=6LEC74LEBH<2"
U "1>;EIJE5>JAE8=MC464AASE&J4E20D;;ECD74E3M8554MA4=CLEE0;2D4BE25>A"
U "E2C74EM0AA0JHE<4M<14AJBE>5LEC74LE0AA)0HSELfAA0/HE0E270BE%VUUEM<"
U "4<124ABSIEfAAD0HE<M4<14DABE2D0=E1J4E0BMB86=D43EEM0;D4JBE1HLEDB8"
U "D=6E0LEBD1MB2A8D?CE=MD<14JAEF8MC78=LE?0AM4=C7M4B4BLE05CD4AECD74"
U "E0MAA0HLE=0<A4QE;28:4EMC78B%_E22&0JMV%NEbE#VU20%JMWN%EbEW.^20J%"
U "MXNE%bEX^#22f=J3EB>1E>=SIEs>FLEH>D1LA4EM?A>1M01;HLEF>=M34A8D=6E"
U "FD7HECD74EBMC0C4M<4=CLE5>ALE342M;0A41E8BE%inrSIEy78JBE2>2<4BEM5"
U "A><CE0EC24A<EMDB431E8=EM40A;284AEM?A>6MA0<<28=6EM;0=6MD064JBEC7"
U "D0CE<M40=BLE38<M4=B8)>=SELy70CLEBC8D;;E3M>4B=CLCE0M=BF4JAEC7J4E"
U "#DM4BC8)>=SSISEF7JHE=>JCEDBJ4EC7J4EBCM0C4<24=CE%ijhq%fwjdLE&4;A"
U ";QE0J=E0A2A0HE220=EM70E4LE<>AJ4EC7D0=E>D=4E3M8<4=MB8>=#SEfAMA0H"
U "BLEF8CJ7E<DM;C8?D;4E3M8<4=MB8>=JBE70DE4EHLE<4<M14AB1E8=E2C74EMB"
U "42>D=3E3M8<4=MB8>=LE5>ALE4E4DAHEGLE<4<214AED>5ECD74E5M8ABCLE38<"
U "M4=B8D>=E8J=EC7J4E5>M;;>F28=6EM0;6>MA8C7&<_E2%2inrLE0AA)0HME%VE"
U "yt(EGQE%VEyt(EHNE%fxEn%syjl%jw22Cx>E8J5EC7J4E02MCD0;LE342M;0A0M"
U "C8>=LE;>>2:43EM;8:4LEC78&B_E2%2inr(E0IM%EVEy%tEXQ%EVEy%tEXNI22("
U ">JDEF>2D;3EM70E4LEC74LE5>;M;>F8D=6E<M4<14DABECJ>E0BMB86=LEE0;2D"
U "4BE)C>_E.220I%MVQV%NEEE.EE0I%MVQW%NEEE.EE0I%MVQX.N20I%MWQV%NEEE"
U ".EE0I%MWQW%NEEE.EE0I%MWQX.N20I%MXQV%NEEE.EE0I%MXQW%NEEE.EE0I%MX"
U "QX%N22fLECF>LE38<M4=B8M>=0;LE0AAD0HE8JBEDBM45D;LE5>ALECA0M2:8=J"
U "6EC7J4EBCM0CDB1E>5EM4027LE?84D24E8/=E0EM2742M:4ABLE60<A4QE>JAEB"
U ">M<4C728=6ED>5ECD74E;28:4SIEw4220;;E2C74EM;0BCLE4G0M<?;4LE?A>M6"
U "A0<1E>5EMB42C28>=EMC70C1EF4E2703EJ0E?AM>6A0J<EC7D0CEFM>D;3LE0B:"
U "LEC74LEDB4JAE5>JAEC7J4E8CD4<E=20<4QLEC74LE8C4J<E2>)BCQE20=3E2C7"
U "4EM#D0=MC8CH1E>5EMC70CLE8C4A<QECD74EB2?8CE2>DCE2C74EM30C0LE9DBJ"
U "CE682E4=ED8=E0LE=82J4E5>MA<0CLEF8CJ7EC7J4EC>2C0;ED8=ECD74EAM867"
U "CLE70=J3E2>M;D<=ISE&4);;QEMF8C7LE>=;JHE>=J4E8C)4<QEMC78BLE?A>M6"
U "A0<LE8B=CLCEE24AHEM?A02MC820&;SEgDDCE=D>FEF28C7E2>DAEM=4F5M>D=3"
U "LE:=>MF;43D64E>J5E0AMA0HBLE0=3LEC74LE:=>MF;43D64EFJ4E0;MA403JHE"
U "70DE4E>J5E;>2>?BQ1EF4E220=EM2A40DC4E0IE2B>M<4F7D0CEDMB45DJ;E0?M"
U "?;82M0C8>&=SEyD74E?MA>24DBBEF28;;EMBC0AJCEF8DC7ECD74E?MA>6AD0<E"
U "?MA><?MC8=6LEC74LEDB4JAE5>JAEC7J4E=DM<14A1E>5EM8C4<JBEC7D0CEF28"
U ";;ED14E2M0;2DM;0C4&3SEy274=E2C74EM?A>62A0<EM;>>?JBE5>JAEC7J4E=D"
U "M<14A1E>5EMC8<4JBEC7D0CECD74ED2B4AEM4=C42A43ED0CECD74E1M468=M=8"
U "=6IQE0BMB86=28=6E2C74EM30C0LE4=CM4A43LE8=C/>E0EM<4<1D4AE>J5E0=L"
U "E0AAD0HEFJ4EF8D;;E3M42;0)A4SEIfEE0MA801D;4E2M0;;4J3E=4JCy>C)0;F"
U "EMF8;;1E14EM38B?M;0H4J3E0CLEC74LE4=31E>5E2C74EM?A>62A0<EMF782J7"
U "EF8D;;E2M>=C0D8=ECD74ECM>C0;LE2>BDCBE>J5EC7J4E8C24<BSLE=4CLy>C0"
U "A;FEF28;;EM022DM<D;0DC4E42027EMC8<4LEC7AM>D67LEC74LE;>>J?E0BLEC"
U "74LE2DAMA4=CLEC>CD0;h>)BCFED8BE0M33431EC>E)8CSELyH?4LEC74LE5>;M"
U ";>F8D=6E22>34_%E22h%qx2n%suzy#EGm>JFE<0D=HE8MC4<B1EC>ED14E2M0;2"
U "DM;0C4&3dEGIQEC>2C0;nMC4<B%J2inIrE8CD4<s0)<4IM%VEytLEC>CD0;nC24"
U "<BJ%NEEE%ELEiM42;0DA4E>DDAE0MAA0H&B2inIrE8CD4<h>)BCFM%VEytLEC>C"
U "D0;nC24<BJ%N2inIrE=DJ<nC4)<BJM%VEytLEC>CD0;nC24<BJ%N2inIrEC>2C0"
U ";h2>BCF%MVEyItEC>2C0;nMC4<B%JN2k#twE8%JEbE%VEytLEC>CD0;nC24<BJ%"
U "EEEE%EEEE%EELkM8ABCLE;>>A?_E6D4CE8M=?DC&B2EE%hqx2%EEuw%nsyEIGnC"
U "4&<EG$(E8JE%EEEE%EEEE%EEEE%EEELIEi8BM?;0HLEC74LE2DAMA4=CLE8C4J<"
U "E=DM<14A%2EEu%wnsy%2EEn%suzy#EGnCD4<E=20<4E%RREGIQE8CD4<s0)<4IM"
U "&8JN2%EEns%uzyEIGnC4J<E2>)BCER%REGQLE8C4J<h>BACFM8%JN2E%Ensu%zy"
U "EGLvD0=MC8CH%ERRR%EGQE2=D<nMC4<B.JM8J%N2EEMC>C0J;h>BACFM8%JNEbL"
U "E8C4J<h>BACFM8%JNEOLE=D<LnC4<ABJM8%JN2s(j'yE&8J2h%qx2u%wnsy#EGx"
U "DM<<0A&HG2u%wnsyL25>A2<0CI%EbEG&+EEE%EEEE%EEEE%EEEE&+EII%HQHH%H"
U "SHH%EEEH%QHHH%EEEE%EIIH%QHHH%QHHH%SHHG%2EEE%Euwn%syEGLnC4<LE=0<"
U "&4EEE%EEEE#EEnC)4<Eh2>BCE%EEEvMD0=C28CHEIEy>C)0;Eh2>BCE%EEEG%2E"
U "EE%Euwn%syEG%RRRR%RRRR%RRRR%RRRR%RERR%RRRR%RRRR%EEER%RRRR%RRRE%"
U "ERRR%RRRR%RRRR%RRRG%2ktw(E8JE%bEVE#ytECM>C0;LnC4<&BJ2E%Euwn%syE"
U "z%xnslLE5>A2<0CII$E8CD4<s0)<4IM&8JN$LE8C4J<h>BACFM8%JN$E2=D<nMC"
U "4<B.JM8J#N$ECM>C0;Lh>BC.FM8J%N2EE2=4CyM>C0;%FEbE2=4CyM>C0;%FEPE"
END SUB

SUB V3
U "MC>C0J;h>BACFM8%JN2s(j'yE&8J2u%wnsy%2uwn%syEG1s4CELy>C0&;EbE#G$"
U "E=D4Cy>2C0;F%2jsi#22y7D8BE?MA>6AD0<E8JBE<DD27E;M0A64JAEC7D0=E0M"
U "=HC728=6EDF4LEJ4E3>D=4E0JBE>5LEH4C#SEnC1E8BEM:8=31E>5EJ0EA4ME84"
U "F1E>5EM4E4AMHC78D=6EFJ4LE4LE3>=J4EB>LE50ALE0=3LE>=4LE033M8C8>2="
U "0;EM540C2DA4_LEC74%Ektw%SSSs(j'yEM;>>?#SEy7D8BE:28=3ED>5E;2>>?E"
U "M;>>?JBE5>JAEC7J4E=DM<14A1E>5EMC8<4JBEB?M42852843S#EfEEM0;D41E8"
U "BEM68E4J=EC>CE0EEM0A8021;4E20=3E2C74EM?A>62A0<EM;>>?JBED=2C8;EM"
U "C70CLEE0AM801;J4E8BLE4#DD0;E>JAE6AM40C4JAEC7D0=ECD74E=MD<14JAEB"
U "?M42852843EM05C4JAEC7&4Eyt%SE22%ktwE&8JEb%EVEy%tEVU%2EEu%wnsy(E"
U "8J2.sj'y(E8J2L2&8;J;E;>)>?EVIUEC82<4BQLE?A8M=C8=J6EC7J4E=DM<14A"
U "&BEVEMC7A>2D67E%VUSE1y74EM;>>?LE4=3JBEF8DC7E0#Esj'IyEBCM0C4<24="
U "CEM5>;;M>F431E1HE2C74EME0A8M01;4LEC74LE;>>J?E8=M2A4<M4=CBLE5>A#"
U "SEx>1E8=E2>DAEM?A>62A0<Q1EF4EM70E4LE;>>D?BEF28C7EM8=34JGE=DM<14"
U "AABEM8#JNEBMC0AC28=6E)0CEVLE0=3LE8=2MA40B28=6E25>AEM4E4AJHE=DM<"
U "14ALE14CMF44=#EVE0D=3ECD74ECM>C0;LnC4<&BJQEMF782J7E8BLE68ED4=E1"
U "JHEC7J4EDBD4AE8J=EC7J4E582ABCEM?0AC1E>5E2C74EM?A>62A0<SIEf5CD4A"
U "ECD74ED2B4AEM8=?DDCBECD74E=MD<14JAE>5LE8C4D<BEC270CEMF8;;1E14EM"
U "20;2MD;0C)43QEM5>DALE0AA20HBE20A4E#inr4M=B8>2=43SIEy74JHE0AJ4E>"
U "=J4E38M<4=BM8>=0J;E0AMA0HBIQEB>LEC74JHE0AD4=LCLEE4AJHE2>M<?;4&G"
U "SEyD74E5M8ABC%Ektw%SSSs(j'yEM;>>?LE?A>M<?CBLEC74LEDB4JAE5>JAE40"
U "D27E82C4<SIEy74J=EC7J4E5>MA<0CLEBCA28=6ED8BE3M458=D43E0D=3ECD74"
U "E2M>;D<J=E74M034AJBE0AJ4E?AM8=C4&3SEyD74EBM42>=&3Ekt%wSSS.sj'yL"
U "E;>>J?E2HM2;4BLEC7AM>D67LEC74LE<4<M14AB1E>5E2C74EM5>DALE0AA20HB"
U "E20=3EM?A8=DCBECD74E320C0EMDB8=J6EC7J4E5>MA<0CLEBCA28=6SIEy74LE"
U "30CJ0E5>JAE40D27E<M4<14JAEF0JBE0BMB86=D43E8J=EC7J4E582ABCE%ktwS"
U "%SSsjA'yE;2>>?SIEj02J7E2H22;4EMC7A>2D67E2C74EMB42>D=3E;2>>?QLEC"
U "74LEC>CD0;h>)BCFED>5ECD74E2MDAA4D=CE82C4<EM148=J6E?AM8=C4J3E8BL"
U "E033D43ECJ>EC7J4EE0MA801D;4E=D4Cy>2C0;F#SEy7J4E=4JCy>C)0;FED8BE"
U "CD74ECM>C0;LEBD<1E>5E2C74EMC>C0J;E2>2BCBSIEf5CD4AECD74EBM42>=&3"
U "Ekt%wSSS.sj'yLE;>>A?QECD74E=D4CECM>C0;1E8BEM?A8=2C43E20=3E2C74E"
U "M?A>62A0<EM4=3B%SE221x0HEDF4E720E4EJ0E60D<4E0D=3EF274=E2C74EMDB"
U "4ALE<0:D4BE0LEA422>A3EMB2>AA4QEC274HE264CEDC>EFMA8C4LEC74D8AE=2"
U "0<4ED>=E0LE;8BJCE>5LEC74%EVUEM14BCLEB2>2A4BSIEgDCLEC74LE=4GJCEC"
U "8D<4ECD74ED2B4AEM?;0HJBEC7J4E60)<4QEDF4EF20=CE2C74EM=0<4LE0=3LE"
U "?>BM8C8>J=EC7D4HEAM42>A2343E2C74EM;0BCLEC8<J4EC7D4HE?M;0H4J3EC>"
U "LEBC8D;;E1J4EC724A4S.Ey>ED3>EC278BQ1EF4EM<DBCLEFA8DC4ECJ>EF7D0C"
U "E8JBE20M;;43CE0E528;4QLE0=3LEC74J=EA4D03E8JCE06208=EM;0C4&ASEnJ"
U "5EH>JDE0AJ4E2>M<?DCD4AE;M8C4A20C4QLEC74J=E=>LE3>DD1CEHD>DE:2=>F"
U "EMF70CCE0E528;4E)8BQE20=3EMB8=2J4EH>JDE0AJ4EDB28=6E2C74EM8=C4MA"
U "=4C1EC>EMA403LEC78&BQEnCL<E0MBBD<28=6E2H>DE20A4S.En5E2H>DE23>=L"
U "JCE:=D>FEF270CEJ0E58D;4E8JBE0=J3EH>JDEA4M0;;HLEF0=JCE<41EC>EM4G"
U "?;208=E)8CQEMC74=LE4<0D8;E<J4E0=&3EnEMF8;;#SEx>1EF4EM=4431EC>EM"
U "FA8CJ4EC>LE58;&4SEgM45>AJ4EH>JDE20J=E3>LE0=HMC78=J6EC>CE0E528;4"
U "QLEH>DLE<DBJCE>?D4=E8ACQE0D=3ECM74A4LE0A4LE385M54A4D=CEF20HBE2H"
U ">DE220=EM>?4=CE0E528;4QLE14;M84E41E8CED>AE=)>CSEIfE58D;4E2D0=E1"
U "J4E>?M4=431EB>E2H>DE220=EMA403LE5A>J<E8C1E>AEMFA8CJ4EC>1E8CQ1E>"
U "AED8CE2D0=E1J4E>?M4=43LE0=3LEB?;D8CE82=C>EMA42>2A3BEM;8:4CE0E3M"
U "0C0120B4SIEm4AJ4E8BCE0E#MD82:LEC01D;4E>J5EC7J4E38M554A24=CEMF0H"
U "BLEH>DLE20=LE>?4/=E0EM58;4%_E22#EEn=2?DC_IEw40J3E30DC0E52A><E2C"
U "74EM58;4%2EEtMDC?DAC_E&MA8C4LE30CJ0EC>LEC74LE58;&42EELf??4)=3_E"
U "M&A8CJ4E30DC0ECJ>EC7J4E4=J3E>5CE0E528;42#EEg8M=0AH#_Ew4D03E52A>"
U "<ED>AEFMA8C41EC>EJ0E58D;4E8J=E18M=0AHLE<>3&42EELw0=3)><_ELw403L"
U "E5A>J<E>ALEFA8DC4EC/>E0EM58;4LEF78D27E8JBEB?2;8CEDD?E8J=EA4M2>A"
U "3JBE;8D:4E0LE30CM010B&4E221y74EMBH=CD0GE5D>AEC)74Et%ujsEMBC0CM4"
U "<4=JCE8BLE#D8DC4E?M42D;280AS.EnCLJBE0AM6D<42=CBEMA4#D28A4EDDBEC"
U "J>EB?M4285/HE0EM58;4LE=0<A4QE0J=E02M24BBLECH?A4EMC)74EZLECH?D4B"
U "E3M458=D43E0M1>E4#NQE0D=3E0LE58;J4E=DM<14AISE&7D4=ECD74E528;4ED"
U "8BE>2?4=Q#Evg02B82EMA42>M6=8ID4BE8JCE1HCE0E=MD<14JAEF72827EDF4E"
U "0MBB86J=EC>LEC74LE58;J4EF7D4=EFJ4E>?D4=E8&CSEfD;;EAM454AM4=24JB"
U "E<0D34ECJ>EC7J4E58D;4EDDB4EC278BEM=D<1)4ASECnCE2D0=E1J4E0=JHE=D"
U "M<14ALE5A>&<EVE)C>EW%ZZSECf=E>2?4=EMBC0CM4<4=JCE<0JHE;>D>:E;28:"
U "4EMC78B%_E22%tujsIEGB0M<?;4LSCGC%GEkt%wEns%uzyE%fxEH#V22&J4EF8D"
U ";;E1J4EA4M038=J6E30DC0E52A><EMC78BLE58;J4E14M20DBJ4E8CLEF0BLE>?"
U "42=43E25>AEM8=?D&CSEg202:EDC>E>DDAE?MA>1;D4<E0M1>DCLEC74LE60<J4"
U "EB2M>A4B#SEq4DCBEBD4CED/?E0EM?A>62A0<EMF782J7EF8D;;E0DB:E5D>AEC"
U "M748ALE=0<J4E0=J3E68DE4EC274<EJ0EA0M=3><LEB2>)A4SELy74=1E8CEMF8"
U ";;LE?DCLEC74D8AE=20<4ED>=ECD74E;28BCED0CECD74E0M??A>M?A80DC4E?M"
U ";0241E>=E2C74E2C>?E%VUEMD85E8JCE<02:4BE2C74EM;8BC#NSE&J4L;;LE20"
U ";J;EC7J4E58);4EG2C>?VIUS30&CSGE1gDCE2B0HEMF74=LEC74LEDB4JAE1DDH"
U "BECD74E620<4QLEC74DA4E0DA4E0M;A40)3HEVIUE=02<4BE20=3EMB2>AD4BE8"
U "J=EC724A4S1E&4EMFA8CJ4EC7J4E5>M;;>F28=6EM?A>62A0<EDC>E?DDCE3M45"
U "0DD;CE=M0<4BLE0=3LEB2>2A4BEM8=C>LEC>?#VUS3)0C_E%22hq%x2tu%jsEG2"
U "C>?VIUS30&CGEk%twEt%zyuz%yEfx%EHV2%ktwE&8JEb%EVEy%tEVU#2EE?M;0H"
U "4MA=0<&4IEb#EGu;M0H4A%GEPE%xywI(M8JN#2EE?M;0H4MAB2>)A4JE%bEVU%U"
U "UER.EM8J%EOEV%UUN2.EE&w%nyjE%HVQEM?;0HM4A=0)<4IQLE?;0MH4ABM2>A4"
U "%J2sjA'yE8%J2hq%txjE%HV2u%wnsy#EGi0DC0EFMA8CCD4=ECJ>E58);4G2%js"
U "i2#22y724A4E20A4EJ0E2>MD?;4LEBCAM0=64LE540MCDA4JBE>5LEC78JBE?AM"
U ">6A0J<EC7D0CEFJ4E70DE4E=D>CEB244=E2H4CS.En=E2C74EMB42>D=3E;28=4"
U "ED>5ECD74E?MA>6AD0<ECD74E528;4ED8BE>M?4=4J3E5>JAE>DMC?DC1EB>EDF"
U "4E2D0=EFMA8C41EC>E)8CSECn=ECD74E5M>DACJ7E;8D=4E>J5EC7J4E?AM>6A0"
U "J<EF4LE64CLE8=CJ>EB>D<4E;M867CLEBCA28=6EM<0=8M?D;0MC8>=%SEfEM=0"
U "<41E8BEM64=4MA0C4J3E5AD><ECD74EF2>A3EM?;0H)4AQE20=3ED8BE2M>=20M"
U "C4=02C43EMF8C7LEBCA28=6EM5>A<1E>5E2C74EM2DAA24=CEM;>>?LE=D<214A"
U "SLE(>DLE20=LE2>=M20C4M=0C4LECF>LEBCAM8=6B1E1HEMDB8=J6EC7&4EPEM>"
U "?4AM0C>A#SEy7&4Exy#wIE5MD=2C28>=EMA4CD2A=BE2C74EMBCA8D=6EAM4?A4"
U "MB4=CM0C8>J=E>5LEC74LE=D<214AEM?0BBD43ECJ>E8C#SEy7J4E>?M?>B8DC4"
U "E>J5EC7&4Exy#wIE5MD=2C28>=ED8BECD74E%#fqE5MD=2C28>=QLEF78D27EAM"
U "4CDAD=BECD74E=MD<4AD82EEM0;D41E>5E2C74EMBCA8D=6E?M0BB4J3EC>1E8C"
U "SIEq0B2C;HQLEC74(E&wn#yjEBMC0C4M<4=CLEFA82C4BEDC>ECD74E528;4EM="
U "D<1D4AEBM?428M58431E0BE2C74EM58ABJCE0AM6D<4D=CECD74EEM0;D4JBE>5"
U "LEC74LE5>;M;>F8D=6E0MA6D<M4=CB#SEi0DC0E8JBEFAM8CC4J=EC>LE58;J4E"
U "8=CE0E5M>A<0JCEA4M0301D;4E1JHEC7&4Ens%uzyEIHEBCM0C4<24=CEMF782J"
U "7EF4LEF8;J;EDBJ4E8=LEC74LE02C2D0;EM?A>62A0<S1E&4EM=443LEC78JBEB"
U "72>ACEM?A>62A0<E25>AE2C74E2186E2>=4EDC>EF2>A:EDB>EFJ4E20J=E68DE"
U "4ECD74E?MA>6AD0<E320C0EDC>EA2403EM5A><IQE>ALE4;BJ4EF4LEF8;J;E64"
U "/CE0EM=0BC&HEns%uzyE%ufxy%Ejsi%EtkE%knqjLE4AAD>AEF274=EDF4ECDAH"
U "ECJ>EADJ=E8C#SEs>DC4EC270CE2C74EM58;4LEB7>2D;3ED14E2M;>B4J3EF7D"
U "4=EFJ4E0AJ4E3>D=4EF28C7ED8CE1JHEDB28=6E2C74E%hqtxIjEBCM0C4<24=C"
U "EM5>;;M>F431E1HE2C74EM58;4LE=D<214AS%E22fD=3E=D>FEFJ4E2>D<4ECJ>"
U "EC7J4E18J6E?AM>6A0A<QE0&BEnEM70E4LEA45M4AA4J3EC>1E8CS.EnCED8BE#"
U "MD8C4LE;0AD64E0D=3E2M><?;)4GQE20=3EInE70DE4E=D>CE5MD;;HLE34BM2A"
U "81D43E0D;;ECD74EBMC0C4M<4=CJBEDBD43E8J=E8CIQEB>#EnE720E4EM1A>:D"
U "4=E8JCE3>DF=ECJ>E58DE4EBM42C82>=BEMF782&7EnEMF8;;LE34BM2A81J4E8"
U "=LE34C208;EM05C4MAF0A)3BSELm4A4IQE0CLE;0BACQE8JBEC7J4E2>)34_E%2"
U "2LEMB42C28>=E%V2hq%x2wf%sitr(n)jE%ynrjIw2H>DDAx22>A4J%EbEn%syMw"
U "%siEO%EVUU%UN2u%wnsy#EGl0)<4Et2E4AG%2uwn%syEGM(>DALEB2>DA4E8&BE"
U "G$LEH>DJAx2>)A4J2%inrEM?;0HM4A=0)<4IM%VEyt%EVUN%EEEEILi42M;0A4L"
U "E0AA20HBE25>AE2C74E#VUE4M=CA8D4BE>J=EC7J4E;8)BC2i#nrE?M;0H4MAB2"
U ">)A4JM%VEyt%EVUN%EEE2#2LEBM42C8)>=EW%2tuj#sEGC)>?VULS30C%GEkt%w"
U "Ens%uzyE%fxEH%V2EE#itE&%mnqj%Esty%Ejtk%MVNE%EEEE%EEEE%ELEj#tkE<"
U "M40=BIEG4=J3E>5LE58;&4G2E#EEE8%JEbE&8JEP%EV2E%EEEn%suzy%EHVQLE?"
U ";0MH4A=20<4I(M8JN%EELw2403EM5A><LE58;&42EE%EEns%uzyE%HVQEM?;0HM"
U "4AB22>A4J(M8JN%2EEq%ttu2%hqtx%jEHV%2uwn%syE2#2LEBM42C8)>=EX%2kt"
U "w(E8JE%bEVE%ytEV%U2EE#nkEH2>DAxM2>A4%JEcbLE?;0MH4ABM2>A4.JM8J%N"
U "Eym%js2E%EEEk#twE8&8JEb%EVUE#ytE8%JEPE%VExy%juER%VEEE%EEELCl>E1"
U "M02:FM0A3B.EM8J%EaEV%UN2E%EEEELE?;0MH4A=20<4I1M88J%NEbEM?;0HM4A"
U "=0)<4IM)88JE%REVN%2EEE#EEE?M;0H4MAB2>)A4JM)88JN#EbE?M;0H4MAB2>)"
U "A4JM)88JE%REVN%2EEE#Esj'IyE88%J2EE%EEuw%nsyEIGh>=M6A0CMD;0CM8>="
U "BIFE(>JDE70DE4E<2034E2C74E2C>?E%VUFG%2EEE%Ensu%zyEGM&70C1E8BEMH"
U ">DALE=0<&4dEGIQEH>DDAs0)<4I2%EEEEM?;0HM4A=0)<4IM&8JNEIbEH>DDAs0"
U ")<4I2%EEEEM?;0HM4AB22>A4J(M8JN#EbEH2>DAxM2>A4%J2EE#EEj'%nyEk%tw"
U "2E%Ejsi%Enk2.sj'y(E8J2#2LEBM42C8)>=EY%2tuj#sEGC)>?VULS30C%GEkt%"
U "wEtz%yuzy%EfxE%HV2E%Ektw(E8JE%bEVE%ytEV%U2EE.EE&w%nyjE%HVQEM?;0"
U "HM4A=0)<4IM&8JNQLE?;0MH4ABM2>A4.JM8J%N2EE.sj'y(E8JE%E2hq%txjE%H"
U "V22ILEB4M2C8>&=EZ2%uwns%y2uw%nsyEIGm4AJ4E8BLEC74LEC>?%EVUGL25>A"
U "2<0CI%EbEG&+EEE%EEEE%EEEE%EEEE%EEEE%EEEE(E+EE%HHHH%EG2E%EEEu%wn"
U "sy#EGu;M0H4AIEs0<&4EEE%EEEE%EEEE%EEEE#EEx22>A4G%2EEE%Euwn%syEG%"
U "RRRR%RRRR%RRRR%RRRR%RRRR%RRRR%RREE%RRRR%RG2k#twE8%JEbE%VEyt%EVU"
U "2%EEuw%nsyE%zxnsIlE5>MA<0C#I$E?M;0H4MA=0<A4IM8%JN$EM?;0HM4AB22>"
U "A4J(M8JN#2sj'.yE8J%2jsi%22EELx42C28>=E%V_EyD74EBM2A44J=E8BLE2;4"
U "M0A43#SEy7J4EB4M2>=3LE;8=J4E2>M=C08D=BECD74EBMC0C4M<4=C%Ewfs%it"
U "rn&)jEy%nrjwISE&7D4=E3M40;8D=6EF28C7EMA0=3D><E=MD<14)ABQEDF4E<2"
U "DBCEM68E4LEC74LE2><M?DC4/AE0EM=D<1D4AEBJ>E8CLE70BLEB><M4C78D=6E"
U "CJ>E10DB4ECD74EAM0=3>J<E=DM<14A1E8CEMF8;;LE2A420C4EM5A><#SEy7D8"
U "BE=MD<14JAE8BLE20;2;43E2C74EMA0=3D><EB2443EM64=4MA0C>&ASEfLEA0="
U "23><EMB443LE64=M4A0CD>AE2D0=E1J4EB?M42852843EMF8C7LEC74%Ewfs%it"
U "rnA)jEBMC0C4M<4=C#SEk>JAEC7J4EB4)43QEDF4E=2443EJ0E=DM<14ALEC70J"
U "CEF8D;;E=D>CE1J4EC7J4EB0D<4E4ME4AHLEC8<J4EF4LEAD=CE0E?MA>6A)0<Q"
U "EDB>EFJ4E34M28341EC>E2DB4E2C74EM=D<1D4AE>J5EB4M2>=3JBEF72827EM7"
U "0E4LE4;0M?B43LEB8=D24E<M83=8267CSIEy74%Eynr#jwEBMC0C4M<4=CLE022"
U "M4BB4/BE0EMBHBCD4<E3M4E82J4E20M;;43LEC74LEBHB2C4<EMC8<4AAQE0D=3"
U "EAM4CDAD=BECD74E2MDAA4D=CE=MD<14JAE>5LEB42M>=3BLEF78D27E720E4EM"
U "4;0?2B43EMB8=2J4E<8M3=86)7CSELx8=2J4EC7D8BE=MD<14JAEF8D;;E2M70="
U "6J4E8=LE402J7E?AM>6A0J<EF4LEAD=IQEC7D8BE2D0=E1J4EDBD43E5D>AECD7"
U "4EAM0=3>J<EB4)43SE1y74EME0A8M01;4LEH>DJAx2>)A4JED8BE6M8E4=CE0EA"
U "M0=3>J<E=DM<14ALE5A>&<EUE)C>EV%UUUS.En=E2C74EM;0BCLE?0AJCE>5LEB"
U "42MC8>=LE>=4IQEF4LE342M;0A4LECF>LE0AA20HBEMF8C7%EVUEM<4<124ABEM"
U "4027%SE22#EEx4M2C8>&=EW_.En=E2C74EM58ABJCE;8D=4EFJ4E>?D4=ECD74E"
U "528;4E25>AEM8=?DACQEBJ>EF4LE20=LEA40J3E5AD><E8&CSEyD74EBM42>=J3"
U "E;8D=4E0M??40DABECJ>E14LEE4AJHEF428A3ED0CE5M8ABCISE&4LE0A4LEBC0"
U "MAC8=/6E0EM;>>?LEF8CJ7EC7&4EitLEBC0MC4<4)=CQE20=3EMC74=CE0E2M>="
U "38MC8>=1EC>ED3>EFM78;4#SEy7J4E5DM=2C8)>=Ej#tkECM4BCBLEC74LE58;J"
U "4E=DM<14ALE?0B2B43EDC>ECD74E5MD=2C28>=E#RRE8J=EC7D8BE220B4E%VER"
U "RLE0=31E85E2C74E24=3ED>5ECD74E528;4E%MjtkINE70JBE14D4=E4M=2>DM="
U "C4AD43E8JCEA4MCDA=JBECA)D4SE(x>Ej%tkMVINE8BLECADJ4E851EF4E20A4E"
U "MA40328=6E2C74E24=3ED>5ECD74E528;4SIEgDC1EF4E20A4EMDB8=J6EC7A4E"
U "g>M>;40J=E>?M4A0C)>AEs%tyQEDB>EFJ4EF0D=CECJ>E;>D>?EFM78;4LEC74L"
U "E4=31E>5EM58;4LE2>=M38C8D>=E8JBE502;B4S1E&4EMF0=C1EC>ED3>ECD74E"
U ";2>>?EMF78;J4EF4LE0A4LE=>CLEA40M38=6LE5A>J<EC7J4E4=J3E>5LE58;&4"
U "EVSLE(>DLEF8;J;E;420A=EM<>A4LE01>)DCEgM>>;4D0=E>M?4A0MC>AB%EMst"
U "%yQEf%siQE%twQE&'twQLE4C2#SNE0JBEH>JDE2>M=C8=DD4E?MA>6AM0<<8)=6"
U "SELy74=1EF4EM0BB8D6=ECD74E2MDAA4D=CE320C0ED8=ECD74E528;4EDC>ECD"
U "74E0MAA0HJBEF4LE342M;0A4J3E8=LEB42MC8>=%EVSE1y74E%nsuz%yEHEMBC0"
U "CM4<4=JCE8BLEDB4J3EC>LEA40J3E5AD><ECD74EBM?428M5843LE58;J4E8=DC"
U ">ECD74EBM?428M5843LEE0AM801;/4MBNLED=CD8;E0LE2><D<0E>JAE20MAA80"
U "D64EAM4CDAJ=E8BLE4=2M>D=CM4A43%SE22#EEx4M2C8>&=EX_IEy74LE<08J=E"
U "?DMA?>BJ4E>5LEC78JBEB4M2C8>J=E8B1EC>EDA4RFMA8C4LEC74LEC>?%EVUEM"
U ";8BC1E85E2C74EM?;0HD4ALBLEA0=M3><;JHE64M=4A02C43EMB2>AJ4E?;M024"
U "B1E>=E2C74EM;8BCISE&41E3>EMC78B1E1HEM2H2;28=6EMC7A>2D67E2C74EM;"
U "8BCIQE0=J3EC4MBC8=J6E85LEH>DJAx2>)A4JED8BE6MA40CD4AEC270=ED>AE4"
U "M#D0;1EC>E%McbNLEC74LE2DAMA4=CLE?;0MH4ABM2>A4IJE1428=6EMC4BC)43"
U "SECn5E8JCE8BIQEC7D4=EFJ4E70DE4ECJ>EB7285CEM4027LE4G8MBC8=J6EB22"
U ">A4EM14;>JFEC7J4E2DMAA4=JCE>=J4E3>DF=E>D=4ECJ>E<0D:4EA2>><E25>A"
U "E2C74E2=4FEMB2>AJ4E1428=6EM0334&3SEyD74ED2B4AED8BE2M>=6AM0CD;M0"
U "C43LE0=3LE?A>M<?C4J3E5>JAEC7248AEM=0<4#SEy7J4E;>D>?E8JBEC7D4=E4"
U "MG8C4J3EDB28=6E2C74E(j'ny%EktwLEBC0MC4<4)=CQEMF782J7EC7D4=E62>4"
U "BEDC>EBM42C8)>=EY%SE22#EEx4M2C8>&=EY_IEy78JBEB72>ACEMB42C28>=EM"
U "B8<?D;HE>M?4=BLEC74LE58;J4E5>JAE>DMC?DC1EB>EDF4E2D0=EFMA8C41EC>"
U "E)8CSELy74=1EF4EMFA8CJ4E40D27E>J5EC7J4E<4M<14AJBE>5LEC74LE0AAD0"
U "HECJ>E58);4SE%22EELx42C28>=E%Z_EnJ=EC7D8BE5M8=0;LEB42MC8>=1EF4E"
U "M3458D=4ECD74E5M>A<0JCEBCMA8=6IQE?A28=CE2C74EM740324ABQLE0=3LEC"
U "74J=E?A28=CE20;;E2C74EM<4<124ABED>5ECD74EC)>?EVIUE0=J3EC7248AEM"
U "B2>A)4BSE1f=3EMC70CCLBECD74E4D=3E>J5EC7J4E?AM>6A0&<FE2I2s>F1E>="
U "EDC>E0LE=4FLEC>?)82QEMF782J7EF8D;;E;M0C4ALE1422><4EMA4;02C43EDC"
U ">ECD74E?MA4E82>DBSIEzB4JAE34M58=4J3ECH2?4BSIEw4220;;EMC70CCE0EC"
U "2H?4ED8BECD74EC2H?4ED>5EEM0;D4CE0EEM0A8021;4E220=EM70E4IQEBDD27"
U "E0JBE8=MC464AAQEBMCA8=A6QE;2>=6QLE3>D21;4Q1E>AEMB8=6);4SE2(>DE2"
U "20=EM2A40DC4EH2>DAE2>F=EMCH?4JBEF72827EM2>=C208=E2>=4ED>AE<2>A4"
U "ED>5ECD74E0M;A40D3HE3M458=D43ECMH?4B#SEm4DA4E8JBE0=LE4G0M<?;41E"
U ">5EJ0EDBD4AE3M458=D43EC2H?4_%E22y&(ujEM4<?;M>H44LyH?4#2EE5M8ABC"
U "M=0<4%EfxE%xywn%slEO%EXU2IEE;0MBC=0)<4Ef%xExy%wnsl%EOEX%U2EE206"
U "4E%fxEn%syjl%jw2ELEF06&4Efx%Exns%lqj2%jsiE(y(ujI22&4LE70EJ4E34M"
U "58=4/3E0E2=4FEMCH?4IQEF72827EM2>=BM8BCB1E>5EM5>DALE30CJ0E<4M<14"
U "AABQE0&BEnEM20;;LEC74A<SE&J4E20J=E=>JFE34M2;0A/4E0EME0A8M01;41E"
U ">5EMC78BLECH?&4_E2%2inrLE4<?M;>H4&4EfxLE4<?M;>H4J4yH?&422fLEE0A"
U "M801;J4E>5CE0ED2B4AEM34582=43EMCH?41E8BEM;8:41E0=EM0AA0AHQE8J=E"
U "C7D0CE8JCE20J=E70DE4E<2>A4EMC70=LE>=4LEE0;DD4E0MBB862=43EDC>E8&"
U "CSEgDDCEHD>DE2D0=E720E4ED0=E0MAA0H1E>5EJ0EE0MA801D;4E>/5E0EMDB4"
U "ALE345M8=43LECH?J4E0BLEF4;A;QEBJ>EC7M8=6BLE20=LE64CLEA0C274AEM2"
U "><?2;4GSIEf=H2F0HQLE=>FLEC70JCEH>JDE70DE4E0LEDB4JAE34M58=4J3ECH"
END SUB

SUB V4
U ")?4QE2H>DE220=EM0BB8D6=EEM0;D4JBEC>LEC74LE30CJ0E<4M<14AJBE>5LEC"
U "70JCEE0MA801);4SE1zB4EJ0E?4MA8>31EC>EM0224DBBE0LE30CJ0E<4M<14A1"
U "E>5EJ0ECH)?4QEM;8:4LEC78&B_E2L24<?M;>H4J4S58MABC=20<4E%bEGg)>1G"
U "2M4<?;M>H44LS;0BMC=0<&4EbEIGk>B2C4AGL24<?M;>H4J4S06&4EbE#WY24M<"
U "?;>2H44SMF064%EbE[%S\]2I2y78JBE2>2D;3EM70E4LE144J=E74M;?5DJ;E8="
U "LEC74LE;0BJCE?AM>6A0J<EF4LE<03J4EF8DC7ECD74EC)>?EVIUE;8)BCSED&4"
U "E2M>D;3LE70EJ4E34M2;0AD43E0LEDB4JAE34M58=4J3ECHD?4E2M0;;4J3E?;M"
U "0H4ALyH?4IQE;8D:4EC278B_%E22y&(ujEM?;0HD4AyH)?42ELE=0<&4Efx%Exy"
U "w%nslE%OEWU#2EEBM2>A4%EfxE%nsyj%ljw2%jsiE(y(ujI220=J3EC7D4=E3M4"
U "2;02A43ED0=E0MAA0H1E>5EME0A8M01;4JBE>5LEC70JCECH)?4E2%2inrLE?;0"
U "2H4AM%VEyt%EVUN%EfxEM?;0HD4AyH)?422Ly70CLEF>DD;3E720E4EM<034LE>"
U "DALE2>3J4E<>DA4E4M5582M84=CIQE1DJCE=>JCE=4M24BBM0A8;JHE<>DA4EAM"
U "403021;4SIEs>C2824EMF74=1EF4EM342;20A4EJ0EBCMA8=61E8=EJ0EDBD4AE"
U "3M458=D43EC2H?4EMC70C1E8CEMB44<JBE0B1E85EDF4E0DA4E<MD;C8M?;H8D="
U "6E8JCE1HCE0E=MD<14&ASEfM2CD02;;HQ1EF4E2C74EM=D<1D4AE0M5C4ALEC74"
U "#EOE3M458=D4BECD74E<M0G8<DD<E;M4=6CJ7E>5LEC74LEBCA28=6SLE(>DLE<"
U "DBJCE34M58=4LEC78JBE14M20DBJ4EC7J4EB8DI4E>/5E0EMDB4ALE345M8=43L"
U "ECH?J4E<DDBCE1J4E:=2>F=ED1HECD74E2M><?D2C4ASIEf=HLEE0;DD4E0MBB8"
U "62=43EDC>EC278BEMBCA8D=6E320C0EM<4<1D4AEFM7827LE4G2M443BLEC74LE"
U ";4=26C7EMB?42M8584J3E8BLECADM=20C)43SE#22zBD4AE3M458=D43ECMH?4B"
U "LE20=LEB4ADE4E<2>A4EMC70=1EC>ED14E4M5582M84=C#SEy7D4HE0DA4ECD74"
U "E7M40AC1E>5E2C74EMA0=3D><E0M224BJBE58D;4E<2>34QLEF78D27E8JBE2>M"
U "<<>=D;HED2B43ED8=E3M0C0120B4EM58;4&BSEfLE30CM010BJ4E8BCE0E<M4C7"
U ">J3E>5LE>A6M0=8I28=6EM;0A6J4E#DM0=C8MC84B1E>5EM8=5>MA<0C28>=ED8"
U "=EAM42>AD3BE0D=3E5M84;3&BSEn/=E0EMA42>)A3QEMC74AJ4E0A/4E0E2B4CE"
U "D>5E5M84;3JBEF72827E20A4EM2>=BMC0=C1E8=EM4E4AJHEA4M2>A3%SEfEM58"
U "4;/3LBEME0;DJ4E27M0=64JBE5AD><EAM42>AJ3EC>LEA422>A3QLE7>FM4E4A#"
U "SEoDDBCECD74E=20<4ED>5ECD74E5M84;3LEA4<M08=BLE2>=MBC0=&CSExJ>E7"
U ">JFE3>D4BEC278BEMA4;0DC4ECJ>EDBD4AE3M458=D43ECMH?4BIdE&4D;;ECM7"
U "8=:1E>5EJ0EE0MA801D;4E>/5E0EMDB4ALE345M8=43LECH?J4E0BCE0EAM42>A"
U "J3E8=LEC74L230CM010BA4QE0D=3ECD74E320C0EM<4<124ABEM584;D3BE>J5E"
U "C7J4EA4M2>A3&BSEjM<?;>2H44E2<0HED14E0LEA422>A3QLE0=3LE58AMBC=0)"
U "<4QEM;0BCM=0<4IQE06A4QE0D=3EF2064E2<0HED14E5M84;3ABSE%M0;D4JBE2"
U "0J=E14LE0BBM86=4J3EC>LEC74LE5842;3BED8=E42027EMA42>)A3QEMC7DBLE"
U "2>=MBCADM2C8=/6E0EM30C0M10B4%SEfEM58;4LE>?42=43E25>AEMA0=3D><E0"
U "M224BJBE8BLE>A6M0=8ID43E8J=EC7D8BE5M0B78)>=QEMF8C7LEA42M>A3BLEB"
U "?;D8CE82=C>EM584;)3BSELj027LEA422>A3ED8=ECD74EAM0=3>J<E02M24BBL"
U "E58;J4E8BLE68ED4=E0LEA422>A3EM=D<1D4AEFM7827LE20=1E14EM2>=EM4=8"
U "4D=CE8/=E0EM30C0M10B4LE4=EM8A>=M<4=C#SEn=LEC74%EtujIsEBCM0C4<24"
U "=CE25>AEM>?4=28=6EJ0EA0M=3><LE02224BBEM58;4LEC74DA4E8JBE>=J4E4G"
U "2CA0EM0A6DM<4=CISE&4LE<DBJCEB?M4285JHEC7J4E;4M=6C71E8=EM1HC4JBE"
U ">5LE7>FLE<D2J7EB?2024E2>=4EMA42>DA3EF28;;EM>22D)?HERIREC7J4EA4M"
U "2>A3LE;4=26C7SIEy78JBE20J=E14LE40B28;HEMC0:4J=E1HLEC0:28=6E2C74"
U "E#qjs6DC7E>/5E0EME0A8M01;4LE345M8=431E0BE2C74EMDB4ALE345M8=43LE"
U "CH?J4EF4LE0A4LE6>8D=6ECJ>EDB&4SExJ>E10D2:ECJ>E>DJAE4<M?;>HD44E4"
U "MG0<?);4QEDF4E2M>D;3LEDB4LEC74%EqjsLE5D=M2C8>J=EC>LE64CLEC74LEB"
U "8IJ4E8=LE1HCD4BE>J5EC7J4E4<M?;>HD44EEM0A8021;4QLEF78D27E8JBE0=L"
U "E4<?M;>H4J4yH?&4SEm24A4LJBEC7J4E2>)34_EI22A4M2>A31q4=H%EbEq#jsM"
U "4M<?;>2H44N%2tuj#sEG3M0C0120B4S230CG%Ektw%Ewfs%itrE%fxEH%VEqj%s"
U "EbEMA42>DA3q4&=H22%qjsEMBC0=D3BE5D>AE;M4=6CA7SE(D>DE2D0=E02;B>E"
U "2DB4E2C74E%qjsEM5D=2MC8>=1EC>E264CE2C74EM=D<1D4AE>J5E27M0A02MC4"
U "AB1E8=EJ0EBCMA8=6IQE1DJCEC7D0CE8JBE:8D=3E>J5E8AMA4;4ME0=CLEA86D"
U "7CE=)>FSECx>E;D4CLBLE2>=MBCADD2CE0LEB8<2?;4EM30C0M10B4LEC70JCEF"
U "8D;;E:244?EMCA02J:E>5LEC74LE4<?M;>H4D4BE>/5E0EM1DB8M=4BB%SE22#L"
U "Ex4M2C8>&=EV2%hqx2(y(ujLE4<?M;>H4J4yH?&42EEM58ABMC=0<&4Efx%Exyw"
U "%nslE%OEXU#2EE;M0BC=20<4E%fxEx%ywns%lEOE%XU2ELE064%EfxE%nsyj%lj"
U "w2IEEF0)64Ef%xExn%slqj%2jsi.Ey(u%j2inIrE4<M?;>H)44EfIxE4<M?;>HD"
U "44yH)?422#LEx4M2C8>&=EW2%uwns%yEGV%SNEhMA40CJ4E=4JFEA4M2>A32B4C"
U "G%2uwn%syEG%WSNEM%84FLE4G8MBC8=J6EA4M2>A32B4CG%2nsu%zyEGM&782J7"
U "E>?MC8>=%dEEGIQEB4M;42C28>=J%22LELx42C28>=E%X2nkLEB4;M42C8)>=JE"
U "%bEVE%ymjs%E2EE%nsuz%yEGmD>FE<20=HEM4<?;M>H44JBE0AJ4E8=LEC74LE2"
U "><M?0=H%dEEGIQE=DJ<w42M>A3B%J2EEMA42>DA3q4&=HEb%EqjsLM4<?M;>H4&"
U "4N2E%Etuj#sEG3M0C0120B4S230CG%Ektw%Ewfs%itrE%fxEH%VEqj%sEbEMA42"
U ">DA3q4&=H2E%EEEk#twE8%JEbE%VEytLE=D<Lw42>2A3BJ%2EEE%EEEh%qx2E%E"
U "EEE%Ensu%zyEGLk8ABJCE=0)<4_E%EGQEM4<?;M>H44LS58AMBC=0)<42E%EEEE"
U "%Ensu%zyEGLq0BCLE=0<&4_EE%EGQEM4<?;M>H44LS;0BMC=0<&42EE%EEEE%ns"
U "uz%yEGf)64_E%EEEE%EEEE#GQE4M<?;>2H44S20642%EEEE%EEns%uzyELG&06&"
U "4_EE%EEEE%EEGQLE4<?M;>H4J4SF0)642E%EEEE%Euzy%EHVQIEQ4<M?;>H)44E"
U "2%EEEE.sj'y(E8J2%EEEE%hqx2%EEhq%txjE%HV2E%Euwn%syEGLw42>MA3B4JC"
U "E2AM40C8D>=E2M><?;24C4G%2EEj%si2j%siEn%k22LIEx42MC8>=%EY2nIkEB4"
U "M;42C28>=J%EbEW%Eymj%s2EEMA42>DA3q4&=HEb%EqjsLM4<?M;>H4&4N2E%Et"
U "uj#sEG3M0C0120B4S230CG%Ektw%Ewfs%itrE%fxEH%VEqj%sEbEMA42>DA3q4&"
U "=H2E#EEE5M>A<0&CIEb.EG+E%EEEE%EEEE%EEEE#EEE+(Q+EE%EEEE%EEEE%EEE"
U "E.EE+E%EEHH%HEEI%IHHS%HHG2%EEEE%EEEE%uwns%yEGq20BCEM=0<4%EEEE%E"
U "EEE#EEk82ABCEM=0<4%EEEE%EEEE%EEEf)64EEM&064%EEEG%2EEE%EEEE%Euwn"
U "%syEG%RRRR%RRRR%RRRR%RRRR%RRER%RRRR%RRRR%RRRR%RRRR%REEE%RRRE%ER"
U "RR%RRRR%G2EE%EEit(E&mn%qjEs%tyEj%tkMV%N2EE%EEEE%ljyE%HVQELQ4<?M"
U ";>H4&4EEE%EELxM>AAHLE01>DDCECD74E;M4=6CJ7E>5LEC78JBE;8)=4FF%FE2"
U "E%EEEE%Euwn%syEz%xnslLE5>A2<0CII$E4<M?;>HD44S;M0BC=20<4$LE4<?M;"
U ">H4J4S58MABC=20<4$LE4<?M;>H4J4S06A4$E4M<?;>2H44SMF064%2EEE%Eqtt"
U "%u2EE%hqtx%jEHV%2EEj%si2j%siEn%k22n1LE4EMB?;8JCEC7D8BE?MA>6AD0<"
U "E82=C>EMB42CM8>=BLE060D8=E1M420DDB4EC270CEMB44<JBEC>LEF>AJ:EF4D"
U ";;E5D>AECD74E;M0A64JAE>=)4BSE%22EELx42C28>=E#V_E&J4LA4LE345M8=8"
U "=J6EC7J4EDBD4AE3M458=D43EC2H?4E20=3EM342;M0A8=/6E0EME0A8M01;41E"
U ">5EMC70CLECH?&4SE2%2EExM42C8)>=EW#_Ey7J4E582ABCEMC78=J6EC7J4EDB"
U "D4AEB244BED8BE0LE<4=JDEF8DC7ECD74E>M?C8>J=EC>LE48C274AEM2A40DC4"
U "E0LE=4FLE30CM010BA4EMAM42>AM3B4CINE>ALEE84JFEC7J4E4GM8BC8D=6E>)"
U "=4SE1y74EMDB4A1E8BEM?A><M?C431EC>EM<0:4CE0EBM4;42MC8>=LEF78D27E"
U "8JBEBCM>A431E8=E2C74EME0A8M01;4LEB4;M42C8)>=JS%E22EIEx42MC8>=%E"
U "X_ECn5ECD74ED2B4AEM27>BJ4E>?MC8>=%EVERIRE2AM40C4CE0E=D4FEAM42>A"
U "M3B4C%ERREMC74=LEC78JBE2>D34E8JBE4GM42DC)43SELk8ABJCEF4LE?A>2<?"
U "CE2C74EMDB4ALE5>ALE7>FLE<0=JHE4<M?;>H244BE20A4ED8=ECD74E2M><?0D"
U "=HEBJ>EF4LE:=>JFE7>JFE<0D=HECM8<4B1EC>ED6>ECM7A>DD67E0LE;>>&?SE"
U "y274=EDF4E>2?4=E2C74EM58;4IQE?AM><?CLEC74LEDB4JAE5>JAEC7J4E30DC"
U "0E5D>AE42027EME0A8M01;4IQE0=J3EFA28C4E2C74EMF7>;J4EA4M2>A31EC>E"
U "M58;4#SEy7J4EA4M2>A31E8BEMFA8C2C4=EMDB8=J6EC7&4EuzIyEBCM0C4<24="
U "CSIEy74LE58ADBCE0MA6D<24=CE)8=Eu#zyE8JBEC7J4E58D;4E=MD<14AAQECD"
U "74EBM42>=J3E8BLEC74LEA422>A3EM=D<1)4AQE20=3E2C74EMC78AJ3E8BLEC7"
U "4LE30CJ0EC>1E14EMFA8C2C4=EDC>E528;4S.En5ED=>EAM42>AJ3E=DM<14A1E"
U "8BEMB?42M8584J3E5>JAEC7J4EB4M2>=3LE0A6MD<4=ACQECD74E2MDAA4D=CE5"
U "28;4EM?>B8MC8>=1E8BEMDB43IQEF72827EMF8;;LE9DBJCE0?M?4=3LEF70JCE"
U "F4LEB?4M285HLE05CD4AEF270CED8BE0M;A40D3HECM74A4#SEy7D8BEFM>A:BL"
U "E58=A4QEBJ>EF4LE3>=CLCE=2443EDC>EFM>AAHLE01>DDCE4MG?;8228CEMA42"
U ">DA3E=MD<14)ABSELs>C8D24EC270CEDF4E0DA4EFMA8C8D=6ECD74EFM7>;4LE"
U "4<?M;>H4J4EE0MA801D;4ECJ>E58);4SELy78B1E8BEM14202DB4EDF4EFMA8C4"
U "LEA42M>A3B1EC>EM58;4IQE0=J3EC7J4EF72>;4EME0A8M01;4LE2>=MC08=JBE"
U "C7J4E30DC0E5D>AECD74E320C0EM<4<124ABELM5842;3BN%SE22#EEx4M2C8>&"
U "=EY_.En5E2C74EMDB4ALE27>M>B4B1EC>EME84FLEC74LE4G8MBC8=J6EA4M2>A"
U "32B4CQLEC74J=EF4LE58ADBCE>2?4=E2C74EM58;4IQE34M58=4CE0E5M>A<0JC"
U "EBCMA8=6LE5>ALEC74LE?A8M=C>DACQE0D=3E?MA8=CLEC74LE740M34AB#SEs4"
U "DGCEFJ4E70DE4E0LE;>>J?ED=2C8;E2C74E24=3ED>5E528;4ED8BE4M=2>DM=C"
U "4A)43SELs>C8D24EC)74El#jyEBMC0C4M<4=CIQEF72827ED8BED2B43EDC>EA2"
U "403EM5A><CE0EAM0=3>J<E02M24BBLE58;&4SEyD74E5M8ABCLE0A6MD<4=JCE8"
U "BLEC74LE58;J4E=DM<14A1EF4EMF0=C1EC>EMA403LE5A>A<QECD74EBM42>=J3"
U "E8BLEC74LEA422>A3EM=D<1)4AEMMF782J7EF4LE0A4LE;40ME8=6LE1;0D=:E1"
U "M420DDB4EFJ4E20J=EA4D03E52A><E2C74EM2DAA24=CEM?>B8MC8>=(E*huJ,E"
U ";8D:4EFJ4E38J3E8=LEC74%EuzyLEBC0MC4<4)=CNQLE0=3LEC74LEC78DA3E8J"
U "BEC7J4EE0MA801D;4E8J=2F72827EDF4EA2403E2C74EM30C01E8=E)C>SELy78"
U "BLEE0AM801;J4E<DDBCE1J4E>5LEC74LEB0<J4ECHD?4EC270CEDF4EFMA>C4LE"
U "F8CJ7E>ALE4;BJ4EC7J4ECH2?4BEMF8;;1E14EM8=2>M<?0CM81;4ISE(>/DL3E"
U "M?A>1M01;HLE64C(E0Ey&(ujE%rnxr%fyhmLE4AAD>AE8/5E0EM3855M4A4=JCE"
U "E0MA801D;4E8JBEDBD43E1M420DDB4ECD74E5M84;3JBE0AJ4E=>JCE4#2D0;Q1"
U "EB>E2C74EM?A>62A0<EM3>4BLE=>CLE:=>JFEF7D0CECJ>E0BMB86=LEC74LE30"
U "CJ0EC>%SE22M&4;;LEC70/CLBED8CE5D>AEAM0=3>J<E02M24BB#SEn5LEH>DLE"
U "70EJ4ED=M34ABMC>>3LE70;J5E>5LEF70&CEnLDE4EB2083QLE544J;E6>)>3SE"
U "2(>DEM70E4CE0E62>>3EM:=>FM;436J4E>5LEF70&CEvgM0B821E8BEM01>D&CS"
U "EsD>FE>J=EC>LEB><J4E<>DA4E0M3E0=2243EM?A>6MA0<<28=6F%E222%xjhy%"
U "ntsE%YERE%lwfu%mnhxI2lA0M?782JBE?AM>6A0M<<8=J6E8=#Evg02B82E220="
U "E264CEM508AD;HE2M><?;)4GSELq4CBLEBC0DACE52A><E2C74EM1468M==8=A6"
U "SE(2>DAEMB2A4D4=E8JBE<0D34EDJ?E>5LE7D=M3A43JBE>5LE?8G24;BSIEy74"
U "LE=D<214AED>5E?M8G4;JBE7>MA8I>M=C0;D;HE0D=3ECD74EEM4AC8M20;;JHE"
U "34MC4A<M8=4BLEC74LEA4BM>;DC28>=ED>5EH2>DAEM<>=82C>ASIEw86D7CE=)"
U ">FQEMH>DALE<>=M8C>A1E8BE2B4CEDD?E8/=E0EME834J>E6AM0?78D2BE<2>34"
U "EMF782J7E34MC4A<M8=4BLE7>FLE<0=JHE?8MG4;BLE20=1E14EM38B?M;0H4J3"
U "E>=LEB2A244=S.ErHEMA4B>M;DC8D>=E8JBEB4JCEC>%E]UU&G[UULEA86D7CE="
U ")>FQE21DCE2C74EM<>BCLE2><2<>=E)8BE[.YUGY%]USEM(>DALE6A0M?782JBE"
U "<>D34E8JBE34MC4A<M8=431E1HE2C74EMB2A4D4=EAM4B>;MDC8>J=E8=LE?8G2"
U "4;BQLEC74LEC4GJCEA4MB>;DMC8>=IEM7>JFE<0D=HE;M8=4BLE0=3LE2>;MD<="
U "B1E>5EMC4GCLE20=LE58C1E>=EMH>DALEB2A244=NIQEC7J4E=DM<14A1E>5EM?"
U "064JBE>5LEE83D4>E<M4<>AAHQE0D=3ECD74E2M>;>ALE?0;M4CC4#SEy724A4E"
U "20A4E#VXEBM2A44J=E6AM0?78D2BE<M>34B1E8=EIvg0B)82QE20=3EM4027LE7"
U "0BLE8CBLE385M54A4D=CE?MDA?>)B4SE2(>DE220=EM;>>:1E8=E2C74EM74;?L"
U "E8=3D4GE8&=EvgM0B82LE5>ACE0E;M8BC8D=6E>J5EC7J4EB2MA44=LE6A0M?78"
U "2JBE<>234BE20=3EMC748JAEB?M4285M820CM8>=B#SEj0D27E>J5EC7J4E0BM?"
U "42CJBE>5CE0EBM2A44J=E6AM0?78D2BEC2H?4E220=ED14E2M70=6D43ECJ>E2A"
U "M40C4LE455M42CB%SE22Ly74AJ4E0A/4E0EM=D<1D4AE>J5E6AM0?78D2BEAM>D"
U "C82=4BEMDB431E8=EIvg0BD82EFM7827LE0;;D>FE0LEE0AM84CH1E>5EM6A0?M"
U "7820J;E45M542C&BSEq24CBE2CAHEJ0E54&F_E2%2xhw%jjsE%VW2q%nsjE%MUQ"
U "U%NRM[%YUQY%]UNQ%EV2h%nwhq%jEMX%WUQE%WYUN%QEWU%QEW2%uxjy%EMVU%Q"
U "VUN%QEVY%2iwfA&EG2#VZE1&<VUU%QYUUCE;Z4CZ5Z;%ZG2j%si221y74EM58AB"
U "JCE;8D=4E8M=8C8M0;8ID4BECD74E6MA0?7282BEM<>341EC>E%VWQEMF782J7E"
U "8B%EV[EM2>;>)ABQEIVE?0D64E>J5EE8234>EM<4<>)AHQE20=3E#[YUG%Y]UEM"
U "A4B>M;DC8)>=SE%E22E%EqnsIjE3A20FBEJ0E;8D=4E52A><E2>=4EM2>>AM38="
U "0DC4ECJ>E0=M>C74&ASEyD74E5M8ABCLE>?CM8>=0J;E0AM6D<4D=CE0M5C4ALE"
U "C74LE2>>MA38=M0C4BIEMF72827E20A4E2=>CEM>?C8M>=0;INE8BLEC74LE2>;"
U ")>ASELf5C4JAEC7)0CQE&0EgEIMG1>&GGNE)>AEg%kEMG21>GEM58;;#GNE2D0="
U "E1J4EDBD43ECJ>E3AD0FE0LE1>G1E>AEJ0E1>JGE58M;;43LEF8CJ7EC7J4E2>2"
U ";>AEMB?42M8584&3SEyD74E5M8ABCLE2>>MA38=20C4E220=ED14E>M<8CCD43E"
U "0D=3EC)74ERLE;45JCE8=1EC>EM3A0FCE0E;28=4EM5A><LEC74LE2DAMA4=CLE"
U "6A0M?782JBE?>MB8C8)>=EM%huNEDC>ECD74EAM4;0C28E4EM2>>AM38=02C4BE"
U "MB?42M8584&3SEq%nsjE%RMVU%UQUNLEF8;J;E3AD0FE0LE;8=J4E5AD><ECD74"
U "E2MDAA4D=CE6MA0?7282BEM?>B8MC8>=1EC>E%VUUEM?8G4D;BECJ>EC7J4EA82"
U "67CS%22EE%hnwh#qjE3MA0FBCE0E2M8A2;J4EF8DC7ECD74E2M4=C4JAE0CLEC7"
U "4LE2>>MA38=M0C4BLEB?4M2858)43SE1y74EM58ABJCE0AM6D<4)=CEMMA4#DM8"
U "A43INE052C4AE2C74EM2>>AM38=02C4BED8BECD74EAM038DJBE>5LEC74LE28A"
U "22;4SIEy74J=E2>2<4BE2C74EM2>;>&ASEfM5C4ALEC70ACQE8J5EH>JDEF0D=C"
U "ECJ>E3AD0FE0J=E0AA2QE8JBEC7J4EBCM0AC8D=6E0M=6;41E>5E2C74E20A2ED"
U "8=EAM0380)=BQEMC74=LEC74LE4=328=6EM0=6;J4E>5LEC74LE0A2#SEy>LE<0"
U ":J4E0=LE0A2IQE582ABCEMC>D2J7ED?1E>=EMH>DALE64>M<4CAAHQEC274=EMA"
U "420D;;EC270CEDC>E2M>=E4DACE52A><EM346A244BEDC>EAM0380D=BE8&BEun"
U "%EMXS%VYVZ%^W[ZINE38ME834J3E1H%EV]U#SEy7J4E;0DBCE0MA6D<24=CED8B"
U "ED2B43ED85EHD>DEF20=CEDC>E<20:4ED0=E4M;;8?)B4QE20=3ED8BECD74EAM"
U "0C8>1E>5E2C74EJHE0GD8BECJ>EC7/4EGEM0G8B#SEx>%EEhn%whqj%EMXW%UQW"
U "Y%UNQE%WUQE%WQEX%SVYV%ZQEU%QESZLEF>DD;3E32A0FED0=E4M;;8?MC820J;"
U "E6A244=E20A2EMF8C7LEC74LE24=2C4AED0CECD74E<M833;J4E>5LEC74LEB2A"
U "244=QLEBC0MAC8=J6E0C%EV]ULE346MA44B%EMunINE0=J3E6>28=6E)C>EULE3"
U "46MA44BIQEF8DC7E0LE2><M?A4BMB8>=LEA0CD8>E>&5EVE)C>EW.EMGEM0G8BL"
U "ECF8D24E0JBE18J6E0BLEC74(EHNSIEy78JBE;>2>:BEM;8:4CE0EF2834EMB<8"
U ";D4HE52024EM<>DC&7S22%EEux#jyE5M8;;BCE0E?M8G4;1E0CE2C74EMB2A4D4"
U "=E2M>>A3M8=0CJ4EH>JDEB?M4285JHEF8DC7ECD74E2M>;>ALEH>DLEB?4M285H"
U "#SEn=LEC78JBE20)B4QEMH4;;)>FS2%EE2kM8=0;);HQE2C74E#iwf&LEBC0MC4"
U "<4)=CSE1y74E#iwf&LEBC0MC4<4D=CE7D0BE8/CLBE2>F=EM2><<M0=3BLEF78)"
U "27EnLEBCAM>=6;JHEBDM664BJCEH>JDE<4M<>A8)I4SEM&74=1EF4E264CED8=E"
U "CJ>EB2M0;8=J6E0=J3EA>MC0C8D>=EHD>DEF28;;EM=4431EC>EM:=>FLEH>DJA"
U "E3AD0FE2M><<02=3BEM?A4CDCHEF24;;SIEy74LE3A0JFE2>M<<0=J3E8=LEC74"
U "LE01>DE4E22>34EM4G0<2?;4E220=ED14EA2403E)0BEGM2>;>&AEVZIEMF728C"
U "4NIQE<>DE4EFM8C7>DDCE3MA0F8D=6ECJ>EB2MA44=LE2>>MA38=20C4E%VUUQ%"
U "YUUQLE3A0JFE;4)5CEZLED=8)CBQEM3A0F1ED?E20=3EMA867&CEZEMD=8CABQE"
U "32A0FEM3>F=LE0=3LEA86)7CEZLED=8)CBQE20=3EM3A0FLE;45&CEZEMD=8C&B"
U "SGECn=E>MC74ALEF>A)3BQEJ0ECAM80=6);4SEIfED=D8CE8JBEB4JCE1HLEC74"
U "LE2DAMA4=CLEB20D;4E<2>34QLEF78D27E1JH234M50D;JCE8B%EYSELx8=2J4E"
U "34M50D;JCEB220;4EM<>341E8BE#YQE>D=4ED2=8CEMA4?AM4B4=)CBEYLE?8G2"
U "4;BS.Ex>E2>DAEMCA80M=6;41E8BE#YUE?M8G4;JBEF8D34E0JCEC7J4E10)B4S"
U "E#22y724A4E20A4E#V[E3M458=D43E2M>;>AJBE8=#Evg02B82SIEy74%Ehtq#t"
U "wEBMC0C4M<4=CLEB4CJBEC7J4E2DMAA4=JCE2>2;>AE25>AEMC4GCLE>DC2?DCS"
U "#EnE7M867;JHEA4M2><<24=3EM<4<>MA8I8D=6ECD74E2M>;>AJBE0BLEF4;&;S"
U "EwDD=EC278BEM?A>62A0<_%E22x%hwjj%sEVW%2ktw(E8JE%bEUE%ytEV%Z2EE%"
U "htqt.wE8J%2EEu%wnsy%EGht%qtwG.$E8J#2sj'.yE8J#22y7D8BEF28;;EM?A8"
U "=JCE>DJCEC7&4EV[LE2>;2>ABEMDB431E8=EIvg0B)82SEIUE8BLE1;0)2:QEDB"
U ">EC270CEM>1E8M>DB;JHEF>/=LCEMB7>F1ED?S.Ef=EM#D82J:EA4M54A42=24E"
END SUB

SUB V5
U "25>AEM2>;>DABEFM78;4LEH>D1LA4ED8=EC)74EvLg0B8&2Eni#jEM8M=C46MA0"
U "C4J3E34ME4;>M?<4=JCE4=ME8A>M=<4=ACNE8JBEC>LE;>>J:ED=234AE2C74E%"
U "tuyn%tsxE&KEin%xuqfJ(E<4)=DSE1y74EM2>;>DABE;M8BC4J3EC724A4E20A4"
U "ED8=EC)74EvLg0B8J2E>A234AQLEBC0MAC8=J6EF8DC7E1M;02:LE0=3LE4=328"
U "=6EMF8C7LE1A8267CEMF78C&4SE2I2s>FLEH>DLE:=>JFEC7J4E102B82EM6A0?"
U "M782BLEA>DMC8=4JBE0=J3EC7248AEMDB4B%SSSEM;4CBLE<0:/4E0EM2>D?D;4"
U "E?MA>6A20<BEMC70CLE34<M>=BCMA0C4LEC74J<EC>CE0E6MA40CD4AE4MGC4=&"
U "CSEkM8ABC.QE0EM?A>62A0<EMF782J7E?AM><?CJBEC7J4EDBD4AE5D>AE0LEA0"
U "328DBQLE20;M2D;02C4BE2C74EM0A40LE0=3LE28AM2D<5M4A4=)24QE20=3EM3"
U "A0FJBEC7J4E28MA2;41E8=EJ0EA0M=3><LE2>;D>AE>J=EC7J4EB2MA44=%SE22"
U "%xhwj%jsEV%W2wf%sitr(n)jE%ynrj%w2ht%sxyE)?8FE%bEXS%VYVZ%2it2%EE"
U "ht%qtwE%VZ_E%nsuz%yEGwM038D&BEMRIVEC>LE#D8&CNER%RcEGIQEA0M38DB%"
U "F2EE#nkEAM038D&BFEb%ERVE%ymjs.Ej'n%yEit#2EE02A40F#EbE?&8FEOLEA0"
U "328DBF(E-EW#2EE2M8A2D&<FEb1E?8F%EOEW#EOEAM038D&BF2E%Ehtq%twEV%Y"
U "2EE%EEuw%nsyEIGfA4&0EbE%EEEE%EEEGI$E0A)40F2%EEEE%uwns%yEGhM8A2D"
U "M<54AM4=24%EbEGI$E28MA2D<%F2EE%hnwh%qjEM%XWUQ%WYUNIQEA0M38DB%FQ"
U "En%syMw%siEO%EVZE%PEVN%2EEi%t_Eq%ttuE&&mnq%jEns.pj(I%EbEG%G2EE%"
U "hqx2%qttu%2htq%twE^%_Euw%nsyEIGl>>A3EgH&4FG2%jsiE%2EE212&4EM58A"
U "BJCEB4JCEC7J4EB2MA44=LE6A0M?782JBE<>D34E0D=3E6M4=4A20C4EJ0EA0M="
U "3><LEB44J3E=DM<14ALE10BD43E>J=EC7J4EBHMBC4<LEC8<)4ASELy74=1EF4E"
U "M?A><D?CE5D>AECD74EAM038DJBE8=CE0EEM8E83LE1A8267CEMF78CA4QE0D=3"
U "EC24BCEDC>EBD44E8J5EF4LEB7>2D;3E24=3E2C74EM?A>62A0<S1E&4EMC74=L"
U "E20;M2D;0DC4ECD74E02A40E20=3EM28A2MD<54MA4=2A4QE0D=3E?MA8=CLEC7"
U "4LEA4BMD;CB1E8=EMH4;;)>FSELy74=1EF4EM3A0FLEC74LE28A22;4EM5A><LE"
U "C74LE<8323;4ED>5ECD74EBM2A44J=E0CLEC74LEA0328DBEM68E4J=E8=CE0EA"
U "M0=3>J<E2>2;>ASIEy78JBEA0M=3><LE2>;D>AE8JBEB4JCE1HLE58ADBCE6M4="
U "4AM0C8=/6E0EMA0=3D><E=MD<14JAE5A)><EU1EC>E%VYQEM0338)=6EV1EC>E)"
U "8CQE20=3EM2>=EM4AC8D=6E8JCEC>1E0=EM8=C4264AEMF8C7LEC74%EnsyLE5D"
U "=M2C8>&=SEyD74E=24GCEM;8=4LEB44D<BEFM48A3#SEy7&4Ens.pj(ILEBC0MC"
U "4<4D=CEAM403BLEC74LE:4HM1>0AJ3E0=J3EA4MCDA=JBEC7J4EBCMA8=6LEA4?"
U "MA4B4M=C0C28>=ED>5ECD74E:D4HE?MA4BB)43SED&4E0DA4E;M>>?8D=6EFM78"
U ";4%Ensp(j(IED8BE=M>C78)=6QED>AE8J=E>C274AEMF>A3ABQEFM78;4LEC74L"
U "EDB4JAE8B/=LCEM?A4BMB8=6LE0=HMC78=&6SEyD74E;2>>?EM6>4B1E>=EM5>A"
U "42E4AEMD=C8J;EC7J4EDBD4AE?MA4BBD4BE0D=HE:)4HQE20=3ED0CEC278BEMC"
U "8<4CE0EEM0;D4LEF8;J;E14LE68ED4=EC&>Ens.pj(ILEF78D27EHD>DE<M867C"
U "LE3422834EDC>ED)B4SE1y74EMB2A4D4=E8JBEC7D4=E2M;40AD43E5D>AECD74"
U "E=24GCEM4=CA&HSEnJ5EC7J4EDBD4AE1MA40:JBEC7J4E;>D>?E1JHE4=MC4A8)"
U "=6ERIVE5>JAEC7J4EA0M38DBIQEF4LE?A8)=CEl2>>3E1gH4F1E8=EM1A86D7CE"
U "12;D4EM;4CC24ABS%E22yM74A4LE0A4CE0E;D>CE<2>A4EM2>;>DABEC270=EM9"
U "DBC%EV[S.En=EM502CIQEH>JDE20J=E27M0=64LEC74LEE0;2D4BED>5E42027E"
U "D>5EC)74EVI[E2>M;>AB1EC>EMA4?AM4B4=JCEB>D<4E>MC74ALE2>;D>AEC270"
U "CE2H>DEMB?42285HSLE(>D1E3>EMC78BLEF8CJ7EC7&4Euf%qjyyIjEBCM0C4<2"
U "4=CSIEy74LE5>;M;>F8D=6E0M??;8D4BECJ>EB2MA44=LE<>3)4BEVIWE0=&3EV"
U "X#SEy7D8BEBMC0C4M<4=CLE70BLECF>LE0A6MD<4=)CB_E2C74EM2>;>JAEH>JD"
U "EF0D=CECJ>E27M0=64LE0=3LEC74LE2>;D>AEHD>DEBM?428)5HSELx?42M85H8"
U "D=6E0LE2>;D>AE8JBEC7J4E70DA3E?20ACSIEm4AJ4E8B1E<HEME4AB28>=ED>5"
U "ECD74EBMH=C0JGE>5LEC74LE?0;M4CC4LEBC0MC4<4)=CE2%2ufq%jyyjLE2>;)"
U ">AQEM1;D4M%0;D&4EOE%WZ[E&-EWEIPE6AM44=%M0;D4%EOEW%Z[EPLEA43M%0;"
U "D&4E22M2>;>JAE8BLEC74LE2>;D>AEHD>DE0DA4E2M70=628=6SIEy74LE.%0M;"
U "D4BLE0A4LE=D<M14ABLE5A>&<EUE)C>E[IXEF72827EMB?42285HE2C74EM8=C4"
U "M=B8CJHE>5LEC70JCE2>2;>ASLE(>DLE<DBJCEDBJ4EC7J4E<DM;C8?M;84AJBE"
U "052C4AE2C74EME0;DD4BE0D=3EDDB4ECD74E0M338C28>=EM>?4AM0C>A1EC>EM"
U "B4?0MA0C4LEC74&<SExJ>E;4DCBE<20:4EJ0E?AM>6A0J<EC7D0CE5M034BLEC7"
U "4LEB2A244=ED8=E0D=3E>)DCQEM5A><LE1;0D2:ECJ>E?DMA?;4#SEM12;D4E20"
U "=3E2A43EM<0:4LE?DA2?;4N%SE22%xhwj%jsEV%W2it%2EEk#twE8%JEbE%VEyt"
U "%E[X2%EEEE%ufqj%yyjE#UQE8%JEOE%WZ[E&-EWE.PE8J%2EEs(j'yE&8J2E%Ek"
U "tw(E8JE%bE[X%EytE%VExy%juER%V2EE%EEuf%qjyy%jEUQ(E8JE%OEWZ.[E-E%"
U "WEPE&8J2E#Esj'.yE8J%2qtt.uE&m%nqjE%nspj&(IEb%EGG2%jsiE#E22&J4EB"
U "C20ACED1HE2M70=628=6E2C74EME0;DJ4E>5LE1;0)2:EM%UNQEMF782J7E8BLE"
U "C74LE102M:6A>2D=3EM2>;>JAEC>LE?DA2?;4QLE5A>J<E>=J4E34M6A441E>5E"
U "M1;D4#EPEAD43ECJ>EC7J4E=4)GCSELy74=1EF4EM1A8=J6E8CLE102J:E3>DF="
U "ECJ>E1;202:ED1HE3M42A4M0B8=J6EC7J4E1;)D4EPLEA43LEE0;)D4SED&4E3J"
U ">EC7D8BE>2E4AE20=3EM>E4ALED=CD8;ECD74ED2B4AEM?A4B2B4BEJ0E:4JHE>"
U "ALE14628=BEDC>E720E4EMB48IMDA4B%SE22Lx20;28=6E20=3EMA>C0MC8>=LE"
U "20=1E14EM022>M<?;8MB743LE#D8DC4E4M0B8;JHEF8DC7EC)74Ei.wf&EMBC0C"
U "M4<4=ACQE0M;C7>2D67ED8CE8M=E>;2E4BEMB><4LEF48DA3E;M>>:8D=6E22>3"
U "4SIEk8A)BCQEM;4CBLE34528=4EJ0EB720?4EMC70C1EF4E220=EMB20;J4E0=J"
U "3EA>MC0C4%SE2221>GI%EbEG)1DZEA;ZE3#VUEA#VUED#VUE;IZE13%ZG22Ln=C"
U "4MA?A4MC0C8)>=_ELG<>EJ4ED?#EZEBM?024JBEF8MC7>DJCE3AM0F8=A6QE32A"
U "0FEIZEB?M024BLE;45ACQE32A0FE#VUEBM?024JBE3>)F=QEM3A0F%EVUEMB?02"
U "D4BEAM867CIQE3A)0FEVIUEB?M024B1ED?QLE3A0&FEZEMB?02D4BE;245CQLE0"
U "=3LE<>E&4EZEMB?02D4BE32>F=EMF8C72>DCEM3A0F28=6S#GEy7D8BE5M>A<BC"
U "E0E1)>GSELs>C8D24EC270CEInEBCM0AC4J3E0CLEC74LE24=2C4AE20=3E2=>C"
U "ED0CE0LE2>A2=4AED>AEB2834EMF782J7EF>2D;3EMB44<1EC>ED14E4M0B84AA"
U "SE&24;;QLEF74J=EH>JDEA>MC0C4LEB><M4C78)=6QED8CE3MA0FBLE10BD43E>"
U "J=EC7J4EBCM0AC8D=6E?M>8=C1E>5E2C74EM>194)2CQE20=3EDF4EF20=CED8C"
U "ECJ>EA>MC0C41EB>ED85EFJ4E?D/CE0E2?4=ED0CE42027EM2>A=D4AE>J5EC7J"
U "4E1>AGQE8JCEF>2D;3EM3A0FCE0E?M4A54D2CE2M8A2;&4SEyM74A4M5>A41EF4"
U "E2B4CE2C74EM24=CD4AE>J5EC7J4E1>JGE0BLEC74LEBC0MAC8=J6E?>28=CED>"
U "5ECD74E>M1942&CSEnLE20;J;EC7D8BEC)74EGM>194D2CE7M0=3;&4QGE2=>CE"
U "DC>E1J4E2>M=5DBD43EF28C7E2C74EM70=3D;4ED2B43ED8=ECD74E&M8=3>)FB"
U "Ef%unSE1y74EDC0E32A0FEM2><<20=3EMBC0=D3BE5)>AEGMCDA=LE0=6);4QGL"
U "E0=3LE>1EM8>DBD;HECMDA=BLEC74LE>19242CED8=ECD74E3M46A4D4BEHD>DE"
U "BM?428)5HSECx>E8J5EF4LECDA2=43E2C74E21>GEM5A><#EUEC&>EX[IUE34M6"
U "A44ABQE3MA0F8D=6ECD74E1D>GE0JCE40D27EB2C4?E20=3EM4A0B28=6E2C74E"
U "M?A4EM8>DBLE8<0)64QEDF4EFM>D;3LE64CCE0EAM>C0C28=6E21>GSIEgDC1EF"
U "4EM=443LE>=4LE<>AJ4E5DM=2C8)>=_E&%fwu%ywIS(E%fw%uywILEBC02=3BE2"
U "5>AELGE0AM801;J4E?>M8=C4&AQGEJ0EC4DA<EHD>DE2D0=E2M><?;M4C4;JHE8"
U "6M=>A4LED=;24BBE2H>DE264CEM8=C>#EhE>AAEfBMB4<1D;HE?MA>6AM0<<8)="
U "6SED&4E=2443EDC>EBM><47D>FE6D4CECD74E1)>GIEMB70?J4E8=DC>ECD74E3"
U "2A0FEMBCA8D=6E2M><<0D=3EFJ4EDBJ4E8<M?;4<24=CED8=ECD74E;2>>?Q1EB"
U ">EDF4E720E4EDC>EC20:4E2C74EM033A24BBED>5ECD74E>M1942JCEBCMA8=6L"
U "E0=3LE?;DJ6E8CLE8=CJ>EC7J4E3AD0FEBMCA8=&6SEy278BE220=ED14E0M22>"
U "<M?;8B2743ED1HEDMB8=6LEC74CE'E2M><<0)=3QEMF782J7EC42;;BE&%fwu%y"
U "wIEMF74AJ4EC>LE?;DJ6E8=LEC74LEBCA28=6LJBE03M3A4BJBEB>1E8CE220=E"
U "D14ED2B43SLE&8CJ7E1>AGIE3M458=D43E0M1>E4IQE74DA4LBLEC74LE2>3J4E"
U "5>/AE0EMA>C0MC8=6LE1>G%_E22%it2EM0=6;&4JEbLE0=6);4JE%PEV2%EnkEM"
U "0=6;&4JEc%bEX[%UEym#jsE0M=6;4%JEbE%V2Ei.wf&E(G2UE)1<XW%UQWYIUEC"
U "0%GEPE%xywILM0=6);4JE%REVN%EPEG&'GEP(E%fw%uywILM1>G%IN2E#iwf&.E"
U "G2V1E1<X%WUQW#YUEC&0GEP%ExywIIM0=26;4J%NEPE(G'GE.PE%f%wuywIIM1>"
U "&GIN2%qttu(E&mn%qjEn#spj(%IEbE%GG2j%si221s>CEMC70CLE70AJ3E8B1E8"
U "Cd1E&4EM3A0FLEC74LE1>G1E0CE2C74EM?A4EM8>DBLE0=6D;4E8J=E1;202:QL"
U "E0=3LEC74J=E3AD0FECD74E1D>GE0JCEC7J4E2DMAA4=JCE0=26;4ED8=E12;D4"
U "S%E22xM20;8D=6E8JBE3>D=4E?MA4CCJHE<DD27ECD74EB20<4E2F0HQLE1DCLE"
U "8=BMC4031E>5EM270=M68=6LEC74LE0=6D;4E0D=3E4MA0B8D=6ECD74E?MA4E8"
U "2>DBEM8<06A4QEFJ4E27M0=64LEC74LEB20D;4E5M02C>JAE0=J3E4A20B4E2C7"
U "4EM?A4EM8>DBLE8<0)64SELw420D;;EC270CE2C74EM34502D;CEMB20;J4E50M"
U "2C>ALE5>ALEC74%EiwfJ&EBCM0C4<24=CE)8BEYLE?8G24;BE2?4AEMD=8CISE&"
U "4);;QED85EFJ4E8=M2A40DB4EC278BEM502CD>AEC274=EDF4EF28;;EM70E4LE"
U "<>AJ4E?8MG4;BLE?4ALED=8ACQEC27DBEM68E8D=6ECD74E8M<064LEC74LE455"
U "242CED>5E4M=;0AM64<4)=CSECx>E8J5EF4LEB4C1ED?E&0Ekt%wSSS.sj'yLE;"
U ">>J?EF72827EMF8;;LE8=2MA40BJ4EC7J4EB220;4EM502CD>AE52A><EIWEC>I"
U "QEB0&HQEW%UUQEDF4EF28;;E264CE2C74EM4554D2CE>J5EB2M0;8=&6SEgDDCE"
U ";24CBEMBC0AJCEF8DC7E0LEB<0M;;4ALE8<0D64EFM78271E8BEM<0H1&4E]EM?"
U "8G4D;BEF2834EM5A><LEC74LEBC0DACE8M=BC4D03E>&5EYU1EB>EDF4E6D4CE0"
U "LE<>AJ4E3AM0<0CD82E4M5542&CSE2%2xhw%jjsE#VW21)>GIE#bEG1ADYE;.YE"
U "3](EA]EAD]E;IYE13%YG2k#twEB%JEbE%WEyt%EWUU%E2EE#iwf&.EG2U1E1<X%"
U "WUQW#YUEB%GEPE%xywI(MBJE%REVN%EPEG&'GEP(E%fw%uywILM1>G%IN2E%Eiw"
U "fA&EG2IWE1<%XWUQ%WYUE&BGEP%Exyw.IMBJ%NEPE(G'GE.PE%f%wuywIIM1>&G"
U "IN2.sj'y(EBJ2%jsi2I2s>C2824EMF70C1EF4LDA4E3M>8=6LE74AA4SE&J4E0A"
U "J4EBCM0AC8D=6ECD74EBM20;4LE5022C>AED0CE>D=4E720;5ED>5E3M450D);C"
U "EM#WNE1M420DDB4EC)74Ek%twSS#Ssj'IyE;>D>?EBMC0ACJBEF8DC7EBIJE0C%"
U "EWSE1y74EJBE3AD0FE2M><<0D=3EB24CBE2C74EMB20;J4E50M2C>A#SEs>MC82"
U "4LE0;BJ>EC7D0CEFJ4E<DDBCE2M>=C8M=D>D2B;HEM0=27D>AECD74E>M1942JC"
U "E70M=3;41E0CEJ0E?>28=CEDC>E:244?ED8CEBM20;8D=6E0M1>DCLEC74LE70="
U "23;4S1E&4ED3>EC278BED1HE<M>E8=J6EC7J4E>1M942CLE70=23;4E)C>EX%WU"
U "QW%YUEMM24=CD4AE>J5EB2MA44=INE40D27EC28<4EMC7A>2D67E2C74EM;>>?I"
U "SE&7M4=4ED4AEFJ4EF0D=CECJ>E?D/CE0EM=D<1D4AE82=C>E2C74EM3A0FLEBC"
U "A28=6Q1EF4EM<DBCLE2>=M20C4M=0C4LEC74LEBCA28=6EM5>A<)0CEM%xywIIN"
U "E>5LEC74LE=D<214AEMF8C7D8=ECD74EBMCA8=&6SEnM=BC4D03E>J5E2>M=20C"
U "M4=0C28=6E2C74E21>GILEF8CJ7EC7J4EA4DBCE>J5EC7J4EBCMA8=6IQE8C1E8"
U "BEM50BCD4AECJ>E>=D;HE?20BBE2C74EM033A24BBED>5ECD74EBMD1BCMA8=6L"
U "EF8CJ7EC7/4E%f%wuywIIE5DM=2C8)>=SE#22x>LEF70JCE85LEH>DLEF0=JCEC"
U ">LEB20D;4E0D=3EAM>C0CJ4EB>M<4C728=6ED0CECD74EB20<4EMC8<4#dEx8M<"
U "?;4IQE9DDBCEBD4CED/?E0E%ktwS%SSsjA'yE;2>>?EMF782J7E8=M2A402B4BE"
U "2C74EMB20;J4E50M2C>A1E0BEM145>)A4QE20=3EMF8C7D8=ECD74E;2>>?EM8="
U "2AM40B4LEC74LE0=6);4SE1gDCEM8=BC2403ED>5EBMD1CAM02C8D=6E0LE5022"
U "C>AE25>AE2C74EM0=6;J4EC>LE4A0DB4ECD74E?MA4E82>DBEM0=6;A4QE;24CB"
U "ED3>E8JCEC7D8BEF)0H_EM4A0BJ4EC7J4E?AM4E8>DDBE8M<064LEF8CJ7EC7J4"
U "E2DMAA4=JCE0=26;4QLE8=2MA40BJ4EC7J4E0=26;4QLEC74J=E3AD0FECD74E2"
U "MDAA4D=CE8M<064LEF8CJ7EC7J4E=4JFE2DMAA4=JCE0=26;4SIEy78JBEF0JHE"
U "851EF4EMF0=C1EC>EM270=D64ECD74E5M02C>JAE0CLEF78D27ECD74E0M=6;4L"
U "E8=2MA40B)4BQEDF4EF28;;EM>=;HLE70EJ4EC>LE2702=64E2>=4EM=D<1D4AE"
U "8M=BC4D03E>J5ECF&>E22%xhwj%jsEVIW21>&GIEbIEG1D.YE;Y(E3]EAA]ED.]"
U "E;Y1E13Y%G2kt.wEBJ%EbEW%EytE%WZU2%EEiw(f&EGA2UE1&<XWU%QWYU1EC0G"
U "%EPEx%ywIM&0JNE#PEGB%GEPE%xywI(MBJE%REVN%EPEG&'GEP(E%fw%uywILM1"
U ">G%IN2E(E0JE.bE0J%EPEV%2EEn.kE0J%EcbE%X[UE%ymjs(E0JE%bEV2%EEiw("
U "f&EGA2VE1&<XWU%QWYU1EC0G%EPEx%ywIM&0JNE#PEGB%GEPE%xywI(MBJN%EPE"
U "G&'GEP(E%fw%uywILM1>G%IN2s(j'yE&BJ2j%si221yAHED8CE>)DCFELiA0FLE"
U "BCAM8=6BLE20=LE64CLE5082A;HEM2><?2;4GQLE1DCLEH>D1L;;E264CEMDB43"
U "1EC>EMC74<LEF8CJ7E?AM02C8D24E0D=3EF274=E2H>DEM<4<>MA8I4LEC74LE3"
U "A0JFEBCMA8=6LE2><M<0=3&BSE2I2y74LEB2A244=EM2>>AM38=02C4BE25>AEM"
U "3855M4A4=JCEB2MA44=LE<>3D4BE2D0=E1J4E50M8A;HLE385M582DD;CECJ>EF"
U ">DA:EF28C7QLE0=3LEC74JHE3>LEC4=J3EC>1E14EMF48AJ3E=DM<14A&BSEyJ>"
U "E<0D:4EH2>DAEM2>34LEB8<M?;4A1EC>EMFA8CA4QEHD>DE2D0=E3M458=/4E0E"
U "M;>68220;EM?;0=J4E>ED4AECD74E?M7HB8220;EM?;0=&4SEfJ=E4GM0<?;J4E"
U ">5CE0E?M7HB8220;EM?;0=J4E8BLEC74%E[YU&GY]ULEA4BM>;DC28>=EM4BC0M"
U "1;8B2743ED1HEC)74Ex%hwjj%sEVWLEB2A244=EM<>34ISE(>JDE20J=E34M58="
U "4CE0E;M>682)0;QED>AE0M;C4AM=0C4LEDB4JAR34M58=4J3E?;20=4EMF8C7LE"
U "C74(E&ns.it&EMBC0CM4<4=&CSE2%2xhw%jjsE#VW2&%nsit&&EMU%QUNR%MVUU"
U "%QVUU%N2hn%whqj%EMZU%QZUN%QVUQ%Y2qn%sjEM%UQUN%RMZU%QZUN%QW2j%si"
U "22Ly78BLECA8ME80;LE4G0M<?;4LE345M8=4BCE0E;M>682D0;E?M;0=4LEF78D"
U "27E8&BEVU(UGVU%USEZ%UQZU1E8BE2=>FE2C74EM24=CD4AE>J5EC7J4EB2MA44"
U "=IQEB>LEC78JBE3A20FBEJ0EA4J3E28MA2;4LE5A>J<EC7J4E24M=C4ALEF8C/7"
U "E0EMA038DDBE>&5EVU#SEy7J4E;8D=4EBMC0C4M<4=CLE3A0DFBE0LE6A4D4=E;"
U "28=4EM5A><LEC74LE;>FD4AE;245CEM2>A=D4AECJ>EC7J4E24M=C4A1E>5E2C7"
U "4EMB2A4)4=SELs>C8D24EC270CEM3458M=8=6CE0E;M>682D0;E?M;0=4LEB4CJ"
U "BEC7J4E>AM868=%EMUQ#UNECJ>EC7J4E1>MCC><LE;45JCE>5LEC74LEB2A244="
U "QLE8=BMC4031E>5E2C74EM34502D;CEMD??4JAE;4)5CSECn5EHD>DEF20=CE2C"
U "74EM>A86D8=ECJ>E141E8=E2C74EMD??4JAE;4D5CEF28C7EJ0E;>M6820J;E?;"
U "20=4QLE033LEC74%Exhw%jjsEM:4HF2>A3EM05C4/AE&n#sit&#SEx>1EC>EM34"
U "58D=4ECD74E6MA0?7282BEM<>34%EVWEMB2A4D4=EAM4B>;MDC8>A=QECD74E22"
U ">34E)8B_E%22xh%wjjs%EVW2&&nsi(t&Ex%hwjj%sEMU%QUNR%M[YU%QY]U%N22"
U "zDB4EFM70C42E4AED8BE<2>A4EM2><5M>AC021;4QLE1DC#EnEFM>D;3LEA42M>"
U "<<4D=3EDMB8=6(E&ns.it&E%xhwj#jsE1M420DDB4ECM74A41E8BEM;4BBLE2>="
U "M5DB8D>=EF274=EM2>=EM4AC8D=6E52A><EM;>68220;EDC>E?M7HB8220;EM?;"
U "0=)4BSE#22k8M=0;;AHQE0LE;8C2C;4EM8=5>MA<0C28>=ED>=E2MA40C28=6E#"
U "iwf&LE455M42CBLEF8CJ7EC7J4E>C274AEIvg0BD82E6MA0?7282BEMA>DCM8=4"
U "B#SEm>D?4EHD>DE:2=>FEMB><4LECA8M6>=>M<4CAJHE5>JAEC7D8BE?20ACSIE"
U "w4220;;EMC70C1E8=E2C74EMD=8CLE28A22;4QLEF78D27E7D0BE0LEA0328DBE"
U ")>5EVIQEC7D0CECD74E2M>>A3M8=0CD4BE>/5E0EM?>8=JCE>=LEC74LE28A22;"
U "4EM68E4J=E0=LE0=6D;4E8JBE34M58=4J3E0B%EMEh#txM0M=6;4%NQEx#nsM0M"
U "=6;4%NENSIEkDAMC74AM<>A4IQE851EF4E20A4EM68E4/=E0EM?>8=JCE>=LEC7"
U "4LE28A22;4Q1EF4E220=EM58=3LEC74LE0=6D;4E1JHE3AM0F8=/6E0EME4ACM8"
U "20;LE;8=J4E?4MA?4=M382D2;0AEDC>ECD74EGLE0G8JBE5AD><ECD74E?M>8=C"
U "#SEn51EF4EMC0:4LEC74LE0A2MC0=624=CED>5ECD74EEM4AC8220;EM;4=6DC7"
U "E>J5EC7D8BE;28=4EM38E82343ED1HECD74E7M>A8IM>=C0J;E38MBC0=D24E>J"
U "5EC7D8BE;28=4EM5A><LEC74LE>A8268=Q1EF4EMF8;;LE64CLEC74LE0=6);4S"
U "ECx>ECD74E0M=6;41E8BEM34582=43E)0BEf#ysM((T'NSLE&8CJ7EC7D8BE:M="
U ">F;M4364IQE8CLEF>DD;3E1J4E?>MBB81D;4ECJ>E2AM40C4CE0EBM?8==28=6E"
U "M;8=4LEDB8D=6E>2=;HE2C74EM;8=4LE2><M<0=3#SEn51EF4EM2A40DC4E0LE;"
U ">>J?EF72827EM8=2AM4<4=DCBECD74E0M=6;4LE5A>&<EUE)C>EX#[UEC274=ED"
U "F4E2D0=EC20:4E)C>Eh%txQx#nsE>J5EC7J4E0=26;4EDC>E6D4CECD74E?M>8="
U "C1EF4EMB7>DD;3E32A0FE)C>SE1gDCEMC74A/4LBEM>=;HLE>=4LE<>AJ4E?AM>"
U "1;4&<SEy)74EvLg0B8J2E5DM=2C82>=BE%htxE20=3E%xnsEMC78=J:E8=LEA03"
U "M80=BIQEB>1EF4EM<DBCLE58ADBCE2M>=E4DACECD74E0M=6;41EC>EMA03820="
U "BED1HE<MD;C8M?;H8)=6Eu%nETE%V]USIEy70JCE8BLE#D8DC4E4M0B8;JHE3>)"
U "=4ESIEm4AJ4E8BLEC74LE2>3&4_E2%2xhw%jjsE%VW2h%tsxy%EunE%bEXS%VYV"
U "Z(2&ns.it&E%xhwj%jsEM%RVQV%NRMV%QRVN%2it2%EEqn%sjEM%UQUN%RMht.x"
U "M0J%EOEu%nETE%V]UN%Qxns(M0JE%OEun%ETEV%]UNN%QEU2.EE0J#EbE0%JEPE"
END SUB

SUB V6
U "%V2EE#nkE0%JEcb%EX[U%Eymj.sE0J%EbEV%2EEq%nsjE%MUQU%NRMh#txM0%JE"
U "OE%unET%EV]U%NQxn.sM0J%EOEu%nETE%V]UN%NQEV%Y2qt#tuE&%mnqj%Ensp("
U "j(IE%bEGG%2jsiI22&4LEBC0DACE1JHE8=M8C80M;8I8D=6ECD74E6MA0?7282B"
U "EM<>34IQEC7D4=E3M458=28=6E#unE0/BE0EM2>=BMC0=C#ERE0LEE0AM801;J4"
U "EF72827EMF8;;LE=4ED4AE2M70=6J4E8=LEC74LE?A>M6A0<LE4G4M2DC8)>=SE"
U "Ly74=LE34528=4E2C74EM;>68220;EM?;0=A4QE0D=3EBMC0ACLEC74LE;>>&?S"
U "EyD74E;28=4EMBC0ADCBE52A><E2C74EM24=CD4AE>J5EC7J4EB2MA44=LE0=3L"
U "E6>4JBEC>LEC74LE2>>MA38=20C4EMB?42M8584J3E1HLEC74%Ehtx%Qxns1E>5"
U "E2C74EM0=6;A4SE&J4E;>D>?EDM=C8;LEC74LEDB4JAE?AM4BB4/BE0E2:4HS%E"
U "22yM74A41E8BE2>=4EM<>A4LECH?J4E>5LE6A0M?782JBEC7)0CEvLg0B8J2E70"
U "/BE0EMBCA>D=6E?M>8=CLE5>A#E_EC24GCSIElA0M?782D0;E4M5542DCBE2D0="
U "E1J4E<0D34E#MD8C4LE40B28;HEMDB8=J6E>=D;HEC24GCE)8=EvLg0B8&2SEyM"
U "74A4LE0A4CE0E5D4FE5MD=2CM8>=BLEC70JCE0AJ4E#D28C4EMDB45DD;EF274="
U "EM340;28=6EMF8C7LEC4G&CSEyD74E5M8ABC1E8BE2C74E%hmwILE5D=M2C8>&="
U "SEnJ5EH>JDE?0DBBE0LE=D<214AEDC>EC)74Eh%mwIEM5D=2MC8>=IQE8CLEF8;"
U "J;EA4MCDA=LEC74%Efxh%nnEMLf<4AM820=LEBC0M=30AJ3E2>D34E5D>AE8M=5"
U ">AM<0C8D>=E8M=C4AM270=)64NEMC4GCLEE0;DD4E>J5EC7D0CE=MD<14&ASEyJ"
U ">E58D=3E0LE;8BMC8=61E>5E2C74E%fxhnInE27M0A022C4AEM2>34ABQE;2>>:"
U "ED8=ECD74E724;?EM2>=CM4=CBIQE0=J3EC724A4ED8BE0LE;8BMC8=6LEC74)A"
U "4SE1k>AEM4G0<2?;4Q1EC>EM?A8=/CE0EMB<8;D4HE52024ED>=ECD74EBM2A44"
U "A=QECD74E22>34ED8BEC278B_%E22h%qx2u%wnsy%Ehmw%IMVN%2jsi#22x82=2"
U "4E2C74E%fxhnInE27M0A022C4AEM2>34LE5>ACE0EBM<8;4JHE50D24E8&BEVQL"
U "EH>DLE20=LEDB4LEC74%EhmwIIE5DM=2C8D>=ECJ>E64JCEC7)8BSELf=>C274A"
U "EMDB45DD;E5MD=2C28>=E)8BEf%xhQEMF782J7EA4MCDA=JBEC7&4Efx%hnnEME"
U "0;DJ4E>5CE0EC24GCEME0;DJ4EH>JDE?0DBBECJ>E8C#SEx>%Efxh%MGfGINEF8"
U "D;;EAM4CDA&=E[ZLE142M0DB4LEC74%Efxh#nnEEM0;D41E>5EIfE8B%E[ZSIEj"
U "E4DAHE?MA8=CM01;4LE270MA02C)4AEM20=3EMC74=LEB><A4NE720E4E)0=Ef%"
U "xhnnLEE0;)D4QEDB>ECM74B4LECF>LE5D=M2C8>D=BE<20:4ED8CE#MD8C4LE40"
U "B&HSE2I2k8=M0;;HIQEC7&4Eqt%hfyjLEBC0MC4<4D=CE8JBE4GMCA4<24;HEMD"
U "B45DD;E5D>AE0D=HEC24GCEM10B4J3E?AM>6A0&<SEq%thfyIjEB4DCBECD74EC"
U "24GCE#huECJ>EC7J4E2>M>A38M=0C4JBEH>JDEB?M4285&HSEyD74E5M8ABCLE0"
U "A6MD<4=JCE8BLEC74LE2>;2D<=QLE0=3LEC74LEB422>=3ED8BECD74EA)>FSE("
U "x>E2%2hqx%2qth%fyjE%ZQVU%2uwn%syEh%mwIM%WV^N%2jsiI22&8D;;E?MA8="
U "CCE0EBM>;83LEF78DC4E1M;>2:1E0CEM2>;D)<=EZIQEA>&FEVU#SEf=J3EC7D0"
U "CLB1E8CE25>AEM6A0?M782BIFE(>JDE=>JFE:=D>FE=M40A;JHE4E24AHEM6A0?"
U "M782BLEA>DMC8=41E8=EIvg0B)82QE20=3EM70E4LEC74LE:=>MF;43D64ECJ>E"
U "<0D:4E0LE60<J4E>ALE78627;HEM6A0?M7820J;E?AM>6A0&<SElMA0?7282BEM"
U "34?4D=3E>J=E7>JFEH>JDE0AMA0=6J4EC7)4<QEDB>E8JCEA4M#D8AD4BE0J=E0"
U "AMC8BCD82EBM:8;;1EC>EMB><4LE3462A44S.En5E2H>DE264CEM2A40MC8E4LE"
U "F8CJ7EC724B4EM6A0?M782BLE2><M<0=3ABQEHD>DE2D0=E2MA40CJ4E=4M0A;H"
U "LE0=HLE455242CE2H>DEM=443%SE22%2xjh%ynts%EZER%Eijx%nlsn%slEf%uu"
U "qn%hfyn%tsx2CnCE8JBE=>JCE?AM02C8220;ED8=EA240;EMF>A;J3EC42A<BED"
U "C>EBD4CEDJ?E0=LE0??M;820MC8>=1E8=E2>=4EM;>=6LE;8BJCE>5LE2>3&4SE"
U "r20=HEM40A;JHE?AM>6A0M<<8=J6E;0M=6D0264BEMF4A4LE?DA24;HEM;8=4)0"
U "AQEM<40=28=6EMC70CLEC74JHEBCM0AC4J3E5AD><E>D=4E?M>8=C1E>=EJ0E;8"
U "DBCE>J5E2>)34QE20=3EM4=34J3E0CLE0=>MC74ALE?>8)=CSE1f;;ED>5ECD74"
U "E22>34EInE70DE4EFMA8CCD4=E8J=EC7D8BECMDC>A280;EDB>E5D0AE7D0BE12"
U "44=EM?DA4D;HE;M8=40&ASEmM>F4E)4AQEM;8=4D0AE?MA>6AM0<<8D=6E8JBE="
U ">JCE?AM02C8220;ED8=E0LEC40J<E4=ME8A>M=<4=&CSEnJ5E>=J4E?4MAB>=LE"
U "2>DD;3EFMA8C4LE>=4LE0B?242CED>5E22>34QLE0=3LE0=>MC74ALEFA8DC4E0"
U "M=>C7D4AE?20ACED>5ECD74E?MA>6A)0<QEMC78=D6BEFM>D;31E14EM<D27LE<"
U ">AJ4E>AM60=82I43S#Evg02B82EM2>=CM08=BLEC74LE20?M018;28CHEDC>E<2"
U "44CEMC74BJ4E=4243BQLE20;2;43EM<>3D2;0AEM?A>6MA0<<28=6SLE(>DLE20"
U "=LE1A4D0:E0LE?A>M6A0<LE8=CJ>E38M554A24=CELG<>3MD;4BIGEF72827E20"
U "A4EMB4?0MA0C4LE5A>J<EC7J4E<0D8=E?MA>6AD0<E0D=3EHD4CE2D0=E1J4E02"
U "M24BBD43E1JHE0=JHE?0DACE>J5E8C%SEnEM7867D;HEAM42><M<4=3LEC74LED"
U "B41E>5EMB4?0MA0C4LE<>3MD;4B1E8=EM?A>6MA0<<28=6EM0??;M820CM8>=BI"
U "QE0;MC7>DD67E8JCE8BLE=>CCE0EBM8<?;J4EC0DB:ECJ>E;420A=S%E22yM74B"
U "4LEB4?M0A0CJ4E<>M3D;4JBE0AJ4E0;DB>E:M=>F=1E0BEM?A>2M43DAD4BE8J="
U "EC7&4EvgM0B82LE4=EM8A>=M<4=C#SEy724A4E20A4E2CF>EMCH?4JBE>5LE?A>"
U "M243D2A4B_LEBD1JBE0=J3E5DM=2C82>=BSIExD1JBE<4MA4;HLE4G4M2DC4CE0"
U "EC20B:E20=3EMA4CDDA=ECJ>EC7J4E<0D8=E?MA>6A)0<QEMF782J7E5DM=2C82"
U ">=BEM4G422DC4EJ0EC0DB:E0D=3EAM4CDA/=E0EME0;DJ4EC>LEC74LE<08J=E?"
U "AM>6A0&<SEfJ=E4GM0<?;J4E>5CE0EBDD1E<M867C1E14EJ0E?AM>2432DA4EMF"
U "782J7E38MB?;0DHBE0LEC8CD;4EBM2A44J=E>=LEC74LEB2A244=QLEF78D;4E0"
U "LE5D=M2C8>J=E<0JHE14CE0E?MA>24M3DA4LEC70JCEA4MCDA=/BE0EM346AD44"
U "E8J=E34M6A44JBE682E4=EJ0E=DM<14A1E8=EMA03820=BSIEkD=M2C8>J=E?AM"
U ">243MDA4BLE0A4LE0;BJ>EDBD43E8A=Eh0M;2D;)DBQEDB>EH)>DEhM0;2D2;DB"
U "EM?4>?D;4EBM7>D;J3E0;MA403JHE14LE50<M8;80JAEF8DC7E5MD=2CM8>=B%S"
U "E22LuA>2M43DAD4BE2D0=E0M224?JCE0AM6D<42=CBED8=EF270CED8BE2M0;;4"
U "J3E0=LE0A6MD<4=JCE;8)BCSELj027LE0A6MD<4=JCE8=LEC74LE0A6MD<4=JCE"
U ";8DBCE7D0BE0LE345M8=43LECH?A4QE0D=3E0J=E>1M942C1E>5EMC70CLECH?J"
U "4E<DDBCE1J4E?0MBB431EC>E2C74EM?A>2M43DAJ4EF7D4=E8JCE8BLE20;2;43"
U "SIEk>ALE4G0M<?;4IQEC7&4Ehm%wIEvLg0B8J2E5DM=2C8D>=E0M224?DCBE0LE"
U "=D<M4A82LE0A6MD<4=&CSEyD74E5MD=2C28>=EM8CB4D;5E2M>=E42ACBEMC78B"
U "LE=D<M4A82LE0A6MD<4=JCE8=DC>E0LEBCA28=6EMA4?AM4B4=MC0C8D>=E>J5E"
U "C7&4Efx%hnnEME0;DJ4E>5LEC74LE=D<214AEM?0BB)43QE20=3EMA4CD2A=BEM"
U "C78BLE>=4LE270MA02CD4AEBMCA8=&6SE2I2uA>M243D2A4BE)8=EvLg0B8J2E0"
U "AJ4E682E4=EMC748JAE>FJ=EB2MA44=ISE&7D4=EHD>DE4M=C4ALEC74#Evg02B"
U "82E%nijQLEH>DLE0A41E8=E2C74EM<08=LE?A>M243DDA4EFM7827LE20=LE022"
U "24BBE20;;E2C74EM>C74)ABSELtC74JAE?AM>243MDA4BLE0A4LE2A4M0C431E1"
U "HEMCH?8D=6ECD74EC2H?4ED>5E?MA>24M3DA4%EMxzIgE>A%Ekzs%hynt%sNQE2"
U "C74EM?A>2M43DAJ4E=0)<4QEM5>;;M>F431E1HE2C74EM2><?M;4C4LE0A6MD<4"
U "=JCE;8)BCSE2(>DE220=EME84FLEH>DJAE?AM>243MDA4BLEC7AM>D67LEC74(E"
U "%njJ&E<4)=DSELm4A41E8BED0=E4MG0<?D;4E>/5E0E2BD1EM?A>2M43DAJ4EF7"
U "2827EM?4A5M>A<BLEB><J4E>?M4A0CM8>=BLE5>ACE0E?MA>6AD0<EC270CEMF8"
U ";;1E14EMDB8=J6E6AM0?78)2BQEMA0=3D><E=MD<14)ABQE20=3EJ0E;>M6820J"
U ";E?;20=4S%EE22%xzgEM8=8CLuA>62A0<M%N2EE%wfsi#trn)%jEyn%rjw2%EEx"
U "h%wjjs%EVW2.EE&n#sit&%EMUQ%UNRM%VUUQ%VUUN%2EEh%tqtw%EVZ2%jsiE%x"
U "zg2I2y74LE>=;JHEC728=6E2H>DEM=4431EC>EMCH?41E8BE%xzgEM8=8CLuA>6"
U "2A0<E%MNQE20=3E2C74EMB2A4D4=EF28;;ED14EBMF8C22743EDC>EC270CEM?A"
U ">2M43DA&4SEy)74Ej%siEx#zgE8JBE?;M0243LEC74DA4E5D>AEH)>DQEDB>ECD"
U "74E>2=;HEMC78=J6EH>JDE=4D43ECJ>ECHD?4EC274=ED8BECD74E22>34EMF8C"
U "7D8=ECD74EB)D1SE1yAHEMCH?8D=6EC278BE2>DCED>=EH2>DAE2>F=EDC>EBD4"
U "4E7D>FEC278BEMF>A:&BSEy278BEM?A>2M43DAJ4E8BLE20;2;43ED1HEBM8<?;"
U "JHECHM?8=6LE8=8JCuA>M6A0<1E8=E2C74EM<08=LE?A>M243D)A4SECf=E0M;C"
U "4AM=0C8DE4E<M4C7>J3E8B%EhfqIqE8=D8CuAM>2432DA4E%MNSELw867JCE74D"
U "A4ECD74E?M0A4=MC74BD4BE0DA4E>M?C8>2=0;QLE1DC1E85E2H>DEMF4A41EC>"
U "EM?0BBLE0A6MD<4=DCBECJ>EC7J4E?AM>2432DA4QLE?0AM4=C7M4B4BLEF>DD;"
U "3E1J4EA4M#D8AD43EF28C7E2C74E%hfqqLEBC0MC4<4)=CSE1s>FEM;4CBLECAH"
U "LE?0BMB8=61E0=EM0A6DM<4=C1EC>EJ0E?AM>2432DA4S1E&4EMF8;;LE?0BJBE"
U "CFJ>E0AM6D<42=CBEDC>E0LE?A>M243DDA4E2M0;;4J3E24M=C4ALEF78D27E0D"
U "A4E0LEBCA28=6EM2>=CM08=8D=6ECD74EC24GCEDC>E1J4E24M=C4A)43QE20=3"
U "E2C74EM7>A8MI>=CD0;E;M>20C28>=ED>=ECD74EBM2A44J=E0CLEF78D27EHD>"
U "DEF28B7EDC>E2M4=C4JAE8C%SE22%xzgEM24=C)4AMEMC4GC#IQE71q>2J%EN2E"
U "%Eqth%fyjEJ7q>2%JQEY%VERE%MqjsLMC4G&CINE%TEWN%2EEu%wnsyLEC4G&CI"
U "2j%siEx%zg221y74EM58ABJCE;8D=4E0M5C4ALEC74LEBD1LE342M;0A0MC8>=L"
U "E?>BM8C8>D=BECD74EBMC0AC28=6EM?>8=JCE>5LEC74LEC4GJCE0CLEC74LE7>"
U "AM8I>=2C0;EM;>20MC8>=1EF4EM?0BBD43E0JCEC7J4EB4M2>=3LE0A6MD<4=JC"
U "E0=J3EE4MAC82D0;E2M>>A3M8=0C&4SEyD74EEM4AC8220;EM2>>AM38=0DC4E8"
U "JBE20M;2D;M0C431E1HEMBD1CMA02C28=6E2>=4EM70;5LEC74LEB2A244=LJBE"
U "F823C7ED8=E2M70A0M2C4A&BEMY#VNE0D=3E720;5E2C74E#qjs6DC7E>J5EC7J"
U "4EC4DGCEFJ4E?0MBB431E0BE2C74EM58ABJCE0AM6D<4)=CSED&4EFM>D;3LE20"
U ";J;E24M=C4ALE5A>J<EC7J4E<0D8=E?MA>24M3DA4LE;8:J4EC7)8B_E#E222M4"
U "=C4&AEGuMA>6AM0<<4J3E1H1E#?\Le?>1D>GS2)><GQ%EVW2.2tAEM;8:4LEC78"
U "&BE22%hfqqLE24=2C4AE#MGuAM>6A0M<<431E1HE)#?\eM?>1>JGS2>&<GQE%VW"
U "N2.2nCLJBE#D28C4EMB8<?D;4E0M2CD02;;HSIEkD=M2C8>D=BE0DA4EBM;8672"
U "C;HEM3855M4A4=JCE0=J3E8=ME>;EJ4E0=LE033M8C8>2=0;EM?0ACLEF78D27E"
U "B2D1BED3>E=)>C_EJ0EA4MCDA=LEE0;)D4SE1y74EMA4CDDA=EEM0;D41E8BEMB"
U "?42M8584J3E1HLE0BBM86=8D=6ECD74EEM0;D4LEH>DLEF0=JCEC>LEA4C2DA=E"
U "DC>ECD74E5MD=2C28>=EM=0<4LE5A>J<EF8MC78=LEC74LE5D=M2C8>J=E34M58"
U "=8MC8>=ISE&7D4=E2M0;;8D=6ECD74E5MD=2C28>=EM5A><LEF8C278=E2C74EM"
U "<08=LE?A>M243D)A4QE2C74EM=0<41E>5E2C74EM5D=2MC8>=1E8BEMCA402C43"
U "ED0BE0LEE0;DD4EFM78271E8BEM4E0;MD0C4J3E0CLE2><M?8;4LRC8<&4SEm24"
U "A4ED8BE0J=E4GM0<?;J4E>5CE0E5MD=2C28>=EM3458M=8C8)>=_E%22kz%shyn"
U "#tsE2M>=E4)ACSyA>Sw0M380=ABEM3M46A4&4FN2%EEqj%yEun%EbEX%SVYV%Z2"
U "EEM2>=E24ACS(y>SwM0380)=BEbLE3462A44F%EOEu%nETE%V]U2%jsiE%xzg2I"
U "2y74LE5D=M2C8>J=E8BLE8<?M;8282C;HEM20;;D43E8J=EC7D8BE?MA>6A)0<E"
U "2%2hqx%2nsu%zyEGLj=C4/AE0EME0;DJ4E8=LE346MA44B%_EGQLE346MA44%M0"
U ";D4IF2A0M380=M%0;D&4FEbLE2>=ME4AC.Sy>SLw03820=BMM346AM44%02;D4F"
U "%N2uw%nsyEIGy74LEA03280=EM4#D8ME0;4D=CE8&BG$EMA038M0=%02;D4F#$E"
U "GAM0380)=BG2%jsi212&4EMCA40JCEC7J4EE02;D4EMA4CDMA=43LE5A>J<EC7J"
U "4E5DM=2C8D>=E0/BE0EME0;DJ4EF4LE20=LE8<<M4380MC4;HLE0BB286=EDC>E"
U "0M=>C7D4AEEM0;D4#SEy7J4EE0MA801D;4EAM0380M=%0;)D4FED8BE6M8E4=LE"
U "C74LEE0;DD4EAM4CDA2=43EM5A><LE2>=ME4AC.Sy>SLw03820=BSIEy74DB4E2"
U "M>=242?CBE20A4EMBD??M>AC4J3E8=LE0;;LE?A>M6A0<M<8=6LE;0=M6D06)4B"
U "QEDB>EC278BEM8=5>MA<0C28>=EMF8;;1E14EM14=4M5828D0;ECJ>EH>JDE8=L"
U "EC74LE5DC2DA4S%E22yM74A41E8BE2>=4EM58=0J;E2>M=24?JCEF72827E270B"
U "EM?A>ED4=ECJ>E14LEE4AJHEBDM224BMB5D;1E8=EM?A>6MA0<<28=6_CE0E<M4"
U "BB0D64E;2>>?SLE&8C&7EvgM0B82IQEH>JDE20J=E2>M=BCA2D2CEJ0E;>D>?EF"
U "M7827LEAD=JBE5>JAEC7J4E;4M=6C71E>5E2C74EM?A>62A0<QLEA42M48E4JBE"
U "8=2?DCEM5A><LEC74LEDB4AAQE0D=3E4MG42D2C4BEJ0E<4MBB06J4E102B43ED"
U ">=EF270CE2C74EMDB4ALE3>4ABSE&J4EF8D;;E2M>=BCMAD2CCE0E1M0B82LE0?"
U "?M;820MC8>=LEF78D27EAM42482E4BEM8=?DJCE5AD><ECD74ED2B4AED8=ECD7"
U "4E52>A<ED>5E0J=E0A2A>FE2:4HQLE0=3LE<>ED4BE0LE1>G1E>=E2C74EMB2A4"
U "D4=E1M0B431E>=E2C74EM38A4M2C8>J=EC7J4EDBD4AE?MA4BB)43SE1y74EM0A"
U "A>JFE:4DHBE0DA4E3M8554MA4=CLE5A>J<E=>MA<0;LE8=?MDCC4J3E:4DHBEAM"
U "42482E43EMF8C7%Ensp(j(IS.Et=E2C74EM4=70M=243%EVUVLE:4HM1>0AD3BE"
U "FM7827LE70EJ4E0A2A>FEM:4HB%QEns.pj(ILEA4CMDA=BLECF>LEE0;2D4B_LE"
U "C74%Efxh#nnEC24GCEM4?A4MB4=CM0C8>J=E>5LEC74LE:4HLE?A4MBB43IQE0="
U "J3EC7J4E:4MH1>0DA3EB220=EM2>341E>5E2C74E2:4HEM?A4B2B43SIEx8=D24"
U "ECD74E0MAA>FLE:4HJBE3>LE=>CLE70EJ4E0=%Efxh#nnEC24GCEMA4?AM4B4=M"
U "C0C8)>=QEDF4E<2DBCE2DB4E2C74EM:4H1M>0A3LEB20J=E2>234BE25>AEMC74"
U "<#SEy7J4E:4MH1>0DA3EB220=EM2>34JBE20J=E14LEE842F43ED8=EC)74Em%j"
U "quE&KEht%syjs#yxEBM42C8D>=E>J5EC7&4EvgM0B82LE<4=)DBSE1k>AEMC78B"
U "LE?A>M6A0<IQEF4LEF8;J;E70DE4ECDF>E?MA>24M3DA4JBE8=LE033M8C8>J=E"
U "C>LEC74LE<08J=E?AM>2432DA4SIEy74LE58ADBCEF28;;EM8=8CM80;8DI4ECD"
U "74E?MA>6AD0<EBM4CC82=6BE20=3EM?>B8MC8>=LEC74LE270MA02CD4AE8J=E7"
U "8JBEBCM0AC8D=6E?M>B8C28>=SIEy74LE>C7D4AEF28;;EM<>E4LEC74LE6DH1E"
U "8=E2C74EM38A4M2C8>J=EF72827EDF4E?20BBEDC>ECD74E5MD=2C28>=SIEy74"
U "LE<08J=E?AM>2432DA4EMF8;;LE20;J;EC7J4EBDJ1E?AM>243MDA4BLE0=3LE2"
U ">=MC08=JBEC7J4E<0D8=E<M4BB0D64E;2>>?EMF782J7EA4MCA842E4BEM8=?DJ"
U "CE5AD><ECD74ED2B4ASIEk8ADBCE>J5E0;A;QE724A4ED8BECD74E22>34E25>A"
U "E2C74EM<08=LE?A>M243D)A4_E%22ht%sxyE%zuEb%EV2h%tsxy#Eit&%sEbE%W"
U "2ht%sxyE%qjky%EbEX%2hts%xyEw%nlmy%EbEY#22y(#ujE>M1942JCyH?&42EE"
U "&GEfx%Ensy%jljw#2EEH%EfxE%nsyj%ljw2%jsiE(y(uj%2inrLE>19242CE#fx"
U "E>M1942JCyH?J428=D8Cx2MA44=L2>19242CS&GEbE#YV2>M1942/CSHE%bEWY%"
U "22it%2EEx%jqjh%yEhf%xjEn#spj(%I2EE%EEhf%xjEh%mwIM%UNEP%Ehmw%IM\"
U "W#N_E<2>E4E%zuQEM>194)2C2E%EEEh%fxjE%hmwI%MUNE%PEhm%wIM]%UN_EM<"
U ">E4#Eit&#sQE>M1942&C2EE%EEhf%xjEh%mwIM%UNEP%Ehmw%IM\Z#N_E<2>E4E"
U "%qjkyIQE>1M942C%2EEE%Ehfx%jEhm%wIMU%NEPE%hmwI%M\\NI_E<>)E4Ew%nl"
U "myIQE>1M942C%2EEE%Ehfx%jEhm%wIMX%WN_E(j'ny%Eit2%EEjs%iExj%qjhy%"
U "2qtt%uE2q%thfy%jEVQ%V_Eu%wnsy#EGy720=:E2H>DE25>AEM?;0H28=6G%2js"
U "i#22y7D8BE22>34ED8BE5M08A;JHEB4D;5E4MG?;0M=0C>DAHEF28C7E2C74EM4"
U "G24M?C8>J=E>5LEC74%Exjq%jhyE%hfxj%SSSE%jsiE%xjqj#hyEBMCAD2MCDA4"
U "LEF78)27EnLE70EJ4E=>JCEH4JCE4GM?;082=43SIEy78JBECHD?4E>J5E2>M=3"
U "8CM8>=0J;EC4MBC8=J6E5>MA<0CLEC4BDCBE0LE2>=M38C8)>=QE20=3EMB4E42"
U "A0;EM20B4JBE5>JAEC7D0CE2M>=38MC8>=LE0A4LEC74J=EC4MBC43#SEn=LEC7"
U "8JBE20)B4QEDF4E0DA4EBM448=&6Enk%Ensp(j(IE%bEhm%wIMU%NEPE%hmwI%M"
U "\WN%QEnk%Ensp(j(IE%bEhm%wIMU%NEPE%hmwI%M]UNIQE0=J3EB>1E>=SIEy78"
U "JBE8BLE9DB/CE0EM<>A4LE;46M81;4LE5>A2<0CEMC70=%EnkS%SSym%jsSS%Sj"
U "qx%jSEs2>C4EMC70C1E8=E2C74ELvD82J:g0BD82E2M><?82;4AQ(E0Eh%fxjE%"
U "jqxjLEBC0MC4<4D=CE8JBEA4M#D8AD43E8J=EC7J4EBCMAD2C2DA4E25>AEMF70"
U "CLEA402B>=EInE70DE4E=J>E83)40SE1y74EM01>EJ4E2>D34E8JBEC7J4E3AM8"
U "E4ALE5>ALEC74LEA4BJCE>5LEC74LE?A>M6A0<#SEk82ABCEMB><4%EhtsIxy0="
U "DCBE0DA423M42;02A43EMF782J7EA4M<08=LE2>=MBC0=JCE5>JAEC7J4E3DMA0"
U "C8D>=E>J5EC7J4E?AM>6A0J<E0=J3E8=LE0=HLE<>32D;4S#EfED2B4AEM34582"
U "=43EMCH?41E8BEM342;M0A431EC>EMBC>AJ4EC7J4E2>M>A38M=0C4JBE>5LEC7"
U "4LE270MA02C)4ASELy74=1E0=EM4=3;24BBEM;>>?1E8BEM4G42MDC43IQE20M;"
U ";8=J6EC7J4E0?M?A>?MA80CJ4E?AM>2432DA4E25>AE2C74EM0AA>JFE:4JHE?A"
U "M4BB4J3ED=2C8;E2C74EMDB4ALE?A4MBB4BLEC74LEB?0D24E1)0AEM%hmwI%MX"
U "WN%NSEm24A4ED8BECD74E22>34E25>AE2C74EM8=8CLx2A4D4=E?MA>24M3DA4%"
U "_E22%xzgEM8=8CLx2A4)4=EM%NE2E%Exhw%jjsE%VW2E%Ehtq%twE^#2EE&%niy"
U "m%E]UQ%ZU2E%Eqth%fyjE%WYQY%V2EE%uwns%yEhm%wIMV%N2js%iExz%g22yD7"
U "4E&%niym%E]UQ#ZUEBMC0C4M<4=CLEB4CJBEC7J4EB2MA44=LEC4GJCEA4MB>;D"
U "MC8>=1EC>E#]UE2M>;D<D=BE0)=3EZIUEA>)FBSED&4EC274=EM?A8=/CE0EMB<"
U "8;D4HE52024ED8=ECD74E<M833;J4E>5LEC74LEB2A244=ED8=E0LE=82J4E1AM"
U "867CLE1;DJ4E2>2;>ASIEs4GJCEF4LE=44J3EC>LEFA8DC4ECD74E<2>E4EM?A>"
U "2M43DAA4QE0D=3EC274=EDF4EF28;;ED14E32>=4EMF8C7LEC74LE?A>M6A0<%S"
U "E22%xzgEM<>E4IEMF0&HEfx%Ensy%jljwIQE>1M942C%EfxEM>194D2CyH)?4N2"
END SUB

SUB V7
U "%EEqt%hfyjLE>19242CSAHQE>M1942/CSG2%EEuw%nsyE%hmwI%MUNE%EEEE%EE"
U "LEM4A0BJ4E?AM4E8>DDBE8M<064%E2EE%xjqj%hyEh%fxjE2F0H2%EEEE%hfxj%"
U "Ezu_%EnkEM>194D2CSH%EcEV%EymjIsE>1M942C(SHEbLE>19242CS&HERE%V2E"
U "E%EEhf%xjEi(t&s_%EnkEM>194D2CSH%EaEY%^Eym#jsE>M1942/CSHEIbE>1M9"
U "42C(SHEP%EVEE%2EEE%Ehfx%jEqj%ky_E#nkE>M1942/CSGE%cEVE%ymjsLE>19"
U "242CS&GEbEM>194D2CSG%EREV%2EEE%Ehfx%jEwn%lmy_%EnkEM>194D2CSG%Ea"
U "E\%^Eym#jsE>M1942/CSGEIbE>1M942C(SGEP%EV2E%Ejsi%Exjq%jhy2%EEqt%"
U "hfyjLE>19242CSAHQE>M1942/CSG2%EEuw%nsyE%hmwI%MVNE%EEEE%EELEM3A0"
U "FLE2DAMA4=CLE8<0)642j%siEx%zg221f=3EMC70CCLBECD74EFM7>;4LE?A>M6"
U "A0<%SSSEM2>=5MDB8=J6E0B1E8CE2<0HE)14FELn340JBEB7M>D;31E14EM6>8="
U "J6EC7MA>D6J7EH>DDAE72403EM01>DJCEF7D0CEHD>DE2M>D;31E3>EMF8C7LEC"
U "78JBE8=M5>A<M0C8>&=SEjM=C8AJ4E602<4BE220=ED14E2MA40CD43EF28C7EM"
U "C78BLEB8<2?;4EM2>=BMCAD2&CSE2I2y74DA4E0DA4E<2>A4EMC78=D6BECJ>E2"
U ">M=B83)4AQE21DCEMC74HLE0A4LE14H2>=3E2C74EMB2>?J4E>5LEC78JBECDMC"
U ">A8)0;SECn5EHD>DEF24A4EDC>E3M4B86J=E0=LE0??M;820MC8>=1E8=EIvg0B"
U ")82QE2H>DEMF>D;J3E>=D;HE=2443E2C74EM8=5>MA<0C28>=EM5A><LEC78JBE"
U "B4M2C8>J=E0=J3E>=J4E74D2:E>J5E0=LE8<0M68=0MC8>=#SEuAM>6A0M<<8=J"
U "6EC02:4BEM:=>FM;436J4E>5LEC74LE;0=M6D06J4E0=/3E0EM2A40MC8E4LE<8"
U "=&3SSSLE?A>M6A0<JBE0AJ4E<0D34E1JHE?AM>6A0M<<4AJBEF8DC7E12>C7S.E"
U "n5E2H>DE220=EM34E42;>?EJ0E2AM40C8DE4E<28=3QLEC74J=EH>JDE20J=E34"
U "ME4;>J?E0=JHE?AM>6A0J<E2>M=248ME01;&4SE2%22xj%hynt%sE[E%REgj&(t"
U "si%Evgf%xnh2Cn5EHD>DLEJ4EA4D03EC278BEMCDC>MA80;LE0=3LED=3M4ABC2"
U ">>3E2C74EM8=5>MA<0C28>=EMF8C7)8=QE2H>DE220=EM7>=4MBC;HLE20;J;EH"
U ">MDAB4D;5E0#Evg02B82EM?A>6MA0<<)4ASELy70CLE<86D7CE=D>CEBM>D=3LE"
U "E4AJHE?AM4BC8M68>DABQE0D=3EHD>DE?MA>1021;HE2F>=LJCE64/CE0E29>1E"
U "D8=ECD74EA240;EMF>A;J3E1HLEB0H28=6EMC70CIQE1DJCE07LEF4;&;SEvLg0"
U "B8J2E8BCE0E5DD=E0D=3EFM834BM?A40J3E;0M=6D0)64SE1gDCE2H>DEM<867J"
U "CE14LEF>=M34A8)=6QEMF70C1E3>EInE3>LE=>F#dErHLEBD6M64BC28>=ED8BE"
U "CJ>E2>M=C8=DD4ECJ>E;420A=EM0=>C274AEM;0=6MD064%SEnEMF>D;J3EA4M2"
U "><<24=3ELu0B2D0;E8J5EH>JDE0AJ4EB4MA8>DJBE012>DCEM?A>6MA0<<28=6E"
U "M14202DB4EMC74AJ4E0AJ4E5DM=30<M4=C0J;E2>M=24?DCBEC270CE2H>DEMBC"
U "8;J;E=4D43ECJ>E;420A=SIEy74DA4E8JBE0;DB>E8M=5>AM<0C8D>=EFM7827#"
U "EnE720E4EM34;8M14A0MC4;HLE;45JCE>DJCE>5LEC78JBECDMC>A8D0;EF28C7"
U "E2C74EM7>?4LEC70&CEnE220=EMC402J7EH>/DE0EMBCH;J4E>5LE?A>M6A0<M<"
U "8=6LEF78D27E8JBE14M2><8D=6E8M=2A4M0B8=26;HEM?>?D2;0AS%E22g%fxnh"
U "1E8BED0=E4MGCA4M<4;HLE?>?MD;0ALE;0=M6D06J4EF8DC7ECM7>DBM0=3B1E>"
U "5EM3855M4A4=JCEE4MAB8>D=BEFM>A;3LRF83A4QEBJ>E8C1E8BEM<0=3M0C>AJ"
U "HEC7D0CEHD>DE;M40A=1E8CSIEgDC1E85E2H>DEMF8;;LE2>=MC8=DJ4E8=LE?A"
U ">M6A0<M<8=6IQE:=M>F8=/6E0E1r83RM;4E4&;EitIxE;0M=6D0D64EF28;;E2="
U ">CEMBD552824ED8=ECD74EA240;EMF>A;&3SEnLEBD6M64BCLE;40MA=8=J6EB>"
U ")<4EuM0B20J;E=4)GCQE20=3EMC74=LE<>E28=6ED>=ECJ>EC7J4EF>2A;3ED>5"
U "E&M8=3>)FBSEM&74=#EnEB)0HEGM;40A&=GEn1E3>E2=>CEM<40=LE<4<M>A8IJ"
U "4E4E24AHEM2><<20=3ED8=ECD74E;M0=6D2064Q#EnE<240=ELG64CLE50<M8;8"
U "0JAEF8DC7ECD74E2M>=242?CBSIGE(>JDE<0JHE=>JCE;420A=E27>FEDC>E3J>"
U "E0=MHC78D=6E1M4H>=J3EF7D0CEHD>DE2D0=E3J>E8=#Evg02B82QLE1DCLEC70"
U "/CLBEM58=4%SE22Cx>ECM70=:JBE5>JAEA4M038=J6E<HLECDCM>A80&;SEwM4<"
U "4<214AEDC>E2M742:LE102J:E?4MA8>3M820;);HSEInE<0JHE70DE4E<M8BB4J"
U "3EB>M<4C728=6QLE0=3#EnL;J;E34M58=8MC4;H1E14EM2>AAM42C8D=6ECD74E"
U "7MD=3A243BED>5EBM?4;;28=6EM4AA>)ABFE1f=3EM544;LE5A4J4EC>LE4<0D8"
U ";E<J4E0C1E#?\Le?>1D>GS2D><E8J5EH>JDE70DE4E0D=HE#MD4BCM8>=B1E>AE"
U "M2><<M4=CB1E>=EM0=HCM78=6LE?A4MB4=CD43E724A4S#EnL;J;E14LE?A>2<?"
U "CED8=E0M=BF4MA8=6LE0=HLE#D4MBC8>D=BEHD>DE<M867CLE70E&4SEyM70=:J"
U "BE06208=S%E22y%mjEj%si2%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&P%%%&Q%%%&R%%%&S%%%"
U "&T%%%&U%%%&V%%%&W%%%&X%%%&Y%%%&Z%%%&[%%%&\%%%&]%%%&^%%%&_%%%&$%"
U "%%&a%%%&b%%%&c%%%&d%%%&e%%%&f%%%&g%%%&h%%%&i%%%&j%%%&k%%%&l%%%&"
U "m%%%&n%%%&o%%%&p%%%&q%%%&r%%%&s%%%&t%%%&u%%%&v%%%&w%%%&x%%%&y%%"
U "%&z%%%'%%%%'&%%%''%%%'(%%%')%%%'*%%%'+%%%',%%%'-%%%'.%%%'/%%%'0"
U "%%%'1%%%'2%%%uwxxxuwxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx"
U "uxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxx"
U "xxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxu"
U "xxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxx"
U "xuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxux"
U "xxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxxuxxxx%9(%%%?(%%"
U "%#(%%%b(%%%c(%%&'*%%&(*%%&)*%%&**%%&;*%%&<*%%&J*%%&K*%%&V*%%&W*"
U "%%&v*%%&w*%%'B*%%'C*%%'M*%%'N*%%'g*%%'h*%%'w*%%'x*%%%%+%%%&+%%%"
U "2+%%%3+%%'d-%%'e-%%'f-%%'5/%%'6/%%'7/%%&z0%%'%0%%'&0%%''0%%usnk"
U "hud$\XuSOKGuC?;7u3/+'MyuqmMie$[MWSOKMGC?;)73%%%%%%%(+,*%&25%%(+"
U ",*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%"
U "&25%%(+,*%&25%%(+,*%&25%%#-z&,.*%25%%%-z(&,*%&25%%(+,*%&25%%(+,"
U "*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&"
U "25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%"
U "%(+,*%&25%%(+,*%&25%%(+,*%&25%%#-z&,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25%%%*z(&,*%#*z&,%*%-z(&,*%&2M%%#-z&,.*%2M%%%%K"
U "''0%%'<0%%'=0%%'/2%%'02%%'12%%'l2%%'m2%%'n2%%%B3%%%C3%%%S3%%%T3"
U "%%%h3%%%i3%%&)3%%&*3%%&B3%%&C3%%&D3%%&L4%%&M4%%&N4%%&A5%%&B5%%&"
U "C5%%&X5%%&Y5%%&Z5%%%I6%%%J6%%%K6%%'26%%'36%%'46%%'D6%%'E6%%'V6%"
U "%'W6%%usnjfub^ZVuRNJFuB>:6u2.*&MxtplMhd$\MXTPLMHD#<)84%%%%%%%#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%-z(&,*%&25%%#-z&,"
U ".*%25%%%%K'W6%%'e6%%'f6%%'v6%%'w6%%%37%%%47%%%57%%&n7%%&o7%%&p7"
U "%%'k9%%'l9%%'m9%%'n9%%%C:%%%D:%%'%<%%'&<%%''<%%'*<%%'+<%%'V<%%'"
U "W<%%'Z<%%'[<%%'\<%%%p>%%%q>%%%r>%%%u>%%%v>%%&'>%%&(>%%&0>%%&1>%"
U "%&n>%%&o>%%&r>%%utplhud$\XuTPLHuD#;6u2.*&MxtplMhd$\MXTPLMHD#<)8"
U "4%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%-z(&,*%&25%%#-z&,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25%%%%K&r>%%&s>%%&t>%%%JA%%%KA%%%LA%%%OA%%%PA%%%vA"
U "%%%wA%%&#A%%&AA%%':A%%';A%%'>A%%'?A%%'#A%%%hD%%%iD%%%jD%%%mD%%%"
U "nD%%&<D%%&=D%%&aD%%&bD%%'5D%%'6D%%'\D%%']D%%%2E%%%3E%%%6E%%%7E%"
U "%%8E%%'SH%%'TH%%'UH%%'XH%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZ"
U "VRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25%%%%K'XH%%'YH%%%5I%%%6I%%&.I%%&/I%%&2I"
U "%%&3I%%&4I%%%2K%%%3K%%%4K%%%7K%%%8K%%%DK%%%EK%%%xK%%%yK%%&<K%%&"
U "=K%%&fK%%&gK%%&jK%%&kK%%&lK%%&)M%%&*M%%&+M%%%:P%%%;P%%%<P%%%QP%"
U "%%RP%%%^P%%%_P%%&&P%%&'P%%&gP%%&hP%%utplhud$\XuTPLHuD#<8u40,(Mz"
U "vrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K&hP%%'/P%%'0P%%'JP%%'KP"
U "%%'uP%%'vP%%%(Q%%%)Q%%%DQ%%%EQ%%%HQ%%%IQ%%%JQ%%&zR%%'%R%%'&R%%%"
U "GU%%%HU%%%IU%%%^U%%%_U%%&/U%%&0U%%&kU%%&lU%%'HU%%'IU%%%.V%%%/V%"
U "%%TV%%%UV%%&:V%%&;V%%&eV%%&fV%%&gV%%'cX%%'dX%%utplhud$\XuTPLHuD"
U "#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K'dX%%'eX%%%)Y"
U "%%%*Y%%%NY%%%OY%%%sY%%%tY%%&FY%%&GY%%&_Y%%&$Y%%'MY%%'NY%%%=Z%%%"
U ">Z%%&+Z%%&,Z%%&NZ%%&OZ%%'9Z%%':Z%%'=Z%%'>Z%%'?Z%%&B]%%&C]%%&D]%"
U "%&E]%%&p]%%&q]%%&__%%&$_%%&a_%%'%_%%'&_%%''_%%%X$%%%Y$%%utplhud"
U "$\XuTPLHuD#<8u40,(MzvrnMjfb^MYTPLMHD#<)84%%%%%%%#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25%%%-z(&,*%&25%%#-z&,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K%Y$"
U "%%%Z$%%%j$%%%k$%%%l$%%%[a%%%\a%%%]a%%%ga%%%ha%%%ra%%%sa%%&'a%%&"
U "(a%%&)a%%%,c%%%-c%%%.c%%%Sc%%%Tc%%%Uc%%&.c%%&/c%%&0c%%&Gc%%&Hc%"
U "%&Ic%%'-c%%'.c%%'/c%%'Nc%%'Oc%%'nc%%'oc%%%:d%%%;d%%%<d%%%Nf%%%O"
U "f%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25%%%%K%Of%%%fh%%%gh%%%hh%%%kh%%%lh%%&Lh%%&Mh%%'.h%%'/h%%'Nh%%'"
U "Oh%%'nh%%'oh%%%;i%%%<i%%%vi%%%wi%%&&i%%&'i%%&ki%%&li%%&si%%&ti%"
U "%'Di%%'Ei%%'ki%%'li%%%>j%%%?j%%%oj%%%pj%%%wj%%%xj%%&%j%%&&j%%&5"
U "j%%&6j%%&;j%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%"
U "%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25%%%%K&;j%%&<j%%')j%%'*j%%'mj%%'nj%%%]k%%%^k%%%wk%%%"
U "xk%%&tk%%&uk%%'Gk%%'Hk%%'Ok%%'Pk%%'Uk%%'Vk%%'uk%%'vk%%%%l%%%&l%"
U "%%'l%%&9m%%&:m%%&;m%%&Km%%&Lm%%&Vm%%&Wm%%&^m%%&_m%%&$m%%'/q%%'0"
U "q%%'1q%%%ou%%%pu%%%qu%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRN"
U "MJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25%%%%K%qu%%&;u%%&<u%%&\u%%&]u%%'0u%%'1u%%'"
U "fu%%'gu%%%gv%%%hv%%%iv%%'Cw%%'Dw%%'Ew%%'fw%%'gw%%'hw%%'Yy%%'Zy%"
U "%'[y%%'^y%%'_y%%%,z%%%-z%%%=z%%%>z%%%az%%%bz%%&.z%%&/z%%&Tz%%&U"
U "z%%&\z%%&]z%%&ez%%&fz%%',z%%'-z%%utplhud$\XuTPLHuD#<8u40,(Mzvrn"
U "Mjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K'-z%%'0z%%'1z%%'2z%%'3z%%("
U "N)%%(O)%%(P)%%(]*%%(^*%%(_*%%(j*%%(k*%%(n*%%(o*%%)(*%%))*%%)E*%"
U "%)F*%%)W*%%)X*%%)z*%%*%*%%*o*%%*p*%%(8+%%(9+%%(:+%%(E+%%(F+%%(f"
U "+%%(g+%%)I+%%)J+%%)Y+%%)Z+%%*2+%%*3+%%*Q+%%utplhud$\XuTPLHuD#<8"
U "u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K*Q+%%*R+%%*X+%%*"
U "Y+%%*a+%%*b+%%*h+%%*i+%%*j+%%*u+%%*v+%%(2,%%(3,%%([,%%(\,%%)E,%"
U "%)F,%%)s,%%)t,%%*M,%%*N,%%*Z,%%*[,%%(=-%%(>-%%(h-%%(i-%%)2-%%)3"
U "-%%)T-%%)U-%%)a-%%)b-%%)j-%%)k-%%)r-%%)s-%%)t-%%*)-%%utplhud$\X"
U "uTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
END SUB

SUB V8
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K*)-%%*"
U "*-%%*K-%%*L-%%*^-%%*_-%%(:.%%(;.%%(F.%%(G.%%(O.%%(P.%%(Q.%%(\.%"
U "%(].%%(b.%%(c.%%)'.%%)(.%%)U.%%)V.%%*-.%%*..%%*[.%%*\.%%*l.%%*m"
U ".%%(Q/%%(R/%%(Y/%%(Z/%%(]/%%(^/%%(_/%%*/2%%*02%%*12%%)%6%%)&6%%"
U "utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%"
U "%%%K)&6%%)'6%%)E8%%)F8%%)G8%%(-9%%(.9%%(/9%%*89%%*99%%*:9%%(2;%"
U "%(3;%%(4;%%(E;%%(F;%%($;%%(a;%%(z;%%)%;%%)5;%%)6;%%)F;%%)G;%%)O"
U ";%%)P;%%)Q;%%*x;%%(%<%%(&<%%(B<%%(C<%%(D<%%)j=%%)k=%%)l=%%*0=%%"
U "*1=%%*M=%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%"
U "%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25%%%%K*M=%%*N=%%*_=%%*$=%%*t=%%*u=%%*v=%%)d>%%)e>%%)f>%"
U "%)u>%%)v>%%*5>%%*6>%%*H>%%*I>%%*Q>%%*R>%%*S>%%(4?%%(5?%%(6?%%(W"
U "?%%(X?%%(Y?%%*u#%%*v#%%*w#%%(5C%%(6C%%)OF%%)PF%%)QF%%)kF%%)lF%%"
U "*KF%%*LF%%*MF%%*7G%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJF"
U "B>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25%%%%K*7G%%*8G%%*9G%%*DG%%*EG%%*HG%%*IG%%*ZG%"
U "%*[G%%*uG%%*vG%%(;H%%(<H%%(LH%%(MH%%(]H%%(^H%%(fH%%(gH%%)-H%%)."
U "H%%)/H%%):H%%);H%%)[H%%)\H%%*)H%%**H%%*MH%%*NH%%*OH%%*ZH%%*[H%%"
U "*rH%%*sH%%(^I%%(_I%%)%I%%)&I%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjf"
U "b^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K)&I%%)]I%%)^I%%*%I%%*&I%%*/I%"
U "%*0I%%*_I%%*$I%%(:J%%(;J%%(dJ%%(eJ%%)9J%%):J%%)RJ%%)SJ%%)^J%%)_"
U "J%%)fJ%%)gJ%%)qJ%%)rJ%%*AJ%%*BJ%%*GJ%%*HJ%%*NJ%%*OJ%%*PJ%%*[J%%"
U "*\J%%*rJ%%*sJ%%(;K%%(<K%%(sK%%(tK%%)bK%%utplhud$\XuTPLHuD#<8u40"
U ",(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K)bK%%)cK%%*QK%%*RK%"
U "%(BL%%(CL%%(ZL%%([L%%)IL%%)JL%%*QL%%*RL%%*ZL%%*[L%%*eL%%*fL%%*k"
U "L%%*lL%%*rL%%*sL%%*tL%%)+M%%),M%%)-M%%*0M%%*1M%%*2M%%)hN%%)iN%%"
U ")jN%%(KR%%(LR%%(MR%%(^T%%(_T%%)-U%%).U%%)/U%%(>V%%utplhud$\XuTP"
U "LHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,."
U "*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K(>V%%(?V%"
U "%(#V%%(AV%%(UV%%(VV%%*3Y%%*4Y%%*5Y%%(TZ%%(UZ%%(VZ%%(_Z%%($Z%%(w"
U "Z%%(xZ%%):Z%%);Z%%)KZ%%)LZ%%)iZ%%)jZ%%)mZ%%)nZ%%)oZ%%(>[%%(?[%%"
U "(#[%%(-]%%(.]%%(/]%%(_$%%($$%%(a$%%(g$%%(h$%%)v$%%)w$%%)y$%%utp"
U "lgub^ZVuRNJFuB>:6u2.*&MxtplMhd$\MXTPLMHD?;)73%%%%%%%(+,*%&25%%("
U "+,*%&25%%(+,*%&25%%#-z&,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%"
U "+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,."
U "*%25%%%-z(&,*%&25%%#-z&,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%"
U "K)y$%%)z$%%)tb%%)ub%%(Ec%%(Fc%%(Gc%%*Bc%%*Cc%%*Dc%%*Mc%%*Nc%%*^"
U "c%%*_c%%*ic%%*jc%%()d%%(*d%%(1d%%(2d%%(3d%%).e%%)/e%%)0e%%)Ef%%"
U ")Ff%%)Gf%%)Pf%%)Qf%%)$f%%)af%%)sf%%)tf%%)vf%%)wf%%*Vf%%*Wf%%*uf"
U "%%*vf%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%"
U "%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25%%%%K*vf%%(=g%%(>g%%([g%%(\g%%(fg%%(gg%%)2g%%)3g%%)Xg%%)Y"
U "g%%*1g%%*2g%%*Ng%%*Og%%*Tg%%*Ug%%*Yg%%*Zg%%*tg%%*ug%%(%h%%(&h%%"
U "((h%%()h%%(*h%%(.l%%(/l%%(0l%%*,m%%*-m%%*.m%%*om%%*pm%%*qm%%([o"
U "%%(\o%%(]o%%(fo%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>)"
U ":6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25%%%%K(fo%%(go%%(io%%(jo%%)&o%%)'o%%)Go%%)Ho%%)Q"
U "o%%)Ro%%)lo%%)mo%%*7o%%*8o%%*Ao%%*Bo%%*Xo%%*Yo%%*^o%%*_o%%*$o%%"
U "('q%%((q%%()q%%*3q%%*4q%%*5q%%*Wq%%*Xq%%*Yq%%)Iw%%)Jw%%)Kw%%)Mw"
U "%%)Nw%%)bw%%)cw%%*.w%%*/w%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^M"
U "ZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25%%%%K*/w%%*ow%%*pw%%(Xx%%(Yx%%(ox%%(p"
U "x%%(sx%%(tx%%(ux%%*Bx%%*Cx%%*Dx%%+$%%%+a%%%+b%%%+k%%%+l%%%,5%%%"
U ",6%%%,H%%%,I%%%-/%%%-0%%%-h%%%-i%%%-p%%%-q%%%-t%%%-u%%%-v%%%,g("
U "%%,h(%%,i(%%-/*%%-0*%%-1*%%-:*%%-;*%%utplhud$\XuTPLHuD#<8u40,(M"
U "zvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K-;*%%-Z*%%-[*%%-l*%%-m"
U "*%%+g+%%+h+%%+u+%%+v+%%,:+%%,;+%%-/+%%-0+%%-7+%%-8+%%-;+%%-<+%%"
U "-=+%%+t,%%+u,%%+v,%%-\-%%-]-%%-^-%%-g-%%-h-%%+*.%%++.%%+>.%%+?."
U "%%+S.%%+T.%%+W.%%+X.%%+Y.%%,30%%,40%%,50%%,>0%%utplhud$\XuTPLHu"
U "D#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K,>0%%,?0%%,\"
U "0%%,]0%%,^0%%+Q1%%+R1%%+S1%%,.5%%,/5%%,05%%,95%%,:5%%,K5%%,L5%%"
U ",g5%%,h5%%,j5%%,k5%%-L5%%-M5%%-Z5%%-[5%%-u5%%-v5%%+Z6%%+[6%%+q6"
U "%%+r6%%+u6%%+v6%%+w6%%,t7%%,u7%%,v7%%-^9%%-_9%%-$9%%-c9%%utplhu"
U "d$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%2"
U "5#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K-c"
U "9%%-d9%%-q9%%-r9%%-u9%%-v9%%-w9%%,6;%%,7;%%,8;%%+T<%%+U<%%+V<%%"
U "+Y<%%+Z<%%+e<%%+f<%%+u<%%+v<%%+y<%%+z<%%,%<%%-O=%%-P=%%-Q=%%-R="
U "%%-t=%%-u=%%+jA%%+kA%%+lA%%,EC%%,FC%%,GC%%+HE%%+IE%%+JE%%+/G%%+"
U "0G%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjea]MYUQMMIEA=)95%%%%%%%%%%%"
U "%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+"
U ",*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%(+,*%&25%%#-z&,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25%%%%K+0G%%+1G%%+BG%%+CG%%+TG%%+UG%%+$G%%+aG%%+yG%%+zG%%,.G%%"
U ",/G%%,6G%%,7G%%,8G%%,=J%%,>J%%,?J%%,YJ%%,ZJ%%-)J%%-*J%%-7J%%-8J"
U "%%-?J%%-#J%%-AJ%%+rL%%+sL%%+tL%%,FL%%,GL%%,HL%%,UL%%,VL%%,WL%%-"
U "0L%%-1L%%-2L%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVRNMJFB>):6%"
U "%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25%%%%K-2L%%,CN%%,DN%%,EN%%,jN%%,kN%%-&N%%-'N%%-PN%%"
U "-QN%%-XN%%-YN%%-ZN%%+8O%%+9O%%+:O%%+=O%%+>O%%+nO%%+oO%%,HO%%,IO"
U "%%-,O%%--O%%-0O%%-1O%%-2O%%-^P%%-_P%%-$P%%+1V%%+2V%%+3V%%+?V%%+"
U "#V%%+NV%%+OV%%+]V%%+^V%%utplhud$\XuTPLHuD#<8u40,(MzvrnMjfb^MZVR"
U "NMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25%%%%K+^V%%+mV%%+nV%%+oV%%,(V%%,)V%%,7V%%"
U ",8V%%,FV%%,GV%%,OV%%,PV%%,hV%%,iV%%,sV%%,tV%%-+V%%-,V%%-9V%%-:V"
U "%%-;V%%-=V%%->V%%-RV%%-SV%%++W%%+,W%%+ZW%%+[W%%,3W%%,4W%%,cW%%,"
U "dW%%-(W%%-)W%%-5W%%-6W%%-;W%%-<W%%utplhud$\XuTPLHuD#<8u40,(Mzvr"
U "nMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K-<W%%-eW%%-fW%%-iW%%-jW%%"
U "-kW%%+wZ%%+xZ%%-'[%%-([%%-)[%%-;[%%-<[%%-G[%%-H[%%-Q[%%-R[%%-_["
U "%%-$[%%-n[%%-o[%%+*\%%++\%%+2\%%+3\%%+4\%%+3]%%+4]%%+5]%%+d]%%+"
U "e]%%,*]%%,+]%%,X]%%,Y]%%,j]%%,k]%%-N]%%-O]%%utplhud$\XuTPLHuD#<"
U "8u40,(MzvrnMjfb^MZVRNMJFB>):6%%%%%%%%%%%%#%%+,.*%25#%%+,.*%25#%"
U "%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,"
U ".*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%"
U "25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%K-O]%%+9^%%+:^%%"
U "+u^%%+v^%%,]^%%,^^%%,j^%%,k^%%-0^%%-1^%%-[^%%-\^%%-c^%%-d^%%-e^"
U "%%-,_%%--_%%-._%%+ta%%+ua%%+va%%+wa%%,:a%%,;a%%+Bd%%+Cd%%+Dd%%+"
U "Kf%%+Lf%%+Mf%%,Tg%%,Ug%%,Vg%%,]g%%,^g%%utplhud$\XuTPLHuD#<8u40,"
U "(MzvqlMhd$\MXTPL2HC?%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%(+,*%&25%%#-z&,.*%2M#%%+,.*%25#%%+,.*%25#%%+,.*%25"
U "#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%"
U "-z(&,*%&25%%#-z&,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#"
U "%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+"
U ",.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*"
U "%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25#%%+,.*%25%%%%H%9(%%"
U "%#(%%%c(%%&(*%%&)*%%&**%%&<*%%&K*%%&W*%%&w*%%'C*%%'N*%%'h*%%'x*"
U "%%%%+%%%&+%%%3+%%'e-%%'f-%%'6/%%'7/%%'%0%%'&0%%''0%%'=0%%'s%%%["
U "%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%"
U "%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%"
U "(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%"
END SUB

SUB V9
U "%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%"
U "&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&"
U "%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%%='=0%%'02%%'12%%'m2%%'n2%%%C3%%%T3%%%i3%%&*3%%&C3%%&D3%%&M4"
U "%%&N4%%&B5%%&C5%%&Y5%%&Z5%%%J6%%%K6%%'36%%'46%%'E6%%'W6%%'f6%%'"
U "w6%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%"
U "%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%"
U "%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$"
U "%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%"
U "%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%%='w6%%%47%%%57%%&o7%%&p7%%'l9%%'m9%%'n9%%%D:%%'&<"
U "%%''<%%'+<%%'W<%%'[<%%'\<%%%q>%%%r>%%%v>%%&(>%%&1>%%&o>%%&s>%%&"
U "t>%%%KA%%%LA%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%"
U "%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%"
U "%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%"
U "&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U ")%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%"
U ")%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%%=%LA%%%PA%%%wA%%&AA%%';A%%'?A%%'#A%%%iD"
U "%%%jD%%%nD%%&=D%%&bD%%'6D%%']D%%%3E%%%7E%%%8E%%'TH%%'UH%%'YH%%%"
U "6I%%&/I%%&3I%%&4I%%%3K%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%"
U "%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%"
U "%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%"
U "(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7"
U "%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%"
U "9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9"
U "'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=%3K%%%4K%%%8K%%%EK%%%yK%%&=K"
U "%%&gK%%&kK%%&lK%%&*M%%&+M%%%;P%%%<P%%%RP%%%_P%%&'P%%&hP%%'0P%%'"
U "KP%%'vP%%%)Q%%%EQ%%%IQ%%%JQ%%'%R%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%"
U "%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%"
U "%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%"
U ".%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i"
U "%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i"
U "%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%"
U "%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%='%R%%'&R%%%HU%%%IU"
U "%%%_U%%&0U%%&lU%%'IU%%%/V%%%UV%%&;V%%&fV%%&gV%%'dX%%'eX%%%*Y%%%"
U "OY%%%tY%%&GY%%&$Y%%'NY%%%>Z%%&,Z%%&OZ%%':Z%%'s%%%[%%%n%%%%%7%%i"
U "%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%"
U "%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%"
U "#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%"
U "%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&"
U "%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=':Z%%'>Z"
U "%%'?Z%%&C]%%&D]%%&E]%%&q]%%&$_%%&a_%%'&_%%''_%%%Y$%%%Z$%%%k$%%%"
U "l$%%%\a%%%]a%%%ha%%%sa%%&(a%%&)a%%%-c%%%.c%%%Tc%%%Uc%%'s%%%[%%%"
U "n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K"
U "%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%"
U "%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%"
U "%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U "%=%Uc%%&/c%%&0c%%&Hc%%&Ic%%'.c%%'/c%%'Oc%%'oc%%%;d%%%<d%%%Of%%%"
U "gh%%%hh%%%lh%%&Mh%%'/h%%'Oh%%'oh%%%<i%%%wi%%&'i%%&li%%&ti%%'Ei%"
U "%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%"
U "P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%"
U "%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%"
U "%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%"
U ")%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%%='Ei%%'li%%%?j%%%pj%%%xj%%&&j%%&6j%%&<j%%'*j%%'nj%%%"
U "^k%%%xk%%&uk%%'Hk%%'Pk%%'Vk%%'vk%%%&l%%%'l%%&:m%%&;m%%&Lm%%&Wm%"
U "%&_m%%&$m%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%"
U "%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2"
U "%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%"
U "%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7"
U "%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%"
U "9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9"
U "'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%%=&$m%%'0q%%'1q%%%pu%%%qu%%&<u%%&]u%%'1u%%'"
U "gu%%%hv%%%iv%%'Dw%%'Ew%%'gw%%'hw%%'Zy%%'[y%%'_y%%%-z%%%>z%%%bz%"
U "%&/z%%&Uz%%&]z%%&fz%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%"
U "%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%"
U "'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j"
U "%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i"
U "%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i"
U "%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%"
U "%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%"
U "&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=&fz%%'-z%%'1z%%'2z%%'3z%%(O)%%("
U "P)%%(^*%%(_*%%(k*%%(o*%%))*%%)F*%%)X*%%*%*%%*p*%%(9+%%(:+%%(F+%"
U "%(g+%%)J+%%)Z+%%*3+%%*R+%%*Y+%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%"
U "%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%"
U "+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%"
U "o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&"
U "%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%"
U "%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=*Y+%%*b+%%*i+%%*j+%%*"
U "v+%%(3,%%(\,%%)F,%%)t,%%*N,%%*[,%%(>-%%(i-%%)3-%%)U-%%)b-%%)k-%"
U "%)s-%%)t-%%**-%%*L-%%*_-%%(;.%%(G.%%(P.%%'s%%%[%%%n%%%%%7%%i%%%"
U "%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%"
U "7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%"
U "%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U ")%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=(P.%%(Q.%%("
U "].%%(c.%%)(.%%)V.%%*..%%*\.%%*m.%%(R/%%(Z/%%(^/%%(_/%%*02%%*12%"
U "%)&6%%)'6%%)F8%%)G8%%(.9%%(/9%%*99%%*:9%%(3;%%(4;%%'s%%%[%%%n%%"
U "%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%"
U "[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%"
U "%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%("
U "%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=("
U "4;%%(F;%%(a;%%)%;%%)6;%%)G;%%)P;%%)Q;%%(%<%%(&<%%(C<%%(D<%%)k=%"
U "%)l=%%*1=%%*N=%%*$=%%*u=%%*v=%%)e>%%)f>%%)v>%%*6>%%*I>%%*R>%%'s"
U "%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%"
U "%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%"
U "%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%."
U "%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%"
U "9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9"
U "'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%%=*R>%%*S>%%(5?%%(6?%%(X?%%(Y?%%*v#%%*w#%%(6C%%)PF%%)QF%"
U "%)lF%%*LF%%*MF%%*8G%%*9G%%*EG%%*IG%%*[G%%*vG%%(<H%%(MH%%(^H%%(g"
U "H%%).H%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%"
U "%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%"
U "%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#"
U "%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i"
U "%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i"
U "%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%"
U "%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%"
U "&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%%=).H%%)/H%%);H%%)\H%%**H%%*NH%%*OH%%*[H%%*sH%"
U "%(_I%%)&I%%)^I%%*&I%%*0I%%*$I%%(;J%%(eJ%%):J%%)SJ%%)_J%%)gJ%%)r"
U "J%%*BJ%%*HJ%%*OJ%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z"
U "%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%"
U "%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%"
U "%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&"
U "%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%"
U "%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%%=*OJ%%*PJ%%*\J%%*sJ%%(<K%%(tK%%)cK%"
U "%*RK%%(CL%%([L%%)JL%%*RL%%*[L%%*fL%%*lL%%*sL%%*tL%%),M%%)-M%%*1"
U "M%%*2M%%)iN%%)jN%%(LR%%(MR%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%"
U "'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<"
U "%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%"
U "%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U ")%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%"
U ")%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=(MR%%(_T%%).U%%)/U%%(?V%"
U "%(#V%%(AV%%(VV%%*4Y%%*5Y%%(UZ%%(VZ%%($Z%%(xZ%%);Z%%)LZ%%)jZ%%)n"
U "Z%%)oZ%%(?[%%(#[%%(.]%%(/]%%($$%%(a$%%'s%%%[%%%n%%%%%7%%i%%%%%%"
U "+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%"
U "A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%"
U "%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7"
U "%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=(a$%%)w$%%)z$%"
U "%)ub%%(Fc%%(Gc%%*Cc%%*Dc%%*Nc%%*_c%%*jc%%(*d%%(2d%%(3d%%)/e%%)0"
U "e%%)Ff%%)Gf%%)Qf%%)af%%)tf%%)wf%%*Wf%%*vf%%(>g%%'s%%%[%%%n%%%%%"
U "7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%"
U "%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&"
U "y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%"
U "%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9"
U "'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=(>g%"
U "%(\g%%(gg%%)3g%%)Yg%%*2g%%*Og%%*Ug%%*Zg%%*ug%%(&h%%()h%%(*h%%(/"
U "l%%(0l%%*-m%%*.m%%*pm%%*qm%%(\o%%(]o%%(go%%(jo%%)'o%%)Ho%%'s%%%"
U "[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%"
U "%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+"
U "%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%["
U "%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i"
U "%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%"
U "%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%"
U "&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%%=)Ho%%)Ro%%)mo%%*8o%%*Bo%%*Yo%%*_o%%*$o%%((q%%()q%%*4q%%*5"
U "q%%*Xq%%*Yq%%)Jw%%)Kw%%)Nw%%)cw%%*/w%%*pw%%(Yx%%(px%%(tx%%(ux%%"
END SUB

SUB VA
U "*Cx%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%"
U "%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7"
U "%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%"
U "$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&"
U "%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%"
U "%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%%=*Cx%%*Dx%%+a%%%+b%%%+l%%%,6%%%,I%%%-0%%%-i%%%-q"
U "%%%-u%%%-v%%%,h(%%,i(%%-0*%%-1*%%-;*%%-[*%%-m*%%+h+%%+v+%%,;+%%"
U "-0+%%-8+%%-<+%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%"
U "%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%["
U "%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%"
U "%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U ")%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%"
U ")%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%%=-<+%%-=+%%+u,%%+v,%%-]-%%-^-%%-h-%%++"
U ".%%+?.%%+T.%%+X.%%+Y.%%,40%%,50%%,?0%%,]0%%,^0%%+R1%%+S1%%,/5%%"
U ",05%%,:5%%,L5%%,h5%%,k5%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%"
U "%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%"
U "%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%"
U "%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7"
U "%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%"
U "9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=,k5%%-M5%%-[5%%-v5%%+[6%%+r"
U "6%%+v6%%+w6%%,u7%%,v7%%-_9%%-$9%%-d9%%-r9%%-v9%%-w9%%,7;%%,8;%%"
U "+U<%%+V<%%+Z<%%+f<%%+v<%%+z<%%,%<%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d"
U "%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%"
U "%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%"
U "%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9"
U "'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i"
U "%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=,%<%%-P=%%-Q=%%-R"
U "=%%-u=%%+kA%%+lA%%,FC%%,GC%%+IE%%+JE%%+0G%%+1G%%+CG%%+UG%%+aG%%"
U "+zG%%,/G%%,7G%%,8G%%,>J%%,?J%%,ZJ%%-*J%%-8J%%'s%%%[%%%n%%%%%7%%"
U "i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%"
U "%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%"
U "%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%"
U "%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%"
U "%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%"
U "&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%"
U "&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&"
U "%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%=-8J%%-#"
U "J%%-AJ%%+sL%%+tL%%,GL%%,HL%%,VL%%,WL%%-1L%%-2L%%,DN%%,EN%%,kN%%"
U "-'N%%-QN%%-YN%%-ZN%%+9O%%+:O%%+>O%%+oO%%,IO%%--O%%-1O%%'s%%%[%%"
U "%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+%P%%%%%%%'"
U "K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-%%%%%%+%(%"
U "%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%%%%.%%[%%%"
U "%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%"
U "%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%"
U "%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%"
U "%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%"
U "%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%"
U "%%=-1O%%-2O%%-_P%%-$P%%+2V%%+3V%%+#V%%+OV%%+^V%%+nV%%+oV%%,)V%%"
U ",8V%%,GV%%,PV%%,iV%%,tV%%-,V%%-:V%%-;V%%->V%%-SV%%+,W%%+[W%%,4W"
U "%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7%%U%%%%%%+"
U "%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%2%%%%%7%%-"
U "%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e%%%#%%%$%%"
U "%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%"
U "%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%"
U ")%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%"
U ")%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)"
U "%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)"
U "%%9'i%&%%%%%=,4W%%,dW%%-)W%%-6W%%-<W%%-fW%%-jW%%-kW%%+xZ%%-([%%"
U "-)[%%-<[%%-H[%%-R[%%-$[%%-o[%%++\%%+3\%%+4\%%+4]%%+5]%%+e]%%,+]"
U "%%,Y]%%,k]%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7"
U "%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%"
U "2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e"
U "%%%#%%%$%%%%%.%%[%%%%%%(%V%%%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%"
U "7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%"
U "%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7"
U "%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%"
U "9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%"
U "9i%%&%%%%)%%9'i%&%%%%%=,k]%%-O]%%+:^%%+v^%%,^^%%,k^%%-1^%%-\^%%"
U "-d^%%-e^%%--_%%-._%%+ua%%+va%%+wa%%,;a%%+Cd%%+Dd%%+Lf%%+Mf%%,Ug"
U "%%,Vg%%,^g%%'s%%%[%%%n%%%%%7%%i%%%%%%+%d%%%%%%%'_%%%[%%%Z%%%%%7"
U "%%U%%%%%%+%P%%%%%%%'K%%%[%%%F%%%%%7%%A%%%%%%+%<%%%%%%%'7%%%[%%%"
U "2%%%%%7%%-%%%%%%+%(%%%%%%%&y%%%#%%%t%%%%%.%%o%%%%%%(%j%%%%%%%&e"
U "%%%#%%%$%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9"
U "i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'"
U "i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i"
U "%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%)%7%9i%%&%%%%)%%9'i"
U "%&%%%%)%7%9i%%&%%%%)%%9'i%&%%%%%;%9(%%,^g%%&G%9(d%%^g.%%g%%%%%%"
U ",Jd%%m%%xx-xx%%uxxxx(96&%%3%4%%-%&%%p%4%%%%%%%?%%e-jx'%%?%+sM>A"
U "<0&;%'%%%%(%&0.)%%%%%%%%%%%%%%%%%%%%%%%%G%mfekx&p%G%I;i45M0D;CI"
U "Eu0AM06A0)?7Ek2>=C%%%%%%%%%%%%%%%%%%%)%%%%%%7%%I'%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%'xe9%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%m&%wx%(/%%uxxxx%%.'%"
U "%%%%%'9%%%%%%%k%A%%%Lr82AM>B>5JCE&>)A3E[%SUEiM>2D<24=C%%/%%%Irx"
U "&>DA3i>&2%%%7%%m^*+#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
U "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
END SUB
<PAGEEND:"Tutorial.Tutorial2.File">

<PAGESTART:"Cur.Dir.File">
'#iab.compatibility.version.1a
'CWD version 1.0d -- Get current working drive and directory
'Copyright (c)1996 Mark K. Kim
'markkkim@aol.com
'http://members.aol.com/markkkim/
'http://members.aol.com/vinDaci/
'* Freely distributed.  May be used in other programs with proper notice of
'  credit.
'* This program is provided "as-is".
'* In QBASIC, no modification is necessary
'* In QuickBASIC, QuickBASIC PDS, or VisualBASIC for DOS, run with the
'  "/L" option, like so:
'
'    QB /L
'    QBX /L
'    VBDOS /L
'
'  Also, do not include the QB.BI, QBX.BI, or VBDOS.BI files. If you do,
'  modify them so that the line "DECLARE ABSOLUTE..." is gone.
'* In QuickBASIC PDS and VisualBASIC, change all the lines in the format
'  "VARSEG(any.string.variable$)" to "SSEG(any.string.variable$)".
'* CREDIT: Ralf Brown's interrupt list was used to get interrupt for the
'  function.  Microsoft DOS's Debug was used to convert Assembly code to
'  machine code.  Microsoft is a Registered Trademark of Microsoft Corp.
'Read the header of each function to find out their usage. These functions
'are designed to work with most other routines as it does not interfere
'with any other routines.


'the following line exists for compatibility reasons:
DECLARE SUB absolute (var1%, var2%, var3%, var4%, var5%, var6%, var7%, var8%, var9%, offset%)

'#begin declaration
  DECLARE FUNCTION getdrv% ()
  DECLARE FUNCTION getdir$ (drive%)
'#end declaration


'#start example program
  CLS
  PRINT "The current working directory is ";
  PRINT CHR$(getdrv + 65);  'display drive letter
  PRINT ":";                'display colon
  PRINT getdir$(getdrv)     'display directory path
'#end example program

'getdir - Get directory
'INPUT:
'* drive% is the number representation of the drive letter, where A = 0,
'  B = 1, C = 2, etc.  -1 is used for the current drive.
'RETURN:
'* The directory is returned in "\directory\directory\..." format.
'  * There is always "\" at the beginning of the string.
'  * There is no "\" at the end of the string.
'* On error, the length of the string is zero.
'  * You can tell whether the directory is a root or whether an error has
'    occurred because the root directory is returned as "\" whereas an
'    error is returned as "".
'EXAMPLE:
'  IF LEN(getdir$(0)) <> 0 THEN
'    PRINT "The current directory is "; getdir$(0)
'  ELSE
'    PRINT "Cannot find current directory!"
'  END IF
FUNCTION getdir$ (drive%)

  drive% = drive% + 1
  'initialize assembly code
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'push bp
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'mov bp, sp
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H47)                     'mov ah, 47h
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'mov bx, [bp+0ah]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)                     'mov dx, [bx]
  asm$ = asm$ + CHR$(&H1E)                                  'push ds
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)         'mov bx, [bp+08h]
  asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)                     'mov ds, [bx]
  asm$ = asm$ + CHR$(&H56)                                  'push si
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'mov bx, [bp+06h]
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H37)                     'mov si, [bx]
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'int 21h
  asm$ = asm$ + CHR$(&H5E)                                  'pop si
  asm$ = asm$ + CHR$(&H1F)                                  'pop ds
  asm$ = asm$ + CHR$(&HBA) + CHR$(&H0) + CHR$(&H0)          'mov dx, 0000h
  asm$ = asm$ + CHR$(&H80) + CHR$(&HD2) + CHR$(&H0)         'adc dl, 00h
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)         'mov bx, [bp+0a]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H17)                     'mov [bx], dx
  asm$ = asm$ + CHR$(&H5D)                                  'pop  bp
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'retf 0012h

  'string to store directory information
  directory$ = SPACE$(65)
  dirseg% = VARSEG(directory$)  'get segment address
  diroff% = SADD(directory$)    'get offset address

  'execute
  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, drive%, dirseg%, diroff%, SADD(asm$))
  directory$ = LEFT$(directory$, INSTR(directory$, CHR$(0)))
  IF LEFT$(directory$, 1) <> "\" THEN directory$ = "\" + directory$

  IF drive% THEN directory$ = ""

  getdir$ = directory$

END FUNCTION

'getdrv - Get current drive
'RETURN:
'* The number representation of the drive letter, where A = 0, B = 1, etc.
'EXAMPLE:
'  PRINT "The current working drive is "; getdrv
FUNCTION getdrv%

  'initialize assembly code
  asm$ = ""
  asm$ = asm$ + CHR$(&H55)                                  'push bp
  asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)                     'mov bp, sp
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H19)                     'mov ah, 19h
  asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)                     'int 21h
  asm$ = asm$ + CHR$(&HB4) + CHR$(&H0)                      'mov ah, 00h
  asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)         'mov bx, [bp+06h]
  asm$ = asm$ + CHR$(&H89) + CHR$(&H7)                      'mov [bx], ax
  asm$ = asm$ + CHR$(&H5D)                                  'pop bp
  asm$ = asm$ + CHR$(&HCA) + CHR$(&H12) + CHR$(&H0)         'retf 0012h

  'execute
  DEF SEG = VARSEG(asm$)
  CALL absolute(dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, dummy%, drive%, SADD(asm$))

  getdrv% = drive%

END FUNCTION
<PAGEEND:"Cur.Dir.File">

<PAGESTART:"3D.Info.File1">
'this is code to draw and rotate a 3-d image of a cylinder
'  and a sphere.
'by Douglas H. Lusher, October 1996
DECLARE SUB DrawPoly (X%(), Y%(), Vertices%, Culler%)
DECLARE FUNCTION KeyPress% ()
CONST Green = 2, White = 15
CONST ESC = 27
CONST HomeKey = -71, EndKey = -79
CONST UpArrow = -72, DnArrow = -80
CONST LArrow = -75,  RArrow = -77
'the home key brings the object toward the viewer, the end key
'   takes it away from the viewer.
'the up arrow moves the object up, the down arrow moves it down,
'   the right arrow moves it right, the left arrow moves it left.
'pressing "y","p", or "r" increases yaw, pitch and roll respectively.
'   pressing the uppercase of these letters decreases the values.
RANDOMIZE TIMER
APage% = 1: VPage% = 0
SCREEN 9, , APage%, VPage%
ScrnWid% = 640: ScrnHgt% = 350
CtrX% = ScrnWid% \ 2: CtrY% = ScrnHgt% \ 2
AspectRatio! = 4 * (ScrnHgt% / ScrnWid%) / 3
Pi! = ATN(1) * 4!

DO: R1! = RND: LOOP UNTIL R1! < .628: R1! = R1! * 10!
DO: R2! = RND: LOOP UNTIL R2! < .628: R2! = R2! * 10!
DO: R3! = RND: LOOP UNTIL R3! < .628: R3! = R3! * 10!
'R1! = 0: R2! = 0: R3! = 0
D! = 1200
MX! = 0: MY! = 0: MZ! = -350
Inc! = .02
RInc! = -Inc!
PInc! = -Inc!
YInc! = -Inc!

GOSUB InitCylinder
'GOSUB InitSphere

'MainLoop
DO
  SELECT CASE KeyPress%
    CASE 0
    CASE UpArrow: MY! = MY! + 10!
    CASE DnArrow: MY! = MY! - 10!
    CASE LArrow: MX! = MX! + 10!
    CASE RArrow: MX! = MX! - 10!
    CASE HomeKey: MZ! = MZ! + 10!
    CASE EndKey: MZ! = MZ! - 10!
    CASE ASC("r")
      RInc! = RInc! + Inc!: IF RInc! > 1 THEN RInc! = 1
    CASE ASC("R")
      RInc! = RInc! - Inc!: IF RInc! < -1 THEN RInc! = -1
    CASE ASC("y")
      YInc! = YInc! + Inc!: IF YInc! > 1 THEN YInc! = 1
    CASE ASC("Y")
      YInc! = YInc! - Inc!: IF YInc! < -1 THEN YInc! = -1
    CASE ASC("p")
      PInc! = PInc! + Inc!: IF PInc! > 1 THEN PInc! = 1
    CASE ASC("P")
      PInc! = PInc! - Inc!: IF PInc! < -1 THEN PInc! = -1
    CASE ESC: EXIT DO
  END SELECT
  R1! = R1! + YInc!: IF R1! > 6.28 THEN R1! = 0
  R2! = R2! + RInc!: IF R2! > 6.28 THEN R2! = 0
  R3! = R3! + PInc!: IF R3! > 6.28 THEN R3! = 0
  SR1! = SIN(R1!): CR1! = COS(R1!)
  SR2! = SIN(R2!): CR2! = COS(R2!)
  SR3! = SIN(R3!): CR3! = COS(R3!)
  CLS
  GOSUB DrawCylinder
  'GOSUB DrawSphere
  SWAP APage%, VPage%
  WAIT &H3DA, 8
  SCREEN , , APage%, VPage%
LOOP
SCREEN 0: WIDTH 80
END
  
PerspectiveCalculations:
X! = -X!
XA! = CR1! * X! - SR1! * Z!
ZA! = SR1! * X! + CR1! * Z!
X! = CR2! * XA! + SR2! * Y!
YA! = CR2! * Y! - SR2! * XA!
Z! = CR3! * ZA! - SR3! * YA!
Y! = SR3! * ZA! + CR3! * YA!
X! = X! + MX!
Y! = Y! + MY!
Z! = Z! + MZ!
SX% = CINT(D! * X! / Z!) + CtrX%
SY% = CINT(D! * Y! / Z! * AspectRatio!) + CtrY%
RETURN

CheckVisibility:
'plane equation method of hidden surface removal
SP1! = -X1! * (Y2! * Z3! - Y3! * Z2!)
SP2! = X2! * (Y3! * Z1! - Y1! * Z3!)
SP3! = X3! * (Y1! * Z2! - Y2! * Z1!)
VisibleSurface% = ((SP1! - SP2! - SP3!) <= 0)
RETURN

'========================================================================
InitCylinder:
L! = 40!     'half the length of the cylinder
R! = 20!     'the radius of the cylinder
Divs% = 18   'the number of steps around the cylinder
StepAmount! = (Pi! * 2!) / CSNG(Divs%)
S1% = 1: S2% = Divs% \ 3: S3% = S2% + S2%
REDIM X1!(1 TO Divs% + 1), X2!(1 TO Divs% + 1)
REDIM Y1!(1 TO Divs% + 1), Y2!(1 TO Divs% + 1)
REDIM Z1!(1 TO Divs% + 1), Z2!(1 TO Divs% + 1)
REDIM SX1%(1 TO Divs% + 1), SY1%(1 TO Divs% + 1)
REDIM SX2%(1 TO Divs% + 1), SY2%(1 TO Divs% + 1)
REDIM X%(1 TO 4), Y%(1 TO 4)
Xtra% = Divs% + 1
RETURN

DrawCylinder:
R5! = 0
FOR T% = 1 TO Divs%
  XX! = SIN(R5!) * R!: YY! = COS(R5!) * R!
  'one end of cylinder
  X! = XX!: Y! = YY!: Z! = L!
  GOSUB PerspectiveCalculations
  X1!(T%) = X!: Y1!(T%) = Y!: Z1!(T%) = Z!
  SX1%(T%) = SX%: SY1%(T%) = SY%
  'other end of cylinder
  X! = XX!: Y! = YY!: Z! = -L!
  GOSUB PerspectiveCalculations
  X2!(T%) = X!: Y2!(T%) = Y!: Z2!(T%) = Z!
  SX2%(T%) = SX%: SY2%(T%) = SY%
  R5! = R5! + StepAmount!
NEXT
X1!(Xtra%) = X1!(1): X2!(Xtra%) = X2!(1)
Y1!(Xtra%) = Y1!(1): Y2!(Xtra%) = Y2!(1)
Z1!(Xtra%) = Z1!(1): Z2!(Xtra%) = Z2!(1)
SX1%(Xtra%) = SX1%(1): SX2%(Xtra%) = SX2%(1)
SY1%(Xtra%) = SY1%(1): SY2%(Xtra%) = SY2%(1)
FOR Q1% = 1 TO Divs%          'draw the side polygons of the cylinder
  Q2% = Q1% + 1
  X1! = X1!(Q1%): Y1! = Y1!(Q1%): Z1! = Z1!(Q1%)
  X2! = X1!(Q2%): Y2! = Y1!(Q2%): Z2! = Z1!(Q2%)
  X3! = X2!(Q2%): Y3! = Y2!(Q2%): Z3! = Z2!(Q2%)
  GOSUB CheckVisibility
  IF VisibleSurface% THEN
    X%(1) = SX1%(Q1%): Y%(1) = SY1%(Q1%)
    X%(2) = SX1%(Q2%): Y%(2) = SY1%(Q2%)
    X%(3) = SX2%(Q2%): Y%(3) = SY2%(Q2%)
    X%(4) = SX2%(Q1%): Y%(4) = SY2%(Q1%)
    CALL DrawPoly(X%(), Y%(), 4, White)
  END IF
NEXT
'draw one end
X1! = X1!(S1%): Y1! = Y1!(S1%): Z1! = Z1!(S1%)
X2! = X1!(S3%): Y2! = Y1!(S3%): Z2! = Z1!(S3%)
X3! = X1!(S2%): Y3! = Y1!(S2%): Z3! = Z1!(S2%)
GOSUB CheckVisibility
IF VisibleSurface% THEN
  CALL DrawPoly(SX1%(), SY1%(), Divs%, White)
END IF
'draw the other end
X1! = X2!(S1%): Y1! = Y2!(S1%): Z1! = Z2!(S1%)
X2! = X2!(S2%): Y2! = Y2!(S2%): Z2! = Z2!(S2%)
X3! = X2!(S3%): Y3! = Y2!(S3%): Z3! = Z2!(S3%)
GOSUB CheckVisibility
IF VisibleSurface% THEN
  CALL DrawPoly(SX2%(), SY2%(), Divs%, White)
END IF
RETURN

'========================================================================
InitSphere:
R! = 40!            'the radius of the sphere
Divs% = 18
StepAmount! = (Pi! * 2!) / CSNG(Divs%)
REDIM X1!(1 TO Divs% + 1), X2!(1 TO Divs% + 1)
REDIM Y1!(1 TO Divs% + 1), Y2!(1 TO Divs% + 1)
REDIM Z1!(1 TO Divs% + 1), Z2!(1 TO Divs% + 1)
REDIM SX1%(1 TO Divs% + 1), SY1%(1 TO Divs% + 1)
REDIM SX2%(1 TO Divs% + 1), SY2%(1 TO Divs% + 1)
REDIM X%(1 TO 4), Y%(1 TO 4)
Xtra% = Divs% + 1
RETURN

DrawSphere:
'north polar area
'R5! = 0: X! = SIN(R5!) * R!: Y! = COS(R5!) * R!: Z! = 0
X! = 0!: Y! = R!: Z! = 0
GOSUB PerspectiveCalculations
X3! = X!: Y3! = Y!: Z3! = Z!
X%(3) = SX%: Y%(3) = SY%
R5! = StepAmount!: GOSUB CalcAround
FOR Q1% = 1 TO Divs%
  Q2% = Q1% + 1
  X1! = X2!(Q2%): Y1! = Y2!(Q2%): Z1! = Z2!(Q2%)
  X2! = X2!(Q1%): Y2! = Y2!(Q1%): Z2! = Z2!(Q1%)
  GOSUB CheckVisibility
  IF VisibleSurface% THEN
    X%(1) = SX2%(Q2%): Y%(1) = SY2%(Q2%)
    X%(2) = SX2%(Q1%): Y%(2) = SY2%(Q1%)
    CALL DrawPoly(X%(), Y%(), 3, Green)
  END IF
NEXT

'middle of sphere
R5! = StepAmount!
FOR T2% = 1 TO (Divs% \ 2) - 2
  FOR Q1% = 1 TO Divs% + 1
    X1!(Q1%) = X2!(Q1%): Y1!(Q1%) = Y2!(Q1%): Z1!(Q1%) = Z2!(Q1%)
    SX1%(Q1%) = SX2%(Q1%): SY1%(Q1%) = SY2%(Q1%)
  NEXT
  R5! = R5! + StepAmount!: GOSUB CalcAround
  FOR Q1% = 1 TO Divs%
    Q2% = Q1% + 1
    X1! = X1!(Q1%): Y1! = Y1!(Q1%): Z1! = Z1!(Q1%)
    X2! = X1!(Q2%): Y2! = Y1!(Q2%): Z2! = Z1!(Q2%)
    X3! = X2!(Q2%): Y3! = Y2!(Q2%): Z3! = Z2!(Q2%)
    GOSUB CheckVisibility
    IF VisibleSurface% THEN
      X%(1) = SX1%(Q1%): Y%(1) = SY1%(Q1%)
      X%(2) = SX1%(Q2%): Y%(2) = SY1%(Q2%)
      X%(3) = SX2%(Q2%): Y%(3) = SY2%(Q2%)
      X%(4) = SX2%(Q1%): Y%(4) = SY2%(Q1%)
      CALL DrawPoly(X%(), Y%(), 4, Green)
    END IF
  NEXT
NEXT

'south polar area
R5! = Pi!: X! = SIN(R5!) * R!: Y! = COS(R5!) * R!: Z! = 0
GOSUB PerspectiveCalculations
X3! = X!: Y3! = Y!: Z3! = Z!
X%(3) = SX%: Y%(3) = SY%
FOR Q1% = 1 TO Divs%
  Q2% = Q1% + 1
  X1! = X2!(Q1%): Y1! = Y2!(Q1%): Z1! = Z2!(Q1%)
  X2! = X2!(Q2%): Y2! = Y2!(Q2%): Z2! = Z2!(Q2%)
  GOSUB CheckVisibility
  IF VisibleSurface% THEN
    X%(1) = SX2%(Q2%): Y%(1) = SY2%(Q2%)
    X%(2) = SX2%(Q1%): Y%(2) = SY2%(Q1%)
    CALL DrawPoly(X%(), Y%(), 3, Green)
  END IF
NEXT
RETURN

CalcAround:
R4! = 0!: XX! = SIN(R5!) * R!: YY! = COS(R5!) * R!
FOR T% = 1 TO Divs%
  X! = COS(R4!) * XX!: Y! = YY!: Z! = SIN(R4!) * XX!
  GOSUB PerspectiveCalculations
  X2!(T%) = X!: Y2!(T%) = Y!: Z2!(T%) = Z!
  SX2%(T%) = SX%: SY2%(T%) = SY%
  R4! = R4! + StepAmount!
NEXT
X1!(Xtra%) = X1!(1): X2!(Xtra%) = X2!(1)
Y1!(Xtra%) = Y1!(1): Y2!(Xtra%) = Y2!(1)
Z1!(Xtra%) = Z1!(1): Z2!(Xtra%) = Z2!(1)
SX1%(Xtra%) = SX1%(1): SX2%(Xtra%) = SX2%(1)
SY1%(Xtra%) = SY1%(1): SY2%(Xtra%) = SY2%(1)
RETURN

SUB DrawPoly (X%(), Y%(), Vertices%, Culler%)
PSET (X%(Vertices%), Y%(Vertices%)), Culler%
FOR Q% = 1 TO Vertices%
  LINE -(X%(Q%), Y%(Q%)), Culler%
NEXT
END SUB

FUNCTION KeyPress%
KP$ = INKEY$
IF LEN(KP$) THEN 
  KP% = ASC(KP$): IF KP% = 0 THEN KP% = -ASC(MID$(KP$, 2))
END IF
KeyPress% = KP%
END FUNCTION
<PAGEEND:"3D.Info.File1">

<PAGESTART:"3D.Info.File2">
'<PRE>
'3DEXP1a.BAS By Rich Geldreich May 22, 1992
'A fast, QuickBASIC 4.5 3-D wireframe animation program.
'Compile it for maximum speed!
'If you have any questions or ideas, please write/call:

'Rich Geldreich
'410 Market St.
'Gloucester City, NJ 08030
'(609)-742-8752

'The following program is in the public domain! Have fun!

DEFINT A-Z
TYPE LineType
    X AS INTEGER
    Y AS INTEGER
    Z AS INTEGER
    X1 AS INTEGER
    Y1 AS INTEGER
    Z1 AS INTEGER
END TYPE
DIM Points(100) AS LineType
DIM Xs(100), Ys(100), Xe(100), Ye(100), Xn(100), Yn(100)
DIM Xs1(100), Ys1(100), Xe1(100), Ye1(100)
DIM X(100), Y(100), Z(100), Pointers1(100), Pointers2(100)
DIM R(100)
DIM Cosine&(360), Sine&(360)
CLS
PRINT "3-D Craft v1a"
PRINT "By Rich Geldreich May 22, 1992"
PRINT
PRINT "Keys to use: (Turn NUMLOCK on!)"
PRINT "Q...............Quits"
PRINT "Numeric keypad..Controls your position(press 5 on the keypad"
PRINT "                to completly stop yourself) "
PRINT "-...............Forward exceleration"
PRINT "+...............Backward exceleration"
PRINT "Arrow keys......Controls the rotation of the craft"
PRINT "F...............Excelerates the craft (Forward)"
PRINT "B...............Slows the craft (Backward)"
PRINT "S...............Stops the craft"
PRINT "A...............Toggles Auto Center, use this when you lose";
PRINT " the craft"
PRINT "C...............Stops the craft's rotation"
PRINT "V...............Resets the craft to starting position"
PRINT
PRINT "Wait a sec..."

'The following for/next loop makes a sine & cosine table.
'Each sine & cosine is multiplied by 1024 and stored as long integers.
'This is done so that we don't have to use any slow floating point
'math at run time.
A = 0
FOR A! = 0 TO 359 / 57.29577951# STEP 1 / 57.29577951#
    Cosine&(A) = INT(.5 + COS(A!) * 1024)
    Sine&(A) = INT(.5 + SIN(A!) * 1024): A = A + 1
NEXT
'Next we read in all of the lines that are in the object...
FOR A = 0 TO 44
    READ Points(A).X, Points(A).Y, Points(A).Z
    READ Points(A).X1, Points(A).Y1, Points(A).Z1
NEXT
'Here comes the hard part... Consider this scenario:

'We have two connected lines, like this:

'   1--------2 and 3
'            |
'            |
'            |
'            |
'            4
'Where 1,2, 3, & 4 are the starting and ending points of each line.
'The first line consists of points 1 & 2  and the second line
'is made of points 3 & 4.
'So, you ask, what's wrong? Nothing, really, but don't you see that
'points 2 and 3 are really at the sample place? Why rotate them twice,
'that would be a total waste of time? The following code eliminates such
'occurrences from the line table. (great explanation, huh?)

NumberLines = 45
'take all of the starting & ending points and put them in one big
'array...
Np = 0
FOR A = 0 TO NumberLines - 1
    X(Np) = Points(A).X
    Y(Np) = Points(A).Y
    Z(Np) = Points(A).Z
    Np = Np + 1
    X(Np) = Points(A).X1
    Y(Np) = Points(A).Y1
    Z(Np) = Points(A).Z1
    Np = Np + 1
NEXT
'Now set up two sets of pointers that point to each point that a line
'is made of... (in other words, scan for the first occurrence of each
'starting and ending point in the point array we just built...)
FOR A = 0 TO NumberLines - 1
    Xs = Points(A).X
    Ys = Points(A).Y
    Zs = Points(A).Z            'get the 3 coordinates of the start point
    FOR B = 0 TO Np - 1         'scan the point array
        IF X(B) = Xs AND Y(B) = Ys AND Z(B) = Zs THEN
            Pointers1(A) = B    'set the pointer to point to the
            EXIT FOR            'point we have just found
        END IF
    NEXT
    Xs = Points(A).X1           'do the same thing that we did above
    Ys = Points(A).Y1           'except scan for the ending point
    Zs = Points(A).Z1           'of each line
    FOR B = 0 TO Np - 1
        IF X(B) = Xs AND Y(B) = Ys AND Z(B) = Zs THEN
            Pointers2(A) = B
            EXIT FOR
        END IF
    NEXT
NEXT
'Okay, were almost done! All we have to do now is to build a table
'that tells us which points to actually rotate...
Nr = 0
FOR A = 0 TO NumberLines - 1
    F1 = Pointers1(A)   'get staring & ending point number
    S1 = Pointers2(A)
    IF Nr = 0 THEN      'if this is the first point then it of course
                        'has to be rotated
        R(Nr) = F1: Nr = Nr + 1
    ELSE
        Found = 0       'scan to see if this point already exists...
        FOR B = 0 TO Nr - 1
            IF R(B) = F1 THEN
                Found = -1: EXIT FOR    'shoot, it's already here!
            END IF
        NEXT
        IF NOT Found THEN R(Nr) = F1: Nr = Nr + 1   'point the point
                                                    'in the array it we
    END IF                                          'can't find it...
        
    Found = 0   'now look for the ending point
    FOR B = 0 TO Nr - 1
        IF R(B) = S1 THEN
            Found = -1: EXIT FOR
        END IF
    NEXT
    IF NOT Found THEN R(Nr) = S1: Nr = Nr + 1
NEXT
PRINT "Press any key to begin..."
A$ = INPUT$(1)
'The following sets up the rotation & perspective variables.

'Vs = the screen that is currently being viewed
'Ws = the screen that is currently being worked on
Vs = 1: Ws = 0

'Deg1 & Deg2 are the two angles of rotation
'D1 & D2 are the deltas of each axes. If D1 = -5, for instance, then
'Deg1 will be decreased 5 degress every frame.
Deg1 = 0: Deg2 = 0: D1 = 0: D2 = 0

'Spos & Mypos are for the perspective routines...
'Spos is the screen's Z coordinate and Mypos is the users Z coordinate
Spos = -250: Mypos = 0

'Mx, My, and Mz are the coordinates of the user.
'Ox, Oy, and Oz are the coordinates of the craft.
Mx = 0: My = 0: Mz = 0: Ox = 0: Oy = 0: Oz = -260
'main loop
NumberOfFrames = 0
DEF SEG = &H40
StartTime = PEEK(&H6C)
DO

    'swap the viewing and working screens for page flipping...
    SWAP Vs, Ws
    SCREEN 9, , Ws, Vs
    
    'adjust the angles according to their deltas...
    Deg1 = (Deg1 + D1) MOD 360
    Deg2 = (Deg2 + D2) MOD 360
    'fix the angles up if they go out of range
    IF Deg1 < 0 THEN Deg1 = Deg1 + 360
    IF Deg2 < 0 THEN Deg2 = Deg2 + 360
    'get the sine and cosine of each angle from the tables
    'that were prepared at the beginning of the program
    C1& = Cosine&(Deg1): S1& = Sine&(Deg1)
    C2& = Cosine&(Deg2): S2& = Sine&(Deg2)
 
    'now we must adjust the object's coordinates
    'based on how quickly it is moving...
   
    X = Speed: Y = 0: Z = 0
 
    X1 = (X * C1&) \ 1024: Y1 = (X * S1&) \ 1024
    X2 = (X1 * C2&) \ 1024: Zn = (X1 * S2&) \ 1024
    Ox = Ox + X2: Oy = Oy + Y1: Oz = Oz + Zn
    IF Oz > 32000 THEN Oz = 32000
    IF Oz < -32000 THEN Oz = -32000
    IF Ox > 32000 THEN Ox = 32000
    IF Ox < -32000 THEN Ox = -32000
    IF Oy > 32000 THEN Oy = 32000
    IF Oy < -32000 THEN Oy = -32000
   
    'if Atloc is true then Auto-Center is on...
    IF AtLoc THEN
        Mx = Mx + (Ox - Mx) \ 4
        My = My + (Oy - My) \ 4
        Mz = Mz + ((Oz + 200) - Mz) \ 4
    ELSE
        'adjust the users position based on how much he is moving...
        Mz = Mz + Mzm: Mx = Mx + Mxm: My = My + Mym
        IF Mz > 32000 THEN Mz = 32000
        IF Mz < -32000 THEN Mz = -32000
        IF Mx > 32000 THEN Mx = 32000
        IF Mx < -32000 THEN Mx = -32000
        IF My > 32000 THEN My = 32000
        IF My < -32000 THEN My = -32000
    END IF
    '(Wait for vertical retrace, reduces flicker. This was recommended
    'by someone on the echo but I can't remember who! Thanks)
    WAIT &H3DA, 8
    'erase the old lines...
    IF Ws = 1 THEN
        FOR A = 0 TO Ln(Ws) - 1
            LINE (Xs1(A), Ys1(A))-(Xe1(A), Ye1(A)), 0
        NEXT
    ELSE
        FOR A = 0 TO Ln(Ws) - 1
            LINE (Xs(A), Ys(A))-(Xe(A), Ye(A)), 0
        NEXT
    END IF
    'print frames per second
    LOCATE 1, 1: PRINT A$
    'rotate the points...
    FOR A = 0 TO Nr - 1
        R = R(A): Xo = X(R): Yo = Y(R): Zo = Z(R)
        X1 = (Xo * C1& - Yo * S1&) \ 1024
        Y1& = (Xo * S1& + Yo * C1&) \ 1024 - My + Oy
        X1& = (X1 * C2& - Zo * S2&) \ 1024 - Mx + Ox
        Zn = (X1 * S2& + Zo * C2&) \ 1024 - Mz + Oz
        'if the point is too close(or behind) the viewer then
        'don't draw it...
        IF (Mypos - Zn) < 15 THEN
            Xn(R) = -1: Yn(R) = 0: Zn = 0
        ELSE
            'Put the point into perspective...
            'The original formula was:
            'Xnew=Xnew+( -Xold * ( (Spos-Z) / (MPos-Z) ) )
            'Ynew=Ynew=( -Yold * ( (Spos-Z) / (Mpos-Z) ) )
            V = (1330& * (Spos - Zn)) \ (Mypos - Zn)
            Xn(R) = 320 + X1& + (-X1& * V) \ 1330
           
            'The Y coordinate is also multiplied by .8 to adjust
            'for SCREEN 9's height to width ratio...
           
            Yn(R) = 175 + (8 * (Y1& + (-Y1& * V) \ 1330)) \ 10
        END IF
    NEXT
    'draw the lines...
    '(There are two seperate cases, each puts it's coordinates
    'in a different array for later erasing. I could of used a
    '2 dimensional array for this but that is slower.)
    IF Ws = 1 THEN
        Ln = 0
        FOR A = 0 TO NumberLines - 1
            F1 = Pointers1(A): S1 = Pointers2(A)
            Xn = Xn(F1): Yn = Yn(F1)
            'if Xn<>-1 then it's in view...
            IF Xn <> -1 THEN
                IF Xn(S1) <> -1 THEN
                    X1 = Xn(S1): Y1 = Yn(S1)
                    LINE (X1, Y1)-(Xn, Yn), 14
                    'store the lines so they can be erased later...
                    Xs1(Ln) = X1: Ys1(Ln) = Y1
                    Xe1(Ln) = Xn: Ye1(Ln) = Yn
                    Ln = Ln + 1
                END IF
            END IF
        NEXT
    ELSE
        Ln = 0
        FOR A = 0 TO NumberLines - 1
            F1 = Pointers1(A): S1 = Pointers2(A)
            Xn = Xn(F1): Yn = Yn(F1)
            'if Xn<>-1 then it's in view...
            IF Xn <> -1 THEN
                IF Xn(S1) <> -1 THEN
                    X1 = Xn(S1): Y1 = Yn(S1)
                    LINE (X1, Y1)-(Xn, Yn), 14
                    'store the lines so they can be erased later...
                    Xs(Ln) = X1: Ys(Ln) = Y1
                    Xe(Ln) = Xn: Ye(Ln) = Yn
                    Ln = Ln + 1
                END IF
            END IF
        NEXT
    END IF
    Ln(Ws) = Ln
    K$ = UCASE$(INKEY$)
    'Process the keystroke(if any)...
    IF K$ <> "" THEN
        SELECT CASE K$
            CASE "A"
                AtLoc = NOT AtLoc
            CASE "+"
                Mzm = Mzm + 2
            CASE "-"
                Mzm = Mzm - 2
            CASE "5"
                Mxm = 0: Mym = 0: Mzm = 0
            CASE "4"
                Mxm = Mxm - 2
            CASE "6"
                Mxm = Mxm + 2
            CASE "8"
                Mym = Mym - 2
            CASE "2"
                Mym = Mym + 2
            CASE "F"
                Speed = Speed + 5
            CASE "B"
                Speed = Speed - 5
            CASE "C"
                D1 = 0: D2 = 0
            CASE "S"
                Speed = 0
            CASE CHR$(0) + CHR$(72)
                D1 = D1 + 1
            CASE CHR$(0) + CHR$(80)
                D1 = D1 - 1
            CASE CHR$(0) + CHR$(75)
                D2 = D2 - 1
            CASE CHR$(0) + CHR$(77)
                D2 = D2 + 1
            CASE "Q", CHR$(27)
                SCREEN 0, , 0, 0
                CLS
                PRINT "By Rich Geldreich May 22, 1992"
                PRINT "See ya later!"
                END
            CASE "V"
                D1 = 0: D2 = 0: Deg1 = 0: Deg2 = 0: Speed = 0
        END SELECT
    END IF
    NumberOfFrames = NumberOfFrames + 1
    'see if 20 frames have passed; if so then see
    'how long it took...
    IF NumberOfFrames = 20 THEN
        TotalTime = PEEK(&H6C) - StartTime
        IF TotalTime < 0 THEN TotalTime = TotalTime + 256
        FramesPerSecX100 = 36400 \ TotalTime
        High = FramesPerSecX100 \ 100
        Low = FramesPerSecX100 - High
        'A$ has the string that is printed at the upper left
        'corner of the screen
        A$ = MID$(STR$(High), 2) + "."
        A$ = A$ + RIGHT$("0" + MID$(STR$(Low), 2), 2) + "  "
        NumberOfFrames = 0
        StartTime = PEEK(&H6C)
    END IF
LOOP
'The following data is the shuttle craft...
'stored as Start X,Y,Z & End X,Y,Z
DATA -157,22,39,-157,-18,39
DATA -157,-18,39,-127,-38,39
DATA -127,-38,39,113,-38,39
DATA 113,-38,39,193,12,39
DATA 33,42,39,33,42,-56
DATA 33,42,-56,-127,42,-56
DATA -127,42,-56,-157,22,-56
DATA -157,22,-56,-157,22,39
DATA -157,22,-56,-157,-18,-56
DATA -157,-18,-56,-157,-18,39
DATA -157,-18,-56,-127,-38,-56
DATA -127,-38,-56,-127,-38,39
DATA -127,-38,-56,113,-38,-56
DATA 113,-38,-56,113,-38,39
DATA 113,-38,-56,193,12,-56
DATA 193,12,-56,193,12,39
DATA -157,22,-56,193,12,-56
DATA 193,12,39,-157,22,39
DATA -56,-13,41,-56,-3,41
DATA -56,-3,41,-26,-3,41
DATA -26,-3,41,-26,7,41
DATA -51,7,41,-31,-13,41
DATA -11,-13,41,-11,-3,41
DATA -11,-3,41,-1,7,41
DATA 9,7,41,9,-8,41
DATA 9,-8,41,24,-8,41
DATA 34,16,41,34,-38,41
DATA 33,-39,41,33,-39,-53
DATA 33,-39,-53,33,15,-53
DATA -42,-38,19,-72,-38,19
DATA -72,-38,19,-72,-38,-41
DATA -72,-38,-41,-42,-38,-41
DATA -42,-38,-41,-42,-38,19
DATA 33,42,39,34,16,41
DATA 33,42,-56,33,15,-53
DATA -157,22,39,-127,42,39
DATA -127,42,-56,-127,42,39
DATA -127,42,39,33,42,39
DATA 159,-8,-56,159,-8,40
DATA 143,-18,-56,143,-18,39
DATA 193,12,39,193,32,30
DATA 33,42,39,193,32,30
DATA 193,32,30,193,32,-47
DATA 33,42,-56,193,32,-47
DATA 193,12,-56,193,32,-47
<PAGEEND:"3D.Info.File2">

<PAGESTART:"3D.Info.File3">
'Author: Peter Cooper
'Here's my take on the doom.bas program that was posted here a while ago.
'It's much clearer and more organized and a bit faster as well, I think,
'because a lot of unneccessary math has been eliminated.

DECLARE SUB CreateBackground ()
DECLARE SUB GetKeypress (Keycode%)

CONST UpArrow = -72, DnArrow = -80, LArrow = -75, RArrow = -77

RANDOMIZE TIMER
DIM Grid%(1 TO 12, 1 TO 12)
DIM STable!(0 - 31 TO 360 + 32), CTable!(0 - 31 TO 360 + 32)
PX! = 9: PY! = 11    'the starting coordinates of the player's location
Stride! = 3          'the distance covered in one "step" by the player
                     '   by pressing the up or down arrow keys
Heading% = 0         'the heading of the player (in degrees)
Turn% = 5            'number of degrees of rotation produced by
                     '   pressing the right or left arrow keys

FOR Y% = 1 TO 12
  FOR X% = 1 TO 12
    READ Grid%(X%, Y%)
  NEXT
NEXT

Factor! = (ATN(1) * 8) / 360
FOR A% = 0 TO 359
  Angle! = CSNG(A%) * Factor!
  STable!(A%) = SIN(Angle!) * .1
  CTable!(A%) = COS(Angle!) * .1
NEXT
FOR A% = -31 TO -1
  STable!(A%) = STable!(A% + 360)
  CTable!(A%) = CTable!(A% + 360)
NEXT
FOR A% = 360 TO 360 + 32
  STable!(A%) = STable!(A% - 360)
  CTable!(A%) = CTable!(A% - 360)
NEXT

SCREEN 7, , 0, 0
PRINT

PRINT
PRINT "            RAYCASTER DEMO"
PRINT
PRINT "      UP ARROW........Move Forward"
PRINT "      DOWN ARROW......Move Backward"
PRINT "      RIGHT ARROW.....Turn Right"
PRINT "      LEFT ARROW......Turn Left"
PRINT
PRINT
PRINT "            Please wait...";

CALL CreateBackground
BEEP
LOCATE , 1
PRINT "        Press any key to begin...";
DO WHILE LEN(INKEY$): LOOP: DO UNTIL LEN(INKEY$): LOOP

ViewPg% = 0: WorkPg% = 1: BG1% = 2: BG2% = 3
SCREEN , , WorkPg%, ViewPg%
GOSUB ComputeView

DO 'Main loop
CALL GetKeypress(Keycode%)
SELECT CASE Keycode%
  CASE LArrow
    Heading% = (Heading% + Turn%) MOD 360
    GOSUB ComputeView
  CASE RArrow
    Heading% = (Heading% + (360 - Turn%)) MOD 360
    GOSUB ComputeView
  CASE UpArrow
    NewPX! = PX! - (STable!(Heading%) * Stride!)
    NewPY! = PY! - (CTable!(Heading%) * Stride!)
    IF Grid%(NewPX!, NewPY!) = 0 THEN
      PX! = NewPX!: PY! = NewPY!
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      SOUND 80, 1
    END IF
  CASE DnArrow
    NewPX! = PX! + (STable!(Heading%) * Stride!)
    NewPY! = PY! + (CTable!(Heading%) * Stride!)
    IF Grid%(NewPX!, NewPY!) = 0 THEN
      PX! = NewPX!: PY! = NewPY!
      GOSUB ComputeView
    ELSE 'tried to walk through a wall
      SOUND 80, 1
    END IF
  CASE 27
    EXIT DO
  CASE ELSE
    BEEP
  END SELECT
LOOP
SCREEN 0: WIDTH 80, 25
END

ComputeView:
PCOPY BG1%, WorkPg%: SWAP BG1%, BG2%
X1% = 0
FOR A% = Heading% + 32 TO Heading% - 31 STEP -1
  StepX! = STable!(A%): StepY! = CTable!(A%)
  XX! = PX!: YY! = PY!
  L% = 0
  DO
    XX! = XX! - StepX!: YY! = YY! - StepY!
    L% = L% + 1
    K% = Grid%(XX!, YY!)
  LOOP UNTIL K%
  DD% = 900 \ L%
  H% = DD% + DD%
  DT% = 100 - DD%
  LINE (X1%, DT%)-STEP(4, H%), K%, BF
  X1% = X1% + 5
NEXT
SWAP WorkPg%, ViewPg%
SCREEN , , WorkPg%, ViewPg%

RETURN

' Level data
DATA  9,  1,  9,  1,  9,  1,  9,  1,  9,  1,  9,  1
DATA  1,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  9
DATA  9,  0,  2, 10,  0,  0,  0,  0,  0, 12,  0,  1
DATA  1,  0, 10,  2,  0,  0,  0,  0,  0,  4,  0,  9
DATA  9,  0,  0,  0,  0,  0,  0,  0,  0, 12,  0,  1
DATA  1,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  9
DATA  9,  0,  0,  0,  0,  7,  7,  0,  0,  0,  0,  1
DATA  1,  0, 13,  0,  0,  0,  0,  8,  0, 12,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  7,  0,  4,  0,  1
DATA  1,  0, 13,  0,  0,  0,  0,  8,  0, 12,  0,  9
DATA  9,  0,  5,  0,  0,  0,  0,  7,  0,  4,  0,  1
DATA  1,  9,  1,  9,  1,  9,  1,  9,  1,  9,  1,  9

SUB CreateBackground

SCREEN , , 2, 0: CLS
' Sky
LINE (0, 0)-(319, 99), 3, BF
' Clouds
FOR Cnt% = 1 TO 10
  X% = INT(RND * 320)
  Y% = INT(RND * 80) + 10
  R% = INT(RND * 50)
  AR! = RND / 10
  CIRCLE (X%, Y%), R%, 15, , , AR!: PAINT (X%, Y%), 15
NEXT
' Sun
CIRCLE (50, 30), 10, 14: PAINT (50, 30), 14, 14
' Building (gray)
LINE (200, 20)-(220, 15), 8
LINE (220, 15)-(240, 20), 8
LINE (200, 20)-(200, 99), 8
LINE (240, 20)-(240, 99), 8
LINE (200, 99)-(240, 99), 8
PAINT (220, 50), 8
FOR Cnt% = 1 TO 20 ' Lights
  PSET (INT(RND * 38 + 201), INT(RND * 80 + 20)), 14
NEXT
LINE (200, 20)-(220, 15), 0 ' Building (border)
LINE (220, 15)-(240, 20), 0
LINE (219, 15)-(219, 99), 0
LINE (200, 20)-(200, 99), 0
LINE (240, 20)-(240, 99), 0

PCOPY 2, 3
FOR Y% = 100 TO 199
  FOR X% = 0 TO 319
    IF RND AND 1 THEN PSET (X%, Y%), 6
  NEXT
NEXT

SCREEN , , 3, 0
FOR Y% = 100 TO 199
  FOR X% = 0 TO 319
    IF RND AND 1 THEN PSET (X%, Y%), 6
  NEXT

NEXT

SCREEN , , 0, 0

END SUB

DEFINT A-Z
SUB GetKeypress (Keycode%) STATIC
DO: Ky$ = INKEY$: LOOP UNTIL LEN(Ky$)
Keycode% = ASC(Ky$): IF Keycode% = 0 THEN Keycode% = -ASC(MID$(Ky$, 2, 1))
END SUB
<PAGEEND:"3D.Info.File3">

<PAGESTART:"3D.Info.File4">
*****************************************************************************
*                       'Doom' 3D Engine techniques                         *
*****************************************************************************
By Brian 'Neuromancer' Marshall
(Email: brianm@vissci.demon.co.uk)

        This document is submitted subject to certain conditions:

1. This Document is not in any way related to Id Software, and is 
   not meant to be a representive of their techniques : it is based
   upon my own investigations of a realtime 3d engine that produces
   a screen display similar to 'Doom' by Id software.

2. I take no responsibility for any damange to data or computer equipment
   caused by attempts to implement these algorithms.

3. Although I have made every attempt to ensure that this document is error
   free I take no responsability for any errors it may contain.

4. Anyone is free to use this information as they wish, however I would
   appreciate being credited if the information has been useful.

5. I take no responsability for the spelling or grammar.
   (My written english is none too good...so I won't take offence
    at any corrections: I am a programmer not a writer...)

        Right now that that little lot is out of the way I will start this
document proper....

1:  Definition of Terms
======================

        Throughout this document I will be making use of many graphical terms
using my understanding of them as they apply to this algorithm. I will
explain all the terms below. Feel free to skip this part....

Texture:
        A texture for the purpose of this is a square image.

U and V:
        U and V are the equivelants of x and y but are in texture space.
ie They are the the two axies of the two dimensional texture.

Screen:
        For my purposes 'screen' is the window we wish to fill: it doesn't
have to be the whole screen.

Affine Mapping:
        A affine mapping is a texture map where the texture is sampled
in a linear fashion in both U and V.

Biquadratic Mapping:
        A biquadratic mapping is a mapping where the texture is sampled
along a curve in both U and V that approximates the perspective transform.
This gives almost proper forshortening.


Projective Mapping:
        A projective mapping is a mapping where a changing homogenous
coordinated is added to the texture coordinateds to give (U,V,W) and
a division is performed at every pixel. This is the mathematically and
visual correct for of texture mapping for the square to quadrilateral
mappings we are using.
        (As an aside it is possible to do a projective mapping without
the divide (or 3 multiplies) but that is totally unrelated to the matter
in hand...)

Ray Casting:
        Ray Casting in this context is back-firing 'rays' along a two
dinesional map. The rays do however follow heights... more on that later

Sprite:
        A Sprite is a bitmap that is either a monster or an object. To
put it another way it is anything that is not made out of wall or
floor sectins.

Sprite Scaling:
        By this I mean scaling a bitmap in either x or y or both.

Right... Now thats over with onto the foundation:

2:   Two Dimensional Ray Casting Techniques
===========================================

        In order to make this accessible to anyone I will start by
explaining 2d raycasting as used in Wolfenstein 3d style games.

  2.1: Wolfenstien 3D Style Techniques...
  =======================================

          Wolfenstein 3d was a game that rocked the world (well me anyway!).
  It used a technique where you fire a ray accross a 2d grid based map to
  find all its walls and objects. The walls were then drawn vertically
  using sprite scaling techniques to simulate texture mapping.

          The tracing accross the map looked something like this;


        =============================================
        =   =   =   =   =   =  /=   =   =   =   =   =
        =   =   =   =   =   = / =   =   =   =   =   =
        =   =   =   =   =   =/  =   =   =   =   =   =
        ====================/========================
        =   =   =   =   =  /=   =   =   =   =   =   =
        =   =   =   =   = / =   =   =   =   =   =   =
        =   =   =   =   =/  =   =   =   =   =   =   =
        ================/============================
        =   =   =   =  /#   =   =   =   =   =   =   =
        =   =   =   = / #   =   =   =   =   =   =   =
        =   =   =   =/  #   =   =   =   =   =   =   =
        ============/===#########====================
        =   =   =  /=   =   =   #   =   =   =   =   =
        =   =   = / =   =   =   #   =   =   =   =   =
        =   =   =/  =   =   =   #   =   =   =   =   =
        ========/===============#====================
        =   =  /=   =   =   =   #   =   =   =   =   =
        =   = P =   =   =   =   #   =   =   =   =   =
        =   =  \=   =   =   =   #   =   =   =   =   =
        ========\===============#====================
        =   =   =\  =   =   =   #   =   =   =   =   =
        =   =   = \ =   =   =   #   =   =   =   =   =
        =   =   =  \=   =   =   #   =   =   =   =   =
        ============\=======#####====================
        =   =   =   =\  =   #   =   =   =   =   =   =
        =   =   =   = \ =   #   =   =   =   =   =   =
        =   =   =   =  \=   #   =   =   =   =   =   =
        ================\===#========================
        =   =   =   =   =\  #   =   =   =   =   =   =
        =   =   =   =   = \ #   =   =   =   =   =   =
        =   =   =   =   =  \#   =   =   =   =   =   =
        =============================================

        (#'s are walls, = is the grid....)

        This is just a case of firing a ray for each vertical
  line on the screen. This ray is traced accross the map to
  see where it crosses a grid boundry. Where it crosses a
  boundry you cjeck to see if there is a wall there we see how
  far away it it and draw a scaled vertical line from the texture
  on screen. The line we draw is selected from the texture by
  seeing where the line has intersected on the side of the square it
  hit.
        This is repeated with a ray for each vertical line on the
  screen that we wish to display.
        This is a very quick explaination of how it works missing
  out how the sprites are handled. If you want a more detailed 
  explaination then I suggest getting acksrc.zip from
  ftp.funet.fi in /pub/msdos/games/programming

        This is someone's source for a Wolfenstien engine written
  in Borland C and Assembly language on the Pc.
        Its is not the fastest or best but has good documentation
  and solves similiar sprite probelms, distance probelms and has
  some much better explaination of the tracing technique tahn I have
  put here. I recommend to everyone interested taht you get a copy
  and have a thorough play around with it.
  (Even if you don't have a Pc: Everything but the drawing and video
   mode setting is done in 'C' so it should not be too hard to port
   ....)

 
  2.2 Ray Casting in the Doom Environment
  =======================================

        When you look at a screen from Doom you see floors, steps
  walls and lots of other trappings.
        You look out of windows and accross courtyards and you
  say WOW! what a great 3d game!!
        Then you fire your gun a baddie who's in line with you but
  above you and bang! he's a corpse.
        Then you climb up to the level where the corpse is and look
  out the window to where you were and you say Gosh! a 3d game!!

        Hmmm....

        Stop gawping at the graphics for a minute and look at the map
  screen. Nice line vectors. But isn't the map a bit simple???
        Notice how depite colours showing you that there are different
  heights. Then notice that despite the fact that there is NEVER a
  place where you can exist on two different levels. Smelling a little
  2d yet???
        Look where there are bridges (or sort of bridges) : managed to
  see under them yet??

        The whole point to this is that Doom is a 2D games just like
  its ancestor Wolfenstein but it has rather more advanced raycasting
  which does a very nice job of fooling the player into thinking its a
  3d game that shifting loads of polygons and back-culling, depth
  sorting etc... 

        Right the explaination of how you turn a 2d map into the 3d
  doom screen is complex so if you are having difficulty try reading
  it a few times and if all else fails mail me....


  2.3 What is actually done!
  ==========================

        Right to start with the raycasting is started in the same
  way as Wolfenstien. That is find out where the player is in the 2d
  map and get a ray setup for the first vertical line on the screen.

        Now we have an extra stage from the Wolfenstein I described
  whcih involves a data srtucture that we will use later to actually
  draw the screen.

        In this data structure we start the ray off as at the bottom
  of the screen. This is shown in the diagram below;

        =================================
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =*                              =
        =================================


        Where the '=' show the boundry of the screen and '*' is the virtual
  position of the ray.

        Note: the Data structure is really two structures:
        One which is a set of list for each vertical 'scanline' and
        One which is a corresponding list for horizontal scanlines.

        Now we start tracing the ray. We skip accross the 2d map until
  we hit something interesting. By something interesting I mean something
  that is an actual wall or florr section edge.
        Right we have hit the edge of either a floor or wall section.
  We have several things to do know. These are;

        If it was a wall we hit:

  1: Find out how 'high' of screen this section of wall should be
     due to the distance it is accross the 2d map.
  2: Find out at what 'virtual height' it is: This is so that we can see
     where in the vertical scanline in comes for testing where to insert
     it and for clipping it.
  3: Test in our structure to see if you draw it or not.
     (This is done so that you can look through windows : how this works
      will become apparent later.)
  4: If any of the wall segment is visible then we find out where along
     the texture we have hit it and write into the structure the area of
     the screen it takes up as well as the texture, the point where we
     have hit the texture and the size it should be on screen. (This is
     so that we can draw it correctly even if the whole span is not on
     screen.


        If it was a floor section that we hit:

  1: Find out where on the vertical line we are working the floor section
     that the ray has hit is. (We know the height of the the floor in the
     virtual map (2d) and we know the height of the player and the distance
     of the floor square from the player so it is easy).
     As a side effect of this we now know the U,V value where the ray has
     hit the floor square.

  2: Trace Accross the floor square till we hit the far edge of the floor
     square : we then workout where this is on the vertical scanline using
     the same technique as above. We now know the vertical span of the
     floor section, and where on the span it is.

                                                                               3: We check to see if the span is visible on the vertical span.
     If it is or part of it is used then we mark that part of the vertical
     scanline as used.
     We also have to make use of the horizontal buffer I mentioned. We
     insert into this in 2 places. The first is the x coordinate of where
     we hit the floor square into the y line where we where on the screen.
     Phew got that bit?? We also insert here the U,V value which we knew 
     from the tracing. (I told you we'd need it later....)                                                                


        As you can see there's a little more to hiting a floor segment than
a wall segment. Also note that a you exit a floor segment you may also hit
a wall segment.

        Tracing the individual ray is continued until we hit a special kind
of wall. This wall is marked as a wall that connects to the ceiling.
This is one place to stop tracing this ray. However we can stop tracing early
if we have found enough to fill the whole vertical scanline then we can stop
whenevr we have done this.

        Next come a trick. I said we were tracing along a 2d map. Well I
lied a bit. There are (In my implementation at least..) TWO 2d maps. One is
basically from the floor along including all the 'floor' walls and everything
up to and including the walls that join onto the ceiling. The other map
is basically the ceiling (with anything coming down from the ceiling on it
if you are doing this: this makes life a little more complex as I'll explain
below..)
        Now when we have traced along the bottom map and hit a wall that 
connects to the ceiling then we go back and trace along the ceiling from
the start to fill in the gaps. There is a problem with this however.
The problem is when you have things like a monolith or something else built
out of walls jutting down from the ceiling. you have to decide whether to
draw it or draw whatever was already in the scanline structure. This means
either storing extra information in the buffer ie z coordinates or tracing
along both the ceiling and floor at the same time.... for most people I would
suggest just not having anything jutting down from the ceiling.
        Also you could trace backwards instead of starting a new ray. This 
would be fasterfor many cases as you wouldn't be tracing through lots
of floor squares that aren't on screen. By tracing backwards you can keep
going up the vertical scanline and you know that you are on the screen. As
soon as something goes off the top of the screen you can handle that and then
stop tracing.

        Phew. has everyone got that???

        Now we just go back and fire rays up the rest of the vertical
scanlines. Easy!!???

        At the end of this lot we have the necessary data in the two buffers
to go back and draw the screen background.
(There is one more thing done while tracing but I'll explain that later...)


        Oh... one other thing... you have may want to change the raycasting
a bit to subdivide the map... it helps with speed.
        And don't forget the added complexity that walls aren't all at
90 degrees to each other...

3: Drawing the walls and Why it works!!
=======================================

        If you are familiar with Wolfenstein then please still read this
as it is esential background to understanding the floor routine.


        As all of you probably know the walls are drawn by scaling the line
of the texture to the correct size for the screen. The information in the
vertical buffer makes this easy. What you probably don't know is why this
creates texture mapping that is good enough to fool us.

        The wall function is a Affine texture mapping. (well almost)
Now affine texture mappings look abysmal unless you do quite a lot of
subdivision (The amount needed varies according to the angle the projected
square is at.). So why does the Doom technique work??

        Well when we traced the rays we found out exactly where along the
side of the square we hit we were in relation to the width of the texture.
This means that the top and bottom pixels of the scaled wall piece are
calculated correctly. This means that we have effecively subdivided the
texture along vertical scanlines and as the effective subdidvisons are
calculated exactly with proper forshortening as a result of the tracing.
So the ray casting has made the texture mapping easy for us.
        (We have enough subdivision by this scanline effect as the wall
only rotates about one axis and we have proper foreshortening.)

        This knowlege helps us understand how to do the floors and why
that works.

        We can now draw all the wall segments by just looking at the buffer
and drawing the parts marked as walls.(Skiping where we put in the bits used
by the floor/ceiling bits: we draw them later.)

4:  Drawing the Floor/Ceiling and why it works!
===============================================

        If you have grasped why the walls work then you have just about
won for the floors.
        We have the information needed to draw the floors from the horizontal
buffer.
        All we have to do is look at the horizontal spans in the buffer
and draw them in all.
        Each of these spans has 2 end coordinates for which we have
exact texture coorinates. This tells us which line across the texture
we have to step along to do an Affine or linear mapping.
        This is shown below;


        =================================
        =                               =
        =                               =
        =                               =
        =                               = U1,V1 (exit)
        =                              **
        =                           *** =
        =                        ***    =
        =                     ***       =
        =                  ***          =
        =               ***             =
        =            ***                =
        =         ***                   =
        =       **                      =
        =     **                        =
        =   **                          =
        = **                            =
  U0,V0 **                              =
(entry) =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =                               =
        =================================

(apologies for the wonky line: it should be straight!!)

        Now...as the end coordinates are correct and the axis along
which forshortening takes place is not involved (this is a fudge)
we can step linearly along this line across the texture to approximate
the mapping. (This is far easier than a proper texture map).
        This is effectivly a wall lying on its side which works as the
texture coordinates at the ends of the span have been calculated correctly.
This is a benefit of the raycasting we used to find everything.
        Easy huh??


5: Sprites
==========

        The Sprites are really quite easy to do. The basic technique is the
same as used in Wolfenstein 3d.
        This is done as follows:

When you enter a 'square' on the floor map you test to see if there are
any sprites in the square. If there are you flag that sprite as visible
and add it to a list of visible sprites.

When you have finished tracing and drawing the walls and floor you
depth sort the sprites and draw them from the back to the front. (painters
algorithm). The only complication in drawing them is that you have to check 
buffer that has the walls in, in order to clip the sprites correctly.

        (If you're interested in Doom you can occasionally see large 
explosions (ie BFG) slip partially behind a wall segment.)

        On possibly faster way of handling the sprites would be to mark
them like wall segments as you find them in the buffer. The only (ONLY!)
complication to this approach is that sprites can have holes in them. By
this I mean things like the gap between an arm and a leg which should be 
the background colour.


6: Lighting and Depth Cueing
============================

        Lighting and Depth Cueing fits nicely in with the way that we have
prepared the screen ready for drawing.
        All we have to do is see how far away we are when we found either
the floor or wall section and set the light level according to the distance.
        The other thing that is applied is a light level. This is taken from
the map at the edges where you have hit something. As the map is 2D it is
easy to manage lighting, flickering etc.
        For things like pools of light on the floor all you have to do
is subdivide that patch of floor so that you can set the bit under the 
skylight to a lighter colour. Its also very easy to frig this for the
lighting goggles.


7: Controlling the Baddies
==========================
        

        This is pretty easy: all you have to think about is moving and
reacting on a 2d map. the only complications are things like the monsters
looking through windows and seeing a player but this all degenerates into
a simple 2d problem. Things like deciding whether the player has been hit or
has he/she hit a monster is just another case of firing a ray. (Or do it
another way...)


8: Where next???
================

        Thats all folks... hopefully a useful and intersting insight into
my Doom engine works.
        As to the question where next... well I already have some enhancements
to my Doom enigine and others are in the works...

Some of what you may eventually see are:

        Proper lighting (I have done this already...its easier than you
                        think)
        Non-Vertical walls (i.e. Aliens style corridors...)
        Orgranic Walls (i.e. Curved like the Aliens nest...)
        Fractal Landscapes (This one is still very much a theory but how
                        about being able to go outside and walk up and down
                        hills etc??)

        If there are bits people are really shaky about I may post a new
version of this... but I cannot get into implimentation issues as all
implementation work is under copyright...

        By the way if anyone out there implements this I'd love to here
how you get on...

        Anyone got any comments or any other interesting algorithms???

Brian 'Neuromancer' Marshall        'When do graphics not look like graphics?
( Email: brianm@vissci.demon.co.uk ) :when we get it RIGHT.'
<PAGEEND:"3D.Info.File4">

<PAGESTART:"3D.Info.File5">
______________________________________________________________________________
| 3D Programming  |
~~~~~~~~~~~~~~~~~~~
    --------------------------------------------
  /                                           / |
 ---------------------------------------------  |
 3D Graphics in BASIC - Part I.1: Introduction /
 ---------------------------------------------


HEY YOU !

Interrested in programming vector graphics ? Bored of painting 2 dimensional
diagrams. Feared of using C/C++ ? Or are you a math dummie ? 

No panic.

Spend some time (and of course even more time at your PC) with me and join 
me into the wonderful world of ...

        3D Graphics in BASIC (yep, it's possible !!!)


Before I fill your brain with lot of stuff like vectors, matrix, filled 
polygons or shading techniques in the next five parts (this text included), 
I'll introduce me to my person:

I'm Christian Garms, a german chemistry student and programmer. Last year 
I've made some nice money with Visual Basic programs in MS Excel and that's 
why I think BASIC is the opposite of a dead programming language. I'm a
registered PB user but the examples that will be post in this article should
work with both QB and PB (eventually with minor modifications).

For questions, REMarks or comments send an e-mail to:

        garms@chemie.uni-hamburg.de


I assume that you're not a BASIC beginner. Hope that you're at least an 
advanced programmer because this article is not a bedtime story. 

But the sweetest fruits are hidden and hard to get.

Most programs will do the trick without any assembly additives to speed up 
the code. If x86-ASM is necessary I'll write it as INLINE Assembler. 
Sorry QB Users but I have not much time to spend for converting INLINE code 
into suitable OBJ-Files.


************************************************************************
Disclaimer:
The author, Christian Garms, is not responsible for any errors or damage
to your computer system caused by the posted BASIC programs. 
The BASIC programs and snippets are free for any use.
************************************************************************



    ------------------------------------------------
  /                                              / |
 ------------------------------------------------  |
 3D Graphics in BASIC - Part I.2: some basic math /
 ------------------------------------------------

The hardest part to understand of 3D graphics is the mathematical background 
that is - politely spoken - abstract.
But lets begin with an easier entry point. Point - that is the right object
to start with. In our three dimensional world all points consist of three
components, the x-, y- and z-coordinate. With these values every point is
strongly determined in his position. But to whom ?
That is the next thing to be dealt with: Coordinate systems ! 
For the beginning we start with only one coordinate system, the world 
coordinates. That means all coordinates are related to an absolut center 
somewhere in our real world. E.g.: a value of x = 0 , y = 0 and z = 0 define 
a point exactly in the center of our world. 

For a mathematician every point in the whole 3D world is a vector. That's why
3D graphics is also called vector graphics. 
If we had a point Z who lies in the center of our world than the definition 
of Z will be:

        Z = (0 0 0)

Any other point P with unequal values to zero of x-, y-, and z-coordinates
would look like:

        P = (<x> <y> <z>)

The letters in the brackets are placeholders for the corresponding values.
OK, lets return from the equation thicket to programming.
For further use we should define our own TYPE of variable, a vector !

**************************************************************************
' Creating own definition
TYPE vector
  x AS INTEGER
  y AS INTEGER
  z AS INTEGER
END TYPE

' Declare p as vector
DIM p AS vector

' Sets p to the center of the world
p.x = 0
p.y = 0
p.z = 0
**************************************************************************
Listing I-2.1

Listing I-2.1 demonstrates the usage of user-defined types. User-defined 
types makes your programs more structured and better understandable 
than Listing I-2.2.
Especially when you have more than one point !
As you can see I'm using mostly integer arithmetics. That is a common trick 
to speed up the output of 3D graphics enormously.


**************************************************************************
' Define point in the middle of the universe
px% = 0
py% = 0
pz% = 0
**************************************************************************
Listing I-2.2



    ------------------------------------------------
  /                                              / |
 ------------------------------------------------  |
 3D Graphics in BASIC - Part I.3: transformations  /
 ------------------------------------------------

Now we have the simpliest object: a point. The next question is: How to 
convert a point in our 3D world - or mathematically spoken a vector - into  
a flat pixel on the screen. 
So here comes the moment to introduce you with a new coordinate system - the 
eye coordinate system. I think that you, dear reader, will ask WHY. Well,
imagine a scenery from any 3D game you have in mind. In most cases of these
games there is a craft that you fly, drive or move and others that will be
steered by your computer or someone else. You can look in all directions
without steering into this directions. This would be impossible if your
eye coordinate system is non-existant. In other words: The eye coordinate 
system allows watching different from the world coordinate systems.
And now the strategy to convert a point into a pixel:

        1. Transformation of the world coordinates into eye coordinates

        2. Transformation of eye coordinates into screen coordinates

But some mathematics first. I hope you've got your machet right by your
hand and follow me again into the equation jungle. This time it will be 
harder than last time.

Mathematicians are sometimes lazy to write complex formulas. In the case of
transformation of a vector to a new vector in another coordinate system like
the transformation of the world coordinate system into the eye coordinate
system they simply write:

        P_eye = P_world * T

with    P_eye           eye coordinate vector
        P_world         world coordinate vector
        T               Transformation operator

That means: transformation of coordinates is only a "simple" mathematical
operation. But I would not go any further now because I've saved that for 
Part II.
This time I'll explain the transformation by an example. Once again
you must imagine to sit in a craft in our virtual 3D game. Say you're at 
Position x=100, y=0, z=0 and look to the center of our world. If you've 
reset your nav computer and set the absolute position (0 0 0) to your craft 
(the eye coordinate system) the center of the world now lies at 
x=-100, y=0, z=0.
In Summary: the world coordinates of a point will transformed to 
eye coordinates via the following equations:

        x_eye = x_world - eyepos_x
        y_eye = y_world - eyepos_y
        z_eye = z_world - eyepos_z

with    x_eye           x-coordinate of the point (eye coordinate system)
                        dito with y_eye, z_eye
        x_world         x-coordinate of the point (world coordinate system)
                        dito with y-world, z_world
        eyepos_x        position of the watcher (relative to world center)
                        dito with eyepos_y, eyepos_z 

But we gained also a three-dimensional point. How to convert this one into
a pixel? Now the mathematician comes in action. And he won't be lazy any
more ! He will tell you something about triangles, pyramids ... and you're
stuck complete helpless in the thickest formula thicket you could 
think about. If there would be a chalkboard he would easily write it full 
just for explanations. Simple, isn't it ?

Instead of molto formulos there is THE golden wisdom of every 3D-Programmer:
  "The screen coordinates could be calculated by dividing the x- and y-
   position through the depth (z-coordinate)"

In formula speak:

        x_screen = x_eye / z_eye
        y_screen = y_eye / z_eye

with    x_screen        x-coordinate of the pixel
        y_screen        y-coordinate of the pixel
        x_eye, y_eye,   see above
        z_eye

You gain a dimensionless number that must be fit to screen coordinates and 
to the middle of the screen. 
I assume that the width and the height of the screen are given so the formula
results to:

        x_screen = (x_eye / z_eye) * width + width / 2
        y_screen = (y_eye / z_eye) * height + height / 2

Now we've got all parts together to write some real 3D stuff.

**************************************************************************
' Simple 3D Object (Pyramid)

' Type declarations
TYPE vector
  x AS INTEGER
  y AS INTEGER
  z AS INTEGER
END TYPE

TYPE pixel
  x AS INTEGER
  y AS INTEGER
END TYPE

' Variable declaration
DIM p(3) AS vector
DIM eye AS vector
DIM s(3) AS pixel
DIM maxx AS INTEGER     ' width of screen
DIM maxy AS INTEGER     ' height of screen

' Screen resolution 
maxx = 640
maxy = 480 

' Read Object Data
FOR i = 0 TO 3
  READ p(i).x
  READ p(i).y
  READ p(i).z
NEXT i

' Definition of object
DATA 30, 1, 1
DATA  1,30, 1
DATA  1, 1,30
DATA -30,-30,-30

' Set Eye position (change if desired)
eye.x = 0
eye.y = 0
eye.z = 100

' Calculate the eye coordinates
FOR i = 0 TO 3
  p(i).x = p(i).x - eye.x
  p(i).y = p(i).y - eye.y
  p(i).z = p(i).z - eye.z
NEXT i

' Calculate screen coordinates
FOR i = 0 TO 3
  s(i).x = (p(i).x / p(i).z) * maxx + maxx / 2
  s(i).y = (p(i).y / p(i).z) * maxy + maxy / 2
NEXT i

' Draw object
CLS
SCREEN 12
FOR i = 0 TO 5
  READ pt1, pt2
  LINE (s(pt1).x,s(pt1).y)-(s(pt2).x,s(pt2).y)
NEXT i

DATA 0, 1, 0, 2, 0, 3, 1, 2, 1, 3, 2, 3
**************************************************************************
Listing I-3.1

OK, folks. Next time I will introduce you to animated vector graphics and
the calclulation with matrix. Stay tuned and I hope that you enjoy this article.

______________________________________________________________________________
<PAGEEND:"3D.Info.File5">

<PAGESTART:"3D.Info.File6">
______________________________________________________________________________
| 3D Programming  |
~~~~~~~~~~~~~~~~~~~

    ---------------------------------------
  /                                      / |
 ----------------------------------------  |
 3D Graphics in BASIC - Part II.1: Epilog /
 ----------------------------------------
   
It sounds strange to begin with an epilog but I have to explain some real
important things about the listing PYRAMID.BAS in the last part:

1. You only have to calculate the edges of a polygon. In the case of the 
pyramid you only have to calculate FOUR (!!!) points. The rest will do the
LINEs. This is very good because it reduces the amount of calculations to
a minimum and also, of course, the amount of cpu usage.

2. You must have an exact represantation of your 3D object. In our case
of the pyramid this is very simple. There are only four points. The 
definition of the object is located in the DATAs. You need in general a
DATA statement for the points and a DATA statement for the connectivity list.
The connectivity list will instruct the program to draw the right lines to
the right points.
You must determine every edge exactly of any given 3d object you want to 
display. This is very time consuming and you can only create smaller objects
with a pencil and a paper sheet. For 'bigger' objects (more points) you need 
a special editor.


    -----------------------------------------------
  /                                              / |
 ------------------------------------------------  |
 3D Graphics in BASIC - Part II.2: 3D Animations  /
 ------------------------------------------------
   
In PYRAMID.BAS there is only one single picture of a simple object.

Boring, isn't ?

The real 3D effect will only show up if the object will be animated like 
rotating around an axis or moving in real time. So I want you to show
how to get this 'pyramid' into action.

But tons of theory first ...

To make understanding easier for this relative difficult subject because
this part is like "Formula Jones and The Raiders of the lost Arc" and you
could be easily get lost somewhere in the Amasinus I'll give you an
overview of what to do:

1. 3D animations - and of course, animations in general - need the double
buffering technique. That's a common used method of displaying and
generating pictures simultaneously on different screen (often done by
choosing different memory locations of the displaying screen and the
drawing screen).
If you would display and draw the picture on the same screen (the same
memory location), the picture might become flickery. With the double
buffering technique - and eventually waiting for the vertical retrace
interrupt - the animated graphics looks very smooth.

2. Rotating, Scaling and Moving of 3D points could be done with matrix
operations. Because matrix operations aren't a simply matter of fact at all
I'll explain it here in this article but limited for our purpose.
When you've worked through this stuff (it's a very thick formula thicket -
have you got your machet right by your hand ?) you will see the advantages
of this mathematical technique.


    -------------------------------------------------
  /                                                / |
 --------------------------------------------------  |
 3D Graphics in BASIC - Part II.3: Double Buffering /
 --------------------------------------------------

Double buffering is a simple matter of fact. You only need two screens or
pages in any location of the memory. The Video ram is mostly preferred
because of higher perfomance (you must not copy the pages to the video ram
from the memory anymore).
A general algorithm for the Double Buffering technique is as follows:

        1. Show the "display" page, hide the "draw" page
        2. Clear "draw" page
        3. Various Drawing operations in the "draw" page
        4. Wait for vertical rectrace
        5. Switch "display" and "draw" page

The listing II-3.1 is in example for a simple demo of double buffering.
The compiled program will show a rectangle that has four moving corners
with different speed and direction.

**************************************************************************
' Double Buffering Demo
' (C)) 1996 by Ch. Garms


' Type declarations

TYPE pixel
  x AS INTEGER
  y AS INTEGER
END TYPE


' Some Constants

%NOPE = 0
%UP = 1
%DOWN = 2
%PORT = 4
%STARBORD = 8


' Variable declarations

DEFINT a-z
DIM r(3) AS pixel       ' rectangle points
DIM d(3) AS pixel       ' direction increment / decrement


' Screen dimensions

%MAXX = 639
%MAXY = 349


' Init the random generator with a different value

RANDOMIZE TIMER


' Sub: Switch Drawing / Displaying Screen

SUB switchscreen
  STATIC drawing, display

  IF drawing = display THEN
    drawing = 0
    display = 1
  ELSE
    SWAP drawing, display
  END IF
  WAIT &H3DA, 8 ' wait for vertical retrace
  SCREEN 9, 0, drawing, display
END SUB


' Sub: Draw rectangle

SUB rectangle
  SHARED r()

  LINE ( r(0).x, r(0).y ) - ( r(1).x, r(1).y ), 11
  LINE ( r(1).x, r(1).y ) - ( r(2).x, r(2).y ), 11
  LINE ( r(2).x, r(2).y ) - ( r(3).x, r(3).y ), 11
  LINE ( r(3).x, r(3).y ) - ( r(0).x, r(0).y ), 11
END SUB


' Sub: Calculate new points

SUB newpoints
  SHARED r(), d()
  LOCAL i, bounds

  FOR i = 0 TO 3
    bounds = boundcheck( r(i), d(i) )
    SELECT CASE bounds
      CASE ( %UP OR %PORT )
        r(i).x = 0
        r(i).y = 0
        d(i).x = -d(i).x
        d(i).y = -d(i).y
      CASE ( %UP OR %STARBORD )
        r(i).x = %MAXX
        r(i).y = 0
        d(i).x = -d(i).x
        d(i).y = -d(i).y
      CASE ( %DOWN OR %PORT )
        r(i).x = 0
        r(i).y = %MAXY
        d(i).x = -d(i).x
        d(i).y = -d(i).y
      CASE ( %DOWN OR %STARBORD )
        r(i).x = %MAXX
        r(i).y = %MAXY
        d(i).x = -d(i).x
        d(i).y = -d(i).y
      CASE %UP
        r(i).x = ( -r(i).y * d(i).x ) / d(i).y + r(i).x
        r(i).y = 0
        d(i).y = -d(i).y
      CASE %DOWN
        r(i).x = ( ( %maxy - r(i).y ) * d(i).x ) / d(i).y + r(i).x
        r(i).y = %MAXY
        d(i).y = -d(i).y
      CASE %PORT
        r(i).y = d(i).x / d(i).y * -r(i).x + r(i).y
        r(i).x = 0
        d(i).x = -d(i).x
      CASE %STARBORD
        r(i).y = d(i).x / d(i).y * (%maxx - r(i).x) + r(i).y
        r(i).x = %MAXX
        d(i).x = -d(i).x
      CASE %NOPE
        INCR r(i).x, d(i).x
        INCR r(i).y, d(i).y
    END SELECT
  NEXT i
END SUB


' Function boundcheck:
' Check if pixel left the frontiers of the screen

FUNCTION boundcheck(pt AS pixel, dir AS pixel) AS INTEGER
  LOCAL work

  work = %NOPE
  SELECT CASE pt.y + dir.y
    CASE < 0
      INCR work, %UP
    CASE > %MAXY
      INCR work, %DOWN
  END SELECT
  SELECT CASE pt.x + dir.x
    CASE < 0
      INCR work, %PORT
    CASE > %MAXX
      INCR work, %STARBORD
  END SELECT
  boundcheck = work
END FUNCTION


' Initializing the 2D object and the directions increments/decrements
' Just a few random numbers ...

FOR i=0 TO 3
  r(i).x = %MAXX * RND(1)
  r(i).y = %MAXY * RND(1)
  WHILE d(i).x = 0
    d(i).x = 4 - 8 * RND(1)
  WEND
  WHILE d(i).y = 0
    d(i).y = 4 - 8 * RND(1)
  WEND
NEXT i


' Main Program
' Calling the SUBs and waiting for a key

WHILE NOT INSTAT
  switchscreen                  ' Show screen
  CLS                           ' Clear the screen
  rectangle                     ' Drawing rectangle
  newpoints                     ' Calculate the new points
WEND
**************************************************************************
Listing II-3.1

If you change the main program to the one described in Listing II-3.2
then you will see why it's necessary to flip pages. The aninamtion of the
rectangle will become flickery. So that's why page flipping is important
for any type of animation.

**************************************************************************
' modified Main program
' actually it didn't flip the pages anymore ...

SCREEN 9
WHILE NOT INSTAT
  CLS                           ' Clear the screen
  rectangle                     ' Drawing rectangle
  newpoints                     ' Calculate the new points
WEND
**************************************************************************
Listing II-3.2: RECTANGLE.BAS


    -------------------------------------------------
  /                                                / |
 --------------------------------------------------  |
 3D Graphics in BASIC - Part II.4: 3D Object moving /
 --------------------------------------------------

Moving - or also called: translation - of an object is done by changing
the coordinates of the object. Let's start with a simple example: a point
in the 3D world. Moving the point could be done by:

        1. changing the points coordinates:

        obj.x = obj.x + t.x
        obj.y = obj.y + t.y
        obj.z = obj.z + t.z

        With (obj.x/obj.y/obj.z) = 3D point and (t.x/t.y/t.z) =
        translation vector. The translation vector describes how much a
        point is moved in any direction (x,y,z).

        or (very important !)

        2. changing the viewers coordinates:

        eye.x = eye.x + t.x
        eye.y = eye.y + t.y
        eye.z = eye.z + t.z

        With (eye.x/eye.y/eye.z) = viewers' point

The result will be the same: The point will be moved. That's the same
phenomon as if we watched the sunrise. Not the sun is going up but our
planet earth is rotating around his polar axis. We know that the earth is
moving but it looks like the sun is moving.
The listing II-4.1 is the modified example of the last part - PYRAMID.BAS.
Now it shows some motion. The pyramid is bouncing (in fact the viewpoint
is moving) to the viewer and away from him/her.

**************************************************************************
' ---------------------
'   Moving Pyramid
' based on PYRAMID.BAS
' (C) 1996 by Ch. Garms
' ---------------------


' Compiler Instructions

$CPU 80386
$OPTIMIZE SPEED
$LIB GRAPH ON
$ERROR ALL ON
$COMPILE MEMORY


' Creating new TYPEs

TYPE vector
  x AS INTEGER
  y AS INTEGER
  z AS INTEGER
END TYPE

TYPE pixel
  x AS INTEGER
  y AS INTEGER
END TYPE


' Variable declarations

%MAXPT = 3                      ' max. points
%MAXLN = 5                      ' max. lines
DIM s(%MAXPT) AS pixel          ' 2D coordinates of Pyramid
DIM eye AS vector               ' viewpoint
DEFINT a-z


' Initializing screen constants

%MAXPOSX = 639                  ' max. X-coordinate of screen
%MAXPOSY = 349                  ' max. Y-coordinate of screen
%CENTERX = 320                  ' center of screen (X-position)
%CENTERY = 175                  ' center of screen (Y-position)


' Initializing Viewpoint

eye.x = 15
eye.y = 15
eye.z = 0


' Calculating the eye coordinates & transformation into screen pixels

SUB vec2pix( objpt AS vector, scrpix AS pixel )
  SHARED eye

  DECR objpt.x, eye.x
  DECR objpt.y, eye.y
  DECR objpt.z, eye.z

  scrpix.x = (objpt.x / objpt.z) * %MAXPOSX + %CENTERX
  scrpix.y = (objpt.y / objpt.z) * %MAXPOSY + %CENTERY
END SUB


' Switch screens:
' implementation for PB's SCREEN

SUB switchscreen
  STATIC display, drawing

  IF display = drawing THEN
    display = 0
    drawing = 1
  ELSE
    SWAP display, drawing
  END IF

  WAIT &H3DA, 8                 ' wait for vertical retrace
  SCREEN 9, 0, display, drawing
  CLS
END SUB


' IMPORTANT: from here starts the nonrecycable code

' Main program

DIM pwork AS vector
WHILE NOT INSTAT
  FOR j = 40 TO 200 STEP 2
    switchscreen
    eye.z = j
    RESTORE objectdata
    FOR i = 0 TO %MAXPT
      READ pwork.x, pwork.y, pwork.z
      vec2pix pwork, s(i)
    NEXT i
    RESTORE connectdata
    FOR i = 0 TO %MAXLN
      READ pt1, pt2
      LINE (s(pt1).x,s(pt1).y) - (s(pt2).x,s(pt2).y)
    NEXT i
  NEXT j
  FOR j = 200 TO 40 STEP -2
    switchscreen
    eye.z = j
    RESTORE objectdata
    FOR i = 0 TO %MAXPT
      READ pwork.x, pwork.y, pwork.z
      vec2pix pwork, s(i)
    NEXT i
    RESTORE connectdata
    FOR i = 0 TO %MAXLN
      READ pt1, pt2
      LINE (s(pt1).x,s(pt1).y) - (s(pt2).x,s(pt2).y)
    NEXT i
  NEXT j
WEND

SCREEN 0


' Object Data & Connectivity list

objectdata:
DATA  30,  1,    1
DATA   1, 30,    1
DATA   1,  1,   30
DATA -30, -30, -30

connectdata:
DATA  0, 1, 0, 2, 0, 3, 1, 2, 1, 3, 2, 3
**************************************************************************
Listing II-4.1: MOVINPYR.BAS

The listing II-4.1 has some nice features. It contains code that's
recycable (you mustn't reinvent the wheel !). For our purposes there are
two new SUBs:

        SUB switschscreen:
        This subroutine flips between two pages in the video mode 9
        (640x375x16 colours). This EGA resolution is more than enough
        for simple vector graphics.

        SUB vec2pix:
        Converts a vector (3D point) to a screen pixel. This SUB is
        resolution independant. You have to define only the viewpoint
        (setting eye.x/eye.y/eye.z) and the screen parameters %MAXPOSX,
        %MAXPOSY,%CENTERX,%CENTERY before your first call.


    ---------------------------------------------------
  /                                                  / |
 ----------------------------------------------------  |
 3D Graphics in BASIC - Part II.5: 3D Object rotating /
 ----------------------------------------------------

There isn't much to say about 3D rotating. Only formulas, formulas,
formulas. I think our friend Formula Jones won't be unhappy if we come to
the point right now:

        Rotating around the x-axis (Global coordinate system):
        x' = x*cos(alpha) - y*sin(alpha)
        y' = x*sin(alpha) + y*cos(alpha)
        z' = z

        Rotating around the y-axis (Global coordinate system):
        x' = x*cos(beta) + z*sin(beta)
        y' = y
        z' = -x*sin(beta) + z*cos(beta)

        Rotating around the z-axis (Global coordinate system):
        x' = x'
        y' = y*cos(gamma) - z*sin(gamma)
        z' = y*sin(gamma) + z*cos(gamma)

        With:
        (x/y/z)         = old point
        (x'/y'/z')      = new point
        alpha           = angle to rotate around x-axis clockwise
        beta            = angle to rotate around y-axis clockwise
        gamma           = angle to rotate around z-axis clockwise

I won't explain the origin of these formulas because that will not fit
into this article. If you're interrested you'll find this very complex
stuff in any "higher" math book.
Listing II-5.1 is an example of use. Our well known pyramid is now
rotating around his z- and x-axis. But the basic program can be easily
changed. If you want to rotate to any other axis then you have only to
change the calls. Just experimentate with this program !

**************************************************************************
' ---------------------
'   Rotating Pyramid
' based on PYRAMID.BAS
' (C) 1996 by Ch. Garms
' ---------------------


' Compiler Instructions

$CPU 80386
$OPTIMIZE SPEED
$LIB GRAPH ON
$ERROR ALL OFF
$FLOAT EMULATE


' Creating new TYPEs

TYPE vector
  x AS INTEGER
  y AS INTEGER
  z AS INTEGER
END TYPE

TYPE pixel
  x AS INTEGER
  y AS INTEGER
END TYPE


' Variable declarations

%MAXPT = 3                              ' max. points
%MAXLN = 5                              ' max. lines
%FACTOR = 16384
%ANGLE = 3600                           ' max. angles for sinus and cosinus
DIM s(%MAXPT) AS pixel
DIM sinus(%ANGLE) AS SHARED INTEGER     ' array for sinus table
DIM cosinus(%ANGLE) AS SHARED INTEGER   ' array for cosinus table
DIM eye AS SHARED vector                ' viewpoint
DIM pwork AS vector
deg2rad! = 1800/3.14152695
DEFINT a-z


' Initializing Sinus table

FOR i = 0 TO %ANGLE
  sinus(i)   = CINT( SIN( i/deg2rad!) * %FACTOR )
  cosinus(i) = CINT( COS( i/deg2rad!) * %FACTOR )
NEXT i


' Screen constants

%MAXPOSX = 639                          ' max. X-coordinate of screen
%MAXPOSY = 349                          ' max. Y-coordinate of screen
%CENTERX = 320                          ' center of screen (X-position)
%CENTERY = 175                          ' center of screen (Y-position)


' Clipping constants

%LEFT     = 1
%RIGHT    = 2
%UP       = 4
%DOWN     = 8
%TRUE     = -1
%FALSE    = 0


' Initializing Viewpoint

eye.x = 0
eye.y = 0
eye.z = 150


' Rotating Point around X-Axis
'   objpt : vector in world coordinates (!)
'   alpha : angle to rotate around X-Axis (1 means 0.1 deg)

SUB rotatex( objpt AS vector, alpha AS INTEGER )
  SHARED sinus(), cosinus()
  DIM p AS vector

  p.x = (objpt.x * cosinus(alpha) - objpt.y * sinus(alpha)) / %FACTOR
  p.y = (objpt.x * sinus(alpha) + objpt.y * cosinus(alpha)) / %FACTOR

  objpt.x = p.x
  objpt.y = p.y
END SUB


' Rotating Point around Y-Axis
'   objpt : vector in world coordinates (!)
'   beta  : angle to rotate around Y-Axis (1 means 0.1 deg)

SUB rotatey( objpt AS vector, beta AS INTEGER )
  SHARED sinus(), cosinus()
  DIM p AS vector

  p.x = (objpt.x * cosinus(beta) + objpt.z * sinus(beta)) / %FACTOR
  p.z = (objpt.x * -sinus(beta) + objpt.z * cosinus(beta)) / %FACTOR

  objpt.x = p.x
  objpt.z = p.z
END SUB


' Rotating Point around Z-Axis
'   objpt : vector in world coordinates (!)
'   gamma : angle to rotate around Y-Axis (1 means 0.1 deg)

SUB rotatez( objpt AS vector, gamma AS INTEGER )
  SHARED sinus(), cosinus()
  DIM p AS vector

  p.y = (objpt.y * cosinus(gamma) - objpt.z * sinus(gamma)) / %FACTOR
  p.z = (objpt.y * sinus(gamma) + objpt.z * cosinus(gamma)) / %FACTOR

  objpt.y = p.y
  objpt.z = p.z
END SUB


' Calculating the eye coordinates & transformation into screen pixels
'   objpt : vector in world coordinates (!)
'   scrpix: pixel on screen
' The variable eye (TYPE vector) must be defined before calling this sub.

SUB vec2pix( objpt AS vector, scrpix AS pixel )
  SHARED eye

  DECR objpt.x, eye.x
  DECR objpt.y, eye.y
  DECR objpt.z, eye.z

  scrpix.x = (objpt.x / objpt.z) * %MAXPOSX + %CENTERX
  scrpix.y = (objpt.y / objpt.z) * %MAXPOSY + %CENTERY
END SUB


' Switch screens

SUB switchscreen
  STATIC display, drawing

  IF display = drawing THEN
    display = 0
    drawing = 1
  ELSE
    SWAP display, drawing
  END IF

  WAIT &H3DA, 8 ' wait for vertical retrace
  SCREEN 9, 0, display, drawing
  CLS
END SUB


' IMPORTANT: from here starts the nonrecycable code
' Main program

WHILE NOT INSTAT
  FOR j=0 TO %ANGLE STEP 15
    switchscreen
    RESTORE objectdata
    FOR i = 0 TO %MAXPT
      READ pwork.x, pwork.y, pwork.z
      rotatez pwork, j
      rotatey pwork, j
      vec2pix pwork, s(i)
    NEXT i
    RESTORE connectdata
    FOR i = 0 TO %MAXLN
      READ pt1, pt2
      LINE (s(pt1).x,s(pt1).y) - (s(pt2).x,s(pt2).y)
    NEXT i
  NEXT j
WEND

SCREEN 0


' Object Data & Connectivity list

objectdata:
DATA  30,  0,   0
DATA   0, 30,   0
DATA   0,  0,  30
DATA -30,-30, -30

connectdata:
DATA  0, 1, 0, 2, 0, 3, 1, 2, 1, 3, 2, 3
**************************************************************************
Listing II-5.1: ROTPYR.BAS

The listing II-5.1 has a very nice trick: The sinus and cosinus values are
converted to integers by multiplying with a constant factor (the factor
must be less than 32767) and stored in an integer array. That makes the
calculation of the 3D rotating faster than with floating point math. It is
not a great secret because it is a well used technique for vector graphics
since games like Elite on the C-64. Though the calculation aren't very
precise the screen resolution is so small that calculation errors won't
disturb much.

The listing II-5.1 simplifies the rotating. As you can see all formulas
rotate around an axis of the global coordinate system. But the pyramid is
rotating around a point in the center of the pyramid. The program achieves
this by equalising the center of the object and the center of the global
coordinate system. If a chosen scenery is more complex (e.g. two objects
who rotates differemt) then we come to a new coordinate system which I will
now introduce: The Object coordinate system.
That means: All points of a given object will be defined relative to the
center of the object. To display the object in the global cordinate system
(or: world coordinate system) we have only add the translation vector from
the center of the object to the center of the global corrdinate system to
all points of the object.

For example I will take the single point once more for explanation of this
complex subject:
The point is the center of the object. The relative object coordinate will
be (0/0/0) and the translation vector (x/y/z). To display the point into the
world coordinate system we simply add the translation vector to the object
coordinates so the derived global coordinte point is (x/y/z).

In general:

        world.x = obj.x + transl.x
        world.y = obj.y + transl.y
        world.z = obj.z + transl.z

        with:
        (world.x/world.y/world.z) = world coordinates of object point
        (obj.x/obj.y/obj.z) = object coordinates of object point
        (transl.x/transl.y/transl.z) = translation vector of object

That's the same as translating a 3D point in the world coordinate system.
Now we've defined our object within the object coordinate system we only
have to equalise the object center and the world center in our mind. For
the rotations we take the object coordinates not the world coordinates !
Than we can perform the rotations. To display the object we add the
translation vector of the object center to all object points and convert
the points to screen pixels.


    -------------------------------------------------------------------
  /                                                                   / |
 ---------------------------------------------------------------------  |
 3D Graphics in BASIC - Part II.6: Introductions to Matrix calculations /
 ----------------------------------------------------------------------

Matrix operations aren't a mystical thing. You have not to be a math
genius to understand what matrices are:

        "A Matrix is a represantion of a linear equation"

In other words: A Matrix isn't more than an array of values which contains
the suffixes of any linear equation like:

        a1*x + b1*y + c1*z = d1
        a2*x + b2*y + c2*z = d2
        a3*x + b3*y + c3*z = d3

The corresponding matrix looks as follows:

        |a1 b1 c1|   |d1|
        |a2 b2 c2| = |d2|
        |a3 b3 c3|   |d3|

For our purposes we didn't need more to know. As you have seen our 3D
operations are often performed by linear equations. E.g. translation of a
point is performed by adding the translation vector to a point. If we
write down this equation in a matrix form it will look like:

     Matrix1   Matrix2       Matrix3
        |x|   |1 0 0 t.x|   |x + t.x|
        |y|   |0 1 0 t.y| = |y + t.y|
        |z|   |0 0 1 t.z|   |z + t.z|
        |0|   |0 0 0 0  |   |0      |

That means we only multiply the 3D point (Matrix1) with an operator
(Matrix2) to translate the point. It looks like I want to complicate all.
But the advantage of matrix operations is that you can chain many
3D operations like rotation or translation to only one single matrix for
all points of any object. This will reduce the calculations enormous and
speed up 3D graphics dramatically for larger objects.

OK, guys. Next time I will continue you to explain the calculation with
matrix and go further with filled polygon graphics.
Hope to see you again here.

______________________________________________________________________________

Note: Look in the BASIC FANZINE for the next 3D article(s).
<PAGEEND:"3D.Info.File6">

<PAGESTART:"Compress.Huff.Comp">
' Huffman encoder v2.00 for PDS & QB4.5
' by Rich Geldreich May 29th, 1992
' Revised for PDS July 13, 1992
' This program is in the public domain. Use it for what you want!
' Just give me credit. If you find any bugs in it, please tell me about
' them.
'
' QB4.5 users: use search & replace and change all of the "SSEG" strings
' in this program to "VARSEG" strings.
' Do not press ctrl+break while this program is compressing! The string
' pointers may change, which may result in an error! Also, to realize
' the true speed of this program you must run it compiled.
' The overall compression of this program is not optimal, because the
' entire tree is sent to the output file. This was done so the decoding
' program can be as simple and fast as possible(the tree takes up about
' 1000 bytes or so; it depends on the input file).
'
' This program is much, much better than my first huffman encoder. It's
' faster, and (should be) easier to understand. The entire program was
' rewritten from scratch. The following changes have been made:

' The huffman tree is now scanned using a recursive algorithm instead of
' a slow, down-up search.
' Instead of searching for the lowest 2 nodes using a slow, linear search,
' this program uses a much faster presorted table. The entire tree can
' be combined in less than a second on my 286-10!
' The input file is scanned & compressed with a very fast buffer loading
' system, to overcome QB's slowness with binary files.
' A new shell sort is used to sort the node table before the tree is
' combined. A simple bubble sort is then used thereafter.

DEFINT A-Z
DECLARE SUB InitTree ()
DECLARE SUB MakeSortTable ()
DECLARE SUB CombineTree ()
DECLARE SUB CleanUpTree ()
DECLARE SUB WriteTree ()

DECLARE SUB SortDistribution2 ()
DECLARE SUB SortDistribution ()
DECLARE SUB GetDistribution ()
DECLARE SUB RecurseTree (Node)

DECLARE SUB FillBuffer ()


CONST True = -1, False = 0
CONST Null = -2
CONST BufferLength = 10000

CLEAR , , 10000

DIM SHARED Father(512) AS LONG, LeftSon(512), RightSon(512)
DIM SHARED Index(512), RealIndex, Used(255) AS LONG
DIM SHARED Pointer(255), HighestEntry
DIM SHARED Code(255, 40), CodeLength(255)
DIM SHARED CurrentLength, CurrentCode(40)

DIM SHARED Buffer$, Address, EndAddress, Bits(8), CurrentByte, CurrentBit
DIM SHARED BufferSeg


LOCATE , , 1


Bits:
    DATA 1,2,4,8,16,32,64,128,256

'read the bit masks
RESTORE Bits
FOR A = 0 TO 8: READ Bits(A): NEXT

'initialize the tree
InitTree

'initialize the input buffer
Buffer$ = STRING$(BufferLength, 0)
EndAddress = 1: Address = 0

PRINT "Getting Distribution:";
'open input file
OPEN COMMAND$ FOR BINARY AS #1
'check to see if it exists
IF LOF(1) = 0 THEN
    CLOSE #1
    KILL COMMAND$
    PRINT
    PRINT COMMAND$; " not found"
    END
END IF
'read the input file and gather the distribution of each character
GetDistribution
'make a sorting table
MakeSortTable
'sort the table with the a shell sort
SortDistribution
'combine the tree until there is only one node at the "top"
CombineTree
'work down the tree finding codes which represent each character
TopOfTree = Pointer(0)
CurrentLength = 0
RecurseTree TopOfTree
'for debugging: prints the code for each character
'FOR A = 0 TO 255
'    IF Used(A) > 256 THEN
'        PRINT A;
'        FOR B = 0 TO CodeLength(A)
'            PRINT Code(A, B);
'        NEXT
'        PRINT
'    END IF
'NEXT
'STOP
'"cleans" the tree up so it can be sent as small as possible
CleanUpTree

CurrentByte = 0: CurrentBit = 0
RealIndex = RealIndex - 1
'open output file
OPEN "output.huf" FOR BINARY AS #2
'kill file if it already exists
IF LOF(2) <> 0 THEN
    CLOSE #2
    KILL "output.huf"
    OPEN "output.huf" FOR BINARY AS #2
END IF

'put the header
A& = LOF(1)
PUT #2, , A&            'number of bytes in original file
PUT #2, , RealIndex     'number of nodes in tree
Top = Index(TopOfTree)
PUT #2, , Top           'top of tree

WriteTree               'writes the tree to the output file

'compresses the input file
PRINT : PRINT "Encoding...": PRINT : PRINT
Ypos = CSRLIN - 2

SEEK #1, 1
EndAddress = 1: Address = 0
'initialize the output buffer
A$ = STRING$(5000, 0)
A& = SADD(A$)
A& = A& - 65536 * (A& < 0)
OBufferSeg = VARSEG(A$) + (A& \ 16)
OAddress = (A& MOD 16)
OEndAddress = OAddress + 5000
Ostart = OAddress
'start compressing
FOR A& = 1 TO LOF(1)
   
    'get a byte from the input file
    Address = Address + 1
    'if Address=EndBuffer then it's time to fill the input buffer
    IF Address = EndAddress THEN FillBuffer
    B = PEEK(Address)
    'send out all of the bits that represent the input character
    FOR C = 0 TO CodeLength(B)
        IF Code(B, C) THEN
            CurrentByte = CurrentByte * 2 OR 1      'send "1"
        ELSE
            CurrentByte = CurrentByte * 2           'send "0"
        END IF
        CurrentBit = CurrentBit + 1
        'if CurrentBit=8 then we have a complete byte
        IF CurrentBit = 8 THEN
            DEF SEG = OBufferSeg
            POKE OAddress, CurrentByte
            OAddress = OAddress + 1
            'if Oaddress=Oendaddress then it's time to flush the
            'output buffer
            IF OAddress = OEndAddress THEN
                PUT #2, , A$
                B& = SADD(A$)
                B& = B& - 65536 * (B& < 0)
                OBufferSeg = VARSEG(A$) + (B& \ 16)
                OAddress = (B& MOD 16)
                OEndAddress = OAddress + 5000
                Ostart = OAddress
            END IF
            CurrentByte = 0: CurrentBit = 0
            DEF SEG = BufferSeg
        END IF
    NEXT
    'see if it's time to update screen
    PrintCount = PrintCount + 1
    IF PrintCount = 1024 THEN
        PrintCount = 0
        LOCATE Ypos, 1
        PRINT "Bytes In:"; A&; (A& * 100&) \ LOF(1); "%  "
        B& = LOF(2) + OAddress - Ostart
        PRINT "Bytes Out:"; B&; "   "
        PRINT "Compression:"; 100 - (B& * 100&) \ A&; "% ";
    END IF
NEXT
'put whatever is left of the byte buffer into the output buffer
DO UNTIL CurrentBit = 8
    CurrentByte = CurrentByte * 2
    CurrentBit = CurrentBit + 1
LOOP

DEF SEG = OBufferSeg
POKE OAddress, CurrentByte
A$ = LEFT$(A$, OAddress + 1 - Ostart)
PUT #2, , A$
'report compression
LOCATE Ypos, 1
PRINT "Bytes In:"; LOF(1); SPACE$(16)
PRINT "Bytes Out:"; LOF(2); SPACE$(16)
PRINT "Overall Compression:"; 100 - (LOF(2) * 100&) \ LOF(1); "%"; SPACE$(16);
CLOSE

END

'"Cleans" up the tree so it can be sent.
SUB CleanUpTree
    RealIndex = 0
    FOR A = 0 TO 512
        B& = Father(A)
        IF B& <> Null THEN
            IF B& < 256 THEN
                IF Used(B&) > 256 THEN
                    Index(A) = RealIndex
                    RealIndex = RealIndex + 1
                END IF
            ELSEIF B& > 256 THEN
                Index(A) = RealIndex
                RealIndex = RealIndex + 1
            END IF
        END IF
    NEXT

    FOR A = 0 TO 512
        B& = Father(A)
        IF B& <> Null THEN
            IF B& < 256 THEN
                IF Used(B&) > 256 THEN
                    IF LeftSon(A) <> Null THEN
                        LeftSon(A) = Index(LeftSon(A))
                    END IF
                    IF RightSon(A) <> Null THEN
                        RightSon(A) = Index(RightSon(A))
                    END IF
                END IF
            ELSEIF B& > 256 THEN
                IF LeftSon(A) <> Null THEN
                    LeftSon(A) = Index(LeftSon(A))
                END IF
                IF RightSon(A) <> Null THEN
                    RightSon(A) = Index(RightSon(A))
                END IF
            END IF
        END IF
    NEXT
END SUB

'Combines the tree until there is only one node at the top.
SUB CombineTree
   
    Parents = HighestEntry + 1
    DO UNTIL Parents = 1
        'sort the current distribution
        SortDistribution2
        'find the lowest 2 entries
        Lowest = Pointer(HighestEntry)
        NextLowest = Pointer(HighestEntry - 1)
        'find new frequency
        NewFrequency& = Father(Lowest) + Father(NextLowest) - 256
        'combine the two nodes
        IF RightSon(Lowest) = Null AND RightSon(NextLowest) = Null THEN
            Father(NextLowest) = NewFrequency&
            RightSon(NextLowest) = LeftSon(Lowest)
            Father(Lowest) = Null
            Parents = Parents - 1
            HighestEntry = HighestEntry - 1
        ELSEIF RightSon(Lowest) = Null AND RightSon(NextLowest) <> Null THEN
            Father(Lowest) = NewFrequency&
            RightSon(Lowest) = NextLowest
            Pointer(HighestEntry - 1) = Pointer(HighestEntry)
            Parents = Parents - 1
            HighestEntry = HighestEntry - 1
        ELSEIF RightSon(Lowest) <> Null AND RightSon(NextLowest) = Null THEN
            Father(NextLowest) = NewFrequency&
            RightSon(NextLowest) = Lowest
            Parents = Parents - 1
            HighestEntry = HighestEntry - 1
        ELSEIF RightSon(Lowest) <> Null AND RightSon(NextLowest) <> Null THEN
            'search for new node
            FOR A = 512 TO 0 STEP -1
                IF Father(A) = Null THEN EXIT FOR
            NEXT
            Father(A) = NewFrequency&
            LeftSon(A) = Lowest
            RightSon(A) = NextLowest
      
            HighestEntry = HighestEntry - 1
            Pointer(HighestEntry) = A
            Parents = Parents - 1
        END IF
    'loop until there is only one node at the top
    LOOP
END SUB

'Fills the input buffer.
SUB FillBuffer
    GET #1, , Buffer$

    A& = SADD(Buffer$)
    A& = A& - 65536 * (A& < 0)
    BufferSeg = VARSEG(Buffer$) + (A& \ 16)
    Address = (A& MOD 16)
    EndAddress = Address + BufferLength
    DEF SEG = BufferSeg

END SUB

'Scans the input file for its distribution.
SUB GetDistribution
       
    FOR A& = 1 TO LOF(1)
        Address = Address + 1
        IF Address = EndAddress THEN
            FillBuffer
            PRINT ".";
        END IF
        B = PEEK(Address) * 2
        Father(B) = Father(B) + 1
    NEXT
    B = 0
    FOR A = 0 TO 510 STEP 2
        Used(B) = Father(A): B = B + 1
    NEXT
END SUB

'Initilizes the tree.
SUB InitTree
    B = 0
    FOR A = 0 TO 510 STEP 2
  
        Father(A) = 256
        LeftSon(A) = A + 1
        RightSon(A) = Null
  
        Father(A + 1) = B
        LeftSon(A + 1) = Null
        RightSon(A + 1) = Null
  
        B = B + 1
    NEXT
END SUB

'Makes a sorting table.
SUB MakeSortTable
    HighestEntry = 0
    FOR A = 0 TO 510 STEP 2
        IF Father(A) > 256 THEN
            Pointer(HighestEntry) = A
            HighestEntry = HighestEntry + 1
        END IF
    NEXT
    HighestEntry = HighestEntry - 1
END SUB

'Recursive procedure to go down the tree and build up codes
'that represent each character.
SUB RecurseTree (Node)
    'are we at a character?
    IF Father(Node) < 256 THEN
        'yup! CurrentCode() has this character's bit sequence
        Char = Father(Node)
        FOR A = 0 TO CurrentLength - 1
            Code(Char, A) = CurrentCode(A)
        NEXT
        CodeLength(Char) = CurrentLength - 1
    END IF
    'go to the left if there's something there
    IF LeftSon(Node) <> Null THEN
        CurrentCode(CurrentLength) = 1      'add "1" to the current code
        CurrentLength = CurrentLength + 1
        RecurseTree LeftSon(Node)           'go down
        CurrentLength = CurrentLength - 1   'take "1" from the current code
    END IF
    'go to the right if there's something there
    IF RightSon(Node) <> Null THEN
        CurrentCode(CurrentLength) = 0      'add "0" to the current code
        CurrentLength = CurrentLength + 1
        RecurseTree RightSon(Node)          'got down
        CurrentLength = CurrentLength - 1   'take "0" from the current code
    END IF
END SUB

'A REAL Shell sort follows. It is much faster than the well-known one.
'Sorts the nodes according to the sorting table.
SUB SortDistribution
    Offset = HighestEntry \ 2
    DO
        FOR I = 0 TO HighestEntry - Offset
            IF Father(Pointer(I)) < Father(Pointer(I + Offset)) THEN
                SWAP Pointer(I), Pointer(I + Offset)
                CompareLow = I - Offset
                CompareHigh = I
                DO WHILE CompareLow >= 0
                    IF Father(Pointer(CompareLow)) < Father(Pointer(CompareHigh)) THEN
                        SWAP Pointer(CompareLow), Pointer(CompareHigh)
                        CompareHigh = CompareLow
                        CompareLow = CompareLow - Offset
                    ELSE
                        EXIT DO
                    END IF
                LOOP
            END IF
        NEXT
        Offset = Offset \ 2
    LOOP WHILE Offset > 0
    

END SUB

'A simple bubble sort... used while combining the tree.
SUB SortDistribution2
    
    DO
        SwapFlag = False
        FOR A = HighestEntry - 1 TO 0 STEP -1
            IF Father(Pointer(A + 1)) > Father(Pointer(A)) THEN
                SWAP Pointer(A + 1), Pointer(A)
                SwapFlag = True
            END IF
        NEXT
    LOOP WHILE SwapFlag
    
END SUB

'Writes the tree to disk.
SUB WriteTree
    

    FOR A = 0 TO 512
        B& = Father(A)
        IF B& <> Null THEN
            IF B& < 256 THEN
                IF Used(B&) > 256 THEN
                    GOSUB SendOne
                    FOR C = 0 TO 7
                        IF (B& AND Bits(C)) > 0 THEN
                            GOSUB SendOne
                        ELSE
                            GOSUB SendZero
                        END IF
                    NEXT
                END IF
            ELSEIF B& > 256 THEN
                GOSUB SendZero
                IF LeftSon(A) <> Null THEN
                    GOSUB SendOne
                    Son = LeftSon(A)
               
                    FOR C = 0 TO 8
                        IF (Son AND Bits(C)) > 0 THEN
                            GOSUB SendOne
                        ELSE
                            GOSUB SendZero
                        END IF
                    NEXT
                ELSE
                    GOSUB SendZero
                END IF
                IF RightSon(A) <> Null THEN
                    GOSUB SendOne
                    Son = RightSon(A)
                   
                    FOR C = 0 TO 8
                        IF (Son AND Bits(C)) > 0 THEN
                            GOSUB SendOne
                        ELSE
                            GOSUB SendZero
                        END IF
                    NEXT
                ELSE
                    GOSUB SendZero
                END IF
            END IF
        END IF
    NEXT

    EXIT SUB

SendZero:
    CurrentByte = CurrentByte * 2
    CurrentBit = CurrentBit + 1
    IF CurrentBit = 8 THEN
        A$ = CHR$(CurrentByte)
        PUT #2, , A$
        CurrentByte = 0: CurrentBit = 0
    END IF
RETURN

SendOne:
   
    CurrentByte = CurrentByte * 2 OR 1
    CurrentBit = CurrentBit + 1
    IF CurrentBit = 8 THEN
        A$ = CHR$(CurrentByte)
        PUT #2, , A$
        CurrentByte = 0: CurrentBit = 0
    END IF
RETURN

END SUB
<PAGEEND:"Compress.Huff.Comp">

<PAGESTART:"Compress.Huff.Decomp">
' Huffman decoder v2.00 for PDS & QB4.5
' by Rich Geldreich May 29th, 1992
' Revised for PDS July 13, 1992
' This program is in the public domain.
' QB4.5 users: use search & replace and change all of the "SSEG" strings
' in this program to "VARSEG" strings.
' Do not press ctrl+break while this program is decompressing! The string
' pointers may change, which may result in an error! Also, to realize
' the true speed of this program you must run it compiled!
' See HUFFMAN2.BAS for info.

DEFINT A-Z

DECLARE FUNCTION GetBit ()
DECLARE SUB FillBuff ()

CONST True = -1, False = 0
CONST Null = -2
CONST BufferLength = 10000

DIM SHARED Bits(8)
DIM SHARED Father(512)
DIM SHARED LeftSon(512)
DIM SHARED RightSon(512)

DIM SHARED Buffer$, Address, EndAddress, CurrentByte, BitsIn, BufferSeg

Bits:
    DATA 1,2,4,8,16,32,64,128,256

RESTORE Bits
FOR A = 0 TO 8: READ Bits(A): NEXT
'disk buffer
Buffer$ = STRING$(BufferLength, 0): EndAddress = 1: Address = 0: BitsIn = -1
'turn on cursor
LOCATE , , 1
'open the compressed file
OPEN "output.huf" FOR BINARY AS #1
'get the header
GET #1, , FileLength&
GET #1, , RealIndex
GET #1, , TopOfTree
'read in the tree
FOR A = 0 TO RealIndex
    IF GetBit THEN
        Father = 0
        FOR C = 0 TO 7
            IF GetBit THEN Father = Father + Bits(C)
        NEXT
        Father(A) = Father
        RightSon(A) = Null
        LeftSon(A) = Null
    ELSE
        Father(A) = 256
        IF GetBit THEN
            Son = 0
            FOR C = 0 TO 8
                IF GetBit THEN Son = Son + Bits(C)
            NEXT
            LeftSon(A) = Son
        ELSE
            LeftSon(A) = Null
        END IF
        IF GetBit THEN
            Son = 0
            FOR C = 0 TO 8
                IF GetBit THEN Son = Son + Bits(C)
            NEXT
            RightSon(A) = Son
        ELSE
            RightSon(A) = Null
        END IF
    END IF
NEXT
'when PrintCounter=1024 then screen is updated
PrintCounter = 0
'A$ is the output buffer
A$ = STRING$(5000, 0)
A& = SADD(A$)
A& = A& - 65536 * (A& < 0)
OutputSeg = VARSEG(A$) + (A& \ 16)
OAddress = (A& MOD 16)
OEndAddress = OAddress + 5000
OStart = OAddress
'start decoding
PRINT "Decoding:";
Xpos = POS(0): Ypos = CSRLIN
'open output file
OPEN COMMAND$ FOR BINARY AS #2
'decode each byte
FOR CurrentByte& = 1 TO FileLength&
    DEF SEG = BufferSeg
    'start at top of tree
    A = TopOfTree
    'keep on getting bits until a character is found
    DO
        'if BitsIn<0 then time to fill byte buffer
        IF BitsIn < 0 THEN
            Address = Address + 1
            'if Address=EndBuffer then time to fill disk buffer
            IF Address = EndAddress THEN
                FillBuff
            END IF
            CurrentByte = PEEK(Address): BitsIn = 7
        END IF
        'see if we go left or right
        IF (CurrentByte AND Bits(BitsIn)) THEN A = LeftSon(A) ELSE A = RightSon(A)
        BitsIn = BitsIn - 1
        F = Father(A)
        'loop until an ascii character is found
    LOOP UNTIL F < 256
    'put byte into output buffer
    DEF SEG = OutputSeg
    POKE OAddress, F
    OAddress = OAddress + 1
    IF OAddress = OEndAddress THEN
        PUT #2, , A$
        A& = SADD(A$)
        A& = A& - 65536 * (A& < 0)
        OutputSeg = VARSEG(A$) + (A& \ 16)
        OAddress = (A& MOD 16)
        OEndAddress = OAddress + 5000
        OStart = OAddress
    END IF
    'see if time to update the screen
    PrintCounter = PrintCounter + 1
    IF PrintCounter = 1024 THEN
        PrintCounter = 0
        LOCATE Ypos, Xpos
        PRINT (CurrentByte& * 100) \ FileLength&; "%";
    END IF
'loop until all of the characters have been restored
NEXT
'save whatever is currently in the output buffer
A$ = LEFT$(A$, OAddress - OStart)
PUT #2, , A$
CLOSE
'all done
LOCATE Ypos, Xpos
PRINT " done."

END

'fills the input buffer
SUB FillBuff
    GET #1, , Buffer$
    A& = SADD(Buffer$)
    A& = A& - 65536 * (A& < 0)
    BufferSeg = VARSEG(Buffer$) + (A& \ 16)
    Address = (A& MOD 16)
    EndAddress = Address + BufferLength
    DEF SEG = BufferSeg
END SUB

'gets one bit from the input file(only used when the tree
'is read in)
FUNCTION GetBit STATIC
    IF BitsIn < 0 THEN
        Address = Address + 1
        IF Address = EndAddress THEN
            FillBuff
        END IF
        CurrentByte = PEEK(Address): BitsIn = 7
    END IF
    GetBit = (CurrentByte AND Bits(BitsIn)): BitsIn = BitsIn - 1
END FUNCTION
<PAGEEND:"Compress.Huff.Decomp">

<PAGESTART:"Compress.LZW.Comp">
'Experimental LZW Compressor for PDS / QuickBASIC 4.5
'By Rich Geldreich 1992
'This program is in the public domain: use as you wish!
'(QB4.5 users: Use search & replace to change all of the "SSEG" strings
'to "VARSEG" strings in this program.)
'If you have and questions or problems, write/call:

'Rich Geldreich
'410 Market St.
'Gloucester City, NJ 08030
'(609)-742-8752
'
' Do not press ctrl+break while this program is decompressing! The string
' pointers may change, which may result in an error!

DEFINT A-Z
DECLARE SUB PutByte (A)
DECLARE SUB PutCode (A)
DECLARE SUB Rebuild.Table (New.Entries)
DECLARE FUNCTION GetByte ()
DECLARE SUB Hash (Prefix, Suffix, Index, Found)

CONST True = -1, False = 0

DIM SHARED Prefix(6576), Suffix(6576), Code(6576)
DIM SHARED Used(4096)

DIM SHARED InBuffer$, IAddress, IEndAddress, Iseg
DIM SHARED OutBuffer$, OStartAddress, OAddress, OEndAddress, Oseg

DIM SHARED CodeSize, CurrentBit, Char&
DIM SHARED Shift(12) AS LONG


FOR A = 0 TO 12: READ Shift(A): NEXT
DATA 1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192


LOCATE , , 1
IF POS(0) <> 1 THEN PRINT


InBuffer$ = STRING$(4000, 0)   'input buffer
OutBuffer$ = STRING$(4000, 0)  'output buffer


A& = SADD(OutBuffer$)
A& = A& - 65536 * (A& < 0)
Oseg = VARSEG(OutBuffer$) + (A& \ 16)     'Segment of buffer
OAddress = (A& MOD 16)                  'Current address in disk buffer
OEndAddress = OAddress + 4000           'End address of  buffer
OStartAddress = OAddress                'Start of buffer

'Open input file
File$ = COMMAND$
IF File$ = "" THEN LINE INPUT "File to compress? "; File$: File$ = LTRIM$(RTRIM$(File$))
IF File$ = "" THEN END
OPEN File$ FOR BINARY AS #1
FileLength& = LOF(1)
'Is it there?
IF FileLength& = 0 THEN
    CLOSE #1
    KILL COMMAND$
    PRINT COMMAND$; " not found"
    END
END IF
'Open output file
OPEN "output.lzw" FOR BINARY AS #2
'Is it already there?
IF LOF(2) <> 0 THEN
    'Kill output file and reopen it
    CLOSE #2
    KILL "output.lzw"
    OPEN "output.lzw" FOR BINARY AS #2
END IF
'CurrentLoc& - position in input file
CurrentLoc& = 2

'Compression codes:
'Code 256 = end of file
'Code 257 = increase code size
'Code 258 = rebuild table
'Code 259 - 4095 = available for strings
StartCode = 259                 'First LZW code that is available
NextCode = 259
'The maximum code that can be represented in 9 bits
MaxCode = 512
'Start with 9 bit code size
CodeSize = 9
'Current bit position in Char& - use for PutCode
CurrentBit = 0
'Char& is a temporary buffer; accumulates codes from main program and
'puts them in the output file once complete bytes have been
'built
Char& = 0

GOSUB ClearTable
'Get first byte from file(it's a special case)
Prefix = GetByte

PRINT "LZW Compressor For QuickBASIC 4.5"
PRINT "By Richard Geldreich June 2nd, 1992"
PRINT "Compressing "; File$
PRINT : PRINT : PRINT
'First line to start updating statistics
Y = CSRLIN - 3
'Main compression loop
DO
    DO
     
        IF CurrentLoc& > FileLength& THEN
            PutCode Prefix
            PutCode 256
            PutCode 0: PutCode 0
            OutBuffer$ = LEFT$(OutBuffer$, OAddress - OStartAddress)
            LOCATE Y, 1
            PRINT "Bytes In:"; CurrentLoc&; (100& * CurrentLoc&) \ FileLength&; "%"
            BytesOut& = LOF(2) + (OAddress - OStartAddress)
            PRINT "Bytes Out:"; BytesOut&
            PRINT "Total Compression:"; 100 - ((100& * BytesOut&) \ CurrentLoc&); "%                         ";
            PUT #2, , OutBuffer$
            CLOSE
            END
        ELSE
            
            Suffix = GetByte
            CurrentLoc& = CurrentLoc& + 1
            'We now have a Prefix:Suffix to search for.
            'If the search fails, put the Prefix in the output file
            'and set the Prefix equal to the character which caused
            'the failure.

            Hash Prefix, Suffix, Index, Found
            IF Found = True THEN
                Prefix = Code(Index)
                'update how many times this string was used
                Used(Prefix) = Used(Prefix) + 1
            END IF
        END IF
    LOOP WHILE Found = True

    'only increase the code size when required
    DO WHILE Prefix >= MaxCode AND CodeSize < 12
        PutCode 257
        MaxCode = MaxCode * 2
        CodeSize = CodeSize + 1
    LOOP
   
    PutCode Prefix

    'Put the new string into the hash table.
    Prefix(Index) = Prefix
    Suffix(Index) = Suffix
    Code(Index) = NextCode  'remember this string's code

    'Prefix is now equal to the character that caused the failure now.
    Prefix = Suffix
 
    NextCode = NextCode + 1
    'if there are too many strings then rebuild the encoding table
    IF NextCode > 4096 THEN
           
        PutCode 258 'send rebuild table code to decompressor

        Rebuild.Table New.Entries
        NextCode = New.Entries + StartCode
       
        IF NextCode > 4096 THEN
            GOSUB ClearTable
            NextCode = StartCode        'reset NextCode to top of tree
        END IF

        CodeSize = 9
        MaxCode = 512

        
    END IF

    'let the impatient user know we haven't hung up (yet!)
    PrintCounter = PrintCounter + 1     'see if time to update the
    IF PrintCounter = 512 THEN          'screen
        LOCATE Y, 1
        PRINT "Bytes In:"; CurrentLoc&; (100& * CurrentLoc&) \ FileLength&; "%"
        BytesOut& = LOF(2) + (OAddress - OStartAddress)
        PRINT "Bytes Out:"; BytesOut&
        PRINT "Compression:"; 100 - ((100& * BytesOut&) \ CurrentLoc&); "%  "; "CodeSize:"; CodeSize; "NextCode:"; NextCode; "   ";
        PrintCounter = 0
    END IF
LOOP
'clears the hash table
ClearTable:
    FOR A = 0 TO 6576
        Prefix(A) = -1
        Suffix(A) = -1
        Code(A) = -1
    NEXT
RETURN

'Reads one byte from the input buffer, and fills the buffer if it's emty.
FUNCTION GetByte STATIC
    IF IAddress = IEndAddress THEN
        GET #1, , InBuffer$
        A& = SADD(InBuffer$)
        A& = A& - 65536 * (A& < 0)
        Iseg = VARSEG(InBuffer$) + (A& \ 16)
        IAddress = (A& MOD 16)
        IEndAddress = IAddress + 4000
    END IF
    DEF SEG = Iseg
    GetByte = PEEK(IAddress)
    IAddress = IAddress + 1
END FUNCTION

'Attempts to finds a prefix:suffix string.
SUB Hash (Prefix, Suffix, Index, Found)
    
    Index = (Prefix * 256& XOR Suffix) MOD 6577 'XOR hashing
    IF Index = 0 THEN  'is Index lucky enough to be 0?
        Offset = 1     'Set offset to 1, because 6577-0=6577
    ELSE
        Offset = 6577 - Index
    END IF
    DO 'until we find a match or don't
        IF Code(Index) = -1 THEN      'is there nothing here?
            Found = False             'yup, not found
            EXIT SUB
        'is this entry what we're looking for?
        ELSEIF Prefix(Index) = Prefix AND Suffix(Index) = Suffix THEN
            Found = True              'yup, found
            EXIT SUB
        ELSE 'retry until we find what were looking for or we find a blank
             'entry
            Index = Index - Offset
            IF Index < 0 THEN 'is index too far down?
                Index = Index + 6577 'yup, bring it up then
            END IF
        END IF
    LOOP
END SUB

'Throws a byte into the output buffer and writes the buffer if it's full.
SUB PutByte (A) STATIC
    IF OAddress = OEndAddress THEN
        PUT #2, , OutBuffer$
        OAddress = OStartAddress
    END IF
    DEF SEG = Oseg
    POKE OAddress, A
    OAddress = OAddress + 1
END SUB

'Throws one multi-bit code to the output file.
SUB PutCode (A) STATIC
    SHARED MaxCode
    IF A >= MaxCode THEN STOP

    Char& = Char& + A * Shift(CurrentBit)
    CurrentBit = CurrentBit + CodeSize
    DO WHILE CurrentBit > 7
        PutByte Char& AND 255
        Char& = Char& \ 256
        CurrentBit = CurrentBit - 8
    LOOP
END SUB

'This is the "experimental" part of the program. This procedure eliminates
'any strings which are not used in the encoding table: the usual result of
'doing this is greater compression.
'It isn't documented well yet... I'm still working on it.
SUB Rebuild.Table (New.Entries)
    DIM P(4096), S(4096), U(4096) AS LONG, Pn(4096), C(4096)
    DIM Location(4096)
   
    SHARED StartCode, MaxCode, Prefix
    Num.Entries = 0
    
    FOR A = 0 TO 6576
        C = Code(A)
        IF C <> -1 THEN 'valid code?
            IF Used(C) > 0 THEN 'was it used at all?
                Used(C) = 0
                P = Prefix(A): S = Suffix(A)
                P(Num.Entries) = P          'put it into a temporary table
                S(Num.Entries) = S
                U(Num.Entries) = P * 4096& + S
                C(C) = Num.Entries
                Num.Entries = Num.Entries + 1
            END IF
        END IF
    NEXT
    

    Num.Entries = Num.Entries - 1
    FOR A = 0 TO Num.Entries
        Pn(A) = A
    NEXT
        'sort the table according to it's prefix:suffix
    Mid = Num.Entries \ 2
    DO
        FOR A = 0 TO Num.Entries - Mid
            IF U(Pn(A)) > U(Pn(A + Mid)) THEN
                SWAP Pn(A), Pn(A + Mid)
                Swap.Flag = True
                CompareLow = A - Mid
                CompareHigh = A
                DO WHILE CompareLow >= 0
                    IF U(Pn(CompareLow)) > U(Pn(CompareHigh)) THEN
                        SWAP Pn(CompareLow), Pn(CompareHigh)
                        CompareHigh = CompareLow
                        CompareLow = CompareLow - Mid
                    ELSE
                        EXIT DO
                    END IF
                LOOP
               
            END IF
        NEXT
        
        Mid = Mid \ 2
    LOOP WHILE Mid > 0
    
    
    FOR A = 0 TO Num.Entries
        Location(Pn(A)) = A
    NEXT
    'clear the old hash table
    FOR A = 0 TO 6576
        Prefix(A) = -1
        Suffix(A) = -1
        Code(A) = -1
    NEXT
    
    'put each prefix:suffix into the hash table
    FOR A1 = 0 TO Num.Entries
        A = Pn(A1)
       
        P = P(A)
        S = S(A)
        IF P >= StartCode THEN 'is it pointing twards a string?
            P = StartCode + Location(C(P)) 'yup; update the pointer
        END IF
        IF S >= StartCode THEN
            S = StartCode + Location(C(S))
        END IF
        'where does this prefix:suffix go?
        Hash P, S, Index, 0
        'put it there
        Prefix(Index) = P
        Suffix(Index) = S
        Code(Index) = A1 + StartCode
        
    NEXT
    '# of entries in the hash table now
    New.Entries = Num.Entries + 1
END SUB
<PAGEEND:"Compress.LZW.Comp">

<PAGESTART:"Compress.LZW.Decomp">
'Experimental LZW Decompressor for PDS / QuickBASIC 4.5
'By Rich Geldreich 1992
'This program is in the public domain: use as you wish!
'(QB4.5 users: Use search & replace to change all of the "SSEG" strings
'to "VARSEG" strings in this program.)
'If you have and questions or problems, write/call:

'Rich Geldreich
'410 Market St.
'Gloucester City, NJ 08030
'(609)-742-8752
'
' Do not press ctrl+break while this program is decompressing! The string
' pointers may change, which may result in an error!

DEFINT A-Z
DECLARE SUB PutByte (A)
DECLARE SUB Rebuild.Table (New.Entries)
DECLARE FUNCTION GetCode ()
DECLARE FUNCTION GetByte ()
CONST True = -1, False = 0

'Prefix & Suffix of each code
DIM SHARED Prefix(4096), Suffix(4096), Used(4096)
DIM OutCode(4096)               'simulates a hardware stack

'Input and output disk buffers
DIM SHARED InBuffer$, IAddress, IEndAddress, Iseg
DIM SHARED OutBuffer$, OStartAddress, OAddress, OEndAddress, Oseg

'Used for screen updating
DIM SHARED BytesIn&

'Powers of two
DIM SHARED Powers(7)
DIM SHARED LongPowers(12) AS LONG
'Mask for each codesize
DIM SHARED Masks(12)
'Current codesize
DIM SHARED CodeSize
'Initialize each array
FOR A = 0 TO 7: Powers(A) = 2 ^ A: NEXT
FOR A = 0 TO 12: LongPowers(A) = 2 ^ A: NEXT
FOR A = 1 TO 12: Masks(A) = (2 ^ A) - 1: NEXT
'Turn on cursor
LOCATE , , 1
'Initialize each disk buffer
InBuffer$ = STRING$(5000, 0)
OutBuffer$ = STRING$(5000, 0)
'Find address of output buffer
A& = SADD(OutBuffer$)
A& = A& - 65536 * (A& < 0)
Oseg = VARSEG(OutBuffer$) + (A& \ 16)
OAddress = (A& MOD 16)
OEndAddress = OAddress + 5000
OStartAddress = OAddress
BytesIn& = 0
'Open files
OPEN "OUTPUT.LZW" FOR BINARY AS #1
OPEN COMMAND$ FOR BINARY AS #2

'First code is 259
FreeCode = 259
StartCode = 259
'First codesize is 9 bits
CodeSize = 9
'Get First code(special case)
Code = GetCode
CurCode = Code
OldCode = Code
FinChar = Code
PutByte FinChar

FileLength& = LOF(1)
IF POS(0) <> 1 THEN PRINT
PRINT "LZW Decompressor in QuickBASIC 4.5"
PRINT "By Richard Geldreich June 2nd, 1992"
PRINT "Decompressing:";
Y = CSRLIN: X = POS(0)
'Main decompression loop
DO
    'Update screen every 1,024 codes
    OutputCounter = OutputCounter + 1
    IF OutputCounter = 1024 THEN
        LOCATE Y, X
        PRINT (100& * BytesIn&) \ FileLength&; "% done";
        OutputCounter = 0
    END IF

GetCode:
    'Get code from input file
    Code = GetCode
    'Process code
    SELECT CASE Code
    'End of file code
    CASE 256
        OutBuffer$ = LEFT$(OutBuffer$, OAddress - OStartAddress)
        PUT #2, , OutBuffer$
        LOCATE Y, X
        PRINT " done       "
        CLOSE : END
    'Increase code size code
    CASE 257
        CodeSize = CodeSize + 1
    CASE 258
        Rebuild.Table New.Entries
        FreeCode = New.Entries + StartCode
        CodeSize = 9

        IF FreeCode > 4096 THEN
            FreeCode = StartCode
            Code = GetCode
             
            CurCode = Code
            OldCode = Code
             
            FinChar = Code
            PutByte FinChar
        ELSE
            'prevents an invalid code from entering the table
            Ignore.Next = True
        END IF

    'Process a code
    CASE ELSE
       
        CurCode = Code
        InCode = Code
        'Do we have this string yet?
        IF Code >= FreeCode THEN
            'If Code>FreeCode then stop decompression: this can't be right!
            IF Code > FreeCode THEN PRINT "??BAD LZW CODE IN FILE": CLOSE : END
            'Trick decompressor to use last code
            
            Used(Code) = Used(Code) + 1
            CurCode = OldCode
            OutCode(OutCount) = FinChar
            OutCount = OutCount + 1
        END IF
        
        'Does this code represent a string?
        IF CurCode >= StartCode THEN
            'Get each character from the table and push it onto the stack
            
            DO
                Used(CurCode) = Used(CurCode) + 1
                OutCode(OutCount) = Suffix(CurCode)
                OutCount = OutCount + 1
                CurCode = Prefix(CurCode)
            'keep on doing this until we have a normal character
            LOOP UNTIL CurCode <= 255
        END IF
        FinChar = CurCode
        OutCode(OutCount) = FinChar
        'Pop all the codes of the stack and put them into the output file
        FOR A = OutCount TO 0 STEP -1
            PutByte OutCode(A)
        NEXT
        OutCount = 0
        'Put the new string into the table
        IF Ignore.Next THEN
            Ignore.Next = False
        ELSE
            Prefix(FreeCode) = OldCode
            Suffix(FreeCode) = FinChar
            FreeCode = FreeCode + 1
        END IF
        OldCode = InCode
    END SELECT
LOOP

FUNCTION GetByte STATIC
    IF IAddress = IEndAddress THEN
        GET #1, , InBuffer$
        A& = SADD(InBuffer$)
        A& = A& - 65536 * (A& < 0)
        Iseg = VARSEG(InBuffer$) + (A& \ 16)
        IAddress = (A& MOD 16)
        IEndAddress = IAddress + 5000
    END IF
    DEF SEG = Iseg
    GetByte = PEEK(IAddress)
    BytesIn& = BytesIn& + 1
    IAddress = IAddress + 1
END FUNCTION

FUNCTION GetCode STATIC
    IF BitsLeft = 0 THEN
        TempChar = GetByte
        BitsLeft = 8
    END IF
    WorkCode& = TempChar \ Powers(8 - BitsLeft)
    DO WHILE CodeSize > BitsLeft
        TempChar = GetByte
        WorkCode& = WorkCode& OR TempChar * LongPowers(BitsLeft)
        BitsLeft = BitsLeft + 8
    LOOP
    BitsLeft = BitsLeft - CodeSize
    GetCode = WorkCode& AND Masks(CodeSize)
END FUNCTION

SUB PutByte (A) STATIC
    IF OAddress = OEndAddress THEN
        PUT #2, , OutBuffer$
        OAddress = OStartAddress
    END IF
    DEF SEG = Oseg
    POKE OAddress, A
    OAddress = OAddress + 1
END SUB

SUB Rebuild.Table (New.Entries)
    DIM P(4095), S(4095), U(4095) AS LONG, Pn(4095), C(4095)
    DIM location(4095)
   
    SHARED StartCode, OldCode
   
    Num.Entries = 0
    FOR A = StartCode TO 4095
        IF Used(A) > 0 THEN
            Used(A) = 0
            P = Prefix(A): S = Suffix(A)
            P(Num.Entries) = P
            S(Num.Entries) = S
            U(Num.Entries) = P * 4096& + S
            C(A) = Num.Entries
            Num.Entries = Num.Entries + 1
        END IF
    NEXT
  

    Num.Entries = Num.Entries - 1
    FOR A = 0 TO Num.Entries
        Pn(A) = A
    NEXT
  
    Mid = Num.Entries \ 2
    DO
        FOR A = 0 TO Num.Entries - Mid
            IF U(Pn(A)) > U(Pn(A + Mid)) THEN
                SWAP Pn(A), Pn(A + Mid)
                Swap.Flag = True
                CompareLow = A - Mid
                CompareHigh = A
                DO WHILE CompareLow >= 0
                    IF U(Pn(CompareLow)) > U(Pn(CompareHigh)) THEN
                        SWAP Pn(CompareLow), Pn(CompareHigh)
                        CompareHigh = CompareLow
                        CompareLow = CompareLow - Mid
                    ELSE
                        EXIT DO
                    END IF
                LOOP
              
            END IF
        NEXT
       
        Mid = Mid \ 2
    LOOP WHILE Mid > 0
   
   
    FOR A = 0 TO Num.Entries
        location(Pn(A)) = A
    NEXT
   
    
   
    FOR A1 = 0 TO Num.Entries
        A = Pn(A1)
     
        P = P(A)
        S = S(A)
        IF P >= StartCode THEN
            P = StartCode + location(C(P))
        END IF
        IF S >= StartCode THEN
            S = StartCode + location(C(S))
        END IF
       
        Prefix(A1 + StartCode) = P
        Suffix(A1 + StartCode) = S
       
    NEXT
    
    IF OldCode >= StartCode THEN
        OldCode = StartCode + location(C(OldCode))
    END IF
   
    New.Entries = Num.Entries + 1

END SUB
<PAGEEND:"Compress.LZW.Decomp">

<PAGESTART:"Mouse.Routines.File1">
'Ok... this program doesn't ACTUALLY do anything.  It's the result of a lack
'of INTERNET connection combined with boredom and visiting relatives you
'don't want to know you are home.
'You need a mouse... a computer... some memory... a little hard-drive...
'patience... boredom... the default library... the real QUICKBASIC.
'Load up QuickBASIC by typing "QB/L" this loads the default library...
'You can use this however you like... I really don't care...
'If you make money off of it... pay me... I'm broke.
'If you at least bother to look at it...
'send me an e-mail...
'exnihilo@rhunebbs.com.
'Send me the latest ABC packet.
'Send me your funky code.
'Send me a life.
'All code by NICOLAS CULBERSON.
'This program intentionally bounces around like that!  Oh yeah, and it was
'created on a 486/33 so if it doesn't work right on your computer don't
'tell me about it.  I don't care.

DECLARE SUB warp ()         'Declare stuff...
DECLARE SUB right ()        'Declare stuff...
DECLARE SUB down ()         'Declare stuff...
DECLARE SUB up ()           'Declare stuff...
DECLARE SUB left ()         'Declare stuff...
DECLARE SUB shoot ()        'Declare stuff...
REM $INCLUDE: 'QB.BI'       'Include the library thing...
DIM SHARED regx  AS RegTypeX'Dim regx as regtypex and share it between the
                            'subs(see "Declare stuff...")
DIM SHARED a, b             'Do the same thing with the variables a,b
RANDOMIZE TIMER             'This Randomizes the computer timer(duh)

CLS                         'Clear the screen.  If you don't understand this
                            'statement... don't bother trying to figure the
                            'program out.  You need a manual.
SCREEN 13                   'Put the screen into 320 * 200 graphics mode.
a = regx.cx / 2             'Define the variable regx.cx
                            '(the X AXIS on the mouse) as variable named a.
                            'You must divide by half in screen 13.
b = regx.dx                 'Do the same thing to the variable named b with
                            'the Y AXIS
DO                          'Begin LOOP(see LOOP)
a$ = INKEY$                 'Look for a keypress and place it in STRING A$
IF a$ = CHR$(27) THEN END   'If the key pressed is "esc" then escape.(please
                            '(note:  this is high level programming, do not
                            'attempt to put such wonderful features in your
                            'own programs without adult supervision.)
regx.ax = 2                 'Hide the mouse cursor
CALL INTERRUPTX(&H33, regx, regx) 'Call the mouse interrupt at the address
                                  '&H33... this works on most computers...
regx.ax = 3                       'I dunno what this does but it has to be
                                  'there last time I checked.
CALL INTERRUPTX(&H33, regx, regx) 'Call it again.
REM IF regx.dx > 139 THEN regx.dx = regx.dx - 1 'This line is remmed...
                                                'ignore it.
IF a > regx.cx / 2 THEN CALL left  'Call the sub LEFT if the mouse
                                   'moves in the left direction.
IF a < regx.cx / 2 THEN CALL right 'Call the sub RIGHT if the mouse
                                   'moves in the right direction.
IF b > regx.dx THEN CALL up        'Call the sub UP if the mouse
                                   'moves in the UP direction.
IF b < regx.dx THEN CALL down      'Bear with me here... things do change.
IF regx.bx = 1 THEN CALL shoot     'Regx.bx is the mouse button variable.
                                   '.bx=1 is button number 1
                                   '.bx=2 is button number 2
                                   '.bx=3 is button number 1 and 2 at the
                                   'same time or button 3 if you have it, I
                                   'think.
                                   'So, this line checks for button 1...
                                   'and if it is pressed, calls the sub
                                   'named shoot.
IF regx.bx = 2 THEN CALL warp      'If button 2 is pressed...
                                   'call the WARP sub.
LOOP UNTIL bob = 1                 'Loop forever.  Whose BOB?


'Hmmm... you're still reading eh?  Your internet connection must be down too.
'How about calling Zeitgeist BBS in Saint John... the phone number is
'(506)832-9012 or something like that.  Experiment... you never know who you
'might get.  When you get there... e-mail Ex Nihilo, or Beanpole, or
'Ebenezer. 

SUB down
PSET (a, b), 0               'Delete the old one
DRAW "e10f10l20"             'by drawing over top of it in black.
b = b + 1                    'Move the picture down 1.
PSET (a, b), 12              'Redraw it.
DRAW "e10f10l20"             '  "    " .
PAINT (a + 3, b - 1), 14, 12 'Paint the yellow inside.
END SUB 'End the Sub(pretty self explanatory)

SUB left
PSET (a, b), 0   'See SUB DOWN... it's the same thing.
DRAW "e10f10l20"
a = a - 1
PSET (a, b), 12
DRAW "e10f10l20"
PAINT (a + 3, b - 1), 14, 12
END SUB

SUB right
PSET (a, b), 0   'See SUB DOWN it's the same thing...
DRAW "e10f10l20"
a = a + 1
PSET (a, b), 12
DRAW "e10f10l20"
PAINT (a + 3, b - 1), 14, 12

END SUB

SUB shoot
LINE (a + 10, b - 13)-(a + 10, b - 50), 10  'Draw the green shooting line.
FOR cool = 1 TO 100: NEXT cool              'Delay...
LINE (a + 10, b - 13)-(a + 10, b - 50), 0   'Draw over top of the shooting
                                            'line in black.
END SUB

SUB up
PSET (a, b), 0    'See SUB DOWN.  Same dif...
DRAW "e10f10l20"
b = b - 1
PSET (a, b), 12
DRAW "e10f10l20"
PAINT (a + 3, b - 1), 14, 12
END SUB

SUB warp
PAINT (a + 3, b - 1), 0, 12 'This SUB drops the ship somewhere else.
PSET (a, b), 0              'Figure it out each line by line for yourself...
DRAW "e10f10l20"            'I'm sick of explaining every little thing...
a = INT(RND * 300)
b = INT(RND * 180)
PSET (a, b), 12
DRAW "e10f10l20"
PAINT (a + 3, b - 1), 14, 12
FOR cool = 1 TO 1000: NEXT cool
END SUB
<PAGEEND:"Mouse.Routines.File1">

<PAGESTART:"Mouse.Routines.File2">
'<PRE>
REM This uses assembly language to make the mouse visible, get a keypress
REM and then make the mouse invisible again.
REM
REM Written by Ben McGaughey

DEFINT A-Z

DECLARE SUB InitMouse ()
DECLARE SUB ShowMouse ()
DECLARE SUB HideMouse ()

REM The total bytes in the ASM program is 6 so you devide that by 2
REM and this is what the array below has to be.
DIM SHARED ShowMouse1(3)
DIM SHARED HideMouse1(3)

InitMouse

ShowMouse
WHILE INKEY$ = "": WEND
HideMouse

END

DATA &HB8,&H01,&H00    : ' MOV AX,0001
DATA &HCD,&H33         : ' INT 33
DATA &HCB              : ' RETF

DATA &HB8,&H02,&H00    : ' MOV AX,0001
DATA &HCD,&H33         : ' INT 33
DATA &HCB              : ' RETF

SUB HideMouse

DEF SEG = VARSEG(HideMouse1(0))
CALL ABSOLUTE(VARPTR(HideMouse1(0)))
DEF SEG

END SUB

SUB InitMouse

REM This is poking the ASM program into the array.
DEF SEG = VARSEG(ShowMouse1(0))
FOR i = 0 TO 5
READ j
POKE (VARPTR(ShowMouse1(0)) + i), j
NEXT i
DEF SEG

DEF SEG = VARSEG(HideMouse1(0))
FOR i = 0 TO 5
READ j
POKE (VARPTR(HideMouse1(0)) + i), j
NEXT i
DEF SEG

END SUB

SUB ShowMouse

REM Now activate the program.
DEF SEG = VARSEG(ShowMouse1(0))
CALL ABSOLUTE(VARPTR(ShowMouse1(0)))
DEF SEG

END SUB
<PAGEEND:"Mouse.Routines.File2">

<PAGESTART:"Mouse.Routines.File3">
'<PRE>
'              ********************************************
'              *              QMouse.BAS                  *
'              *  Mouse Routine for MS-QBasic/IBM-QBasic  *
'              *                1 9 9 5                   *
'              ********************************************

'                    Robert Wolf TV & Radio Service

'********************************* INI *************************************

    DEFINT A-Z
    DECLARE SUB Mouse (cx, dx, bx)
    DECLARE SUB MousePointer (SW)
    DIM SHARED a(9)                 'Set up array for code
                                                           
    DEF SEG = VARSEG(a(0))          'Get array segment (nnnn:    )
                                    '    (two 8 bit)
    FOR i = 0 TO 17                 'length of DATA to
       READ r                       'read
       POKE VARPTR(a(0)) + i, r     'into array/2 (nnnn:iiii) (one 8 bit)
    NEXT i                          'until 17

'**************************** Machine Code *********************************

DATA &HB8,&H00,&H00   :   ' mov  AX,[n]       [Swap code-(L),(H)] in AX
DATA &H55             :   ' push BP           Save BP
DATA &H8B,&HEC        :   ' mov  BP,SP        Get BP to c Seg
DATA &HCD,&H33        :   ' int  33           Interrupt 33
DATA &H92             :   ' xchg AX,[reg]     [Swap code-reg] in AX
DATA &H8B,&H5E,&H06   :   ' mov  BX,[BP+6]    Point to (variable)
DATA &H89,&H07        :   ' mov  [BX],AX      Put AX in (variable)
DATA &H5D             :   ' pop  BP           Restore BP
DATA &HCA,&H02,&H00   :   ' ret  2            Far return

'*********************** P R O G R A M   S C R E E N ***********************

     CLS

COLOR 14, 0
PRINT "                   Ŀ                 "
PRINT "                      Q b a s i c     M o u s e                    "
PRINT "                                    "
COLOR 4, 0
PRINT "      "
COLOR 10, 0
PRINT "                                                                   [End]           "
LOCATE 6, 4
COLOR 15, 1

'****************************** Mouse set up ******************************
           
                CALL MousePointer(0)      'Reset mouse and
                CALL MousePointer(1)      'turn pointer on
                CALL MousePointer(3)      'Get coordinates

'****************************** P R O G R A M ******************************

    DO WHILE k$ <> CHR$(27)
          k$ = INKEY$

        CALL Mouse(cx, dx, bx)

           LOCATE 22, 60
           PRINT cx                          'Display Row
           LOCATE 22, 66
           PRINT dx
             
              IF bx = 1 THEN                 'Filter a 1 for Left
                bx$ = "[ L e f t "           'Set or skip bx$
               ELSEIF bx = 2 THEN            'Filter a 2 for Right
                bx$ = "[ R i g h t"          'Set or skip bx$
               ELSE
                bx$ = "[           ]"        'Blank for No Button Event
               END IF
           LOCATE 22, 5
           PRINT bx$                          'Display Button Event
          
           IF bx = 1 THEN                      'If Left Button Click's
             IF cx = 4 THEN
               IF dx > 67 AND dx < 71 THEN     'on [ESC] Then
                 GOTO done                     'End Program
                 END IF
              END IF
            END IF
    LOOP

'******************************** Exit *************************************
done:
                 CALL MousePointer(2)              'Turn mouse off
   
    LOCATE 22, 1
    PRINT "                        " + CHR$(177) + "     G O O D      B Y E       " + CHR$(177) + "                        "
COLOR 7, 0
    DEF SEG
   
END
'**************************** Return to Basic ******************************

SUB Mouse (cx, dx, bx)
         
           POKE VARPTR(a(4)), &H92           'Swap code,Get CX setup
          CALL absolute(cx, VARPTR(a(0)))     'Run Code
              cx = cx / 8                     'Adjust 25x80
           POKE VARPTR(a(4)), &H91           'Swap code,Get DX setup
          CALL absolute(dx, VARPTR(a(0)))     'Run Code
              dx = dx / 8                     'Adjust 25x80
           POKE VARPTR(a(4)), &H93           'Swap code,Get BX setup
          CALL absolute(bx, VARPTR(a(0)))     'Run Code

                                   'Note :
                                   'Remove the /8
                                   'for graphics modes.

END SUB

SUB MousePointer (SW)
         
           POKE VARPTR(a(0)) + 1, SW         'Swap code,Set AX = (SW)
          CALL absolute(c, VARPTR(a(0)))     'Run Code

                                          'Note:
                                             'SW = 0-reset
                                             'SW = 1-on
                                             'SW = 2-off
                                             'SW = 3-coordinates


END SUB
<PAGEEND:"Mouse.Routines.File3">

<PAGESTART:"Mouse.Routines.File4">
This Article From Peter Cooper's "The BASIC Fanzine"....
-------------------------------------------------------------------------------
- SECTION TWO PART 2 - (Programming the mouse) --------------------------------
-------------------------------------------------------------------------------

 This is programming the mouse by : peter@trenham.demon.co.uk

 Programming the mouse in QBasic is a very tedious affair although it is 
 possible but I cannot describe how to do it before this fanzine is meant
 to be out! So I am going to explain how to program the mouse in QuickBasic
 4.5 and PDS 7.1.

 To program the mouse we need to use interrupts. If you want a more indepth
 view into these then you will have to read the section on 'Interrupts in
 depth' next issue... patience...
 
 To be able to use interrupts you need QuickBasic or PDS 7.1 (both from
 Microsoft) and I think PowerBasic may also allow you to do this but I cannot
 be sure. On top of that you need a 'QB.BI' or 'QBX.BI' file. You get QB.BI
 with QuickBasic 4.5 and you get 'QBX.BI' with PDS 7.1. Substitute QBX.BI
 in my programs for whatever your one is called. 

 To start your program off you need to do this:
 
  '$INCLUDE: 'qbx.bi'
  Dim shared inregs as RegType
  Dim shared outregs as RegType
 
  SUB mousecommand (ax%,bx%,cx%,dx%)
  inregs.ax = ax%
  inregs.bx = bx%
  inregs.cx = cx%
  inregs.dx = dx%
  CALL INTERRUPT (&H33,inregs,outregs)
  END SUB
 
 Now, we have the definitions set up and we have a subroutine that gives the
 mouse driver commands. Beware, this subroutine does not return anything from
 the mouse... try and figure out how to do it.. if you can't then you'll have
 to keep reading. So now, what are the commands? Well here goes... here is
 a list of some of the mouse commands:

  AX = 00               (Reset Mouse)
  AX = 01               (Show Mouse Pointer)
  AX = 02               (Hide Mouse Pointer)
  AX = 03               (Get Mouse position and button status)
    - returned values:
                 in BX  =   0 no buttons down
                            1 left button down
                            2 right button down
                            3 both buttons down
                 in CX = x position
                 in DX = y position
 
 Right! Those commands should get anyone started! ;-) So lets add some more
 to the main part of our program.

 mousecommand 1,0,0,0

 That line (when run) would display the mouse pointer onto the screen. Try it
 out and see! Now, to do something useful with the mouse we would need to know
 where on the screen it actually was. We can get the X and Y coords by using
 AX = 03 (see the table above). So lets try this:

 mousecommand 3,bx%,cx%,dx%
 x% = cx%
 y% = dx%
 print x%,y%

 Now if we try that then we see that the x and y co-ords are NOT DISPLAYED!!
 Why? Well as I said earlier, the procedure does not return anything from the
 mouse... so we need a bit of an adjustment to our procedure...

 SUB mousecommand (ax%,bx%,cx%,dx%)
 inregs.ax = ax%
 inregs.bx = bx%
 inregs.cx = cx%
 inregs.dx = dx%
 CALL INTERRUPT (&H33,inregs,outregs)
 ax% = outregs.ax
 bx% = outregs.bx
 cx% = outregs.cx
 dx% = outregs.dx
 END SUB

 Now if we try then we see it works! Et voila, you have a program that reads
 the mouse once and then displays the coords on the screen. To have something
 more useful we could use this code in the main section of the program:

 mousecommand 1,bx%,cx%,dx%
 DO
 mousecommand 3,bx%,cx%,dx%
 x% = cx%
 y% = dx%
 locate 1,1
 print x%,y%
 LOOP WHILE bx% <> 1

 Try it and see how it works! Have fun with the mouse! 

 Mail me if you wish to see anything else mousewise covered...
 Cheers, 8-)
-------------------------------------------------------------------------------
<PAGEEND:"Mouse.Routines.File4">

<PAGESTART:"SB.Routines.File1">
This Article From Peter Cooper's "The BASIC Fanzine"....
-------------------------------------------------------------------------------
- SECTION TWO PART II - (Programming the SB card) -----------------------------
-------------------------------------------------------------------------------  

 On the comp.lang.basic.misc and alt.lang.basic newsgroups there are regularly
 questions like   ' How do program a SB from Basic? ' or 'How I detect an SB
 port address' or 'WAV FILES: playing through SB?' etc.
 This tute should address many of the problems faced by BASIC programmers.

 PROGRAMMING THE SB
 ==================

 Programming the SB is quite simple but the timing is the hard bit so I'm
 going into that in this tutorial. I'll just show you how to reset the card
 , turn the speaker on and produce a square-wave tone.

 The SB is controlled by a chip called the DSP (this is the Digital Sound
 Processor) and this is what we use in this tutorial. Before we can send
 raw data for the card to sound we need to reset the card.

' START OF RESET SECTION

OUT &H226, 1: OUT &H226, 0                      ' steps 1+2
DO
x% = INP(&H22E)                                 ' step 3
IF x% AND 128 THEN                              ' step 4
        x% = INP(&H22A)                         ' step 5
        IF x% = &HAA THEN                       ' step 6
                PRINT "reset!"
                EXIT DO
        END IF
END IF
LOOP

 That bit of program will reset the card. Here is what it does:

 1 - Send a 1 to the reset port  (2x6h)   
 1a - wait 3 microseconds. basic is so slow that i havn't had to bother
 2 - Send a 0 to the reset port  (2x6h)   
 3 - Poll the data ready port (2xEh)
 4 - If the 7th bit is not set then goto 3
 5 - Poll the data port (2xAh)
 6 - If it returns h0AA then you're done otherwise go back to step 3

 You should do this up to 100 times. If it doesn't work by then then the port 
 address is wrong or the card is faulty.
 (NOTE: where I put &H226 or &H22E is for a 220 based card. For a 240 they 
        would be    &H246 or &H24E OK?)

 OK. So now we've reset the thing but we still cannot send data because you
 won't hear it! The speaker has not been turned on.
 (The first time I programmed the SB, I didn't turn it on and I had to turn the
  speakers full up to hear anything. I went mad to find the solution!)
 The way we turn it on is to program the DSP with the hex byte D1. A sample
 is shown below.
 
' TURN SPEAKER ON
DO
x% = INP(&H22C)
LOOP WHILE x% AND 128
OUT &H22C, &HD1                                ' send speaker on code

 Before the byte can be sent we have to check if the SB is ready to get it.
 That's what the DO...LOOP does. So now the SBs speaker is on.

 Now we can send raw data to the card. But before each byte is sent we need
 to send 10 hex to tell the SB it is sound data we are doing.

DO
FOR g% = 100 TO 1 STEP -1                      ' START OF LOOP
OUT &H22C, &H10                                ' send
OUT &H22C, f%                                  ' send no.
FOR aa% = 1 TO 100: NEXT aa%                   ' delay
IF f% = 255 THEN f% = 0 ELSE f% = 255          ' alternate between 0 and 255
NEXT g%                                        ' END OF LOOP
LOOP

The f% is the value that is the sound on the sound wave. BTW, if you want to
play WAV,VOC or RAW files what you need to do is read a byte from the file
each time and send it to the card after sending the &H10. More about that, in
the next fanzine. (but you might work it out from I just said ,by then)

Here's the full program that produces a tone by alternating from 0 to 255 and
back. Change the aa% loop for a different pitched note.

' START OF RESET SECTION

OUT &H226, 1: OUT &H226, 0
DO
x% = INP(&H22E)
IF x% AND 128 THEN
        x% = INP(&H22A)
        IF x% = &HAA THEN
                PRINT "reset!"
                EXIT DO
        END IF
END IF
LOOP

' END OF RESET SECTION


' TURN SPEAKER ON
DO
x% = INP(&H22C)
LOOP WHILE x% AND 128
OUT &H22C, &HD1                                ' send speaker on code

DO
FOR g% = 100 TO 1 STEP -1                      ' START OF LOOP
OUT &H22C, &H10                                ' send
OUT &H22C, f%                                  ' send no.
FOR aa% = 1 TO 100: NEXT aa%                   ' delay
IF f% = 255 THEN f% = 0 ELSE f% = 255          ' alternate between 0 and 255
NEXT g%                                        ' END OF LOOP
LOOP

 Hope that's useful.
-------------------------------------------------------------------------------
<PAGEEND:"SB.Routines.File1">

<PAGESTART:"Tutorial.Gametech.File">
This Article From Peter Cooper's "The BASIC Fanzine"....
-------------------------------------------------------------------------------
| SECTION 1 PART B SUBPART 4 | Simple game development |
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
                            Game Development
                            ~~~~~~~~~~~~~~~~
                              Introduction
                        1-Before you get Started                                                               
                            2-Writing a Game
                          3-Tips and Reference
 
                              Introduction
                              ~~~~~~~~~~~~
   Making computer games is not as hard as it seems. In this article I'm
going to explain the basics of making games. This article will be tilted
towards simple games, but these steps are used in just about every game
ever made.

Section 1

Before you get started making a game you should have a few things.

Step 1. Planning
       1. An idea. This is the most important part of making a game.

       2. Once you have an idea, think up a storyboard. This is not necessary
          always. For example, Tetris doesn't have a story.

       3. Now, plan the Levels. If the game has several levels, think how they
          are going to look.

       4. After you have the basic concept, think about goals. There has to be
          some kind of goals to make the player keep playing.

       5. Now think about the gameplay.  Gameplay makes a game.  Without gameplay
          the game is boring.

       6. Finally think of little bonuses you can add.(Score, explosions, sounds,
          animations, Level completion bonuses, Power-ups, etc.)  Use these to
          spice the game up.

Step 2. Tools
       1. First, you're going to need a graphics program(unless it's a
          text -adventure OR it's graphics are ASCII characters).  Personally
          I suggest QBDRAW17(it's only Screen 13 though). There are several
          graphics programs available(Check Simtel) or you could draw in Window's
          Paint Brush or another commercial program(you'll need some GIF, PCX or
          BMP code to load these though)

       2. Second, you're going to need some Algorithms for Artificial
          Intelligence. here's an Example,
          In Space Invaders, the enemies algorithym was:
  
          1. Go Right until Wall.
          2. When hit wall go Left.
          3. Go Left until Wall.
          4. When hit wall go Right.
          5. Move Down.
          6. Loop back to step 1.

       3. Code for Input Devices. (Keyboard, Joystick, Mouse,etc.)  You can get
          this just about anywhere.

       4. Music and Sound. There is nothing wrong with using the PC Speaker to do
          sounds(Just don't put long and annoying Music that'll wake up your
          parents at 3 AM) Remember, you can't adjust the PC Speaker's volume(at
          least from the outside). If you're going to have Sound Blaster sounds,
          find some libraries(it's not easy to write them yourself).

Section 2

Now we are going to write a Pong Game

{Cut here}
********************************************************
SCREEN 13: CLS                  'Screen with 256 colors
DIM Sphere(100)                 'Allocate memory for sprites
DIM Paddle(200)
PAINT (160, 100), 201           'Paint Background
CIRCLE (160, 100), 7, 4         'Draw Ball
PAINT (160, 100), 4             'Paint Ball
LINE (10, 10)-(18, 50), 1, BF    'Draw Paddle

GET (151, 92)-(169, 108), Sphere  'Get Sprites and store in array
GET (9, 4)-(19, 56), Paddle
CLS : PAINT (160, 100), 201       'Clear and Repaint screen
                                  'Initialize Variables
p1 = 0: p2 = -1    'Scores
X = 1: Y = 1       'Ball's Location
X1 = 5: Y1 = 75    'Player 1's Location
X2 = 295: Y2 = 75  'Player 2's Location

DO WHILE INKEY$ <> CHR$(27)   'Begin Main Program Loop and loop until ESC
                              'is pressed.
LOCATE 1, 8: PRINT p1: LOCATE 1, 36: PRINT p2   'Print Scores

GOSUB Keys
IF X > 300 THEN Xadj = -2: p1 = p1 + 1: SOUND 200, 1 'See if Ball hits Side

IF X <= 1 THEN Xadj = 2: p2 = p2 + 1: SOUND 200, 1   'See if Ball hits Side

IF Y >= 180 THEN Yadj = -2: SOUND 200, 1             'See if Ball hits Top
IF Y <= 1 THEN Yadj = 2: SOUND 200, 1                'See if Ball hits Top

  FOR i = 1 TO 3               'Continously move Ball
    X = X + Xadj
    Y = Y + Yadj
    PUT (X, Y), Sphere, PSET
  NEXT i

  PUT (X1, Y1), Paddle, PSET   'Put Paddles
  PUT (X2, Y2), Paddle, PSET
  FOR q% = 1 TO 100            'Add Delay (Increase if game runs too fast)
  GOSUB Keys
  NEXT q%

 SELECT CASE Y   'If the Ball is within one of the Paddle's Y Range,
                 'Compare it's X Location
   CASE (Y1 - 15) TO (Y1 + 30)
   GOSUB Precheck

   CASE (Y2 - 15) TO (Y2 + 30)
   GOSUB Precheck
 END SELECT

LOOP    'Main Program Loop

Precheck:        'Since the last Case found their Y location similiar, It
SELECT CASE X    'checks their X locations. If it's in range, contact occurs.

  CASE X1 TO (X1 + 10)      'Reverse Ball's X direction and play Sound to show
  Xadj = 2: SOUND 37, 1    'contact occured
			 
  CASE (X2 - 10) TO X2      'Reverse Ball's X direction and play Sound to show
  Xadj = -2: SOUND 37, 1   'contact occured
END SELECT
RETURN


Keys:
 SELECT CASE INKEY$                'Get Input from Keyboard
  CASE IS = CHR$(0) + CHR$(72)     'Player 1 Up
  GOSUB up

  CASE IS = CHR$(0) + CHR$(80)     'Player 1 Down
  GOSUB Down

  CASE IS = "Q", "q"               'Player 2 Up
  GOSUB Up2

  CASE IS = "A", "a"               'Player 2 Down
  GOSUB Down2
 END SELECT
RETURN

Down:                        'Move First Player Down
  IF Y1 < 142 THEN           'Makes sure Paddle doesn't go Offscreen
   FOR i = 1 TO 3            'Make Animation Smooth
    Y1 = Y1 + 3
    PUT (X1, Y1), Paddle, PSET
    Y1 = Y1 + 3
   NEXT i
  END IF
RETURN       'Go back to Main Program


Down2:                       'Move Second Player Down
  IF Y2 < 142 THEN           'Makes sure Paddle doesn't go Offscreen
   FOR i = 1 TO 3            'Make Animation Smooth
    Y2 = Y2 + 3
    PUT (X2, Y2), Paddle, PSET
    Y2 = Y2 + 2
   NEXT i
  END IF
RETURN        'Go back to Main Program

up:                          'Move First Player Up
  IF Y1 > 6 THEN             'Makes sure Paddle doesn't go Offscreen
    FOR i = 1 TO 3           'Make Animation Smooth
     Y1 = Y1 - 3
     PUT (X1, Y1), Paddle, PSET
     Y1 = Y1 - 3
    NEXT i
  END IF
RETURN         'Go back to Main Program

Up2:                     'Move Second Player Up
  IF Y2 > 6 THEN         'Makes sure Paddle doesn't go Offscreen
    FOR i = 1 TO 3       'Make Animation Smooth
     Y2 = Y2 - 3
     PUT (X2, Y2), Paddle, PSET
     Y2 = Y2 - 3
    NEXT i
  END IF
RETURN         'Go back to Main Program

*******************************************************
{cut here}


Section 3

Remember, don't try to over-achieve yourself on your First game.
In other words, On your first try, make something like Pac-Man, not DOOM.

A game can be broken down in a few sections

1. The Game World and it's Data
2. The Graphics Engine(Which draws the sprites on the screen)
3. The Input/Output System(Whether it's the Keyboard, Joystick or Mouse)       
4. The Game's Artificial Intelligence System
5. The Main Game Loop(The Loop that continously loops during the game)
6. The User Interface(Title Screen, Options, Score, Lives, Energy, etc.) 
7. The Sound Effects system(Spices up the Gameplay)

Any Questions should be directed to me at: diego@sgi.net

Check out my NEW and Constantly updated Web Page at:

Http://www.geocities.com/SiliconValley/6165/
-------------------------------------------------------------------------------
<PAGEEND:"Tutorial.Gametech.File">

<PAGESTART:"Type.Example.File">
This Article From Peter Cooper's "The BASIC Fanzine"....
-------------------------------------------------------------------------------
QUESTION: Hello,
      
 Can you please write me a little program that will show me how to use and
 what they are used for?

 NOTE ::: Please write me a program that will show me what the X's are susposed
 to be.  Also tell me what each of them does.

 TYPE (XxXxXxX)
     (XxXxXxX) as (XxXxXxX)
 END TYPE
 and 
 DIM (XxXxXxX) as (XxXxXxX)
 or
 REDIM (XxXxXxX) as (XxXxXxX)

ANSWER: Ok. The things you are mentioning here are records (thats what I call
        them) This would be simpler with explanation.

        TYPE person
                age as integer
                name as string * 20
                address as string * 80
        END TYPE

        This is a 'type' for one person.. It is a defined type. To be able to
        enter data in it properly then you need to DIM it like so:

        DIM SHARED people as person

        Now you can enter data into it like so:

        people.age = 52
        people.name = "fred bloggs"
        people.address = "Topeka City, Winconsin etc.."

        Of course, you can file these to disk using the PUT command, refer
        to qbasic help. You can also declare arrays of these types:

        DIM SHARED people(50) as person

        This would generate '50 people' and you can edit their details etc:

        people(1).age = 25
        people(1).name = "john"
        people(2).age = 50
        people(2).name = "bert"
        etc...

        These are powerful tools.. you can even use them in games, such as
        adventure games where you need to keep track of what screen a certain
        direction goes to (this is just an example and not neccesarily the
        best way to do it):

        TYPE location
                title as string * 50
                ident as integer
                picfile as string * 12
                north as integer
                south as integer
                west as integer
                east as integer
        END TYPE

        If anyone needs more help then please mail me, or post to the basic
        newsgroups.
-------------------------------------------------------------------------------
<PAGEEND:"Type.Example.File">

<PAGESTART:"Encryption.Routines.File1">
DECLARE SUB Encrypt (PW$, st$)
'This file was from the ABC packets (forget by whom). Anyway the file was for
'PB, but I have converted it into QBasic/QuickBASIC code. So enjoy !
'
'The SUB Encrypt encrypt's text.
'So first call the sub and give a password and text. The sub returns the
'encrypted data. Now call the sub, with the same password and the encrypted
'text. You'll get the first message.
'
'Thank's a lot to the original author.

CLS
COLOR 12, 7
INPUT "Type in password "; password$            'Input password

text$ = "This is sample text"                   'Change to whatever
PRINT "The text to be encrypted is: "; text$

CALL Encrypt(password$, text$)                  'Call the sub `Encrypt'

'The SUB Encrypt returns the encrypted text to variable name `target$'

PRINT "Encrypted text: "; target$               'Print the encrypted text
text$ = target$

INPUT "Reenter password "; password$          'Reenter password for decryption

CALL Encrypt(password$, text$)                  'Decrypt text

PRINT "Deencrypted text: "; target$             'Print decrypted text

PRINT "Enjoy"

SUB Encrypt (PW$, st$)
SHARED target$
z = 0
target$ = ""
FOR Y = 1 TO LEN(st$)
        a$ = MID$(st$, Y, 1)
        z = z + 1
        IF z > LEN(PW$) THEN z = 1
        b$ = MID$(PW$, z, 1)
        target$ = target$ + CHR$(ASC(a$) XOR ASC(b$))
NEXT
st$ = target$
END SUB
<PAGEEND:"Encryption.Routines.File1">

<PAGESTART:"Encryption.Routines.File2">
'>   But my question is: Can we talk about and share code for
'>   en/decoders? Since this topic is on my mind anyway, has
'>   anyone programmed a MIME-en/decoder and/or a UUEn/Decoder?
'>........................................
'   One of the simplest forms of encoding to text is to convert
'from an 8-bit value to 6-bit. This allows you to have three
'normal ASCII characters coverted to four characters  within the
'range of the lower, message format usable, ASCII. Try this:
'_|_|_|  826_BIT.BAS
'_|_|_|  This program demonstrates one method of encoding data
'_|_|_|  to conform to low ASCII requirements by turning three
'_|_|_|  8-bit values into four 6-bit values and vice-verse.
'_|_|_|  No warrantees or guarantees are given or implied.
'_|_|_|  Released to   PUBLIC DOMAIN   by Kurt Kuzba.  (6/1/96)
DECLARE FUNCTION ENCODE$ (Bytes3$)
DECLARE FUNCTION UNCODE$ (Bytes4$)
PRINT : PRINT
test$ = CHR$(176) + CHR$(177) + CHR$(178)
PRINT test$, ENCODE$(test$), UNCODE$(ENCODE$(test$))
test$ = CHR$(254) + CHR$(219) + CHR$(129)
PRINT test$, ENCODE$(test$), UNCODE$(ENCODE$(test$))
test$ = CHR$(17) + CHR$(21) + CHR$(7)
PRINT test$, ENCODE$(test$), UNCODE$(ENCODE$(test$))
test$ = "ABC"
PRINT test$, ENCODE$(test$), UNCODE$(ENCODE$(test$))
'_|_|_|   end   826_BIT.BAS

FUNCTION ENCODE$ (Bytes3$)
   Result$ = "": B& = 0
   FOR t% = 3 TO 1 STEP -1
      B& = B& * 256 + ASC(MID$(Bytes3$, t%))
   NEXT
   FOR t% = 1 TO 4
      Result$ = Result$ + CHR$(48 + (B& AND 63)): B& = B& \ 64
   NEXT: ENCODE$ = Result$
END FUNCTION

FUNCTION UNCODE$ (Bytes4$)
   Result$ = "": B& = 0
   FOR t% = 4 TO 1 STEP -1
      B& = B& * 64 + ASC(MID$(Bytes4$, t%)) - 48
   NEXT
   FOR t% = 1 TO 3
      Result$ = Result$ + CHR$(B& AND 255): B& = B& \ 256
   NEXT: UNCODE$ = Result$
END FUNCTION
<PAGEEND:"Encryption.Routines.File2">

<PAGESTART:"Encryption.Routines.File3">
'   As promised 87 years ago, here is a simple key-file generation
' program.  It is designed to keep honest people honest, as any
' hacker can break it by either breaking the code or patching the
' original program to bypass the registration checking.
'   As written, this will generate a simple key and includes the
' code to check that the key can be decoded.  Several things need
' to be done before it is used in 'real life'.  I'll list them in a
' minute.

' What it does:
'   1 - Generates a key file that includes a CRC check and an
'       embedded registration name and serial number.
'     - The first two lines of this file show the registration
'       name and serial number.  These lines are not used by the
'       program and can be changed without affecting the programs
'       operation as long as total line length is not changed.
'       They are included so you can do a quick check of who that
'       key is for.  This allows you to make several keys at once
'       and then sort out who gets which one (you would need to
'       include a routine to change the key file name after each
'       generation.
'     - The remaining space is filled by randomly generated ASCII
'       characters, with the TIMER function used to seed the random
'       generator.
'     - The display name and serial number are then encrypted and
'       the letters scattered about the random ASCII.
'     - A 16 bit CRC check is performed, and the value is encrypted
'       and and put into an area not included in the CRC check.
'
'   2 - Generates a historical record, with enough information to
'       generate an identical key at a later date. (This prevents a
'       couple of people from registering a program and getting a
'       key, then requesting a replacement key and comparing the
'       differences in order to break the encryption.)
'     - This data includes the registration name, serial number,
'       date the key is generated, and the seed for the random
'       generator.
'
' What it needs to be usable:
'   1 - Better routines for getting the display name and serial
'       number.  I decided to not waste bandwidth on examples that
'       others have already made.
'   2 - Larger areas for the display name and serial number.  I
'       limited these also for space
'   3 - Places for an address in the historical file
'   4 - Routines to compare names and serial numbers for dupes
'   5 - Routine to look through historical file and select one and
'       generate a replacement key based on the information found.
'   6 - A field for different levels of registration.  That is easy
'       to add using the procedures demonstrated.
'   7 - A drop-dead date for temporary keys.  I suggest that the
'       number of days since some arbitrary date be selected as the
'       base date (1 Jan 1900 ??) and then a value be added with
'       the days after the base date as the drop dead date.  Using
'       the same basedate in the generator and the actual program,
'       an imbedded 'total days' number can be made with each temp
'       key.  Use the system date to get 'current total days'.
'       This prevents someone from hacking a new month into the
'       temp key.
'   8 - Change the encryption value of 64 to 'your' value, between
'       64 and 100.
' So, without further comment (HA!), here it is.  Comments?

' Onwards....


'------------------
' generate registration keys for programs

DECLARE FUNCTION crc16% (target$)

' define structure file 1 - which holds your list of past keys
TYPE KeyRecord
   Regno AS STRING * 10
   RegName AS STRING * 30
   Datereg AS STRING * 10
   Rndseed AS LONG
   LnTrn AS STRING * 2

END TYPE
DIM FileBuffer AS KeyRecord
  FileBuffer.LnTrn = CHR$(13) + CHR$(10)
DIM namepoint(20), serpt(20)
namlength = 5
seriallength = 5

' open file 1 as past keys
CLS

GOSUB oldkey

GOSUB getrandseed:  ' get a seed value for the random function

GOSUB opnkey: ' open the new KeyFile.Dat to write in the values

' get display name for key file.  Replace this routine with a better one
INPUT "What display name do you want to use "; Dspnam$
Dspnam$ = LEFT$(Dspnam$ + SPACE$(namlength), seriallength)

' get serial/registration number.  Replace this routine, also.
INPUT "What is the serial number "; srnmbr$
srnmbr$ = LEFT$(srnmbr$ + SPACE$(seriallength), seriallength)

' check on dupes of names and numbers

' get date of registration
   FileBuffer.Datereg = DATE$

' put info into file one and update
   FileBuffer.Regno = srnmb$
   FileBuffer.RegName = Dspnam$
   FileBuffer.Rndseed = rseed
   FileBuffer.LnTrn = CHR$(13) + CHR$(10)
   totrec = totrec + 1
   PUT #1, totrec, FileBuffer
   GET #1, 1, FileBuffer
   FileBuffer.Rndseed = totrec
   PUT #1, 1, FileBuffer


' generate key - file 2

' pad name with spaces to center
   namspac = LEN(Dspnam$)
   namfre = 80 - namspac - 2
   line1$ = SPACE$(namfre / 2) + Dspnam$ + SPACE$(namfre / 2) + CHR$(13) + CHR$(10)
' put in Key File for your info only.  You use to confirm which key you
' are sending to who, by using a doc viewer
LSET fuline$ = line1$
PUT #2, 1

' pad serial with spaces to center
   serspac = LEN(srnmbr$)
   serfre = 80 - serspac - 2
   line2$ = SPACE$(serfre / 2) + srnmbr$ + SPACE$(serfre / 2) + CHR$(13) + CHR$(10)

  ' put in file 2 as second line
LSET fuline$ = line2$
PUT #2, 2

' close out the two lines and re-open data file as 1 byte
GOSUB keyfill

  ' fill file 2 with random values
RANDOMIZE (-rseed)

  FOR x = 161 TO 500
      LSET PtFilr$ = CHR$(RND * 255)
      PUT #2, x
   NEXT x

' read locations for name letters
RESTORE namdatpt

  FOR x = 1 TO namlength
     READ namepoint(x)
  NEXT x

 FOR x = 1 TO namlength
'   convert name digit coded letter
  mp$ = CHR$((ASC(MID$(Dspnam$, x, 1)) + 64))
  LSET PtFilr$ = mp$
   PUT #2, namepoint(x)
 NEXT x

' read location for serial number
RESTORE serldatpt
  FOR x = 1 TO seriallength
    READ serpt(x)
  NEXT x

 FOR x = 1 TO seriallength
   sp$ = CHR$((ASC(MID$(srnmbr$, x, 1)) + 64))
   LSET PtFilr$ = sp$
   PUT #2, serpt(x)
 NEXT x

' calculate the CRC
testcr$ = ""
 FOR x = 161 TO 450
 GET #2, x
 testcr$ = testcr$ + PtFilr$
NEXT x

' calculate the crc, convert to a string so you can hide it
crcnumber = crc16(testcr$)
PRINT "crc checks as "; crcnumber
crcname$ = STR$(crcnumber)
crcname$ = LEFT$(LTRIM$(crcname$) + "aAbBcCdDeEfFgGhHiIjJkKlL", 10)

'PRINT "crc word = "; crcname$; "  and value "; VAL(crcname$)
' put the CRC at point 460 , incrementing the value of each letter
'   so it doesn't stand out as a number
FOR x = 460 TO 469
  LSET PtFilr$ = CHR$(ASC(MID$(crcname$, x - 459, 1)) + 64)
  PUT #2, x
NEXT x

' ----
' This is the part that would be in the program being protected.  It
' is put here to demonstrate the program works.
' The data points and file opening routines would need to be copied,
' also.


' retrieve the stored CRC
rechk$ = ""
FOR x = 460 TO 469
  GET #2, x
  rechk$ = rechk$ + CHR$(ASC(PtFilr$) - 64)
NEXT x
crcchk2 = VAL(rechk$):  ' the stored CRC value


' calculate the CRC
testcr$ = ""
 FOR x = 161 TO 450
 GET #2, x
 testcr$ = testcr$ + PtFilr$
NEXT x
crcnumber = crc16(testcr$)

IF crcchk2 = crcnumber THEN
  PRINT "They match as "; crcnumber
     Dspnam$ = ""
     FOR x = 1 TO namlength
'      convert digit coded letter to name
       GET #2, namepoint(x)
       mp$ = CHR$((ASC(PtFilr$) - 64))
       Dspnam$ = Dspnam$ + mp$
     NEXT x
       PRINT "Display Name is "; Dspnam$

  ELSE PRINT "No Match: something was changed ";
       PRINT crcnumber; " "; crcchk2

END IF

CLOSE
END


oldkey:
CLOSE #1
OPEN "oldkey.dat" FOR RANDOM AS #1 LEN = LEN(FileBuffer)
GET #1, 1, FileBuffer
  ' check if there is a data file.  If not, start one.
  IF INSTR(FileBuffer.Regno, "Start") = 0 THEN
    FileBuffer.Regno = "Start"
    FileBuffer.RegName = "No-Name"
    FileBuffer.Datereg = DATE$
    FileBuffer.Rndseed = 1
    FileBuffer.LnTrn = CHR$(13) + CHR$(10)
    PUT #1, 1, FileBuffer
    totrec = 1
  END IF
totrec = FileBuffer.Rndseed:  ' total registrations on file

RETURN


opnkey: ' open the new key file
CLOSE #2
OPEN "NewKey.DAT" FOR RANDOM AS #2 LEN = 80
  FIELD #2, 80 AS fuline$
RETURN

keyfill:
CLOSE #2
OPEN "NewKey.dat" FOR RANDOM AS #2 LEN = 1
FIELD #2, 1 AS PtFilr$
RETURN



getrandseed: ' get the random seed
rseed = INT(TIMER)
rseed = ABS(rseed)

RETURN

' below are the data areas where you specify the location inside the random
' generated area for the storage of your values.  For demo purposes, I am
' limiting the number of values so it is easy to visually check there are
' not any locations specified twice.  In actual practice, I suggest you
' write a random list - in order - on a piece of paper and scratch the
' values off as you put them here.

namdatpt: ' random data points for the name
DATA 241, 152, 423, 367, 275

serldatpt: ' random locations for the serial number
DATA 342, 467, 199, 300, 400

FUNCTION crc16% (target$)
STATIC Initialized%, CRCTable%()
' 05-25-93  Douglas Lusher  16bit CRC calculation  1:282/7
IF Initialized% GOTO CalcCRC16

REDIM CRCTable%(255)
FOR Ptr% = 0 TO 255
  CRC& = Ptr% * &H100&
  FOR Bit% = 0 TO 7
    Carry% = ((CRC& AND &H8000) <> 0)
    'Carry% is True if Bit 16 is set
    CRC& = (CRC& * 2) AND &HFFFF&
    'shift the low 16 bits one place left
    CRC& = CRC& XOR (Carry% AND &H1021)
    'if there was a carry, then XOR in the bitmask
  NEXT
  CRCTable%(Ptr%) = (CRC& - 32768) XOR &H8000
  'change the long int to an unsigned int for the table
NEXT
Initialized% = -1

CalcCRC16:

HiByte% = 0
LoByte% = 0
FOR Ptr% = 1 TO LEN(target$)
  Char% = ASC(MID$(target$, Ptr%))
  CRC& = CRCTable%(HiByte% XOR Char%) XOR LoByte%
  CRC& = CRC& * &H100
  HiByte% = (CRC& AND &HFF0000) \ &H10000
  LoByte% = ((CRC& AND &HFF00&) - 32768) XOR &H8000
NEXT
crc16% = HiByte% OR LoByte%

END FUNCTION
<PAGEEND:"Encryption.Routines.File3">

<PAGESTART:"Fire.Routines.File1">
'
' Description : Fyre - Mode 13 VGA Special Effect Routine
' Written by  : Andrew L. Ayers
' Date        : 09/10/96
'
' This shows off two techniques which may prove useful to you in game or
' demo development. The first technique is that of simulating fire. It
' uses a routine similar to that of my FirePrint! routine for doing
' burning text. I saw a post by someone (I forget who) who needed to
' know how to do fire. I hope they see this. The second technique is the
' more important of the two. It shows how to use a single buffer to hold
' multiple frames of an animation for GET/PUT. Basically, it involves using
' an offset into the buffer during the Build/GET process to store each
' frame into the buffer, then using the same offsets to replay the buffer
' frame by frame. You must know the size of each "frame" in bytes in order
' to use this, and all frames should be the same size for easiest implem-
' entation (though not necessarily). This will work for all screen modes.
'
' As always, if you use this in any of your creations, please consider your
' source and mention my name. Thanx, and have phun!
'
DECLARE SUB ReadRGB (red%, grn%, blu%, slot%)
DECLARE SUB WriteRGB (red%, grn%, blu%, slot%)
DECLARE SUB SetPal (start.slot%, end.slot%)
'
DIM frame%(3400)
'
SCREEN 13
'
' Create an "all black" palette
'
CALL WriteRGB(0, 0, 0, 1)
CALL WriteRGB(0, 0, 0, 63)
'
CALL SetPal(1, 63)
'
' Build each frame of the "fyre"
'
LINE (0, 101)-(14, 101), 63
'
FOR t% = 0 TO 19
  '
  FOR Y% = 100 TO 80 STEP -1
    '
    FOR X% = 0 TO 14
      '
      C% = POINT(X%, Y% + 1) - INT(RND * 10): IF C% < 0 THEN C% = 0
      '
      PSET (X%, Y%), C%
      '
    NEXT
    '
  NEXT
  '
  ' Get the frame
  '
  GET (0, 80)-(14, 101), frame%(t% * 170)
  '
NEXT
'
CLS
'
' Build up "fyre" colored palette
'
CALL WriteRGB(0, 0, 0, 1)
CALL WriteRGB(63, 0, 0, 21)
CALL WriteRGB(63, 63, 0, 42)
CALL WriteRGB(58, 58, 58, 63)
'
CALL SetPal(1, 21)
CALL SetPal(21, 42)
CALL SetPal(42, 63)
'
' Display "fyre" at the bottom of the screen
'
DO
  '
  t% = t% + 1: IF t% > 19 THEN t% = 0
  '
  FOR tt% = 0 TO 300 STEP 15
    '
    PUT (tt%, 178), frame%(t% * 170), PSET
    '
  NEXT
  '
  ' Delay (may need to be adjusted)
  '
  FOR dlay = 1 TO 20000: NEXT dlay
  '
LOOP UNTIL INKEY$ <> ""

SUB ReadRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C7, slot% ' Read RGB values from slot
  '
  red% = INP(&H3C9)
  grn% = INP(&H3C9)
  blu% = INP(&H3C9)
  '
END SUB

SUB SetPal (start.slot%, end.slot%)
  '
  num.slots% = end.slot% - start.slot%
  '
  CALL ReadRGB(sr%, sg%, sb%, start.slot%)
  CALL ReadRGB(er%, eg%, eb%, end.slot%)
  '
  rr% = ABS(er% - sr%): rg% = ABS(eg% - sg%): rb% = ABS(eb% - sb%)
  rs% = SGN(er% - sr%): gs% = SGN(eg% - sg%): bs% = SGN(eb% - sb%)
  '
  stepr = (rr% / num.slots%) * rs%
  stepg = (rg% / num.slots%) * gs%
  stepb = (rb% / num.slots%) * bs%
  '
  r = sr%: g = sg%: b = sb%
  wr% = r: wg% = g: wb% = b
  '
  FOR t% = start.slot% TO end.slot%
    '
    CALL WriteRGB(wr%, wg%, wb%, t%)
    '
    r = r + stepr: wr% = r
    g = g + stepg: wg% = g
    b = b + stepb: wb% = b
    '
  NEXT t%
  '
END SUB

SUB WriteRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C8, slot% ' Write RGB values to slot
  '
  OUT &H3C9, red%
  OUT &H3C9, grn%
  OUT &H3C9, blu%
  '
END SUB
<PAGEEND:"Fire.Routines.File1">

<PAGESTART:"Fire.Routines.File2">
'Fire!!  By Tony Lieuallen.  E-mail: marvin@mars.superlink.net
'This is a demo I made (Evolved slowly from the file in the PC Games
'Programmers Encyclopedia) in my free time.  In the rem's is what you
'would have to do to make it run in PB (originally written for QuickBasic).
'I like values of XMax=200 YMax=100 X and YStart=50.

DEFINT A-Z

SCREEN 13
' in PB make this:
'      (or is that ah?)
'! mov ax, &H13
'! int &H10

RANDOMIZE TIMER
IF COMMAND$ <> "" THEN
   T$ = COMMAND$
   XMax = VAL(LEFT$(T$, INSTR(T$, " ")))
   T$ = RIGHT$(T$, LEN(T$) - INSTR(T$, " "))
  
   YMax = VAL(LEFT$(T$, INSTR(T$, " ")))
   T$ = RIGHT$(T$, LEN(T$) - INSTR(T$, " "))
  
   XStart = VAL(LEFT$(T$, INSTR(T$, " ")))
   T$ = RIGHT$(T$, LEN(T$) - INSTR(T$, " "))
  
   YStart = VAL(T$)
ELSE
   INPUT "  XMax=", XMax
   INPUT "  YMax=", YMax
   INPUT "XStart=", XStart
   INPUT "YStart=", YStart
END IF
CLS

CMax = 150
Red = 0
Grn = 0
Blu = 0
CC = 1

FOR X = 1 TO CMax
   SELECT CASE CC
      CASE 1
         Red = Red + 1
         IF Red = 60 THEN CC = 2
      CASE 2
         Grn = Grn + 1
         IF Grn = 60 THEN CC = 3
      CASE 3
         Grn = Grn - 2
         Red = Red - 1
   END SELECT
   OUT &H3C8, X
   OUT &H3C9, Red
   OUT &H3C9, Grn
   OUT &H3C9, Blu
NEXT

DEF SEG = &HA000
DO
   IF INKEY$ <> "" THEN
      COLOR 180
      SYSTEM
   END IF
   FOR Count = 1 TO XMax \ 1.5
      Y& = (YMax - 1 + YStart)
      'In PB make all the "poke"s "pokeb"s
      POKE (320 * Y& + (INT(RND * XMax) + XStart)), INT(RND * CMax)
      POKE (320 * (Y& - 1) + (INT(RND * XMax) + XStart)), INT(RND * CMax)
   NEXT

   P = 0
   FOR Y1 = 2 TO YMax - 1
      FOR X1 = 2 TO XMax - 1
         X& = (X1 + XStart)
         Y& = (Y1 + YStart)
         P = PEEK(320 * Y& + (X& + 1))
         P = P + PEEK(320 * Y& + (X& - 1))
         P = P + PEEK(320 * (Y& + 1) + X&)
         P = P + PEEK(320 * (Y& - 1) + X&)
         P = P \ 4
         POKE (320 * (Y& - 1) + X&), P
      NEXT
   NEXT
LOOP
<PAGEEND:"Fire.Routines.File2">

<PAGESTART:"Fire.Routines.File3">
' Description : FirePrint! - Custom text print subroutine for
'               VGA Mode 13
' Written by  : Andrew L. Ayers
' Date        : 07/24/96
'
' This little routine allows you to place a "burning" text
' string on the mode 13 screen. This routine was based on
' a routine by Martin Lindhe. Both are essentially the same,
' though this one is cleaner. Remember, the better the machine,
' the better the effect. Also, smaller strings will look better.
'
' You may use this routine in any manner you like, as long
' as you give Mr. Lindhe and myself credit in an appropriate
' manner.
'
' I wish to thank Martin Lindhe for providing the inspiration
' to do this routine.
'
DECLARE SUB FirePrint (h%, v%, a$, tilt%)
'
SCREEN 13
'
' Set up an all "red" palette
'
FOR t = 0 TO 63: PALETTE t, t: NEXT t
'
' Call the routine once for a simple "flame" effect,
' or over and over (as done here) for a great "burning"
' effect! Use uppercase for best effect.
'
DO
  CALL FirePrint(18, 12, "FIRE!", 0)
LOOP UNTIL INKEY$ <> ""

SUB FirePrint (h%, v%, a$, tilt%)
  '
  ' Print the string in bright "red"
  '
  COLOR 63: LOCATE v%, h%: PRINT a$
  '
  ' Set up start and end locations for the burn
  '
  sx% = (h% * 8) - 8: ex% = ((h% + LEN(a$)) * 8) - 8
  sy% = (v% * 8) - 16: ey% = (v% * 8) - 8
  '
  FOR y% = sy% TO ey%
    FOR x% = sx% TO ex%
      '
      ' Take the current color, subtract a random amount for
      ' red flame "fade", and plot the new point
      '
      col% = POINT(x%, y%) - RND * 25: IF col% < 0 THEN col% = 0
      '
      PSET (x% + tilt%, y% - 1), col%
      '
    NEXT x%
  NEXT y%
  '
END SUB
<PAGEEND:"Fire.Routines.File3">

<PAGESTART:"Explosion.Routines.File1">
'
' Description : Explosions - VGA mode 13 special effect
' Written by  : Andrew L. Ayers
' Date        : 10/22/96
'
' The name says it all!
'
' You may use this routine in any manner you like, as long
' as you give credit in an appropriate manner. Have phun!
'
SCREEN 13
'
' Set up arrays for our explosion data
'
DIM x(50), y(50), xv(50), yv(50), ox(50), oy(50)
'
DO
  '
  ' Initialize an explosion
  '
  FOR t% = 0 TO 50
    x(t%) = 0
    y(t%) = 0
    dir = RND * 6.28: vel = INT(RND * 5) + 1
    xv(t%) = SIN(dir) * vel
    yv(t%) = COS(dir) * vel
  NEXT t%
  '
  ' Initialize offsets and color
  '
  tx% = INT(RND * 320)
  ty% = INT(RND * 200)
  c% = 31: done% = 0
  '
  ' Print the title
  '
  LOCATE 1, 6: PRINT "Explosions by Andrew L. Ayers"
  LOCATE 23, 8: PRINT "Press any key to exit demo"
  '
  ' Explode!
  '
  DO
    '
    ' Move all the pieces
    '
    FOR t% = 0 TO 50
      '
      ' Erase an old piece
      '
      LINE (ox(t%) + tx%, oy(t%) + ty%)-(x(t%) + tx%, y(t%) + ty%), 0
      ox(t%) = x(t%): oy(t%) = y(t%)
      '
      ' Move the piece
      '
      x(t%) = x(t%) + xv(t%)
      y(t%) = y(t%) + yv(t%)
      '
      ' Draw it at new position
      '
      LINE -(x(t%) + tx%, y(t%) + ty%), c%
      '
    NEXT
    '
    ' Decrement color to "fade"
    '
    c% = c% - 1: IF c% < 16 THEN done% = 1 ' Do another explosion if done
    '
    IF INKEY$ <> "" THEN done% = 2 ' Exit on any key press
    '
    FOR dlay = 1 TO 5000: NEXT dlay ' Change to suit your machine
    '
  LOOP UNTIL done%
  '
LOOP UNTIL done% = 2
'
CLS
<PAGEEND:"Explosion.Routines.File1">

<PAGESTART:"Get.Put.File1">
'
' Description : GetShift - Mode 13 VGA Special Effect Routine
' Written by  : Andrew L. Ayers
' Date        : 09/10/96
'
' This shows off one hell of a way to achieve a very smooth and fast "scroll"
' type effect which may be useful in a game or demo. The technique I use to
' do the effect is to shift the data within the GET buffer, re-displaying it
' each time using the PSET operator. By keeping the buffer small, I can do
' the shifting relatively fast, then copy the shifted version over and over
' again on the screen to create a full screen scroll type effect!
'
' As always, if you use this in any of your creations, please consider your
' source and mention my name. Thanx, and have phun!
'
DIM a%(451), save%(24)
'
SCREEN 13
'
' Build our image
'
FOR t% = 15 TO 0 STEP -1
  '
  col% = 31 - (t% * 2)
  CIRCLE (15, 0), t%, col%
  PAINT (15, 0), col%
  '
  CIRCLE (15, 29), t%, col%
  PAINT (15, 29), col%
  '
  CIRCLE (0, 15), t%, col%
  PAINT (0, 15), col%
  '
  CIRCLE (29, 15), t%, col%
  PAINT (29, 15), col%
  '
NEXT
'
' Put it in the buffer
'
GET (0, 0)-(29, 29), a%
'
' The following is info you might find helpful
'
dbyte% = a%(0)
highbyte% = INT(dbyte% MOD 256)
lowbyte% = INT(dbyte% / 256)
wid% = INT(highbyte% / 8) ' Width of GET image in pixels
'
dbyte% = a%(1)
highbyte% = INT(dbyte% MOD 256)
lowbyte% = INT(dbyte% / 256)
hgt% = highbyte% ' Height of GET image in lines
'
' Clear off the screen
'
CLS
'
LOCATE 1, 3: PRINT "Smooth as Silk! - By Andrew L. Ayers"
'
DO
  '
  ' Shift the buffer up
  '
  FOR t% = 0 TO 14: save%(t%) = a%(2 + t%): NEXT ' Top line
  '
  ' Middle lines
  '
  FOR t% = 17 TO 451
    '
    a%(t% - 15) = a%(t%)
    '
  NEXT
  '
  FOR t% = 0 TO 14: a%(437 + t%) = save%(t%): NEXT ' Bottom line
  '
  ' Display it!
  '
  FOR y% = 0 TO 5
    '
    FOR x% = 0 TO 9
      '
      PUT (7 + x% * 30, 10 + y% * 30), a%, PSET
      '
    NEXT
    '
  NEXT
  '
LOOP UNTIL INKEY$ <> ""
<PAGEEND:"Get.Put.File1">

<PAGESTART:"Star.Simulation.File1">
'Check out the difference in speed when you turn DEFINT A-Z off !!!!
DEFINT A-Z                              'Use integers as default for speed.

'The starfield code itself is not mine.
'When I got it however, it needed some speeding up. First of all I added the
'DEFINT A-Z statement. (I use this in all my programs.)
'I also found some unnessesarry statement's and removed those too.
'Then. A friend came with a rather interresting suggestion.
'"Hey, why not add something like a comet?", "Ok, I'll try it."
'I was a little suprised when it actually worked.
'The comet code probably needs some fine-tuning (it's only in there for a day
'or so. But I'm sure somebody can find it usefull.
'Oh, almost forgot. Many thanks to the original author. I hope you recognize
'YOUR piece of the work.
'                                           BEN.

TYPE StarData
 xPos AS INTEGER                        'X position of a star.
 yPos AS INTEGER                        'Y position of a star.
 Speed AS INTEGER                       'Speed of star (Parallax effect).
 Colour AS INTEGER                      'Colour of a star.
END TYPE

TYPE CometData
 xPos AS INTEGER                        'X position of a comet.
 yPos AS INTEGER                        'Y position of a comet.
 xSpeed AS INTEGER                      'Speed of comet in X direction.
 ySpeed AS INTEGER                      'Speed of comet in Y direction.
 Visible AS INTEGER                     'Is comet visible.
 TailSize AS INTEGER                    'Length of tail in pixels.
END TYPE

CONST False = 0: True = NOT False       'Boolean constants.

'--- Program settings. ------------------------------------------------------
Stars = 100                             'Number of stars to plot ?
                                        'Adjust if starfield gets "animated"
                                        '286/20 => 100 and P100 => 600.
UseRetrace = True                       'Use retrace in VGA modes ?
CometSeed = 100                         'Create comet every ... frames.
CometHeadColor = 14                     'Colour of the comet's head.
CometTailColor = 4                      'Colour of the comet's tail.
ScrMode = 12                            'Which screenmode to use ?
'--- End program settings. --------------------------------------------------

Comets = 1                              'Number of comet's (KEEP ON 1 !!!)
OPTION BASE 1                           'Start array's with element 1.
REDIM Comet(Comets) AS CometData        'Create array for comet's
REDIM StarField(Stars) AS StarData      'Create array's for stars.
REDIM OldStarField(Stars) AS StarData

SELECT CASE ScrMode                     'Determine screen boundaries.
 CASE 0
  PRINT "Sorry, graphic modes only! Maybe next time."
  END                                   'See ya later.
 CASE 7                                 'EGA 320x200
  HorLimit = 320
  VerLimit = 200
  UseRetrace = False                    'Disable using retrace as delay.
 CASE 8                                 'EGA 640x200
  HorLimit = 640
  VerLimit = 200
  UseRetrace = False                    'Disable using retrace as delay.
 CASE 9                                 'EGA 640x350
  HorLimit = 640
  VerLimit = 350
  UseRetrace = False                    'Disable using retrace as delay.
 CASE 12                                'VGA 640x480
  HorLimit = 640
  VerLimit = 480
 CASE 13                                'VGA 320x200
  HorLimit = 320
  VerLimit = 200
 CASE ELSE                              'Anything that's NOT tested.
  PRINT "Unsupported videomode."
  END                                   'See ya later.
END SELECT

'Initialize program.
SCREEN ScrMode: RANDOMIZE (TIMER)

'Fill array with random stars...
FOR I = 1 TO Stars                      'Fill 'er up.
 StarField(I).xPos = INT(RND * HorLimit + 1)
 StarField(I).yPos = INT(RND * VerLimit + 1)
 StarField(I).Speed = INT(RND * 8 + 1)
 OldStarField(I).xPos = INT(RND * HorLimit + 1)
 OldStarField(I).yPos = INT(RND * VerLimit + 1)
 OldStarField(I).Speed = INT(RND * 8 + 1)
 SELECT CASE OldStarField(I).Speed
  CASE 0 TO 3: OldStarField(I).Colour = 8
  CASE 4 TO 7: OldStarField(I).Colour = 7
  CASE 8: OldStarField(I).Colour = 15
 END SELECT
 SELECT CASE StarField(I).Speed
  CASE 0 TO 3: StarField(I).Colour = 8
  CASE 4 TO 7: StarField(I).Colour = 7
  CASE 8: StarField(I).Colour = 15
 END SELECT
NEXT I

'Fill array with random comet...
Comet(1).xPos = INT(RND * HorLimit + 1) 'Pick a random X position.
Comet(1).yPos = 1                       'Always start on the top line.
Comet(1).xSpeed = INT(RND * 4 + 2)
Comet(1).ySpeed = INT(RND * 3 + 2)
'50% of the time the direction of the comet will be altered.
IF INT(RND * 2) = 0 THEN Comet(1).xSpeed = -Comet(1).xSpeed
Comet(1).TailSize = INT(RND * 20 + 5)

DO
 IF INT(RND * CometSeed) = 1 AND NOT CometStart THEN CometStart = -1
 FOR I = 1 TO Stars                     'Replot all the stars.
  PSET (StarField(I).xPos, StarField(I).yPos), 0
  StarField(I).xPos = StarField(I).xPos - OldStarField(I).Speed
 
  IF StarField(I).xPos <= 1 THEN        'Recalculate if star hits lower limit.
   StarField(I).xPos = HorLimit
   StarField(I).yPos = INT(RND * VerLimit + 1)    'Give star new y position.
  END IF
 
  'Enable the lines below if you plan on having a left -> right effect.
  'IF OldStarField(i).xPos >= HorLimit THEN 'Recalculate if star hits higher limit.
  ' OldStarField(i).xPos = 1
  ' OldStarField(i).yPos = INT(RND * VerLimit + 1) 'Give star new y position.
  'END IF
 
  'Put the star on screen at it's modified position.
  PSET (StarField(I).xPos, StarField(I).yPos), StarField(I).Colour
 NEXT I

 'Replot comet (This part is needed when the head is NOT off the screen.)
 IF CometStart AND NOT CleanTail THEN
  PSET (Comet(1).xPos, Comet(1).yPos), CometTailColor
  Comet(1).xPos = INT(Comet(1).xPos + Comet(1).xSpeed)
  Comet(1).yPos = INT(Comet(1).yPos + Comet(1).ySpeed)
  IF Comet(1).xPos >= HorLimit OR Comet(1).xPos <= 1 OR Comet(1).yPos >= VerLimit THEN
   CleanTail = True                     'Start removing the tail.
  ELSE
   PSET (Comet(1).xPos, Comet(1).yPos), CometHeadColor
   TailxPos = Comet(1).xPos - INT(Comet(1).TailSize * Comet(1).xSpeed)
   TailyPos = Comet(1).yPos - INT(Comet(1).TailSize * Comet(1).ySpeed)
   IF TailxPos >= 1 AND TailyPos >= 1 THEN PSET (TailxPos, TailyPos), 0
  END IF
 END IF
 'Remove the rest of the tail if the head is moved off the screen.
 IF CleanTail THEN
  TailxPos = INT(Comet(1).xPos - Comet(1).TailSize * Comet(1).xSpeed)
  TailyPos = INT(Comet(1).yPos - Comet(1).TailSize * Comet(1).ySpeed)
  Comet(1).TailSize = Comet(1).TailSize - 1
  IF TailxPos >= 1 AND TailyPos >= 1 THEN PSET (TailxPos, TailyPos), 0
 
  'Create a new comet.
  IF TailxPos >= HorLimit OR TailxPos <= 1 OR TailyPos >= VerLimit THEN
   Comet(1).xPos = INT(RND * HorLimit + 1) 'Pick a random X position.
   Comet(1).yPos = 1                    'Always start on the top line.
   Comet(1).xSpeed = INT(RND * 4 + 2)
   Comet(1).ySpeed = INT(RND * 3 + 2)
   IF INT(RND * 2) = 0 THEN Comet(1).xSpeed = -Comet(1).xSpeed
   Comet(1).TailSize = INT(RND * 20 + 5)
   CometStart = False
   CleanTail = False
  END IF
 END IF

 'Using the Vertical Retrace (VGA+ only) keeps the program from being
 'affected by the number of stars to print. If you use 100 or 500 stars on
 'a P100 doesn't matter. The VR will keep everything going at the same speed.
 '(Within certain boundaries). This method works great when used on anything
 'faster then my old 286 :-). I think it has something to do with the
 'frequency of the monitor. SVGA's have a much smoother parallax effect.

 IF UseRetrace THEN WAIT &H3DA, 8    'Wait for VGA vertical retrace.

 'Put your nice scrolly or something over here.
 'LOCATE 14, 30: PRINT "Starfield Simulation..."
LOOP UNTIL INKEY$ <> ""
<PAGEEND:"Star.Simulation.File1">

<PAGESTART:"Tsr.Program.File">
'Ok, here's the source code to a TSR that will make a small screen saver pop up
'every time you hit the printscreen key. You can make other types of tsr's with 
'this also, all you have to do is hook the right interrupts.
'I don't really want to explain how to use this source, so for the most part, 
'you'll have to figure it out for yourself. One thing you should know though...

'In the program introduction (The part where I wrote A = 1000: B = 1000 etc.) 
'you should put any variables that you plan on using. For example. if you are 
'using A as a variable in your program, and the biggest possible number that 
'will ever be in A is 1000, you'd type A = 1000. Same goes for string 
'variables. If you are going to use A$, and the contents of A$ is never going 
'to exceed 1000 characters, you'd put A$ = SPACE$(1000)
'On line 20000, there is a place on the line where there is a number. You can 
'use the number that is there, or the number that is on the same line commented
'out... Using one number will cause the computer to continue what it was doing

'after doing what the TSR told it to, the other one will do what the tsr told 
'it to do, and abort any other processes. For example, in my screensaver 
'thingy... one number will cause the screen saver to popup when you hit 
'printscreen, and then return to DOS when you hit a key, the other number will 
'cause the screensaver to popup, and return to dos, AND print the screen when 
'you hit a key.
'Also, you will notice in the source that it creates a small .COM file, 
'runs it with a shell command, and then kills it. This is unavoidable...
'Load QUickbasic with the /L switch.
'Do *NOT* run the TSR source from the environment
'Always compile into the Stand-Alone format.
'And last but not least: I wrote the screensaver, but I did not write the TSR 
'source itself.
'Um, I guess that's it. Here it is. Not the best, but the closest I've seen to 
'a QuickBasic TSR...
'--------------------------------------------------------------
'                       TSR_IN_BASIC
'                   QuickBasic version
'              start QB with"/lqb" switch
1    '  start introduction program here
'
A = 1000: B = 1000: C = 1000: D = 1000: I = 1000: COL = 1000: MP = 1000: Z = 1000
6999 '  end introduction program here
'
7000 '  set-up program
'
7010    DIM GMMCKAY%(600)
GMMCKAY%(600) = 0: GMMCKAY%(599) = 0: GMMCKAY% = 0: GMMCKAY$ = "00"

GMMCKAY%(598) = VARPTR(GMMCKAY%(0))
DEF SEG = VARSEG(GMMCKAY%(0))
FOR GMMCKAY% = 0 TO 800
READ GMMCKAY$
POKE GMMCKAY%(598) + GMMCKAY%, VAL("&H" + GMMCKAY$)
NEXT GMMCKAY%
IF GMMCKAY$ <> "00" THEN PRINT "error loading program": STOP

7500    GMMCKAY%(597) = 1'  *** first interrupt ***
7520    GMMCKAY%(598) = 5
7540    GOSUB 9000

7600 '  GMMCKAY%(597)=2  '  *** second interrupt ***
7620 '  GMMCKAY%(598)=5
7640 '  GOSUB 9000

7700 '  GMMCKAY%(597)=3  ' ** third interrupt ***
7720 '  GMMCKAY%(598)=5
7740 '  GOSUB 9000

8140    DEF SEG = VARSEG(GMMCKAY%(0))
GMMCKAY% = VARPTR(GMMCKAY%(0))

8160    CALL absolute(GMMCKAY%) ' call set-up
IF GMMCKAY%(599) = 1 THEN 10000
GMMCKAY%(599) = 1
LOCATE , , 1
Z = FREEFILE: OPEN "CS.COM" FOR OUTPUT AS Z
PRINT #Z, "Ȼ" + CHR$(0) + CHR$(0) + ">" + CHR$(0) + "L!";
CLOSE Z
SHELL "CS.COM"
KILL "CS.COM"
GMMCKAY% = VARPTR(GMMCKAY%(0)) + 763
DEF SEG = VARSEG(GMMCKAY%(0))
8340    CALL absolute(GMMCKAY%) ' terminate as TSR
GOTO 10000
9000    GMMCKAY% = VARPTR(GMMCKAY%(0)) + 643
DEF SEG = VARSEG(GMMCKAY%(0))
9040    CALL absolute(GMMCKAY%(598), GMMCKAY%(597), GMMCKAY%)' call interrupt  .......
9060    RETURN
'
10000 ' start TSR program here

SCREEN 12
RANDOMIZE TIMER
DO
A = INT(RND * 640)
B = INT(RND * 480)
C = INT(RND * 640)
D = INT(RND * 480)
COL = INT(RND * 15)
FOR I = A TO INT(RND * (640 - A))
Z = INT(RND * 3) + 1
MP = INT(RND * 2)
SELECT CASE Z
CASE 1: C = C + 1
CASE 2: D = D + 1
CASE 3: B = B + 1
END SELECT
LINE (A, B)-(C, D), COL
NEXT I
LOOP WHILE INKEY$ = ""
SCREEN 0
CLS

19999 ' end TSR program here
'
20000   GMMCKAY% = 437'**** or have GMMCKAY%=551
20020   GMMCKAY% = GMMCKAY% + VARPTR(GMMCKAY%(0))
DEF SEG = VARSEG(GMMCKAY%(0))
20060   CALL absolute(GMMCKAY%) ' return to original program
GOTO 10000
20100   END

31000  '      GMMCKAY%() data statements
31001  DATA  9C,56,E8,00,00,5E,81,C6,7B,03,2E,8C,5C,08,0E
31002  DATA  1F,89,04,89,5C,02,89,4C,04,89,54,06,8C,54,0A
31003  DATA  8C,44,0C,58,89,44,0E,89,7C,10,89,6C,12,58,89
31004  DATA  44,16,B9,30,00,89,F0,05,60,00,05,18,00,07,89
31005  DATA  C7,29,CF,29,CF,8C,05,E2,F5,89,64,14,B8,00,00
31006  DATA  89,84,30,01,E9,A1,00,90,9C,56,E8,00,00,5E,81
31007  DATA  C6,28,03,2E,89,44,78,58,2E,89,44,7A,58,2E,89
31008  DATA  44,7C,2E,8B,84,30,01,3D,00,00,74,1C,2E,8B,84
31009  DATA  02,01,50,2E,8B,84,00,01,50,2E,8B,44,7C,50,2E
31010  DATA  8B,44,78,2E,8B,74,7A,9D,CB,90,B8,01,00,2E,89
31011  DATA  84,30,01,2E,8C,9C,88,00,0E,1F,90,90,8B,44,78
31012  DATA  89,84,80,00,8B,44,7C,89,84,96,00,8B,44,7A,89
31013  DATA  84,8E,00,89,9C,82,00,89,8C,84,00,89,94,86,00
31014  DATA  8C,94,8A,00,8C,84,8C,00,89,BC,90,00,89,AC,92
31015  DATA  00,B9,30,00,89,F0,05,60,00,05,98,00,07,89,C7
31016  DATA  29,CF,29,CF,8C,05,E2,F5,89,A4,94,00,8E,54,0A
31017  DATA  8B,64,14,B9,30,00,89,F0,05,16,00,89,C7,01,CF
31018  DATA  01,CF,8E,05,06,E2,F5,8B,6C,12,8B,7C,10,8E,44
31019  DATA  0C,8B,54,06,8B,4C,04,8B,5C,02,8B,44,16,50,8B
31020  DATA  44,0E,50,8B,04,8E,5C,08,5E,9D,FB,CB,90,90,9C
31021  DATA  56,E8,00,00,5E,81,C6,50,02,2E,89,44,78,58,2E
31022  DATA  89,44,7A,58,2E,89,44,7C,2E,8B,84,30,01,3D,00
31023  DATA  00,74,1C,2E,8B,84,06,01,50,2E,8B,84,04,01,50
31024  DATA  2E,8B,44,7C,50,2E,8B,44,78,2E,8B,74,7A,9D,CB
31025  DATA  90,B8,02,00,E9,25,FF,90,9C,56,E8,00,00,5E,81
31026  DATA  C6,0B,02,2E,89,44,78,58,2E,89,44,7A,58,2E,89
31027  DATA  44,7C,2E,8B,84,30,01,3D,00,00,74,1C,2E,8B,84
31028  DATA  0A,01,50,2E,8B,84,08,01,50,2E,8B,44,7C,50,2E
31029  DATA  8B,44,78,2E,8B,74,7A,9D,CB,90,B8,03,00,E9,E0
31030  DATA  FE,90,E8,00,00,5E,81,C6,C8,01,0E,1F,8E,94,8A
31031  DATA  00,8B,A4,94,00,B9,30,00,89,F0,05,96,00,89,C7
31032  DATA  01,CF,01,CF,8E,05,06,E2,F5,8B,AC,92,00,8B,BC
31033  DATA  90,00,8E,84,8C,00,8B,94,86,00,8B,8C,84,00,8B
31034  DATA  84,30,01,01,C0,01,C0,01,F0,BB,FE,00,01,C3,8B
31035  DATA  07,50,8B,47,FE,90,90,50,8B,9C,82,00,8B,84,96
31036  DATA  00,50,FA,B8,00,00,89,84,30,01,8B,84,80,00,8E
31037  DATA  9C,88,00,2E,8B,B4,8E,00,9D,CB,90,E8,00,00,5E
31038  DATA  81,C6,56,01,0E,1F,8E,94,8A,00,8B,A4,94,00,B9
31039  DATA  30,00,89,F0,05,96,00,89,C7,01,CF,01,CF,8E,05
31040  DATA  06,E2,F5,8B,AC,92,00,8B,BC,90,00,8E,84,8C,00
31041  DATA  8B,94,86,00,8B,8C,84,00,90,8B,9C,82,00,8B,84
31042  DATA  96,00,50,FA,B8,00,00,89,84,30,01,8B,84,80,00
31043  DATA  8E,9C,88,00,2E,8B,B4,8E,00,9D,FB,CF,90,E8,00
31044  DATA  00,5E,81,C6,FA,00,2E,8C,9C,A0,00,0E,1F,8C,84
31045  DATA  A2,00,89,AC,A4,00,89,BC,A6,00,89,E5,8B,7E,06
31046  DATA  8A,05,B4,35,CD,21,89,F2,8B,7E,04,8B,0D,83,F9
31047  DATA  01,75,0E,89,9C,00,01,8C,84,02,01,81,EA,2D,03
31048  DATA  EB,1F,83,F9,02,75,0E,89,9C,04,01,8C,84,06,01
31049  DATA  81,EA,55,02,EB,0C,89,9C,08,01,8C,84,0A,01,81
31050  DATA  EA,10,02,B4,25,CD,21,8B,AC,A4,00,8B,BC,A6,00
31051  DATA  8E,84,A2,00,8E,9C,A0,00,CA,04,00,90,90,B4,62
31052  DATA  CD,21,B8,00,00,8E,C0,26,A1,FE,03,29,D8,89,C2
31053  DATA  B8,00,31,CD,21,90,90,90,90,00,00,00,00,00,00
31054  DATA  00,00,00,00,00,00
31055  '         end GMMCKAY%() data statments
<PAGEEND:"Tsr.Program.File">

<PAGESTART:"Melt.Screen.File1">
DECLARE SUB SetRGB (Nr%, r%, g%, b%)
DECLARE SUB RenderCircle (x%, y%, r%, colstart%, a!)
' SUMMER.BAS - FREEWARE by Robert Seidel rseidel@ifk.uni-jena.de

'  
'                                                      
'  This file was found at Robert's HomePage !          
'                                                      
'  Come and visit me if you are interested in:         
'                                                      
'   PowerBASIC, QBASIC, POVRAY, POVLAB,                
'     FREE 3D Studio IPAS, PICTURES,                   
'       FREEWARE, GAME Levels                          
'         AND A LOT OF LINKS !                         
'                                                      
'   http://www.uni-jena.de/~p6sepa/rshp.html  ___      
'                                            (o o)     
'                                        oOo ( O ) oOo 
'  


DEFINT A-Z
DIM melt(2400)

SCREEN 13
RANDOMIZE TIMER

FOR i = 0 TO 63 'Palette
  SetRGB i, 64 - i, 64 - i, 64 - i 'grau
  SetRGB i + 64, i, 0, 0 'rot
  SetRGB i + 128, 63, i, 0 'rot-orange
NEXT

FOR i = 1 TO 50 'Schnee
  LINE (0, i + 150)-(320, i + 150), i
NEXT

RenderCircle 160, 158, 50, 1, .8 'Schneemannkrper
RenderCircle 160, 95, 35, 1, .8
RenderCircle 160, 50, 25, 1, .8
RenderCircle 149, 45, 3, 58, 1.2 'Augen
RenderCircle 169, 46, 3, 58, 1.2
FOR i = 85 TO 205 STEP 25 'Knpfe
  RenderCircle 155 + RND * 2, i, 2, 50 + RND * 4, 1
NEXT
CIRCLE (160, 93), 40, 0, 1.2, 1.8 'Mund
CIRCLE (160, 94), 40, 0, 1.2, 1.8
FOR i = 147 TO 177
  LINE (i, 9)-(i - 2, 32), i - 130 'Hut
NEXT
LINE (135, 32)-(184, 34), 30
FOR x = 16 TO 1 STEP -1 'Nase
  RenderCircle 142 + x, 59 - x / 2.5, x \ 4, 128 - x * 2, 1
NEXT

SLEEP 'Pause

'SCHMELZEFFEKT:
FOR i = 1 TO 4000
  x = RND * 271
  y = RND * 150
  GET (x, y)-(x + 48, y + 48), melt
  PUT (x, y + 1), melt, PSET
NEXT i

RenderCircle 160, 100, 60, 128, 1 'Sonne
RenderCircle 140, 80, 7, 55, 1 'Augen
RenderCircle 180, 80, 7, 55, 1
CIRCLE (160, 80), 50, 60, 4, 5.5 'Mund
CIRCLE (160, 88), 50, 60, 3.6, 5.8, 1.3

SLEEP 'Pause

SUB RenderCircle (x, y, r, colstart, a!)
  FOR i = r TO 0 STEP -1
    CIRCLE (x, y), i, (colstart + i), , , a!
    PAINT (x, y), (colstart + i)
  NEXT
END SUB

SUB SetRGB (Nr, r, g, b)
  OUT &H3C8, Nr
  OUT &H3C9, r
  OUT &H3C9, g
  OUT &H3C9, b
END SUB
<PAGEEND:"Melt.Screen.File1">

<PAGESTART:"Plasma.Routines.File1">
'
' Description : Quadratic Plasma
' Written by  : Andrew L. Ayers
' Date        : 10/23/96
'
' This is a program to create quadratic plasma (I am unsure on
' the name here. I know I am not using quadratic equations, but
' hey, call it what you want). The images are formed using only
' math - no recursion, SIN/COS warping, or random numbers. What
' comes out is a very nice display. On machines without a co-
' processor, this may take a little while. Have phun!
'
DECLARE SUB ReadRGB (red%, grn%, blu%, slot%)
DECLARE SUB WriteRGB (red%, grn%, blu%, slot%)
DECLARE SUB SetPal (start.slot%, end.slot%)
'
DIM oldr%(255), oldg%(255), oldb%(255)
'
SCREEN 13
'
' Save old palette
'
FOR t% = 0 TO 255
  CALL ReadRGB(oldr%(t%), oldg%(t%), oldb%(t%), t%)
NEXT t%
'
' Create a custom 63 color palette
'
CALL WriteRGB(63, 63, 63, 1)
CALL WriteRGB(63, 0, 0, 15)
CALL WriteRGB(0, 63, 0, 31)
CALL WriteRGB(0, 0, 63, 47)
CALL WriteRGB(63, 63, 63, 63)
'
CALL SetPal(1, 15)
CALL SetPal(15, 31)
CALL SetPal(31, 47)
CALL SetPal(47, 63)
'
' Display quadratic plasma
'
' Try different numbers (greater than 1) for scale!
'
'scale = 1
'scale = 10
scale = 100
'scale = 250
'
FOR y = -100 * scale TO 100 * scale STEP 1 * scale
  '
  h% = 0
  '
  FOR x = -160 * scale TO 160 * scale STEP 1 * scale
    '
    h% = h% + 1
    '
    ' Try out these equations for different effects!
    '
    c% = (SQR(x * x + y * y) AND 62) + 1
    'c% = ((SQR(x * x) + SQR(y * y)) AND 62) + 1
    'c% = (SQR(ABS(x * y) + ABS(x * y)) AND 62) + 1
    'c% = (SQR(ABS(x * x - y * y)) AND 62) + 1
    PSET (h%, v%), c%
  NEXT
  '
  GOSUB MovePalette ' Remove this line if your machine lacks a coprocessor
  v% = v% + 1
  '
NEXT
'
' Move the palette for a cool effect!
'
DO
  GOSUB MovePalette
  FOR delay = 1 TO 1000: NEXT delay' Adjust for your machine
LOOP UNTIL INKEY$ <> ""
'
CLS
'
' Reset original RGB values
'
FOR t% = 0 TO 255
  CALL WriteRGB(oldr%(t%), oldg%(t%), oldb%(t%), t%)
NEXT t%
'
STOP
'
MovePalette:
  '
  CALL ReadRGB(ored%, ogrn%, oblu%, 1)
  '
  FOR t% = 1 TO 62
    CALL ReadRGB(red%, grn%, blu%, t% + 1)
    CALL WriteRGB(red%, grn%, blu%, t%)
  NEXT
  '
  CALL WriteRGB(ored%, ogrn%, oblu%, 63)
  '
RETURN

SUB ReadRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C7, slot% ' Read RGB values from slot
  '
  red% = INP(&H3C9)
  grn% = INP(&H3C9)
  blu% = INP(&H3C9)
  '
END SUB

SUB SetPal (start.slot%, end.slot%)
  '
  num.slots% = end.slot% - start.slot%
  '
  CALL ReadRGB(sr%, sg%, sb%, start.slot%)
  CALL ReadRGB(er%, eg%, eb%, end.slot%)
  '
  rr% = ABS(er% - sr%): rg% = ABS(eg% - sg%): rb% = ABS(eb% - sb%)
  rs% = SGN(er% - sr%): gs% = SGN(eg% - sg%): bs% = SGN(eb% - sb%)
  '
  stepr = (rr% / num.slots%) * rs%
  stepg = (rg% / num.slots%) * gs%
  stepb = (rb% / num.slots%) * bs%
  '
  r = sr%: g = sg%: b = sb%
  wr% = r: wg% = g: wb% = b
  '
  FOR t% = start.slot% TO end.slot%
    '
    CALL WriteRGB(wr%, wg%, wb%, t%)
    '
    r = r + stepr: wr% = r
    g = g + stepg: wg% = g
    b = b + stepb: wb% = b
    '
  NEXT t%
  '
END SUB

SUB WriteRGB (red%, grn%, blu%, slot%)
  '
  OUT &H3C8, slot% ' Write RGB values to slot
  '
  OUT &H3C9, red%
  OUT &H3C9, grn%
  OUT &H3C9, blu%
  '
END SUB
<PAGEEND:"Plasma.Routines.File1">

<PAGESTART:"Plasma.Routines.File2">
'I synched the program execution to the vertical retrace.
'This keeps the display speed constant on nearly any system.
'_|_|_|   DEMYST.BAS
'_|_|_|   A program that demystifies the mystify screen saver.
'_|_|_|   No warrantee or guarantee is given or implied.
'_|_|_|   Released to   PUBLIC DOMAIN   by Kurt Kuzba.  (6/11/96)
DEFINT A-Z
SCREEN 12: RANDOMIZE (TIMER * 1000)
TYPE IntersectPoints
   x AS INTEGER: y AS INTEGER: dx AS INTEGER: dy AS INTEGER: END TYPE
DIM lnx(60) AS IntersectPoints
lnx(0).x = 0: lnx(0).y = 0: lnx(0).dx = 0: lnx(0).dy = 0
FOR T = 1 TO 59: lnx(T) = lnx(0): NEXT
DO
   WHILE ((INP(&H3DA)) AND 8) <> 0: WEND  'Here's where I keep the speed
   WHILE ((INP(&H3DA)) AND 8) = 0: WEND   'constant for almost all systems
   FOR L = 0 TO 5
      IF lnx(L).x < 1 THEN lnx(L).dx = 2 + ((RND * 999) MOD 4)
      IF lnx(L).y < 1 THEN lnx(L).dy = 2 + ((RND * 999) MOD 4)
      IF lnx(L).x > 638 THEN lnx(L).dx = -(2 + ((RND * 999) MOD 4))
      IF lnx(L).y > 478 THEN lnx(L).dy = -(2 + ((RND * 999) MOD 4))
      lnx(L).x = lnx(L).x + lnx(L).dx: lnx(L).y = lnx(L).y + lnx(L).dy
   NEXT
   FOR L = 0 TO 5
      IF (L MOD 3) <> 0 THEN
         S = L + 54: F = ((L + 1) MOD 6) + 54
         LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 0
      END IF
      S = L + 48: F = ((L + 1) MOD 6) + 48
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 1
      S = L + 42: F = ((L + 1) MOD 6) + 42
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 1
      S = L + 36: F = ((L + 1) MOD 6) + 36
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 1
      S = L + 30: F = ((L + 1) MOD 6) + 30
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 9
      S = L + 24: F = ((L + 1) MOD 6) + 24
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 9
      S = L + 18: F = ((L + 1) MOD 6) + 18
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 11
      S = L + 12: F = ((L + 1) MOD 6) + 12
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 11
      S = L + 6: F = ((L + 1) MOD 6) + 6
      LINE (lnx(S).x, lnx(S).y)-(lnx(F).x, lnx(F).y), 15
      E = (L + 1) MOD 6
      LINE (lnx(L).x, lnx(L).y)-(lnx(E).x, lnx(E).y), 15
   NEXT
   FOR L = 0 TO 5
      lnx(L + 54) = lnx(L + 48): lnx(L + 48) = lnx(L + 42)
      lnx(L + 42) = lnx(L + 36): lnx(L + 36) = lnx(L + 30)
      lnx(L + 30) = lnx(L + 24): lnx(L + 24) = lnx(L + 18)
      lnx(L + 18) = lnx(L + 12): lnx(L + 12) = lnx(L + 6)
      lnx(L + 6) = lnx(L): NEXT
LOOP WHILE INKEY$ = "": SCREEN 0
'_|_|_|   end   DEMYST.BAS
<PAGEEND:"Plasma.Routines.File2">

<PAGESTART:"Plasma.Routines.File3">
'
' Description : Spinner - Mode 13 VGA Special Effect Routine
' Written by  : Andrew L. Ayers
' Date        : 10/15/96
'
' This routine doesn't show anything special, code-wise, but it does
' look interesting all the same...
'
' As always, if you use this in any of your creations, please consider your
' source and mention my name. Thanx, and have phun!
'
SCREEN 13
'
x1% = 160: y1% = 100: colr% = 16
'
DO
  '
  FOR t% = 0 TO 319
    '
    LINE (x1%, y1%)-(t%, 0), colr%
    '
    colr% = colr% + 1: IF colr% > 47 THEN colr% = 17
    '
  NEXT
  '
  FOR t% = 0 TO 199
    '
    LINE (x1%, y1%)-(319, t%), colr%
    '
    colr% = colr% + 1: IF colr% > 47 THEN colr% = 16
    '
  NEXT
  '
  FOR t% = 319 TO 0 STEP -1
    '
    LINE (x1%, y1%)-(t%, 199), colr%
    '
    colr% = colr% + 1: IF colr% > 47 THEN colr% = 16
    '
  NEXT
  '
  FOR t% = 199 TO 0 STEP -1
    '
    LINE (x1%, y1%)-(0, t%), colr%
    '
    colr% = colr% + 1: IF colr% > 47 THEN colr% = 16
    '
  NEXT
  '
LOOP UNTIL INKEY$ <> ""
'
CLS
<PAGEEND:"Plasma.Routines.File3">

<PAGESTART:"Plasma.Routines.File4">
'Vortex 2
'By Ryan White
'See kiddies, sugar does do the world some good!!!  Or at least it did me.
'I think if you put a spiraler routine into the start and end of the circle,
'you could get a really awsome effect.  Enjoy!  8')

SCREEN 13
DEFINT A-W
CLS
DIM c(255, 2), co(255, 2)
FOR n = 0 TO 15
c(n, 0) = n * 4: c(n, 1) = n * 4: c(n, 2) = n * 4: c(n + 16, 0) = 63: c(n + 16, 1) = 63 - n * 4: c(n + 16, 2) = 63 - n * 4: c(n + 32, 0) = 63: c(n + 32, 1) = n * 2: c(n + 32, 2) = 0
c(n + 48, 0) = 63: c(n + 48, 1) = n * 2 + 31: c(n + 48, 2) = 0: c(n + 64, 0) = 63 - n * 4: c(n + 64, 1) = 63: c(n + 64, 2) = 0: c(n + 80, 0) = 0: c(n + 80, 1) = 63 - n * 2: c(n + 80, 2) = n * 4
c(n + 96, 0) = 0: c(n + 96, 1) = 32 - n * 2: c(n + 96, 2) = 60: c(n + 112, 0) = n * 3: c(n + 112, 1) = 0: c(n + 112, 2) = 60: c(n + 128, 0) = 45 - n * 3: c(n + 128, 1) = 0: c(n + 128, 2) = 60
c(n + 144, 0) = 0: c(n + 144, 1) = n * 2: c(n + 144, 2) = 60: c(n + 160, 0) = 0: c(n + 160, 1) = 30 + n * 2: c(n + 160, 2) = 60 - n * 4: c(n + 176, 0) = n * 4: c(n + 176, 1) = 63: c(n + 176, 2) = 0
c(n + 192, 0) = 63: c(n + 192, 1) = 60 - n * 2: c(n + 192, 2) = 0: c(n + 208, 0) = 63: c(n + 208, 1) = 30 - n * 2: c(n + 208, 2) = 0: c(n + 224, 0) = 60 - n * 2: c(n + 224, 1) = n * 2: c(n + 224, 2) = n * 2
c(n + 240, 0) = 30 - n * 2: c(n + 240, 1) = 30 - n * 2: c(n + 240, 2) = 30 - n * 2: NEXT n: FOR n = 1 TO 255: OUT &H3C8, n: FOR m = 0 TO 2: OUT &H3C9, c(n, m): NEXT m: NEXT n

n = 0: x = 5
FOR I = 200 TO 40 STEP -1: n = n + 1: IF n = 256 THEN n = 1
x = x / 1.003: FOR j = 1 TO 10: CIRCLE (160, I), x, n, , , .5: x = x * 1.003: NEXT j
NEXT I

n = 255: x = 5
FOR I = -10 TO 160: n = n - 1: IF n = 0 THEN n = 255
x = x / 1.003: FOR j = 1 TO 10:
CIRCLE (160, I), x, n, 0, 1, .5: CIRCLE (160, I), x, n, 2, 3, .5:
CIRCLE (160, I), x, n, 4, 5.5, .5: x = x * 1.003: NEXT j
NEXT I

DO UNTIL INKEY$ <> ""
FOR n = 1 TO 255: OUT &H3C7, n: FOR m = 0 TO 2: co(n, m) = INP(&H3C9): NEXT m: NEXT n
c(255, 0) = co(1, 0): c(255, 1) = co(1, 1): c(255, 2) = co(1, 2)
FOR n = 1 TO 254: FOR m = 0 TO 2: c(n, m) = co(n + 1, m): NEXT m: NEXT n
FOR n = 1 TO 255: OUT &H3C8, n: FOR m = 0 TO 2: OUT &H3C9, c(n, m): NEXT m: NEXT n
LOOP
<PAGEEND:"Plasma.Routines.File4">

<PAGESTART:"MB.Music.File">
ON PLAY(2) GOSUB MORE
SCREEN 1

PLAY ON

PLAY "T160 MB ML L8 O4 E E- E E- E <B >D C <A"
PLAY "O2 E A >C E A B"
PLAY "O2 E G# >E G# B >C"

PLAY "O2 E A >E"
STANZA% = 1

DO
X1 = RND * 320
X2 = RND * 320
Y1 = RND * 200
Y2 = RND * 200
COL = INT(RND * 4)
LINE (X1, Y1)-(X2, Y2), COL, B
LOOP WHILE INKEY$ = ""

PLAY OFF
DO
LOOP WHILE PLAY(0) > 0
CLS
END

MORE:
IF STANZA% = 1 THEN
STANZA% = 2
PLAY "MB ML L8 O4 E E- E E- E <B >D C A<"
PLAY "O2 E A >C E A B"
PLAY "O2 E G# >E >C <B A2. L8 N0"
ELSE
SATNZA% = 1
PLAY "MB ML L8 O4 E E- E E- E <B >D C <A"
PLAY "O2 E A >C E A B"
PLAY "O2 E G# >E G# B >C"
PLAY "O2 E A >E"
END IF
RETURN
<PAGEEND:"MB.Music.File">

<PAGESTART:"VGA.Pan.File1">
' Greetings, fellow BASIC programmers.
' I just finished working out how to do pixel-by-pixel scrolling
' on a VGA card and I thought that this might interest some of
' you, so here's a quick demo. What this code does is this: it
' creates a virtual screen much larger than the usual SCREEN 12
' 640x480, then prints graphics to this larger virtual screen.
' When you press a key, the graphics stop being printed and you
' can use the arrow keys to pan around and observe different
' parts of the virtual screen.

' When the VGA card sets up a screen mode, the Offset Register
' &H3D5, index &H13 contains the amount of display memory to be
' used per horizontal scan line. The virtual screen is made wider
' than the ordinary screen by increasing this value. The Start
' Address High and Start Address Low registers, &H3D5 index &HC
' & &HD contain the MSB and LSB respectively of the address in
' video memory where the displayed screen begins. Increasing or
' decreasing this value by 1 pans the screen left or right by
' 8 pixels. Changing this value by the amount of memory per scan
' line pans the screen up or down. Notice that horizontal panning
' by this method alone moves the screen 8 pixels at a time. To
' pan horizontally a pixel at a time involves the Horizontal
' PEL Panning register &H3C0 index &H13. Rotating the values of
' this register from 0 through 7 pans the screen pixel-column 
' by pixel-column. Note that this register must only be changed
' during a vertical retrace and that an INP(&H3DA) command must
' preceed a change to this register. Also, bit 5 must always be
' set.

' It is worth noting also that the normal BASIC graphics commands
' will not work on the larger virtual screen, so I have provided
' my own code to create the graphics in this demo. While the code
' for these graphics commands is good, it is just BASIC and is 
' not necessarily optimised, so I realized that it is slow. That
' particular aspect is not the focus of this demo.

 DECLARE SUB QPrint (X%, Y%, Text$, Culler%)
 DECLARE SUB DrawCircle (X%, Y%, Radius%, Culler%)
 DECLARE SUB PutPixel (X%, Y%, Culler%)
 DECLARE SUB DrawLine (X1%, Y1%, X2%, Y2%, Culler%)
 DEFINT A-Z
 REDIM BitMask%(0 TO 7)
 Mask% = 128
 FOR Bit% = 0 TO 7
   BitMask%(Bit%) = Mask%: Mask% = Mask% \ 2
 NEXT

 RANDOMIZE TIMER
 SCREEN 12: ScrnWid% = 640: ScrnHgt% = 480

 'the width of the virtual screen in pixels:
 VScrnWid% = 832
 'In SCREEN 12, the following must be true:
 '  VScrnWid% must be equal to or greater than 640
 '  VScrnWid% must be less than or equal to 1088
 '  VScrnWid% must be evenly divisible by 16
 HPanLimit% = VScrnWid% - ScrnWid%
 BytesPerLine% = VScrnWid% \ 8

 'the height of the virtual screen in pixels:
 VScrnHgt% = 624
 'In SCREEN 12, the following must be true:
 '  VScrnHgt% must be equal to or greater than 480
 '  VScrnHgt% must be less than or equal to 819
 '  The product of VScrnHgt% multiplied by VScrnWid% must be less
 '      than or equal to 524288
 VPanLimit% = VScrnHgt% - ScrnHgt%

 'create the virtual screen:
 OUT &H3D4, &H13: OUT &H3D5, VScrnWid% \ 16

 'put up some graphics
 MinX% = 0: MaxX% = VScrnWid% - 1
 MinY% = 0: MaxY% = VScrnHgt% - 1
 CALL DrawLine(MinX%, MinY%, MaxX%, MinY%, 1)
 CALL DrawLine(MaxX%, MinY%, MaxX%, MaxY%, 2)
 CALL DrawLine(MaxX%, MaxY%, MinX%, MaxY%, 3)
 CALL DrawLine(MinX%, MaxY%, MinX%, MinY%, 4)

 RR% = VScrnHgt%: IF VScrnWid% < VScrnHgt% THEN RR% = VScrnWid%
 DO UNTIL LEN(INKEY$)
   X1% = INT(RND * VScrnWid%)
   Y1% = INT(RND * VScrnHgt%)
   X2% = INT(RND * VScrnWid%)
   Y2% = INT(RND * VScrnHgt%)
   C% = INT(RND * 14) + 1
   CALL DrawLine(X1%, Y1%, X2%, Y2%, C%)
   R% = INT(RND * (RR% \ 4))
   X1% = INT(RND * (VScrnWid% - R% * 2)) + R%
   Y1% = INT(RND * (VScrnHgt% - R% * 2)) + R%
   C% = INT(RND * 14) + 1
   CALL DrawCircle(X1%, Y1%, R%, C%)
 LOOP
 CALL QPrint(8, 8, "Upper Left", 15)
 CALL QPrint(VScrnWid% - 96, 8, "Upper Right", 15)
 CALL QPrint(8, VScrnHgt% - 16, "Lower Left", 15)
 CALL QPrint(VScrnWid% - 96, VScrnHgt% - 16, "Lower Right", 15)

 'allow the user to pan around the virtual screen
 X% = 0: Y% = 0
 DO
  DO WHILE LEN(INKEY$): LOOP
  DO: KP$ = INKEY$: LOOP UNTIL LEN(KP$)
  KP% = ASC(KP$): IF KP% = 0 THEN KP% = -ASC(MID$(KP$, 2))
  SELECT CASE KP%
    CASE 27
      EXIT DO
    CASE 52, -75  'Four, LArrow
      IF X% > 0 THEN
        X% = X% - 1
        DO: LOOP WHILE (INP(&H3DA) AND 8) = 0
        OUT &H3C0, &H33: OUT &H3C0, X% MOD 8
      ELSE
        BEEP
      END IF
    CASE 54, -77   'Six, RArrow
      IF X% < HPanLimit% THEN
        X% = X% + 1
        DO: LOOP WHILE (INP(&H3DA) AND 8) = 0
        OUT &H3C0, &H33: OUT &H3C0, X% MOD 8
      ELSE
        BEEP
      END IF
    CASE 56, -72  'Eight, UpArrow
      IF Y% > 0 THEN
        Y% = Y% - 1
      ELSE
        BEEP
      END IF
    CASE 50, -80  'Two, DnArrow
      IF Y% < VPanLimit% THEN
        Y% = Y% + 1
      ELSE
        BEEP
      END IF
  END SELECT
  Ptr% = (Y% * BytesPerLine%) + (X% \ 8)
  OUT &H3D4, &HD: OUT &H3D5, Ptr% MOD 256
  OUT &H3D4, &HC: OUT &H3D5, Ptr% \ 256
 LOOP
 SCREEN 0: WIDTH 80
 END

 SUB DrawCircle (X%, Y%, Radius%, Culler%)
 'a routine to draw circles using only integers and integer math
 'an implementation of Bresenham's algorithm
 'by Douglas H. Lusher, 05-09-1996
 A% = 0
 B% = Radius%
 D% = (1 - Radius%) * 2
 XX1% = X%: YY1% = Y% + B%
 XX2% = X%: YY2% = Y% - B%
 XY1% = X% + B%: YX1% = Y%
 XY2% = X% - B%: YX2% = Y%
 DO WHILE B% >= A%
   CALL PutPixel(XX1%, YY1%, Culler%)
   CALL PutPixel(XX1%, YY2%, Culler%)
   CALL PutPixel(XX2%, YY1%, Culler%)
   CALL PutPixel(XX2%, YY2%, Culler%)
   CALL PutPixel(XY1%, YX1%, Culler%)
   CALL PutPixel(XY1%, YX2%, Culler%)
   CALL PutPixel(XY2%, YX1%, Culler%)
   CALL PutPixel(XY2%, YX2%, Culler%)
   IF D% + B% > 0 THEN
     B% = B% - 1
     D% = D% - (B% * 2) + 1
     YY1% = YY1% - 1: YY2% = YY2% + 1
     XY1% = XY1% - 1: XY2% = XY2% + 1
   END IF
   IF A% > D% THEN
     A% = A% + 1
     D% = D% + (A% * 2) + 1
     XX1% = XX1% + 1: XX2% = XX2% - 1
     YX1% = YX1% + 1: YX2% = YX2% - 1
   END IF
 LOOP
 END SUB
 
 SUB DrawLine (X1%, Y1%, X2%, Y2%, Culler%)
 'a routine to draw lines using only integers and integer math
 'an implementation of Bresenham's algorithm
 'by Douglas H. Lusher, 05-08-1996
 A% = X2% - X1%
 B% = Y2% - Y1%
 DX2% = 1: DY2% = 1
 IF A% < 0 THEN A% = -A%: DX2% = -1
 IF B% < 0 THEN B% = -B%: DY2% = -1
 DX1% = DX2%: DY1% = 0
 IF A% < B% THEN SWAP A%, B%: DX1% = 0: DY1% = DY2%
 I1% = B% * 2
 D% = I1% - A%
 I2% = D% - A%
 X% = X1%: Y% = Y1%
 FOR I% = 0 TO A%
  CALL PutPixel(X%, Y%, Culler%)
  IF D% < 0 THEN
    X% = X% + DX1%
    Y% = Y% + DY1%
    D% = D% + I1%
  ELSE
    X% = X% + DX2%
    Y% = Y% + DY2%
    D% = D% + I2%
  END IF
 NEXT
 END SUB

 SUB PutPixel (X%, Y%, Culler%)
 SHARED BitMask%(), BytesPerLine%
 DEF SEG = &HA000
 Offset& = (CLNG(Y%) * BytesPerLine%) + (X% \ 8)
 OUT &H3CE, 5: OUT &H3CF, 2
 OUT &H3CE, 8: OUT &H3CF, BitMask%(X% AND 7)
 Byte% = PEEK(Offset&): POKE Offset&, Culler%
 END SUB

 SUB QPrint (X%, Y%, Text$, Culler%)
 'this routine uses the VGA hardware to print text
 '  in 16 color graphics modes
 'by Douglas H. Lusher, 06-08-1996
 SHARED BytesPerLine%

 ' 8 x 8 char box, CGA
 CharSegment% = &HFFA6: CharOffset% = &HE: CharHgt% = 8

 ' 8 x 16 char box, VGA
 'DIM Regs AS RegTypeX
 'Regs.AX = &H1130
 'Regs.BX = &H600
 'CALL InterruptX(&H10, Regs, Regs)
 'CharSegment% = Regs.ES: CharOffset% = Regs.BP: CharHgt% = 16

 REDIM BitPattern%(1 TO CharHgt%)
 Temp& = (CLNG(Y%) * BytesPerLine%) + (X% \ 8)
 VideoSegment% = &HA000 + (Temp& \ 16)
 VideoOffset% = (Temp& MOD 16) - 1
 OUT &H3CE, 5: OUT &H3CF, 2: OUT &H3CE, 8
 FOR Char% = 1 TO LEN(Text$)
   Ptr% = CharHgt% * ASC(MID$(Text$, Char%, 1)) + CharOffset% - 1
   DEF SEG = CharSegment%
   FOR Ln% = 1 TO CharHgt%
     BitPattern%(Ln%) = PEEK(Ptr% + Ln%)
   NEXT
   VideoPtr% = VideoOffset% + Char%
   DEF SEG = VideoSegment%
   FOR Ln% = 1 TO CharHgt%
     OUT &H3CF, BitPattern%(Ln%)
     Byte% = PEEK(VideoPtr%): POKE VideoPtr%, Culler%
     VideoPtr% = VideoPtr% + BytesPerLine%
   NEXT
 NEXT
 END SUB
<PAGEEND:"VGA.Pan.File1">

<PAGESTART:"VGA.Pages.File1">
'Greetings, everyone. Here is code to put a VGA card into 320x240 mode
'with 256 colors and 3 pages. This should be a good layout for high
'quality graphics and animation. It has a 4:3 aspect ratio, so the pixels
'are square, and it has 20% more pixels than SCREEN 13 and multiple
'pages. All with 256 colors. Please try it out and send me your
'comments and bug reports. Thanks.

 DECLARE SUB XCLS (Page%)
 DECLARE SUB ShowPage (Page%)
 DECLARE SUB Set320x240mode ()
 DECLARE SUB XPRINT (X%, Y%, Text$, Culler%, Page%)
 DECLARE SUB PutPixel (X%, Y%, Culler%, Page%)
 DEFINT A-Z
 '$INCLUDE: 'QB.BI'

 DIM BitMask%(7)
 FOR Bit% = 0 TO 7: BitMask%(Bit%) = 2 ^ Bit%: NEXT
 Test$ = "The quick brown fox jumps over lazy dogs"
 CALL XPRINT(0, 0, "", 0, 0)   'initialize the print routine

 CALL Set320x240mode: SLEEP 1
 HMax% = 320: VMax% = 240: Pg% = 0
 FOR X% = 0 TO HMax% - 1
   CALL PutPixel(X%, 0, 2, Pg%)
   CALL PutPixel(X%, VMax% - 1, 2, Pg%)
 NEXT
 FOR Y% = 0 TO VMax% - 1
   CALL PutPixel(0, Y%, 2, P%)
   CALL PutPixel(HMax% - 1, Y%, 2, Pg%)
 NEXT
 CALL XPRINT(0, 0, "This is 320x240x256 mode, 3 pages", 15, P%)
 FOR Y% = 1 TO 14
   CALL XPRINT(0, Y% * 16, Test$, Y%, Pg%)
 NEXT
 BEEP: A$ = INPUT$(1)
 CALL XCLS(0)
 CALL XPRINT(0, 0, "This is page 0", 1, 0)
 CALL XPRINT(0, 64, "Press 0, 1, or 2 to see the pages", 1, 0)
 CALL XPRINT(0, 80, "Press ESC to exit", 1, 0)
 CALL XPRINT(0, 16, "This is page 1", 2, 1)
 CALL XPRINT(0, 64, "Press 0, 1, or 2 to see the pages", 2, 1)
 CALL XPRINT(0, 80, "Press ESC to exit", 2, 1)
 CALL XPRINT(0, 32, "This is page 2", 4, 2)
 CALL XPRINT(0, 64, "Press 0, 1, or 2 to see the pages", 4, 2)
 CALL XPRINT(0, 80, "Press ESC to exit", 4, 2)
 DO
 A$ = INPUT$(1)
 SELECT CASE A$
   CASE "0": CALL ShowPage(0)
   CASE "1": CALL ShowPage(1)
   CASE "2": CALL ShowPage(2)
   CASE CHR$(27): EXIT DO
   CASE ELSE: BEEP
 END SELECT
 LOOP
 SCREEN 13: SCREEN 0: WIDTH 80
 END

 SUB GetPixel (X%, Y%, Culler%, Page%)
 SELECT CASE Page%
   CASE 0: VidSegment% = &HA000
   CASE 1: VidSegment% = &HA4F0
   CASE 2: VidSegment% = &HA9E0
   CASE ELSE: ERROR 5
 END SELECT
 OUT &H3CE, 4: OUT &H3CF, X% AND 3
 DEF SEG = VidSegment%
 Culler% = PEEK((Y% * 80) + (X% \ 4))
 END SUB

 SUB PutPixel (X%, Y%, Culler%, Page%)
 SHARED BitMask%()
 SELECT CASE Page%
   CASE 0: VidSegment% = &HA000
   CASE 1: VidSegment% = &HA4F0
   CASE 2: VidSegment% = &HA9E0
   CASE ELSE: ERROR 5
 END SELECT
 OUT &H3C4, 2: OUT &H3C5, BitMask%(X% AND 3)
 DEF SEG = VidSegment%
 POKE (Y% * 80) + (X% \ 4), Culler%
 END SUB

 SUB Set320x240mode
 'begin with standard 320x200x256 mode
 SCREEN 13
 'disable "chain4" mode
 OUT &H3C4, &H4: OUT &H3C5, &H6
 'enable writes to all four planes
 OUT &H3C4, &H2: OUT &H3C5, &HF
 'clear video memory
 CLS
 'synchronous reset while switching clocks
 OUT &H3C4, 0: OUT &H3C5, &H1
 'select 25 Mhz dot clock and 60 hz scanning rate
 OUT &H3C2, &HE3
 'restart the sequencer
 OUT &H3C4, 0: OUT &H3C5, &H3
 'to reprogram the CRT controller,
 'remove write protect from the registers
 OUT &H3D4, &H11: OUT &H3D5, INP(&H3D5) AND &H7F
 OUT &H3D4, &H6: OUT &H3D5, &HD     'total vertical pixels
 OUT &H3D4, &H7: OUT &H3D5, &H3E    'overflow
 OUT &H3D4, &H9: OUT &H3D5, &H41    'turn off double double-scan
 OUT &H3D4, &H10: OUT &H3D5, &HEA   'vertical sync start
 OUT &H3D4, &H11: OUT &H3D5, &HAC   'vertical sync end, reprotect registers
 OUT &H3D4, &H12: OUT &H3D5, &HDF   'vertical pixels displayed
 OUT &H3D4, &H14: OUT &H3D5, 0      'turn off dword mode
 OUT &H3D4, &H15: OUT &H3D5, &HE7   'vertical blank start
 OUT &H3D4, &H16: OUT &H3D5, &H6    'vertical blank end
 OUT &H3D4, &H17: OUT &H3D5, &HE3   'turn on byte mode
 END SUB

 SUB ShowPage (Page%)
 SELECT CASE Page%
   CASE 0: OUT &H3D4, &HC: OUT &H3D5, 0
   CASE 1: OUT &H3D4, &HC: OUT &H3D5, &H4F
   CASE 2: OUT &H3D4, &HC: OUT &H3D5, &H9E
   CASE ELSE: ERROR 5          'illegal function call
 END SELECT
 END SUB

 SUB XCLS (Page%)
 SELECT CASE Page%
   CASE 0: VidSegment% = &HA000
   CASE 1: VidSegment% = &HA4F0
   CASE 2: VidSegment% = &HA9E0
   CASE ELSE: ERROR 5
 END SELECT
 OUT &H3C4, &H2: OUT &H3C5, &HF
 DEF SEG = VidSegment%
 FOR Address% = 0 TO 19199: POKE Address%, 0: NEXT
 END SUB

 SUB XPRINT (X%, Y%, Text$, Culler%, Page%)
 STATIC HiNibble%(), LoNibble%()
 IF LEN(Text$) GOTO StartXPRINT
 REDIM HiNibble%(255, 15), LoNibble%(255, 15)
 REDIM BitMask%(15)
 BitMask%(0) = 0:  BitMask%(1) = 8:   BitMask%(2) = 4
 BitMask%(3) = 12: BitMask%(4) = 2:   BitMask%(5) = 10
 BitMask%(6) = 6:  BitMask%(7) = 14:  BitMask%(8) = 1
 BitMask%(9) = 9:  BitMask%(10) = 5:  BitMask%(11) = 13
 BitMask%(12) = 3: BitMask%(13) = 11: BitMask%(14) = 7
 BitMask%(15) = 15
 DIM Regs AS RegTypeX
 Regs.AX = &H1130
 Regs.BX = &H600
 CALL InterruptX(&H10, Regs, Regs)
 CharSegment% = Regs.ES: CharOffset% = Regs.BP
 DEF SEG = CharSegment%
 FOR Char% = 0 TO 255
   FOR Ln% = 0 TO 15
     BitPattern% = PEEK(CharOffset%)
     HiNibble%(Char%, Ln%) = BitMask%(BitPattern% \ 16)
     LoNibble%(Char%, Ln%) = BitMask%(BitPattern% AND 15)
     CharOffset% = CharOffset% + 1
   NEXT
 NEXT
 ERASE BitMask%

StartXPRINT:
 SELECT CASE Page%
   CASE 0: VidSegment% = &HA000
   CASE 1: VidSegment% = &HA4F0
   CASE 2: VidSegment% = &HA9E0
   CASE ELSE: ERROR 5
 END SELECT
 OUT &H3C4, 2
 DEF SEG = VidSegment%
 VidPtr% = (Y% * 80) + (X% \ 4)
 FOR Ptr% = 1 TO LEN(Text$)
   Char% = ASC(MID$(Text$, Ptr%, 1))
   VidOffset% = VidPtr%
   FOR Ln% = 0 TO 15
     OUT &H3C5, HiNibble%(Char%, Ln%)
     POKE VidOffset%, Culler%
     OUT &H3C5, LoNibble%(Char%, Ln%)
     POKE VidOffset% + 1, Culler%
     VidOffset% = VidOffset% + 80
   NEXT
   VidPtr% = VidPtr% + 2
 NEXT
 END SUB
<PAGEEND:"VGA.Pages.File1">

<PAGESTART:"256.Colors.File1">
'NOTE: VGA required to run this program.

'This program demonstrates how to calculate and display the 256k colors
'available in SCREEN 12.  The formula used below looks kind of cryptic
'at first, but it will begin to make sense after you think about
'how colors work.

'There are 3 basic colors: red, green, and blue.
'In SCREEN 12, each of these colors has an intensity range of 0 to 63
'That gives a total of 64 shades for each one.
'Therefore, 64 * 64 * 64 = 262144 (256k) possible colors.
'Sounds good, well the down side is that BASIC can only display
'16 of them at one time, oh-well.
'Red's palette begins at 0
'Green's palette begins at 256
'Blue's palette begins at 65536
'Therefore, the palette formula is:
'       PalColor& = (65536 * blue%) + (256 * green%) + red%

'Enough of that, run this and see what you think.

'--------------------------------------------------------------------------
ON ERROR GOTO ETrap     'set an error trap
SCREEN 12       'set the screen mode
PALETTE 1, 0    'assign black to color attribute #1 to use as the default

w% = 100: x% = 50         'set the viewport boundry coordinate var's
y% = 540: z% = 300
VIEW SCREEN (w%, x%)-(y%, z%), 0, 15    'define a viewport w/ border
LINE (w%, x%)-(y%, z%), 1, BF           'draw a box, fill w/ color 1

COLOR 15        'put options on the screen
LOCATE 3, 14: PRINT "PALETTE VALUE:"
LOCATE 21, 14: PRINT "R = More red                         Red intensity:"
LOCATE 22, 14: PRINT "r = Less red"
LOCATE 24, 14: PRINT "G = More green                     Green intensity:"
LOCATE 25, 14: PRINT "g = Less green"
LOCATE 27, 14: PRINT "B = More blue                       Blue intensity:"
LOCATE 28, 14: PRINT "b = Less blue"
LOCATE 30, 35: PRINT "Esc = Quit";

DO  'loop here and update the palette and data w/ each key hit

    a& = (65536 * blue%) + (256 * green%) + red%   'calc the new palette

    PALETTE 1, a&   'display the new palette

    LOCATE 3, 28: PRINT a&; "     "   'update the screen data
    LOCATE 21, 65: PRINT red%
    LOCATE 24, 65: PRINT green%
    LOCATE 27, 65: PRINT blue%

    DO: k$ = INKEY$      'wait for a user key
    LOOP WHILE k$ = ""

    SELECT CASE k$       'process the key
        CASE "R"
            IF red% < 63 THEN        'increment red intensity
                red% = red% + 1
            ELSE
                SOUND 200, .1
            END IF

        CASE "r"
            IF red% > 0 THEN         'decrement red intensity
                red% = red% - 1
            ELSE
                SOUND 200, .1
            END IF

        CASE "G"
            IF green% < 63 THEN      'increment green intensity
                green% = green% + 1
            ELSE
                SOUND 200, .1
            END IF

        CASE "g"
            IF green% > 0 THEN       'decrement green intensity
                green% = green% - 1
            ELSE
                SOUND 200, .1
            END IF

        CASE "B"
            IF blue% < 63 THEN       'increment blue intensity
                blue% = blue% + 1
            ELSE
                SOUND 200, .1
            END IF

        CASE "b"
            IF blue% > 0 THEN        'decrement blue intensity
                blue% = blue% - 1
            ELSE
                SOUND 200, .1
            END IF
       
        CASE CHR$(27)

        CASE ELSE
            SOUND 200, .1

    END SELECT
LOOP UNTIL k$ = CHR$(27)    'exit if escape is hit

VIEW        'close the viewport
CLS
PALETTE     'reset the palette to default
SCREEN 0

'print the final palette data
PRINT "FINAL PALETTE VALUE   :"; a&
PRINT "RED INTENSITY         :"; red%
PRINT "GREEN INTENSITY       :"; green%
PRINT "BLUE INTENSITY        :"; blue%

Done:
END

ETrap:
    CLS     'display the error code and exit program
    PRINT "BASIC RUNTIME ERROR #"; ERR
RESUME Done
<PAGEEND:"256.Colors.File1">

<PAGESTART:"What.Card.File1">
DECLARE FUNCTION GetVideoCard$ ()

TYPE RegType
        ax      AS INTEGER
        bx      AS INTEGER
        cx      AS INTEGER
        dx      AS INTEGER
        bp      AS INTEGER
        si      AS INTEGER
        di      AS INTEGER
        flags   AS INTEGER
END TYPE

DECLARE SUB INTERRUPT (IntNo AS INTEGER, InRegs AS RegType, OutRegs AS RegType)

        CLS
        PRINT "Your video card is a "; GetVideoCard$

END

FUNCTION GetVideoCard$

REM This function returns a 3-letter string: "MDA" (monochrome adapter card)
REM "CGA" (color graphics adapter), "EGA" (enhanced graphics adapter),
REM "PGA" (professional graphics adapter), "VGA" (variable graphics array)

   DIM InRegs AS RegType, OutRegs AS RegType
   InRegs.ax = &H1A00
   CALL INTERRUPT(&H10, InRegs, OutRegs)
   IF (OutRegs.ax AND &HFF) = &H1A THEN
       Code = OutRegs.bx AND &HFF
       SELECT CASE Code
           CASE 1
                GetVideoCard$ = "MDA"
           CASE 2
                GetVideoCard$ = "CGA"
           CASE 4 TO 5
                GetVideoCard$ = "EGA"
           CASE 6
                GetVideoCard$ = "PGA"
           CASE 7 TO 8
                GetVideoCard$ = "VGA"
       END SELECT
       EXIT FUNCTION
   ELSE
       InRegs.ax = &H1200
       InRegs.bx = &H10
       CALL INTERRUPT(&H10, InRegs, OutRegs)
       IF (OutRegs.bx AND &HFF) <> &H10 THEN
           GetVideoCard$ = "EGA"
           EXIT FUNCTION
       ELSE
           InRegs.ax = &HF00
           CALL INTERRUPT(&H10, InRegs, OutRegs)
           IF (OutRegs.ax AND &HFF) = 7 THEN
               GetVideoCard$ = "MDA"
               EXIT FUNCTION
           ELSE
               GetVideoCard$ = "CGA"
               EXIT FUNCTION
           END IF
       END IF
   END IF

END FUNCTION
<PAGEEND:"What.Card.File1">

<PAGESTART:"Post.It.File1">
DEFINT A-Z
'--- PostIt! subroutines.
DECLARE SUB ParseCmdLine (cmd$, Params$(), Found%)
DECLARE SUB SepPath (a$, Drive$, path$, tName$)
DECLARE FUNCTION Decode% (oSwitch%, InSpec$, OutSpec$)
DECLARE FUNCTION Encode% (Op%, iSwitch%, cSwitch%, aSwitch%, tSwitch%, sSwitch%, pSwitch%, lSwitch%, oSwitch%, bSwitch%, InSpec$, OutSpec$)
DECLARE SUB ExpandLine (a$, Lines$(), LineLength%, NumLines%)
DECLARE FUNCTION FASC% (a$)
DECLARE FUNCTION GrabNum& (a$, Lower&, Upper&, Default&)
DECLARE FUNCTION UnTab$ (b$, TabStops%)
'--- ImportIt! subroutines.
DECLARE SUB ImportIt (BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference%)
DECLARE SUB CreateRep (BBSID$, ArcCommand$)
DECLARE SUB AddToRep (BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference%, ErrorCode$)
DECLARE SUB IIParse (cmd$, toname$, fromname$, conference%, BBSID$)
'
' --- beta test release --- released by Calvin French, August 1993 ---
'
' This SHOULD work perfectly. Please test it, tangle it, and report any
' bugs you find in it to Victor, Me, or (lastly only because he is very
' very busy), Rich.
'
' - Calvin -
'
' --------------------------------------------------------------------
'
' PostIt! v7.2 Script Encoder/Decoder-Public Domain-August 1993
' By Rich Geldreich & Victor Yiu. Many  contributions,   fixups,  and
' features by Mark H. Butler,  Quinn Tyler Jackson, and Scott Wunsch.
' QWK compatable .REP file support by Calvin French.
' Decoding instructions in header by Steve Harmon.
'
' PostIt! can  encode   any  binary   file  into  a  series  of self-
' extracting  script  files  that  can  be  reliably  distributed  on
' text-only  conferences  or  networks.   The  script  files  can  be
' extracted with  this  program,  or  with  any  Microsoft QuickBASIC
' language (DOS 5's QBASIC, QB4.5, PDS, VB-DOS) because  each  script
' contains its own small QuickBASIC decoder.
'
' PostIt!   can  also  format  QuickBASIC  source  code  suitable for
' distribution on conferences, and reconstruct source code  formatted
' by  this  program.   This  allows  QuickBASIC programmers to easily
' exchange BASIC source code without worrying about the annoying line
' length and message limitations of most networks.
'
' ImportIt!, a new part of PostIt!, can toss the output files created
' by PostIt! into a QWK compatable .REP file.
'
' New 7.3 Features:
'
' o  Added decoding instructions to the header.
'
' New 7.2 Features:
'
' o  QWK  compatable  .REP file support  has been  included! No  more
'    importing tons of files into your reply packets via your offline
'    mail reader!
'
' New 7.1 Features:
'
' o  Totally rewritten source code!
' o  Much  more efficient  encoding algorithm (MOD 86 encoding)  with
'    a smaller and faster self extractor!
' o  Huge binary scripts now supported, up to 150k!
' o  The  script decoding & unfiltering functions  are now automated!
'    As  long  as a few  simple rules are followed (see the  notes on
'    the Decode command), no  user intervention  is needed to extract
'    multiple scripts from the same capture file.
' o  PostIt!  is  finally  a command line utility! Error codes can be
'    returned  to batch  files if  you're compiling   with  VBDOS  or
'    QBX.   Look  at the source to  find out  which error  code means
'    which.
' o  The format of PostIt!'s   message  headers has finally been well
'    thought out and (hopefully) finalized.  Although   compatibility
'    with  previous versions of PostIt!  has been sacrificed, scripts
'    created by  newer versions  of  PostIt!   should be decodable by
'    this version because of a common message header format.
'
' Explanation of Commands
'
' E = Encodes  any binary  file less than 150k into a self-extracting
'     text-only script.  If the -s  option is used with this command,
'     the entire script will be written to one output file; otherwise
'     the script will be split into multiple output files, where each
'     output file contains one message.   (Note:  Scripts created  by

'     this  command  cannot  be  extracted  by  previous  versions of
'     PostIt!.)
'
' F = Filters QuickBASIC source code for  posting  on  a  conference.
'     This  command  actually  performs  two filtering functions.  It
'     splits very long  lines  with  continuation characters (special
'     precautions are taken to ensure  quoted strings and remarks are
'     split correctly), and chops the source code into multiple files
'     so each file corresponds to one message  (unless the -s  option
'     is used).The filtered file can still be executed or compiled by
'     QuickBASIC, just as the original could.  (Note: DATA statements
'     split by filtering cannot be unsplit correctly by QB! This will
'     hopefully  be fixed  soon...   Files  filtered  by this command
'     cannot by unfiltered by previous versions of PostIt!.)
'
' D = Decodes binary/text scripts.  Multiple scripts can  be  decoded
'     from the same  input  file  with  this  function.  The decoding
'     algorithm  automatically  decides  which  method  was  used  to
'     encode the source file(binary script or source code filtering).
'
'     If  any  errors  are  encountered during decoding the script is
'     skipped  and the  partly decoded  file is deleted.
'
'     Binary and text scripts created by previous versions of PostIt!
'     cannot be decoded with this command, because of the new  header
'     format employed by this version of PostIt!.
'
'     (Notes:  Pages of a script MUST appear in increasing order.  In
'     other words, page 2 must follow page 1, page 3 must follow page
'     2, etc.  When posting  files  created  by  the E or F commands,
'     don't modify or remove the message headers because the decoding
'     algorithm expects these to indicate the beginning and ending of
'     each page.  (All message headers begin with a "'>>>" sequence.)
'     Finally, if an output file is specified on  the  command  line,
'     for  example "POSTIT D capture.txt c:\q\coolcode.zip", only the
'     specified output file  (COOLCODE.ZIP  in  the  example) will be
'     decoded if its script can be  located.   The  pathname  of  the
'     output  file  will  be  the  destination  path specified on the
'     command line.  In the  example,  the  file COOLCODE.ZIP will be
'     written to the C:\Q directory.)
'
' -Q  This  switch  will cause  PostIt!  to invoke  ImportIt!, a  new
'     feature available with version 7.2. ImportIt! will toss all the
'     files that PostIt! creates  into a QWK compatable reply  packet
'     (.REP file.) You  MUST specify  at least three  more paramaters
'     for this capability, however. They are:
'
'     [to:to_name] (optional)
'     This is the name that you would like in the "to" field (who you
'     are sending the message to.)  If it is not specified, ImportIt!
'     will substitute the name "ALL".
'
'     from:from_name
'     This is the name that you would like in the "from" field (which
'     is, more often than not, your own name)
'
'     NOTE: With  both names, if a  space is needed, use a period  in
'     the command  line (e.g.,  to:Victor.Yiu from:Calvin.French) and
'     ImportIt! will translate it to a space.
'
'     conf:conf_number
'     This is the number of the  FidoNet echomail conference that you
'     would like the  the messages to be  tossed into. This is really
'     the only very important  thing you need to remember in order to
'     use  ImportIt!  NOTE:  This  is NOT  the  NAME of the  echomail
'     conference (e.g., QUIK_BAS), but  rather the NUMBER (e.g., 32).
'     It should also  be mentioned that  sometimes this number is not
'     the same number as may appear  on your BBS's Message Base list.
'     It is suggested that  you check this  number carefully via your
'     offline  mail reader  as the  wrong  number will  toss  all the
'     messages into the wrong area.
'
'     bbsid:BBSID
'     This is  the BBS  identification  name of the  BBS you will  be
'     uploading  your  reply  packet  to.  According  to  the  naming
'     conventions outlined in the QWK format (version 1.6), this will
'     be the file name (not including the extention) of your .QWK and
'     .REP file  (QWK mail packet and reply  packet).  ImportIt! will
'     use this name to access the reply packet, so it is important to
'     get it right.
'
' Completely Stupid and Irrelevant Examples for the Average Fool
'
' postit e maim.zip -p95 -b20 c:\scripts\mc
' (Encodes a binary script of MAIM.ZIP. All output file(s) are written
'  to the C:\SCRIPTS directory and begin with the "MC" suffix. The
'  message length is 95 lines, and 20 blank lines are reserved on the
'  first message.)
' postit -a f x-ray.bas -o -s
' (Filters the file X-RAY.BAS for posting. All blank lines are padded
'  with a space, no prompting is done for file overwrites, and no
'  message splitting is performed.)
' postit d zebra.txt q\
' (Decodes all scripts from the file ZEBRA.TXT to the Q directory.)
' postit e graphics.zip -p95 -b0 -q to:You from:Me conf:32 bbsid:MYBBS
' (Encodes a binary script of GRAPHICS.ZIP. Output files are then
'  attached, or rather merged into MYBBS.REP. The messages will be from
'  YOU to ME in fidonet conference are #32. If to: was not specified,
'  it would be from YOU to ALL.) Tip: Since ImportIt! tosses files
'  directly into the .REP file, there is usually no need to reserve
'  blank lines on the first message.
'
TYPE MsgHeaderType
  Status          AS STRING * 1
  ConfNumASCII    AS STRING * 7
  MsgDate         AS STRING * 8
  MsgTime         AS STRING * 5
  ToField         AS STRING * 25
  FromField       AS STRING * 25
  SubjectField    AS STRING * 25
  PassWord        AS STRING * 12
  MsgRefNumber    AS STRING * 8
  NumBlocks       AS STRING * 6
  Flag            AS STRING * 1
  ConfNum         AS INTEGER          ' should be UNSIGNED INTEGER
  PacketMsgNumber AS STRING * 2
  NetworkTag      AS STRING * 1
END TYPE
' change the following to the name of the archiver you would like
' to use. Must be ZIP, ARJ or LHA
CONST PreferredArchiveMethod$ = "ZIP"
'CONST PreferredArchiveMethod$ = "ARJ"
'CONST PreferredArchiveMethod$ = "LHA"
DIM SHARED OutPutFile$(1 TO 256)
DEFINT A-Z
CONST true = -1, false = 0, Debug% = false
DIM SHARED GERR%: ON ERROR GOTO ErrHandler
LOCATE , , 1
PRINT "PostIt! v7.3 QuickBASIC Compatible Encoder/Decoder"
PRINT "Public Domain by Rich Geldreich and Victor Yiu"
PRINT
IF FRE(-1) < 65536 THEN ErrLvl% = 1: PRINT "Not enough memory": GOTO AllDone
DIM Params$(1 TO 10)
'The following line must be modified for DOS 5 QBASIC.
ParseCmdLine COMMAND$, Params$(), NumParams%
IF NumParams% = 0 THEN ErrLvl% = 2: GOTO ShowHelp
FOR I% = 1 TO NumParams%
  q$ = Params$(I%)
  IF LEFT$(q$, 1) <> "-" AND LEN(q$) = 1 THEN
    Command% = INSTR("EFD", q$)
    IF Command% <> 0 THEN
      Params$(I%) = "": EXIT FOR
    ELSE
      PRINT "Bad command: "; q$: PRINT : ErrLvl% = 3: GOTO ShowHelp
    END IF
  END IF
NEXT
IF Command% = 0 THEN PRINT "No command specified.": PRINT : ErrLvl% = 4: GOTO ShowHelp
IF Command% = 2 THEN DefaultLineLength% = 72 ELSE DefaultLineLength% = 65
sSwitch% = false: pSwitch% = 85: lSwitch% = DefaultLineLength%
tSwitch% = 4: oSwitch% = false: bSwitch% = 0: aSwitch% = false
iSwitch% = false: cSwitch% = false: qSwitch = 0
FOR I% = 1 TO NumParams%
  q$ = Params$(I%): Z$ = MID$(q$, 3)
  IF LEN(q$) THEN
    IF LEFT$(q$, 1) = "-" OR LEFT$(q$, 3) = "TO:" OR LEFT$(q$, 5) = "FROM:" OR LEFT$(q$, 5) = "CONF:" OR LEFT$(q$, 6) = "BBSID:" THEN
      IF LEFT$(q$, 3) <> "TO:" AND LEFT$(q$, 5) <> "FROM:" AND LEFT$(q$, 5) <> "CONF:" AND LEFT$(q$, 6) <> "BBSID:" THEN
        SELECT CASE MID$(q$, 2, 1)
          CASE "S": sSwitch% = true
          CASE "P": pSwitch% = GrabNum&(Z$, 45, 1000, 85)
          CASE "L": lSwitch% = GrabNum&(Z$, 60, 80, CLNG(DefaultLineLength%))
          CASE "T": tSwitch% = GrabNum&(Z$, 1, 8, 4)
          CASE "O": oSwitch% = true
          CASE "B": bSwitch% = GrabNum&(Z$, 0, 30, 0)
          CASE "A": aSwitch% = true
          CASE "I": iSwitch% = true
          CASE "C": cSwitch% = true
          CASE "Q"
            qSwitch% = true
            IIParse COMMAND$, toname$, fromname$, conference%, BBSID$
            qError$ = ""
            IF fromname$ = "" THEN
              qError$ = "From name not specified! "
            ELSEIF conference% = 0 THEN
              qError$ = qError$ + "Conference not specified! "
            ELSEIF BBSID$ = "" THEN
              qError$ = qError$ + "BBSID not specified! "
            END IF
            IF qError$ <> "" THEN
              PRINT LTRIM$(qError$)
              ErrLvl = 3
              qSwitch = false
              GOTO ShowHelp
            END IF
          CASE ELSE: PRINT "Bad switch: "; q$: PRINT : ErrLvl% = 3: GOTO ShowHelp
        END SELECT
      END IF
    ELSE
      SELECT CASE J%
      CASE 0: InputSpec$ = q$
      CASE 1: OutputSpec$ = q$
      CASE ELSE: PRINT "Too many filenames.": PRINT : ErrLvl% = 5: GOTO ShowHelp
      END SELECT: J% = J% + 1
    END IF
  END IF
NEXT
IF J% < 1 THEN PRINT "Must specify input file.": PRINT : ErrLvl% = 5: GOTO ShowHelp
SepPath InputSpec$, InputDrive$, InputPath$, InputName$
IF INSTR(InputName$, ".") = 0 THEN
  IF Command% = 1 THEN     'encoding  .ZIP
    InputSpec$ = InputSpec$ + ".ZIP"
  ELSEIF Command% = 2 THEN 'filtering .BAS
    InputSpec$ = InputSpec$ + ".BAS"
  ELSEIF Command% = 3 THEN 'decoding  .TXT
    InputSpec$ = InputSpec$ + ".TXT"
  END IF
ELSE
  IF Command% = 1 THEN
    SELECT CASE MID$(InputName$, INSTR(InputName$, ".") + 1, 3)
    CASE "ZIP", "LZH", "ARJ", "GIF", "SQZ", "ZOO", "ARC", "HAP", "JPG"
    CASE ELSE: PRINT "Warning: Uncompressed files should not be" + " encoded" + " into binary scripts!": PRINT
  END SELECT
  END IF
END IF
OPEN InputSpec$ FOR INPUT AS #1: CLOSE #1
IF GERR% THEN PRINT "Can't open "; InputSpec$: ErrLvl% = 6: GOTO AllDone
SepPath OutputSpec$, OutDrive$, OutPath$, OutName$
TestFile$ = OutDrive$ + OutPath$ + "pi742875.2yz"
OPEN TestFile$ FOR OUTPUT AS #1: CLOSE #1
IF GERR% THEN PRINT "Bad output specification.": ErrLvl% = 7: GOTO AllDone
KILL TestFile$
SELECT CASE Command%
CASE 1: Status% = Encode%(0, iSwitch%, cSwitch%, aSwitch%, tSwitch%, sSwitch%, pSwitch%, lSwitch%, oSwitch%, bSwitch%, InputSpec$, OutputSpec$)
CASE 2: Status% = Encode%(1, iSwitch%, cSwitch%, aSwitch%, tSwitch%, sSwitch%, pSwitch%, lSwitch%, oSwitch%, bSwitch%, InputSpec$, OutputSpec$)
CASE 3: Status% = Decode%(oSwitch%, InputSpec$, OutputSpec$)
END SELECT
IF Status% < 0 THEN ErrLvl% = 8 ELSE IF Status% > 0 THEN ErrLvl% = 9 ELSE ErrLvl% = 0
GOTO AllDone
ShowHelp:
PRINT "Usage: POSTIT [switch] command inputfile [outputfile] [-q" + " options]"
PRINT
PRINT "Commands:"
PRINT "e [E]ncode any file <150k into a self extracting binary script"
PRINT "f [F]ilter QB source into a text script"
PRINT "d [D]ecode captured text or binary script(s)"
PRINT
PRINT "Switches:"
PRINT "-s  Don't split output file into multiple messages"
PRINT "-o  Don't prompt for file overwrites"
PRINT "-b# Reserve # blank lines on first message (0-30, default=0)"
PRINT "-t# Set tab stops to # characters (1-8, default=4)"
PRINT "-l# Set line length to # characters (60-80, default=65 or 72)"
PRINT "-p# Set message length to # lines (45-1000, default=85)"
PRINT "-a  Padd blank lines with a space when filtering"
PRINT "-i  Ignore blank lines when filtering"
PRINT "-c  Crush space characters from start of lines when filtering"
PRINT
PRINT "ImportIt! (QWK compatable .REP file support):"
PRINT "-q [to:to_name] from:from_name conf:conf_num bbsid:BBSID"
AllDone:
IF qSwitch = true THEN
  IF GERR < 0 THEN
    IF Debug% THEN PRINT "Exiting with an errorlevel of"; ErrLvl%
    END
  END IF
  FOR n = 1 TO 256
    a$ = OutPutFile$(n)
    IF a$ = "" THEN EXIT FOR
  NEXT n
  NumFiles = n - 1
  DIM MsgFiles$(1 TO NumFiles)
  FOR n = 1 TO NumFiles
    MsgFiles$(n) = OutPutFile$(n)
  NEXT n
  FOR n = LEN(InputSpec$) TO 1 STEP -1
    IF MID$(InputSpec$, n, 1) = "\" THEN StartFname = n + 1
  NEXT n
  IF StartFname <> 0 THEN
    TitleFile$ = MID$(InputSpec$, StartFname, 1)
  ELSE
    TitleFile$ = InputSpec$
  END IF
  FOR n = 1 TO LEN(toname$)
    IF MID$(toname$, n, 1) = "." THEN MID$(toname$, n, 1) = " "
  NEXT n
  FOR n = 1 TO LEN(fromname$)
    IF MID$(fromname$, n, 1) = "." THEN MID$(fromname$, n, 1) = " "
  NEXT n
  ImportIt BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference%
END IF
IF Debug% THEN PRINT "Exiting with an errorlevel of"; ErrLvl%
END
ErrHandler: GERR% = ERR
  IF Debug% THEN IF GERR% <> 53 THEN PRINT "Global error #"; GERR%
RESUME NEXT

SUB AddToRep (BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference, ErrorCode$)
  DIM MsgHeader     AS MsgHeaderType
  DIM QWKRecBuff    AS STRING * 128
  DIM QWKByteBuff   AS STRING * 1
  DIM ArcHeader     AS STRING * 3
  ' test for file
  OPEN BBSID$ + ".REP" FOR BINARY AS #1
  IF LOF(1) = 0 THEN
    CLOSE #1
    KILL BBSID$ + ".REP"
    ErrorCode$ = "Reply packet (.REP file) not found!"
    EXIT SUB
  END IF
  ' test for messages
  NumMessages = UBOUND(MsgFiles$)
  IF NumMessages = 0 THEN
    CLOSE #1
    ErrorCode$ = "No files to add to reply (.REP) packet!"
    EXIT SUB
  END IF
  ' check ToName$
  IF toname$ = "" THEN
    toname$ = "ALL"
  END IF
  ' check FromName$
  IF fromname$ = "" THEN
    CLOSE #1
    ErrorCode$ = "No from field (name) specified!"
    EXIT SUB
  END IF
  CLOSE #1
  ' process mail packet
  PRINT
  PRINT "Unarchiving "; BBSID$ + ".REP";
  ' determine archive type
  OPEN BBSID$ + ".REP" FOR BINARY AS #1
  ' PKZIP file?
  SEEK 1, 1
  GET #1, , ArcHeader
  IF ArcHeader = "PK" + CHR$(3) THEN
    DeArcCommand$ = "PKUNZIP"
    ArcCommand$ = "PKZIP"
    ArcType$ = "ZIP"
  END IF
  ' LZH file?
  SEEK 1, 3
  GET #1, , ArcHeader
  IF ArcHeader = "-lh" THEN
    DeArcCommand$ = "LHA E"
    ArcCommand$ = "LHA A /M"
    ArcType$ = "LZH"
  END IF
  ' ARJ file?
  SEEK 1, 1
  GET #1, , ArcHeader
  IF LEFT$(ArcHeader, 2) = "'" + CHR$(234) THEN
    DeArcCommand$ = "ARJ E"
    ArcCommand$ = "ARJ A -Y"
    ArcType$ = "ARJ"
  END IF
  ' dearchive file
  PRINT " using "; ArcType$
  SHELL DeArcCommand$ + " " + BBSID$ + ".REP"
  CLOSE #1
  ' test for file
  OPEN BBSID$ + ".MSG" FOR BINARY AS #1
  IF LOF(1) = 0 THEN
    ErrorCode$ = "Error occured during DeArchiving. File " + BBSID$ + ".MSG not found in archive"
    CLOSE #1
    KILL BBSID$ + ".MSG"
    EXIT SUB
  END IF
  ' read messages
  PRINT
  PRINT "Reading Messages from "; BBSID$; ".MSG..."
  SEEK 1, 1
  GET #1, , QWKRecBuff
  DO
    GET #1, , MsgHeader
    NewHighest = VAL(MsgHeader.MsgRefNumber)
    IF NewHighest > Highest THEN Highest = NewHighest
    ' read until next message
    FOR n = 1 TO VAL(MsgHeader.NumBlocks) - 1
      GET #1, , QWKRecBuff
    NEXT n
  LOOP UNTIL SEEK(1) >= LOF(1)
  PRINT
  PRINT "Writing new messages..."
  PRINT
  PRINT "To:     "
  PRINT "From:   "
  PRINT "Subj:   "
  PRINT "Conf:   "
  PRINT "Date:   "
  PRINT "Time:   "
  PRINT "Number: "
  StartLin = CSRLIN - 7
  FOR msg = 1 TO NumMessages
    LOCATE StartLin, 1
    Subj$ = "[" + LTRIM$(STR$(msg)) + "/" + LTRIM$(STR$(NumMessages)) + "] " + TitleFile$
    conf$ = LTRIM$(STR$(conference))
    num$ = LTRIM$(STR$(msg + Highest - 1))
    dat$ = LEFT$(DATE$, 6) + RIGHT$(DATE$, 2)
    tim$ = LEFT$(TIME$, 5)
    PRINT "To:     "; toname$
    PRINT "From:   "; fromname$
    PRINT "Subj:   "; Subj$
    PRINT "Conf:   "; conf$
    PRINT "Date:   "; dat$
    PRINT "Time:   "; tim$
    PRINT "Number: "; num$
    PRINT "Writing File: "; MsgFiles$(msg);
    TotalLen& = 0
    OPEN MsgFiles$(msg) FOR INPUT AS #2
    OPEN "~IIBETA.TMP" FOR BINARY AS #3
    DO WHILE NOT EOF(2)
      LINE INPUT #2, text$
      text$ = text$ + CHR$(227)
      PUT #3, , text$
    LOOP
    TotalLen& = SEEK(3)
    TotalLen& = TotalLen& + 128       ' for tagline
    QWKRecBuff = CHR$(227) + " * ImportIt! v1.0b [BETA] * ImportIt!" + " [PD] by Calvin French, August 1993" + CHR$(227) + CHR$(227)
    PUT #3, , QWKRecBuff
    ExtraString$ = SPACE$(128 - (TotalLen& MOD 128))
    TotalLen& = TotalLen& + LEN(ExtraString$)
    PUT #3, , ExtraString$
    Blocks$ = LTRIM$(STR$((TotalLen& / 128) + 1))
    MsgHeader.Status = "-"            ' public, read
    MsgHeader.ConfNumASCII = conf$    ' conference (.REP only)
    MsgHeader.MsgDate = dat$          ' date
    MsgHeader.MsgTime = tim$          ' time
    MsgHeader.ToField = toname$       ' to
    MsgHeader.FromField = fromname$   ' from
    MsgHeader.SubjectField = Subj$    ' subject
    MsgHeader.PassWord = SPACE$(12)   ' password
    MsgHeader.MsgRefNumber = num$     ' message number
    MsgHeader.NumBlocks = Blocks$     ' blocks in message
    MsgHeader.Flag = CHR$(225)        ' active flag
    MsgHeader.ConfNum = conference    ' conference (.REP and .QWK)
    MsgHeader.PacketMsgNumber = " "   ' not sure what this is.
    MsgHeader.NetworkTag = " "        ' network tagline
    PUT #1, , MsgHeader
    SEEK 3, 1
    FOR n = 1 TO TotalLen& / 128
      GET #3, , QWKRecBuff
      PUT #1, , QWKRecBuff
    NEXT n
    CLOSE #3
    CLOSE #2
    KILL "~IIBETA.TMP"
  NEXT msg
  CLOSE #1
  PRINT
  PRINT
  PRINT "Rearchiving Packet..."
  SHELL ArcCommand$ + " " + BBSID$ + ".REP " + BBSID$ + ".MSG"
  PRINT
  PRINT "Deleting " + BBSID$ + ".MSG..."
  PRINT
  KILL BBSID$ + ".MSG"
  ErrorCode$ = "Packet Successfully Processed!"
END SUB

SUB CreateRep (BBSID$, ArcCommand$)

DIM QWKRecBuff AS STRING * 128

PRINT
PRINT "Creating message data file (.MSG file)..."
PRINT

OPEN BBSID$ + ".MSG" FOR BINARY AS #1

QWKRecBuff = UCASE$(BBSID$)

PUT #1, , QWKRecBuff

CLOSE #1

PRINT "Archiving file..."

SHELL ArcCommand$ + " " + BBSID$ + ".REP " + BBSID$ + ".MSG"

PRINT
PRINT "Deleting message data file (.MSG file)..."

KILL BBSID$ + ".MSG"

END SUB

FUNCTION Decode% (oSwitch%, InSpec$, OutSpec$)
  DIM Lines$(1 TO 256), ValidChar%(255)
  FOR q% = 0 TO 85 'Valid encoding characters
    IF q% = 27 THEN
      ValidChar%(ASC("#")) = true
    ELSEIF q% = 59 THEN
      ValidChar%(ASC("$")) = true
    ELSE
      ValidChar%(q% + 37) = true
    END IF
  NEXT
  GERR% = 0: Z$ = "OPEN " + CHR$(34) + "O" + CHR$(34) + ",1," + CHR$(34)
  SepPath OutSpec$, OutDrive$, OutPath$, OutName$
  OutPath$ = OutDrive$ + OutPath$
  InputHandle% = FREEFILE
  OPEN InSpec$ FOR INPUT AS InputHandle% LEN = 8192
  OutputHandle% = FREEFILE
  DO
    IF FoundNewScript% = false THEN
      DO UNTIL EOF(InputHandle%)
        M% = M% + 1: IF M% = 16 THEN GOSUB AbortCheck
        LineNum& = LineNum& + 1
        LINE INPUT #1, a$: a$ = LTRIM$(RTRIM$(UCASE$(a$)))
        IF GERR% THEN PRINT "Error while reading from input file!": GOTO DecodeExit
        IF LEFT$(a$, 14) = "'>>> PAGE 1 OF" AND INSTR(a$, "BEGINS" + " HERE") > 0 AND INSTR(a$, "TYPE:") > 0 THEN EXIT DO
      LOOP
      IF EOF(InputHandle%) THEN EXIT DO
    END IF
    FoundNewScript% = false
    OutFile$ = LTRIM$(MID$(a$, 15))
    OutFile$ = RTRIM$(LEFT$(OutFile$, INSTR(OutFile$, "BEGINS") - 1))
    IF LEN(OutFile$) = 0 THEN GOTO FindNext
    IF LEN(OutName$) = 0 OR OutFile$ = OutName$ THEN
      FilesCRC% = -1: FilesLength& = -1: ScrDone% = false
      BadScript% = false: NumLines% = 0: K% = 0: s% = 0: b& = 0
      q% = INSTR(a$, "TYPE:") + 5
      SELECT CASE MID$(a$, q%, 3)
      CASE "BAS": ScriptType% = 0
      CASE "BIN"
        ScriptType% = 1
        EncodeVer% = FASC%(MID$(a$, q% + 3, 1)) - 65
        ExtractVer% = FASC%(MID$(a$, q% + 4, 1)) - 65
        IF ExtractVer% <> 0 THEN PRINT "Unsupported encoding algorithm" + "" + " for file "; OutFile$: PRINT : GOTO FindNext
      CASE ELSE: PRINT "Unsupported script type for file "; OutFile$: PRINT : GOTO FindNext
      END SELECT
      GOSUB CheckLine
      OPEN OutPath$ + OutFile$ FOR INPUT AS OutputHandle%: CLOSE OutputHandle%
      IF GERR% = 0 THEN
        IF oSwitch% = false THEN
          PRINT OutPath$ + OutFile$; " already exists. [O]verwrite, or" + "" + " [A]bort(o/a)? ";
          DO: DO: a$ = INKEY$: LOOP UNTIL LEN(a$): a$ = UCASE$(a$)
          LOOP UNTIL INSTR("OA" + CHR$(27), a$)
          LOCATE , 1: PRINT SPACE$(78); : LOCATE , 1
          SELECT CASE a$
          CASE "A", CHR$(27): GERR% = -1: PRINT "Aborted by user!": GOTO DecodeExit
          END SELECT
        END IF
      END IF
      GERR% = 0: OPEN OutPath$ + OutFile$ FOR OUTPUT AS OutputHandle%
      IF GERR% THEN PRINT "Error while opening "; OutPath$ + OutFile$; "!": GOTO DecodeExit
      OutSpecOpened% = true
      IF ScriptType% = 0 THEN PRINT "Unfiltering ";  ELSE PRINT "Decoding ";
      PRINT OutPath$ + OutFile$; "... ";
      LookingForNextPage% = false
      CurrentPage% = 1
      DO UNTIL EOF(InputHandle%)
        IF GERR% THEN PRINT "Error #"; STR$(GERR%); " while processing" + "" + " file!": GOTO DecodeExit
        M% = M% + 1: IF M% = 16 THEN GOSUB AbortCheck
        LineNum& = LineNum& + 1
        LINE INPUT #InputHandle%, a$: a$ = RTRIM$(a$)
        IF ScriptType% = 1 THEN a$ = LTRIM$(a$)
        IF LEFT$(a$, 4) = "'>>>" THEN
          GOSUB CheckLine
          IF UCASE$(LEFT$(a$, 10)) = "'>>> PAGE " THEN
            a$ = UCASE$(a$)
            IF LEFT$(a$, 15) = "'>>> PAGE 1 OF " AND INSTR(a$, "BEGINS" + "" + " HERE") > 0 THEN
              PRINT "Premature end of script on line"; LineNum&
              FoundNewScript% = true: BadScript% = true: EXIT DO
            END IF
            IF GrabNum&(MID$(a$, 11), 1, 256, -1) <> CurrentPage% THEN PRINT "Page out of sync on line"; LineNum&: BadScript% = true: EXIT DO
            IF INSTR(a$, "BEGINS HERE") THEN
              IF LookingForNextPage% = false THEN PRINT "Page"; CurrentPage%; " was encountered more than once on line"; LineNum&: BadScript% = true: EXIT DO
              LookingForNextPage% = false
            ELSEIF INSTR(a$, "ENDS HERE") THEN
              IF LookingForNextPage% = true THEN PRINT "Page"; CurrentPage%; "was terminated prematurely on line"; LineNum&: BadScript% = true: EXIT DO
              LookingForNextPage% = true
              CurrentPage% = CurrentPage% + 1
              IF INSTR(a$, "LAST PAGE") THEN ScrDone% = true: EXIT DO
            ELSE
              PRINT "Bad page header on line"; LineNum&: BadScript% = true: EXIT DO
            END IF
          END IF
        ELSE
          IF LookingForNextPage% = false THEN
            IF ScriptType% = 0 THEN
              GOSUB ShrinkLine
            ELSE
              IF LEFT$(a$, 1) = "U" AND LEFT$(LTRIM$(MID$(a$, 2)), 1) = CHR$(34) THEN GOSUB DecodeLine
            END IF
          END IF
        END IF
      LOOP
      IF BadScript% = false THEN
        IF ScrDone% = false THEN PRINT "Premature end of script on" + " line"; LineNum&: BadScript% = true: GOTO DecodeDone
        GoodScripts% = GoodScripts% + 1
        IF ScriptType% = 0 THEN
          IF NumLines% > 0 THEN a$ = "": GOSUB ShrinkLine
          PRINT "Ok"
        ELSE
          IF FilesLength& = -1 THEN
            PRINT "Warning: File's length could not be located!"
          ELSEIF FilesLength& <> b& THEN
            PRINT "Warning: Decoded file's length is incorrect."
          ELSEIF FilesCRC% = -1 THEN
            PRINT "Warning: File's checksum could not be located!"
          ELSEIF FilesCRC% <> s% THEN
            PRINT "Warning: Decoded file's checksum is incorrect."
          ELSE
            PRINT "Ok"
          END IF
        END IF
      END IF
DecodeDone:
      CLOSE OutputHandle%
      IF GERR% THEN PRINT "Error while writing to output file!": GOTO DecodeExit
      IF BadScript% THEN KILL OutPath$ + OutFile$
      OutSpecOpened% = false
      PRINT : IF OutFile$ = OutName$ THEN EXIT DO
    END IF
FindNext:
  LOOP UNTIL EOF(InputHandle%)
'----------------------------------------------------------
DecodeExit:
  q% = GERR%: CLOSE InputHandle%: CLOSE OutputHandle%
  IF q% = 0 THEN PRINT LTRIM$(STR$(GoodScripts%)); " script(s) decoded" + "" + " successfully."
  IF q% <> 0 AND OutSpecOpened% THEN KILL OutPath$ + OutFile$
  Decode% = q%
EXIT FUNCTION
'----------------------------------------------------------
ShrinkLine:
  FoundIt% = FASC(RIGHT$(a$, 1)) = 95
  IF FoundIt% THEN
    InQuote% = false
    FOR I% = 1 TO LEN(a$)
      IF MID$(a$, I%, 1) = CHR$(34) THEN InQuote% = NOT InQuote%
    NEXT
    'Don't combine lines that are part of binary scripts
    IF InQuote% THEN FoundIt% = false
  END IF
  IF FoundIt% OR NumLines% > 0 THEN
    IF NumLines% = 256 THEN
      PRINT "Too many line continuations!": BadScript% = true: GOTO DecodeDone
    END IF
    NumLines% = NumLines% + 1: Lines$(NumLines%) = a$
    IF FoundIt% = false THEN 'last line?
      a$ = ""
      FOR a% = 1 TO NumLines%
        b$ = Lines$(a%)
        'can we combine two quoted strings together?
        CombineQuote% = false
        IF RIGHT$(a$, 2) = "+_" AND LEN(a$) > 3 THEN
          IF RIGHT$(RTRIM$(LEFT$(a$, LEN(a$) - 2)), 1) = CHR$(34) THEN
            IF FASC(LTRIM$(b$)) = 34 THEN CombineQuote% = true
          END IF
        END IF
        IF CombineQuote% THEN
          a$ = RTRIM$(LEFT$(a$, LEN(a$) - 2))
          a$ = LEFT$(a$, LEN(a$) - 1) + MID$(LTRIM$(b$), 2)
        ELSE
          InQuote% = false
          'can we combine two remarks together?
          FOR I% = 1 TO LEN(a$)
            q$ = MID$(a$, I%, 1)
            IF q$ = CHR$(34) THEN
              InQuote% = NOT InQuote%
            ELSEIF InQuote% = false THEN
              IF q$ = "'" OR UCASE$(MID$(a$, I%, 4)) = "REM " THEN
                IF LEFT$(LTRIM$(b$), 1) = "'" THEN b$ = MID$(b$, 2)
                EXIT FOR
              END IF
            END IF
          NEXT
          'eradicate trailing "_" character
          IF LEN(a$) THEN a$ = LEFT$(a$, LEN(a$) - 1)
          a$ = a$ + b$
        END IF
      NEXT
      PRINT #OutputHandle%, a$: NumLines% = 0
    END IF
  ELSE
    PRINT #OutputHandle%, a$
  END IF
  IF GERR% THEN PRINT "Error while writing to output file!": GOTO DecodeExit
RETURN
'----------------------------------------------------------
DecodeLine: '**MOD 86 Decoder**
  a$ = MID$(LTRIM$(MID$(a$, 2)), 2)
  IF RIGHT$(a$, 1) = CHR$(34) THEN a$ = LEFT$(a$, LEN(a$) - 1)
  FOR a% = 1 TO LEN(a$)
    C% = ASC(MID$(a$, a%, 1))
    IF ValidChar%(C%) = false THEN PRINT "Illegal character found on" + " line"; LineNum&: BadScript% = true: GOTO DecodeDone
    C% = C% - 37: IF C% < 0 THEN C% = 91 + C% * 32
    IF K% < 4 THEN
      IF C% > 80 THEN PRINT "Decode out of sync/illegal character" + " found" + " on line"; LineNum&: BadScript% = true: GOTO DecodeDone
      K% = C% + 243
    ELSE
      T% = C% + (K% MOD 3) * 86: IF T% > 255 THEN PRINT "Illegal" + " character found on line"; LineNum&: BadScript% = true: GOTO DecodeDone
      PRINT #OutputHandle%, CHR$(T%);
      IF GERR% THEN PRINT "Error while writing to output file!": GOTO DecodeExit
      b& = b& + 1: K% = K% \ 3
    END IF
    s% = (s% + C%) AND 255
  NEXT
RETURN
'----------------------------------------------------------
CheckLine:
  q% = INSTR(a$, "TLEN:")
  IF q% THEN FilesLength& = GrabNum&(MID$(a$, q% + 5), 1, 153600, -1)
  q% = INSTR(a$, "TCHK:")
  IF q% THEN FilesCRC% = GrabNum&(MID$(a$, q% + 5), 0, 255, -1)
RETURN
'----------------------------------------------------------
AbortCheck: M% = 0: K$ = INKEY$
  IF K$ = CHR$(27) OR K$ = CHR$(0) + CHR$(0) THEN GERR% = -1: PRINT "Aborted by user!": GOTO DecodeExit
RETURN
END FUNCTION

FUNCTION Encode% (Op%, iSwitch%, cSwitch%, aSwitch%, tSwitch%, sSwitch%, pSwitch%, lSwitch%, oSwitch%, bSwitch%, InSpec$, OutSpec$)
  ' following SHARED is for ImportIt!
  DIM Bucket%(1 TO 4), Lines$(64)
  GERR% = 0: q$ = CHR$(34)
'----------------------------------------------------------
  SepPath InSpec$, OutDrive$, OutPath$, InName$
  SepPath OutSpec$, OutDrive$, OutPath$, OutName$
  IF LEN(OutName$) = 0 THEN
    OutName$ = InName$
    IF INSTR(OutName$, ".") THEN OutName$ = LEFT$(OutName$, INSTR(OutName$, ".") - 1)
  END IF
  IF INSTR(OutName$, ".") THEN
    OutExt$ = MID$(OutName$, INSTR(OutName$, "."))
    OutName$ = LEFT$(OutName$, INSTR(OutName$, ".") - 1)
  END IF
  IF LEN(OutExt$) = 0 THEN IF Op% THEN OutExt$ = ".PST" ELSE OutExt$ = ".PI"
'----------------------------------------------------------
  InputHandle% = FREEFILE
  IF Op% THEN
    OPEN InSpec$ FOR INPUT AS InputHandle% LEN = 8192
  ELSE
    OPEN InSpec$ FOR BINARY AS InputHandle%
  END IF
  InputFileSize& = LOF(InputHandle%)
  IF Op% = 0 AND InputFileSize& > (150 * 1024&) THEN
    PRINT "Can't encode files larger than 150k."
    GERR% = -1: GOTO EncodeExit
  ELSEIF InputFileSize& = 0 THEN
    PRINT "Input file is null.": GERR% = -2: GOTO EncodeExit
  END IF
'----------------------------------------------------------
  IF Op% THEN PRINT "Filtering ";  ELSE PRINT "Encoding ";
  PRINT InSpec$; " ("; LTRIM$(STR$((InputFileSize& + 1023) \ 1024)); "k)"
  PRINT
'----------------------------------------------------------
  OutputHandle% = FREEFILE: LinesInPage% = 0
'----------------------------------------------------------
  IF Op% = 0 THEN
    Work$ = "U" + q$ + SPACE$(lSwitch% - 2): WorkPos% = 3
    CurrentSub% = 0: LinesInSub% = 0: FlagScaler% = 1
    GOSUB PrintDecodeHeader
    BytesLeft& = InputFileSize&: BufferSize% = 4096
    Buffer$ = SPACE$(BufferSize)
    DO
      IF GERR% THEN PRINT "- Error #"; STR$(GERR%); " while encoding" + " file!": GOTO EncodeExit
      IF BytesLeft& < BufferSize% THEN Buffer$ = SPACE$(BytesLeft&): BufferSize% = BytesLeft&
      GET InputHandle%, , Buffer$
      IF GERR% THEN PRINT "- Error while reading from input file!": GOTO EncodeExit
      GOSUB EncodeBlock
    LOOP WHILE BytesLeft&
    IF NumCodes% THEN GOSUB FlushCodeBuffer
    IF WorkPos% > 3 THEN Work$ = LEFT$(Work$, WorkPos% - 1): GOSUB PutSubLine
    IF LinesInSub% THEN L$ = "END SUB": GOSUB PutLine
    FOR a% = 2 TO CurrentSub%: L$ = "V" + HEX$(a%): GOSUB PutLine: NEXT
    GOSUB PrintDecodeTrailer
  ELSE
    BytesLeft& = InputFileSize&
    DO UNTIL EOF(InputHandle)
      IF GERR% THEN PRINT "- Error #"; STR$(GERR%); " while filtering" + "" + " file!": GOTO EncodeExit
      LINE INPUT #InputHandle, a$: a$ = RTRIM$(UnTab$(a$, tSwitch%))
      IF GERR% THEN PRINT "- Error while reading from input file!": GOTO EncodeExit
      IF cSwitch% THEN a$ = LTRIM$(a$)
      BytesLeft& = BytesLeft& - LEN(a$) - 2
      IF LEN(a$) > 0 OR iSwitch% = false THEN
        ExpandLine a$, Lines$(), lSwitch%, NumLines%
        'Don't let split lines cross page boundries, because QB won't
        'put them back together.
        IF sSwitch% = false AND (NumLines% > 1) AND (LinesInPage% + 1 + NumLines%) > pSwitch% THEN
          PRINT #OutputHandle%, "'>>> Page"; STR$(NumOutputFiles%); " of "; InName$; " ends here. Continued on next page."
          LinesInPage% = LinesInPage% + 1: GOSUB CloseOutputFile
        END IF
        FOR a% = 1 TO NumLines%
          L$ = Lines$(a%)
          'Don't let blank lines proceed the first page header.
          IF LinesInPage% <> 0 OR LEN(RTRIM$(L$)) > 0 THEN
            'The padding option is for those unfortunates that post
            'source online in RBBS's grubby line oriented text editor...
            IF aSwitch% THEN IF LEN(L$) = 0 THEN L$ = " "
            GOSUB PutLine
          END IF
        NEXT
      END IF
    LOOP
  END IF
'----------------------------------------------------------
  L$ = "'>>> Page" + STR$(NumOutputFiles%) + " of " + InName$ + " ends" + "" + " here. Last page."
  IF Op% = 0 THEN L$ = L$ + " TCHK:" + LTRIM$(STR$(CheckSum%))
  GOSUB PutLine: GOSUB CloseOutputFile: PRINT
  PRINT LTRIM$(STR$(TotalLines%)); " lines in"; STR$(NumOutputFiles%); " message(s) written."
'----------------------------------------------------------
EncodeExit:
  q% = GERR%
  CLOSE InputHandle%: CLOSE OutputHandle%
  IF q% <> 0 THEN FOR a% = 1 TO NumOutputFiles%: KILL OutPutFile$(a%): NEXT
  Encode% = q%
EXIT FUNCTION
'----------------------------------------------------------
EncodeBlock: '**MOD 86 Encoder**
  FOR I% = 1 TO BufferSize%
    Byte% = ASC(MID$(Buffer$, I%, 1)): BytesLeft& = BytesLeft& - 1
    CurrentFlag% = CurrentFlag% + (Byte% \ 86) * FlagScaler%
    FlagScaler% = FlagScaler% * 3: NumCodes% = NumCodes% + 1
    Bucket%(NumCodes%) = Byte% MOD 86
    IF NumCodes% = 4 THEN GOSUB FlushCodeBuffer
  NEXT
RETURN
'----------------------------------------------------------
FlushCodeBuffer:
  q% = CurrentFlag%: GOSUB PutByte
  FOR J% = 1 TO NumCodes%: q% = Bucket%(J%): GOSUB PutByte: NEXT
  NumCodes% = 0: CurrentFlag% = 0: FlagScaler% = 1
RETURN
'----------------------------------------------------------
PutByte:
  CheckSum% = (CheckSum% + q%) AND 255
  IF q% = 27 THEN
    MID$(Work$, WorkPos%) = "#"
  ELSEIF q% = 59 THEN
    MID$(Work$, WorkPos%) = "$"
  ELSE
    MID$(Work$, WorkPos%) = CHR$(q% + 37)
  END IF
  WorkPos% = WorkPos% + 1: IF WorkPos% > lSwitch% THEN GOSUB PutSubLine
RETURN
'----------------------------------------------------------
PutSubLine:
  IF LinesInSub% = 0 THEN
    CurrentSub% = CurrentSub% + 1
    IF CurrentSub% = 1 THEN
      L$ = "SUB V1:OPEN " + q$ + "O" + q$ + ",1," + q$ + InName$ + q$ + ",4^6:Z&=" + LTRIM$(STR$(LOF(1))) + ":?STRING$(50,177);"
    ELSE
      L$ = "SUB V" + HEX$(CurrentSub%)
    END IF
    GOSUB PutLine
  END IF
  L$ = Work$: GOSUB PutLine
  LinesInSub% = LinesInSub% + 1
  IF LinesInSub% = 200 THEN L$ = "END SUB": GOSUB PutLine: LinesInSub% = 0
  WorkPos% = 3
RETURN
'----------------------------------------------------------
PutLine:
  IF LinesInPage% = 0 THEN GOSUB OpenNewOutputFile
  PRINT #OutputHandle%, L$
  IF GERR% THEN PRINT "- Error writing to output file!": GOTO EncodeExit
  LinesInPage% = LinesInPage% + 1
  IF sSwitch% = false THEN
    'make sure last page has some meat on it
    IF LinesInPage% = (pSwitch% - 1) OR (BytesLeft& < 256 AND LinesInPage% > (pSwitch% - 10)) THEN
      PRINT #OutputHandle%, "'>>> Page"; STR$(NumOutputFiles%); " of "; InName$; " ends here. Continued on next page."
      LinesInPage% = LinesInPage% + 1: GOSUB CloseOutputFile
    END IF
  END IF
  'Check the blower for contol+c and escape every few lines...
  IF (LinesInPage% AND 7) = 1 THEN
    a$ = INKEY$: IF a$ = CHR$(27) OR a$ = CHR$(0) + CHR$(0) THEN GERR% = -3: PRINT "- Aborted by user!": GOTO EncodeExit
  END IF
RETURN
'----------------------------------------------------------
OpenNewOutputFile:
  IF NumOutputFiles% = 256 THEN GERR% = -4: PRINT "Too many output" + " files!": GOTO EncodeExit
  NumOutputFiles% = NumOutputFiles% + 1
  IF sSwitch% = true THEN
    J$ = OutName$
  ELSE
    J$ = LTRIM$(STR$(NumOutputFiles%))
    J$ = LEFT$(OutName$, 8 - LEN(J$)) + J$
  END IF
  OutFile$ = OutDrive$ + OutPath$ + J$ + OutExt$: GERR% = 0
  OPEN OutFile$ FOR INPUT AS OutputHandle%: CLOSE OutputHandle%
  IF GERR% = 0 THEN
    IF oSwitch% = false THEN
      PRINT OutFile$; " already exists. [O]verwrite, overwrite [R]est," + "" + " or [A]bort(o/r/a)? ";
      DO: DO: a$ = INKEY$: LOOP UNTIL LEN(a$): a$ = UCASE$(a$)
      LOOP UNTIL INSTR("ORA" + CHR$(27), a$)
      LOCATE , 1: PRINT SPACE$(78); : LOCATE , 1
      SELECT CASE a$
      CASE "A", CHR$(27): GERR% = -3: PRINT "Aborted by user!"
        NumOutputFiles% = NumOutputFiles% - 1: GOTO EncodeExit
      CASE "R": oSwitch% = true
      END SELECT
    END IF
  END IF
  PRINT "Now writing: "; OutFile$; " ";
  GERR% = 0: OPEN OutFile$ FOR OUTPUT AS OutputHandle% LEN = 4096
  OutPutFile$(NumOutputFiles%) = OutFile$
  IF GERR% THEN
    PRINT "- Error opening output file!"
    NumOutputFiles% = NumOutputFiles% - 1: GOTO EncodeExit
  END IF
  LinesInPage% = 1
  IF NumOutputFiles% = 1 THEN
    FOR I% = 1 TO bSwitch%
      IF aSwitch% THEN PRINT #OutputHandle, " " ELSE PRINT #OutputHandle,
    NEXT
    LinesInPage% = LinesInPage% + bSwitch%
  END IF
  PRINT #OutputHandle%, "'>>> Page"; STR$(NumOutputFiles%); " of "; InName$; " begins here.";
  IF NumOutputFiles% > 1 THEN
    PRINT #OutputHandle%,
  ELSE
    IF Op% = 0 THEN
      'The first letter after "BIN" is  which algorithm was used
      'to encode the file. The second letter is the minimum decoding
      'algorithm required to extract the file. Both range from A-Z.
      PRINT #OutputHandle%, " TYPE:BINAA";
      'TLEN stands for "total length".
      PRINT #OutputHandle%, " TLEN:"; LTRIM$(STR$(InputFileSize&))
      'In the future, other information may be put onto this line,
      'such as the file's date and time. (Actually, any line
      'starting will "'>>>" will be scanned for information by
      'the Decode function.)
    ELSE
      PRINT #OutputHandle%, " TYPE:BAS"
    END IF
  END IF
  GERR% = 0
RETURN
'----------------------------------------------------------
CloseOutputFile:
  CLOSE OutputHandle%
  IF GERR% THEN PRINT "- Error while writing to output file!": GOTO EncodeExit
  PRINT : TotalLines% = TotalLines% + LinesInPage%: LinesInPage% = 0
RETURN
'----------------------------------------------------------
PrintDecodeHeader:
 
'This section added 5/23/96 by Steve Harmon
'This section modified 6/11/96 by Steve Harmon
  L$ = "'-------------------------------------------------------------"
  GOSUB PutLine
  L$ = "'                  INSTRUCTIONS FOR DECODING"
  GOSUB PutLine
  L$ = "'If there are multiple parts to this file, merge them into one"
  GOSUB PutLine
  L$ = "'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all"
  GOSUB PutLine
  L$ = "'message header and footer information (everything outside the"
  GOSUB PutLine
  L$ = "'" + CHR$(34) + ">>> Page x of..." + CHR$(34) + " lines),  load the result into your version"
  GOSUB PutLine
  L$ = "'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original"
  GOSUB PutLine
  L$ = "'file will be decoded into the current directory on your disk."
  GOSUB PutLine
  L$ = "'-------------------------------------------------------------"
  GOSUB PutLine
'End section added 5/23/96 by Steve Harmon


  L$ = "DEFINT A-Z:DIM SHARED K,S,B&,Z&:V1 'Created by PostIt! 7.3"
  GOSUB PutLine
RETURN
'----------------------------------------------------------
PrintDecodeTrailer:
  L$ = "CLOSE:IF S=" + LTRIM$(STR$(CheckSum%))
  L$ = L$ + "AND B&=Z&THEN?" + q$ + " :) Ok!" + q$ + "ELSE?" + q$ + " " + "" + ":( Bad!"
  GOSUB PutLine
  L$ = "SUB U(A$):FOR A=1TO LEN(A$):C=ASC(MID$(A$,A))-37:IF C<0THEN" + " C=91+C*32"
  GOSUB PutLine
  L$ = "IF K<4THEN K=C+243ELSE?#1,CHR$(C+(K MOD 3)*86);:K=K\3:B&=B&+1"
  GOSUB PutLine
  L$ = "S=(S+C)AND 255:NEXT:LOCATE,1:?STRING$(B&*50\Z&,219);:END SUB"
  GOSUB PutLine
RETURN
END FUNCTION

'This self containted subroutine for splitting QB lines was made by
'Victor Yiu and a few other folks on the QUIK_BAS echo.
SUB ExpandLine (a$, Lines$(), LineLength%, NumLines%)
  NumLines% = 0
  'check to see if the line has already been split
  FOR I% = LEN(a$) TO 1 STEP -1
    SELECT CASE MID$(a$, I%, 1)
    CASE "_": NoSplit% = true
    CASE " "
    CASE ELSE: EXIT FOR
    END SELECT
  NEXT
  DO WHILE NoSplit% = false AND LEN(a$) > LineLength%
    'locate a place to split the line
    WrapPoint% = 0
    FOR I% = LineLength% TO LineLength% - 20 STEP -1
      SELECT CASE MID$(a$, I%, 1)
      CASE " ", ".", ",", ":", ";": WrapPoint% = I%: EXIT FOR
      END SELECT
    NEXT
    IF WrapPoint% = 0 THEN WrapPoint% = LineLength%
    'avoid wrapping on quote chars
    IF MID$(a$, WrapPoint% - 1, 1) = CHR$(34) THEN WrapPoint% = WrapPoint% - 1
    InQuote% = false: HasComment% = false
    'check to see if the line contains a remark
    FOR I% = 1 TO WrapPoint% - 1
      q$ = MID$(a$, I%, 1)
      IF q$ = CHR$(34) THEN
        InQuote% = NOT InQuote%
      ELSEIF InQuote% = false THEN
        IF q$ = "'" OR UCASE$(MID$(a$, I%, 4)) = "REM " THEN
          HasComment% = true: EXIT FOR
        END IF
      END IF
    NEXT
    NumLines% = NumLines% + 1
    IF InQuote% THEN
      Lines$(NumLines%) = LEFT$(a$, WrapPoint% - 1) + CHR$(34) + "+_"
    ELSE
      Lines$(NumLines%) = LEFT$(a$, WrapPoint% - 1) + "_"
    END IF
    a$ = MID$(a$, WrapPoint%)
    IF HasComment% THEN
      a$ = "'" + a$
    ELSEIF InQuote% THEN
      a$ = CHR$(34) + a$
    END IF
  LOOP
  NumLines% = NumLines% + 1: Lines$(NumLines%) = a$
END SUB

FUNCTION FASC% (a$)
  IF LEN(a$) = 0 THEN FASC% = -1 ELSE FASC% = ASC(a$)
END FUNCTION

FUNCTION GrabNum& (a$, Lower&, Upper&, Default&)
  FOR I% = 1 TO LEN(a$)
    q$ = MID$(a$, I%, 1): IF (q$ < "0" OR q$ > "9") THEN EXIT FOR
    J& = J& * 10& + ASC(q$) - 48
    IF J& > Upper& THEN GrabNum& = Default&: EXIT FUNCTION
  NEXT
  GrabNum& = J&: IF LEN(a$) = 0 OR J& < Lower& OR J& > Upper& THEN GrabNum& = Default&
END FUNCTION

SUB IIParse (cmd$, toname$, fromname$, conference%, BBSID$)
  ' this short sub parses cmd$ and returns values for use with ImportIt!
  FOR n = 1 TO LEN(cmd$)
    IF MID$(cmd$, n, 4) = " -Q " THEN
      qLoc = n + 4
    END IF
  NEXT n
  FOR n = qLoc TO LEN(cmd$)
    IF MID$(cmd$, n, 3) = "TO:" THEN
      toname$ = LTRIM$(RTRIM$(MID$(cmd$, n + 3, INSTR(n, cmd$, "FROM:") - (n + 3))))
    ELSEIF MID$(cmd$, n, 5) = "FROM:" THEN
      fromname$ = LTRIM$(RTRIM$(MID$(cmd$, n + 5, INSTR(n, cmd$, "CONF" + ":") - (n + 5))))
    ELSEIF MID$(cmd$, n, 5) = "CONF:" THEN
      conference% = VAL(LTRIM$(RTRIM$(MID$(cmd$, n + 5, INSTR(n, cmd$, "BBSID:") - (n + 5)))))
    ELSEIF MID$(cmd$, n, 6) = "BBSID:" THEN
      BBSID$ = LTRIM$(RTRIM$(LTRIM$(RTRIM$(MID$(cmd$, n + 6)))))
    END IF
  NEXT n
END SUB

SUB ImportIt (BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference)
  PRINT
  PRINT "ImportIt! v1.0"; CHR$(225); " QuickBASIC Compatable QWK format" + " file importer."
  PRINT "For use with PostIt! QuickBASIC Compatable Encoder/Decoder."
  PRINT "Public Domain by Calvin French, August 1993"
  PRINT
  PRINT "Adding encoded files to reply packet (.REP file)"
  AddToRep BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference, ErrorCode$
  PRINT
  PRINT "Status returned: "; ErrorCode$
  IF ErrorCode$ = "Reply packet (.REP file) not found!" THEN
    ArcMethod$ = PreferredArchiveMethod$
    SELECT CASE ArcMethod$
      CASE "ARJ"
        ArcCommand$ = "ARJ A"
      CASE "LHA"
        ArcCommand$ = "LHA A"
      CASE "ZIP"
        ArcCommand$ = "PKZIP"
    END SELECT
    CreateRep BBSID$, ArcCommand$
    AddToRep BBSID$, MsgFiles$(), toname$, fromname$, TitleFile$, conference, ErrorCode$
    PRINT "Status returned: "; ErrorCode$
    PRINT
  END IF
END SUB

'This parsing sub does NOT mistake filenames like "F-14G.ZIP" as
'containing a switch. That's why it looks so big.
SUB ParseCmdLine (cmd$, Params$(), Found%)
  Found% = 0: Sep$ = "-/": Temp$ = LTRIM$(RTRIM$(cmd$)): InParam% = 0
  FOR p% = 1 TO LEN(Temp$)
    C$ = MID$(Temp$, p%, 1)
    IF InParam% = -1 THEN 'Inside of a switch?
      IF INSTR(Sep$, C$) THEN 'Found another switch?
        'Terminate current switch, then start parsing the next one.
        GOSUB MakeParam: MID$(Temp$, p%, 1) = LEFT$(Sep$, 1)
        ParamStart% = p%
      ELSEIF ASC(C$) = 32 OR ASC(C$) = 9 THEN
        GOSUB MakeParam: InParam% = 0 'Terminate current switch.
      END IF
    ELSEIF InParam% = -2 THEN 'Inside of a parameter?
      IF ASC(C$) = 32 OR ASC(C$) = 9 THEN 'Terminate parameter with
        GOSUB MakeParam: InParam% = 0     'space or TAB.
      END IF
    ELSE
      IF INSTR(Sep$, C$) THEN 'Found start of a switch?
        'Make sure all switches start with "-".
        MID$(Temp$, p%, 1) = LEFT$(Sep$, 1): InParam% = -1
        ParamStart% = p%
      ELSEIF ASC(C$) <> 32 AND ASC(C$) <> 9 THEN 'If char isn't a
        InParam% = -2: ParamStart% = p% 'space or TAB it's a parameter.
      END IF
    END IF
  NEXT
 IF InParam% THEN GOSUB MakeParam
  EXIT SUB
MakeParam:
  Found% = Found% + 1
  Params$(Found%) = MID$(Temp$, ParamStart%, p% - ParamStart%)
  IF Found% = UBOUND(Params$) THEN EXIT SUB
RETURN
END SUB

SUB SepPath (a$, Drive$, path$, tName$)
  FOR I% = LEN(a$) TO 1 STEP -1
    IF INSTR("\:", MID$(a$, I%, 1)) THEN EXIT FOR
  NEXT
  IF I% > 0 THEN
    path$ = UCASE$(MID$(a$, 1, I%)): tName$ = UCASE$(MID$(a$, I% + 1))
  ELSE
    path$ = "": tName$ = UCASE$(a$)
  END IF
  Temp% = INSTR(path$, ":"): Drive$ = ""
  IF Temp% THEN Drive$ = LEFT$(path$, Temp%): path$ = MID$(path$, Temp% + 1)
END SUB

FUNCTION UnTab$ (b$, TabStops%)
  a$ = b$: T% = INSTR(a$, CHR$(9))
  IF T% THEN
    DO: Temp% = (T% - 1) MOD TabStops%
    a$ = LEFT$(a$, T% - 1) + SPACE$(TabStops% - Temp%) + MID$(a$, T% + 1)
    T% = INSTR(T%, a$, CHR$(9)): LOOP WHILE T%
  END IF
  UnTab$ = a$
END FUNCTION '(last subroutine)
<PAGEEND:"Post.It.File1">

<PAGESTART:"Publish.Shareware.File">
-----------------------------------------------------------------------------
How To Publish Your Programs:-
-----------------------------------------------------------------------------
Contact James MacLean <James_MacLean@zd.com>, who is incharge. His company's
web page is ---> http://www.zdnet.com
-----------------------------------------------------------------------------
He will distribute your programs (as long as they are good) to

1) America on Line
2) Compuserve
3) The ZDNet WWW site.

   They are among the "Top 25"  WWW sites in the world.

(99% of the shareware authors make little or no money. You will never get
 rich selling retail. Selling wholesale is where all the money is. Think of
 a program that a business would want to buy.)

Here are the steps:

1) They have an "Author Upload Center" BBS.

 Toll free number (Free for you? I have no idea.) --->1-800-426-3425.

2) You can attach your program to an e-mail and send it to me
   (James_MacLean@zd.com).

 We use "MIME" to decode and our gateway has an attachment limit, that is
 less than 3 megs..

3) We then send the programs to our virtual reviewers.

4) When we get the program back, it is uploaded to all three services.

* Your program must contain a "read me" file with certain information.

A) The program title

B) Version number

C) Author information

D) Operating System the program runs on

E) Is the program, Freeware or Shareware

F) Keywords

G) Description of the program

That's about it
-----------------------------------------------------------------------------
For more information contact James MacLean at <James_MacLean@zd.com>, who is
a very friendly guy :-). His company's web page is ---> http://www.zdnet.com
-----------------------------------------------------------------------------
<PAGEEND:"Publish.Shareware.File">

<PAGESTART:"Interrupt.Page.File1">
 =================================
[     QuickBasic 4.5 Tutorial     ]
[      How To Use Interrupts      ]
[ Copyright (c) 1996 by Tika Carr ]
 =================================
(Please read disclaimer at the end of this tutorial.)

This tutorial hopes to cover the basics of how to use Interrupts in
QuickBasic. Note that this method only works in QuickBasic 4.5. I hope
to do a tutorial for those who use QBasic (which comes with MS-DOS 5.0
and higher).

1. Getting Started

You will need to have started QuickBasic 4.5 by typing the following
at the MS-DOS prompt:

QB /L QB.QLB

This QuickLiBrary will load in what you need to use interrupts.

Many new programmers avoid using interrupts because they are afraid to
damage their computer. I've noticed people mess up their system
*without* using interrupts. Sections 7 - 9 have some tips on safe
debugging and what to do if you have a crash. Further,  BACK UP YOUR
HARD DRIVES! This is MOST important! And save your programs onto
floppy diskette before you run them. Ultimately, its still up to you
to protect your system. This goes for any type of programming.

2. Your First Interrupt

Type in the following and save it, then run it. We'll look at the
program and see how it all works in a moment.

=======>8 Snip 8<=======

'Example Program for CALL INTERRUPT Tutorial
'by Tika Carr

'$INCLUDE: 'QB.BI'

DIM Inregs AS RegType, Outregs AS RegType

'Int 10h (interrupt 10 hexidecimal) controls the video part.
'0Ah tells the computer to write a character on the screen.
'We'll put the letter 'A' on the screen in this example.

CLS

Inregs.ax = &HA41  'load high and low bytes into ax register (&H0A01)
Inregs.cx = 1      'write only 1 character

CALL INTERRUPT(&H10, Inregs, Outregs) 'put the character on the screen

=======>8 Snip 8<=======

'$INCLUDE: 'QB.BI' defines the type structures used for the
interrupts.

DIM Inregs AS RegType, Outregs AS RegType

The INCLUDE statement defines the type structures that is used for
interrupts. These are found in the QB.BI file that comes with
QuickBasic 4.5. The DIM Statement lets you specify what variable to
put the registers defined in RegType in, so that its easy to pass all
the registers to the interrupt.

3. What are registeres and what do they do?

A register is a place where you store values, and is a more direct way
to communicate with the computer. The computer looks into registers
for specific values, and uses them to perform different tasks. For
example, we gave the computer some information in the AX register,
telling it we wanted to write something on the screen, and what we
wanted to write to the screen (the letter 'A'). We also put a value
into the CX register, telling the computer we wanted to write only one
copy of the letter 'A'. When you call an interrupt, you send all that
information along to the computer (int 10h, which accesses your
video). Basically, we just told the computer to PRINT "A" on the
screen. Registers also let the computer send information back to your
program. For example, INT 33 can give your program the X and Y
coordinates of where the mouse currently is located.

For CALL INTERRUPT: ax, bx, cx, dx, bp, si, di, flags
Defined as RegType

FOR CALL INTERRUPTX: ax, bx, cx, dx, bp, si, di, flags, ds, es
Defined as RegTypeX

Depending on the interrupt you want to use, you will need to pick the
type of call that suits it. For instance, if you don't use the es
register, then using CALL INTERRUPT would work fine. However, if the
computer will be looking into the es register for something, or if you
will need to know what is in the ds register, you will want to use the
CALL INTERRUPTX.

These definitions are all in the QB.BI file. You '$INCLUDE: 'QB.BI' in
your program, then you DIM Inregs AS RegyType, OutRegs AS RegType.
These will set up your variables so that you can access the registers.

To put something into the registers, you use Inregs, and to read the
registers, you use the OutRegs variable:

Inregs.ax  is where you would put something in the AX register.
Outregs.cx is where you can find what the computer put in the CX
           register.

4. Storing Values into Registers:

Since the registers take information in bytes only, you may have to do
some converting to load the registers properly. Many times an
interrupt listing will show something like:

Interrupt 10h: Video
        Entry: ah = 0A write a character to the screen
               al = value of character to write
               bh = video page
               bl = attribute or color of character
               cx = number of times to write the character

This can seem confusing. How do you load the AX register? Where IS it?
There's an AH and an AL. These mean the High and Low bytes of the AX
register, respectively. Here's how you would put a value into the AX
register:

Inregs.ax = &HA41  'load high and low bytes into ax register (&H0A01)

(Note that QuickBasic likes to take away the leading 0s. Initially, we
typed it as: Inregs.ax = &H0A41)

The values go into the registers as:  0A41
                                      HiLo

Most of the time, you probably will run into this situation:

Video$ = "0A"              ' Tell computer to write to video
Character$ = "A"           ' Character to write on screen

Here is how you would get it all into one register:

Character$ = HEX$(ASC(A))  ' Convert 'A' into its ASCII value in
                           ' Hexidecimal.

Since Video$ already is in Hexidecimal, we won't need to change it.
Now, we put them together:

AX$ = Video$ + Character$      ' AX$ now contains 0A41 PRINT AX$ to
                                ' see for yourself.

Now that we got the full hexidecimal value to put into the AX
register, we still have to convert this into a *number*:

Inregs.ax = VAL("&H" + AX$)

This makes the string now say "&H0A41" and it also converts it into a
numeric value (using VAL). Now you have the high and low bytes
converted and stored into the AX register that will go into the
computer (Inregs). When you do the CALL INTERRUPT (&H10, Inregs,
Outregs), the values will be correctly loaded where the computer can
find them.

5. Reading the Registers

Outregs also holds register values. After you make a CALL INTERRUPT,
you can read, let's say, the high and low bytes of the BX register and
use it in your own program:

BX$ = HEX$(Outregs.bx)      ' Convert the value to hexidecimal, its
                            ' easier to extract the high and low bytes
                            ' this way.

Since the computer likes to truncate leading 0s, we have to convert
the value of BX$:

' Get Low and High Byte of BX
' BH$ is the high byte, BL$ is the low byte, both in Hexidecimal.

L = LEN(BX$)
IF L = 1 THEN BH$ = "0" + BX$: BL$ = "00"
IF L = 2 THEN BH$ = LEFT$(BX$, 2): BL$ = "00"
IF L = 3 THEN BH$ = "0" + LEFT$(BX$, 1): BL$ = RIGHT$(BX$, 2)
IF L = 4 THEN BH$ = LEFT$(BX$, 1): BL$ = RIGHT$(BX$, 2)

bh = VAL("&H" + BH$)        ' Decimal Value of high byte of BX
bl = VAL("&H" + BL$)        ' Decimal Value of low byte of BX

Note that this is only applicable for any register you need to get
specifically the low and high bytes of. Sometimes a register is a
pointer to a memory address. If that is the case, you can just use
that value directly, without any type of conversion. For example:

Address = Outregs.es
Value = Outregs.dx
POKE Address, Value
' Or do whatever you need to with the address returned.

6. Calling the Interrupt

When you do a CALL INTERRUPT you access a certain function within the
computer. For example, in CALL INTERRUPT(&H10, Inregs, Outregs) you
called the video interrupt 10h (&H10). Its best of course, to know
what interrupt does what, what to put into the registers, and what the
registers may return to your program that you may be able to use. The
best Interrupt source I've found is Ralph Brown's Interrupt List,
found on some programming BBSs and on the internet on different FTP
sites (like Oakland, SimTel, and Garbo, which you can get current
addresses for by searching Lycos at http://lycos.cs.cmu.edu)

7. What To Do About Crashes

a) BACKUP YOUR PROGRAMS BEFORE RUNNING THEM!
First and foremost, its good practice to save your program onto a
floppy diskette before you run it. When your system crashes and you
get back in, just reload the program into QuickBasic.

b) System Crashes
If your system crashes, or seems to hang, first try hitting CTRL-C or
CTRL-Pause (which is also CTRL-Break). You may have to hit ENTER
afterward to get back to the QuickBasic Interactive Debugging Editor
(IDE) to look at your program. If this don't work, reboot the computer
with CTRL-ALT-DEL (or hit the RESET button on the computer if that
didn't work). Then reload and take a look at your program. If worse
comes to worse, you can shut off the computer, wait a few moments and
turn it back on. Personally, I have always been able to recover by
breaking out of the program with CTRL-Break.

c) Disk FAT crashes
This is one situation that could occur if you are using interrupts to
access the disk drives or hard disk, and you didn't get things loaded
in right. Best to have your hard drive backed up before each
programming session if you know you'll be using interrupts that will
access the disk drives (ie. may have potential of writing to sectors
or the FAT). Another good thing to have on hand is some utilities that
repair damaged FAT tables and such. There are a number of good
commercial programs out there, and some shareware ones as well. Put
one of these on a bootable floppy.

d) Video, Sound and other hardware
Its rare that you can actually damage hardware with an interupt call.
If something goes "haywire" the best bet is to just hit the reset
button on the PC right away. Usually, things will then reset and
recover.

8. Safe Debugging

Once you get your program written, put a remark before the CALL
INTERRUPT:

'CALL INTERRUPT (&H10, Inregs, Outregs)

Then set up the Debug to watch your variables:

HEX$(Inregs.ax)
HEX$(Outresg.bx)

Or whatever variables you are working with. Then ALT-R R to restart.
NOW SAVE THE PROGRAM TO FLOPPY DISK! Remove the disk from the drive.
Hit F8 to step through your program one instruction at a time, paying
close attention to the values in the variables. Are they loading
properly? Once you think its working, you can again save the program
and then remove the remark from the call. Step through again and pay
attention to the Outregs registers if you are using them.

It may seem like a lot to go through, but watching how your program
works step by step, especially if you're first learning to use
interrupts, will show you how the computer uses them, and how your
programs behave (for better or for worse).

9. In Closing....

Interrupts are a great way to do things in QuickBasic that you can't
find a command for. Normally, they don't hurt anything and at worse,
just make you have to restart the computer. While a risk is there to
mess up things like hard drives, its rare you'll run into that, if at
all, as long as you don't use disk interrupts until you are
comfortable with how interrupts work and how to use them. Stick with
writing for video, mouse, printer, sound card for starters. Video is
easiest, as is the mouse. And if wierd things happen, don't panic -
reset. :)

                    ******* DISCLAIMER *******

The author of this article cannot garantee the usability or
suitability of the inforamtion presented herein for any particular
purpose. In addition, the user of the information in this article
agrees not to hold the author, moderator or any other direct or
indirect agent liable in any way for any damages, loss of data, or
other consequenses arising from use of this information. While I have
made every conscious effort to ensure the information in this tutorial
is accurate and safe to use on any PC compatible in the QuickBasic 4.5
environment, the end result depends on the person making use of the
intformation presented here. Use the information in this tutorial at
your own risk.

                  ******* CONTACT INFORMATION *******

As of 8/3/96, comments, questions and suggestions, can be directed to:

 FidoNet: Tika Carr 1:2613/601
Internet: kari@rochgte.fidonet.org

=====================================================================
Tika Carr, former staff writer and later editor of GEnieLamp PC
Multimedia Magazine, has been writing QuickBasic 4.5 programs since
1989, and is a frequent contributor to the QUICK_BAS FidoNet Echo. Her
area of specialty is in "tools that make tools" (Steven Levy,
"Hackers"), meaning anything that will make things easier for
programmers to take control of the computer, and make their
imaginations come alive.
=====================================================================
Microsoft, QuickBasic 4.5, and QBasic are trademarks of Microsoft
Corporation. MS-DOS is a registered trademark of Microsoft
Corporation.
<PAGEEND:"Interrupt.Page.File1">

<PAGESTART:"Key.Stuff.File1">
DECLARE SUB KeyInt (AL%)
'
' KEYSTUFF.BAS  by Matt Hart
' Uses Interrupt 16H for various keyboard operations.
'
' The scroll lock, num lock, caps lock, and insert
' key flags remain ON until pressed again, thus the need for
' the ?Flag variables in this demo program.
'
'
    DEFINT A-Z
    TYPE RegTypeX
        AX    AS INTEGER
        bx    AS INTEGER
        cx    AS INTEGER
        dx    AS INTEGER
        bp    AS INTEGER
        si    AS INTEGER
        di    AS INTEGER
        flags AS INTEGER
        ds    AS INTEGER
        es    AS INTEGER
    END TYPE
    DECLARE FUNCTION RShift ()
    DECLARE FUNCTION LShift ()
    DECLARE FUNCTION CtrlKey ()
    DECLARE FUNCTION AltKey ()
    DECLARE FUNCTION ScrollLock ()
    DECLARE FUNCTION NumLock ()
    DECLARE FUNCTION CapsLock ()
    DECLARE FUNCTION InsertKey ()
    SFlag = 0: NFlag = 0: CFlag = 0: IFlag = 0
    DO
        IF RShift THEN PRINT "Right Shift Key"
        IF LShift THEN PRINT "Left Shift Key"
        IF CtrlKey THEN PRINT "Control Key"
        IF AltKey THEN PRINT "Alt Key"
        IF ScrollLock AND NOT SFlag THEN
            PRINT "Scroll Lock Enabled"
            SFlag = NOT SFlag
        ELSEIF NOT ScrollLock AND SFlag THEN
            PRINT "Scroll Lock Disabled"
            SFlag = NOT SFlag
        END IF
        IF NumLock AND NOT NFlag THEN
            PRINT "Num Lock Enabled"
            NFlag = NOT NFlag
        ELSEIF NOT NumLock AND NFlag THEN
            PRINT "Num Lock Disabled"
            NFlag = NOT NFlag
        END IF
        IF CapsLock AND NOT CFlag THEN
            PRINT "Caps Lock Enabled"
            CFlag = NOT CFlag
        ELSEIF NOT CapsLock AND CFlag THEN
            PRINT "Caps Lock Disabled"
            CFlag = NOT CFlag
        END IF
        IF (InsertKey AND NOT IFlag) OR (NOT InsertKey AND IFlag) THEN
            PRINT "Insert Key Toggled"
            IFlag = NOT IFlag
        END IF
    LOOP UNTIL INKEY$ = CHR$(27)
    END

FUNCTION AltKey
    CALL KeyInt(AL): AltKey = (AL AND 8) = 8
END FUNCTION

'
FUNCTION CapsLock
    CALL KeyInt(AL): CapsLock = (AL AND 64) = 64
END FUNCTION

'
FUNCTION CtrlKey
    CALL KeyInt(AL): CtrlKey = (AL AND 4) = 4
END FUNCTION

'
FUNCTION InsertKey
    CALL KeyInt(AL): InsertKey = (AL AND 128) = 128
END FUNCTION

'
SUB KeyInt (AL)
    DIM InRegs AS RegTypeX
    DIM OutRegs AS RegTypeX
    InRegs.AX = &H200
    CALL InterruptX(&H16, InRegs, OutRegs)
    AL = OutRegs.AX MOD 256
END SUB

'
FUNCTION LShift
    CALL KeyInt(AL): LShift = (AL AND 2) = 2
END FUNCTION

'
FUNCTION NumLock
    CALL KeyInt(AL): NumLock = (AL AND 32) = 32
END FUNCTION

'
FUNCTION RShift
    CALL KeyInt(AL): RShift = (AL AND 1) = 1
END FUNCTION

'
FUNCTION ScrollLock
    CALL KeyInt(AL): ScrollLock = (AL AND 16) = 16
END FUNCTION
<PAGEEND:"Key.Stuff.File1">

<PAGESTART:"Com.Exchange.File1">
'Port Addresses: COM1  --  03F8h
'                COM2  --  02F8h
'                COM3  --  03E8h
'                COM4  --  02E8h

'EXAMPLE: Accessing COM3

   DEF SEG = 64       'move QuickBASIC segment pointer to BIOS data area
   POKE &H0, &HE8     'change com1: address in BIOS data area to com3:
   DEF SEG            'return to QB's DGROUP

   'open com3: by issuing open "com1:" command

   OPEN "COM1:9600,N,8,1" FOR OUTPUT AS #1


   PRINT #1, "ATDT555-5555"  'print to comm port
        
   CLOSE #1           'close comm port

   DEF SEG = 64       'point to BIOS data area
   POKE &H0, &HF8     'restore "com1:" address in BIOS data area to com1:
   DEF SEG            'return to DGROUP


'EXAMPLE: Accessing COM4

   DEF SEG = 64       'move QuickBASIC segment pointer to BIOS data area
   POKE &H2, &HE8     'change com2: address in BIOS data area to com4:
   DEF SEG            'return to DGROUP

'open com4: by issuing open com2: command

   OPEN "COM2:9600,N,8,1" FOR OUTPUT AS #1


   PRINT #1, "ATDT555-5555"  'print to comm port

   CLOSE #1           'close comm port

   DEF SEG = 64       'point to BIOS data area
   POKE &H2, &HF8     'restore com2: address in BIOS data area to com2:
   DEF SEG            'return to DGROUP
<PAGEEND:"Com.Exchange.File1">

<PAGESTART:"Xmodem.Transfer.File1">
'  +-------------------------------------------------------------------+
'  |                                                                   |
'  |   XMODEM.BAS                                Author: Bryan Leggo   |
'  |                                                                   |
'  |   Original XModem, XModem-CRC, and XModem-1K Transfer Protocols   |
'  |                                                                   |
'  |   Uses standard QuickLibrary for "FileExists" function. Use /L    |
'  |   for QB.QLB in environment or the .LIB while compiling.          |
'  |                                                                   |
'  +-------------------------------------------------------------------+

DECLARE FUNCTION CalcCheckSum% (Blk$)
DECLARE FUNCTION CalcCRC& (X$, CRCHigh%, CRCLow%)
DECLARE FUNCTION FileExists% (T$, Attrib%)
DECLARE FUNCTION NoCarrier% ()
DECLARE FUNCTION TimedGet$ (Limit&, Cancelled%)
DECLARE FUNCTION Warn$ (Message$)
DECLARE SUB ClrLn (Ln%, Spaces%)
DECLARE SUB OpenCom (ComChan%, Param$)
DECLARE SUB PurgeBuffer ()
DECLARE SUB ReceiveXModem (BlkSize%, F$)
DECLARE SUB SendXModem (BlkSize%, F$)
DECLARE SUB SimpleTerminal ()
DECLARE SUB Txt (Side$, T$)
DECLARE SUB Transfer (WhichWay$)
DECLARE SUB VidBar (BarOn%, Col%, Length%)

TYPE RegTypeX                                   'Register Type for
   ax    AS INTEGER                             ' Interrupt Calls
   bx    AS INTEGER
   cx    AS INTEGER                             'AX = AH AL
   dx    AS INTEGER                             'BX = BH BL, etc.
   bp    AS INTEGER
   si    AS INTEGER
   di    AS INTEGER
   Flags AS INTEGER
   ds    AS INTEGER
   es    AS INTEGER
END TYPE

CONST TRUE = -1, FALSE = 0                      'Boolean Constants

DEFINT A-Z

DIM SHARED CR$, LF$, BS$, Escape$               'Global String Constants
DIM SHARED Lft$, Rght$, Up$, Down$
DIM SHARED PgUp$, PgDown$
DIM SHARED XOn$, XOff$
DIM SHARED Ack$, Nak$, Soh$, Stx$, Eot$, Can$   'Protocol Pseudo-Constants
DIM SHARED ComBase, Baud&
DIM SHARED Txt1st, TxtMax                       'Used by Txt Sub
DIM SHARED Kolor, BGKolor                       'Screen Colors
DIM SHARED ErrCode, ErrCt                       'Error Number & Count

'===========================================================================
'                  I N I T I A L I Z E     V A R I A B L E S
'===========================================================================

CR$ = CHR$(13): LF$ = CHR$(10): BS$ = CHR$(8): Escape$ = CHR$(27)
Up$ = CHR$(0) + CHR$(72): Down$ = CHR$(0) + CHR$(80)
Lft$ = CHR$(0) + CHR$(75): Rght$ = CHR$(0) + CHR$(77)
PgUp$ = CHR$(0) + CHR$(73): PgDown$ = CHR$(0) + CHR$(81)
XOn$ = CHR$(17): XOff$ = CHR$(19): Ack$ = CHR$(6): Nak$ = CHR$(21)
Soh$ = CHR$(1): Stx$ = CHR$(2): Eot$ = CHR$(4): Can$ = CHR$(24)

Baud& = 2400                                       'Set the BaudRate
Param$ = STR$(Baud&) + ",N,8,1,RS,OP,CD0,DS0"      ' and Com Parameters


'===========================================================================
'                         M A I N     P R O G R A M
'===========================================================================

OpenCom 1, Param$                               'Open Port 1 with Parameters$
SimpleTerminal                                  'Terminal Mode
END


'***************************************************************************
'                        E R R O R     H A N D L E R
'***************************************************************************

Handler:
ErrCode = ERR                               'Copy Err # to Global Var
ErrCt = ErrCt + 1                           'Try Statement Causing the Error
IF ErrCt MOD 3 = 0 THEN                     ' Twice Before Giving Up and
   RESUME NEXT: ErrCt = 0                   ' Going to the Next Statement
ELSE
   RESUME
END IF

FUNCTION CalcCheckSum (Blk$)                'Returns CheckSum on Blk$

C& = 0                                      'Use Long Int to Avoid Overflow
FOR Q = 1 TO LEN(Blk$)
   C& = C& + ASC(MID$(Blk$, Q, 1))          'Add to Add Bits of Each Byte
NEXT Q
C& = (C& AND 255)                           'AND Out Hi Byte Bits
CalcCheckSum = C&
END FUNCTION

FUNCTION CalcCRC& (B$, CRCHigh%, CRCLow%)      'Calculates CRC for Each Block

DIM Power(0 TO 7)                              'For the 8 Powers of 2
DIM CRC AS LONG

FOR I = 0 TO 7                                 'Calculate Once Per Block to
   Power(I) = 2 ^ I                            ' Increase Speed Within FOR J
NEXT I                                         ' Loop
CRC = 0                                        'Reset for Each Text Block
FOR I = 1 TO LEN(B$)                           'Calculate for Length of Block
   ByteVal = ASC(MID$(B$, I, 1))
   FOR J = 7 TO 0 STEP -1
      TestBit = ((CRC AND 32768) = 32768) XOR ((ByteVal AND Power(J)) = Power(JCRC = ((CRC AND 32767&) * 2&)))
      IF TestBit THEN CRC = CRC XOR &H1021&     ' <-- This for 16 Bit CRC
      '*** IF TestBit THEN CRC = CRC XOR &H8005&     ' <-- This for 32 Bit CRC
   NEXT J
NEXT I
CRCHigh% = (CRC \ 256)                          'Break Word Down into Bytes
CRCLow% = (CRC MOD 256)                         ' for Comparison Later
ComputeCRC& = CRC                               'Return the Word Value
END FUNCTION

REM $DYNAMIC
SUB ClrLn (Ln, Spaces)                       'Clears Line from Left Side
LOCATE Ln, 1, 0: PRINT SPACE$(Spaces);       ' for Number of Designated
LOCATE Ln, 1                                 ' Spaces. Returns Cursor to
END SUB                                      ' to First Column Afterwards

FUNCTION FileExists (T$, Attrib)     'True if File T$ Exists else False

DIM F AS STRING * 64
DIM Inx AS RegTypeX
DIM Outx AS RegTypeX

Inx.ax = &H2F00                      'Function 2FH Gets the DTA Address in
CALL INTERRUPTX(&H21, Inx, Outx)     ' ES:BX
DTASeg = Outx.es
DTAAddr = Outx.bx
F$ = LTRIM$(RTRIM$(UCASE$(T$))) + CHR$(0)

Inx.ds = VARSEG(F$)                  'Pass the File Specs by Giving Address
Inx.dx = VARPTR(F$)                  ' of String that Contains Specification
Inx.ax = &H4E00                      'Function 4EH for Find 1st Matching Entry
Inx.cx = Attrib                      'CX = Directory Attribute (0=Files Only)
CALL INTERRUPTX(&H21, Inx, Outx)     'Use Interrupt 21H
IF Outx.Flags AND 1 THEN
   FileExists = FALSE
ELSE
   FileExists = TRUE
END IF

END FUNCTION

FUNCTION NoCarrier

DEF SEG = &H40
IF (INP(ComBase + 6) AND 128) = 0 THEN NoCarrier = TRUE ELSE NoCarrier = FALSE
DEF SEG

END FUNCTION

REM $STATIC
SUB OpenCom (ComChan, Param$)

CLOSE 1
SELECT CASE ComChan                   'Will Require Swapping at &H400, &H402
CASE 1                                ' Order to Support Com 3 and 4
   ComBase = &H3F8
   OPEN "R", 1, "COM1:" + Param$
CASE 2
   ComBase = &H2F8
   OPEN "R", 1, "COM2:" + Param$
END SELECT

END SUB

SUB PurgeBuffer                                    'Clear Comm Line of Chars

Mark& = TIMER                                      'Mark Starting Time
DO
   IF NOT EOF(1) THEN                              'Get More Chars While Some
      JunkIt$ = INPUT$(1, 1): Mark& = TIMER        ' In the Buffer and it's
   END IF                                          ' Less Than 1/2 Second
LOOP UNTIL EOF(1) AND (ABS(TIMER - Mark&) > .5)    ' Since Last Char Gotten
END SUB

SUB ReceiveXModem (BlkSize, F$)                 '(Block Size and Filename)
DIM B$(1 TO 4)                                  'Temp Storage of Block Bytes

CLOSE 9: OPEN "O", #9, F$                       'Save File to Channel #9
PRINT #1, XOff$; XOn$;
Cancels$ = STRING$(3, Can$)
Underway = FALSE                                'True After 1st Pkt Confirmed
Blocks = 1                                      'Block/Pkt Counter (1-Max)
BlkNum = 1                                      'Packet Block Number (1-255)
Bad = 0                                         'Bad Packets/Error Count
BCt = 0                                         'RAM Block Ptr for B$()
PurgeBuffer                                     'Get Rid of Extra Chars
CrcMode = TRUE: PktSize = BlkSize + 5           'Try CRC Mode First
PRINT #1, "C";                                  'Send "C" to Signal It


GetPacket:                                      'Get Packet of Bytes
'IF NoCarrier THEN ErrType = 13: GOTO ShowErr    'Are We Still Online?
Pkt$ = ""
FOR Tries = 1 TO 10                             'Allow 10 Tries
   W$ = TimedGet$(8, Cancelled)                 'Get Response/1st Char of Pkt
   IF Cancelled THEN ErrType = 11: GOTO ShowErr 'Quit If User Cancelled
   SELECT CASE W$                               '1st Byte Is:
   CASE Soh$: BlkSize = 128: EXIT FOR           'Soh = 128 Byte Block Coming
   CASE Stx$: BlkSize = 1024: EXIT FOR          'Stx = 1K Block Coming
   CASE Eot$: GOTO ReceptionDone                'End of Xmission. Close Out.
   CASE Can$: EXIT FOR                          'Cancelled by Sender
   CASE ""                                      'No Char In Means Timed Out
      Bad = Bad + 1: LOCATE 7, 40
      PRINT "Tries:"; Tries; TAB(80);
   CASE ELSE                                    'Else Didn't Get An Expected
      PurgeBuffer                               ' Response So Purge Characters
   END SELECT
   IF NOT Underway THEN                         'Handshaking Not Complete Yet
      IF Tries < 4 THEN                         ' So Send Out Init Char Again
         CrcMode = TRUE: PRINT #1, "C";         ' Send a "C" to Start CRC or
      ELSE                                      ' a <Nak> for Standard Mode
         CrcMode = FALSE: PRINT #1, Nak$;
      END IF
   END IF
   IF Bad >= 10 THEN                            'Have Reached the Max of 10
      ErrType = 14: PurgeBuffer: GOTO ShowErr   ' Errors from TimeOuts or
   END IF                                       ' Bad Packets so Abort
NEXT Tries
IF CrcMode THEN                                 'Blk Size Determined by <Soh>
   PktSize = BlkSize + 5                        ' or <Stx>, PacketSize by
ELSE                                            ' BlockSize and Type of Check
   PktSize = BlkSize + 4                        ' Used (1 Extra Byte for CRC)
END IF
Pkt$ = W$                                       'We've Got the First Byte
WHILE LEN(Pkt$) <= PktSize - 1                  'Now Get Rest of Packet
   W$ = TimedGet$(4, Cancelled)
   IF Cancelled THEN ErrType = 11: GOTO ShowErr
   IF LEN(W$) THEN                              'If There is a Byte then Add
      Pkt$ = Pkt$ + W$                          ' it to the Packet
      IF LEFT$(Pkt$, 3) = Cancels$ THEN         'Packet Starting with Three
         PRINT #1, Cancels$; Ack$;              ' <Can>s Is a Cancellation So
         ErrType = 12: GOTO ShowErr             ' <Ack>nowledge And Abort
      END IF
   ELSE                                         'Else Null Means We Timed Out
      Bad = Bad + 1
      LOCATE 7, 40: PRINT TAB(80);
      LOCATE 7, 40: PRINT "Character Timeout. Errors:"; Bad;
      GOTO CheckPacket
   END IF
WEND

CheckPacket:                                              'Check Packet Errors
IF LEN(Pkt$) = PktSize THEN                               'If Packet Right Size
  IF BlkNum = ASC(MID$(Pkt$, 2, 1)) + 1 AND (BlkNum XOR 255) = ASC(MID$(Pkt$, ErrType = 7)) THEN GOTO ShowErr                          'Repeated Block #
    ELSEIF BlkNum <> ASC(MID$(Pkt$, 2, 1)) THEN            'Block Counts Don't
      ErrType = 5: GOTO ShowErr                           ' Match. Try New Pkt
    ELSEIF (BlkNum XOR 255) <> ASC(MID$(Pkt$, 3, 1)) THEN  'Block Ct Complement
      ErrType = 6: GOTO ShowErr                           ' Mismatch. Try New
  END IF                                                 ' Packet
  Blk$ = MID$(Pkt$, 4, BlkSize)                          'Else Copy the Block
  IF CrcMode THEN                                        'Do CheckSum or CRC
    J& = CalcCRC&(Blk$, Hi, Low)
    IF Hi <> ASC(MID$(Pkt$, PktSize - 1, 1)) THEN ErrType = 4: GOTO ShowErr
    IF Low <> ASC(MID$(Pkt$, PktSize, 1)) THEN ErrType = 4: GOTO ShowErr
  ELSE
    ChkSum = CalcCheckSum(Blk$)
    IF ChkSum <> ASC(MID$(Pkt$, PktSize, 1)) THEN ErrType = 3: GOTO ShowErr
  END IF
  GOSUB ShowProgress                             'Displays Xfer Status
  BlkNum = 255 AND (BlkNum + 1)                  'Success Thru All CheckPts
  Blocks = Blocks + 1: Bad = 0                   ' so Increment Block Cts
  Underway = TRUE                                ' Mark Handshake Completed
  IF BlkSize = 1024 THEN                         'For Xmodem-1k Write to Disk
    PRINT #9, Blk$;                             ' Immediately
  ELSE
    BCt = BCt + 1: B$(BCt) = Blk$               'Else Save 4 Blocks In RAM
    IF BCt = 4 THEN                             ' Write them to Disk Every
      PRINT #9, B$(1); B$(2); B$(3); B$(4);    ' 4th, i.e. After 512 Bytes
      BCt = 0                                  ' Reset RAM Block Index
    END IF
  END IF                                         'Acknowledge Good Block Read
  PRINT #1, Ack$;                                ' And Go to Get Next Packet
  GOTO GetPacket
IF LEN(Pkt$) < PktSize THEN ErrType = 1: GOTO ShowErr                      'Err and Get New Packet
IF LEN(Pkt$) > PktSize THEN
  ErrType = 2: GOTO ShowErr                      ' And Get New Packet
ELSE                                              'Else an Unexpected Error
  ErrType = 8: GOTO ShowErr                      ' So Warn and Try for New
END IF                                            ' Packet
                                                  ' Last 2 Should NOT Occur

ReceptionDone:
IF BCt <> 0 THEN                                  'If Some Bytes Still In
   FOR I = 1 TO BCt: PRINT #9, B$(I); : NEXT I    ' Memory Then Write Them
END IF                                            ' to Disk
CLOSE 9: PRINT #1, Ack$;                          'Xmit Complete so Close
EXIT SUB                                          ' File and Send Final Ack


'---------------------------------------------------------------------------

ShowErr:
Response$ = Nak$                                  'Send Nak After Most Errors
SELECT CASE ErrType
CASE 1: ErM$ = "Short Block in #" + STR$(Blocks)
CASE 2: ErM$ = "Long Block in #" + STR$(Blocks)
CASE 3: ErM$ = "Checksum Error in #" + STR$(Blocks)
CASE 4: ErM$ = "CRC Error in #" + STR$(Blocks)
CASE 5: ErM$ = "Block # Error in #" + STR$(Blocks)
CASE 6: ErM$ = "Complement Error in #" + STR$(Blocks)
CASE 7: ErM$ = "Block # Repeated in #" + STR$(Blocks - 1): Response$ = Ack$
CASE 8: ErM$ = "Unexpected Error!"
CASE 9:
CASE 10: ErM$ = "Transfer Cancelled"
CASE 11: ErM$ = "Transfer Aborted by User"
CASE 12: ErM$ = "Transfer Aborted by Sender"
CASE 13: ErM$ = "No Carrier"
CASE 14: ErM$ = "Maximum Errors. Transfer Aborted."
END SELECT
LOCATE 7, 40: PRINT TAB(80);                      'Show the ErrorMsg
LOCATE 7, 40: PRINT ErM$;
IF ErrType < 10 THEN                              'ErrType < 10 is Recoverable
   Bad = Bad + 1                                  ' Count One More Error
   PRINT #1, Response$;                           ' Respond Nak (or Ack) and
   Pkt$ = "": GOTO GetPacket                      ' Go to Get Packet Again
ELSE
   J$ = Warn$(ErM$)                               'Notify User of Cancel
   SLEEP 2: PurgeBuffer                           'Get Rid of Remaining Pkt
   PRINT #1, STRING$(5, 24); STRING$(5, 8);       'Send 5 <Can>s & 5 <BS>s
   CLOSE 9: KILL F$                               'ErrType >= 10 is Fatal so
   EXIT SUB                                       ' Kill Off File and Quit
END IF

'---------------------------------------------------------------------------

ShowProgress:                                     'Show Byte Counts & Bar
KBytes = INT(Blocks * (BlkSize / 1024))
LOCATE 5, 40: PRINT "Received #"; Blocks; TAB(60); KBytes; "K Bytes";
IF BarLength = 0 THEN
   LOCATE 9: VidBar FALSE, 1, 80
   FOR K = 1 TO 9
      LOCATE 10, K * 8 - 1
      PRINT LTRIM$(STR$(100 * (KBytes \ 100) + (K * 10))); "K ";
   NEXT K
END IF
BarLength = INT(80 * ((KBytes MOD 100) / 100))
LOCATE 9: VidBar TRUE, 1, BarLength
RETURN



' Block refers to Block of Text from File (128 bytes, 1024 for Xmodem-1K)
' Packet Refers to Block + Extra "Control" Characters, i.e. :

'       XModem: SOH + BlockCt + Complement BlockCt + Block + CheckSum
'    XModemCRC: SOH + BlockCt + Complement BlockCt + Block + CRC (Hi & Low)
'    XModem-1K: STX + BlockCt + Complement BlockCt + Block + CheckSum
' XModemCRC-1K: STX + BlockCt + Complement BlockCt + Block + CRC (Hi & Low)

END SUB

SUB SendXModem (BlkSize, F$)                              '(Bytes, FileName$)

CLOSE 9: OPEN F$ FOR RANDOM AS 9 LEN = 128
FIELD #9, 128 AS BlkOf128$
FiLen& = LOF(9): TtlBlocks = FiLen& \ BlkSize             'Get File Length
IF FiLen& MOD BlkSize > 0 THEN TtlBlocks = TtlBlocks + 1  ' in Bytes & Blocks
LOCATE 3, 40: PRINT "Blocks:"; TtlBlocks; TAB(60);
Seconds = ((TtlBlocks * 6) + FiLen&) \ (Baud& \ 16)
Est$ = STR$(Seconds \ 3600) + STR$(Seconds \ 60) + STR$(Seconds MOD 60)
FOR I = 2 TO LEN(Est$)
   IF MID$(Est$, I, 1) = " " THEN MID$(Est$, I, 1) = ":"
NEXT I
PRINT "Est. Time:"; Est$;

ErM$ = "Transfer Aborted"                        'Generic Msg In Case of Error
Blocks = 0: BlkNum = 0                           'Blocks (1-?), BlkNum (1-255)
EoFile = FALSE: W$ = ""                          'Initialize Block, Byte,
Ct& = 0                                          'To Count Bytes Used & Sent
Bad = 0                                          'Error Counter
PurgeBuffer                                      'Clear the Com Line

DO                                               'Shake Hands with Receiver
   W$ = TimedGet$(20, Cancelled)                 'Get Initial Character

   IF Cancelled THEN GOTO AbortSend              'If User Pressed <Esc>
   SELECT CASE W$
   CASE Can$: GOTO AbortSend                     'Receiver is Cancelling
   CASE Nak$: CrcMode = FALSE: EXIT DO           'Nak for Standard XModem
   CASE "C": CrcMode = TRUE: EXIT DO             'C Indicates XModem-CRC
   END SELECT                                    'Begin After <Nak> or C
LOOP

MakePacket:
IF NoCarrier THEN                                    'Still Online?
   ErM$ = "No Carrier!": GOTO AbortSend
END IF
W$ = "": Blocks = Blocks + 1: Bad = 0                'Advance Block Counter
IF (BlkSize = 1024) AND ((Ct& + 896) > FiLen&) THEN  'If Doing 1k and at End
   BlkSize = 128                                     ' of File Then Shorten
END IF                                               ' to Avoid Extra Nulls
IF BlkSize = 128 THEN MaxBCt = 1 ELSE MaxBCt = 8     '8 Groups of 128 = 1024
BCt = 0: Blk$ = ""                                   'Build the Block$
DO
   Ct& = Ct& + 128: GET #9                           'Advance File Ptr, Get Fro
   BCt = BCt + 1: Blk$ = Blk$ + BlkOf128$
   IF Ct& >= FiLen& THEN                             'If It's Last Block We're
      EoFile = TRUE                                  ' About Done Xmitting
      Pad = Ct& - FiLen&                             ' Pad the End with Nulls
      MID$(Blk$, BlkSize - Pad, Pad) = STRING$(Pad, CHR$(0))
      EXIT DO
   END IF
LOOP UNTIL BCt = MaxBCt                              'Done After 1 (8 for 1k)
BlkNum = (255 AND Blocks)                            ' So Assemble the Packet
Pkt$ = Soh$ + CHR$(BlkNum) + CHR$(BlkNum XOR 255) + Blk$
IF BlkSize = 1024 THEN MID$(Pkt$, 1, 1) = Stx$       '1st Byte is Stx for 1K
IF CrcMode THEN                                      'End of Packet Varies
   J& = CalcCRC&(Blk$, Hi%, Low%)                    ' with Check Method Used
   Pkt$ = Pkt$ + CHR$(Hi%) + CHR$(Low%)              ' 2 Bytes for CRC
ELSE
   ChkSum = CalcCheckSum(Blk$)                       ' 1 Byte for CheckSum
   Pkt$ = Pkt$ + CHR$(ChkSum)
END IF

SendPacket:
PRINT #1, Pkt$;                                      'Send the Packet and
LOCATE 5, 40: PRINT "Sending #"; Blocks;             ' Show Progress on Screen
P = INT((Blocks / TtlBlocks) * 100)                  'Calculate Percentage
IF P <= 100 THEN                                     'Percentage Can Be > 100
   LOCATE 5, 60: PRINT P; "% Complete": LOCATE 9     ' On Last Blocks of 1k
   VidBar TRUE, 1, INT((Blocks / TtlBlocks) * 80)    ' Mode Since Last 1024 is
END IF                                               ' Sent in 128 Byte Blocks

DO                                                   'Packet Has Been Sent so
   W$ = TimedGet$(10, Cancelled)                     'Get Response/Confirm
   IF Cancelled THEN GOTO AbortSend                  'Quit If User <Esc>aped
   SELECT CASE W$                                    'Interpret Response
   CASE Ack$                                         'Block Acknowledged So
      Bad = 0                                        ' Send Next Packet If
      IF EoFile THEN EXIT DO ELSE GOTO MakePacket    ' More Data
   CASE ELSE                                         'Else
      Bad = Bad + 1                                  ' Count 1 More Error
      IF Bad > 9 THEN GOTO AbortSend                 ' Abort If Over Limit
      IF W$ = Can$ THEN                              'If a <Can> Then Look
         FOR I = 1 TO 2                              ' For at Least 2 More to
            W$ = W$ + TimedGet$(2, Cancelled)        ' Be Sure (Or User Esc)
            IF Cancelled THEN GOTO AbortSend
            IF W$ = STRING$(3, Can$) THEN GOTO AbortSend
         NEXT I
         GOTO SendPacket
      ELSE
         PurgeBuffer                                 'Any Other Char Is an
         GOTO SendPacket                             ' Error So ReSend Packet
      END IF                                         ' & Look for <Ack> Again
   END SELECT
LOOP

ConcludeSend:
ErM$ = "End of Transmission": GOSUB ShowStatus       'Proper End of Transmit
CLOSE 9: PRINT #1, Eot$;                             'Close File, Send the EOT
I$ = TimedGet$(10, Cancelled)                        'Get Final Char
IF I$ = Ack$ THEN                                    'Should Be an <Ack> but
   ErM$ = "Acknowledged": GOSUB ShowStatus
ELSEIF Cancelled THEN                                'Allow User to Cancel
   EXIT SUB
ELSE                                                 'If Not an <Ack> Resend
   GOTO ConcludeSend                                 ' <Eot> and Try Again
END IF
EXIT SUB

'---------------------------------------------------------------------------

AbortSend:
J$ = Warn$(ErM$)                                 'Show Error Status
CLOSE 9                                          'Close File
PRINT #1, STRING$(5, Can$); STRING$(5, BS$);     'Send Cancel to Receiver
EXIT SUB

'---------------------------------------------------------------------------

ShowStatus:
LOCATE 7, 40: PRINT ErM$; TAB(80);               'Show the Status or ErrorMsg
RETURN

END SUB

SUB SimpleTerminal
ON ERROR GOTO Handler
FF$ = CHR$(12): Hm$ = CHR$(11)

CLS : GOSUB InfoBar
PRINT #1, "AT S0=1"                       'Send Modem Initialization String
DO
   Out$ = INKEY$                          'Look for Key Press
   'IF LEN(Out$) THEN                      'If There IS One then Select
      SELECT CASE Out$
      CASE PgUp$, PgDown$                 ' to Upload or Download
         Transfer Out$: GOSUB InfoBar
      CASE Escape$                        ' Escape to End Program
         EXIT DO
      CASE CHR$(0) + CHR$(59)
         PRINT #1, "atdt 626-9456"
      CASE ELSE
         PRINT #1, Out$;                  ' Else Send the Character Verbatim
      END SELECT
   'END IF
   IF LOC(1) THEN                         'Is there Incoming Data from Com?
      DO                                  ' If So then Get Chars Until No
         ComChr$ = INPUT$(1, 1)           ' More or End of a Line <LF>
         SELECT CASE ComChr$
         CASE BS$: ComChr$ = CHR$(29)     'Replace BackSpaces with CHR$(29)
         CASE FF$, Hm$: ComChr$ = ""      'Filter these Out
         CASE LF$: ComChr$ = "": EXIT DO  'Ignore Linefeeds But Exit Do Loop
         END SELECT
         PRINT ComChr$;                   'Print the Char Received On Screen
      LOOP UNTIL LOC(1) = 0               'No More Com Waiting
   END IF
LOOP
EXIT SUB

'---------------------------------------------------------------------------

InfoBar:
CLS
LOCATE 24, 1: COLOR 0, 7
PRINT " <PgUp> to Upload,        <PgDown> to Download,         <Escape> to End Program ": COLOR 7, 0: LOCATE 24, 1
RETURN

END SUB

FUNCTION TimedGet$ (Limit&, Cancelled)            'Timed Routine to Get One
                                                  'Character from Comm Port
Mark& = TIMER                                     'Mark Starting Time
DO
   IF NOT EOF(1) THEN                             'If Chars Waiting Then
      TimedGet$ = INPUT$(1, 1): EXIT FUNCTION     ' Return 1 Character
   END IF
   IF INKEY$ = Escape$ THEN                       'User Can Press <Esc> to
      Cancelled = TRUE: EXIT FUNCTION             ' Quit
   END IF
LOOP WHILE ABS(TIMER - Mark&) < Limit&            'Wait Up Until Past Limit
TimedGet$ = ""                                    'Return "" If Timing Out
END FUNCTION

REM $DYNAMIC
SUB Transfer (WhichWay$)                  'WhichWay = PgUp (U/L), PgDn (D/L)
ON ERROR GOTO Handler

NumProtos = 4                             'Number of Protocols Here
SendDir$ = ""                             'Define Directories Where Files Will
RecvDir$ = ""                             ' Be DownLoaded To or Uploaded From
SendExternal$ = ""                        'DOS Command Line Used to Execute
RecvExternal$ = ""                        ' External Protocol (~ for Filename)
Kolor = 0: BGKolor = 7                    'Transfer Area in Reverse Video for
COLOR Kolor, BGKolor                      ' Contrast
VIEW PRINT 1 TO 11: CLS 2: VIEW PRINT     'Clear Top 11 Lines
LOCATE 11, 1: PRINT STRING$(80, "#");

IF WhichWay$ = PgUp$ THEN                 'Determine if Sending or Receiving
   Way$ = "Sending": Sending = TRUE       ' From Key Pressed
ELSE
   Way$ = "Receiving": Sending = FALSE
END IF
DO
   ClrLn 9, 80: PRINT "File You Are "; Way$; ": ";
   F$ = "": LINE INPUT F$
   IF F$ = "" THEN GOTO ExitTransfer
   F$ = UCASE$(F$)
   IF Sending THEN
      IF LEN(SendDir$) THEN
         IF INSTR(F$, ":") = 0 THEN F$ = SendDir$ + "\" + F$
      END IF
      IF FileExists(F$, 0) THEN Ok = TRUE ELSE J$ = Warn$("File Not Found")
   ELSE
      IF LEN(ReceiveDir$) THEN
         IF INSTR(F$, ":") = 0 THEN F$ = ReceiveDir$ + "\" + F$
      END IF
      IF FileExists(F$, 0) THEN
         ClrLn 9, 80
         PRINT F$; " Already Exists! Overwrite it? (Y/N)? ";
         DO: B$ = UCASE$(INKEY$)
         LOOP UNTIL LEN(B$) AND INSTR("YN", B$)
         IF B$ = "Y" THEN Ok = TRUE
      ELSE
         ErrCode = 0: F = FREEFILE
         OPEN "O", F, F$
         IF ErrCode THEN J$ = Warn$("Bad Path/Filename?") ELSE Ok = TRUE
         CLOSE F
      END IF
   END IF
LOOP UNTIL Ok

Txt1st = 1: TxtMax = 30                            'And Draw a Box Around
LOCATE 1, 1
PRINT TAB(40); "Choose a Protocol"; TAB(80);
Txt "T", ""
Txt "C", "       XModem       "
Txt "C", " XModem-1k (YModem) "
Txt "C", " External Protocol  "
Txt "C", "       Cancel       "
Txt "B", ""
R = 1: C = 0
DO
   LOCATE R + 1, 2, 0
   VidBar TRUE, 2, 30
   DO: C$ = INKEY$: LOOP UNTIL LEN(C$)
   VidBar FALSE, 2, 30
   SELECT CASE C$                                      'Based on Terminator:
   CASE Up$: R = R - 1: IF R < 1 THEN R = NumProtos    ' Go to Line Above
   CASE Down$: R = R + 1: IF R > NumProtos THEN R = 1  ' or Line Below
   CASE CR$: EXIT DO
   CASE Escape$: EXIT DO
   END SELECT
LOOP
IF C$ = Escape$ THEN GOTO ExitTransfer                 'Cancelled by User
VidBar TRUE, 2, 30
LOCATE 9, 1: PRINT "+--+---+---+---+---+---+---+---+---+---|---+---+---+---+---+---+---+---+---+---+"
LOCATE 1, 3: PRINT " Press <Escape> to Cancel "
LOCATE 1, 40: PRINT Way$; ": "; UCASE$(F$); TAB(80);
IF Sending THEN
   LOCATE 10, 1: PRINT "0%    10%     20%     30%     40%     50%     60%     70%     80%     90%   100%"
   SELECT CASE R
   CASE 1: SendXModem 128, F$
   CASE 2: SendXModem 1024, F$
   CASE 3: Ext$ = SendExternal$: GOSUB InsertFileName: SHELL Ext$
   CASE 4: GOTO ExitTransfer
   END SELECT
ELSE
   SELECT CASE R
   CASE 1: ReceiveXModem 128, F$
   CASE 2: ReceiveXModem 1024, F$
   CASE 3: Ext$ = RecvExternal$: GOSUB InsertFileName: SHELL Ext$
   CASE 4: GOTO ExitTransfer
   END SELECT
END IF
'PLAY "T90 O3 L32 CBCBCBCBCBCBCBCBCBCBCBCBCBCBCBC"     'All Done Warning Sound

ExitTransfer:
COLOR 7, 0                                            'Back to White on Black
VIEW PRINT 1 TO 11: CLS 2: VIEW PRINT                 'Clear Top 11 Lines
VIEW PRINT 1 TO 24: LOCATE 24, 1, 1
EXIT SUB

'----------------------------------------------------------------------------

InsertFileName:                    'Substitute FileName for ~ in Strings Used
P = INSTR(Ext$, "~")               ' to Call External Protocol (Send or Recv)
IF P > 1 THEN
   Ext$ = LEFT$(Ext$, P - 1) + F$ + RIGHT$(Ext$, LEN(Ext$) - P)
END IF
RETURN

END SUB

REM $STATIC
SUB Txt (Side$, Text$)                  'Put 1 Line of Text w/ Box Delimiters

IF LEN(Text$) > TxtMax THEN Text$ = LEFT$(Text$, TxtMax - 2)
SpaceLeft = (TxtMax - LEN(Text$)) \ 2
LOCATE , Txt1st
IF LEN(Text$) MOD 2 = 1 THEN Text$ = Text$ + " "
IF Side$ = LCASE$(Side$) THEN Shadow$ = ""
SELECT CASE UCASE$(Side$)
CASE "T"
   Text$ = "+" + STRING$(TxtMax, "-") + "+"                    'Top Border
   C = (TxtMax \ 2) - (LEN(T$) \ 2)
   MID$(Text$, C) = T$
CASE "B"
   Text$ = "+" + STRING$(TxtMax, "-") + "+"                    'Bottom Border
   C = (TxtMax \ 2) - (LEN(T$) \ 2)
   MID$(Text$, C) = T$
CASE "C"
   Text$ = "|" + STRING$(SpaceLeft, " ") + Text$ + STRING$(SpaceLeft, " ") + "|"
CASE "R"
   Text$ = "|" + STRING$(2 * SpaceLeft, " ") + Text$ + "|"     'Right-Justify
CASE "L"
   Text$ = "|" + Text$ + STRING$(2 * SpaceLeft, " ") + "|"     'Left-Justify
END SELECT

PRINT Text$; Shadow$;                                   'Print Text, DeLimits
IF CSRLIN < 24 THEN PRINT                               'Go to Next Line
IF (Side$ = "B") AND LEN(Shadow$) THEN
   IF CSRLIN = 24 THEN LOCATE 25
   LOCATE , Txt1st
   PRINT " "; STRING$(TxtMax + 1, Shadow$); Shadow$;
   Shadow$ = ""
END IF
END SUB

SUB VidBar (BarOn, Col, Length)

113 LOCATE , Col                        'Position at Paramter Column
IF BarOn THEN                           'IF Hilighting (BarOn = True) then
   COLOR BGKolor, Kolor                 ' Use the BGKolor in the FG
   FOR J = Col TO Col + Length - 1      'Across the Screen for the "Length"
      PRINT CHR$(SCREEN(CSRLIN, J));    ' Re-Print the Char That is Already
   NEXT J                               ' There in It's New Colors
ELSE
   COLOR Kolor, BGKolor                 'ELSE De-HiLiting So Return Colors
   FOR J = Col TO Col + Length - 1      ' to Normal and Re-Print each Char
      PRINT CHR$(SCREEN(CSRLIN, J));    ' in the Row with the Regular Video
   NEXT J
END IF
LOCATE , Col                            'Return to 1st Column
COLOR Kolor, BGKolor                    ' and Normal Colors
END SUB

FUNCTION Warn$ (Warning$)
LOCATE 1, 40: COLOR 20
PRINT " "; Warning$; TAB(80);
COLOR Kolor, BGKolor
'BEEP: BEEP
END FUNCTION
<PAGEEND:"Xmodem.Transfer.File1">

<PAGESTART:"Read.File.File1">
DEFINT A-Z
   
' $INCLUDE: 'QB.BI'

DECLARE SUB CRTShutDown ()
DECLARE SUB DrawBox (TOPROW%, LFTCOL%, BOTROW%, RTCOL%, BORDER%)
DECLARE SUB CloseBox (TOPROW%, LFTCOL%, BOTROW%, RTCOL%)
DECLARE SUB PokeChar (row%, col1, col2, segmnt)
DECLARE SUB Initalize ()
DECLARE SUB Main ()
DECLARE FUNCTION Exist% (FIL$)
DECLARE FUNCTION CRT% ()
DECLARE SUB DrawScreen ()
DECLARE SUB CTRShutDown ()
DECLARE SUB ScrollScreen (Direction%, NumLines%, ULROW%, ULCOL%, LRROW%, LRCOL%)

DIM SHARED inregs AS RegType, outregs AS RegType
DIM SHARED chars%(1 TO 3000), box%, lastchar%
DIM SHARED boxes%(1 TO 30), ends%(1 TO 30), colors%(1 TO 3000)
DIM SHARED boxstart%, FG%, BG%, fl$, buffer$(1 TO 22)
DIM SHARED seekpos&(1 TO 10000), SaverDelay!

RANDOMIZE TIMER
CLS
PRINT "VIEWIT - Ver 2.0"
PRINT "Written by John Woodgate 1993..."
PRINT

IF COMMAND$ <> "" THEN
 fl$ = COMMAND$
ELSE
 LINE INPUT "Enter file to view :", fl$
END IF
IF Exist%(fl$) = 0 THEN
 PRINT "File not found....."
 END
END IF
IF CRT% = 0 THEN     ' 0 = Monochrome  -1 = Color
 FG% = 15: BG% = 0   ' Monochrome Color Set
ELSE
 FG% = 15: BG% = 0
END IF
SaverDelay! = 120   ' Screen Saver Delay in Seconds

CALL DrawScreen
CALL Main

SUB CloseBox (TOPROW%, LFTCOL%, BOTROW%, RTCOL%)

IF box% = 0 THEN EXIT SUB
z = boxes%(box%)
FOR a = TOPROW% TO BOTROW%
  row% = a: col1% = LFTCOL%: col2% = RTCOL%
  segmnt% = z
  CALL PokeChar(row%, col1%, col2%, segmnt%)
  z = z + (RTCOL% - LFTCOL% + 1)
NEXT a

box% = box% - 1
IF box% = 0 THEN
  lastchar% = 0
  boxstart% = 0
ELSE
  boxstart% = boxes%(box%)
  lastchar% = ends%(box%)
END IF


END SUB

FUNCTION CRT%

DEF SEG = 0
IF PEEK(&H463) = &HB4 THEN
  CRT% = 0
ELSE
  CRT% = -1
END IF
END FUNCTION

SUB CRTShutDown
   
IF CRT% = 0 THEN
 DEF SEG = &HB000
ELSE
 DEF SEG = &HB800
END IF
BSAVE "VIEWIT.TMP", 0, 4000
COLOR 15, 0: CLS

DO
 rw% = INT(RND * 24) + 1
 cl% = INT(RND * 42) + 1
 LOCATE rw%, cl%
 PRINT "ViewIt Screen Saver, Press any key to Restore.."
 FOR Delay& = 1 TO 20000: NEXT Delay&
 CLS
LOOP WHILE INKEY$ = ""
BLOAD "VIEWIT.TMP", 0
KILL "VIEWIT.TMP"

END SUB

SUB DrawBox (TOPROW%, LFTCOL%, BOTROW%, RTCOL%, BORDER%)

z = lastchar%
IF z >= 3900 THEN
  EXIT SUB
END IF

' Save the Screen
boxstart% = z + 1
box% = box% + 1
boxes%(box%) = lastchar% + 1
FOR a = TOPROW% TO BOTROW%
   FOR b = LFTCOL% TO RTCOL%
      z = z + 1
      chars%(z) = SCREEN(a, b, 0)
      colors%(z) = SCREEN(a, b, 1)
   NEXT b
NEXT a
lastchar% = z
ends%(box%) = z

IF BORDER% = 0 THEN
  FOR a = TOPROW% TO BOTROW%
     LOCATE a, LFTCOL%
     PRINT SPACE$(RTCOL% - LFTCOL% + 1);
  NEXT a
  EXIT SUB
END IF

IF BORDER% = 1 THEN
   LOCATE TOPROW%, LFTCOL%
   st$ = CHR$(218) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(196)) + CHR$(191)
   PRINT st$
   st$ = CHR$(179) + SPACE$(RTCOL% - LFTCOL% - 1) + CHR$(179)
   FOR a = TOPROW% + 1 TO BOTROW% - 1
      LOCATE a, LFTCOL%
      PRINT st$
   NEXT a
   LOCATE BOTROW%, LFTCOL%
   st$ = CHR$(192) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(196)) + CHR$(217)
   PRINT st$
   EXIT SUB
END IF
IF BORDER% = 2 THEN
  LOCATE TOPROW%, LFTCOL%
  st$ = CHR$(201) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(205)) + CHR$(187)
  PRINT st$
  st$ = CHR$(186) + SPACE$(RTCOL% - LFTCOL% - 1) + CHR$(186)
  FOR a = TOPROW% + 1 TO BOTROW% - 1
     LOCATE a, LFTCOL%
     PRINT st$
  NEXT a
  st$ = CHR$(200) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(205)) + CHR$(188)
  LOCATE BOTROW%, LFTCOL%
  PRINT st$
  EXIT SUB
END IF
IF BORDER% = 3 THEN
  st$ = CHR$(213) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(205)) + CHR$(184)
  LOCATE TOPROW%, LFTCOL%
  PRINT st$
  st$ = CHR$(179) + SPACE$(RTCOL% - LFTCOL% - 1) + CHR$(179)
  FOR a = TOPROW% + 1 TO BOTROW% - 1
     LOCATE a, LFTCOL%
     PRINT st$
  NEXT a
  st$ = CHR$(212) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(205)) + CHR$(190)
  LOCATE BOTROW%, LFTCOL%
  PRINT st$
  EXIT SUB
END IF
IF BORDER% = 4 THEN
  st$ = CHR$(214) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(196)) + CHR$(183)
  LOCATE TOPROW%, LFTCOL%
  PRINT st$
  st$ = CHR$(186) + SPACE$(RTCOL% - LFTCOL% - 1) + CHR$(186)
  FOR a = TOPROW% + 1 TO BOTROW% - 1
     LOCATE a, LFTCOL%
     PRINT st$
  NEXT a
  st$ = CHR$(211) + STRING$(RTCOL% - LFTCOL% - 1, CHR$(196)) + CHR$(189)
  LOCATE BOTROW%, LFTCOL%
  PRINT st$
  EXIT SUB
END IF

END SUB

SUB DrawScreen

LOCATE , , 0: COLOR FG%, BG%: CLS
LOCATE 1, 1
PRINT SPACE$(80);
LOCATE 2, 1
PRINT CHR$(213); STRING$(78, CHR$(205)); CHR$(184);
FOR a = 3 TO 24
  LOCATE a, 1
  PRINT CHR$(179); SPACE$(78); CHR$(176);
NEXT a
LOCATE 25, 1
PRINT CHR$(212); STRING$(78, CHR$(205)); CHR$(190);
LOCATE 25, 66
PRINT CHR$(181); SPACE$(11); CHR$(198);
LOCATE 25, 68
PRINT "F1 - Help";
END SUB

FUNCTION Exist% (FIL$)

IF FIL$ = "" THEN
 Exist% = 0
 EXIT FUNCTION
END IF

OPEN FIL$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
 Exist% = 0
 CLOSE #1
 KILL FIL$
ELSE
 CLOSE #1
 Exist% = -1
END IF
END FUNCTION

SUB Main

LOCATE 2, 39 - (LEN(fl$) + 2) \ 2
PRINT CHR$(181); " "; UCASE$(fl$); " "; CHR$(198);
OPEN fl$ FOR INPUT AS #1
COLOR FG%, BG%
CALL DrawBox(9, 20, 13, 60, 1)

DO
 LINE INPUT #1, dummy$
 Maxlines& = Maxlines& + 1
 IF Maxlines& < 23 THEN buffer$(Maxlines&) = dummy$
 LOCATE 11, 29: PRINT "Reading Line # "; LTRIM$(STR$(Maxlines&))
 IF Maxlines& >= 10000 THEN
  LOCATE 11, 22
  PRINT "File Exceeds 10,000 Line Limit..          "
  LOCATE 13, 33
  PRINT " Press any key ";
  SLEEP 0
  CALL CloseBox(9, 20, 13, 60)
  COLOR 15, 0: CLS
  END
 END IF
 seekpos&(Maxlines&) = SEEK(1) - LEN(dummy$) - 2
LOOP UNTIL EOF(1)
CLOSE #1

FOR a = 1 TO 22
 IF INSTR(buffer$(a), CHR$(12)) > 0 THEN MID$(buffer$(a), INSTR(buffer$(a), CHR$(12)), 1) = " "
NEXT a
OPEN fl$ FOR INPUT AS #1 LEN = 3072
CALL CloseBox(9, 20, 13, 60)
currline& = 1
FOR a = 3 TO 24
  LOCATE a, 2
  IF LEN(buffer$(currline&)) >= 77 THEN
   prnt$ = LEFT$(buffer$(currline&), 77)
  ELSE
   prnt$ = buffer$(currline&)
  END IF
  PRINT prnt$;
  currline& = currline& + 1
NEXT a
currline& = 1
curr% = 3 + (currline& / Maxlines&) * 21
LOCATE curr%, 80: PRINT CHR$(178);


   WHILE NOT finished
   GOSUB GetKbd
   SELECT CASE Kbd$
    CASE CHR$(0) + "G"
     GOSUB HomeKey
    CASE CHR$(0) + "O"
     GOSUB EndKey
    CASE CHR$(0) + "H"
     GOSUB ScrollUp
    CASE CHR$(0) + "P"
     GOSUB ScrollDown
    CASE CHR$(0) + "D"
     GOSUB ExitIt
    CASE CHR$(0) + ";"
     GOSUB PrintHelp
    CASE CHR$(0) + "Q"
     GOSUB PageDown
    CASE CHR$(0) + "I"
     GOSUB PageUp
    CASE CHR$(0) + "="
     GOSUB PrintIt
   END SELECT
   WEND

EXIT SUB

GetKbd:
Kbd$ = ""
start! = TIMER
GOSUB PrintBar
DO
 Kbd$ = INKEY$
 IF TIMER - start! >= SaverDelay! THEN
  CALL CRTShutDown
  start! = TIMER
 END IF
LOOP WHILE Kbd$ = ""
RETURN

ScrollUp:
IF currline& > 1 THEN
 currline& = currline& - 1
 SEEK #1, seekpos&(currline&)
 LINE INPUT #1, buffer$(1)
 IF INSTR(buffer$(1), CHR$(12)) > 0 THEN MID$(buffer$(1), INSTR(buffer$(1), CHR$(12)), 1) = " "
 CALL ScrollScreen(1, 1, 3, 2, 24, 79)
 IF LEN(buffer$(1)) >= 78 THEN
  prnt$ = LEFT$(buffer$(1), 78)
 ELSE
  prnt$ = buffer$(1)
  prnt$ = prnt$ + SPACE$(78 - LEN(prnt$))
 END IF
 LOCATE 3, 2
 PRINT prnt$;
END IF
RETURN


ScrollDown:
IF currline& + 21 < Maxlines& THEN
 currline& = currline& + 1
 SEEK #1, seekpos&(currline& + 21)
 LINE INPUT #1, buffer$(1)
 IF INSTR(buffer$(1), CHR$(12)) > 0 THEN MID$(buffer$(1), INSTR(buffer$(1), CHR$(12)), 1) = " "
 CALL ScrollScreen(0, 1, 3, 2, 24, 79)
 IF LEN(buffer$(1)) >= 78 THEN
  prnt$ = LEFT$(buffer$(1), 78)
 ELSE
  prnt$ = buffer$(1)
  prnt$ = prnt$ + SPACE$(78 - LEN(prnt$))
 END IF
 LOCATE 24, 2
 PRINT prnt$;
END IF
RETURN

PageUp:
IF currline& - 22 > 0 THEN
 SEEK #1, seekpos&(currline& - 22)
 currline& = currline& - 22: crln& = 1
 FOR a = 1 TO 22
   LINE INPUT #1, buffer$(a)
   IF INSTR(buffer$(a), CHR$(12)) > 0 THEN MID$(buffer$(a), INSTR(buffer$(a), CHR$(12)), 1) = " "
 NEXT a
 FOR a = 3 TO 24
   IF LEN(buffer$(crln&)) >= 78 THEN
    prnt$ = LEFT$(buffer$(crln&), 78)
   ELSE
    prnt$ = buffer$(crln&)
    prnt$ = prnt$ + SPACE$(78 - LEN(prnt$))
   END IF
   LOCATE a, 2
   PRINT prnt$;
   crln& = crln& + 1
 NEXT a
END IF
RETURN


PageDown:
IF (currline& + 21) + 21 < Maxlines& THEN
 SEEK #1, seekpos&(currline& + 22)
 currline& = currline& + 22: crln& = 1
 FOR a = 1 TO 22
   LINE INPUT #1, buffer$(a)
   IF INSTR(buffer$(a), CHR$(12)) > 0 THEN MID$(buffer$(a), INSTR(buffer$(a), CHR$(12)), 1) = " "
 NEXT a
 FOR a = 3 TO 24
   IF LEN(buffer$(crln&)) >= 78 THEN
    prnt$ = LEFT$(buffer$(crln&), 78)
   ELSE
    prnt$ = buffer$(crln&)
    prnt$ = prnt$ + SPACE$(78 - LEN(prnt$))
   END IF
   LOCATE a, 2
   PRINT prnt$;
   crln& = crln& + 1
 NEXT a
END IF
RETURN


ExitIt:
CALL DrawBox(9, 15, 13, 65, 3)
LOCATE 11, 18, 1
PRINT "(E)xit (S)hell or (R)eturn to Program :";
DO
 GOSUB GetKbd
LOOP UNTIL Kbd$ = "e" OR Kbd$ = "s" OR Kbd$ = "r"
LOCATE , , 0
IF Kbd$ = "e" THEN
 COLOR 15, 0
 CLS
 PRINT "If you have amy problems just contact me over"
 PRINT "FIDONet in the QuickBASIC programmers ECHO..."
 END
ELSEIF Kbd$ = "r" THEN
 CALL CloseBox(9, 15, 13, 65)
 RETURN
ELSE
 CALL CloseBox(9, 15, 13, 65)
 IF CRT% THEN
  DEF SEG = &HB800
 ELSE
  DEF SEG = &HB000
 END IF
 BSAVE "VIEWIT.TMP", 0, 4000
 COLOR 15, 0
 CLS
 PRINT "Type EXIT to Return to ViewIt..."
 SHELL
 BLOAD "VIEWIT.TMP", 0
 KILL "VIEWIT.TMP"
 RETURN
END IF

PrintHelp:
CALL DrawBox(4, 10, 20, 70, 3)
LOCATE 4, 29
PRINT CHR$(181); " Keyboard Commands "; CHR$(198);
LOCATE 6, 12
PRINT "Arrow Keys:  Up --- Scroll up one line"
LOCATE 7, 12
PRINT "             Down - Scroll down one line"
LOCATE 8, 12
PRINT "             PgDn - Scroll down one page"
LOCATE 9, 12
PRINT "             PgUp - Scroll up one page"
LOCATE 10, 12
PRINT "             Home - Move to the top of the Document"
LOCATE 11, 12
PRINT "             End -- Move to the end of the Document"
LOCATE 14, 12
PRINT "Function Keys:  F3 --- Print file"
LOCATE 15, 12
PRINT "                F10 -- Exit ViewIt"
LOCATE 20, 31
PRINT " Press any key ";
SLEEP 0
CALL CloseBox(4, 10, 20, 70)
RETURN


PrintIt:
CALL DrawBox(9, 15, 14, 65, 1)
LOCATE 11, 25
PRINT "Printing, press ESC to Cancel"
curseek& = SEEK(1)
SEEK #1, 1
total& = LOF(1)

DO
 LINE INPUT #1, X$
 printed& = printed& + LEN(X$) + 2
 LPRINT X$
 IF INKEY$ = CHR$(27) THEN
  CALL CloseBox(9, 15, 14, 65)
  LPRINT CHR$(27); "@";
  RETURN
 END IF
 FOR Delay% = 1 TO 5000: NEXT Delay%   ' Give the printer a chance to catch up
 Percent& = printed& / total& * 100
 LOCATE 13, 31
 PRINT USING "###% Complete..."; Percent&
LOOP UNTIL EOF(1)
LPRINT CHR$(12);
FOR Delay% = 1 TO 10000: NEXT Delay%
LPRINT CHR$(27); "@";
CALL CloseBox(9, 15, 14, 65)
RETURN

PrintBar: 
IF 3 + (currline& / Maxlines&) * 21 <> curr% THEN
 LOCATE curr%, 80
 PRINT CHR$(176);
 LOCATE 3 + (currline& / Maxlines&) * 21, 80
 PRINT CHR$(178);
 curr% = 3 + (currline& / Maxlines&) * 21
END IF
RETURN

HomeKey:
IF currline& = 1 THEN RETURN
SEEK #1, seekpos&(1)
currline& = 1: crln& = 1
FOR a = 1 TO 22
 LINE INPUT #1, buffer$(a)
 IF INSTR(buffer$(a), CHR$(12)) > 0 THEN MID$(buffer$(a), INSTR(buffer$(a), CHR$(12)), 1) = " "
NEXT a
FOR a = 3 TO 24
   LOCATE a, 2: PRINT SPACE$(78);
   IF LEN(buffer$(crln&)) >= 78 THEN
    prnt$ = LEFT$(buffer$(crln&), 78)
   ELSE
    prnt$ = buffer$(crln&)
   END IF
   LOCATE a, 2
   PRINT prnt$;
   crln& = crln& + 1
NEXT a
RETURN


EndKey:
IF currline& = Maxlines& - 21 THEN RETURN
SEEK #1, seekpos&(Maxlines& - 21)
currline& = Maxlines& - 21: crln& = 1
FOR a = 1 TO 22
 LINE INPUT #1, buffer$(a)
 IF INSTR(buffer$(a), CHR$(12)) > 0 THEN MID$(buffer$(a), INSTR(buffer$(a), CHR$(12)), 1) = " "
NEXT a
FOR a = 3 TO 24
   LOCATE a, 2: PRINT SPACE$(78);
   IF LEN(buffer$(crln&)) >= 78 THEN
    prnt$ = LEFT$(buffer$(crln&), 78)
   ELSE
    prnt$ = buffer$(crln&)
   END IF
   LOCATE a, 2
   PRINT prnt$;
   crln& = crln& + 1
NEXT a
RETURN
END SUB

SUB PokeChar (row%, col1%, col2%, segmnt%)

DEF SEG = 0
segment = 0
IF PEEK(&H463) = &HB4 THEN
  DEF SEG = &HB000
ELSE
  DEF SEG = &HB800
END IF
segment = row% * 160 - 160
segment = segment + col1% * 2 - 2
colorseg% = segment + 1
FOR c = segmnt% TO segmnt% + (col2% - col1%)
  POKE segment, chars%(c)
  POKE colorseg, colors%(c)
  segment = segment + 2
  colorseg = colorseg + 2
NEXT c
DEF SEG
END SUB

SUB ScrollScreen (Direction%, NumLines, ULROW, ULCOL, LRROW, LRCOL)

' Uses the BIOS Video Interrupt
' to scroll the screen
'
IF Direction% = 0 THEN
 inregs.ax = NumLines + (6 * 256)
ELSE
 inregs.ax = NumLines + (7 * 256)
END IF
inregs.bx = BG% * 256
inregs.cx = (ULCOL - 1) + (256 * (ULROW - 1))
inregs.dx = (LRCOL - 1) + (256 * (LRROW - 1))
CALL INTERRUPT(&H10, inregs, outregs)
END SUB
<PAGEEND:"Read.File.File1">

<PAGESTART:"Read.File.File2">
' VIEWFILE.BAS  by Matt Hart
' View any size text file without any temporary files.
' Keeps the SEEK position of each line in a long integer array -
' which does limit this to 16,384 lines of text (and makes this
' program easy, small, and fast.)  Key controls are up, down,
' left, right, page up, page down, end, home, and escape.
'
    '$DYNAMIC
    DEFINT A-Z
'
    CONST false = 0
    CONST true = NOT false
    CLS
    LINE INPUT "File Name: "; File$
    Escape = false
'
    OPEN File$ FOR INPUT AS #1
    REDIM Seeks&(1 TO 16384)        ' Max number of lines if 16384
    CurSeek& = 1
    NumLines = 0
    DO UNTIL EOF(1)
        LINE INPUT #1, Text$
        NumLines = NumLines + 1
        Seeks&(NumLines) = CurSeek&          ' Save starting position
        CurSeek& = CurSeek& + LEN(Text$) + 2 ' Next position - 2 is
    LOOP                                     ' for C/R & LF
'
    CurCol = 1                               ' Current Column
    SeekEl = 1                               ' Current line
    Escape = false

    DO
       GOSUB LoadAndDisplay
       GOSUB KeyProcess
    LOOP UNTIL Escape

    CLOSE 1
    END

LoadAndDisplay:
    SEEK #1, Seeks&(SeekEl)
    FOR i = 1 TO 24
        IF NOT EOF(1) THEN LINE INPUT #1, Text$ ELSE Text$ = ""
        Strg$ = SPACE$(80)
        IF LEN(Text$) < CurCol THEN Text$ = Text$ + SPACE$(CurCol - LEN(Text$))
         LSET Strg$ = MID$(Text$, CurCol)
        LOCATE i, 1, 0: PRINT Strg$;
    NEXT i
RETURN

KeyProcess:
    A$ = INKEY$: IF A$ = "" THEN GOTO KeyProcess
    SELECT CASE A$
        CASE CHR$(27): Escape = true        ' ESC
        CASE CHR$(0) + CHR$(72)             ' Up Arrow
            SeekEl = SeekEl - 1
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(80)             ' Dn Arrow
            SeekEl = SeekEl + 1
            IF SeekEl + 23 > NumLines THEN SeekEl = SeekEl - 1: GOTO KeyProcess
         CASE CHR$(0) + CHR$(77)             ' Right Arrow
            CurCol = CurCol + 1
        CASE CHR$(0) + CHR$(75)             ' Left Arrow
            CurCol = CurCol - 1
            IF CurCol < 1 THEN CurCol = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(73)             ' Page Up
            SeekEl = SeekEl - 24
            IF SeekEl < 1 THEN SeekEl = 1
        CASE CHR$(0) + CHR$(81)             ' Page Dn
            SeekEl = SeekEl + 24
            IF SeekEl > NumLines THEN
                SeekEl = NumLines - 23: GOTO KeyProcess
            END IF
        CASE CHR$(0) + CHR$(71)                       ' Home
            SeekEl = 1
        CASE CHR$(0) + CHR$(79)                       ' End
            SeekEl = NumLines - 23
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE ELSE
            GOTO KeyProcess
    END SELECT
RETURN
<PAGEEND:"Read.File.File2">

<PAGESTART:"Win.Font.File1">
'>>> Page 1 of QBWINFNT.ZIP begins here. TYPE:BINAA TLEN:55046
'-------------------------------------------------------------
'                  INSTRUCTIONS FOR DECODING
'If there are multiple parts to this file, merge them into one
'file using  COPY PART1.EXT+PART2.EXT FILENAME.EXT  Remove all
'message header and footer information (everything outside the
'">>> Page x of..." lines),  load the result into your version
'of Basic (QBASIC, QuickBASIC, etc.) then RUN it. The original
'file will be decoded into the current directory on your disk.
'-------------------------------------------------------------
DEFINT A-Z:DIM SHARED K,S,B&,Z&:V1 'Created by PostIt! 7.3
SUB V1:OPEN "O",1,"QBWINFNT.ZIP",4^6:Z&=55046:?STRING$(50,177);
U"%up()%9%'%#-%%/n0A<O:UA/t.%%O[%&%1%.%%&k%rfsz#fqS&RwneL):F#\W+/
U"gK>rHq\g)z[(Jtnj&s48[26R,aQu>SJ<p6d=2/jbBeC7s_9_EB?Vqag8-ix0N9i
U"gn)MX((guOQBE=SEKCX+J+#em&MM4m/#xtc,Hctq.njHuPx$,uHwh8tkxZuF4bD
U"MTwhoVTHcq6$omc7cVrFFWpZ5I=J7DpIZrDt[oZ;X/zwvjmS[sdFblHQVn-h.mC
U"cixo2CY<J8v&86'-w/oj_NlIqSSH7aS'CD:#OpnB&hcSV4K+MK*vreZBxLV$_r'
U"B5c>Wk>j2QoxW);kFeN4E>KvuHLlo;>KnNx6q_GV(A5o1/YnDJspni:HTwn.oe9
U"P[u>_?Of<,6.=CB%Mo-q=okpQIoQm^B7up#O]Pe<#y7WJ.7N(4t-JXH(]cG>k[a
U"ea'eW7/:NG6$ow'5opJ[k+Wl8v;>i4y$x;:XhPWd87njn_+UZ[gYkeO0*l4U'.I
U"qLy)df;9;7bOS=+eX:n1KMSh+W\pW2$84V'l25[q9.zNBb%pP=W<FTE</1wcXDG
U"3EOe^X4WL5&8D,-M:3[UTxlNqyS%N2gzAMe9+)^X/#_6,ljLu&dZH\9y&s5\G4c
U"pz=%5kwK$cB<'CuMAg588dOv/K3Y,7dCgg8$F[SLr*h;o#eA17snMn5:y)LY-LR
U"apNFnuP;h?.%1e/A<A8c[>Yu3KXGhxMz*#8c:Ih?,3KbQTdsV):=N4IhsLz=UPa
U"z<C$&D^TYaqu$&^o<\>mfP.'b6_<e>sKlG9PNG1NP,sd1;A=kF>B/%X9GQ+,d)J
U"W6$.7Q<*gB08t21g,&+wXG)$w[:WhGYFQvmda^E/YHAMy5#GZegL[8M(q3f-li.
U"U&a?Yd#++=a+e/)9D.[0aR^Lqj8l$]5[$gjl\<?29tUsFlkAumU9_4iMH+Vzs$9
U"ncsEe$+;fie]j0Y7Od8o'.']%Ome;+2[9g1%S)sAi)n?0O72khY0Y2H[oXe=YiD
U"JT;ky#&>M9?yJdAlj*Pqs6NCyc2:Zb^*(S)eTT;,1VD8X$uIkzI8>I6CzGxt6(N
U"&dUM;D1_cE<\moCx,tvfu)V5gwhH''?4DmI_uA'SgC^G[1-piu[pcBLquhLZicZ
U"Rnn0nXAuW#t^zNI,po\GtD9+dK-i#2Fj3kYO$?[8J%f]Ew_7T)[BTBv)MQNDmk]
U"G0pnYP8jmJvuNq0)F]DK\6pLOOC[axv^iU,)h84N$u,:R5>=/$N33/57m\7U:i5
U"%^5kW^<(F#kWa2_Lc[J4IVXl]6LDC1K-'$1ha5uNucwjRS)7\kMJCA;ICfFW>&:
U"=?sTg6Tsp=d<K<iw9*M.XU:Gf<BL'_?ab5WocO*E.]ak)$_[$ZZvI'.'7UpbfK4
U"-hpRP$t;P6d+RLS8y]f7OtF81v:TU*GYVC[,ill\uo6aVt+O[N0F,x\+(/?3Ak9
U"KM/5?ha:r9b_w8TM<.kFX\44V;tq]aUPQV>p&Zc\850sLU%&7EKReNbWBj6YB5g
U"M(Gc_=of0J68*N&A,d_S[?$b/YMCi*H[eX*b/Rbe*Bo+Q[4-WQu)J\W#IoY0tYP
U"ZvO9p(rzwN7vR_/e^PqIpPVE90FgKs*=t?z(j8d&hO64&fGqJsd3[eTg5m8lm_E
U"e24Q^w'TCSb'&dN2nOTd?Dr(_Fq4[Q8Uckt$FUwo/94/T;4S0N(A[]v65c96OD?
U"PLUR3R%NH,0%)AB1;j,h0vCA8W)9NdYbRu+gE3>D($'SKbTSx/(v+5CLbX49S&$
U"T'ZU%#PoHfx03'Is1i+^o_tAcsYb-M5C'&j2AZ-Yhu:1M9/M4[T^PyojRK*-fI3
U":[0>6R_:p$Md-5lXsS*jCFnQ*#Ja)-jd&Ch5j-Ha2Ax7Z?6Q'_j.B=WjJmdGo=:
U"h/5(1>J$kwL*Zc]bzliaC?wQXFuq5]<,-aoiFqMT7(Kq_GE\)XG/-p(=S1&bo[E
U";.d$ogni\9u[:/hpuAX>eecD+Q'WERc+6_ZZdtg7X/\/Gi95e,qi&qWvM-wBQ6R
U"W(J<59_*s8:^E;5?1t=7:?2t,x]]9tFmEBg3O7=jsp^HAgk(ANI.[vK_j8ubW#K
U"](2Kur>^Z2KlULyBUjw\xKCzXAiAswl.VC_YW,7*N>AU]=#V1j]8a*'fJxWc3Ne
U"w>YgPDxC:)Jjx6r2Uz$AXq:8AQZrXm]NwT'IAHDm,6-S]<2k&tHE2O<_n0gN$'%
U"B7ca+N<03uC0Z5i>%6J$6%ke53Xwy'_p>uB0+'#IK]'?5AYahd&p+N?-J0x_P7*
U"F,+4TAcQYc=V&R:gn;X'/H76VY&JEZEUnj&ws[:TJ+P.4.s*RSgO\AN5'4w9>_C
U"H]LL?4\QJLUkRKCw'WQnz&-1+Q'YA-p+(Ku=]&w/U-G^)KD5nmnttPsYgk.[X(O
U"l(SkI9#emZS+:.Gb8[Lwc95olnk-nVK:V$2Qt4^Rw9%=P>G?mDOh'fDgMcQUOAo
U"8XhDhi20pv$$a93I3;C2R(v2ittcNd4&8/eFn'1qfDz<E3>'\NoIe;3=?,7.>I^
U"*N=f6Rrm:3D<R;#%x)758xziENq=+o7+y*U):&,4^Lq*9*K),)5fM*$RGDk)8z#
U"/*e6ms79)=<o%CG%-8Osh0<S\Lwn\OH6&GuccH)Do&f[oq1%^Sm77ovq+V,9B5F
U"(4;&^jHfHgIY8Aql83FjvVz1E36*/Ug2+<8KUH<S1+m:;Wq=UBFRn7ZGKc?.reP
U"xep9?d$2OC(T'P;f[3aj2Mcg(ek-Y=98+uY+K-mS%^>i;5cr>[&_o2,xAwSZ_pD
U"o$.A%I5]*GZgP(&EE$Px6#)kPK(LPm^XVZFh99'=MmkA7Q7:LM>Pi,UIZLbW%Mg
U"B6NQR<wn_2Y+k(^)Wv8Bgfuq?YK%/Sj]]R;'obWyMDw8G1WVpmATQ]c7YD09OYK
U"v**S(G?_i&ePXLcc%c-6nM&$*V&&$1-U4?b'r\QwK'#<q?uL,ClD^I)P):N_'g2
U",oY,^xs2&[/;a%eXGe6MaWS0C,[Z],xYM?cXgtk?cN<,u6L6Pm,l1wTTUSr$N\Z
U"lufgoZn0)$crC/talfZ-X*E6J.$X.p=MxyEZN*ISNXBbbnRq<#7L$RDz%aaaF.R
U"ktg/P*6tIE5pNuv\jo6J:=GtCZT[&s=<5JpoT9C&iSo[ppn3-O8Nl7Z[[y/fHgE
U"H[T,=0?.WPNADgvZDE5sT_U\+FNQ&kELdI5c:X2N<=Cmo:-l_H6cI1?]SqR+l>U
U"S]\9+S(2$()'$B%S],XDV)GXZO)RO1Y:Ipuu4*\?-y-]D6-mcDP,jl[:*a6[x10
U"UCvsJ]>vomn84wt5Sp3.u1x*iAj/=L*H&5Q95_YV:t=He#*I5-.$98/#*ztp?4B
U"3%o0dQ5j1Ta2UK'(=gC?7k$we[;Iqf9dRI/j>2MloFKR?$%l;MmJr[OEelod29%
U"y/mb?#lA)8u*vM4zIaJ=AmI*+sG?TJMlHtuUGgL;ov6?[&Ez-?q6wD%i\9Ch3x5
U"PWL+&/sLJ:.K(R0LG(ir&Ozq%BC7]gSV=N]U0t_q#O<%i0'va)d8wO6;PQS_Mgm
U"DX=_(9IAh0ze]9Wl91$hra4:OR)E<k&Z.jW?mT_Y#4Fse^j.YQ=ngpiOwPEH4XH
U"d5TDATD?a]1ZA;N;6$YY[<T$GWbg^)Ry)-;<nuV9a.>(q\.d_FF7w^u,E62Kkk4
U"(^FMMCb;5g\)p9].=KA_ijYlQuJ\BO[urubslnLfdo*NNhI(g$Q^nsyLta.ME?9
U"+j12t[Yr[:h^3;Wn(3B,?C%;5;/SE'-LZXZj.'3V'.t6Ex:eRb+4vVJJ#1,2L7.
U"f8_zJBE7X5\QSWLbiw.B^)#A_[\ilrG/JOtGim&N=[7V6SV,#JJ%4O4SDWn_8Xh
U"-QJLPnSHaZUqW*dGcXqsc?+f3Q2CT*09&d&yDi-fy+)qgXeH>5o6fbTGwrE?_rW
U"H/9gLPcQOVpaLV9uAFB#FILUVb_UiJa\2W)%aPnKobzGOUUEm;L0vDciIsGK&gx
U"yT3IkA*v3y9]^]*;/T[N;CED:GU-B9zBIO>74g1RNERKBvKo?8$\:5GBC/6BD;t
U"hOI5Dc3-.h7mkJz?qd12%uI<Ns>KZj]9-1ef[F<-Sb=Ci4('q?)f1i\CYwOXMMX
U"+9I6s7=JXb1gDBc5ee0jBRDL(+)Q(,o\B+G3nDJSZuLNdrn\F&_vKGW+bcc2Wf%
U"Hmr8GrN)J)&68LK=e\-kwrK78OkmreDDmu&,MqH6)v9vCBwq%$No31(\#*XX*MS
U"%d5oTNF17b:T1=<*_)jMY.tC0NDuM,pYo]i9%&Gfo+6vVlR\dZOm0lF1=g/pIvs
U"2oj?ia/N,J/q2rQ*(wBg[(oK=?7\Lf3I'zpxr+_x\FoZ&<\'N5;\#Z_x]TU#<;3
U"HFh:l[TEKopIX;<vA5oGu[XR^aRMprZmst;pFXeE3.l=gr0(\HdG3HY_:A7/ydo
U"jb73_Um2bq<2#5%XIA4rfYN:x*ZRdc^:1uHP5++_Q\I9TC[/)<UUJ4VNTvJ1-iV
U"s%3vMEQb6ctD]m9(p'909z.fR2f0XV=L=p,oe2:[a[$+ZFqO1SG19v37lF7G<%0
U">f*(_)ZK16b\C+G=.'w,'8ZZ5V6lx/:rWs&%YFp;VrbUIhGWjVR)J6a:w&*JK\R
U".+$m0miA^^WC(V86)q$Bjkuny$\BzcB'M)qXt4'Ivr59sxQjJidgcmCC=>Ok#dV
U"B:qk)G?Y8S5DG=0;4lhlB6;U.1]nGeFCd_b*T:FY6):q\ffuEr;TQYdYA5W^/x_
U"H.JD6t#%IL1e[.<.Hc^)Us_'+Q%HlujPJNk6WrEG3<l6AOE9aXWWIPfarx8eDF3
U"-Ip4<nsp_:bjJ15p+Lg98DD1JC(Ekg:M:iYSWmkil38bB[3IX1w>G//fHGrT<fe
U"OXY6O<KhTacWweVNF5JqE/3vU&k5SE]^Aem\iCv4_#O/LYCJ$=Dv<UhXHI&%WrV
U",4qX'K)rljX%>kocChbf;ZsvfU_dH4covgC[%]><PEa7d(D_02%00fF=2jHOiJ;
U"%V_#+yrBF5-+d93y[YGlF-:s+nUucjv\T9[#Oy;.P#A\uYh#/y?d/,\^m1musl/
U",==e122281M<P5ib:jaJ0E_y'Odp+QSRc#U,/AAk#P(37<>277.P,W'+j2m]9-+
U"Na4whA3+i+[_iq%]wD-rWOjw*H=?#:E<'pQ-tim0p$Ps*_yQE10fZqc5?L'iP3$
U"O.6[aR>1Zhymb0_ke,M:]?_r.0fW3(?6zoX#X$_Y$s/E<#$%6&ocOvZH9hI_WU4
U"9G?d[oSoFWCO^7S-AYnH_&u:a8'2b%._V9yEia?pS:4i_gbkD7Ng(Wbc#0VM5oC
U"$ZJ^RNNLR1bs5hib9W^DtHRAVxMB1.0K=>S;/HWI2JEm_pJEbuLobgZJk&E2AFM
U"YiP<ni_rn'<KKdL4<13vM[qP<#=XQ,t\]:'[?VIfe5s5jLvu3hSW>=;)o8s3.zk
U"0c&bwN#jxb2=q?,:#SCSl#U;lpuI,D^jHf=?COtXh8('ShJBGz[nBM>x']tk5HO
U";s'<e+4A[RY<^DixfC7MCL>-H63ojT<[E[Hc3'mgBUbq)W&aSG=WSg/s:J6txN&
U"9X9djvk$%=cCB.9jb1<Ls5Sej'Q%CfygiCFaTeM4&HVI-uod^=mraURRjC<5U.e
U"8Jn[&hxG&Wk:W[ch9l3\H<5^nU3W_/+Ku(SKn$+1ragG$:gj+.q5A(=%\t[SuDc
U"T3B62q\+/<d;SPn-HF6hiXZKj4^1R&)h7Dc<bxv3%^JrY&8QMn2Znr6A\viQ9ZB
U"68\0id'ga#J8$cXuP#HZL6n-iG?%j5Z&>+21yH^$5TD^U\662,z,_2^IiO1)+5S
U"9k5+4(*2YJQqSCUy6+SD_Ro5fbM/)e\BbOKwIDy%Ppcho'4Vltx;aBjA5i]QO$[
U"R)5f>)VhPP=kuQt:QfRz.>3U165TaFD>R0Dv[oVP-/HJ5Keg+NS2OOK++vGw9Hu
U"0&(sA'Y/*\/$$,R#Uq\T&T]Uk;?<(_P%VN#$3[ALPodLsB$h*::^jE+j<f^Oz;:
U"&ic(t'w.ma<a**S1EWsmT#&]MP)w72'ch9-D]k?<&uHlx,7^9]4zl8EQ<r\XtwS
U"o1I=OPBUaa2St7bNfr,r.)d2*tH4Fi?wG6Oae-)#<&<8S9[ao+U&U$FCm=x0m=5
U"4fF4cP$^?*?RTT:(6?*WqCiJ/_7_Qqq_f[4DA#FIPnyh=iO[ykW/rJ8VgAaI34F
U"vH3rECjYY?$/5=cNQ60a3RNAX)(]t;O<,qqIZi84_Lh6wlAx>ui?Y=T>FV1f'__
U"8h(-Lk8jUmv2\eTI_fcAEH<8-vt&%)it_.xLYzsHrxflWW.tHJswn(a<<O48G.3
U"t<7J=ZT,:Rb1,6U>yQ*%06'feVRK:pi3c(FN[gHZpht\bS0TeMhpmH;1C%oze=(
U"+4\D<.1o*C3xW1Nm_f)9T'X2A$Glq9tb9fBgBKfBnXRJdX>pDM0#;]LO.ZPPib.
U"&1TLAv%+lhin\W:V82e+&5PK0Fb6&RdvU7?,0XUtOUuwb%huWlZnv6$P9Gd^Q76
U"8?i%0xpOH*eZjlW$f5s6n.QW+jq)?UYOjhJo,3Y['0XxitH\$TJ$TI)cc9c]N8d
U"ipJjAqpM4O,U*\gozEQP[u.HnW940s0/U,_*VONNz?90?5)wh,pLSl-N#<_\D4L
U"$+5>?_Y0k^H5AB8fgU=i7\rpj[7w=9DaSQ*$xenl$Hg[ZWXUj)odiE3;ffBXRR:
U"k=VH09Cks=JTSP[K0Q\LbF%GFm9%>-0s?Mn?\j1%W*sOcj+$*rmTu5<L0;qhtM^
U".)9PFA?^>)>0eO61P.ye(uO3JBr%,K]Q(5Yd:%_ZAi$((lrLl#z[[/3a\\TM^n;
U"OBl('=P]&k+d:%#7N]KJ>nf#KE2S%^N'.,Yspy0jQXniTREVR(aVb&Ztpl:*g?^
U"VseH8dqqJnp47Jo;.2W#^=brIq.2cOdbg-pt=$C4pMGH77%&bgr(F,0IW1G;S5.
U"a/TN0T?k&r6h61VaKio2#F>zi-?WEI;hb7mJ$k>D]5fBqBIKn]/v659Jbnf2jc?
U"]#nI.X/5c.TLA.CXut;wr\E[Y*g)H)-;eTg_7]JeCt6n(Y_V>zk.C$_KY/]0$ML
U"id00VRPhYITAAL9L7(kaE%*J=E0;WKS,l%u.Dn,fBqgPa*o]hE?lm[qH5m(8Br+
U"A)>r:idbo#9O)7S38^*sqSex^rrK'xDReG^dKYS&0?VP=uW:%_9;YzNGUY/<H\1
U"llfIY-h3P4<un2Hw<(1)[2Z(.8%vO3o8?Qjh1Lprk6R.$;[($HnbTnIS7=D^SSA
U"%q.]-JB9U5h&URxJa;mJbl4JN;ET'EVM?s.B\9\$AmgLGCZ/k>HB/0ws4vLeT79
U"X>,n7b$;,\=dJ?/o)%3Lr,[h4<W%4#&82pFVE;^$[E)\v^UN8##dC\])Vrx0Gd&
U"dHBQ&Q[l-774BSkLIK:%%4K,[U/&EJzThU$(p/Q'*63[hnJoE>f\g^Kl9>k/*lJ
U",%D.a?b<JedJymaP(K=.AU#\PgF9Fr%RYt&?-oSe9Tbh%,m)?k\\5sb_9^'MhL*
U"YIo[um-h\pnS_Sg[Zw%?DDR/%\nE$5:co/RY*P]6*o]K=BMeSQk)$Q$K9-+Iovq
U"I:IcjGmU_'f2nZq:%RQ++uSqBX1WY<^,wV])k%Y-+(-egJF9\XG(*OnW;1$Yl[w
U"<M(AEk%:UzFh,3,b5n%+m?CRahyZf:'\nfG6nl#0J1VT/NGTqe19FGu(DpL]HoH
U"7R$TAV(UDosDli?i]q#PG[ZYfQLR,WLR\>r=n>l2DG0DfFKq46X0HJQ=+Vo^rkO
U"V0v5D9fxYMAf3tFD,R5_yScJKMi1FL<]<(Wws*V32t=9lh-k*Ov64cM3HWI0DCw
U"&pm<xoug]/+,wmcuNKl:XuPgM2E(;BIvk+j49bo%k$tt7rdekHtA3H5$HHPLHVw
U"M_2w:EpS34Zq1vk:Z=to]d^OUO\m^_ZfYr;O(p),;Q,/(ZZp^79BvQnOPvet5Oo
U"b851B\LVv+m5nr8A6-\P'3/9u#,XHsJ8P6wi3V/UJrdWB1S(lU1'9,kIcS^V%3#
U">Szu[S^K09^%mz7le7nZAuFcGnBDaE)#_h8g<k/GL'mIFKF942Od8nt>hh.lE-'
U"X_+.d$U\XA;co(f.5.X9clQc.p#bRWn['M(,GsI>/RXqXPIioX/JfXa3/E1$E*b
U"kk+1iu6bfuBi/Yk*:[>Q-4DoMrc2?8E0mlPA->Fac%4sH*gm)EfZ*I1R'stSUra
U"iF^.c9Ckg,h$Y]R6iEipTx[(I?60W$R:q&^]T').MFywim0-dG\9%XHV9*/RGDu
U"^)T7k$u9*J1vud9EiH7oibGJ(HBMc64pD0Yy^;H*s?SxQ,m.#7nF(YD+P[F.(A]
U"Gp&l.;V?J^]4LpT>1eWkLA0/=y8$1fd>LJ'#15'Jhi*U'Eh*54\82m)^wg:C#)a
U"BTbfFbo?UZ3\]#h/k%:(MU-:B6^6^kU\y\EF2KRzV+^pzD_yXV82Y.yB=#\pAWX
U"YXr_gk0ns)ESusO*)W:4$qq+U+43EpLBJM(VO#tc/FTYym]Uqx&'rppE%'Tg;,(
U"h$Ve%bDjZ]80a'unqp=L5Dquy=xiPJ0[*MAa;R=[gMgTo6G1)f9Tcioq/^T#;RR
U"qfmG[FpAIVXLqtrO,t6HELGb6H+7<m\+.Bf%Nne$9,;8U0AQ3pRd3%<?]2letz#
U"XmzDm-4tDO3%uT&T2Y_N)CH^LaI^kjIIJ\*ow&+H5]IQFCwrXb4O^aV3Ksu><p<
U"M1i$v5kNny.ml#d$9)l>qr_XQ=a4sONd_6*qg&A2C+Ao7DP\CC-FJ[>M(?zvvX+
U"S1P$2q-np=Q%1>QMlF5dgX.DB/hE-&:Z,%3]EysQgm/gFu3cqymq132u$vQGZ+X
U"VFu*dqGeRlhP#'2/vleI$S&Q5L;*0%-P>8e0&Z:GUhN*NCsMuCib0OL/g:gEpj$
U"VZMs(pa7$T-k0-1knI4D'(\z.w<b+V&J0<,PA6OoQIO\Qia^Ug:D:nHlw^v&_^m
U"G)WXNdn*,XV)mhe8]$hgCO/Uhgu;vOV=[w^w%jRrUFEm5XM0Tslk:/eq(e8,YcK
U"VJJ,7l+^-4Pj-;5hr=i,1d^^;M:Yt3;*oo_6C*Q0wAvVnzDg0Ah]9udm8kF(X%M
U"f*G0e,[[J$\[T;TY%=-UtSl94XSALGnRfGWh(WRXV\b$9k'qS7jcm3vR91[_('#
U"8ViENYCL/7%.;$03kW]Ep2vNsrlhuUE/F6hg+%WxHkZ.cffZPQ/*D&73]A1_a3Q
U"cB>e_['JWz4T&%9z7CZF&re'QY1DWb>b8%.Fnh_K4l_l+B#+VTNS&AYL:h0,^=C
U">UVf<IhcRC?cs*Qi7<:Wo_lCNUC<JH;;yO/\p*gleOuLk(sZ.jO3i'aU0&_%M'Q
U"lla^>P<rXK#B:CWR(R#f)OcH#QR;:%YiB-T1&i<+%+w>rM.4/eH,SEOQ<G:g8j#
U">XHG(?rk%(lTx<E.-G0+tmv/2#I)tg,&.SifwsU>?PD;i/vs?9W#5&Uh:Ih57&^
U"9[lTS]/%H[tG7/A#?ic*);uF#(uBrd9If1?c#nA=gTG^OWE%RX6cm_FgB8k.=[?
U"/rjSDtHKLn4ROT5O/<TS:IlFib/]T%Ok#uyZdo?&G_E[VhBt-e>f'kVf/=_Q\1(
U"1$&a]Sf\W<1wZM+Gw8C=^?TOfW5J4+5(t:^K5'$ZmnOa,5:Z#se_d&32YTSl3Uu
U"wa'*14WcAO0%K4<8r,SOLF_0htkhI4]$+]76#U',(1DZ,pQub7pV'C1Ne8E*0hT
U"gQg#'=G\gvYXOf>Rvo?.WUO,$jYWc&lyVfm'vu^5A#+LOl6Z3/RbrcZ<MGVW\,O
U"c**>uB9C3]Nvq2k%ui2=38P3ueGh_H#fpR9q1\FMAM>;1]:7.r4-[9LdYe2t*v(
U"?fom^N2E\S.aBIvtzoKO,nI08&O':%GNB#^%qJX63^-_Sr.ev?Jr#Nf6$==<1N,
U"Bb3iFE0%&I#'h[N1lTxAP29C+m4nC/]PWo_>F0(_doeH\:+T;%)r0d5#>bQ'7lF
U"zRlu4C9:mJO.>6;FS=%PUC>x7r4E4sy[<)3N(Jo?;0QLw-^,9Ua/:4YTb5]Y>fs
U"D,gXHDTK'b1ciH''er&-,mFb/hP-h,#.<2PX7ylHEmF9Zg5b%b]c0gw41SM:Lug
U"YaE:46E=R%Cu+LX'o.]:S(bD,9r+fholOEC]1s;g%F0'tW:ug\;G$#N;]=msgJt
U"pCV/yH8%?[_8*ff[r2/q3zkf7/icF_g/\wg-I#8U?TI*p+b1)JWoXnZ5SRAGLF1
U"aR:DOL'Ou%R+OXtj2E[-u1qTd.VX#RDfwQ$,EfQfH2U:N?yGmO?T%PI6]a=tm_c
U"C3']d60S2;)YU];f,]tZ+Cj^#6/ydN/_[DeI(VIwWHL0$[+xErFEIqM_J:vTq7v
U"VtA=O6;u+SkaS#=f)WTc%Y._gNr-5[lX5E(lm/DHiPEX8>Mj.Ny4o+&Ry#E(gh8
U"P/L_J5BMmQe5?REamvCPVgw_yENxpd^:B9>fkG)FT)?(.K.PWA+v2&c?#3V+\wB
U"*u()5>]e:R5tB%+Mb9B?x77YePYb<>OG-MZ2=3mLWjRA8ebW+;tSS][^Nl^&qO<
U"'H4JB^XbV\q5$n9Mqb5;3>Bz*?0$3Q5eY6Qu(wXF1dNfsKkhTAy)54Wi6ZDC)-(
U"a<Vf&]a-'5GAbs?TYJIuXSow0Vaf*UPg\:G7G;Iq87RV1)kZ,zR?5[uVsi(5A_n
U"G';V#bW0/Aq$XYPQWk6U94Ie'5+*O6$;7^V/cRL3Gj]Fmi&?%1.T:YtL:h)ji3-
U"$\H:/FBx098^*;1;fba;/6?QI8:9MVev<)QNY;pc;,_;:=y5,bZ?AbA1e.O.mBr
U"wE7AM&V&pIlGFc0n=K=G\&l[#q5MGTV;a)]%(HKQ'20q:gR$HY>N#),I?HN5&me
U"LI$I]D%3^0T?h60_A?474D59)1J)?;Eu?xk^b6$o/;SFjzK)N+]uZ&n'/G_+KOf
U"'V]fe,Q3?.tLcntkKrV+WQf*kX$f;mgVK.ElkgK$%aOjKF/;o(-D7r1/d,5vhG1
U"NGwOM[yGjol/\mNK5R3Rg#Nsjn(+:QxU]c]Iwn21obEF7+2r8d_*Yr<xh'V%Hq/
U"eJc&_ZB.QU.$^C*<3n(,0kl&'l]ZR8,L-D=30z-mPkQKB'V5<f:<Grw#_\m?.E3
U"8-SQN7^2aI'&N*zAYuDbopVRSVb,LFkaTRw2_AK.T$1xQG,:KATA=Y/t&<OXNL^
U"#:r$t6pdtRWXH&-PPmmsc,R$P#_Hc(XaYL85Hj]\TbqrQ+NKVeZe'wPbFDnSxo3
U"907EoIT'U/U7#xEuDup0-Clzph#sF=j8V3Cu[+[+l76=he;xwqP?rfPmKA$:=%I
U"<&'Hu1r\g=eP?^u,o509-xk[w/;E&RR(hae[puP':n#0*52z':r]^0TG6E,_9YM
U"pSZ9\D?0EH6(g.al$ZRf_AY>fJ_hQ$F5UmKmB9H=PrYy4osX\p[A(YULMu#kSs9
U"%O*DXoQtmi9w=l3[,2]LDFsF.,,jfhr<iasTwhc\RmBKC#goxCZ;pPzKQ3q:ZHe
U"2Zr-A#UfA8\B4t;0$KMMR1k9b*:\%cc-K_Gt3qZ2)6ZSFI;QmQL6r&Xge6RSart
U"6<vlff:GeXcM4.67/lb<^S[YCL:6upF'Ny)N#y=gz7zzH2\/E:iJD2'iQ(X^:L.
U"U<?clfoT8ZTiu$%Q8BCzw'b:W2I?kDQ(SDcJKLot:dVFP1?^bRU=UQL)WerbA>.
U"O+1)tVIR+\(;^q$D%D5oop9b3lZ9A+eQ?,=Kqcadir%r9PZ2gY'^(?5<;jVvurp
U"xcD1k,6gL>,01xe6^R-<Oge7IEj2u9svi%JO;TK]eeBN._RKBgeW>N.>fAR*-Zr
U"S<heu7WTxZ_F:NuxdZJZjBT>dt,6XtLx<44Dx2J[6t8jtAv/^6j]?YV%bbH-slj
U"[rDZrXUp,NfP&PZ.Vqm=fl;Ew49ix4xOMMVDQpOjl);YdxFl&/Ku66\PXECQaA.
U"DvcNb_3w1;.fI$L(UED4c[Yrq#65D5)N&?h0O1XDS90V0?vU81'dO9]^_AGc4>s
U"50B%_B754;l,&$<,U0K^=^<24;agaWLum_a+gGX-SaURTc[e_V?el6*<S=BYT<'
U"LMJBcW4iWf02^Bumb#=Z'EcN'k]ig37_EMTJuufI'OQ.Pg/>z-\r,0EBxm1UY2n
U"Z+;$q\S/)g93rOS,T[iGRhdO5:/]g9-w)ssBel6+-lfqQ,pX9D,L)5iux(*B6xE
U"3u=7Iq6tR?<n=+U$7bzE\_=,=F+SD7CDZuCm<KnZlNelmm,k7/jrPd81stfPbdF
U"1UHDW4(B76,tRj3UDWYe)UP\J6rRc=Q[OX8j5zqm;hiV3Ft;at5Yh)G8.t^qKqi
U"u%SK%K)pN8_/jPxNSw*XqgS2q/1wrJ>kL_(b$b[>\.BK&QeS[p?x+;EeVtjse/M
U"Cl:Rkg>*=36_H'q33V/Tb_*$&'Fr9eYuAsWeOp(\s^>P/V7+4Q2iFz6#4iW+D;8
U"*<f1\Z5+BGxPt+urigK?J'm8a]=Q%h4?r)_l+=%0_W#7,Jr/*^CJ?_8[6F?HYf7
U"brKfQom[vQG)w?p=%?yS#7ZUP)#*SfkherZ1KWJ)D=NH*>%m5QdF\^t+q-ZghA2
U"X2K8W7(xN7Dz,/raX/sb4;$J_xWQ474mbsWRKPMK-qa$sl*i_f*Lg:zY/h<[q5A
END SUB
SUB V2
U"CElf)A?X_kkvYiY//EsZqz='SLRO%Eq8RPO\+<$UCjzuMnF<w.Z.IEPjZ:j.A=$
U"pWTs]Ce,h=BXQEr3vVVZIZq^&QqIl=K#>v:hF2zYJ/PzgiU1#>2m,B7$oj+nfWj
U"h%1l?CdV\<Tvp:O94O[E[I#AuT6)wdxnM6WX_MFq>ph04GlL/8:1pR,12S<FPTP
U"\Pi:,WXCEOpQVo/F6N--h=.h>2D&>i*t<bxCZGCk)c>DkTlZJm1Sjc/=+$US3<P
U"q)\a300<N:'=ETVg%f$?WxvG)k=#lBXt)\N3NEoPq7.j-?AMd7F[488W;JUW(di
U"qrj^*rte#h=9D)<0jZdk$x,+tEx%+*;AbNlF55+6PvXKWHYN2(u0I>hWW[TFY$4
U"=,I*T6ou2&1nmNI&tqX(838[:W-I=m%\)7T$]$-k'ZZajVSCL:NRoYGTeP.>]>Q
U"-KewB3NJQ\RLM].L^SY(]qji'EaDv$2K4U=R9;uiRduA-n%p+_Ao),&N4MC3a4o
U")DZ1fX-=*<\2W2erPLS'n^t7Bl>&8vSVVDC0C90(z$ZR>R:PVWgaP.I:rNxwW35
U"%5>G$=J&_vGN%62FozR9=rLOX#9Xmz37wkv,[V0fSmtS<7t,OwkaaJZMVgS<mch
U"Nj4QBq(u3Ae,rW^H+0<Nfo,64b>gPw:]*fR9fsp3Qfr?RrN,Jr[\9:m[fff8SMq
U"Iv7YjRZ:+Q32,'pDu/C(]e<T/4_2hqGYOY8GT:,?7\u=P[e9Y-c$-notsQ>dImi
U"Zlg[Qe=CU%crIV0HEk+Pn7q2QxULP.Tf2pE[mdRWO.&B1AL;6M1cJ$5O,A>f+/#
U"56pg[_RYDjR(B:TD[,ulQkEtd9Q41RD-Q-bw2>F*/SYZsof.%#e;mZ*>[Tkh36/
U"R^p,e>6gf89*pLkX\v2F*VKg>I#hdZ-//HMcGl+xnlnrPdtDf;ptdl%[RFq]B5o
U"NQ$c<9As8sV6gNXSz*=:ilhtd5?ZaHFiX2o4YRY5[2ApaH)67.tKJx[;Zd8-FiU
U"LQ$G,llIsA\iY>S_j>,F<Dc4-vljRTKD/n#Wy8/Nx\h=Cd0W7_hFfBCJ8_\+d)L
U"gAV3^4X10Gec#E\w45^e>HZXRJmdr/)gN<N6>4s:1[_r#HJo6ljN3w7o[1PX.+?
U"MKK0,xKRt)zCWlq;i-q^aMP)?44_%,y>^8E2n9J'wP'M15YU-N%Ok$G?f[0iU(*
U"TY?_40kS?9Yeh<-PT?ChNP0GVpXUU'Pn$N.zEtbp9/M%60;=0KoB*pv2+-iKf^G
U"h,8=wP/)FIQ)8^u?B/bz*Xwuyr$9j1^ylo>p%?c^=Ah]sZaL?I3u#bciW3k^Et$
U"%jP&w1RG[xG%?3F,=6-xSSEdq#&Q8QoygLh)4TBcdE&BH.%h.1h6Yl;YOAyyCRE
U"-H\_p[rNtImU,xTew>/b<V2%*&7<dj-%%YJu\%2)Pn#'=]>Je+1Y3sJSjWfCav:
U"+Q0FDwf<=<bfSRIRq'>nk<NI50l0c5,uNF??<lGRg1#?GZ0jle4&FVYxhFs9rnr
U"BO1u6F6>\+3EAZs=eNMj10t:BF:GTSUJZM:>>B0onfmo6IRkmDH8k-MTImX)^=L
U"r7WFVM4d/9FCX%P,b_))),2UUl^?jJ6))kP7'8n3cl2m$DB&*\Q(SAf06w4[>GP
U"Bkh+Iw^chLs2X%WV*'hB#%l=xgI#X47R9rdF$L#qF_,.CQ2BgDq;)A8&g;F(J*8
U"KuHeT:2:uZN,W].A\ZwWCKu>S'gXuV+Sp'^bvOATfO#'oUJ%2h/-MZG-/JnU>T0
U"aK1+ZHip4?La<N+]9;(Gdh3Ui[,xkzkpG03p$J=B8aVT+>g&*(H=DMpmVpGJ3Uz
U"c8-m_OpBu,kHq41U('u7Zw'=],c3J329xn?2>R351D1C:'^ZE,F-n*bMjg9_E^%
U"bd,E6[,o,a(Eac6a:XKQ(Q-%=Mgt##=*+5\jqaV(42eF<Gi,3fcpKZroq'mf4t9
U"VoQD-R+kQEZF&'o=dlZZ5luhjTh?G=CCO;H^&JR7g#RnmeUY\,'KHlfP/Kfah.p
U"$;:h]YR)\=EjJZT,-Q_?og2nIpXNKaWHlFd''xbt?)#v9XSvL(UWSt^%1nff^W6
U"69F]kWG*AQNgPA*l0_g&mG'_c/.*RVMks.:7?iv=Q;x#Rgg:eJeR7'&+-_iRSm(
U"I)+5coe-5a(ogdiuDCUc7Mo(&:27jT1IT3EX=t,q[h?1p0U5WJD,rQliysr?BYr
U"Tus[zdN*%F9XjK$qXs(gdSAe3+AVw]lUe9-YF&W[Fp5BX=/#&CQv#)riZ%&<=DK
U"uEen90D6\65pW1).\M(z.Kc*?:p3cKKt6*nD\HCWoYY\Sw6an,DF^=E0R#[K)z2
U"mg(o0?S/$d_YDlZ.2tO,Nxawh#'7t^+M6&ie,sY,5<3&s\5B#M=c=W61Om1O0h:
U"[*V-1cUBkgMmyV1:s)xJ%QApeZo\HA;b?tA?:'#Uj+mc-J*<)xM2)>?,95=xMsG
U"nV/]u+$9Ldzc\Df*u6S^c+SW6.$+A;:Pds5vND;=loSMC>q=gHRdv\Q/WO$N<(b
U"NI(U$NV?2q?'2m_ZrgeTp%E&r_q%-5t(c,VlxgGpZeY]';S:^miM,L.V5y'APZ&
U";\lDjx5)j'was%6^If-&UN%z&6+)G:'X1Q:?>ke>TkMpW?h2Yu91jz-k+=y+:mJ
U"M]GLkEh_=a+Qh1[.km:(<K*QiY=Jmenxpe*Wx?I6hUQqHX]Y;Db9lB%^[*pf^gk
U"9lk5Wtmk6WK&(j<?J(A[YaA2W]d0w&20)4U<QqUYF:l8G&t<(=4(HH2DZ/Y<^Pv
U">dJD1RH-ZYIoG0'E4fmz&.<Wx&Uh\Ojzg,NuBe:)AUz3U^;'sS1_'%li86%uev8
U"::09&_4'hB)+XQj'%qjX=&PEb48L=SN1%5DOPD:Dcd_wOr.jNnusmHxrrMHEgUR
U"w>pAd$jnRGhhulwWpsbhRW=^#o%ZI5]Ug(_RJtE<j+g.qMhUEHR<FHabDrM%gg#
U"Q#d.;Dp7JAP^)z$higv'M1_n_9)Bi9kmDE]['0Dn2d&h.aW.\_l0q,H%du2L?hI
U".GD>,ruRVv?;z[iCU-3OxQk^Pe:DDY_jKd^LT\8rs%Pk3V$0zrP'p/uo]Q3\l,r
U"UgG2<EEnFklp6K1gS>S6w0=bNd4r_5Y%DAmT*eWIWagLMNr>slB5>/Hn-&I[v#N
U"NW3Mjbbs/d_xdTo([/n#PfNhf%x>QDC]$I[Xt>INhOD3KL\A7S<3<TorKBE(sZA
U"./9(I>OSNlxVVVUq'8u(MXO*v63u$R?)eCcU2OrXz#6%v>\bhJuV_sqk]s8FFhF
U"ZBqc[1X81hA3i^Ir?eLBey8.*K8mp$-+v0)<RF^DhhH\\8+yQ&uO(J<Dw-$FO+d
U"=YxUDi$H9]Y6F:>dMCPuiSH8\xBsQzjJH^+53'4d6MVK1qK3B(UIQcqXMy3)mgT
U"7,h6=J.^:DwX$RmA#E%Gp4pK2+X>)3&,9Vt(_p)j*Jl8:saaNm&.x]+j,QW-wR3
U"/B)wo[Ng[O0?Y^z256HvVbIq3i7y&6?6khB_yznn3v;xzK^fqDH,CZ'OSa(U>]^
U"\NGdH5gY4lk$\y(P>e&?74abRa66C*pv;,LrgUA.drd.RZJ*eu#pB^]Zu=yG'H%
U"HHln/2G1g7lowk2[Kj_]TA\XWosb/t+k<J2\H>6&YBl3:4Or=fi_d(bD9(a5u>6
U"?_AddO9p%j%NHge2u)5/GMAAmwU)$[b)?m<T)46?V#(#W\5u=]QB?pMeT\OBgD<
U"MP$Kn]Z>RVuXF)_8mUj=F^#2i01VZ56NI>dDUi8d:.al)Tc?6#L(DaP%c]8jlZw
U"eqNP#Q4jef$=)spP2roFlxQwI1%j&wDgsyRsFVuw+V54hML[v4ECg?nA4qUv/r[
U"3l,DJXS4I$sr.ZT3q7\?%Lm2X[LVAG6e=T[[plw[#Bb5sQDotqjqRmNBo%CW3se
U"jJ4]==+Mt^=r*2EG]4/Y]07>-do[U0hmGnDl&]cGN]?uLLg5wRT*ZbXIN0O/w<Q
U"J]7XeV3JCi6h>k=rQh7acn1WABHjL8[$Rl8iNggS8f_Lg\oFVcdnsO(XbrjQhu1
U".rUd5Ot7SQTFKR^LWKla?:Uh8U(_9ko)V0Jwqw[WcXD?SKRKu5VKuEu6aB(XPt=
U"TD[nDM^gT&SKoJu)s;1vnkO44b^cAR\(/[FhcIDd<S,vv.qsew)JbNPE7rYGYsM
U"66P^W^)1DM8UCKvn$\w%CA4dVO\m>>Kq9+$lwF:MZzUo4,y<MeHdIu4nc/ns\t4
U"pf[tkq*snlxi2t\fpO8]D6dNY/6\/',i=Lpx(_P,_YQQdcpL6\r7+<:Izk>br/(
U"JNU%lz5;EE#abGBN/HfaGC+V4dlwk9l2gwph52wAV%n?7?=Xw(<VZ]:6=,gq$Aa
U"YFChcC**$I0wAZIaIwJpFLt+v<HH]g=f&Pin:7Yvi:psHhsDK<H2tG_I58GK]=8
U"J'M5)W.7]g(M8yyE]2vR$<tdRjGNMb.bC&=jLVpxm_$u^n]/mg3UtZw8ZuDaP(f
U"3zWGxceMj/McfYB6LHoNtvc_fo6%kWp2_WFB[W/Q4iM8Fx:[u\T4nNm638D.\k5
U"'r:btdxbZG4p4xWtrO.Z,-TwY9_[(VKK5,?>hI[&R88Jhn=l4)C0PrV%*B,hI7.
U"cmYKRHe%BtC8Io/:mz/Y0'jrRCObFgm>]2Qtg?]&&3i]S^>urC4sLR:c#I$ylTv
U"7fau(uVC9(VJwnW_xjR*vQD_'nZBdNkY>Jo>1hHe<^Nl+oYJk=w].lGXg9tzEXN
U"ssYcmtt:nPJHgW6ndd2[L2T(1Gn;Y#Ly0YG2&0a]hz?yi'M.Vn/GNkE'sOAP#G9
U"kX%:/Hjc*;Ujlb-4G=g$\IkCquuS8z^J1<KF6qqpe%aerl<7_M2sBrXx;CvgHm&
U"C:Gx=a(IIA-y],(Q&]r/;ygM.[P[<E4+vfOc.TG&+1v]LsKw?>[q1[S9)8b)?D7
U"SLsqeT[_pRe5NeqlnhtVYHxC2Mnb$ur3g7Th)DSm:Xlc9NCjpfKJ&,<#Gq'5bi>
U"6DZ^d.<wppDZp<%&b\i#Vext?.KsFHsvuS,bqNSy,x\bIi,OslwvcFHx=T.k6&D
U"kLja;I)vy?PYq,0Mk?:O#CVN[#:*/2<EMTouQLg$qIc2S4%w.?698oF]up#;$x(
U"hqE8=-NnVkip/9)Ni+HqLYGQxi2HqH\UNxn\<fvSF'SQrtriEF\ZC4:'N7i8q4p
U"\Px6FKi491/N7xBqlYT_N2x-'x,/LAYt9]I<<i1Fiwp06-cF7q=C1*l:ViW.K\^
U"44bCS[2RNKXlq$H;$xkLunZbZ8r_XwxoB8\HB.^Wn0PAhTq9]E8V8PEN;=PEb&*
U"/V?'wO[y<9(1\E&uGIhc$*;^drJum^RZHS:.xQGeiD9bXut0siwh0jiwn.RiRW<
U"DT)Y8k\uj.H?q0</<CNsky-#.5hT\*jbCS0DUNn:Wqf0Uc81ZuWd*<NSoRu>W.T
U"x+Y*q8=X0x0<]ZDT:dDLpvfLJBtI$^xLY.>hEGjXr^[WTpi;>cYdOQ:N+5QXvBo
U"uBT:aDM3wt#f)viF;VwbnX3vc8/ButjS:(up+jXTO(N%^i^WFc6YD]F*x7T1>1j
U"<Z/xV-ZQw(GtpxV5cJxCW6A5]\7W4okNxVGrrxr5Jux*WO6w0]cMFTe(E)i6xS^
U"zCcJGXN>0q4HHox8WA$xq\kl8e\ua#rExdKc7x7MDMGTO,.g3YR)q]mfRO<qg0d
U"GZR[*VB,eNE[qlhT.ci.<mPx,aDqlto;DfDcr#<w>#7iTrjT8IF<w7.iqDMiZ4r
U":nr_6d0>IUhI4lxrq93Du>SMAxMWi>pR_NvDulxnRx74dqL3.VNotJq\T3<>74u
U"x3oitf/0nlXJ8tnBbCu9OCwdcS<dBaDwNwui#t<bnY4x:_NqpuuZX_F4x3N]q#)
U"9Bh>%Ni(O9l,F4p80avut=%u2&ciH1Y]u#%xT+%q*=*;hB1-N?EfuFPifH1S87G
U"5wtm'VwHp*)?8XUhj;uS8scTav?r4Hu,$<;.O.iwRlYa4b1x?1GiT9b1xP,lZDB
U"1)NC5iuzRY[T.gwp#Q%rj$VLST*s:I,cRD)]x$fi]xH-wm#fixmT-w>,,YTyegQ
U"Y3n/PUW%*l&,-3YMEo4Po;;H,*<c7R:,PoR.4?x(ujUL=(]UC4cE8Rd1#ouVVYG
U"^d+NRg\qfWnOxdOCAN&Ot]Nq4L_nxRbVxkWhXrvSJT-N$(-[frh5FMoS6Ne+3nM
U"8oW#w*F/,j+M>gBIk2_hVs#GE7tgl'pGVlkNU]>nVEL4%kTf,9(#[%l0P58DEc*
U"X*3LMNCESNvwr.3oEC:)Npf?A8hE0]d75/9VD5'kdX-*l.t>9#d:W6cK7U6cK;U
U"6c+GU3cAKUG)WbgftD6t4^'iB?*Fql^>LUu>#:iTs3?uTmZ)lhnW5-;RThZ.1DY
U"mD%b'bde=)IwoK-muo.6arnnl9xETWoN9&$f&Heop=2Ic8#(+Ne=Tub<_bN8U]e
U".7Uu\.2hxf88U7d]8Uwf87Uj\NR1\$XFI?2Nv$=3xU$AuxmTbtD0J3fxfhMt$id
U";*ZNIArw8Ziq6U<x88]u<?;Z86+38S'\MN'wnO-q<+GYDBY0d(DEHRT[:dc27=&
U"x.-$qbHZm\j;xmhIu8Xk;X/=9u&k3:.FY]url<[D[?wlaJkxalXFxT4Axpjqg7q
U"qlqYpMWQN/49upvNin]Q$xrMq7,k<dCail0-Ji<i-<xxYcu8ix-nuvKUGU#NjVi
U"6>'9dL+lwp2QTwViNm8(x04ViNaa+wT?698CQoul#;MN;;duux=j4TCk>X08#GQ
U"qd]V]8nAu<7#i\Jh)NZXni(k=)xwn0i\h1qNjBi]8^>wVrbhcu8g/\sTlXn1MB9
U"/iu6u9cxJ9qoHrZqnj/xD+xZd[=:w\x3Z>h%_Nz)qmp8YXe_%N4r=Jo8Z'co^gW
U"-Xio$Jku:T$#d>Xixbs6Tx^Ui;xDg2gNsm=Ux=R=Ux3m=Ux]X#)v>pW/tXt4)Xw
U"WhDkT9uv_p=(uX?0YDe)$xwIGoxnAXV_SunmsgwH7LFx0XnAxv4I]Nb=.rXqW;+
U"eht;jXZk;,iwglheB=]xonZ?r0.sWEbB#UTmUNrh3g$8i+l_t8UPj[;+H:-B%6R
U"RdJWhen5]Wjv,wiggv+EHl*MIlLpQ)IcnZ+GxWH6kX;iQw#[wE>8H9$jm6.QqIW
U")'MrfR1?to;%(xu0m^*lx82NAdjY>k88b73VOrqEf?31bv_5=/kh.gQuI0:uZeq
U"9g$;uq$<;uq$0sxJlt=wJl,sxJlxUoTr)sOEgLQ*$zzq?c[(;Esl]jA$0OPiZnI
U")cx\BKr\g]-vhj8$uf9Ga5PqA]udKq<tu<dmWBwJHbidlj3xBbfil49gDj0hu(/
U"NrP&dxhgC4mC2ON=+]u*>QTxRCO_N>+u9tXYdni&x*s1er3V3q$J;3q$,V5q$bs
U"XJlLI:kWJ;3;XZ;IcrQ48w>WHJxf(Qax-(QaxP(EaTF(&wjm;3sN';59jLS)9#Z
U"<utXd2tw>(2<ANYqZ]H2v3s;>dj*MrE<LHiTZF\r.sCuh]*:N[4uwHlY^dn,xDf
U"H=Na<lUw4S$p<run=oFDqI)Pp#b7I*CK%mr<;cQo;IcGHmn[Q8(52*uLb#3vND[
U"?S8jxo1/OcINAHuUdT\^'1^Utni(l/K2U>ns0lErZAU[&LXE>;HtVc>>:#Mf<B(
U"l^uw$<xWmKgHf_HB0qKmr^OHlgKA3cVnn6crQ<k[r=m*NrU6l_r;j^r5xn,7/Tl
U"wVic#vK<Nr=:rik>DVxRuc(KT^HlF<l$r>Ai8/_*2p%HKXyO$i8yO#nn*AX-[(S
U"v'4SvTJTUNccu'%v_.JV?Q8T1[lxsZJ'w2<HNxXZ$]8lFkM>'W)[i:GxW&TAN8>
U"Fkdq.Wu8sR%exiCS>H-U#aOcJxMln,FuPR0VwM=N]rlUF)Z%^FIf0a9,u82t7T&
U"OpZN;4Nupp0J/Tj-Ql9:,0_PSo;v1L]6[bT-'J<PA4cMQcx,Gqf8MQxS16u&YYY
U"x#X*ux-4&x\:QiX+P8-=+7Nw>%pL<M'Tb-iT_Ho$yL,6\?iWN#aqLlhk1Zq$Z>a
U"G8=w?>>i<C;29k+S_MM4ktNwX1x21ZqVO/<uJ%f<w\PEfx&:EZr4uh7KuvMclQ?
U"qu,P98n;2u8W&Px$Xwqdc:GNHwQ]Xqcbr)9f^dw1vad%1vhn+Uwp\d*xMzmN&ql
U"[eoBxMx-O+x*4EinORHxVW-hN-^oHX)CrP?HI[B;4\/6wt;(9o'$\t/wlR=-8Xk
U"N-Nf\Z_o(5u/&_s18^Nu$?28/08_jUiwj=;WqFW[TlDv56]X0X9kd-:TrDWY$ln
U"4/jGx^/kqx*7YUwx7O#un>Z,qhll12Jm1MBB#>^80HTx6T$kN]E]lxqE]^d8$ka
U"d4Brl(VXucPfiw2jE195;RXvgEEpvhlExwTT$4idXdBw.Mx6<luK=]ch.#rkFU\
U"uaboExN?J_N90bQ0csghwPMt_Nr0LA8f#c[8kvo0u9nS0>_NFDqM=9\90bv5uj^
U"uRDcZHN#Nun*]6E$fH<lT^Ue.OVrRo^oKgdfr$lnt$2W$MqnfU4NUj6eNh=WTXc
U"+UmMXTb-uX+lYTa='x+HBi<DPc8Hv-iu_rQBw+y/fu4zY\ht*?'xX:=_NzPI*wJ
U"OU$wzbvl.GW/;F3YlbhPPYsT(YjnN*s8oHVmxha2w>tS\5xS?A.g8HAvdo$]sxo
U"p8axWUbaTSHLZ.t?+KhFGUbDkC4zOq%EN*$gNv_oxs;8To9ujRsFx08vVxlnmkH
U"(Uc\o.JN?hnp_\Ex/F?h4eG,hXE>>:)ocwn4ck8C1lx..rmH$Yh<T.-6aJ.34j/
U"jb9&fP^24\-9N\pD6;H075mgrSwXIq-xdp5:Tk_&S3g=(m8j'7rCKh^a6AQ4tD<
U"iM?58QqLM&RiddwMNOwx8.,pr1??VvR;RA%&3#wGZ6Aws>Ur4FB[ekdEB/WS%Ak
U"3L^l_HBd-wbuKVH?.Pdju_F>]aAr>nnPOax)?r%15[Pit:mT88%:^=>R2,]UoCa
U"H8Kx(j-IT,bxJB-EX(vEUk5x4>RX1jG4aVklgrXF:JXlI6Njk?\;oLeBv'EsGd2
U"W?FhUkZ*:p&cv.60(&2\Gqj_FA$_3=rOIrqz??r4F$[AkV(m=Kd&E(dJ561RK3+
U"O+ir'N=cu(rqlLec\[mYnH&/_a%<.afmLpT_wnT:e+.SLRuWLWO$5LY/m3O&2WK
U"K0F60ik'2OSZaX'I0dq+2/s$r<:x]kB+nX]X*+Ib8<sgFtNoM;e^M=FO6BR;<Sa
U"t'.wKRnlUfe>d^7F4V4$P)d0dqEn%H.ZoOk[WT/Q'$977q]I>lubDha;MXi:6<A
U"(qE#(<);V9]7kWqHT=vV6hpn=Zk4HV%W0RcwwZX6x<Lv^#Nr_RdBUfm>4pO:DGw
U"spr?xWIl8N\3kVJG*F:Dolw)]nQN=.r-uZCleN6([TtelF8UTDtg8N\keV$Vw)l
U"M4F/NL'8rS:[(4vw?#faT<x4UkV:[PqYifPQN>V<o8[ZUZx/K#dK'g(rP8jkr*O
U"HXAG^S+;i/ElV4zqI3'cP#A.bNul/lsnlZ9;V_88f%l8'[EdFH2$nF%KxfeC'[=
U"F4VaNdsH>j<qmY/[wnfQe;<2gUnTgKtEH$n,A884/yR4RuW]kWH6=gga.BgGt_t
U"vAl]4*+>T3Otf;\Mi.dn\mZ]5;+[a=lOg(Rco?agt_jtG7Zlcqb[]MDf6z3^Khr
U"Woc,cs;R'fIkZB3RR%RuW(w>EGmZE*_dn;zB.XI%]HB[IH,i=oJA(9+:KZlco15
U"-<E^l_HBhnVQ8O16^M/&iFCQ?d;3P.k#AaKr72\VapwFe3duZ:u\P1MM[Y&[qG0
U"6An3*ortkxZAO<(lLZ)qI6Je$u+B^]k-k2k+<+fM*QPAoms3N;8^M,=2xg+Dose
U"vGNi<3soA6Yam6ZiPbKu^<KpXl'eTLBvYlENEsWPRBD+0LB;<lEZeAW&#EB+<6_
U"fNs&T>\xA9tHC24k;I_ShPb3i'Wb27;s_Op]hdXP3'Kbc2_r_n9\#vMWQd>sWP5
U"BG+fKB;ljE:n=WP/3B+rKhBDiEDD8W&8s^glDc>>8rB'gT<Ar]V]kmQ0.gW#ao0
U"vkJl#.gx(5t\H%b>,c+j7Y.8+ngL(4_#LGBHhuXtN;^gMh[mFWr/(Ff/m/qjblA
U"^*3.reN.)q[6jo]8dLk=VHQuS1afGDlv'WWHB9P^8U?tR6lHyd?wkjD'%>Y<__Z
U"m%;yb>Tanpbx;)?uk9H2kKTr$beKEv_KQhu:MQv8THWvnEd>N+AIQ,Ba8FaGFn(
U"XA#Jc*ks_oC$##LDqSu7aY83lgr]sRB]xR&JFH:P$h$=exY_lNBT30ty?r4.FG%
U"C4_]FEbN1#JRDq_ac,Ab]aZk\+TR1Ijg1kp>Kqhc8e[YVEFLXG^baxH4_tPbA=9
U"kRYjRuW+Vg$/bj:]#kdK>1[B5i;bM._.hc-iHC98=bG;HXu4fRdl6Lr1\w0EZqW
U"h&V9]SFl%L7>3sBg=N?hk652]4R+*KDJjAgSHDlFUjC%9>DAheiw?VK:dbUlBgL
U"TbacRa_1G6b0TB2R)\[diRo>m^]GDKbV<pkBFA3M^bdammE6J;^M9hXK:c+R859
U"$soLMVa^$sXAPAfft7Z:lch>fbd3#;+-$EE#b^3jS2nuGUu[&I0dq+q0shBYz](
U"s:ablWD(F;'DnKQ^LbavT%DvSU3KfH4c:h)d84lv33UNS#b:AZiWP7tV:$_wlRn
U"H2\]5k+Fg+vb(M$.$.lHOqxs6^cetV_P:>\.n3KrB7N91XbT4JHb<fA[B1LGSKQ
U"8kj'KX\FJq0v64$^HLlWUG,_Qc6B&]DCALHA_a_&d0dqUh/s5lAgX^P2KP+jemG
U"DleHjge(Z.0d)qsXwIK^bk#jcrM(eMiSP.9D8N]hT)9q6^QmHrH$:zlu,$cFsDe
U"&dNZk_XPrF4gBCUCAM.brtt):Cpl1orHR^28-HF/.LNG8R/9)0KuojKxHYxWYpr
U"DXKl$.+Ak$UQx:Ld_$)a<Yz9]78A*r^;HX5go3T[vf+j)-CdqY2;s7KmquadAaw
U"k(+6>,+BOqoJ%5bnFo/c.[YD$+nMCkMl-[J$d#9d7]8W]jH8KZlc*h[s*E32dCH
U"g#abA1N3zJ;krBD;e7Zl_cNXK;>T5/+k[Xt=4=h'4x8t3]sB=x/?4oR_ckr'FJ8
U"E*O9j+OdQIZA][GRS7Dv'94^aFEYN186ts_D9.MWUQ4IHaC?HlGdrRXel95;rX7
U"/HFFqfb>]PV]vs9w*WHXI<BT:T7Zl\cWkSjewbu:4(tj/m6ahZBR]1PANZ)0q64
U"XaHfE(5_8b2GflM_%Arcp''G\S6P;^M8J>b%MHlCHJXH^c6Bj3ForWrc:p)q6&4
U"dHBIET$-jP9G+kSuY5Ci-JN2+pTD=vwFm4\BpP_HUlwFkWE^6&[L6\AfV(dy;:Z
U"Ulc;1+,v3AQx:L)g#N\_XD1X4VsB]NsnHNYa]kJk/27n^5drhxDhn^Dc5v6^]0Z
U"3saBADgp#[MwJ4CT_bbAZ]j<]DkY&+b)e=H:.BADvKI=NX+ak7ewMlCLT)hb(n/
U"hqNj>bt(okc6[mbFk8KAHBdH.iKbk8AZr:-r#_R*uWGoDGSl5\b,n$jw)%b>Lm4
U"G0sHt3BsB=NP?PppC*8Eb^nL>(U'bXb:d_qQB-Qc,9(jtH(ol2A_*3O2AaapMc1
U"Zcsn,6v5_rM,_,.1b\]k_db(lEHLn_PB,B]z7nU<frH>##TDLvi=I_7MBU<qS4h
U"8M,?dWUlanam'JPS$<AEV*GHb#1Fl$Uv*-7eNi(9jmh$hSbC(A7j7bjr?a\BOj]
U"X&c.iHCRNksU<ueu\ERIP^QlBM3%U>gs3XyTDav/VKO3+kK&baiC#KdG*Q8?d1u
U"]UP-TiHCKmkOR?9N+]x$T8EHYaPBO(B+Ho-75h0(dqyUlK(3PhlkTBZ.]3lZpJh
U"Y3a*E_iaF/w5RtJ?Bi1.h3H__j/,Wcq4L0b<OnV==XB4.7SNij1;s]4DGQX.%=a
U"T;F98(lD9Ubat=EDA2l]Psp$dk*AGM]iAlSd)-1dqsU<K9k0l+f-GE53AhOj__*
U"iB<J.9iHCdI=nIR06eEK_VbHA^=AF2/]QLhI0dq;q0s&]Ul3<LFa<E*Db<n.rK^
U"e*#t0dqiE4srr]r^5T_uwO'uSU2pSFIhH9u(F8][w?h<N?$lK/_U^h-G(e_dfX6
U"#oFjnCa6?aF8(rc<v9vlTA>AY>B_>8QRB=<kHkjPAhj))[Ni^'Emlno0(5;.qo3
U"YN2SK\0Us-d)oTDvou3kRa']1+Dg+heMbnanq$^5>lS6tBfwtX[B>m+AON2[K_X
U"+n7Cl-JNRI(xu-BsdJBCMkYmGxB^T]/kDKk7HTceu[(Y$5&T.DvuU<K1kbEkLwN
U")WnmEDJ$KA1B(ImPbr.Xi+d$/e$dyGi<Ca:83-r1W2X5KA'0dqcuEm8\_cl1M<b
U"^a52A'W2]kCiFX8$1Ur05x/3GhiM5aT3?JVuZ2.N,#_#fVWjrkF+.n*&ih_>_^a
U":pJxcS^oU3)2[o<_$,n(aHp;p8^XLY.lvn:Pq#BtFIh9TrdUHk]s:WTx_16KLUV
U"KhlKRuPmuP;qFQ#;f]]A;7.R/dLiHi$SmFp_kJBb]Hh]D3r,b5w\MwX8U$1V1aa
U"8x530Ey+YMnr6=Zsu>MK$C=^FLtl/=<hpBGG\aaLAx]jHh7JWwWKUk$s_vcW*aT
END SUB
SUB V3
U"do;RWZ2hw)Xn;bn[(c-K2Xa)JTV34u8J0V,Us*sKBYIi>8fxwgbr($_h^V4wcf-
U"5GXgmIXr0d8V_iJprSIuP.r6S8I,XW]:O;FDw1l2&FY+=OIXgM[J;G+>YITF9Z^
U"FPg1;Xkggr1Zrv)SGiqI08q](m[6g(TKL01v&3L[.vt%gv'.e&lFi(D$37q+FPO
U"\:7x2gRY;rB_S7GwI\tWuJqR%n8WjH.BZN/n:<q2m&*Fi0Ov)%WDe1nXs5&=s9F
U"g-;$k%FS+-(bgf-:jW%5g7J1,T7LB7aQS2fwNip->j>aV4[xXx\H(TM;K/'5TyY
U"O5n2[.X1(wJSF&Y4WFWtU8IJ4\WNLL>7A=4tdXPu?sdx(%up()%9%'%#-%%/A0A
U".w9CGc&.%%7)%%%1%#%%j'&.ihm%fwSg.fxdw<h:TUa5vCA-xiU2bB9ZB#_[M2?
U"YQG?OmU/v,tvYYA*nq<%Nm3Ycxvs*Q6u3CU+*+CQhWJFGVv8VE,JEK9r:q4k-e]
U"56=:buVKddYUPmZhCPlpPSp$aEmsUh%BU9AAtX&G>7/f'\*wiNy77>f0]/hox^Q
U"tqSNfE)K+5sxTC3$a\R3ETKSJ3?M_0ev6Z5It91stwaYtQ'6uptPkRqJD1Q&K#-
U"A?81Jn+i%][\Z[S2e6(AZ=5k4r?JtVjq(=sL,Xn+uPN5St=9iu*LRs:]$'J>BLr
U"#d*q#=k1=M=3P]J(-&Q>SQ2tqfIk4%1)*0ix*GRB1)FG(YQ6PAjrcuwv[cswmgo
U")[VWcH\n-W9L,)??5b%2zHeonem5RnK?3\W#Wk)^L7H(.E-yZo(62Q<hHLwC'0n
U"TRaw]JHLbj$Y<d91I^=Ms0;<ToKPaLRDq1PPGc;Bs*%qx2FF>RNL\b7+Jl/i[t0
U"0rjBv,+L.QCw>QB[#M9.BnemW&D,2[0908.N2:d>B5quFK0_1\dTy?$WTfu.6=0
U"mN*Rtc[Y#2dC1iH8dF6OX&Oa+*:m7wj94Nln]?WTe0pKpY.=wm?qUd,DWLh;b'x
U"_wnInU[0<M7z/C$N%%up()%9%'%#-%%/\0AUv<kv/'7%%x,%%%1%#%%j'&.kxy%
U"hmSg7fx&z;:>So+5vCN-xZ-o1(yRUpNLIW7P>TICm/G?aGKTN.;TXz6,/E<sJut
U"g81[QI.MwSJu,keE)hhX4$)HKwnw0q,lXv8ae-ZJGcM;2\Bmc;aSA?Ze/A6v1PE
U",DI4w+HG0DQpmL<'XgEVrtSACD-V7q6>GFpA?B9nr_/%nYttt[6$4Uh6[2GILh>
U"U]E5MoCIcv[IEpsW:QwCR]Ld)3600g_tjk-rOGFU(xM[cZds0u,;ViDQ6ugx6p'
U"%k8K:$^0obk(m%+[%*R;/OA&>-=.TBW^Mvc0x'[z\kG:csKpdOVW:/YOv'5y+iL
U"h2$A'nOOG7G.cPmf:NW//)$GSe'W,EY[+=er%lXp<q,lumEvne35SaY=HCU0fX,
U"QhaJ)i&C.tziwF>a1ZJRe)0&o-+_AIJa6](FM<1Uc><c'jbCT+CC;Z]peq5ld:1
U"V4/'PPjlYd0c+:1/we<$N::iLk0'T-QEX#yw&eW+BssK4zvr7'MqD]mv\)Hqrd)
U"L2S&yO7L?K2<C-9)Sbl]N3VN()7FEztP=/<tFV/1\66c[e^_Y^Sgo;t,\x53=kw
U"=mct\.5pzeMMhT\?%V/FW6k)S8Zsx'K>Jl;KH+;eYZ$Eu$nSLl\Kn>:,Q*)<gYt
U"LuN;90\_%O-u(g7h#Rkswkh,S7d*FWKe+3rvQ-oR6m,*pl3fUIc;<J2xdvdD.b.
U"d&IlCGNI;vL0KS]fZS$paD5qO_8EA;/_8d;fBX]hc%cW5aGa.%0%6WCX7.s>O>$
U">NXaA4sal<g')PnPnbJ4aLY8fiKR<8I^O6+0D5S,yCj*l5_-mSvJx^;tK/ZkJhq
U"M)<%zSdDrG_k><91F[&L;pSJ[4=fR=Q>#co2S#0UsSo_MR4aLQ8vLx%%up()%9%
U"'%#-%%/S0Aw.%q2*'.%%[)%%%1%#%%j'&.qwx%whSg.fxlx2,>jUp9L(M3x?S7I
U"2KSa7czb[8X7,j+G-WnBPcr-\?WI7e3$)l*h61ILI<.5q0Pj6Q#$kJ#2XM(oG%k
U"u(Pq.2E5Jd#]*S*Xe4w#:.xa#Fr,y=MMj+.lZ^5+q0G^yRNkYt(o2(</RO:/q+O
U"iXPZLc(SZY+SZa2#[Du2m'()Ic^.(Gn7I3dJSq/yiX+W<-j&(ZA6+T2=4GcOljH
U"7u(tgZ)<QE,kpEG$FPo*+.nVrFUeU^G(:l<,=5TS^u+u'SQO^2ll.c4h$B1pcBl
U"aBZN7OqYm7t_O#:HXXg#dl%cO.M.FVu\<$X.[,oOcy,q*i8LgxhOqd80S=<82=o
U"YQ[#'n/;NZ.$$]<.h/_lMRU^9r&Zh/;[k>dQRwNKqS]xCjJy*17RvO%xS2N13gE
U"M8lf$OHK%%:'EWg1G)C9RE6fAc]E<pAL/hagZ8=wA%6](jufw9h;8..c$[$S[p:
U"5VT,Y3C_hD_DPQD4RtGp&0OMUr$qWw?Aik>+<?]L&elH8Jaoa:qvmnuzw(=xG1Q
U"4gQL5r7K<=H:c,XQtf2+4Lt1.*dBXegMLo,r\8qS>GI(c*A8H?(s>3H#vgSGNod
U"dD?'dCEV^FQg\tj4EHce_,FsTo]Qj_](:S=mX_##$riY]mQi=B<Lm*Dv,583Nu%
U"p()/%%%%%I%%/0:ATAj'CA%%%%A%%%%1%%I%j'.%gqik%ySrfIpj'.%gqik%ySg
U"f%x2/v(g&ns%ksyS%gfx2%/up(%)9%'%%-%%D/0APlnO$?['%%B%,%%0%%%%u%f
U"hpn%slSqIxy\d:r>T]:5Uh+9uD_w*mq:Qapw_?%r')m1vs882ofO;1nhWiB3Iz6
U"ZpPh_B-BO$'U-c=XGril/FcCRn9+0;b'Yo<cVsvA/:J<'1dt5:376iv;G/S-%JF
U"pLl\JG=)-m[Z9^[V5X(wBaEBA.j8NR<<fx%+6M_5V3U,,XM641CuFUfkz9O/B'?
U"<ubW$k;c=l18G1Wc2IAppCEA&uh_SkTRL:cVh5?NcyR'^;65pe%0(6hT?2DKfP3
U"i:qY>%$]i=TAv(6uA2lVjnnfmd?9-A\\H>/_8%6cQ9nJi;)r\S$YmEH0Q7\=VZb
U"DI-%u#^XUper_LX^=:bWd8i2%e%M.^C#I=0BN.OWFa4C[ZEF5:Q8z58KOz-ghDf
U"a>1X3[F3'q0\M=aAQ4ai=>Nc7WZ+.a.G-tn>yo_X:]29NL?^M>EoGj3)F-Ij8el
U"3SQcS8JtD=1od&a2%5=J/6^S+Il:zkd#,(ORk6YgP7AD8F,o+N\q0#*3e$j^*<S
U"LsUD-/NcI:2F&MYnP=Wp7)<-e&j<2MD<\q]]Vzr^GZyV/Vq<ymr(.MD['k0aTe[
U"-Ba&H;1B2Yj'wCHQtxjwl4EFy=pYjpa0:b<r9mUB^&]kc.niwjX3Jf8C14YjpOY
U"Pc)<eK2]hbMXVXFJG7'\TpV>DZqOfBLZpe1sD[]NA0bN9Htw75w/oZ+b]>2cbWB
U"gNnT%ZKSQ2k.'%*3.M_PfgtgGqs=Al&xG_8[WO*U18cUGCFD2E:#^cf[-%$-*jp
U"2r:YktsLjRF?U^[MB-D?3TtV*L80eWp>\p2pf?D:CG*F6vm\:R=hSc)SI9sasqP
U"_C64BH#G*1wvJB<3H*okYq2qKNTFU$Ar;OP^5U'6#qpQHg9#kc$#1-AaC$KDi4n
U"mr$/v7%ekCktCCmx%up()%9%'%#-%%/&0AuD)/8'-.%%*I%%%/%%%%xf%ruqj%S
U"ksyDdht;^#(B#.L=k)c5BWu&jJK3IJlSUP\]u1G3(;XR0AI7;>+UBT>-B3Sr&.(
U"?.+L0W[W_%:]BZ]J&y08)_JEoPsZadgP'xKKs+0%UoBa5]oXX/oTqXhu2uUHk'F
U"FWt>WuW68XJ[Q7iZ<l<qX8r0Fp/u80nw_V*dXltfm8unLT7Q8$NNWdV0=ufu9It
U"*Faiq(jvpR4pbyiju0(p?z?KpzrjROwo&F94uvTVA(^:BN-ES[=7U8<-952+Sq5
U"e#-VI/>%J:*%D'-FSU)E4VC?:V.%gWF(&B*BG+iFO^51m9&+j,<AK-ES[=7U8\[
U"3Sq%5e-V1I/M*:B+iF/O51mQ9%pR%0c)5#g1.g2>oR0%c)5gI1.g:6aYQ4(&S5h
U"+'___-1Yh%OF=_O]rK_1'Yh%Fi=_OrgzC?:AV%gW7F&Li.,<K-(ES=74U8U3+Sq
U"5e#-VI/AMBB+0iFO5n1m9um+_1Y[h%F=;_OrrVC?:V.%gWFj&l*a*YQ4&&S5h')
U"uT3S'q5e-dVI/7\T3Sq%5e-V1I/M#:B+iF/O51m-9Ue,(<K-E&S=7UZdaYQ.4&S
U"5Rh'_F-I:*D#'-FUF)ErC5?:V%(gWF&*,P3S'q5e-IVI/=)pR0c%)5g1:.gXj.,
U"<K-(ES=7LU>oR%0c)5#g1.g'Xh,<AK-ES[=7U0V&[0ha+s4wZuY:rnV4s;bKKt#
U"&8?rw.n\i(K%z.$3mdIp1L*]X\hqQDO6nMiWo46?A0.wifRIqwVhxh#u3h7TtD]
U"kJ0<l^CmkwrnT^\WAW3,BP)$:;TXEafl</<T,]$D0sK9#Gm?pDBLshZ^&f*X#?5
U"qxF_a,p,p74_h-fsw42CV7Q&Ye]q*,eN<HE5b#.swv#\-j62qaR0a4ZWm55?6c.
U"YJz?,;=vvs_9V7\xtWkt*_q%,NMiu=eFb)R\D=C_lnPkWgPuV<(V-xP*-&:e82i
U"%zSb^(j?WY0q3KZvUWN7F2PnVSnHmv+(ONk=F)edDJ&/i_W,ODvu)u,eGBGnO18
U"3uKG_U?\wJ#tFXEs_SSZhI9ek<r%&_W.iQWe,LD3Ji5)%UOF)f-g+jVhLle+es6
U"k#_>GIEXdJ\N>[xrYGYMxc3.J7rK&Tc^&u4m*Z6+5(T&mwzq:jFg27c56Y%7r?g
U"]K-&GW^\HHiltq=mKLontgTNbW'RNN8j,Suk2].DxO]T:<PPYHie+4p*YYJEty:
U"HX1$xSBRHTi#$vto^C1[/lM\Zp($4/cm>ofHa)95de66%b'HlvYKCS+t6qJShjN
U"7HJuUM^,KoD-4U<DxI[nD/H[l^:TL\NC)fMehXq'e/xd4OTBTwl#6l$$6#sH.xZ
U"m0pN^[LIL\o*y8a-bLtd(B^ttdDd]=ow#B\k2SC3fqr<8f.QfHJ.uYN)6fCOb\H
U"<ju.=oJQM8_'7(A*aEVjI>aG=TC0kTZcaSbXh59x8[94U-$lKu6HCrgd]GU>5%D
U"6's<h=]Anq>I?d_)y?WW.T>)JdojD$W:0B+pXPq'S'U*2#fvs]YOx$kaxq5p\_C
U"(h*%.PGN+9IHc7w8>8dh.PBpp=Qu,9<KGWSyYrmhDDJV,Vu6'Kx<ZQr*'4?trrS
U"QbcLd\.5:RLrc(z,5dTn/.Nf(xgqZuGg)htqM7rnqvOYTkWQ*w$4vY8uHu&Oyme
U"nZN9*pA0u8r]NPw,'6_<Gz(_Xk.D.f=E8'nWtZrf+GvRo^;-9s5^o\jbeF6WjeU
U"N_*dB;(54x<[u.jH+t1Vq%t<ga$S^B6mb4^_6Y5cnH7/E5D?*JHTjr6mPpt&7Pc
U"LGDoQZ*%6>8IbvtsHH%k<6-XM,c.0#<##Rl,,^w&Ll^^Nm]^^?L\Es*NLtdoxYn
U"sOQ7amurPnHl%5EwV/%I[ohMK$Itj8,_MaJI6LwvAEYj\FQet(EZi88,kWrX<[+
U"WzHg4f(]jTxM;Qn*ALrUgF)t6$cVhVMK*t8JnHlRqfSsLL.jt6wK%M.Fm_uYckT
U":;L4Rh>]Y\#&hakjQo5RcO4H(G^?e-6T_J%%f?3nZxfGbZXN%e$%FtwKQw>N>6n
U"Dt_0S(OWW((xexB9hjqI=ulwsv%ux^6dtn+wPWx+xw=tH]1>Nopp$&MNc3Fx,qE
U"8t=+b8njwgTyaxP5BSv.TMNv967cb3lJtbVlswU]WS<=T8vWbbcmyIHD4]xSKhI
U"tblBPHQPs>couDFnP(u=ei[N,8,80ptr8-8/kL6KRcx,wvcD^x\>h/uruJx%5W]
U"NoKuBx%n6m^jrPLtutfobI.Zv-j<s[TSoV<cs.uR8U7fl;)ihKxM,oWJ6X2KM)U
U"W7swlPeew3Xkb7HNrxlfredN6V34xaEX:s=2L_447LDUw(Tot^H:C3HCSm1tQl0
U"pKrweVKqlisuRS$v_<H^l9MBc(>b&4de'p_g*HgwpB1c_)jJUlIePY$.8AsdD]=
U"KRdrnS)=/XY$DHX;BW-rQk'(WPkv;rhN#*V.<w8Z$Dom;l]VUK]RmGB7^d,mCQu
U"rdg>nrZb,Y0bM3Ra\:##(e$D3b6dRPFjC'vS=(q4tE+NwMYwr^G'JtPTh=_Snu[
U"agqe6bv'Ua8Tn'weOL$)()>s)/v+s>x06u0$xsY&t0J-?$up%()9%%'%-%1%/0A
U"CRs6h%n+%%%+6%%%/%%%%wjfi%rjSyS'y.%_,>#0C7L<oBxU-YA*,uCe2$.nCxd
U"m=5SSaHEBDd?R6uU$]=PS2jE2epNXFU+T&J#ENfqt.f%J6_3EhhhPMrGtEExZpp
U"(f?Z4wrO3FXq*lY&O90<pD4Z:f\;H9mj98[]<s'HY)(VXduiu<V90SV8Z53YE\8
U"V92/2M&/fSbmM(vj497K9&-n5KJRTtaudq,D2un;vO^.+THa%(r89cP-+x4-#ZZ
U")VQ4$dq$Hg;lJ4(h^3Y^8VmDd-/<]&<Batl:jTR\DW#qk&xQD1>28\oa-i+=9SM
U":p?/1iCoVF%o6lgY:42t'?.K<%37jT-T&iw])UlAScT-wDWIG<'bifCaa][<Fm\
U"R>G/V3xV,g&?%<v(fR/(SYOQK-JZ(D+?I[Lvh33%(N,Cu/0YtJ0*g,vrRoDss]?
U"ITKnLqJ??7_CJ;6t,0jkhU5/2F_k1JMBCo;NEO&s1+t+(0??H#xrHwAgKJ]E;&q
U"O&_7bLC??n]hTBqkK*hI)uX_=_HK+Zi8oAcOkAl$Ya_SUP879fe9bV;I-sMgn^6
U"cZf%;Bj:tPh)BW#EbS]:re\fNZd=BCWLF$Jkp&,[MJj>^'A6JW5S+16k+=:KA\y
U"(E:+zeB(&mX.ZY9:WKBMnB63X3-_.v>1Uh9kM1OC\eiIZ7/PSQ,kFo>hB)c3d(j
U"i>Hf%7e<95?,Fl#-x\^^vnH&DM&d3?XT8qLM6(aAB<mN-P&<V14_$,cup2nnl$O
U"8G<9G;Y.?]a0g(qGjdB(U1h5eRzR-C5ARe^)ec=G=de8IY\^lC,p1A0,$cf;&xH
U"lFz.#_-13m1XwZ]iPr-*M;ZU\;BOL5aKCHA4awvJfmx&AfaAb=jhFRat/A>(_px
U"1'-7//v.fE=8\RY:j)=Vp6NL1vS0Y3B7oJcbLs\oOT-Z[GS?ihjc)mU:%2O6iU9
U"1rhu7Iwmgf^&g\&8A:Ajr)X(t'UQyU[q5L#:SZKvY]==tal$8,JG0&Gt._A[*N=
U"ZZlZMya+fj=<.9K\zG;/',$e<H*MJ.$BB*ktGB:,6_k6CBKIw0dJ3_(qX\k;(J0
U"19imBlJpXOWP%.(L(QbDn8yv.;XAycRKV#.pLAt$e]2^l,+tG?o+R8l.&iM.<55
U"rFHr'4Ac2SE^i+0WgkH=B2EZ0k_6J7JNvf>iMJ3Q*^yh72KwQIJAYF;K'V--sO.
U"CmYesQ4B;EHbh[HFyKL-LAJ<vf*X:[Y><+J+?k=z)Jql+?-PUTS3L(?s9MS\MI5
U">uu3xrXU.wYG'>,5<6&T*2/vU^&5;O/Wj[y7]Jr;KRI#ZcX_vD[xgSscei^<;4<
U"0ojX0tBH1Q/jGU(ZjQ49*lGP#g_CR.O#Xw9$[MCPxvW8ca:JHJ>0=db&Q,<.Fo#
U"T\PJ3Xoe[q>S0VU7(?bUtVrL69*9j)Md0j>WKo.c9xRw019)w;PsI&N^yZ(O>Zk
U"Aq<9*WX6s]at6K,7/>y'v7KncMCu=2%$nHW7Pk/*h$N)]XIu>;/2%A1Q0=lQ9^n
U"/-H8.cHCV*NjC_J;bm]%$J'ZNK9gR8G;9\4lH.6nUOyrDg48bb5tR^hla*ZY=??
U"9#/wa:<5V*EqcqjFbwqmHCYzep+QG?UFXP&gMlXvN_d$#qnql=c]U7:eQ9m#sEs
U"Z7EkCksX7g/==rw8OULbVGpi2GT_+cvhJK%.n6*Q;_\j1+,_6j6<l<R>HU\jGI'
U",le'Tuc5OP>EUvBIDqV8bfx).Sc^l^4ImIJiZGD0W#mbtIqlq=/s<cTu[7SlLZw
U"80.D.s$Y1WwG8K$VULtO=Tv&xRX,CML$CQ=ashpndT(.>?XP4pYVFaasX8K_Tf?
U"u^nmh/vvnLtSfJrOhua0-o'mhzYBQw1B]r#?qXJr<FNf7dIvSBAT>X2WKXm\Tgw
U":aMP=FIgS9$NVBJk^(ovSK?/7cn+177$G?7DF.8FItzwLa2ca]0g>9\h,xqYcD\
U"di_(gqLK8tVbKmW9G:T8qEVx0oF3ZsD^5Tw%QQrhk>eytD#\3vgYtY4aLHo'^^/
U"A#8FReL4f?#N,Tb^_/rnj\A\6pAnu%p()9%%'%-I%%/0OA\lN+(66%%%\z%%%1%
U"%%%knq%jnsk%tSgfFxfa:GB\[auX(cwF(CZmd6X]DSAWRkaK,z+Ci^z$[N<Jht3
U"kZ/J7/a_&pmRmNs$.NV;O=RR%MRj;s9(k\.q7a1kFr&]m0ke=<sP(&SSLxeN7+G
U"dsTUl18CjwK5KHPLN-qN2/ibQsjvL,-xwT:XKECQ&s]lj_UeIX+JJ8G'bOhzQ$D
U"/P/%Ix?^XYMGW,a?gJN^4'I?y2N.YBUcPiX-o'DQRS&zS8eHK4qQM7Z.lAo5<rh
U";X^RWLD7Ml^2O#DSU^\,:q/x(u=PUVGi&%.^S-$1f,?\+*.(&<9P=[<YZH\JMhv
U"nj;m8j--<rH\1RX3gI8c93d?]Ku:;xatV5rFQbb8h2aNd=q4D(tpMxWAC7v*(Lb
U"$C\A%:3Xr*h3sk6<GH04mg^]rBHrhz/u,3YrG,SgA33%P[=G4N3JOA?SV[-+V8J
U"'drFUTE<Zsc;j2sNZ[2WUjf5o4:VY5meKSij+B;Q7g8Vr8)EM2c.DmNqX$7C4MC
U"E*<ReTk/#Zh:sFGpAK%E#caU>sC%'iqw0-H^]cBJ3L9cRWm)c&>J08pk[8c#aw$
U"jD]KJ0C2TS:#KYB0Go0QVJ;ZDY;,bC;>GY_1kI)5;hqA%LIzI.^nZN2]eopGJJk
U"F]Rb+5;HRq2KT1i$AyfI1Ex#T1kY\;4->b7TJ$^WX&Awi.&Xz6-=jdPM=.h;ZqD
U"Ti8$CWVWMf'=z]jM-:h\t;3[Q$VFm0o7Y;((1Vu^%D05(Nv0]LLQP/^x'nLy_J[
U"LC'.4*r<G_0#jfyh/yq1T99^'GP5F^tnA+QqC[s9uSdR_4MOcQhtu9Q?')/2qg)
U"HT.4i&yYlK^4T-JBbbd&JGJ2oE;Bby]F(%PO5$-1UClS2.hn2Y3#gY)2=g=e_PH
U"JZGy1C?-mEOcr]QI5OHSAtJ?^ciqcR2C/)2O/wI2e8sG%^)p7R>m?Gg:dX9&2hG
U"Y)\<BA+>Tgp([DYoHP5rhK&0YraTVA3KIc3CqXA5<IYOy&_l+KuI0]>koktDf(B
U"ue>C$fef/?9>5]FCy/0hn[$Ot2[(O1[KR[:/po1r]eAp]\/QOa8qG6Xj8h=ANqI
U"Sq5$g6W\4,LG)F8kOu/ES;1w=n'B3.cjN[qe9#K.=27S+h.<R(l/:&T9YdD[B1E
U"jMC(6;uISi4)<_GBYIA5%GbM#YLjvigAVB7BZkW+X6aH>[SLf?v1jWtQJ[WOGL5
U"GbFrZj:?ZWxW(edy\._)3lkj[nR$lnHb;nf(q6gDrSQ$ixZ^[5;B2uHSBhr)RCk
U"M^1*M457&i=WN*W<51M'Cg[(QJ0d/m;#Io=msAnWnHHr%mFO<IZmL*Wg^J\gH2W
U"<<jqC&ZXb#VuOKU:]eng/t&:((x,%k.u=r&8-T(Uu\1&-b=fc6'U>tUqXNeEA*.
U"7^o,'nt=<2PLpSYX2BJ]n5:_&*3Ax-SrZs7PrGq[IZ97/C>RO'RznLsX?]Ry49q
U"??mXr+BkoXUtlgt6D=E=rG]38p+[h+:dpGqC$94L=G%[sNDoHkj2c:b4Hhs'.(E
U"3gP-mqV<TY35#=>8QKEgPCr%d9+<pZ?WY/\ELHUse/H(i[JvBbw?H=AJrKdIR:p
U"LAiAJ3;l=:w%TxwMhzDYLc.)He8'7Wjsq5;2bAYIJ>IH7IY2lI&<*n#-lfjic]1
U"Xvpp*B\0u=)RBc=l'Sm6E:H/.'=sO9,y#FvguSO/u'oCRk%?FK?.]%MO[=9^V>]
U"'&_[eolvat#&_#optbj[L/loF6Nl7_;>8srP'JU]$;H]SAn^^9:hD]sJs+R]6aR
U"bx.BvZI''=*OABq65B_f0m[>7/,tbY_/OG#6L/(,'Rs(Mx9V+_W4c)isIKr,Ps&
U"F^0s'YYbf?\bM$>IH+If)-]4gMj+kT=/dW1coB4=R'ueFsNpWV>$H;CS4B?7=0:
U"aP&Lq_j8)UvVDRr+Y?P1I*LveJ//YksT.yI0/hEN_cpx9WZR%NKd,0bTQ<qdBlh
U"Y'FTMBA#.Ukbp;L8?#1ANx*_+cY&F2-1g38Zes**RWZh2pnwG]G?4F7o=.>3X94
U"*r0]0^,Q]m7&B6<\>3=Wg('?Jt.6<Ds#okFFDm8*WIBkh&N+.GoZ^2O:7e)H008
U"gL27e1UDpDX.so$mm>CD[Yhj)d>1.'3M+gp6JiEYH9(M]w)S]VFmkcr=kl)aRCo
U"3[9'DSozrK3g#1S5[9UOtKg1,EOW7&E*z+HqaT_Yho&mFM,$]pBS)#Z0a59;=<h
U"E%HYK9%3Ys.1\/IZ(k>%O)uq<h'Egie4nt7VUxIQfJ</ViKGWUHWJ%%b^$4GNs&
U"1xDBOYQeJr&B+Z^4OF:KnTHa.>u4uaAN0r05pbM;ER=PR>3YMI\aLgerziszhEl
U"X9*8O^5dLrBu7G[Xr.&:oU#L_-='nxjdax,?[NX9.VZn)]B+*c'jPZ7:Yzs$VmS
U"w7%V0dHLd'Sn7,lh6j^/C_0N-wS1lO=OD,voxE;X:)[rV1IQdF(TuZCx^Yd?W8Q
U"V:Br)wb3+=&iJ*CJA1KM$x/q;xB=*LXP->9%Y,I5Sp-^>V:-V2Io0Uskvo:pIVd
U"vPRFRFVs/[%qPth>_3#b5uJtO$)$Z2;RCW=Eeb;lL+*R2(YwwgmKaKV0%e[2B6K
U"_x/L(aNE%2N86L+o;AQ9C+R.&Pj_>c3GQ4%i?c3K6m\O^N(3X8%9q3NB]S/a-%)
U"5q.:bljeP:s_xU:_El^)U3+0HWhp8yhsBNc/^;7Y5kt=Mjz\(H$,P=7R\1_bVN]
U"'UQZU.GRlkPBttdulln>;S?NrV$tttE8-ga0pn#EsW[+d,,:tPS4fOD6HFN,K4t
U"1';3K:N=$OC*P-b0$+?TkE(Hm;iV9=1Rd.X8H&#dGB1'?I3:.*Rsh1<Au:^JwmP
U"'o.r-3ZN5BM5'Zjka<LoOo</(-%$N5N[3P+J<cc4q)4gPzXY2A67.-)2lQrvQ.3
U"sHl:OO)QIQKTMocZOe+Vs$AqD?[n9AVsnkg&mllutexTI2>H;]Ub8Bs>dp(jUk:
U"'(IRV2yJ7pABa#7c_QIq?Rxu/5+9rHBHa#jpTPxDCgg^ymh\86lqll1^(Zix#9G
U"Y>;*S5y/>#KH^q8kJj;$H-k%v;>&4c#YGsOSOGPw3rR99h*^-1m$4I3^m-;U$Ci
U">/#SDe>,%R_=;p]hhB+Sk]Nj_Q]-]NAdcZhAo'47OVR3DvKeW4KU$Yeq5.TJd51
U"PpWR5U'f7'^*tyxPo-W4j_R5%_D^,qQk0qhrT7Z.I^AR2-_X'Uh13rwe^.UIJCB
U"(Hk55^I(CRjQx.p)GWSt:IgKGSTZ3hpnuQ8x2JonMlJcP7[ldWnH+.piPsNcg-e
U"2pKbfrc]+IKw31v_8pQ'>^,>1Wrcs^ksaYRKeM0T7br1mABctG&Q5)A1:D-?H;L
U"/z:GKM):[c1kPn>Z9RG+&':va^WDSoGkZG_74t1w+ni6vAuT(-H7K*>$_=u>P)4
U"132*M,$Q%,gYEdZ0TDLquZTSU9G)sDIyB(+plC\+ypft0U-)s5wbP?Z?+ZPa_Ut
U"dn'[pLEcJ[mtv<f-rqiU#*e?Q$TVm<Vl-C)nFFf3s4&OEE6fWrjY'3p7/DB*utu
U"dakL#*Ou6XaC?1RSisPrN2;(h)bkYv4QU6/3ZSb.Jg-0gP)Bmj8C[LMEIXm[DJ^
U"7ECeC+c<^a]UZa=7VYVgdhg<0-IZ8?=P*f8%_Ag2_=nh1B##YrdZR>IBg/?/q<&
U"IZs,/Z%;MoD.7Y+.^&PS4uL,EGO>=p(bZ/NvBEsMR76LpB^hM)spOT.JmY#rf^R
U"Kg.L)G0==ac+ie+iM*z8nRncU%&Pv.e4tyT^iMCpeR&7g(/lBH'x4mJem&(f6RZ
U"WBvl],SjJ&BMOzy>ka>.oNq-/LMA\9;iJuec]>S>FG8u7f71knDU2fEwpgxD$0j
U"H]p\-9K5NErP:o??(9:+4p.9sLnw^xrfuB[jx87N]Ft+?]U&RUz2wo-$3w*nwZ.
U"jAhx%<?R)scN&h]i$VY5oWM]ql6d.6:<W6JbDx<xA9A_+F4:-;r\<_e>j8%k:z/
U"]l?0J>/[u:=oA=DhendOv^dlP[%dCz/]FlDe)Cjv's;L>fL13dME:N.2,RMYX6M
U"3Tlp'QLmyd/yG&[#gpZ$J*Pf*[gv<Rgrrv#n%:0VwF<z>K66?L'j;\$(*lM4OJP
U"'VsMhyi<I#qrn_IdP0tPg?H4]p_J&-u6o'/meT2(ncdQ;71$C*5O:=A.O-uN6t.
U"YpPu/4+Yj,,wDWG%+En-TWNf%%g=R)h5sQxSpGWN6tst*&;OJ)WUEITJ)PIUC3d
END SUB
SUB V4
U"G97Fzkq'xb-jaCNBi;;i5]QBSFL:GJ7A'c^e/b=DLUTZCceCf/H>>+WcX[M&uw'
U"C]C)$xK3Synz'?A[2Q0NF_l_r:mH8G&t0fHj,'5)q,87na06?4)?u%M1*H2c^5_
U"dc^8223eAF*^;3L&,9z.t.en:j/NjW?o-mWG9E<*>Jf7UMmS_R'jeiR,X9?mZUU
U"d+F2O?VwbJz+z=iX.P7Wc2wIw[YkTQ9m'mSMGJ$n%i)xR[omMWYVtR+u3'^pbr&
U"p.c#cZ:s9#Dp0KXwR2pqQosn%Za3^ghZ>JmOXi+c':#u+W98*eOpI&seIlleuwD
U"$VaQtbQCBdn8-8G6,.S'XV7P&Ldmll\H:^FRx$Lu2V%;]kI:;JDOJ_7=Bfa4guA
U"f)$fByKUAY'B[?4u1?q$a[>kH;H=PQ2)H4Y<T.)=^]ZS:7b)/b=/ep#oB87;Qf$
U"7fEP[]RJAo.DUSFfWn_LVXa;-F-)3(ciJ7E:GWk9GcSv]uEvEoRB(s^CU%__mpB
U"q/>7gJi/eS[Z1Aabp)V1obG[5g/^RG29C3kd^73=#p]x(HE.WC]=kwM4nV0P-Ho
U"HImD*wy-o[:4q$C]y1X&?iS5rj?V)Co]\sYC;xN#?EJiLx0vrh*3[?=[OB4CCbA
U"Vt?#G;laX#_]/^/1e<4D55ZeiVyP0:3/_$=<03CheNC]I_1GVnk4Fm3axRO?Ac0
U"\99QtX(SGI/&mZ'.NDZ-,rD*lQpOdYV1V2K)>p7s6vdJ>+E-7#a9eqAcn8lAN;5
U"9fI5+%qryi:)VM]^R3+K_k6T>jN=p%8dlbke*KQ?9&.,8[75'MQ%-:k?phPr=Sm
U"&fWWF3umure7[ArMeg2]I\*-#6lcvEem^&-4.i7s>Evc\w0>HE)0u?$*:&>Qpa%
U"8d=^9wg:IYmo/artnY;&XeM:K2(R:mESNCB)llNncRB?GxRW5.NOO;y>n('VQ?c
U"N1C''odrv)qGKdc\Mm6*k:b#<U_<cBYi:E\+nniA;Y8'?<VWcUPe3;ojkG-pD'H
U"B>icEZYREV?m)5#/(]0;&squ<e8XjvP<IV-2[3]/Mj#a2S^:1H]/],1dg>'A)UO
U"M*'x9.6o\N4IYaF,^_V7wP9]ule,R(^#+h(gQZd'x;XdWg0_hDk'\YefzPf.2k7
U"KjcMMvDE;$t3Ssx=L2hkH]3DK5gK?51',&\M+vh3<8?Fd37XlA$>o3;tbfFnW-^
U"<TW'q4UfkB^*2UNj,L*:58Y5#C5)$M2i*ZwC),,01daCysz_B%I>oBAeBZ[7v1(
U"VxALhtl_&&2PT\*c5cPcR<hSes.=6R4JpV2&X\U7WTdqd6S?f,_>'#63.Gk,(jJ
U"Y6rEw)+=vZS8c=9/5U[ERH=frb10O4s3b:-R.j+Gd'b%Gj78wIB7Xjn8rPwAO+U
U"ne'\9FE=^D\jX<\MXAr*(cfas#g?_/1\8>owb?MeXWYV/CYF1^zhYr2kH5EW']I
U"D;e^:RJ*;Y[GmYddja(ie'x%up%()/%%%%%%1%/0AuMbX3%A%%%%A%%%%1%%%1j
U"'.g(x%ky%Srfp1j'.g(x%ky%Sgfx%2/vg&&nsk%sySg%fx2/%up()%9%'%#-%%/
U"e0Al,%&fL+%%%5C%%%0%%%%ks%yxyw%zhSg4nf(p,BT[5$7FKxe0Txe)uERLq#*
U"HmNYV;:3?e,p=nSWE/Aj0g[&1%Ch%ML*'Y0QNgo=Bbk[]hQ^9Fde##D5?tn#:VX
U"N9N7CWmaM'1]aDBw-DSN;W:RR/hqWCoBNoqNGmc1$.4M&Q]26n5a/xRm*8n/N?]
U"QuIZrR%]<RY(KNc1BYo/B-BNe=<.i%7LQ-QJ,B(gSJ'q^6/2=]KYRd:2Qo3FG_G
U"g/wdJj_2rMa>o)XVM1Yn&1W9%*;yqWTNrJv2#hAXy_2fw:psq'lTt<JDrq^_ii]
U"BER++39C4u&&-<W\(NCFLrX/R+_-=dH9BvU^5cGS:M:0<C)Yn<WrUB=\(x0V\RU
U"%VV)X]%EAhs8VaXZZ\C&FPjnE%._ghlML#15G>/\(u'D]Z9J1#US:d2%FLf4nQ/
U"H*HHO:x)09/fGn?=s.b$ah3Icl32M3s5g--%<oSQ9ASaO;EhQX%\QM.&xuVl_;Z
U"]Lug*3=FNKk/'[dp1I+,%0pYp;+PRjO?Y:lkM/TP+.QuS=1gB$KQ]IUZ^,M-CXg
U"d$_7a8BO8D+qJY4GjMtTk:'\vM-d+vKgI'ei?#T>d\LG9OH8^LAE&7q<KLQ%s6<
U"i)151O2FbbunSH_20[uP(OcO;d=yoJrLKYHhnG7_^Bzc2<pH/XnWmj)byM?S=2O
U"?eu,c,p,*;>PaI;P/lYjyNK&5DokG[)#/1Ks&/%*5sQ#dl4c-Bv/+i>G#2,azY?
U"hQoF3+No[Vd:W_]\o#CHLs9le\TU<YK9Lw%J2,z,pUWDJ3#cg#ZeS#u?K1=&8(N
U"P3F\]1rE\IM&tsV6Y4h5;JlP3n04b+,'tIz-#?8#Nn2Dd_l3YnLbM,[w(G,qvM$
U"4=.)q)g;9EfBL-XfJ4N)BfbW,h?9DNr3t5ef8-:X4:;ZQU8'W)8t;C(5^-4*mW?
U"9N7<31EdZ9UoRJtT\=d7gll=e6A:]AZeA:]sAeA:n]AeA6:xZA2kBrDb7Hg.#3M
U":x-?Iz]g&)k(_w3B[:c*e*W/7<cOpecjm*p9_'9_NdpHSE)UKJbFhtGJoUWG?js
U"uNrDJglQhjy.[_i\KX4<8+JQ,(Eh=0uVOe$_&Z.o&l*&;Yu%=BPN.ZMK]0nnC\#
U"A:vm_WskqWcjP<(en?Ye60hD60Hetf[\4UY13Q7iGOn_5jJ0xZn>3>ZZ9V2+57z
U"nY_c9sLG47+_jeYJB$umUbtm$HNPI2O;S$xLs]5+T95EKOes;\J3'+X$?7mJRk;
U")>,V9CX(93_jDRN)g:v./u&dg8*RN/ONPG#^J\+-F#4g9R0fxnqI>X6I])^wgL;
U")/\3l-%-$=(xg:/mg]6WO^uY%;,WX5j#6<Lb<q)+>1:;0dk=X;mYH5Ue(L/^9iF
U";gguUJffmKb*Ur>kG_+*QuXz[[[\qC]10;+_brx\OrZE/1CX*G$my??\nbR2Yws
U"50fM#Ksw_UlQUT:11;<gm54A6I9dv$pAO2,uluGht^8p^lt*g(VJuI81NNvNtkM
U"u>M):jlR>&PjObhP8nuY,-oSdOChaV/;GW2L3\fmM;/b#/:QkzhIXrk2ZYEcMYp
U"&bl[Bjtbz[eN?oY'X,,%XlR(KC0A4]bn^AU'lc(=&4RlWWS8oj%%8n,$Oy^DC5c
U"M]'bgs)aXn+CjzB<,$i(xUi*s&+TU'9x$7<GUK+3OkEZ5=s-r'.uiAG+6k&j'Xc
U"wpr^LqupIi#mp%FgK^8Mya[rH8rVr_&-f9(]0&Bnen^$tu_#[I3g6AVT=f)MOcM
U"86j/ETlYOvlGDfcohfBm)?g<(rXY#'YeJ/Z:K;5u7Am5j#pOw9C^8pzeFD61[R1
U"P:+7o/LaMcnQymySCAs[DT6=Ps4p<8k$9Ym5*,3\\s:pdT6wmcq_-=>(d*j=:>N
U">0f9$6v6pX,N(=TtJ#t7$BP9SsKCFw.GiC2#y'DQG*1]>SImm0O5j4mGQ%RQlP9
U"DwifCDc4k=hwk;nI(GNmKGu6hTktE8_wu/?][6xRiv,=H\D>gml\%up()%/%%%#
U"%%%/S0ARE,YJA%%%%A%%%%1%#%%j'&.ihm%fwSr#fpj'&.ihm%fwSg%fx2/.vg&
U"n%sksy%Sgfx%2/up%()/%%%%%%1%/0A]NDcr%A%%%%A%%%%1%%%1j'.i%xywl%S
U"rfp1j'.i%xywl%Sgfx%2/vg&&nsk%sySg%fx2/%up()%/%%%#%%%/A0ALg)ajA%
U"%%%A%%%%1%#%%j'&.kxy%hmSr#fpj'&.kxy%hmSg%fx2/.vg&n%sksy%Sgfx%2/
U"up%()/%%%%%%1%/0A4lFYs%A%%%%A%%%%1%%%1j'.k%xyxy%Srfp1j'.k%xyxy%
U"Sgfx%2/vg&&nsk%sySg%fx2/%up()%9%'%#-%%/n0Ai3),zg+7%%F;%%%1%#%%j
U"').&ni%ymSgRfxf')*>?^L9M.x-xZ-:%*[)JK44dq[K7&+%jGu&h8bvCGhj)vT<
U"=Rms1e(XYBe2g^pakF?g<gGb$:Ctkkh+vC^/db-wNNeux_TPUf>oxkLJh/]Y_vu
U";-7<:F4Z0&,)A)sZS#hMZRQ,1;Z4EfLk_9$6U<&6>irMM$s<IU=NG7(_R'I5Qvg
U"f1>B(XBeEKL1K5CD6tRjAXV%V?[?(Et;Y+C=CVc1dItrRUVXa67OtZZ1LqrDI1e
U"[l;:Z0/./K;r&Uu5WU0Nva8bJRRdEe2z>:g2M>dR$=%SagKf4ZVOUsmpYiDRDBI
U"P0[aP*by<\>hy8FKrh^Y]90b4hl*YXn%QHB5gnT.-1K3UfaHNAvKU#+PVe/_K_L
U"o]mJ=llzXf0bxD?:aw#L^y./&Q(-.'Z(2(?'7gXU$:F\a1/f#u.)jlQ4lZQ)k#r
U"3OjDdbL4=o0S<Rv'fjt4(Spvq6;#B]>=;e8*31_#>NW$1gCXS<'cM;0AP%6:R[<
U":kBkM9I4>,D0*Oo2x;u4Z##1>g]btkUX2+Xs3M6?AK_KY(/>q:hYr1lA%VK2\[A
U"R4z1TR19x*S;Suab3--c)bBk8Tq-vTEu%3u]kS_m]f1\pKrAPo/J2$FFMWx.grU
U"if;%TT7zi&w[sC-]D1h?='XfkJlZRD*B+jgg\lzl2hxV?+:#<dJ,/?+\I7orrf_
U"q(0LV'o>/&lPiCym+0DlRsBR_u/LW,dgoe3+IB7'Wx-+C2WGD/#^DnW_ON3maTF
U"LsJ9InH=5eZrI=<,MwC\m\yp?.#hVJC7c'7&-gVEX4$fu%vs7K$g&/9C(xC[,u,
U"nhNM*_&JL29-;V#kj1)XCG(EaNO64\$y?Uc]nTQ'v,dQNwr*=UCotMMnjK%qJzb
U"HQD2=s,Vq5kG4?i#%+/d>?O(#]fND=Za6T\I:>iCeXE;4;e'u]]8zLAE_^X84or
U"2310DbiRNle1q'sg=$Hlz-920l3EbJXevOpJ2l+PyB]C$Rr9FUMCrd?Y)Sb6Cbw
U"lW^/l(zr5mLYc59TRz/7Pa?,x>gzZ_dDJ>)Nq#_sHthevIL?#*z^/'uzKF[T]O(
U"CUC:+my)')iRw3/hTty-ny$2$JpPb68;S+)#W34xL[H])RA_(Z);n(o8RNe90bx
U"wGG?_jooUyfgU4vv6CU(A3eN>W5F_%d',-([:RFe1U;z69z984p&EVn[M5_srCm
U"1SpM&Dk,C+0_aQR7xT3A7:,\3f0YT/gmYSu8(3HrvQWB$Kno.i$<o=s8n;4XSpk
U"Q=P4Z+>/TTDQ5<q[$V?awj1PrR&/-2f4z$(y&xj=YO])R.-XaxwLI1AA%jopC\%
U"7U$nwRh5^b]g_0J#L/JH:fG3]9,5%/Jxh#Jvw38*QE*''I/G1N)7F3F#s5ugOI)
U"2LrDp)Njl2KD.?S2Nj<wWd)hQOOk]f:#lAgaA^\j0NYEu+]a^xUa;\Q$CO/'q2X
U"'491%:H8Zx'Fq,UEIa&YWKdw0$YtcGl+O50jz0=p'e9&Ep;MZ2h8EI85?c&>HHA
U"zx$[JtT+xeek$6tj9p)c1;9MUZWid<fo1MGeBbvgXRd+J)c;mg=pG2Z5KFa>D?O
U"MA=IBl2uMPP)e+jwCR?*lFjp7v10(WENP0[+&G,Jo02o2H=-%^BN3/?H;fA-6H<
U"/S3G0A'u\cebkJ$1_d228<0Dlr26hEJw];AXJ*7=L*$.RxkuVt$ZL+>(OQ#-'R6
U"H*1tG$QQi_Wah_sOf0lv^<kJ32_3.eFKEA,I:j+pBxU1NZkuk0KR(16o1rdofT<
U".R/)cDKEvm$2;*?dC<'%9;*DM+s5tlI'BwH1KqV>89'VZkMtui'elr2E%kL^.KT
U"5XjuFi^6Y]sC:x:Q^XK-kxoKKxAdFc0f<bcqD)xt<A4_nWGka2JSg[QI5]7b$E^
U"Lj:NBP;Pn85DknbLa.qtWX'w?:Q9'03AVU,Hl/Kx/F#GLsN8?rGosoj3O$>:==4
U"t'XEx.5mo7E5kqU/x#lAR2B(1fwI=KHuD7'vN&kqijGoBNBDVZ1dwjJlvP:<S\T
U"%up()%9%'%#-%%/&0A6+7Xfk/7%%)o%%%/%%%%xf%ruqj%SktsNf+N?C9F:Npla
U"TDQWW<M:uELA/F<M:D)Ypp&f0A^7O)Jg#fe$2,6SeI.J?aH8pZ-VL^sa9ndo#Oa
U"O._cmylfAdD14iXlp5$'MVrAADO:)L;#/;7VC&_qVk07uV4DfP^tL$i[C.qZ]4R
U"KZh6pLlXpLXQpVL09\LW&%8%yG7i6Y)^I7Z]nvE;gL_8V2HN([lgU<G.t8T''hM
U"Fo(up:7fc4VBThJIIpW3FeCopbM\lgc#(uV-N664pb$YfQAHmNCp-^zh3<,[=4,
U"BmW[qUKzZ#g][.nVaq+uHBwe%#y'6c,><QEe0XdIrTa5$&ULO^JVPgL=1=3rip;
U"*t'ZRzwo4z7.su3UKZ/N6cT\;0GciX/pWOLvJkFgE(udfRdq-Gporw,44Bs;:/=
U"G-&03NL0bl+f']lgfCp$oDb1-=VNV2ib3Y-#6b5uagSR;nRHq>7#(kdULMu2h3P
U"K1Uh0NR]jL[Gh+jmV(ne\3cqyP]Un&2s95W3WF__^i=UP.tdNivRo'w).n'(j*<
U"UOP1Ayi2Q8>EjhhO6EjI5S129u/J4f<6.FX5q'%eEmUt(%)?V1RH2L$Y<Do.2g'
U"l/;f*SleMaF[Qo)<Z8=D[n'?%M5'0t9Yc=\=6$%ZBIi^p>R+:J)YUj[I?c<znR<
U"*&Q*T0ZqlU(Sk<iiV%'QrhF0[vihOn2tCK<(FRr2ewPpZJWAZZ['S'p<vS9nq#]
U"&2KjMizrpc(G/#O5xyz:&>6*pCx0:U6;XwJvE-.g(z6W1/njn6;sjm0qG11M0n4
U"P$FWb,^mG/jj,5m>k_I[Q9#y:td>Pk>&:LpgF$[$Wu8)N)MoPS,72;qFc/8fQ>=
U"/;K6=ZjnTqb[umk0UTam9%/2.>k0#L#>G?9:9T46l6X6iq;'QW?eAjWIZq+B[s<
U"a(HG'4FgFXR5gE:_1/)j:;1\A:+]GF)oMS&lD$aisV=P_aWi_;L\^P>UF5E68/L
U"[:*=<0=U]S1Q<QEDwPGbe9)GMF(:'1FG(+-ey-XCe\e1'##A<1a\SWGg*-E9T5a
U"r0Xia=[7[#Hp=G\#nRMMKOPM3=:W;f'3m\%=56$8eWiP-=;$=AG'VX-qaW+e]Fg
U"^I1aQG=(*ss4+7ZUqJ;I^+FZlCX+w_p)0BX(mtZLigt;j6^1K(j.DiJ0U(0=QI:
U"1K0d*.f*P,+aP3<WNEugnN9%nD(Vf=(zIr?Wr&57\%#r5\ffSM+7QbGPt;i#&bi
U"+Q[t-$#,IUY^qo,a1u>TK/4)/a)j(=0(6>F$%:Q)a=*6J3,UPL<P_i351r)7.Ck
U"keTu#Z:2zTp[X+G0$*)EB.7,6(E]A4V)+&j8i*VI0aK-CuXqUVT.mYa%e(E<T?4
U"wXYi%]RjGpUlM'jL5vaBINv(mG-,V*hnbQPYFlfsXd9l\$mUAclR])[SVA_lroO
U"P/0\&m[9;j/&7jO-j$^?)#m2Svl<b./_69[E<-z:TM-888h87?J:S#[n&&hpe[5
U"i_690,rm);KYAOc)NNcaCOPuAAaX1,L1u.LKgIT96jYIfnr_]hi,q%I:$/VHI+b
U"Ml1(]]<cno5G>#Q(jhP/+:9Lde/sg2%'TMoc[B<'OIDYRc&[>/,;XYppIYKpFA6
U"/,I5]j(\M8PQQu>7>:Wtelmnc#B78Hio=dB<fC9HBxK[(n$#9B+q8vt,?KC5CA'
U"dE4kI?/IQ.<,$v4,N/ya_AAutMN(n(AQ^k,$3:oJaMi_:WtXO+wdUO<_Y-M#t5Y
U"#au^TBB2urXAE9>u(IRayHVhtH1+z'J$;cN,&Sgv1\TSae<iL_gUMc/T55uIh/7
U"]Sy>5E9f1t(1v3sJ]3KkzUth&0u5=&GdMmG]bfk$#f,<cm+]9gL1$D0O0c--0LL
U"%Y6OPAog^an7Y*U1UC5x+'pHlCG-pS*?/BYt$_Z#nThI,X#L]q#NOMW>x.=l5Ko
U"$0_poO_=5G:-f([Q5a6AC&M(va&M:Q[=Y,aPtqEDd;DcY(u+U3Qk=:+lkX^b\9H
U"<b]7hbstD6=1AS)1g\Io/WRW^an\oQc<o)atMu,&?E;xnjB-<]EUwn(ceb(Iw?9
U"1LG^pcWo%bOVH%uk.5df\<K5f5DZ8Q\hR%\Tu^K,LCNhXvL2^]n)\,a:(3VVkA4
U"VyI/LLbAe]zDIn^F'mg,-W5^c#O#aU2e]_w-rFrASAb6*J?;13Y,i)n/pi-45&j
U"nq;i3>7FK8C'-;BgVh'O=#9Uf,4cqCkt+s5<mo))%hCpMEH3B\Ii'+#q-\<H/5&
U"T3Q+I+-B&virL(jPYb(V?n$H>Do0$3RwZqA,?(g0z-d/)cs7,7*]/Z3vwksKP\0
U"kQkp\lcDdF#c1zAw=$S^T,AkCJERXA3P;f:Suka(N.qC=Am,>M7&^,'.[,+oSXJ
U"9?9MC/7Iy<z/0tkxdWLRc#ae^*.((hA/UrZ%QCZCI&i$__7gu98WX1/$RaBKu/_
U"Q8g1H1=G&4N:KQv2vl'Xtu[9SS$1pf-Q,0CnwsUESr10xo+C[L)gsWqHj4Rsurk
U"W9PbO^MEQlB+l*W7kWa<X^Z1K&h_#r5kA16pMX[j+xqtG$FC<5CabDf)x73N[Bw
U"V8SG3k(E-KB1IVAWsVPEXcNnb=6C0sxX2vg_d49\2.PD[RtJ*wi^9[mS+5v+O1n
U"r%b)IcY3%7xV_o6EI'Yd7^LsceQ=cR=S>0i+=ZbN>G5Y-;Zwb)yCpoK]Bkc[d$^
U"a>RK6_ifb(VDu/3X0rO]hdY[eTY8lKof-[2asZ>r,h1>[#3,s9Ngo^#)dixvFUY
U"]W(g/V?Sc\G90f*s#aum*W:/ZmtcSfz3;qKwA._hC=,?Rgi+hCx)_W6&jR0H\d&
U"%nt?8Z]l^K+A&s<NLXof,1,d8nf3;-.(D&J%8>$r\s[u;9^0A,-Zqm]qC0QhLWj
U"#F9&E=yUEZ=k$kEptW(S;rl6jwudezWqJdljo/K%WcEpthX.*hpb8SEUe'(+16V
U"TXAJASVQ8&WUi==GWhG/sLv%F^Xs5Oq5uwN.D77a-CFu_K:PU9aT^2(6U-h*=JG
U"'S.eY:gW&rDtXZ?\$jHa3G?Z_AYs*jW?MZS^YXobQ(q+GN#wBaGuiqj\l3kO=ur
U"fS4U%&^zbz3=,Y6H7LL&8;baW(nV/P>Ze,qWMc#y#D^-#XADGVdrU%l>G1(6U-h
U"JSFqwdgxKX%[aQzN4O)S29JZO^#2ps5.FT\7jc8DCDWG4ogUiaOZjH2#S16U.-h
U"SF][k6ZNjGup('B?o=Q'DpAe1jmPAN;Ppjmh>DjogY+aN\1]0\iugdXojU^'G)$
U"O/F.N%Ux>#16[j1r,&QV/,*.^v&Qx(ziE)B]'oXT5Aw(.yuBwRXqvMoCe->-Hvj
U"<.d#uS6u]]jiv4%<rca6[Xo)]vj'V4cD/=B3BDBjFopYTZ/UpI:sokb;9\Gx[Lf
U"Eg+t4<33b1&B]?bGF&K$G&VAs3^YbM.z:%?B]ssO'HBX&??AGC1SbtdkcK2:I4h
U"Vd.Lzo]uSc[Sp,R134]'1byK$fAtj^X,FbRYq7M*b-rjPUB.87gd\T#EAp)Na=a
U"s,dMrVg]+]=bXfrxjslox8-a8up%()9%%'%-%1%/0A3Jz0K&U%%%'g%%%%0%%%%
U"knqj&.niSdin)\6^KT%eTevioEa0uf57T)rMq[E'ua*h#b(*w.Quh'\0%v_Ma(+
U"_2b'x%[YSJ8*5'FN],I\*#eF27GC*g5ICq(/h85A/Lx1#5K+gM$2QZNUBI*Em1C
U"y8ih(yzYDk.u(2chmvPqY&hMccbyL5kn%Lwm'chyr/%2>8q%'k'T<%%up(%)/%%
U"%%%%%D/0AU7w4XA%%%%A%%%%1%%%%j2'.&n%iymS%rfpj2'.&n%iymS%gfx2#/v
U"g&%nsks%ySgf%x2/u%p()9%%'%-I%%/0[A+^2,4$;%1%<U%%%1%%#%vg&%nsks%
U"ySgfFxfb:t>T?+9X0mdC1Q]eY9R.kD6RYO^DAGMD$KItLrZZJ0*K&7;:YMFsNDg
U"(i8kLhTkFR$5l]k)e7R$4ulSRR>hRV6i)NRGbVP%xj_srTj$f\o/]3VRBq=JC(7
U"s>rnw48L7I2[-<SJtd<w/o>E=ZQW/7/(1;Zc;WPWuGhf;]]+(9Q-s-s<AUmn(h$
U"\NR'hqaLUt]j,._MsBKEs]a9bZ#Wjw?Th:DDPnrVA(7ibgR7[a>Do1*nv^1<#IF
U"\*D\5xC&DF1dXC:J(-xi)#ah\Yee$>Ds$//e,Q\Qv*uFKg<-<X$ZBVp$lX)buGd
U"o77Y?x0kC9#Fw^$[Nc^uxv2.mKAG0P5t=_Isnid(vCP%<^s%2'[QKc%[_2g$3AU
U"Qnv4b]/#JwfDiG-yM3?IZHRO_OXJa\Me>]Q5$PJdb_SC+8ag42?u8f66$67V4So
U".=2)oH8O8c>.?;ucqYcZIIE<Jn$BXk;a5+s^hu9Lku$7Ag0\?c5d1^YqPW+ip>+
U"KxuRgl5H(8-pGGSB>K^8h[kk%MZj[u4?;#af8nQB#Yx5UArf\Voj85Q]$5aNpI4
U"<%($nG,a;s'B11<5V/IC4%Zn6_#J_\1sb^\)[8H;E;OXiRC(Ca#pP5ROu1P3e*#
U"C.Fp&8ASW^9#5:Oa1u0g/Bi]6X5x+BrcsQ8NYEWJ_x;acl.cI6<Mr+EP4eBBWW7
U"H+^<naeRQm\)oH]VIb?U7%WTmo'<EWI<R\+XLoKkIOP:aZ$qYGURy'W5hU'1CV$
U"79l3ddO8?c>,>;\Kch#6n63d\H0YAhGuY'O;E(iWS:c==a8<nSVWOmuc_q%79gZ
U"hcT;[BPggbSDntZ]%?wCYie?HAj_mN.ubNO/T:aQW1q)3;<\b\OJB_5SDw:p(G-
U"k8pmxJlOa15z8.2OJAJTkjDRgIPT(ZNQNom)5qownurviY+T5v]n_a(5Wtc+^L0
U"MpQ^\j_^Ej^oO510[(D52g+r\%Vo'\7gKaXu]fCKH43LF6^D7;i8O1#H<I1GT%A
U"ql<Z#0C0&I+/?xZb[=M2^_[geO/P7a'&_8_K8Zu:NC(qY\Ah33[,hI*#*3Si8cw
U"G=&hrSaDeI3z9XS\=V5cG8g6+uzr7S8w6f'\dkBPpL*/fufMiju_=UpbfzW9r.z
U"A+aCv4y(>]Uh#C=tvYlGp6hJ[9sj5zED6>/+GY>7=1+mA0PQiyC&)iZbcsq<^6/
U"3$:Di=[AWclEU0)K[1I;/T_Q;k_R5LA38Kn:L=>JI,:YtB:6nTDh<EjAsGlW.Ba
U"z-X=:AfGZbLhL/'dW1K+6B;n&Xzc5oIdu>Qm^YS/P4ltOBi1nB;]-xH.cI3^RLv
U"CT;KBk7qqpGrxeO4R<'CAC?V9m6]vbQIEFRbjg\HtJOH7ifk02(>jJRo0K7;nqg
U"(DAdj3NGQn;g>EhhxwGK0?/0f<[7)s_q7CWnWu1rvaThYw)h\8g0[/NSK]C[2xW
U"'[1Got#F71DP;?s7Ut[AlkEk.[v\?#Rw<Dw[PviJj0.>Z\pO9NGwY(ZXc0OtJ-,
U"f1/uo4gY74vm=c4.5#+YB$#0ZD:VS_l]asYGjSw=iUVaZ+i8)eFWAY4/kc71J>)
U"UcR6*$K9j>[X3L[PA;B,aNX,AFATcgL*>JRJ1_?^Wq09kg:x*l7U7'])m=WC:hY
U";+N9OZCK0UX1UARj:93?y:brJi7^5^u+gWi2u3:2*iKS3+B;MN$t^*&Z^]n%%(-
U"f'd%Lb=,AuvM)]ug\*jI>7-t;T(4ODUtJ3FkN<lWEvo1mljs\)^Ofh#AV&Q=^+N
U"u5,QiY/r3(_u0dwZ)6BN[^]]fBpk=G8?0r?mDV^9oYg3Xc44%tNu^'UTQ<_mm.<
U"UYnm(aj1^V<w6O,,)CUYV-HN,xXIef0]#S-d_&FTe^+z'R<A.s/ZOo/dbmP&)'^
U"tZ5G[m2%Z$YA=QEl(6Oq;21c6TS\ZibN-ecET93SMEPoo-5t5:ME>[-Et:v??/C
U"e*9?saq[d*DrD1HX\4/G^3f3.PLPOl-Md?:t.*=M1l(&C9Q/iJKMjV.Y3IgVJ'L
U"9^16[t?fK,Jt$%1/YU7:5_B?Tt0(DUSN/A;mI81+cnb9&O#oT+jn5uh]u'-d(1_
U"AYlq;O[jI#-WuZY'Sr=rS#^'iO0IR.YD%/:()N$=$k>plKK]7iLIJ#cU+8?[B89
U"658P9Ybh/W41S8e;NR)K:d%='cR'5R-wujm[_W.h*;QhhGg>$O-aq<)e(gp[7w?
U"RMm)#b#\g5a'n[fmt)rn*Lxh&T1n2''q<9CG[wF-R7m[uF8Kd+1A:.Fg_x1&oI9
U"[S>S41\a#XS0iPk3p_lLgD(v)G(av6,8O6QjU5$]u7*8C8B%R;a2I0kwp(Ax5'L
U"(F=a]f4Y,wT$AWuXDyLi96p]460UtmYmb/n[3HH^gCn$nVB0'(nJpBo+NZ>YJ6l
U"dFUqvVguJE++m_mpXR=g[NYAE]tr=60H.fhSfdS<E8Uf6rm#IL\-Hh0c1Au4iZt
U"ETm5JTNNrh8VGW,1cm3_dd=S5-VFIM45CY1^L'?1O#OfnQU%^RV_kk]N>oWfL9O
U"\akCgdg9RS?u/jfid?I#Q8LFACw_0>=&Ys3L//^rbk;)flS6acp<fw_p0EU\>[B
U"2S$P'o\k8YtD;g1GM+G9%9^eHl2R)o.Fr,]pNYZt,gu,sJ6g_T9Pf<kg2S5ZI.7
U"^T]C&IjbMj;Y:,Ax\x_o)VomZQmseUD^guRY%W4S5FXu\>,r[G8+?lB5p+/_PBA
END SUB
SUB V5
U"2JZhw$nRLi%8YcC9ndosh[p;;(Sk:D9geTzJjTw]aMq:cuQKEWA(XR8^dWoVS<X
U"r-i.;btqtec[qAT\%Jl7l>#x^;;f9XqQ<EipF%8vs36x4:o-^9vO;XzMfVcc39t
U"jlE[+T/=#*w$($FU0tQ=y_^TT[j]vsR.utpk_\%qHK)Z,\Ff80s(p,liOKnH-Ry
U"zeq7QjWw(L]'Kr&U^\+^&H/u2ynG%h91ZC/lYp'9tC(B[d]61\R[ik#Ff2i;[*E
U"aLZj-n713A<J=-ZoU$e^7t:a)p1>GAe-l2pJrAp1Pv>Hl$t.T]=izabEv5$ExKa
U"&1rGA6$w>R#;ENvV*vg,mr79RMnlDeUt8O:%[xQJb54G\%E/Up_<)oe/DsbfZ5=
U":;H$Q#Aq;T(jty=%\0YQa)cfsZAE]F0nsl)EXS$-w-Js=eH:.jg5ng+mLG(ejWQ
U"hL%0bO;=0Ya(m;k&5p$)SK*vexoqDKs\61-M0=X(Ws[41\YE(O39na95d0YEhEt
U"s(h3&#7GrDa5<[,s:7kQrm0GcL0X]Prl+11bLkG)9QB,^W<ut*p8A[eyu/,#d+h
U"x)lXqnel6]A,SE-[jIMx0s?r\4S%kjs+KVPa-tAuKK#3'2PlI>1T0f4#tC$1UPi
U"F?GnelL<U$Z5Lr\XrLu#*:*yHm[2?/u?[QF.^9m\Y'E$18R.rS\)(B(?E_Z20E;
U"0;o]DINQ51PR0$T/>Y21+[Sbp1oICfbm#hg.^W<GbO[W]]wH6T]MgdGk,7+$9c?
U"B0F7G(s.(d_pqOO]QT-5N=\]>VZYj1J3M'i5d%FeK2?OifDo:^L6pEYQ_g?KM^>
U"7V\:^LYd8J17MJBK<-q[>7Q=,=R;NC$5lh'+HRM?x&9cs\l=#x]_r],ni94Uq&&
U"QvLZot]9K?'Hxas1NdgOO4fBTjF8N,(2t7q$>dO])Il%tH-/aKE+'9F\cWM03*7
U"6-&emJ[*Ppcq4Q/m4N3bYn/1;D?WR6+rQ<K\xWH<>td,k6^GWaR>kvk;sHW;k#)
U"u_+g<<>P+(T$oUVfNFTEdG8?,wS&v]\rrJu6p1gSE2)-[LjEkU>l6FZYIj&H:>G
U"Xo0QD713fDC%d<cN=(p$ZrpQnQL*$r;1DMUHp^V.G=mMVFOgfV44Q)JjrbGCVh'
U"$):pj]/n;XR10+3TfNGJOib#D*CYE8#&a:NB(3^#DK3L^th9-=.PoV;%K#sjWJ?
U"i[r*A/c\nU[cBD*2=F.>f:i#\uJvIZhk*%+^jd]j3FG&6)^jGMP0D0O4Eo_$KsM
U"<,5Ux6:U5'5oTUeej0QEMtd\2i.fMD(mwc;UOG.CJ<\2zT?<32P3-E;%yBB:<\r
U"TismN'cA6kn42#a'[M;+FY&b[5Nj>)Y]6a)xGRyOIB60)58GPF?pNF5Rj5aIoqJ
U"U#WD3OWE[X<h%W\GcP_n(6nU4Og(><rc?cMFYM%0=dE)dy>6>bE)(4?;tQ&s7VA
U"YE>-?caLEdMI+U/Th2f*/P:th$KQLBPkIY/bne<N7St=b*cWUM=:].f3K#h=#T1
U"nkVQUZOJHV^MOZ8p&]WC<e>PB8R,U$qT0=M=;<m?-bQi2+d?lSV1E-F\YOoX]BB
U"DL4?3UnzU>j<P0QY)Em<IsN5vrfKmCYlpkKW?up6-g7bx[?Ac]Hw?+ko5?x&uvU
U"nT8cLxbFT6k-63g/,&j>Ps2FKrNG<q']-S&/'iuFu,l8B;o1<(/[SjUxmsTxsk0
U"^uAK<<((C:E4w%a>l,H>fx#LuC2dtm2JD82;5HHt8AHo=v8$7_>bpu:wx=g=K*)
U"alXOZ7T(y]Rls0F'Y%nfl<5ePtd_ve)[WSsR>yN0V*iA6r/a]P>#rxWpF:0V-Rp
U"^^.mCb3$IPwz=[lf5FC<hU\*b1c4s(U2EU#0R^2*.bW'JVqxl;g*](Q$1g/Y\1T
U"SQ.IWZ22rjn8As_0)]H_$dU:5VPEtdf4>3AE/<bdaWgk5R;,<Q=y.19K+]UC+?\
U"1q5'ZP^lWg]+ml?C4Fc'X0[Ln_P:f5Gbr7BCn*U'E>;/8PvOHeCwjZZlT4#AuUZ
U"ifP?3C>Pc*Z+zka^kO6O&$,6MsUstYo/-EK4lyT0l\tNd0&S$>f/In%6?](L'0k
U"(WMYdq[WCuYcpMP.O3C:uZ>/k\5JGJoT6p*P3gRw2aFd2jcD)JRVC\_\gf.\7Ra
U"TNfCHXw&d]G$xABs1zu:;]'ufmSS-+W:JaBjz=W8iB,JB5E+aZjmadRg12'98Qn
U"/o0f]UM':Q&IA,?s,8*#osYoJ%BXEUl0q?anee)PXx[DgVeb^G=aCPPg&=WUOwo
U"eo4LI$sr:Z*NNDv8_6As8)i'wV>Plijrh*UI,gwOV6:83+wN.-cy+;4:</s[u;%
U"Xci,8K^k$V:dH])3rJl9<KCM';x&aST+4L0s;-ai4;%+[M0Y7fv:m5YN38.Z<$D
U")IcJMpAQt^zSQ_cNc?]vSq,E<H:]O\1;tHLt-lD/9Zf+]X2I'a+$K98Jd.th15g
U"lFMZTXULLc\&tjRmr0gaM=OGWrzxVgJ^KjPc1%A*l.ZCVuI1PSV1D.PK?>34dA;
U"8&8rgm32/Y+*xuL#>QPC]k)?O2I/ZKa.JIU4-A2vn1r1rJIJ<%p1uw5Q<(?96xI
U"5jn.z_MaO[Btjx5$%Rv]P$B&yFZF7eaj>*E=nChyIU2tbys20#fzVp'*;)'xwS4
U"H7[]DX-*^^RER/QE.3sW<>F.-QNiO')AU;$MQvKW[8L+&-o?a/:;K)er;/,Ys#l
U"1m4z_(>(>bq&c]Vorfc,mB;C:(b7*/g&dx%*YE26W_f/9]#6?v]3j4tC#9vW/JS
U"<&8i%.&.V(]rdD\h<<Z*J+iF*umib>Eru>%#LT^rM46;wftritUIJ-1d1F/M8ZI
U"#XCf3DO9f_q<vg?<LgTc(O[wpBFqsK6C.*b)3/^g+8M6h;Ia8973_8IP=^*tcJZ
U"X%Be+KF3pW^n:dmg#'d_SUGZ(u.T-f=L[0L8S^D^4vE8$%VVq,bWjZpGUOu+\vq
U"a>>F8T_0p-$Lp8E4+4(so.)(0#j;LmBP+NT:;cPukWoG'xu*sKDXzE/TPp;#;OI
U"+[,v?-pNoHBVSjiD=gU?Oul[?L5A=+PYGvK*Jx)%adoX\J-=8H:&uALDg_ay31A
U"\/1>>ZbfQd^ZfRRu(tm$v5TV8q?]&HdF+njMlT%S<oB=n^SIJuJwYal>AbC_JF+
U"KL1YkEfB\%^52F^S>jiu:VatYb]<^e)CMXGL96i1=SKK0LLPQ4$06I9O_H968SL
U"(RZMEWfS39]+K/2d82v?a<_:,y#h&USD8RQ^sE7EPg9=NNN#7vN5,h,8TUqHN%W
U"HH)so$+ccV>m9JWHNkQo0=1d-K0RzKhYN+aw?9tkXKjQr;w;Raw^Ojpj(bC9h^P
U"rW]+hi;Clsa7h>Y-V,S*FT2GpY0ZV&1l5WOX;3tP$2v3bYQjgaaH&G7c84obZTn
U";51S<FB;4#1Ep2wMXZ/%Zl:EJ8pQgl(qMmxzKp<JV8CX^k]_rpCRXg\>(,a?bB%
U"#PbVDXZw?VN8iF_GoBV&4uf]9H=Q'D)J6>iVtI]WC<E)tVJ%f4243=HfoAtMfVp
U"&qE6]PKPP9$McW'ksjtPd7mO.&>cXdYhts9OrJAa\_6\;nZD(WQTc)dCOaK/9rD
U"G$IASLW_,Oz?(<*SiLTZekGeaR>GJ:F4T6%tOkVJNQt;g;dE/VT'[fCBBvd5Wrt
U"PB?7YGo;bAaU1DGuMw(x(nYeoj%5f46Wc%>5.l18akr5=S_[aMx1$-SRX-oammx
U"HR9JHM.K3EnZ]3iN:6&-w_<PkB<-E,9Yz:8lkD)R/$lq(1$0/_T;GJ%V2^%m4.p
U"BDh&:UGMOS><X])d)F=a%q(qZK,Umd2^2XZO-fQRsLv;bIVZ;;8,i+RlH49Lanq
U"(g'*:ffa5B/VJ8=6;4E)c]rjuM(UE\H5^&Etm;M2X68zd)udd%KdoG^9YU1SnDr
U"#+[%S,an$gTeQ_55V\pO;j7<p6T=F2x(AGRkD[$q1$>Dm0644'tGHR$oj6SVOvI
U"/OV>AYkdofcZAw1(%]kwZZiKX*/LktkWgD[cj-C]jQ2BQIh2&IMd+ty)-5+eHO(
U"/n+OHY[N..:P=Xo/h2ZfS;/3mN'N\*A/\9t0GFf)/d#hlh&t$t9\UT6ABMr#U)X
U"BZvXY+D'Y[o5/w%>dX)<+9rv)Eq;:bf$hkgY4-Q2gS^,NFxZu/\LR^wgyJZLjSR
U"17hB,n,,MxAcookV,:7ph<,ZU>'u?b;/]FHQDVhB0W&YwT4^vm>H2sv#w.AP7a+
U"gvD2'3DC\qUr:\AU?<CKCD#v/RF%SkVf?u$qRA.*PztUecC*)sYQV.lNldFDo\D
U",POKig0;n4kdp6z;7S[tA9J#$P[IC,qEpR6j[b=v,Q,t.M=S[d^7=v6Wf\)/'n.
U"o,krr=%H9G7r8pY'IIsMe10GnYcyZV5[9$$f_+gv5ShMAQ2,-nx_3h?'+XoZE#S
U"kbvpG>#u$DQ]qM[K\X^#Fa=^]]h,^7XD]qM5_\j$?Aj>t>AUHv\],dD5#HV^Q7U
U"8]gTAk\n:aHjKveVL>o\TduJ*ZlIA4Eel\m2htGMfpuqh*jdW2*3=s<<9q5?/j\
U"C61jPzAUsHQH;ytz]t^o85)JI'&.,\L%PtW9N3]:pZv;P;^dKJZ1*[l_0lTcM,R
U"&INL]ma]M>amRz,)C$iTd=8Zxd%up()%9%'%#-%%/e0At+>9mk&.%%o)%%%1%#%
U"%j'&.ixy%wlSgIfx\a<fZSe=5?80Kw4R7[#F2S.<3]w;WH2/R?Jj]K4t4jV[-13
U"V&EPAQwplgFipa8O:O;khL5NH?\9Z8O,l*OQYjfnH%[$6][K[UMBXj+h8cg:.(o
U"d0g326Muf5J53+A*E8WZeyoG\Y$M9j7(P<.O[9W//,t\(Sb;E)&D&GX\3OE2ng^
U"':j#Ks[S-%F,[qcc#H&gL)pYiSdafO,O?GbxLq)(Q%W2fl'z<_/Tj=soePSM7&m
U"D]*FkfAX1,ViV+<s9<8]l$##9c'V;=a6U2owPXAps0ly8t(J-A)^6[dP:dg[QCT
U"Pz&E:)m)^icVFH9SNs?qubA2cO+PEinGF4cnUklX3=Ie]4mT0kWmkOP1<mQ6CId
U"UEz(([pvg[rGf,9[.<6.<fh[/]'E*a,6%*^sde*r#\n(:soJYjZURe,W;%hCjnH
U"UjOZjmvecc2s5A1,w$Qahs4[Y8-b%T,7<xOJ5\%dNjP3.'--C5C][zt9r5qe#Hi
U">]69k7v5bOpliYOgABZVv#-Il]_wvL%bbar5M.Z/UA^kuFPtbjY*yr%\n)Tfo[?
U"UpUlx:Misyv)wO0(<k)5*:Z;)c;\*'T?X'[WaGr4PcB:d2h[s)'j/cgPZF>5]8/
U"f]\YoVG.%up()%9%'%#-%%/80Aod(6HM'7%%)*%%%1%#%%j'&.kxy%xySgRfx.c
U"<j:Se49#NTWmNqaRz?:Tu=;O.lT99+g.ie=\e;/\%UtbmZg]g+<dN8p>qMa[joR
U"S<pAHXhPLWJfPVcfS]\0E5Kx6tbkC[,nKK3=TSq^PU:941H,t29-XaxqwhpH5>7
U"WLA>2%iZ^CGur94yr7I4W'f^t*<I,ij]^/9SfQD$na5bufN'9YlQ)bg3qM'n)BU
U"T3n/&IbTbN>oOR0V<wl>mT+QJ9j?jkC,/1vCE,Qs9b<5Oo\+_mA$m4k&rc8%$aL
U"f<3=xHlY,hN71kFXII%xjIuWQGt5U#dobCU[6CL4Sg(%3-0%PF3/1(s4N/_5u0%
U"]^of(_<(0i%>)rnq:uOf+B$2aQ79HK0[Gbt6s*ea2u8g1krAZ'_2v/X7b_\*h'h
U"p?RqO4;.JW5=$UdKT6(:?1^R0;-dczS:+hU#4ct4LP%VNNcL$.ie+#QozQ49>=Q
U"4nErQTC>an0a:>c_XNT=w/.)'*mo;n?S0R>,;*,C$J34O?2ddA_Ec.bgppB&<Cz
U"WHg4%+Xy^VtHgpkrSR$iA:*QGsLkN7Le<Y[Yt=X[l5&q<qH7TCvkbdj8&P?7r-E
U"g#U$4\wxaDGLC\Nw8nKe2w6;\:iTXv0lQ4fPBj<Pb:W(7jSOWaLGf+&[_=evmhI
U"dZD?7jnOxccTn$q9a\'hQt.%PqN/nBt>/enb-V((=EqIQ?cw0:i?RAI'u'up%()
U"9%%'%-%1%/0A4,03>'$&%%%a)%%%1%%%1j'.q%iksy%SgfxJlx,>Aje5K;^cxU4
U"g/QPO0RHybk/7:Cl:.w#*]rmDy:]+OI7CFgvbNXRb1wyKlw3SNh=FE_5E4V48,?
U"&l)#n:$K^w$fWruQ0Mw;0)tT9>(CSyjpx2gEH'(sAV-HNed'r]+EZ(v>$:$\..k
U"Sj/CdY_:iwwjV8erY8B]jNkEdz&6ZB59\:>aFbPK'Cq8tf*x*jylx$q-N#mxaKt
U"+i(t]W'cu<A;tKfIE'102QKygO*DW&21Ci\mjQ-Pq31Uv40NEY.e2W\G]\Mp_.)
U"wlQiNTISegMwCMXsU5w=Z>8ZU8b/wVXRUN>BO%k?T1D^imOWP(8IDxM.HkS,YOA
U"j9;zcBeXD$kl1\J*,1:<rU=2fP&BEBg';XWTx5o#FPO?jH42LLF5+B'QTou1,fz
U"5/yfp:/et$#?'5B6Z&Vr$PBlBj-OjOoZ*a8%TIt9p?xOVe'g3;fA*<]i<2PwRVo
U")j+W]TA]4%EM\IU,)m##)L<cwhS(,KQh5UcL:;GQm#ZPU\L+4Tm;.idRH9l[qJ5
U"WQ&<6hrI'65b,ZUbkwN?hQSljgAIxSSa_BproF',\ViDRfL#C1jo/deE\\f5;1=
U"b\tj[\eJl#D/R8RBuRXc-8+KwTu%p()9%%'%-I%%/0#A1(f%:W'%%%I*%%%1%%I
U"%j'..gx%k%ySgfCxdy<)Zje5iwM_x(Ud0Z#jINt2c+*U_5<(?s)n;VYv+aGXL$D
U"DqF<(xZ74ci3PR%5P,pH525nHkk7(_%o$%]gT#GSH6*6?GC0=PU[4^<A(UTBWbm
U"P:EuebacbWlgDf$'pGkoZHnp%ZAR#65Z?%vX)/D(,.ob[Jdc;:ilLMJCtR:QXd$
U"UFPaEBJVbTF[6GoLJ-*oVe][]?FB]73Br+iVQxE5A[Tg#3UQ\Rr1bpv]qDgq[Zr
U"hG[7TTi4gsoN1tq'5;q?d9Z#fTipd+d9j_w*Tf/^Y_n(/)t'_%t=/1*tIKBB\Y3
U"U__%b5hT)?L5ezWD9OX\gwf:\;]of_fzZiU?A:0\HD]d&d$^-cUfDMaad0M;O<1
U"/;1gpt.hnoIle4d*W3SA(M>L1J&je+[k]by9(gAeaS1lBz0oBJ$.m;3wNHRi+u#
U"pH-1[\L?W<QRNs06k9oMEquC:u8WE8be>$db?h'M*I1O\ZKWp/.91U>%(?p_SC6
U"R,ij5Dz&I'TCOoeWgi#n+0R_/&K=4RENxIJ%,pV+DC:ix]A,NCiMQ^L7XHdEQw?
U"D1C'nI?Ea6\Si#bvSI&VX1PJ*9*qIBB,Km<Ed=OmZiRP<w;ck].+dkY9+&b)^da
U"bFU=2upB>W(eW&udOcM+'L\k)NQXm;SG]TWnzkf6V(yRV\%<msy(au_;kiJ3o%6
U"p.=wh7tM$[*hz)huqoxSj;rz8u%p()9%%'%-I%%/0CAN=^'h<'%%%e)%%%1%%I%
U"j'.%gqik%ySgfgx\af,>Ku9c?8TZ\N]F[kYOuY6M2wnQbDweqQtY_:<BPCto'f>
U"eJT]rNPJ>pk(RW*snLUTuluGD2BoIG_FC&Y,-v=)&]<#(q:y<%t31E1^eUNEP$j
U"[eoIXEO3BP5p2YD]eX<)Z(*2SfU'/A59&AowE3)ot%9;=2\n)L.OY#f9Y;+gG+L
U"$Pvq%YT4n5PHCu.lp8_2)&V-\Trxe;C^Bb-;>yUMd)Z#pPcSG/(lVP3r-F3/0Zq
U"Kel?U:pv;O+6Krt*1a0WJd9Wlu[xlrf$ADhain^wLN%_QyafRPT*nj7fOeT?c:x
U"Au6e?/hYiY+VO?A042QmgNru=W7=^_/7r\01<tk>4iO5xcEd0S*r*+]*by'W>(d
U">cioFggd(2:F%18n4JI+dWr,ZBWhNUCjeH>3M6*fii/$Oh=59xi<w5g;3TBRIU^
U"5%#gG(CgmW_0dAo)7?;&SWrNYEVOmfJooNiqia.ES=:h8<Y.Ct]=B*ivDl,;;2(
U"7d<\>gL4+\#M_ir*(,rbwKY\Ed+?xI].(65Q]+,[.fKH8+;wAKCr#R6eB[CKou:
U"*j(T#6rDpxr[pU/#>b(JYYmF8,2,NfHs$LZUNMp6i<#&lN,]UINgSezeN$<-cPC
U"vZ#l*rL0Q6xBOhRfy:rxTosu(HW5qLFwWnK1b<2Zro?$^Us6k.&b8%up()%9%'%
U"#-%%/n0Aao+pVj-7%%t9%%%1%%%%iy.hm.g%qiSgIns\&C2;#&sB8=pt4Xlr<up
U"g7+#p7qM%sWlN\_-ZH^1nc&)H#UDsxe$3'\#(XATJEnj6'\Q*)\a+rW9/.h(U)[
U"1=D^.hU/7AuyFR&w9Mx.=UHuf?)t+b/-Nn47WLaEXV(frxZf4uXvWxud6p8MN-L
U"9O.<-X,T*KKV/jQ,L=U#'(=2VrV?[97D[QHSO&v]OQP-MTZdPVRuI$Isda;2)j%
U"u7X,Mq2U=7[SBMzrMW%U5V]^FbnaZ<(dqSCbSVdYRbsd\U#\GXZJ2/Ie1cJlj;B
U"1uutu'P89Hs26jbXQ?mXHO(1./?X1P(P[C<5t#Rk:m^F=\s^=#JoBFM4Xl7Ur/:
U"5\32lRWLgFAElCpsht8X,7i$LNpj*jjiaaw[uCUM1.K9dPNa.xc7bQx3x(#MB,3
U"=:W\X5\=*8Xh=vK[c1X9qGjb<[6=?'jDGff_mhuF-r*A2hKh1Lu#9gE3dwx:lxh
U"w9HvdyLdlt>5phsDbp8hxbe7opZrX]nZj8TNtV8gxu5xTwbnsTqux[8[ev'KYWn
U"P6P%\,3+.c5w+/m-KPS?Kiju9>98.(IB(r,ZR<E5Zvgs8E<Er$gLE^tgB9kJuir
U"+Xl/hE9z#PZMnml6Yvo'.C'n*9X)8'8N'x'_G?M1^$'-7sHq7Yb1iX:/>)NA.aD
U"KVQqHo^Y\*(2u#Qves&o6eu#R(,N83j;A>M:i43FTs,U7;_1<9TG0UMF$b&_c?M
U"LiJY2JUJ&pCe:iFy19MsUuNi5^;N1)>U,G;b$pi1CWKJ?k<ATgGNWu+H+6.:jTa
U"iZmfJ1um'av]Jtk8aAvfm?$JXlITj.\6+*lVFV/TED*;[EsaoJQkxQb*qv2H?Mm
U"^0*,X%ncC4Nro.yOtA\[yO.OV5:r[uM=pVkCt<Dycmm03E#++'[HHt>edfN>#BY
U"uIAP=i2ddl[mN>hUpQ]$NR2(jE[5c.&:[RdL)V(i#8)fB#s5])1(9Hf#5Z6SeKr
U"F]<g;oMKh1VuWbHq#F,RYvO=K9<M$U](.3?O>(fKcz0KJTQWJ4W_Ay.mdRjel+b
U"yKk9:Oo,QCn-Qj[%37<%XX##(%geW#Lm:e'eRGk7T5>/f-WS%FyT0ODU)jcJdix
U"CP+Cm*%cPFPsxDDD(z_5#]'U_*_o:v^kS5#XXhj+i?inQg>nPx_Ma&P^OoAH3[j
U"v%E..KYK=ejZf01JqYA4'Zh:$.(d6J9_D7Y%BB(\]tslwNd](?1yWAhqSbLs6y]
U"T#uIDmm9..G&>5Ahz0GM4./isD:jFl<')cZN*C;YRHH2$m6vU-j1QMeP[/b0#nm
U"y4DH%:l/MYpBB=]&l+=Pa^hPE&<s9-DSnqNACI]U4DIzZDs:lA4XnhYKJE%h6p'
U"\vf_o_Bg:D<YA=,x^(,q>HDmTmj-AqyIs-:[4V)8-yD,,>Vd^B24N<$M_],/=jZ
U"Z.??/j5*N%Rg,d%/n)Z$CRvc4]OKM03n3hP*p$b7_0MvzFH#osn/8zA4<UF_>K-
U"uZZ=k??$5M^l0'nFXdMJ'&?+B?ZzZULPn7)%0=%sBDsdhka.U=fHm2,HHs8T*:)
U"N'N?>a')\5bEoOKuZWSPQMmmM)VvSHuQuwtRDsia;Iw,R$VHQD7BVchLHnV4+u]
U"]y1B)1lV[kkKIOZP<#x[1t,Ap8vs&RNNF2-04N2I3E>Eoif1#25:]'LO\?)A^oT
U")163NTe10Z.Vacgc-$P9nmOR%ksv9=NX's\3rPCiV)T6Y9N%u%c*BEGm#IrK]C'
U"b0FNF;B$Oo6Ro8^z24(8D9*PN(KO\u\^vAVmAa_J(Q9^J/NqtytE0NmjAaHnC#g
U"Sz+M5tQ+9_De%>QUK-SB[,f>D,\;)?t]_HC<?:,6]WHp6jdg3;CtM4nRh<Ak_Iw
U"YslC<ANo7^4<Fah##Ts(ixp\C>P=%IosHq7HJ=_*7lD0q(-?<_Eo[-F)s/,+)vu
U"oJ%$uO2m3s2pG'2Q=f6H<+ZbBaIqN:WBVuR6G/1mhxml7_Bg*22)*uYlDP&ISJM
U"ztXXOwn-CeNblg]hD,\FEb]dh])z^-CC=KfFqXK[qvoYpj2D%r&0g0l#m2nrs2L
U";KGstRLr[/:pki[r6n'/G&x:J:N*f[m\mC<#5EYa(%XLtSYm5R=gjE':9U[=g_p
U":2mNGxr&l&<m:?/&*;UL?nus2Y>gJ4U)tPHl4lZ4)-Ce0YuDh'&v^U5'UC_+7g#
U"szt;O?dn'>*nQWyhwrxFqPP:\.iEY3\_;\mXEXEFd='3YCY6V9>gCR'jy2CXQFx
U"&V:vUYAT2yC1XaicADKs<RD\JVQF$5=#.TBG%'Xkd;fk6MxuGi99%Vya;Yec&Ih
U"L0pV<n%#nH/4DRuria/&/ca=#UDC[]1L(7<LkV;*UsseD,B&:G:V2irO*/x_F>.
U"PN>rfQZriat&/ca=%UDC1*aV,H+CXktU,4X/_[]2go,;tITZGeJP=CruZ0R-uc9
U"Ya3.R=k,m(+$:YW#00Z>4TyJW^r4r&/QO%RP4P_eA=7K$Tpa=H3sE-94%n/#&r,
U"V+O[1,?4]<#(okhoR^%U0\]$2QEwnyiR<#5/SABY2&i23:eBE&gM=oJ3N+XS(%m
U"5LH)_+Yh4_j/nFov<E'-/IQcetoAvs%I0c)//VlO[5J7*':a1-Dmh>BEc*UBTrP
U"dFcX<5z2GAP0m[*2OV\d%bDo7wUo$CA<ECr%zT;-)x'u%p()9%%'%-I%%/0XAvH
U"u,>N,%+%2:%%%1%%%%iyh(m.wj%lSgnLs\'L8W##:Pn,EtlvK9-A)>vSFXKR&'N
U"Zk[IFv\?ZoMnDV2]\A)g?ZK,;DvgIMjS:=5ZiR0_-AVRkZ?s^FslAFDrHc_/Y.:
U"d)JSY1d]1o1.tgEPa<c/]KP2mU?.HLj$KMFuCN6jf&Y>Xl5(Hlo_LxpcpP63>(M
U"I%a6m-vI?FS$8Uy]62VGck#>=/a.v/5aAK<Mn)R$>X+a7el=+-Am&QFH6'_W1tn
U"n\DK8heX04Up5O)LYy\:tDj6i6KoVGJC6MbI]nA[pvTrI(3.J4SjU0.a5xs1C;?
U"y00UYjnoCr70rP3_uuHZAUgs[7uqs^Q15g(a](wQ#=hh[7Cg1T=GsWrLGgSoLb$
U"Snb_+R$Dk,YM>c2UZgFBg;FbVt#p>OT$Uk.^n]l$q4wgJM\8<C>k\ortrHur8lX
U"ojlK&omTK8anxFvQ$mE)TAADkKGQ5%OX(6=&6+>s.]Qk7n-5S;bDZ(Z1C;sFcS[
U"T>DZ1tKk*urqkhq&j):#tyIJGlcjQbHbajbzbkYmemc7m<b-7-Pn)A(cSkjka5a
U"G8G8FF8LNjIXd8kc8dL2YBOv(w]Orn4&76$%;IWN7zKw/;N.Mj$Cpe4q/$bPj6_
U"Du,P+hh3>4he3D3pW,'&ygtyBcl+sa3)u-z\WNjcvZc$cF3c$+PnFSPBr6hd$*/
U"B'c8U<jOnMBX?=(E^4<$:rx6rrK$8NbxfEw-C8hU5:$r.ZSTrS6SPDi)](9)/H<
U"S-Q5)K1wGzWiMZbZ;v;=sfKDsY#VMf9m:v:W6z8pN8vNsuXN8Mu8NL>jwj7*)(+
U"M_3>fZ#'>#jYkeA_Y?L$Qe8#><UWo\SMZA#FtAt[S:iP=CinWzsw/hX6t<kqaXb
U"_dG]BmUKLMnr7iXws:h0OtM94vWFb%T'>8gM=,92Sgc-.COFr('.bGgH0K'KJ]V
U"hBI)f'AVd[1'LFV0:$2+7Bs%[w/HTiv8skDH'DM*WEfp\GcF$Y_^R](#_*J&#i[
U"SU;D#E$Cf(yzRuVvI<2u8E).SOb;-c]'=hzeLGfS+S][jsgFlO*IFc+%kEE<hxk
U"iI]<-3xW#E8zf%x$bahC2xx7K?Ob8mb5cocauR.O'MFwTTB]AMOkA&p&1/gK\w)
U",X-fn[rKM42&tC&sEH%r:jeH\_R,j'q\qzdCm^CIQ^-c-Ymdb<%V)?r'Z,78WQl
U"jCM=>Y0C2E$^Os,I3oOedl^0(ZaFI7M=n)^V68O-t'#;U0Iah8M+wC3skP$qqPH
U"R[BBg+X#ekwGog_PSmoN7gAjh':)Iu-Q#a0rYWqLFYk>$mqLEGSs3c#RiU[*x$Q
U"8THP*&(B#5CwnPq*Jh^dpk%Pg*RQWo/pyWFw_?Iz_d+sZip6FWLYy>dV=;L)jI9
U"Z'^Md9PSF*aLgv0[Pu_F\%gmx^>tL(3+#TW*xCmc0(n?wIHW[meNh+IoCG6^dr]
U"a6cFFmh;I'JyOzJu6]8o]XX4vBZg7kFgDX'X[6Jstp/kuQkO<exj?QL/>%w$qO#
U"FIadVMZk7UMRdXmkDK7\Nsmkb,VSNb;4>qD;i<%W5UQWfBe%$odf$$-1+&RBC_B
U"b)(B\gJhw\CQaoCqmW0IPcE_L(hDK*DLPmm>DQM)LlEj%.8L3j^qS;ovRz0o1GJ
U"J3%F^wn8pl;vmnMq,X+K;x%u-5FC$I5#Wm*y?Ddk,%sMlq8<q;;E(];sDjn4+%_
END SUB
SUB V6
U"qU<O4<VlA:o-h&PIHW*m6jrvG5ktev:PT413m\4Bivpu>V='/QaDMU'iRNYdmVo
U"W.s71-P8T$?/bI(W5,>bx.,=cF*2(t>*$sCgVDz&GU[eNkx]pc+5n$MEgbeNrOD
U"0vxNb+Zkt0o&378oM9jah[oYcL[qRD6c17t9is$$pQZ&]lu-?rr%9qk&.yd]d%f
U"ClEB\Zd1TJJaA[?:R2#9Tb/qjNOpWIBZ8dnM945W$%97&sI.RgRlFogAD5;H%L#
U"7L9D9Y:)k^RIZQk^zfH$B8[i&7zSar/-TFse2Th2pA9YU=UX%/1UyWIO:MBB=QI
U":/=2KVq(4GCB7zv-mM]-=<XRv,4K;6rD_Ld+^B*[(I;JyiSn<.K/j<i4i(%8+?E
U"EUj\t#D^_B,\$C^v5kd10$ODYn86S/gTV_7$^rdpYLSzhL)5POY*J=G9iI_Y(UG
U"bk84-=<,e,7Si>Usa1ROE6+)Aa/lyH&OdK'G3)c=E)v$(nsLMDt#m^D/0GYGRmq
U"cX6mc3(Y7qk)[?o=n+,>EP?A1f<>M6V_7_GQ'G])$U_R).[8V#M9HiE+'nXv+3c
U"6q1'qX>DS9,;_iWPyc9)N,F>U%-Q6D'n]%c_OEHgoHz4EKXm.4GlM(($skA[?_g
U"H&Bm>JfYVGnH\kDWG)/)W&t&oTx5EojTqdBV??F1F]?WZWR_F?t?&?cp&ISGXZe
U"rv*Rn7S#oGb+_yVC?8?BnU$?pC?4]Mn=_V-W*=Cfvd^ek(#tVZ9j80]nK6p6h=1
U"gR;UIM3K5muAqEP?96Ug(I'e\6L]WptSnZUlo4;2k,)Wm?I-GoY_)GG?9_ZNv;c
U"+E>o]Yke\'MUCRmO'w,up%()9%%'%-%1%/0A>r3h4'r-%%&0:%%%1%%%%iyhm&.
U"nyq%SgnsD\&4;(#6:du#$t\p$nHo[J$\PQ][ispmp6=+J6WPYDL%BMV&\N_q[d3
U"N-e*UDf,\i,5Mpa.Mz&+CWwyzI%vs\[FFir#H=EUCpvSlTUWQg9+vC2/)_<:.i9
U"')Y,;4NK7d=5o7TOVl6hLhuvWtWZpWD*#tAh_K4$2W;UWAWB+Df_[=q+J1,Y/-A
U"0q?p'YP)8SVTvx?(ZOIe[D05MViJ?J2<TS0Z>UnK:x.r757]x0?x.Je[L4IQ;i]
U"(DI#hjdRd;A1i\>9I].Z]F>u3V%s.[v0wdbUJG.S</(V<I(2Sfh1W4/GO2=gP[7
U"ZQO1NwPi_.v1DG#<OJ#k2Dgd8Xuf^DJ7'DFb4FsrCn'>:+H'A>^*6%C4c>/KOGS
U"Tqoi\J/),^Z_Ippc4I,Ijha&J)>rdjl$IfJZPJxqMC7D7h,7Bac'Iia?wI$gB#g
U"tS/M7I[7YDst+m9kVa*tQoC]E;Jm20\V9qE7(t&j(Yjd?.;+<jzike1b1b^qWjs
U"H[p=ejia5/dQ_DRLLB(K+kMZKuFHU;K$5grwj]<9h18LuuWi#Q;pU69;L<da-x_
U"ujgqAqh.0[3DT)p<Aqcod2xVwT4vXss1vvxS?3vuBTn<cn7y-W+k724nG=sxCbT
U"wGvbL3sxGh7srt$GA?Rmck$?A:A\4G8Ya^DHZke^m_Z_gFU01Xn3ci<KPra_lb_
U"/8k2_tqba4/rD]cj=v)m,fJdja(e?o^[E4tj-t,ogaJXvU$Z=19*qeh9*(*8r*.
U"=wg=*]*?jZq,o\xj#K[d^.n[T>>0=u1Q*jPiV0*d#]rjl=Ha7HJwP_1eGjP:?6k
U"k=<ZuWHf_OcFLma$GbBjb>l\t-ZWYh=?$GYmGnlT2s]5PR$H%%7jiv#QgKb^oH]
U"AD?K[lt-Ch%5hXwU)?^Q0*#^dcCRi9HrHd,H6f#xiHESwThn%z*G1VG/Y30)xt?
U"w;NSRS:DYlF__8C5gf45%wM1^LgP8qM+U&OvV\o*xRem3CjfpG5Z$[Xwv=Y+Nr+
U"2'7#hQV?PQD-%9B1rM1h/xy9Y#?$JZD_t2n4nKqj%5o=kU8;3AT<Km2%5cYbG6d
U".Ce/q&3T)iT7GJ+^DhiuX#gYjRZntobeWRQ&4-la[BSYI_;2px,xrkC\JCH98'_
U"NxyG9kwVVphaU/O=#:i)>b']*(wgUfYWLONq:]k.o,#f)8yB>+f:HseKitMY<T0
U">1D/rr*XXLjuV8/#I__?Ysom'RtAN$]My\qf$_bbBVppEaW\NQ.bDG-$#JnvchX
U"[/h/DRi3F7Y=3snS$A\O2o6uW]TE.L\\3[p88DXPCYbZBJZ0Lz('X((fzjp$Bsm
U":i^&Ip,mJcF3XMo'QQ2r4q58l;fqN&Oj.8</e,2ILz89X81=?etKill3_0]/TBz
U"R$P$E=*hU5Z(($)1FLr*iO?f0%ER137:<V]jPuoBBLTcNVX3/)h<s+tt0Y=VkyT
U"&*ger#1i3DqlcL;5jeA>(V^v*9$q3e4k,/Z-1E$gF%e6mWQGF%EG$wsOf2gDf0p
U")klStCU'Eq_5L>50=*l-<J&_wYP;161b&OVGfDy$^23AdEii;b<+L\Eik3p91oU
U"[#>sH.SBqbD$-^lT-<pU,v4c(s4CAMcMP%3bhy<U(G8MC:=6q7-W$)Std>1.Ia8
U"k\e&P#q4?(Luc;/%'r5_(slvX*hH_bPUUKgd<Iv)IRP,Ru^?U>-+nZR4nRxwexU
U"v3lk#/7_->7iXEOL.A;YSdq,/L^(*V(WS,T&Va[Hd(tGg54K_1cYE+)^K;7)xwL
U"J8Aypy;u_;Qb=YO-Tku&()1(eR2hKYx3.tQ81FIrw1<[4uny%<g)IACRb,uNCFm
U"NrRl\ZXEVB#hA9yQ<1?:*l%8C/fZ[N\E&hqNn#?)1[b[dF-+o2N\&yJ$7;O$:Cz
U"yZ#u)s>p:'Zx:?%6m\/VU&S0gzj>a<?Xp/eDiQu]VPU[<I4Uj'WG69Z5gD+>_EH
U"0+L<Mkd5-?6'B5R4inYJ^gU)%\q63FJ0(TA?=l-vJ.B4j5E19PmP?n>1z<'V9$K
U"=wN\tajb_B%BMZ+,+8+yv6l*Ue)YS5fO%_,<+2[z*JtWgS)hF>(/*'AU9Gpr>MH
U"XL*3ntppiLq8;;o%Yl)NnLL15G<U>,MBn^fwBul\+S9s.J^.MVu4WYqpAR0.JO<
U"$gvzlQIKZZ6sz8P'rg3fGaxlROu>LrrjgS,,^(P%Kt5E7Fe)t.ZHaJl^Z_>Wd\?
U"E:XL;HK+EoZVi$&uGn.S-V*Bp;g4>:'9lM7-9PWKlB;jA2>C/xW-dup'8$\]$c*
U"bP\+Pl'6EL\2U#5JjvBi\hAzA)uY#,i4FvQE;lT]bslZTte7M'ujPAq(en0zasH
U"D/_MXBc1p,U;ZF_ILAvf1%J<r9;Y.uQ4CWm5,gWcIG.xu8?3gdyZF?L-Y=*S.sh
U"Pof<=JB]-3[S.k6NDPvo7+&cfP7Xq1^K)_ggp]o^r-UIVPaJ'iX%j\f?X\2;T)n
U"-u*QK]VXaSiT_-3r%r0<-M1-]yJn(21h<3O.%c>zD#,ys>d0,0esJik1\fUWK?S
U"nb2Wd[]>&'Z$?<Y+52Y)NXo8PdSY,7Y4T=lNH&*w7H(5?-$&4Cl#y&*#j=\*wA:
U"Yt/QVAlAS-=cpT<Oo+h3GyWR/)+j;35[lAyKvA/+[#>%VpLrc\g-1Ct^;=ya=Vt
U"Yj)3T7B'9u_'m*ZRF5mC(c0'G=<SX7Z<f8Uipd7Ey5eSzR7n]2;E[hE]G7LyXZp
U"uI/j][&<K>kwH;uKK]^]EA.9'5bB%Bl7%g\f%]5hS9,Mrm9%N>lEhJ+mc6zchRy
U">=GEHH;-]ZQuS\b#i9K>#7+m6B7#En7R%NhfBZJ%Ck.PvxlD5;v3$;X:TOr7C8<
U"s.sO=MI*(]W>TAP;w-g'78R?[fQEM,CHiuFggO\m3fw%,up&%'9%9%%'%-I%%/0
U"=A<OU,A/t%(%O[&%%1%%%%%%%%%&%E%%%%%#%%%&%krfs%zfqS&&wnu%p&'9%%9
U"%'%%-%%)/0A.bwCGc#&%%7%)%%1%%%%%%%%%&%%E%%+%Yt%I%j'.%ihmf%wSgf%
U"xup&%'9%9%%'%-I%%/0mAUvk,v/'%+%x,%%%1%%%%%%%%%&%E[%%%m%v%%j)'.k
U"x%yhmS%gfxu%p&'9%%9%'%%-%%_/0Aw&.q2*#'%%[%)%%1%%%%%%%%%&%%E%%+%
U"My%I%j'.%qwxw%hSgf%xup&%'9%/%%%%%I%%/0:ATAj'CA%%%%A%%%%1%%%%%%%
U"%%&%E%%%%(&&%%j)'.gq%ikyS%rfpu%p&'9%%9%'%%-%%D/0APlnO$?['%%B%,%
U"%0%%%%%%%%%&%%E%%.%n&%%%ufh%pnsl%Sqxy%up&'%9%9%%'%-%1%/0AIuD/8%
U"'-%%&*I%%%/%%%%%%%%%%%E%#%%])%%%xf%ruqj%Sksy%up&'%9%9%%'%-%1%/0
U"ACRs6h%n+%%%+6%%%/%%%%%%%%%&%E%I%%11%%%wj%firj.Sy'y%up&'%9%9%%'
U"%-%1%/0A3\lN('66%%%\z%%%1%%%%%%%%%&%E%R%%L7%%%kn%qjns%ktSg%fxup
U"%&'9%%/%%%#%%%/n0AMb-X3A%%%%A%%%%1%%%%%%%%%&%%E%%%*3I%%1j'.g(x%
U"ky%Srfp%up&'%9%9%%'%-%1%/0A,l,&f%L+%%%5C%%%0%%%%%%%%%&%E%#%%%J%
U"%%ks%yxyw%zhSg%nup&%'9%/%%%%%I%%/0OAREY'JA%%%%A%%%%1%%%%%%%%%&%
U"E%%%%u&P%%j)'.ih%mfwS%rfpu%p&'9%%/%%%%%%%_/0AN7DcrA%%%%A%%%%1%%
U"%%%%%%%&%%E%%1%eP%I%j'.%ixyw%lSrf%pup&%'9%/%%%%%I%%/0IALga&jA%%
U"%%A%%%%1%%%%%%%%%&%E[%%%U&P%%j)'.kx%yhmS%rfpu%p&'9%%/%%%%%%%)/0
U"Al*FYsA%%%%A%%%%1%%%%%%%%%&%%E%%.%GQ%I%j'.%kxyx%ySrf%pup&%'9%9%
U"%'%-I%%/0XAi3,&zg+%+%F;%%%1%%%%%%%%%&%E#%%%7&Q%%j2'.&n%iymS%gfx
U"u%p&'9%%9%'%%-%%)/0A6[+Xfk[/%%)%o%%/%%%%%%%%%%%%E%%4%MW%%%xfr%u
U"qjS%ktsu%p&'9%%9%'%%-%%_/0AJDz0KU[%%%g%%%%0%%%%%%%%%&%%E%%4%gb%
U"%%knq(j.ni#Sin)%up&'%9%/%%%%%%1%/0A\Uw4X%A%%%%A%%%%1%%%%%%%%%&%
U"E%I%%lc#%%j').&ni%ymSr%fpup%&'9%%9%'%#-%%/&0A+^<24$;I%%<U%%%1%%
U"%%%%%%%&%%E%%%*\c%%.vg&n%sksy%Sgfx%up&'%9%9%%'%-%1%/0Akt+9m'k&%
U"%&o)%%%1%%%%%%%%%&%E%R%%mz#%%j'&.ixy%wlSg%fxup%&'9%%9%'%#-%%/80
U"Aod(6HM'7%%)*%%%1%%%%%%%%%&%%E%%%+5'%%1j'.k%xyxy%Sgfx%up&'%9%9%
U"%'%-%1%/0A4,03>'$&%%%a)%%%1%%%%%%%%%&%E%d%%1)#%%j'&.qik%sySg%fx
U"up%&'9%%9%'%#-%%/&0A1(&f:W'%%%I*%%%1%%%%%%%%%&%%E%%%,B+%%1j'.g(
U"x%ky%Sgfx%up&'%9%9%%'%-%1%/0AeN=^h%<'%%%e)%%%1%%%%%%%%%&%E%m%%H
U"-#%%j'&.gqi%kySg%fxup%&'9%%9%'%#-%%/n0Aao+pVj-7%%t9%%%1%%%%%%%%
U"%%%%E%%%+50%%%iyhm&.gq