DECLARE SUB TestSchaltJahr (Jahr&, SchaltJahr%)
DECLARE SUB Intro ()
DECLARE SUB Eingabe (Tag%, Monat%, Jahr&)
DECLARE SUB UeberPruefen (Tag%, Monat%, Jahr&, Test%)
DECLARE SUB Berechnung (Tag%, Monat%, Jahr&, WochenTag%)
DECLARE SUB Ausgabe (WochenTag%)

REM Ferien-Programm: ORF Teletext, Computerbox (S. 465), 16. 07. 1998:
REM Das folgende BASIC-Programm von Christian Krupica aus 3143 Pyhra
REM berechnet nach Eingabe eines Datums den zugehrigen Wochentag.
REM Verbesserungen (Strukturierung) von W. Gutenbrunner, Juli 1998.

CLS
SCREEN 8
CALL Intro
Antwort$ = ""
DO UNTIL Antwort$ = "n" OR Antwort$ = "N"
   Test% = 0
   DO WHILE Test% = 0
      CALL Eingabe(Tag%, Monat%, Jahr&)
      CALL UeberPruefen((Tag%), (Monat%), (Jahr&), Test%)
   LOOP
   CALL Berechnung((Tag%), (Monat%), (Jahr&), WochenTag%)
   CALL Ausgabe((WochenTag%))
   LOCATE 23, 40: COLOR 7
   PRINT "Noch einmal (j/n)? "
   Antwort$ = ""
   DO UNTIL Antwort$ = "j" OR Antwort$ = "J" OR Antwort$ = "n" OR Antwort$ = "N"
      Antwort$ = INKEY$
   LOOP
LOOP
CLS
END

SUB Ausgabe (WochenTag%)

   COLOR 11
   LOCATE 1, 13: PRINT "  Es werden die Tage (die Wochen + zustzlichen Tage)"
   LOCATE 2, 13: PRINT " berechnet, die seit Beginn unserer Zeitrechnung ver-"
   LOCATE 3, 13: PRINT " gangen sind. Dabei wird angenommen, dass - wrde man"
   LOCATE 4, 13: PRINT " nach unserem Kalender zurckrechnen - der 1. 1. 0 ein"
   LOCATE 5, 13: PRINT "     Sonntag (und das Jahr 0 kein Schaltjahr) sei."
   COLOR 12: LOCATE 15, 35
   IF WochenTag% = 0 THEN PRINT "Sonntag"
   IF WochenTag% = 1 THEN PRINT "Montag"
   IF WochenTag% = 2 THEN PRINT "Dienstag"
   IF WochenTag% = 3 THEN PRINT "Mittwoch"
   IF WochenTag% = 4 THEN PRINT "Donnerstag"
   IF WochenTag% = 5 THEN PRINT "Freitag"
   IF WochenTag% = 6 OR WochenTag% = -1 THEN PRINT "Samstag"
   FOR Zaehler& = 1 TO 50: SOUND 50 + RND * 2000, .2: NEXT Zaehler&

END SUB

SUB Berechnung (Tag%, Monat%, Jahr&, WochenTag%)

   CALL TestSchaltJahr((Jahr&), SchaltJahr%)
   IF Monat% = 1 THEN LET TageFuerVormonate% = 0
   IF Monat% = 2 THEN LET TageFuerVormonate% = 31
   IF Monat% = 3 THEN LET TageFuerVormonate% = 59
   IF Monat% = 4 THEN LET TageFuerVormonate% = 90
   IF Monat% = 5 THEN LET TageFuerVormonate% = 120
   IF Monat% = 6 THEN LET TageFuerVormonate% = 151
   IF Monat% = 7 THEN LET TageFuerVormonate% = 181
   IF Monat% = 8 THEN LET TageFuerVormonate% = 212
   IF Monat% = 9 THEN LET TageFuerVormonate% = 243
   IF Monat% = 10 THEN LET TageFuerVormonate% = 273
   IF Monat% = 11 THEN LET TageFuerVormonate% = 304
   IF Monat% = 12 THEN LET TageFuerVormonate% = 334
   VorTageImJahr% = Tag% - 1 + TageFuerVormonate%
   TageSeit0& = (365 * Jahr&) + VorTageImJahr% + INT(Jahr& / 4) - INT(Jahr& / 100) + INT(Jahr& / 400)
   IF VorTageImJahr% < 60 THEN
      IF SchaltJahr% = 1 THEN TageSeit0& = TageSeit0& - 1
   END IF
   WochenSeit0! = TageSeit0& / 7
   GanzeWochenSeit0& = INT(WochenSeit0!)
   Differenz! = WochenSeit0! - GanzeWochenSeit0&
   ZusaetzlicheTage% = INT((Differenz! * 7) - .1) + 1
   COLOR 10, 0
   LOCATE 18, 20: PRINT "Seit Beginn unserer Zeitrechnung vergingen"
   LOCATE 19, 20: PRINT "bis vor das angegebene Datum:"; TageSeit0&; "Tage,"
   LOCATE 20, 20: PRINT "das sind:"; GanzeWochenSeit0&; "Wochen und"; ZusaetzlicheTage%; "Tag(e)."
   WochenTag% = ZusaetzlicheTage%

END SUB

SUB Eingabe (Tag%, Monat%, Jahr&)

   CLS : COLOR 14

   Tag% = 0
   DO WHILE (Tag% < 1) OR (Tag% > 31)
      LOCATE 8, 30: PRINT "                "
      LOCATE 8, 30: INPUT "Tag: ", Tag%
      IF Tag% > 31 THEN
         LOCATE 18, 20: PRINT "Mehr als 31 Tage pro Monat gibt es nicht!"
         FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
         LOCATE 18, 20: PRINT "                                         "
      END IF
   LOOP

   Monat% = 0
   DO WHILE (Monat% < 1) OR (Monat% > 12)
      LOCATE 10, 28: PRINT "               "
      LOCATE 10, 28: INPUT "Monat: ", Monat%
      IF Monat% > 12 THEN
         LOCATE 18, 20: PRINT "Es gibt nur 12 Monate!"
         FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
         LOCATE 18, 20: PRINT "                      "
      END IF
   LOOP

   Jahr& = 0
   DO WHILE (Jahr& < 1)
      LOCATE 12, 29: PRINT "                "
      LOCATE 12, 29: INPUT "Jahr: ", Jahr&
      IF Jahr& < 1582 THEN
         LOCATE 18, 20: PRINT "Der gregorianische Kalender wurde"
         LOCATE 19, 20: PRINT "erst im J. d. H. 1582 eingefhrt!"
         FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
         LOCATE 18, 20: PRINT "                                         "
         LOCATE 19, 20: PRINT "                                         "
         Jahr& = 0
      ELSEIF Jahr& > 4000 THEN
         LOCATE 18, 20: PRINT "So weit in die Zukunft?"
         LOCATE 19, 20: PRINT "Ist das noch sinnvoll???"
         FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
         LOCATE 18, 20: PRINT "                                         "
         LOCATE 19, 20: PRINT "                                         "
         Jahr& = 0
      END IF
   LOOP

END SUB

SUB Intro

   RANDOMIZE TIMER
   FOR Zaehler& = 1 TO 1000
      COLOR 15
      LOCATE 10, 22: PRINT "  Dieses Programm errechnet Ihnen"
      LOCATE 12, 22: PRINT "bei beliebiger Eingabe eines Datums"
      LOCATE 14, 22: PRINT "    den dazugehrigen Wochentag!"
      COLOR 13
      LOCATE 17, 29: PRINT "Christian Krupica 1996"
      LOCATE 18, 29: PRINT "W. Gutenbrunner, 07/98"
      COLOR 2
      x% = INT(RND * 620)
      y% = INT(RND * 200)
      PSET (x%, y%)
   NEXT Zaehler&

END SUB

SUB TestSchaltJahr (Jahr&, SchaltJahr%)

   SchaltJahr% = 0
   IF Jahr& / 4 = INT(Jahr& / 4) THEN SchaltJahr% = 1
   IF Jahr& / 100 = INT(Jahr& / 100) THEN SchaltJahr% = 0
   IF Jahr& / 400 = INT(Jahr& / 400) THEN SchaltJahr% = 1
   IF Jahr& = 0 THEN SchaltJahr% = 0

END SUB

SUB UeberPruefen (Tag%, Monat%, Jahr&, Test%)

   CALL TestSchaltJahr((Jahr&), SchaltJahr%)
   IF SchaltJahr% = 1 THEN LOCATE 12, 45: PRINT "(Schaltjahr)"
   IF SchaltJahr% = 0 THEN LOCATE 12, 45: PRINT "(Kein Schaltjahr)"
   IF Tag% > 30 AND (Monat% = 4 OR Monat% = 6 OR Monat% = 9 OR Monat% = 10) THEN
      LOCATE 18, 20: PRINT "Dieser Monat hat nur 30 Tage!"
      FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
      Test% = 0
   ELSEIF Tag% > 29 AND Monat% = 2 THEN
      LOCATE 18, 20: PRINT "Der Februar hat maximal 29 Tage!"
      FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
      Test% = 0
   ELSEIF Tag% = 29 AND Monat% = 2 AND SchaltJahr% = 0 THEN
      LOCATE 18, 20: PRINT "Dieses Jahr ist kein Schaltjahr!"
      FOR Zaehler& = 1 TO 1000000: NEXT Zaehler&
      Test% = 0
   ELSE Test% = 1
   END IF

END SUB

