'************************************************
'***   Interface-Treiberprogramm fr QBasic   ***
'***   Version 2.0 - 07.08.92 HHG             ***
'***   (c) 1992 Cornelsen Experimenta         ***
'************************************************

DECLARE FUNCTION Eingang% (eNummer%)
DECLARE FUNCTION Ex% ()
DECLARE FUNCTION Ey% ()
DECLARE SUB Init ()
DECLARE SUB motor (Nummer%, Richtung%)

DEF SEG : BLOAD "TREIBER.BIN", &HFF00
DEFINT A, E, L, R
DIM SHARED e1, e2, e3, e4, e5, e6, e7, e8
DIM SHARED aus, links, rechts, ein
e1 = 1: e2 = 2: e3 = 4: e4 = 8
e5 = 16: e6 = 32: e7 = 64: e8 = 128
aus = 0: links = 1: rechts = 2: ein = rechts
CALL Init

'************************************************
'***   Beginn des Benutzerprogramms           ***
'************************************************
REM Do...Loop hat keinen automatischen Zhler, dashalb muss in dieser
REM Schleife eine Abbruchbedingung eingebaut werden.
REM Schlsselwrter zum Verlassen der Schleife:
REM 1) WHILE <Bedingung>; innerhalb einer Schleife werden die angege-
REM                       benen Befehle solange wiederholt, bis eine
REM 2) UNTIL <Bedingung>; Bedingung erfllt (UNTIL) oder nicht mehr er-
REM                       erfllt ist (WHILE).
REM 3) EXIT DO ist eine weitere Mglichkeit(unabhngig von einer Bedingung).
REM ****PROGRAMM****
CLS
DO WHILE Zahl < 10000: REM Solange die Bedingung wahr ist, werden die
   Zahl = Zahl + 1: REM Befehle ausgefhrt.
   CALL motor(1, links)
LOOP
CALL motor(1, aus)
PRINT "Der Motor lief links"
PRINT : PRINT : PRINT
SLEEP 2
DO UNTIL Nummer = 10000
   Nummer = Nummer + 1: REM Achtung, bei der 2. Schleife neuer Variablename
   CALL motor(1, rechts)
LOOP
CALL motor(1, aus)
PRINT "Der Motor lief rechts"

FUNCTION Eingang (eNummer%)
  CALL absolute(axx, &HFF00 + 43)
  IF (axx AND eNummer%) = 0 THEN Eingang = 0 ELSE Eingang = 1
END FUNCTION

FUNCTION Ex
  aax = &HA0
  CALL absolute(aax, &HFF00 + 128)
  Ex = aax
END FUNCTION

FUNCTION Ey
  aay = &H90
  CALL absolute(aay, &HFF00 + 128)
  Ey = aay
END FUNCTION

DEFSNG A, E, L, R
SUB Init
  CALL absolute(0, &HFF00)
END SUB

SUB motor (Nummer%, Richtung%)
  SHARED mflag%
  SELECT CASE Nummer%
    CASE 1
      motf% = &H3
    CASE 2
      motf% = &HC
    CASE 3
      motf% = &H30
    CASE 4
      motf% = &HC0
  END SELECT
  SELECT CASE Richtung%
    CASE 0              ' aus
      richt% = &H0
    CASE 1              ' links
      richt% = &H55
    CASE 2              ' rechts, ein
      richt% = &HAA
  END SELECT
  mflag% = (mflag% AND (NOT motf%)) OR (motf% AND richt%)
  CALL absolute(mflag%, &HFF00)
END SUB

