'************************************************
'***   Interface-Treiberprogramm fr QBasic   ***
'***   Version 2.0 - 07.08.92 HHG             ***
'***   (c) 1992 Cornelsen Experimenta         ***
'************************************************

DECLARE FUNCTION Eingang% (eNummer%)
DECLARE FUNCTION Ex% ()
DECLARE FUNCTION Ey% ()
DECLARE SUB Init ()
DECLARE SUB Motor (Nummer%, Richtung%)

DEF SEG : BLOAD "TREIBER.BIN", &HFF00
DEFINT A, E, L, R
DIM SHARED E1, E2, e3, e4, e5, e6, e7, e8
DIM SHARED aus, links, rechts, ein
E1 = 1: E2 = 2: e3 = 4: e4 = 8
e5 = 16: e6 = 32: e7 = 64: e8 = 128
aus = 0: links = 1: rechts = 2: ein = rechts
CALL Init

'************************************************
'***   Beginn des Benutzerprogramms           ***
'************************************************
REM ***Der Motor dreht sich solange, bis Schalter 1 gedrckt wird***
REM ***Am Schalter wurde 1 und 2 belegt(0=Schalter gedrckt)
50 :
    IF Eingang%(E1) = 0 AND Eingang%(E2) = 0 THEN 100
    CALL Motor(1, links)
    GOTO 50
100 CALL Motor(1, aus)
GOTO 50

FUNCTION Eingang (eNummer%)
  CALL absolute(axx, &HFF00 + 43)
  IF (axx AND eNummer%) = 0 THEN Eingang = 0 ELSE Eingang = 1
END FUNCTION

FUNCTION Ex
  aax = &HA0
  CALL absolute(aax, &HFF00 + 128)
  Ex = aax
END FUNCTION

FUNCTION Ey
  aay = &H90
  CALL absolute(aay, &HFF00 + 128)
  Ey = aay
END FUNCTION

DEFSNG A, E, L, R
SUB Init
  CALL absolute(0, &HFF00)
END SUB

SUB Motor (Nummer%, Richtung%)
  SHARED mflag%
  SELECT CASE Nummer%
    CASE 1
      motf% = &H3
    CASE 2
      motf% = &HC
    CASE 3
      motf% = &H30
    CASE 4
      motf% = &HC0
  END SELECT
  SELECT CASE Richtung%
    CASE 0              ' aus
      richt% = &H0
    CASE 1              ' links
      richt% = &H55
    CASE 2              ' rechts, ein
      richt% = &HAA
  END SELECT
  mflag% = (mflag% AND (NOT motf%)) OR (motf% AND richt%)
  CALL absolute(mflag%, &HFF00)
END SUB

