'************************************************
'***   Interface-Treiberprogramm fr QBasic   ***
'***   Version 2.0 - 07.08.92 HHG             ***
'***   (c) 1992 Cornelsen Experimenta         ***
'************************************************

DECLARE FUNCTION Eingang% (eNummer%)
DECLARE FUNCTION Ex% ()
DECLARE FUNCTION Ey% ()
DECLARE SUB Init ()
DECLARE SUB Motor (Nummer%, Richtung%)

DECLARE SUB Bildaufbau (Titel$)
DECLARE SUB Eingangsanzeige ()
DECLARE SUB Ausgangsanzeige ()

DEF SEG : BLOAD "TREIBER.BIN", &HFF00
DEFINT A, E, L, R
DIM SHARED e1, e2, e3, e4, e5, e6, e7, e8
DIM SHARED aus, links, rechts, ein
e1 = 1: e2 = 2: e3 = 4: e4 = 8
e5 = 16: e6 = 32: e7 = 64: e8 = 128
aus = 0: links = 1: rechts = 2: ein = rechts
CALL Init

'************************************************
'***   Beginn des Benutzerprogramms           ***
'************************************************

'************************************************
'***   DIAGNOSEPROGRAMM - 07.08.92 HHG        ***
'************************************************

DIM SHARED MotorStatus%(1 TO 4)
DIM SHARED AktuellerMotor

Bildaufbau ("D I A G N O S E")
FOR i% = 1 TO 4
  MotorStatus%(i%) = aus
NEXT i%
AktuellerMotor = 1

DO
  Eingangsanzeige
  Ausgangsanzeige

  CALL Motor(AktuellerMotor, MotorStatus%(AktuellerMotor))
  c$ = UCASE$(INKEY$)
  SELECT CASE c$
    CASE "1"
      AktuellerMotor = 1
    CASE "2"
      AktuellerMotor = 2
    CASE "3"
      AktuellerMotor = 3
    CASE "4"
      AktuellerMotor = 4
    CASE "L"
      MotorStatus%(AktuellerMotor) = links
    CASE "R"
      MotorStatus%(AktuellerMotor) = rechts
    CASE "A"
      MotorStatus%(AktuellerMotor) = aus
    CASE "S"
      FOR i% = 1 TO 4
        MotorStatus%(i%) = aus
        CALL Motor(i%, aus)
      NEXT i%
  END SELECT
LOOP UNTIL c$ = CHR$(27)

FOR i% = 1 TO 4
  CALL Motor(i%, aus)
NEXT i%
COLOR 7, 0
CLS
END



SUB Ausgangsanzeige
    LOCATE 24, 5
    FOR i% = 1 TO 4
      IF i% = AktuellerMotor THEN COLOR 15, 4
      PRINT " ";
      SELECT CASE MotorStatus%(i%)
        CASE links
          PRINT " links  ";
        CASE rechts
          PRINT "rechts  ";
        CASE aus
          PRINT "  aus   ";
      END SELECT
      COLOR 15, 0
    NEXT i%
END SUB

SUB Bildaufbau (Titel$)
    COLOR 0, 7: CLS
    LOCATE 1, 5: PRINT STRING$(72, 196)
    COLOR 15, 4
    LOCATE 2, 1: PRINT SPACE$(65); "Cornelsen      "
    LOCATE 3, 1: PRINT SPACE$(65); "Experimenta    "
    COLOR 4, 7
    LOCATE 5, 5: PRINT "fischer";
    COLOR 1, 7: PRINT "technik";
    COLOR 0, 7: PRINT " Schulprogramm"
    LOCATE 6, 5: PRINT STRING$(72, 196)
    LOCATE 7, 5: PRINT Titel$
    PRINT
    PRINT
    PRINT "    Motorauswahl:  <1> <2> <3> <4>"
    PRINT
    PRINT "    Gewhlter Motor Links:     <L>"
    PRINT "    Gewhlter Motor Rechts:    <R>"
    PRINT "    Gewhlter Motor Aus:       <A>"
    PRINT "    Smtliche Motoren Aus:     <S>"
    PRINT
    PRINT "    Programm beenden:        <Esc>"
    LOCATE 20, 1
    PRINT "    E1 E2 E3 E4 E5 E6 E7 E8    EX   EY"
    LOCATE 23, 1
    PRINT "     Motor1   Motor2   Motor3   Motor4"
END SUB

FUNCTION Eingang (eNummer%)
  CALL absolute(axx, &HFF00 + 43)
  IF (axx AND eNummer%) = 0 THEN Eingang = 0 ELSE Eingang = 1
END FUNCTION

SUB Eingangsanzeige
    COLOR 15, 0
    LOCATE 21, 5
    PRINT Eingang(e1); Eingang(e2); Eingang(e3); Eingang(e4); Eingang(e5); Eingang(e6); Eingang(e7); Eingang(e8);
    PRINT USING "#####"; Ex; Ey
END SUB

FUNCTION Ex
  aax = &HA0
  CALL absolute(aax, &HFF00 + 128)
  Ex = aax
END FUNCTION

FUNCTION Ey
  aay = &H90
  CALL absolute(aay, &HFF00 + 128)
  Ey = aay
END FUNCTION

DEFSNG A, E, L, R
SUB Init
  CALL absolute(0, &HFF00)
END SUB

SUB Motor (Nummer%, Richtung%)
  SHARED mflag%
  SELECT CASE Nummer%
    CASE 1
      motf% = &H3
    CASE 2
      motf% = &HC
    CASE 3
      motf% = &H30
    CASE 4
      motf% = &HC0
  END SELECT
  SELECT CASE Richtung%
    CASE 0              ' aus
      richt% = &H0
    CASE 1              ' links
      richt% = &H55
    CASE 2              ' rechts, ein
      richt% = &HAA
  END SELECT
  mflag% = (mflag% AND (NOT motf%)) OR (motf% AND richt%)
  CALL absolute(mflag%, &HFF00)
END SUB

