'************************************************
'***   Interface-Treiberprogramm fr QBasic   ***
'***   Version 2.0 - 07.08.92 HHG             ***
'***   (c) 1992 Cornelsen Experimenta         ***
'************************************************

DECLARE FUNCTION Eingang% (eNummer%)
DECLARE FUNCTION Ex% ()
DECLARE FUNCTION Ey% ()
DECLARE SUB Init ()
DECLARE SUB Motor (Nummer%, Richtung%)

DEF SEG : BLOAD "TREIBER.BIN", &HFF00
DEFINT A, E, L, R
DIM SHARED e1, e2, e3, E4, e5, e6, E7, E8
DIM SHARED AUS, LINKS, RECHTS, EIN
e1 = 1: e2 = 2: e3 = 4: E4 = 8
e5 = 16: e6 = 32: E7 = 64: E8 = 128
AUS = 0: LINKS = 1: RECHTS = 2: EIN = RECHTS
CALL Init

'************************************************
'***   Beginn des Benutzerprogramms           ***
'************************************************

600 CLS
610 REM *************************
620 REM *                       *
630 REM *                       *
640 REM *                       *
650 REM *    ZUSTELL-SCHRANKE   *
660 REM *        (D)           *
670 REM *                       *
680 REM *                       *
690 REM *************************
700 :
710 REM *********************
720 REM * Bildschirmanzeige *
730 REM *********************
740 :
745 CLS
750 LOCATE 3
760 PRINT TAB(11); "******************************"
770 PRINT TAB(11); "*                            *"
780 PRINT TAB(11); "*     ZUSTELLSCHRANKE        *"
790 PRINT TAB(11); "*                            *"
800 PRINT TAB(11); "******************************"
    PRINT : PRINT : PRINT
    PRINT TAB(11); " Zustellschranke bereit? (j)";
805 J$ = INKEY$
    IF J$ <> "j" AND J$ <> "J" THEN GOTO 805
    PRINT : PRINT
    PRINT TAB(12); "Eingangstaster drcken"
    LOCATE 24, 11
    PRINT " Abbruch mit Strg + Pause";
810 :
820 REM *************************
830 REM *  ABFRAGEBELEGUNG      *
840 REM *************************
850 :
860 REM E4 = Schranke offen
870 REM E7 = Schranke geschlossen
880 REM E8 = Befehl zum ffnen
890 REM Ex = Fotowiderstand
900 REM M1 = Motor
910 REM M2 = Lampe
912 REM M3 = Ampel grn
914 REM M4 = Ampel rot
920 :
930 REM *************************
940 REM *  Schranke schlieen   *
950 REM *************************
960 :
970 CALL Motor(2, AUS)
972 CALL Motor(3, AUS)
974 CALL Motor(4, EIN)
980 IF Eingang%(E7) = 0 THEN 1010
990 CALL Motor(1, RECHTS)
1000 GOTO 980
1010 CALL Motor(1, AUS)
1020 :
1030 REM ******************************
1040 REM * Schranke auf Befehl ffnen *
1050 REM ******************************
1060 :
1070 LOCATE 10, 5
1080 PRINT " TASTE << EINFAHRT >> bettigen "
1090 IF Eingang%(E8) <> 1 THEN 1090
1100 CALL Motor(2, EIN)
1110 IF Eingang%(E4) = 0 THEN 1160
1120 CALL Motor(1, LINKS)
1130 GOTO 1110
1140 :
1150 REM ********************************
1160 REM * Abfrage des Fotowiderstandes *
1170 REM ********************************
1180 :
1190 CALL Motor(1, AUS)
1192 CALL Motor(4, AUS)
1194 CALL Motor(3, EIN)
1200 LOCATE 10, 5
1210 PRINT " << LICHTSCHRANKE >> unterbrechen "
1220 FW = Ex%: REM EX-Wert in FW ablegen
1230 IF Ex% - 15 > FW THEN 740
1240 GOTO 1230
1250 END

FUNCTION Eingang (eNummer%)
  CALL absolute(axx, &HFF00 + 43)
  IF (axx AND eNummer%) = 0 THEN Eingang = 0 ELSE Eingang = 1
END FUNCTION

FUNCTION Ex
  aax = &HA0
  CALL absolute(aax, &HFF00 + 128)
  Ex = aax
END FUNCTION

FUNCTION Ey
  aay = &H90
  CALL absolute(aay, &HFF00 + 128)
  Ey = aay
END FUNCTION

DEFSNG A, E, L, R
SUB Init
  CALL absolute(0, &HFF00)
END SUB

SUB Motor (Nummer%, Richtung%)
  SHARED mflag%
  SELECT CASE Nummer%
    CASE 1
      motf% = &H3
    CASE 2
      motf% = &HC
    CASE 3
      motf% = &H30
    CASE 4
      motf% = &HC0
  END SELECT
  SELECT CASE Richtung%
    CASE 0              ' aus
      richt% = &H0
    CASE 1              ' links
      richt% = &H55
    CASE 2              ' rechts, ein
      richt% = &HAA
  END SELECT
  mflag% = (mflag% AND (NOT motf%)) OR (motf% AND richt%)
  CALL absolute(mflag%, &HFF00)
END SUB

