'************************************************
'***   Interface-Treiberprogramm fr QBasic   ***
'***   Version 2.0 - 07.08.92 HHG             ***
'***   (c) 1992 Cornelsen Experimenta         ***
'************************************************
DECLARE SUB Einfahrt ()
DECLARE SUB Schluss ()
DECLARE FUNCTION Eingang% (eNummer%)
DECLARE FUNCTION Ex% ()
DECLARE FUNCTION Ey% ()
DECLARE SUB Init ()
DECLARE SUB motor (Nummer%, Richtung%)

DEF SEG : BLOAD "TREIBER.BIN", &HFF00
DEFINT A, E, L, R
DIM SHARED e1, e2, e3, E4, e5, e6, E7, E8
DIM SHARED AUS, LINKS, RECHTS, EIN
e1 = 1: e2 = 2: e3 = 4: E4 = 8
e5 = 16: e6 = 32: E7 = 64: E8 = 128
AUS = 0: LINKS = 1: RECHTS = 2: EIN = RECHTS
CALL Init
'************************************************
'***   Beginn des Benutzerprogramms           ***
'************************************************
s = 7: h = 0
COLOR h, s
REM *************************
REM *                       *
REM *                       *
REM *                       *
REM *    ZUSTELL-SCHRANKE   *
REM *        (D)           *
REM *                       *
REM *                       *
REM *************************
REM
REM***Hauptprogramm: eine Menauswahl
DO
 CLS
 COLOR s, h
 LOCATE 5, 15: PRINT "******************************"
 LOCATE 6, 15: PRINT "*                            *"
 LOCATE 7, 15: PRINT "*     ZUSTELLSCHRANKE        *"
 LOCATE 8, 15: PRINT "*      (Rolf Dren)          *"
 LOCATE 9, 15: PRINT "******************************"
 COLOR h, s
 LOCATE 12, 15
 COLOR 4, s: PRINT "AUSWAHLMEN"
 LOCATE 13, 15
 COLOR 4, s: PRINT "==========="
 PRINT
 LOCATE 14, 15
 COLOR 2, s: PRINT "Buchstabe E fr Einfahrt"
 PRINT
 LOCATE 16, 15
 COLOR 1, s: PRINT "Buchstabe S fr Ende"
 PRINT
 LOCATE 18, 15
 COLOR 14, s: INPUT "Geben Sie einen Buchstaben ein (mit RETURN besttigen): ", Taste$
 PRINT
 REM*** Verzweigungsbedingungen zu den einzelnen Prozeduren:
        SELECT CASE UCASE$(Taste$)
                CASE "E"
                        CALL Einfahrt
                CASE "S"
                        CALL Schluss
        END SELECT
LOOP
END
REM Ende des Hauptprogramms

SUB Einfahrt
s = 7: h = 0
     COLOR h, s: CLS
     REM *************************
     REM *  ABFRAGEBELEGUNG      *
     REM *************************
     REM E4 = Schranke offen
     REM E7 = Schranke geschlossen
     REM E8 = Befehl zum ffnen
     REM Ex = Fotowiderstand
     REM M1 = Motor
     REM M2 = Lampe
     REM M3 = Ampel grn
     REM M4 = Ampel rot
     REM ******************************
     REM * Schranke auf Befehl ffnen *
     REM ******************************
     LOCATE 12, 25
     COLOR 4, s: PRINT " Zustellschranke bereit? (j)";
100  J$ = INKEY$
     IF J$ <> "j" AND J$ <> "J" THEN GOTO 100
     CALL motor(4, EIN)
     REM **** Erst Schranke schlieen ****
150  IF Eingang%(E7) = 0 THEN 160
     CALL motor(1, RECHTS)
     GOTO 150
160  CALL motor(1, AUS)
     REM **** Schranke ffnen ****
     LOCATE 14, 25
     COLOR 1, s: PRINT " TASTE << EINFAHRT >> bettigen "
200  IF Eingang%(E8) <> 1 THEN 200
     CALL motor(2, EIN)
300  IF Eingang%(E4) = 0 THEN 350
     CALL motor(1, LINKS)
     GOTO 300
     REM     ********************************
350  REM     * Abfrage des Fotowiderstandes *
     REM     ********************************
     CALL motor(1, AUS)
     CALL motor(4, AUS)
     CALL motor(3, EIN)
     LOCATE 16, 25
     COLOR s, h: PRINT " << LICHTSCHRANKE >> unterbrechen "
400  FW = Ex%: REM EX-Wert in FW ablegen
     IF Ex% - 500 > FW THEN 450: REM je nach Lichtverhltnisse, muss
     GOTO 400: REM der WERT (-500) angepat werden.
     REM    *************************
450  REM    *  Schranke schlieen   *
     REM    *************************
     CALL motor(2, AUS)
     CALL motor(3, AUS)
     CALL motor(4, EIN)
500  IF Eingang%(E7) = 0 THEN 550
     CALL motor(1, RECHTS)
     GOTO 500
550  CALL motor(1, AUS)
COLOR h, s
END SUB

FUNCTION Eingang (eNummer%)
  CALL absolute(axx, &HFF00 + 43)
  IF (axx AND eNummer%) = 0 THEN Eingang = 0 ELSE Eingang = 1
END FUNCTION

FUNCTION Ex
  aax = &HA0
  CALL absolute(aax, &HFF00 + 128)
  Ex = aax
END FUNCTION

FUNCTION Ey
  aay = &H90
  CALL absolute(aay, &HFF00 + 128)
  Ey = aay
END FUNCTION

DEFSNG A, E, L, R
SUB Init
  CALL absolute(0, &HFF00)
END SUB

SUB motor (Nummer%, Richtung%)
  SHARED mflag%
  SELECT CASE Nummer%
    CASE 1
      motf% = &H3
    CASE 2
      motf% = &HC
    CASE 3
      motf% = &H30
    CASE 4
      motf% = &HC0
  END SELECT
  SELECT CASE Richtung%
    CASE 0              ' aus
      richt% = &H0
    CASE 1              ' links
      richt% = &H55
    CASE 2              ' rechts, ein
      richt% = &HAA
  END SELECT
  mflag% = (mflag% AND (NOT motf%)) OR (motf% AND richt%)
  CALL absolute(mflag%, &HFF00)
END SUB

DEFINT A, E, L, R
SUB Schluss
   CLS
   LOCATE 10, 15
   PRINT "Das Programm ist beendet. - Drcken Sie eine Taste."
   SLEEP
   END
END SUB

