'
' Sprites In QBasic, and how to mask them.
'
'   By: TF Software
'
'     Email: tf_software@geocities.com
'
'       Web site:
'         http://members.aol.com/TFSoft/
'
'    Sprites are graphical images. Masking is a technique that will
' preserve the background when you place a sprite on the screen.
'
'    To start out let me say that a sprite is an array. You DIM the array
' just like you would any other array. Finding the neccessary size of the
' array is the tricky part. The size of a graphics array is NOT the same
' in any screen mode. Also a sprite you GET in one screen mode may not be
' compatible with another screen mode.
'
'    A sprite is rectangle in shape. To create a sprite you can draw an
' image on the screen and extract it using GET. What GET does is copies
' a rectangle section of the screen into an array. It is then saved into
' that array and can be placed back on the screen as many times as you want.
' It is kind of like copying and pasting. For example: In MS Paint you can
' use the copy tool to copy a rectangle section of the screen and then paste
' it back on the screen a number of times.
'
'    Before you GET an array from off the screen you must frist set its
' dimensions using the DIM statement. A sprites size is NOT just the amount
' of pixels in the array. There is a formula used to find the exact size of
' an array. Things are explained in more detail in the program below:
'
'
RANDOMIZE TIMER        'Sets random seed.
SCREEN 7, 0, 1, 0: CLS   'To learn about screen pages and PCOPY see
                         'my page flipping program which is available
                         'at my web site.

  '-----Make Background-----
  BgC% = 1                      'This creates the background.
  FOR BgX% = 0 TO 319 STEP 80   'It is on screen page 1.
   BgC% = BgC% + 1
   LINE (BgX%, 0)-(BgX% + 79, 199), BgC%, BF
  NEXT
  '-----End Make Background-----

SCREEN 7, 0, 2, 0: CLS

 '-----Make Sprite-----
 FOR RP% = 1 TO 80      'This makes 80 random pixels which we will
  Rx% = INT(RND * 20)   'use as our sprite.
  Ry% = INT(RND * 20)
  PSET (Rx%, Ry%), 1
 NEXT
 '-----End Make Sprite-----
  '-----Make Mask-----
  FOR Sx% = 0 TO 19           '   What this does is creates a mask for our
   FOR Sy% = 0 TO 19          'sprite. What it does is scans the area where
    Sc% = POINT(Sx%, Sy%)     'we put our pixels. When it scans it, if
    IF Sc% = 0 THEN           'there is no pixel it will draw a pixel where
    PSET (Sx%, Sy% + 100), 15 'our mask will be. If there is a pixel it wont
    END IF                    'draw a pixel where our mask will be.
   NEXT                       '   Basicly it just draws a pixel in every
  NEXT                        'spot we want the background to show through.
  '-----End Make Mask-----

'-----Display some info-----
 LOCATE 1, 6
 PRINT "<- Here is our sprite."
 LOCATE 2, 8
 PRINT "The background will show through"
 LOCATE 3, 8
 PRINT "the black area."

 LOCATE 14, 6
 PRINT "<- Here is our mask."
 LOCATE 15, 8
 PRINT "We must make this to have the"
 LOCATE 16, 8
 PRINT "background show through. Every"
 LOCATE 17, 8
 PRINT "white pixel is where it shows"
 LOCATE 18, 8
 PRINT "through."
PCOPY 2, 0
DO: LOOP UNTIL INKEY$ <> ""
'-----End Display some info-----

'  Now lets get to the part of creating the array for the sprite. There is
' a formula to find the size of the array. Here it is:

'4 + INT(((x2 - x1 + 1) * (bits-per-pixel-per-plane) + 7)/8)* planes * ((y2 - y1) + 1)

'  To find the Bits-Per-Pixel and the number of Planes, please look in
' your QBasic section. I have QBasic 4.5 and it is in the details of
' the GET (Graphics) part.
'
'
'  Our sprite is from (0, 0)-(19, 19). Here is how we would find its size:

SpriteSize% = 4 + INT(((19 - 0 + 1) * (1) + 7) / 8) * 4 * ((19 - 0) + 1)

'  Since our sprite is LONG we then divide the Size by 4. If it was integer
' we would divide it by 2. This information is also in the help section.

SpriteSize% = SpriteSize% / 4

'  We are going to hold the sprite and its mask in one array so we need
' to multiply the size by 2. Also we are going to have the array start
' at element 0 of the array instead of 1. Therefore we must subtract the
' the size by 1.

TotalSize% = (SpriteSize% * 2) - 1

'  Now we have the size so lets DIM it:

DIM Sprite(TotalSize%) AS LONG

'  Now that our sprite is DIMmed lets GET it.

'Our sprite is from (0, 0)-(19, 19)
'Incase you don't know that is: (X1, Y1)-(X2, Y2)
GET (0, 0)-(19, 19), Sprite(0)  'As I said before this sprite starts at
                                'element 0 of the array.
'The size of the sprite takes up (SpriteSize - 1). This means we
'can still fit the mask in the array. So it will start at SpriteSize
'in the array.

'Our mask is from (0, 100)-(19, 119)
GET (0, 100)-(19, 119), Sprite(SpriteSize%) 'The mask will start at
                                            'the SpriteSize in the array.

CONST SpritePict% = 0      'The location of the sprite in the array.
CONST SpriteMask% = 61     'The location of the mask in the array.
CONST SpriteWidth% = 20    'Width
CONST SpriteHeight% = 20   'Height


SpriteX% = 160      'Sets the X location
SpriteY% = 100      'Sets the Y location
SpriteAddX% = 1     'Amount added to X each frame.
SpriteAddY% = 1     'Amount added to Y each frame.

DO
 PCOPY 1, 2
 
  '-----Move Sprite-----
  SpriteX% = SpriteX% + SpriteAddX%
  SpriteY% = SpriteY% + SpriteAddY%
  '-----End Move Sprite-----

   '-----Make sprite bounce off wall-----
   IF SpriteX% < 0 THEN SpriteX% = 0: SpriteAddX% = -SpriteAddX%
   IF SpriteY% < 0 THEN SpriteY% = 0: SpriteAddY% = -SpriteAddY%
   IF SpriteX% > 319 - SpriteWidth THEN SpriteX% = 319 - SpriteWidth: SpriteAddX% = -SpriteAddX%
   IF SpriteY% > 199 - SpriteHeight THEN SpriteY% = 199 - SpriteHeight: SpriteAddY% = -SpriteAddY%
   '-----End Make sprite bounce off wall-----
  
   'Now then, to actually mask the image we must do two PUTs.
   'We must first PUT the mask using the AND actionverb.
   'Then we will PUT the sprite over the mask using the XOR action verb.
   
    PUT (SpriteX%, SpriteY%), Sprite(SpriteMask), AND
    PUT (SpriteX%, SpriteY%), Sprite(SpritePict), XOR

 PCOPY 2, 0
LOOP UNTIL INKEY$ <> ""
END

